# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.39"  # Technical changes for Calibre 3.0.0 compatibility.

from calibre.constants import DEBUG, iswindows
from calibre.db.legacy import LibraryDatabase
from calibre.utils.config import prefs

#-----------------------------------------------------------------------------------------
def zmi_cli_add_custom_column(guidb,param, dbpath):

    #~ param = label + '|||' + name + '|||' +  datatype

    is_multiple = False

    #~ if DEBUG: print("param:", param)

    param = param.strip()
    args = param.split("|||")
    args_list = []
    for row in args:
        s = row.strip()
        if s > " ":
            s = s.replace('"','')
            args_list.append(s)
            if DEBUG: print("arg: ", str(s))
    #END FOR

    label = args_list[0]
    name = args_list[1]
    datatype = args_list[2]

    display  = {}

    db = LibraryDatabase(dbpath)

    db.create_custom_column(label, name, datatype, is_multiple, display=display)

    if DEBUG: print("ZMI Custom Column created:  ", label, "  ", name, "  ", datatype)

    # Re-open the DB so that  field_metadata is reflects the column changes
    guidb.prefs['field_metadata'] = db.field_metadata.all_metadata()

    send_rc_message('')

#-----------------------------------------------------------------------------------------
def send_rc_message(msg):

    from calibre.utils.ipc import RC
    t = RC(print_error=False)
    t.start()
    t.join(3)
    if t.done:
        t.conn.send('refreshdb:'+msg)
        t.conn.close()

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
#END of lc_cli.py
