# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015, DaltonST <DaltonShiTzu@outlook.com>'

__my_version__ = "3.6.83"

from PyQt5.Qt import (Qt, QDialog, QLabel, QLineEdit, QVBoxLayout, QHBoxLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem, QCheckBox, QDoubleSpinBox,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut)


class WorkSeriesIndexChangeDialog(QDialog):

    def __init__(self, gui,icon,guidb,execute_work_series_index_change):


        QDialog.__init__(self, gui)
        self.gui = gui

        self.guidb = guidb

        self.execute_work_series_index_change = execute_work_series_index_change

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(11)

        self.layout.addSpacing(2)

        self.text_heading = QLabel()
        self.text_heading.setTextFormat(1)
        self.text_heading.setText("<center><font color='#0404B4'>Change a Specific Work Series Index [Single Book]</font></center>")
        self.text_heading.setFont(font)
        self.layout.addWidget(self.text_heading)

        self.setWindowTitle('Quarantine And Scrub                                                                                                                          ')
        self.setWindowIcon(icon)

        font.setBold(True)
        font.setPointSize(8)

        self.layout.addSpacing(6)

        self.label2 = QLabel()
        self.label2.setTextFormat(1)
        self.label2.setText("<br><center><font color='#0404B4'>New Work Series Index</font></center>")
        self.label2.setFont(font)
        self.layout.addWidget(self.label2)

        self.max_tags_spin = QDoubleSpinBox(self)
        self.max_tags_spin.setDecimals(1)
        self.max_tags_spin.setMinimum(000)
        self.max_tags_spin.setMaximum(101)
        self.max_tags_spin.setSingleStep(0.5)
        self.max_tags_spin.setProperty('value',1.0)
        self.layout.addWidget(self.max_tags_spin)

        self.label2.setBuddy(self.max_tags_spin)

        self.layout.addSpacing(10)

        self.push_button1 = QPushButton(" ", self)
        self.push_button1.setText("Execute: Change a Work Series Index [Single Book]")
        self.push_button1.clicked.connect(self.__do_push_button1)
        self.push_button1.setFont(font)
        self.layout.addWidget(self.push_button1)

        self.layout.addSpacing(10)

        font.setBold(True)
        font.setPointSize(8)

        button_box = QDialogButtonBox(QDialogButtonBox.Cancel)
        button_box.rejected.connect(self.reject)
        self.layout.addWidget(button_box)

        self.resize(self.sizeHint())


    def __do_push_button1(self):
        work_series_index = float(unicode(self.max_tags_spin.value()))
        self.execute_work_series_index_change(self.guidb,work_series_index)



#END of workseriesindexchangedialog.py