# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014, DaltonST <DaltonShiTzu@outlook.com>'
__docformat__ = 'restructuredtext en'

__my_version__ = "3.3.4"

from PyQt5.Qt import (Qt, QDialog, QLabel, QVBoxLayout, QHBoxLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut)


class MiscellanyDialog(QDialog):

    def __init__(self, gui,icon, _start_miscellaneous_events,
                                                                            autopopulate_tags_by_comment,
                                                                            delete_all_identifiers_except_isbn,
                                                                            reset_last_modified_date,
                                                                            default_work_tags_by_author,
                                                                            reset_default_work_tag_by_author,
                                                                            _tagruleseditor_dialog,
                                                                            _actually_insert_tag_rules_rows,
                                                                            _tagruleseditor_2_dialog,
                                                                            _actually_insert_tag_rules_rows_2 ):

        QDialog.__init__(self, gui)
        self.gui = gui


        self._start_miscellaneous_events = _start_miscellaneous_events                            #connects ui.py to here for this function
        self.delete_all_identifiers_except_isbn = delete_all_identifiers_except_isbn            #connects ui.py to here for this function
        self.reset_last_modified_date = reset_last_modified_date                                      #connects ui.py to here for this function
        self.default_work_tags_by_author = default_work_tags_by_author                        #connects ui.py to here for this function
        self.reset_default_work_tag_by_author = reset_default_work_tag_by_author        #connects ui.py to here for this function
        self.autopopulate_tags_by_comment = autopopulate_tags_by_comment            #connects ui.py to here for this function

        self.db = gui.current_db

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(11)

        self.layout.addSpacing(2)

        self.text_heading = QLabel()
        self.text_heading.setTextFormat(1)
        self.text_heading.setText("<center><font color='#0404B4'>Q&S Tools [Various] </font></center>")
        self.text_heading.setFont(font)
        self.layout.addWidget(self.text_heading)
        self.layout.addSpacing(30)


        self.setWindowTitle('Quarantine And Scrub: Miscellaneous Scrubbing')
        self.setWindowIcon(icon)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button1 = QPushButton(" ", self)
        self.push_button1.setText("Propagate Tags from/to Books With The Identical Series")
        self.push_button1.clicked.connect(self.__do_push_button1)
        self.push_button1.setFont(font)
        self.layout.addWidget(self.push_button1)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading1 = QLabel()
        self.text_subheading1.setTextFormat(1)
        self.text_subheading1.setText("<center><font color='#0404B4'>Job [Updates]</font></center>")
        self.text_subheading1.setFont(font)
        self.layout.addWidget(self.text_subheading1)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)


        self.push_button11 = QPushButton("Change Selected Work Tags to Default Tag of 'Real' Author [Selected Books]", self)
        self.push_button11.clicked.connect(self.__do_push_button11)
        self.push_button11.setFont(font)
        self.layout.addWidget(self.push_button11)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading11 = QLabel()
        self.text_subheading11.setTextFormat(1)
        self.text_subheading11.setText("<center><font color='#0404B4'>Immediate [Updates per Table _tags_by_author_default]</font></center>")
        self.text_subheading11.setFont(font)
        self.layout.addWidget(self.text_subheading11)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)


        self.push_button13 = QPushButton("Auto-Populate Tags-by-Comment Table Using Tag Rules  and Comments", self)
        self.push_button13.clicked.connect(self.__do_push_button13)
        self.push_button13.setFont(font)
        self.layout.addWidget(self.push_button13)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading13 = QLabel()
        self.text_subheading13.setTextFormat(1)
        self.text_subheading13.setText("<center><font color='#0404B4'>Immediate [Updates]</font></center>")
        self.text_subheading13.setFont(font)
        self.layout.addWidget(self.text_subheading13)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button3 = QPushButton("Book Level Tag Scrubber [Selected Books]", self)
        self.push_button3.clicked.connect(self.__do_push_button3)
        self.push_button3.setFont(font)
        self.layout.addWidget(self.push_button3)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading3 = QLabel()
        self.text_subheading3.setTextFormat(1)
        self.text_subheading3.setText("<center><font color='#0404B4'>Job [Updates]</font></center>")
        self.text_subheading3.setFont(font)
        self.layout.addWidget(self.text_subheading3)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button9 = QPushButton("Minimize Work Tags Per Book Using Tag Priorities [Selected Books]", self)
        self.push_button9.clicked.connect(self.__do_push_button9)
        self.push_button9.setFont(font)
        self.layout.addWidget(self.push_button9)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading9 = QLabel()
        self.text_subheading9.setTextFormat(1)
        self.text_subheading9.setText("<center><font color='#0404B4'>Job [Updates]</font></center>")
        self.text_subheading9.setFont(font)
        self.layout.addWidget(self.text_subheading9)


        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button6 = QPushButton("Tag Scrubber:  'Easy-Add'  New Real Tags to Purge to Tag Rules Table", self)
        self.push_button6.clicked.connect(self.__do_push_button6)
        self.push_button6.setFont(font)
        self.layout.addWidget(self.push_button6)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading6 = QLabel()
        self.text_subheading6.setTextFormat(1)
        self.text_subheading6.setText("<center><font color='#0404B4'>[Interactive]</font></center>")
        self.text_subheading6.setFont(font)
        self.layout.addWidget(self.text_subheading6)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button7 = QPushButton("Tag Scrubber:  'Easy-Add'  Work Tags-to-NEWTAG Mappings to Tag Rules Table", self)
        self.push_button7.clicked.connect(self.__do_push_button7)
        self.push_button7.setFont(font)
        self.layout.addWidget(self.push_button7)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading7 = QLabel()
        self.text_subheading7.setTextFormat(1)
        self.text_subheading7.setText("<center><font color='#0404B4'>[Interactive]</font></center>")
        self.text_subheading7.setFont(font)
        self.layout.addWidget(self.text_subheading7)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button12 = QPushButton("Change Default Tag of 'Real' Author to Selected Work Tag [Selected Books]", self)
        self.push_button12.clicked.connect(self.__do_push_button12)
        self.push_button12.setFont(font)
        self.layout.addWidget(self.push_button12)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading12 = QLabel()
        self.text_subheading12.setTextFormat(1)
        self.text_subheading12.setText("<center><font color='#0404B4'>Immediate [Updates Table _tags_by_author_default]</font></center>")
        self.text_subheading12.setFont(font)
        self.layout.addWidget(self.text_subheading12)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button10 = QPushButton("Copy Tag && Title Rules and WSSVD From/To Previously Configured Q&&S Libraries", self)
        self.push_button10.clicked.connect(self.__do_push_button10)
        self.push_button10.setFont(font)
        self.layout.addWidget(self.push_button10)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading10 = QLabel()
        self.text_subheading10.setTextFormat(1)
        self.text_subheading10.setText("<center><font color='#0404B4'>Job [Updates]  [Must be Run from the Configured 'Best' Q&S Library] </font></center>")
        self.text_subheading10.setFont(font)
        self.layout.addWidget(self.text_subheading10)

        self.layout.addSpacing(5)

        font.setBold(True)
        font.setPointSize(8)


        self.push_button4 = QPushButton('Validate Work Series, Work Titles && Work Indexes Via Web Source [Fiction Series of Selected Books]', self)
        self.push_button4.clicked.connect(self.__do_push_button4)
        self.push_button4.setFont(font)
        self.layout.addWidget(self.push_button4)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading4 = QLabel()
        self.text_subheading4.setTextFormat(1)
        self.text_subheading4.setText("<center><font color='#0404B4'>Job [Log Report Only]</font></center>")
        self.text_subheading4.setFont(font)
        self.layout.addWidget(self.text_subheading4)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button5 = QPushButton('Rename Work Series Name to Web Series Name [Previously Validated Fiction Series Only]', self)
        self.push_button5.clicked.connect(self.__do_push_button5)
        self.push_button5.setFont(font)
        self.layout.addWidget(self.push_button5)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading5 = QLabel()
        self.text_subheading5.setTextFormat(1)
        self.text_subheading5.setText("<center><font color='#0505B5'>Job [Updates]</font></center>")
        self.text_subheading5.setFont(font)
        self.layout.addWidget(self.text_subheading5)

        self.layout.addSpacing(5)

        font.setBold(True)
        font.setPointSize(8)


        self.push_button2 = QPushButton("Delete Non-ISBN Identifiers [Selected Books]", self)
        self.push_button2.clicked.connect(self.__do_push_button2)
        self.push_button2.setFont(font)
        self.layout.addWidget(self.push_button2)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading2 = QLabel()
        self.text_subheading2.setTextFormat(1)
        self.text_subheading2.setText("<center><font color='#0404B4'>Immediate [Updates]</font></center>")
        self.text_subheading2.setFont(font)
        self.layout.addWidget(self.text_subheading2)

        self.layout.addSpacing(1)

        font.setBold(True)
        font.setPointSize(8)


        self.push_button8 = QPushButton("Pristine Library:  Reset Last Modified Date to (Now - 24 Hours)", self)
        self.push_button8.clicked.connect(self.__do_push_button8)
        self.push_button8.setFont(font)
        self.layout.addWidget(self.push_button8)

        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading8 = QLabel()
        self.text_subheading8.setTextFormat(1)
        self.text_subheading8.setText("<center><font color='#FF0000'><b>[Only Updates Pristine Library Books Modified Within the Last 24 Hours!]</b></font></center>")
        self.text_subheading8.setFont(font)
        self.layout.addWidget(self.text_subheading8)
        font.setBold(False)
        font.setPointSize(7)
        self.text_subheading8 = QLabel()
        self.text_subheading8.setTextFormat(1)
        self.text_subheading8.setText("<center><font color='#0404B4'>Immediate [Updates]</font></center>")
        self.text_subheading8.setFont(font)
        self.layout.addWidget(self.text_subheading8)


        self.layout.addSpacing(2)

        font.setBold(True)
        font.setPointSize(8)

        button_box = QDialogButtonBox(QDialogButtonBox.Cancel)
        button_box.rejected.connect(self.reject)
        self.layout.addWidget(button_box)

        self.resize(self.sizeHint())


    def __do_push_button1(self):
        miscellany_option = "1"
        run_type = "X"    #not used
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button2(self):
        miscellany_option = "2"
        run_type = "none"    #not a job
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button3(self):
        miscellany_option = "3"
        run_type = "X"    #not used
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button4(self):
        miscellany_option = "4"
        run_type = "0"    #validation report only
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button5(self):
        miscellany_option = "5"
        run_type = "1"    #update only
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button6(self):
        miscellany_option = "6"
        run_type = "X"    #not used
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button7(self):
        miscellany_option = "7"
        run_type = "X"    #not used
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button8(self):
        miscellany_option = "8"
        run_type = "none"    #not a job
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button9(self):
        miscellany_option = "9"
        run_type = "1"    #update only
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button10(self):
        miscellany_option = "10"
        run_type = "1"    #update only
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button11(self):
        miscellany_option = "11"
        run_type = "none"    #not a job
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button12(self):
        miscellany_option = "12"
        run_type = "none"    #not a job
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)

    def __do_push_button13(self):
        miscellany_option = "13"
        run_type = "none"    #not a job
        self._start_miscellaneous_events(miscellany_option, run_type,self.db)



#END of miscellanydialog.py