# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.104"    # BeautifulSoup changed to use Standard Calibre's BS

from calibre.customize import InterfaceActionBase

class ActionQuarantineAndScrub(InterfaceActionBase):

    name                    = 'QuarantineAndScrub'
    description           = '[For Advanced Calibre Users Only: Must Download Special Database From mobileread.com] Clean Malformed, Misplaced or Missing Author, Title, Series, Index, ISBN; Tag Scrubber, Deriver, Propagator, Defaulter & Minimizer; Series Deriver & Consolidator; Series & Index Validator/Corrector; Genre Deriver; LCC & DDC Deriver; Book Awards; & Much More'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (3, 6, 104)
    minimum_calibre_version = (2, 0, 5)

    actual_plugin           = 'calibre_plugins.quarantine_and_scrub.ui:QuarantineAndScrub'

    gui_name = "QuarantineAndScrub"

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):

        pass

    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):

        return True

    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):

        from calibre_plugins.quarantine_and_scrub.config import ConfigWidget

        return ConfigWidget()


    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):

        ConfigWidget.save_settings()

        # Apply the changes
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()


    #--------------------------------------------------------------------------------------------------------------------------

#END of __init__py
