# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2014, DaltonST <DaltonShiTzu@outlook.com>'

__my_version__ = "3.2.1"

from PyQt5.Qt import (Qt, QDialog, QLabel, QVBoxLayout, QHBoxLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem, QLineEdit,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut)

from calibre_plugins.quarantine_and_scrub.config import prefs

class ConfigDialog(QDialog):

    def __init__(self, gui, icon, do_user_config):

        QDialog.__init__(self, gui)
        self.gui = gui
        self.do_user_config = do_user_config

        self.do_user_config(parent=self)

        self.db = gui.current_db

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(11)

        self.layout.addSpacing(2)

        self.label = QLabel()
        self.label.setTextFormat(1)
        self.label.setText("<center><font color='#0404B4'>                           Q+S Configuration Options                        </font></center>")
        self.label.setFont(font)
        self.layout.addWidget(self.label)

        self.layout.addSpacing(4)

        font.setBold(True)
        font.setPointSize(10)

        self.setWindowTitle('Quarantine And Scrub: Configuration                              ')
        self.setWindowIcon(icon)

        self.conf_button = QPushButton('Click to Configure Preferences', self)
        self.conf_button.clicked.connect(self.config)           #this invokes the widget in config.py
        self.layout.addWidget(self.conf_button)

        self.layout.addSpacing(2)

        font.setBold(True)
        font.setPointSize(8)

        button_box = QDialogButtonBox(QDialogButtonBox.Cancel)
        button_box.rejected.connect(self.reject)
        self.layout.addWidget(button_box)

        self.resize(self.sizeHint())



    def config(self):

        self.do_user_config(parent=self)


#END of configdialog.py