# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015, DaltonST <DaltonShiTzu@outlook.com>'
__docformat__ = 'restructuredtext en'

__my_version__ = "3.6.25"

from PyQt5.Qt import (Qt, QDialog, QLabel, QVBoxLayout, QHBoxLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut)


class SeriesConsolChoicesDialog(QDialog):


    def __init__(self,gui,icon,guidb,run_type,s_msg,_question_then_go_series_level_part2):

        QDialog.__init__(self, gui)
        self.gui = gui

        self.guidb = guidb
        self.run_type = run_type
        self.s_msg = s_msg
        self._question_then_go_series_level_part2   =  _question_then_go_series_level_part2

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(11)

        self.layout.addSpacing(2)

        self.text_heading = QLabel()
        self.text_heading.setTextFormat(1)
        self.text_heading.setText("<center><font color='#0404B4'>" + s_msg + "</font></center>")
        self.text_heading.setFont(font)
        self.layout.addWidget(self.text_heading)
        self.layout.addSpacing(10)


        self.setWindowTitle('Quarantine And Scrub')
        self.setWindowIcon(icon)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button1 = QPushButton(" ", self)
        self.push_button1.setText("Source Prioritization:  Work Series [Default]")
        self.push_button1.clicked.connect(self.__do_push_button1)
        self.push_button1.setFont(font)
        self.layout.addWidget(self.push_button1)


        self.layout.addSpacing(15)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button2 = QPushButton(" ", self)
        self.push_button2.setText("Source Prioritization: Global Series then Work Series")
        self.push_button2.clicked.connect(self.__do_push_button2)
        self.push_button2.setFont(font)
        self.layout.addWidget(self.push_button2)


        self.layout.addSpacing(15)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button3 = QPushButton(" ", self)
        self.push_button3.setText("Source Prioritization: Pristine Series then Global Series then Work Series")
        self.push_button3.clicked.connect(self.__do_push_button3)
        self.push_button3.setFont(font)
        self.layout.addWidget(self.push_button3)


        self.layout.addSpacing(20)


        font.setBold(True)
        font.setPointSize(8)

        button_box = QDialogButtonBox(QDialogButtonBox.Cancel)
        button_box.rejected.connect(self.reject)
        self.layout.addWidget(button_box)

        self.resize(self.sizeHint())


    def __do_push_button1(self):
        self.chosen_option = "W"            #Work [Default]
        self._question_then_go_series_level_part2(self.guidb,self.chosen_option,self.run_type)


    def __do_push_button2(self):
        self.chosen_option = "GW"         #Global,Work
        self._question_then_go_series_level_part2(self.guidb,self.chosen_option,self.run_type)


    def __do_push_button3(self):
        self.chosen_option = "PGW"        #Pristine,Global,Work
        self._question_then_go_series_level_part2(self.guidb,self.chosen_option,self.run_type)


#END of seriesconsolchoicesdialog.py