# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "3.6.103" # Book-Level Scrubbing Tweaks
import os, sys
import apsw
from calibre.library.database import LibraryDatabase
import datetime, re, sre_constants
from calibre.db.backend import DB
from calibre import isbytestring, force_unicode, prints
from calibre.constants import filesystem_encoding, preferred_encoding
from Queue import Empty, Queue
from calibre.gui2.threaded_jobs import ThreadedJob, BaseJob
from calibre.utils.logging import Log as log
from calibre.gui2 import error_dialog, info_dialog
import codecs
from time import sleep
import time
import unicodedata
from copy import deepcopy
from difflib import SequenceMatcher
from calibre_plugins.quarantine_and_scrub.config import prefs
from calibre_plugins.quarantine_and_scrub.titlecase import titlecase
from calibre_plugins.quarantine_and_scrub.copywork import ( _convert_identifiers_isbn_from_10_to_13,
                                                                                                      _convert_isbn_check_digit_13, _convert_isbn_convert_10_to_13 )
from calibre_plugins.quarantine_and_scrub.heading import log_heading_common
from calibre_plugins.quarantine_and_scrub.booklevel_keywords import __remove_bad_keywords
myquotes = "\""
mysinglequote = "\'"
mynothing = ""
mynull = None
my_terminate_early = False
notifications = Queue()
my_current_book_id = "000000"
my_book_ids = []
scrubbed_books_final_list = []
work_author_name = ""
work_author_sort = ""
work_title_name = ""
work_series_name = ""
author_valid_globally = False
author_valid_globally = False
series_valid_globally = False
author_probably_good = False
seriesindex_probably_good = False
force_update_of_series = False
title_probably_good = False
title_is_frozen = False
partial_blankout_scenario = False
finished_scrub_title_index_series_in_title = False
finished_scrub_title_series_index_in_title = False
book_is_frozen = False
is_scrubbable = True
author_in_title = False
title_in_author = False
series_in_author = False
series_in_title = False
author_is_really_title = False
set_of_letters = set('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ')
set_of_letters.add('äëöüÜËÄÖáéíóúñçãÕõ')
set_of_numbers =  set('0123456789')
set_of_symbols = set(".,[]{}|?<>;:-_=+*#@&!`~\\//")
set_of_symbols.add('"')
set_of_symbols.add("'")
set_of_symbols.add("'.,&-")
set_of_author_symbols = set("'.,&-")
set_of_numbers_letters = deepcopy(set_of_letters)
set_of_numbers_letters.add('0123456789')
set_of_numbers_letters_spaces = deepcopy(set_of_numbers_letters)
set_of_numbers_letters_spaces.add(" ")
set_of_numbers_letters_spaces.add("  ")
set_of_letters_and_author_symbols = deepcopy(set_of_letters)
set_of_letters_and_author_symbols.add("'.,&-")
set_of_title_characters = deepcopy(set_of_numbers_letters)
set_of_title_characters.add(".,[]{}|?<>;:-_=+*#@&!`~\\//")
set_of_numbers_and_symbols = deepcopy(set_of_numbers)
set_of_numbers_and_symbols.add(".,[]{}|?<>;:-_=+*#@&!`~\\//")
set_of_re_metacharacters = set(".^$*+?{}[]\|()")
series_re_pattern_to_remove = ""
freeze_current_book = False
list_of_known_books_swapped_author = []
list_of_known_authors = []
global_dict1 = {}
global_dict2 = {}
global_dict3 = {}
re_already_imported = False
probable_seriesname_to_add = []
probable_tags_to_add = []
single_work_tags_all = []
tag_regex_rules = []
tag_capitalization_regex_rules = []
title_regex_rules = []
series_regex_rules = []
title_cc_control_rules = []
book_awards_list = []
my_plugin_path = ""
my_guidb = ""
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None
def main_scrub_book_level(self, guidb, book_ids, scrubbed_books_final, my_plugin_path, log=None, abort=None, notifications=True):
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    global my_terminate_early
    global mynothing
    global my_book_ids
    global scrubbed_books_final_list
    global my_guidb
    scrubbed_books_final_list = []
    sleep(1.0)
    my_plugin_path_ = my_plugin_path
    my_book_ids = deepcopy(book_ids)
    del book_ids
    my_guidb = guidb
    path = my_guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    log("Library DB: " + path)
    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log(str(e))
        raise e
        return
    my_cursor = my_db.cursor()
    header_s1 =  str("SQLite Version: " + str(apsw.SQLITE_VERSION_NUMBER) + "  [APSW]")
    mysql = str("PRAGMA main.locking_mode=EXCLUSIVE;")
    my_cursor.execute(mysql)
    header_s2 = mysql
    header_s3 = "Beginning Book Level Scrubbing"
    log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
    mysql = "PRAGMA main.busy_timeout = 5000;"
    my_cursor.execute(mysql)
    sleep(0.01)
    notifications.put((0.001, 'Doing Light Housekeeping Prior to Scrubbing'))
    change_work_series_full_to_standard(my_db, my_cursor, log)
    fix_author_name_null(my_db, my_cursor, log)
    remove_all_double_quotes(my_db, my_cursor, notifications, log)
    __add_title_rule_table_rules(my_db, my_cursor, log)
    Create_SQLite_User_Functions(my_db, my_cursor, log)
    __build_regex_list_from_tag_rules(my_db, my_cursor, log)
    __build_regex_list_from_tag_capitalization_rules(my_db, my_cursor, log)
    __build_regex_list_from_title_rules(my_db, my_cursor, log)
    __build_regex_list_from_series_rules(my_db, my_cursor, log)
    __build_rules_list_from_title_cc_control(my_db, my_cursor, log)
    __build_book_awards_list(my_db, my_cursor, log)
    __delete_unused_values(my_db, my_cursor, notifications, log)
    __explode_custom_column_4_if_needed(my_db, my_cursor, log)
    __explode_custom_column_8_if_needed(my_db, my_cursor, log)
    __explode_custom_column_10_if_needed(my_db, my_cursor, log)
    __explode_custom_column_13_if_needed(my_db, my_cursor, log)
    __update_table_books_work(my_db, my_cursor, log)
    Scrub_Control(my_db, my_cursor, my_book_ids, notifications, log)
    notifications.put((0.99, 'Doing Final Light Housekeeping'))
    __purge_transient_tables(my_db, my_cursor, log)
    sleep(0.5)
    my_db.close()
    n = len(scrubbed_books_final_list)
    scrubbed_books_final = deepcopy(scrubbed_books_final_list)
    log("Job complete.")
    notifications.put((0.99, 'Job is Complete.'))
    return scrubbed_books_final
def Scrub_Control(my_db, my_cursor, my_book_ids, notifications, log):
    log("Beginning Scrubbing")
    notifications.put((0.002, 'Beginning Book Level Scrubbing'))
    global author_probably_good
    global author_valid_globally
    global series_valid_globally
    global seriesindex_probably_good
    global book_is_frozen
    global finished_scrub_title_index_series_in_title
    global finished_scrub_title_series_index_in_title
    global force_update_of_series
    global freeze_current_book
    global scrubbed_books_final_list
    global probable_seriesname_to_add
    global probable_tags_to_add
    global tags_to_subjects_list
    global title_probably_good
    global title_is_frozen
    global author_is_really_title
    global is_scrubbable
    global single_work_tags_all
    single_work_tags_all  = []
    probable_seriesname_to_add = []
    probable_tags_to_add = []
    bstr_book_ids = []
    for row in my_book_ids:
        tuple = row
        bstr_s = str(__change_tuple_to_bytestring(tuple))
        bstr_book_ids.append(bstr_s)
    del my_book_ids
    n0 = len(bstr_book_ids)
    log(" ")
    log(str(n0) + " Book(s) Being Scrubbed")
    if not n0 > 0:
        return
    my_counter = 0
    scrubbed_so_far = 0
    n1 = 0
    for row in bstr_book_ids:
        my_counter = my_counter + 1
        scrubbed_so_far = scrubbed_so_far + 1
        my_current_book = row
        author_valid_globally = False
        series_valid_globally = False
        author_probably_good = False
        title_probably_good = False
        title_is_frozen = False
        finished_scrub_title_index_series_in_title = False
        finished_scrub_title_series_index_in_title = False
        seriesindex_probably_good = False
        force_update_of_series = False
        book_is_frozen = False
        freeze_current_book = False
        probable_seriesname_to_add[:] = []
        probable_tags_to_add[:] = []
        author_is_really_title = False
        is_scrubbable = True
        __skip_frozen_book(my_db, my_cursor,  my_current_book, notifications, log)
        if book_is_frozen:
            continue
        else:
            pass
        scrub_with_special_custom_column_title_cc_control_rules(my_db, my_cursor, my_current_book, notifications, log)
        scrub_manga_control(my_db, my_cursor, my_current_book, notifications, log)
        scrub_comicbook_control(my_db, my_cursor, my_current_book, notifications, log)
        scrub_magazine_control(my_db, my_cursor, my_current_book, notifications, log)
        if is_scrubbable:
            scrub_first_first_author(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_first_first_title(my_db, my_cursor, my_current_book, notifications, log)
            scrub_first_first_series(my_db, my_cursor, my_current_book, notifications, log)
            check_title_for_valid_patterns_to_not_scrub(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_author_name_goofy(my_db, my_cursor,  my_current_book, notifications, log)
            check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_isbn_in_author(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_isbn_in_title(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_the_lewis_the_lover_scenario(my_db, my_cursor, my_current_book, notifications, log)
            check_title_for_special_patterns_to_genericize(my_db, my_cursor,  my_current_book, notifications, log)
            derive_tags_from_comments(my_db, my_cursor, my_current_book, notifications, log)
            scrub_misc_title_issues(my_db, my_cursor, my_current_book, notifications, log)
            scrub_author_name_commas(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_author_name_initials(my_db, my_cursor,  my_current_book, notifications, log)
            check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            check_author_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            check_if_author_is_not_author_and_title_is_not_author(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_misc_title_issues(my_db, my_cursor, my_current_book, notifications, log)
            check_title_for_valid_patterns_to_not_scrub(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_good_series_also_in_title(my_db, my_cursor, my_current_book, notifications, log)
            check_series_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_title_is_author_index_series(my_db, my_cursor,  my_current_book, notifications, log)
            check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_title_is_author_series_index(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_switched_author_title(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_author_is_title_but_title_is_title_with_author_too(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_title_index_series_in_title(my_db, my_cursor, my_current_book, notifications, log)
            scrub_series_substring_across_author(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_series_substring(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_obvious_series_still_in_title_within_delimiters(my_db, my_cursor, my_current_book, notifications, log)
            scrub_obvious_series_still_in_title_with_no_delimiters(my_db, my_cursor, my_current_book, notifications, log)
            check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_author_good_but_author_also_in_title(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_worktitle_workseries_swapped(my_db, my_cursor, my_current_book, notifications, log)
            scrub_work_series_with_numerics(my_db, my_cursor, my_current_book, notifications, log)
            scrub_misc_title_scenarios(my_db, my_cursor, my_current_book, notifications, log)
            check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            __delete_unused_values(my_db, my_cursor, notifications, log)
            check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            scrub_final_author_title_switched(my_db, my_cursor, my_current_book, notifications, log)
            scrub_worktitle_workseries_swapped(my_db, my_cursor, my_current_book, notifications, log)
            scrub_misc_title_issues(my_db, my_cursor, my_current_book, notifications, log)
            scrub_final_work_series_format(my_db, my_cursor, my_current_book, notifications, log)
            scrub_final_final_title(my_db, my_cursor, my_current_book, notifications, log)
            probable_tags_to_add = add_book_awards(my_db, my_cursor, my_current_book, notifications, log, probable_tags_to_add)
            scrub_tags(my_db, my_cursor, my_current_book, notifications, log, probable_tags_to_add)
            add_missing_seriesname_from_web_detail(my_db, my_cursor, my_current_book,notifications, log) #prior to refreshing cc 15
            __refresh_custom_column_15(my_db, my_cursor, my_current_book, notifications, log)
            __update_work_columns_for_utf8_display(my_db, my_cursor, my_current_book, notifications, log)
        else:
            freeze_current_book = True
            pass
        __set_work_freeze(my_db, my_cursor, my_current_book, notifications, log)
        n1 = n1 + 1
        pc = float(n1/n0)
        notifications.put((pc, 'Book Level Scrubbing'))
        sleep(0.1)
        if  my_counter == 20 :
            log(" ")
            log("Books Scrubbed So Far: ", str(scrubbed_so_far))
            sleep(0.2)
            my_counter = 0
    log(" ")
    log("Total Books Scrubbed: ", str(scrubbed_so_far))
    log(" ")
    log("Now Doing Miscellaneous Scrubbing.  This is for all books in the current library that have *any* work-data whatsoever.  The progress indicator will remain at 99% during this (long) process.  Be patient.")
    log(" ")
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [1 of 10]: Adding Tag Combinations'))
    add_tag_combinations(my_db, my_cursor, notifications, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [2 of 10]: Applying Tag String Replacement Rules'))
    apply_tag_string_replacement_rules(my_db, my_cursor, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [3 of 10]: Erasing Unused Values'))
    __delete_unused_values(my_db, my_cursor, notifications, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [4 of 10]: Fixing Missing Series Indexes'))
    __set_null_seriesname_index_to_zero(my_db, my_cursor, notifications, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [5 of 10]: Doing Light Housekeeping'))
    _insert_single_tags_into_work_tags_single(my_db, my_cursor, notifications, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [6 of 10]: Converting ISBN 10 to 13'))
    _convert_identifiers_isbn_from_10_to_13(my_db, my_cursor, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [7 of 10]: Changing Work Title to Web Title as Needed'))
    change_work_title_to_web_title_for_previously_validated_work_series(my_db, my_cursor, notifications, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed'))
    miscellany_change_work_index_to_web_index_standalone(my_db, my_cursor, notifications, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [9 of 10]: Applying Author Mapping Rules'))
    apply_author_mapping_rules(my_db, my_cursor,  my_current_book, notifications, log)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [10 of 10]: Finishing'))
    log("Book-Level Scrubbing is complete.")
def apply_author_mapping_rules(my_db, my_cursor,  my_current_book, notifications, log):
    mysql = "UPDATE custom_column_4 SET value =(SELECT newname FROM _author_mapping WHERE name = custom_column_4.value ) \
                    WHERE value IN(SELECT name FROM  _author_mapping WHERE name = custom_column_4.value AND newname NOT NULL AND name NOT NULL)"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
def scrub_author_name_commas(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_probably_good
    global freeze_current_book
    auth_list = []
    bstr_s = ""
    mysql = "SELECT authname from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tuple = str(row)
            bstr_s = str(__change_tuple_to_bytestring(tuple))
            break
    else:
        return
    bstr_s = str(bstr_s.replace("  "," ",1))
    author_is_garbage = False
    s_new_author_name = str(bstr_s)
    if s_new_author_name.endswith(","):
        s_new_author_name = str(s_new_author_name[0:-1])
        author_is_garbage = True
    n1 = s_new_author_name.count("|")
    if n1 == 1:
        s_new_author_name = s_new_author_name.replace("|", ",", 1)
        author_is_garbage = True
    else:
        pass
    n2 = s_new_author_name.count(",")
    if n2 == 1:
        s_split = s_new_author_name.split(",")
        s1 = str(s_split[0])
        s2 = str(s_split[1])
        s1 = s1.replace(" ", mynothing, 4)
        s2 = s2.replace(" ", mynothing, 4)
        s_new_author_name = str(s2 + " " + s1)
        author_is_garbage = True
    else:
        pass
    if not author_is_garbage:
       return
    else:
        mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, s_new_author_name, my_current_book)
        author_probably_good = True
def scrub_author_name_initials(my_db, my_cursor,  my_current_book, notifications, log):
    global author_probably_good
    tmp_auth_rows = []
    del tmp_auth_rows
    bstr_s = ""
    mysql = "SELECT authname from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            bstr_s = ""
            tuple = row
            bstr_s = __change_tuple_to_bytestring(tuple)
            break
    else:
        return
    n = bstr_s.count(" ")
    if n > 2 :
        return
    else:
        s_new_author_name =  __reformat_author_initials(bstr_s)
        if s_new_author_name <> bstr_s:
            mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                    (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, s_new_author_name, my_current_book)
            author_probably_good = True
def check_author_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log):
    global author_valid_globally
    global author_probably_good
    if author_valid_globally:
        return
    author_valid_globally = False
    tmp_global_auth_rows = []
    del tmp_global_auth_rows
    mysql = 'SELECT authname from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tmp_auth = str(row)
            tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
            n = tmp_auth.count('"')
            if n > 0:
                tmp_auth = str(tmp_auth.replace('"', mynothing, 10))
            mysql = 'SELECT name from _global_authors WHERE name = "' + tmp_auth + '"  ;'
            tmp_global_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
            if tmp_global_auth_rows:
                author_valid_globally = True
            else:
                tmp_global_auth_rows = []
                del tmp_global_auth_rows
                mysql = 'SELECT name from _pristine_authors WHERE name = "' + tmp_auth + '"  ;'
                tmp_global_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
                if tmp_global_auth_rows:
                    author_valid_globally = True
                    break
    else:
        pass
    if author_valid_globally:
        author_probably_good = True
        return
    tmp_global_auth_rows = []
    del tmp_global_auth_rows
    mysql = 'SELECT value FROM __books_work_status WHERE book = "' + my_current_book + '"  AND value = "auth_ok";'
    tmp_global_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_global_auth_rows:
        author_valid_globally = True
        author_probably_good = True
    else:
        pass
def check_title_against_global_author_valid_values(my_db, my_cursor,  my_current_book, notifications, log):
    global author_valid_globally
    global author_probably_good
    if author_valid_globally:
        return
    if author_probably_good:
        return
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    is_title_a_valid_author = False
    tmp_auth_rows = []
    del tmp_auth_rows
    tmp_global_auth_rows = []
    del tmp_global_auth_rows
    mysql = 'SELECT booktitle from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tmp_auth = str(row)
            tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
            tmp_auth = str(tmp_auth.strip())
            mysql = 'SELECT name from _global_authors WHERE name = "' + tmp_auth + '"  ;'
            tmp_global_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
            if tmp_global_auth_rows:
                for row in tmp_global_auth_rows:
                    s = str(row)
                    s = str(__change_tuple_to_bytestring(s))
                    if s == tmp_auth:
                        is_title_a_valid_author = True
                        author_valid_globally = True
                    break
                break
            else:
                return
    else:
        return
    if  is_title_a_valid_author:
        new_auth = str(tmp_auth)
    else:
        return
    tmp_auth_rows = []
    del tmp_auth_rows
    mysql = 'SELECT authname from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            new_title = str(row)
            new_title = str(__change_tuple_to_bytestring(new_title))
            break
    else:
        return
    check_author_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
    if author_valid_globally:
        author_probably_good = True
        title_probably_good = True
        return
    new_title = str(__change_tuple_to_bytestring(new_title))
    new_title = str(new_title.strip())
    if new_title.endswith("-"):
        new_title = str(new_title[0:-1])
    new_title = str(new_title.strip())
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, new_title, my_current_book)
    title_probably_good = False
    tmp_id_rows = []
    del tmp_id_rows
    mysql = "SELECT id from custom_column_4 WHERE value = '" + new_auth + "' ;"
    tmp_id_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_id_rows:
        sleep(.05)
        tmp_id = tmp_id_rows[0]
        tmp_id = __strip_numerics(tmp_id)
        mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_id, my_current_book)
        author_valid_globally = True
    else:
        sleep(.05)
        mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES (?,?)"
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, None, new_auth)
        sleep(.05)
        mysql = 'SELECT id from custom_column_4  WHERE value = "' + new_auth + '" ;'
        tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_auth_rows:
            return
        else:
            tmp_id = tmp_auth_rows[0]
            tmp_id = __strip_numerics(tmp_id)
        sleep(.05)
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = '" + my_current_book + "' ;"
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        sleep(.05)
        mysql = "INSERT  INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?)"
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_id)
        author_valid_globally = True
def check_title_for_valid_patterns_to_not_scrub(my_db, my_cursor,  my_current_book, notifications, log):
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    mysql = 'SELECT booktitle from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title = str(row)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = str(tmp_title.replace("  ", " ", 4))
    tmp_title = tmp_title.strip()
    regex_dict = {}
    regex_dict[1] = "^[a-zA-Z0-9].+\s[&]\s[a-zA-Z0-9-].+"
    regex_dict[2] = '^[a-zA-Z].+\s[1-9][ -]Book\s[a-zA-Z ].+'
    regex_dict[3] = '^[a-zA-Z ].+[,]*\sBooks\s[0-9]+[0-9-]+'
    regex_dict[4] = '^[a-zA-Z].+[:]*\s[1-9][ -]Book\s[a-zA-Z ].+'
    regex_dict[5] = '^[a-zA-Z].+[:]\s[aA][a-zA-Z ]*\sThriller'
    regex_dict[6] = 'Novel\s[12][09][0-9][0-9]\s'
    regex_dict[7] = '^[a-zA-Z ].+\sDigital Edition$'
    regex_dict[8] = '^[a-zA-Z ].+\s[0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]$'
    regex_dict[9] = '^Encyclopedia\sof\s.+:\sVolume\s[0-9]+'
    regex_dict[10] = "^[a-z ]+[']s\s[a-z ]+$"
    regex_dict[11] = "^[a-z ]+\s[0-9]+\s[a-z ]+$"
    regex_dict[12] = "^dr[.][ ][a-z ]+$"
    regex_dict[13] = "^[!!!!!!!!!!!!!!!!!!!!!!!]$"
    num_of_good_regexes = 13
    for i in range(1,(num_of_good_regexes + 1)):
        p = re.compile(regex_dict[i], re.IGNORECASE)
        match1 = p.search(tmp_title)
        if match1:
            if i == 8:
                ns = tmp_title.count(" ")
                nd = tmp_title.count("-")
                if ns > 1 or nd > 0:
                    title_probably_good = True
                    title_is_frozen = True
                else:
                    pass
            else:
                title_probably_good = True
                title_is_frozen = True
                break
    regex_dict[100] = '\(.+\)'
    regex_dict[101] = '\[.+\]'
    regex_dict[102] = "^.+,[a-zA-Z]+"
    regex_dict[103] = "^.+?\s.+?\s[-]\s[a-zA-Z]+[0-9]+\s[-]\s.+"
    regex_dict[104] = "^.+,\s[a-zA-Z]+"
    regex_dict[105] = "^[a-z &]+[0-9]+[ -]+"
    regex_dict[106] = "/^.+\d -/"
    regex_dict[107] = "/^.+\d-/"
    regex_dict[108] = "/^.+\d:/"
    regex_dict[109] = "/^.+\d :/" #matches:  "Isles 4 : " or "ZZZZZZZ 9 : " or "ZZZZZZZ 99 :" but only if space between number and colon
    regex_dict[110] = "\s-\s[a-zA-Z]+[0-9]+\s-\s"
    regex_dict[111] = "^.+\s[IV23456]+\s-\s.+"
    last_bad_regex = 111
    for i in range(100,last_bad_regex):
        p = re.compile(regex_dict[i], re.IGNORECASE)
        match = p.search(tmp_title)
        if match:
            title_probably_good = False
            title_is_frozen = False
            break
def check_title_for_special_patterns_to_genericize(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global probable_seriesname_to_add
    global probable_tags_to_add
    global title_probably_good
    global author_probably_good
    global series_valid_globally
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    new_title = ""
    tmp_title = ""
    mysql = "SELECT booktitle FROM __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            for col in row:
                tmp_title = str(col)
                break
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    need_to_update_title = False
    need_to_update_auth = False
    force_update = False
    my_re1 = "^[a-z ]+\s[0-9]+\s[a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
        return
    else:
        pass
    tmp_title = str(tmp_title.strip())
    s_old = tmp_title
    tmp_title = str(__remove_bad_keywords(tmp_title))
    tmp_title = str(tmp_title.replace("()", mynothing, 10))
    tmp_title = str(tmp_title.replace("[]", mynothing, 10))
    tmp_title = str(tmp_title.replace("{}", mynothing, 10))
    if s_old <> tmp_title:
        new_title = tmp_title
        force_update = True
    my_re1 = "^[A-Z][A-Z][A-Z]*[ ]+[0-9]+[ ][-][ ][A-Z a-z '&]+$"
    p1 = re.compile(my_re1)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s_split = tmp_title.split("-")
            s_left = s_split[0]
            s_left = s_left.strip()
            s_right = s_split[1]
            s_right = s_right.strip()
            s_left = s_left.replace("  "," ",4)
            s_split = s_left.split(" ")
            s_acronym = str(s_split[0])
            s_index = str(s_split[1])
            s_index = str(s_index.strip())
            if s_index[0] == "0":
                s_index = str(s_index[1: ])
            s_acronym_first = str(s_acronym[0])
            tmp_rows = []
            del tmp_rows
            mysql = "SELECT seriesname FROM _global_web_series_detail WHERE booktitle = ? AND seriesindex = ? \
                                                                                                                    AND substr(seriesname,1,1) = ?"
            my_cursor.execute(mysql,(s_right,s_index,s_acronym_first))
            tmp_rows = my_cursor.fetchall()
            if tmp_rows:
                seriesname = "NOTFOUND"
                for row in tmp_rows:
                    for col in row:
                        seriesname = str(col)
                if seriesname <> "NOTFOUND":
                    tmp_title = str(str(s_right) + "  [ " + str(seriesname) + "   ,#" + str(s_index) + "  ]")
                    tmp_title = str(tmp_title.strip())
                    tmp_title = str(tmp_title.replace("  "," ",4))
                    need_to_update_title = True
                    title_probably_good = False
                    title_is_frozen = False
                    new_title = str(tmp_title)
                else:
                    new_title = str(s_right)
                    tmp_title = str(new_title)
                    need_to_update_title = True
                    title_probably_good = True
                    title_is_frozen = True
            else:
                new_title = str(s_right)
                tmp_title = str(new_title)
                need_to_update_title = True
                title_probably_good = True
                title_is_frozen = True
        except Exception as e:
            log("[fix 39:]  " + str(e))
            pass
    my_re1 = "^[a-z ]+[,]*[ ][the]*[ ]*book[ ][onetwhrfuivsxg]+[:][ ].+[,][ ]the$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = str(tmp_title)
            s1 = str(s1[0:-4])
            s1 = str(s1.strip())
            if s1.endswith(","):
                s1 = str(s1[0:-1])
            s1 = str(s1.replace(",",mynothing,1))
            s1 = str(s1.replace("the book","#",1))
            s1 = str(s1.replace("the Book","#",1))
            s1 = str(s1.replace(" One","1",1))
            s1 = str(s1.replace(" Two","2",1))
            s1 = str(s1.replace(" Three","3",1))
            s1 = str(s1.replace(" Four","4",1))
            s1 = str(s1.replace(" Five","5",1))
            s1 = str(s1.replace(" Six","6",1))
            s1 = str(s1.replace(" Seven","7",1))
            s1 = str(s1.replace(" Eight","8",1))
            s1 = str(s1.replace(" Nine","9",1))
            s1 = str(s1.replace(" Ten","10",1))
            s1 = str("[ " + str(s1))
            s1 = str(s1.replace(":","]",1))
            tmp_title = str(s1)
            tmp_title = str(tmp_title.strip())
            tmp_title = str(tmp_title.replace("  "," ",4))
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z &']+[:][ ][a-z &']+[:][ ]book[ ][onetwhrfuivsxg]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = str(tmp_title)
            s1 = str(s1.replace(": book"," #",1))
            s1 = str(s1.replace(": Book"," #",1))
            s1 = str(s1.replace(" One","1",1))
            s1 = str(s1.replace(" Two","2",1))
            s1 = str(s1.replace(" Three","3",1))
            s1 = str(s1.replace(" Four","4",1))
            s1 = str(s1.replace(" Five","5",1))
            s1 = str(s1.replace(" Six","6",1))
            s1 = str(s1.replace(" Seven","7",1))
            s1 = str(s1.replace(" Eight","8",1))
            s1 = str(s1.replace(" Nine","9",1))
            s1 = str(s1.replace(" Ten","10",1))
            s1 = str(s1.replace(":"," [ ",1))
            s1 = str(str(s1) + " ]")
            tmp_title = str(s1)
            tmp_title = str(tmp_title.strip())
            tmp_title = str(tmp_title.replace("  "," ",4))
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z &']+[:][ ]book[ ][onetwhrfuivsxg]+[:][ ][a-z ']+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = str(tmp_title)
            s1 = str(s1.replace(": book","[ #",1))
            s1 = str(s1.replace(": Book","[ #",1))
            s1 = str(s1.replace(" One","1 -",1))
            s1 = str(s1.replace(" Two","2 -",1))
            s1 = str(s1.replace(" Three","3 -",1))
            s1 = str(s1.replace(" Four","4 -",1))
            s1 = str(s1.replace(" Five","5 -",1))
            s1 = str(s1.replace(" Six","6 -",1))
            s1 = str(s1.replace(" Seven","7 -",1))
            s1 = str(s1.replace(" Eight","8 -",1))
            s1 = str(s1.replace(" Nine","9 -",1))
            s1 = str(s1.replace(" Ten","10 -",1))
            s1 = str(s1.replace("-:", "|", 1))
            s1 = str(s1.replace("[", "|", 1))
            s_split = s1.split("|")
            tmp_title = str(s_split[0] + " [ " + s_split[2] + " " + s_split[1] + " ]")
            tmp_title = str(tmp_title.strip())
            tmp_title = str(tmp_title.replace("  "," ",4))
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z &']+[,][ ]Book[ ][onetwhrfuivsxg]+[ ][\(][a-z '&]+[\)]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = str(tmp_title)
            s1 = str(s1.replace(", book","[ #",1))
            s1 = str(s1.replace(", Book","[ #",1))
            s1 = str(s1.replace(" One","1 ",1))
            s1 = str(s1.replace(" Two","2 ",1))
            s1 = str(s1.replace(" Three","3 ",1))
            s1 = str(s1.replace(" Four","4 ",1))
            s1 = str(s1.replace(" Five","5 ",1))
            s1 = str(s1.replace(" Six","6 ",1))
            s1 = str(s1.replace(" Seven","7 ",1))
            s1 = str(s1.replace(" Eight","8 ",1))
            s1 = str(s1.replace(" Nine","9 ",1))
            s1 = str(s1.replace(" Ten","10 ",1))
            s1 = str(s1.replace("(",mynothing,1))
            s1 = str(s1.replace(")"," ",1))
            s_split = s1.split("[")
            s0 = str(s_split[0])
            s1 = str(s_split[1])
            s1 = str(s1.strip())
            n = s1.find(" ")
            s2 = str(s1[0:n])
            s3 = str(s1[n: ])
            tmp_title = str(s0 + " [" + s3 + " " + s2 + " ]")
            tmp_title = str(tmp_title.strip())
            tmp_title = str(tmp_title.replace("  "," ",4))
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z ',]+[,][ ][BookVolume]+[ ][OneTwhrFuivSxg0123456789]+[:][ ][a-z ',]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = str(tmp_title)
            s1 = str("[ " + s1)
            s1 = str(s1.replace(":"," ]",1))
            s1 = str(s1.replace(", book"," #",1))
            s1 = str(s1.replace(", Book"," #",1)) #     [Septimus Heap # One ] Magyk
            s1 = str(s1.replace(", volume"," #",1))
            s1 = str(s1.replace(", Volume"," #",1)) #     [Septimus Heap # One ] Magyk
            s1 = str(s1.replace(" One","1 ",1))
            s1 = str(s1.replace(" Two","2 ",1))
            s1 = str(s1.replace(" Three","3 ",1))
            s1 = str(s1.replace(" Four","4 ",1))
            s1 = str(s1.replace(" Five","5 ",1))
            s1 = str(s1.replace(" Six","6 ",1))
            s1 = str(s1.replace(" Seven","7 ",1))
            s1 = str(s1.replace(" Eight","8 ",1))
            s1 = str(s1.replace(" Nine","9 ",1))
            s1 = str(s1.replace(" Ten","10 ",1))
            tmp_title = str(s1)
            tmp_title = str(tmp_title.strip())
            tmp_title = str(tmp_title.replace("  "," ",4))
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^.+\s\(An\s[a-z ]+\sThriller\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^.+\s\("
        my_re_right = "\(An\s[a-z ]+\sThriller\)"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
        s2 = str(tmp_title.replace(s1, mynothing, 1))
        s2 = str(s2.replace("(", mynothing, 4))
        s2 = str(s2.replace(")", mynothing, 4))
        s2 = str(s2.replace("Book", mynothing, 4))
        s2 = str(s2.strip())
        s2 = str(titlecase(s2))
        probable_tags_to_add.append("Thriller")
        s2 = str(s2.replace("An ", mynothing, 1))
        s2 = str(s2.replace("Thriller", mynothing, 1))
        s2 = str(s2.strip())
        probable_seriesname_to_add.append(s2)
        s1 = str(s1.replace("(", mynothing, 1))
        s1 = str(titlecase(s1))
        s1 = str(s1.strip())
        new_title = str(s1)
        need_to_update_title = True
    my_re1 = "^[a-z ]+[:][ ]A Novel of the[ ][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s_split = s1.split(":")
            s_left = s_split[0]
            s_right = s_split[1]
            s_right = s_right.replace("a novel of the ",mynothing,1)
            s_right = s_right.replace("A Novel of the ",mynothing,1)
            tmp_title = s_left + " [ " + s_right + "]"
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z ]+\s#[0-9]+[: ]\s[a-z ]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        pass
    else:
        my_re_left =  "^[a-z ]+\s#[0-9]+[: ]"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            log("ERROR[1]:  logic error in check_title_for_special_patterns_to_genericize")
            return
        else:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
        s2 = str(tmp_title.replace(s1, mynothing, 1))
        s1 = str(s1.replace(":", mynothing, 1))
        s1 = str(s1.strip())
        new_title = str(str(s2) + " [" + str(s1) + "]")
        need_to_update_title = True
    my_re1 = "^[a-z ]+[:-]\sBook\s[0-9]+\s\(.+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^[a-z ]+[:-]"
        my_re_middle = "^[a-z ]+[:-]\sBook\s[0-9]+\s"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
        s2 = str(tmp_title.replace(s1, mynothing, 1))
        s2 = str(s2.replace("(", mynothing, 4))
        s2 = str(s2.replace(")", mynothing, 4))
        s2 = str(s2.replace("Book", mynothing, 4))
        s2 = str(s2.strip())
        s2 = str("#" + str(s2))
        s2 = str(titlecase(s2))
        s1 = str(s1.replace(":", mynothing, 1))
        s1 = str(titlecase(s1))
        s1 = str(s1.strip())
        new_title = str(str(s1) + " [" + str(s2) + "]")
        need_to_update_title = True
    my_re1 = "^[a-z ]+&[a-z ]+\([a-z ]+-\sBook\s[a-z ]*[0-9]+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^[a-z ]+&[a-z ]+"
        my_re_right = "\([a-z ]+-\sBook\s[a-z ]*[0-9]+\)"
        my_re_numeric = "[0-9]+"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
        s2 = str(tmp_title.replace(s1, mynothing, 1))
        s2 = str(s2.replace("(", mynothing, 4))
        s2 = str(s2.replace(")", mynothing, 4))
        s2 = str(s2.replace("Book", mynothing, 4))
        s2 = str(s2.replace("-", mynothing, 4))
        s2 = str(s2.replace("  ", " ", 4))
        s2 = str(s2.strip())
        s2 = str(titlecase(s2))
        s1 = str(titlecase(s1))
        s1 = str(s1.strip())
        p3 = re.compile(my_re_numeric, re.IGNORECASE)
        match3 = p3.search(s2)
        if not match3:
            sleep(60.0)
            return
        else:
            s3 = match3.group(0)
            s3 = str(s3)
            s3 = str(__strip_numerics(s3))
            s2 = str(s2.replace(s3, str("#" + s3), 1))
        new_title = str(str(s1) + " [" + str(s2) + "]")
        new_title = str(new_title.replace("  ", " ", 4))
        need_to_update_title = True
    my_re1 = "^[a-z ]+[0-9]+[ _:-]+[a-z ]+[,:-]*\s[a-z ]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^[a-z ]+[0-9]+[ _:-]+"
        my_re_numeric = "[0-9]+"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
        s2 = str(tmp_title.replace(s1, mynothing, 1))
        s2 = str(s2.replace(",", mynothing, 4))
        s2 = str(s2.replace(":", mynothing, 4))
        s2 = str(s2.replace("-", mynothing, 4))
        if s2.endswith("The"):
            s2 = s2[0:-3]
        s2 = str(s2.strip())
        s2 = str(titlecase(s2))
        s1 = str(titlecase(s1))
        s1 = str(s1.replace("_", mynothing, 10))
        s1 = str(s1.replace(":", mynothing, 10))
        s1 = str(s1.replace("-", mynothing, 10))
        s1 = str(s1.strip())
        p3 = re.compile(my_re_numeric, re.IGNORECASE)
        match3 = p3.search(s1)
        if not match3:
            sleep(60.0)
            return
        else:
            s3 = match3.group(0)
            s3 = str(s3)
            s3 = str(__strip_numerics(s3))
            s1 = str(s1.replace(s3, str("#" + s3), 1))
        new_title = str(str(s2) + " [" + str(s1) + "]")
        need_to_update_title = True
    my_re1 = "^.+\(.+[0-9]+[:-; ]+.+[0-9]+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        my_re_left =  "^.+\("
        my_re_right = "\(.+[0-9]+[:-; ]+.+[0-9]+\)"
        my_re_far_right = "[:-;]+.+[0-9]+\)"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
            s1 = str(s1.replace("(", mynothing, 1))
            s1 = str(s1.strip())
        s2 = str(tmp_title.replace(s1, mynothing, 1))
        s2 = str(s2.replace("(", mynothing, 4))
        s1 = str(titlecase(s1))
        s1 = str(s1.strip())
        p3 = re.compile(my_re_far_right, re.IGNORECASE)
        match3 = p3.search(tmp_title)
        if not match3:
            sleep(60.0)
            return
        else:
            s3 = match3.group(0)
            s3 = str(s3)
            s2 = str(s2.replace(s3, mynothing, 4))
            s2 = str(s2.replace(")", mynothing, 4))
            s2 = str(s2.replace(":", mynothing, 4))
            s2 = str(s2.replace("-", mynothing, 4))
            s2 = str(s2.replace(";", mynothing, 4))
            s2 = str(s2.replace("  ", " ", 4))
            s2 = str(s2.strip())
            s2 = str(titlecase(s2))
            new_title = str(str(s1) + " [" + str(s2) + "]")
            new_title = str(new_title.replace("  ", " ", 4))
            need_to_update_title = True
    if need_to_update_title:
        s1 = str(new_title)
    else:
        s1 = str(tmp_title)
    n1 = s1.count("Book One")
    if n1 > 0:
        s1 = str(s1.replace("Book One", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#1")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Two")
    if n1 > 0:
        s1 = str(s1.replace("Book Two", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#2")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Three")
    if n1 > 0:
        s1 = str(s1.replace("Book Three", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#3")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Four")
    if n1 > 0:
        s1 = str(s1.replace("Book Four", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#4")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Five")
    if n1 > 0:
        s1 = str(s1.replace("Book Five", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#5")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Six")
    if n1 > 0:
        s1 = str(s1.replace("Book Six", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#6")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Seven")
    if n1 > 0:
        s1 = str(s1.replace("Book Seven", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#7")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Eight")
    if n1 > 0:
        s1 = str(s1.replace("Book Eight", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#8")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Nine")
    if n1 > 0:
        s1 = str(s1.replace("Book Nine", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#9")
        new_title = str(s1)
        need_to_update_title = True
    n1 = s1.count("Book Ten")
    if n1 > 0:
        s1 = str(s1.replace("Book Ten", mynothing, 1))
        s1 = str(s1.strip())
        if s1.endswith(","):
            s1 = str(s1[0:-1])
            s1 = str(s1.strip())
        s1 = str(s1 + " " + "#10")
        new_title = str(s1)
        need_to_update_title = True
    my_re1 = "^.+:.+,\sBook\s[0-9.a-z ]+"
    my_re2 = "^.+:\sA\s.+\sNovella\s\(.+\)"
    my_re3 = "^.+:\sA\s.+\sNovel\s\(.+\)"
    my_re4 = "^.+:\sA\s.+\sBook\s\(.+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    p4 = re.compile(my_re4, re.IGNORECASE)
    match4 = p4.search(tmp_title)
    if ((not match1) and (not match2) and (not match3) and (not match4)) or need_to_update_title :
        pass
    elif (match2 or match3 or match4):
        nc = tmp_title.find(":")
        s1 = str(tmp_title[0:nc])
        np = tmp_title.find("(")
        s2 = str(tmp_title[np-1: ])
        s3 = str(s1 + " " + s2)
        tmp_title = str(s3)
        new_title = str(tmp_title.strip())
        need_to_update_title = True
    else:
        my_re_left =  "^.+:"
        my_re_right = ":.+,\sBook\s[0-9.a-z ]+"
        p1 = re.compile(my_re_left, re.IGNORECASE)
        match1 = p1.search(tmp_title)
        if not match1:
            sleep(60.0)
            return
        else:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
            s1 = str(s1.replace(":", mynothing, 2))
        s2 = str(tmp_title.replace(s1, mynothing, 1))
        s2 = str(s2.replace(":", mynothing, 1))
        s2 = str(s2.strip())
        s2 = str(s2.strip())
        n1 = s2.count("Novella")
        n2 = s2.count("Novel")
        if s2.startswith("A "):
            n3 = 1
        else:
            n3 = 0
        if n1 > 0:
            s2 = str(s2.replace("Novella", mynothing, 2))
        if n2 > 0:
            s2 = str(s2.replace("Novel", mynothing, 2))
        if n3 > 0:
            s2 = str(s2.replace("A ", mynothing, 1))
        s2 = str(s2.replace("Book", mynothing, 1))
        nc = s2.count(",")
        if nc > 0:
            s2 = str(s2.replace(",", "|", 1))
            tmp_list = s2.split("|")
            nr = len(tmp_list)
            if nr == 2:
                s_left = str(tmp_list[0])
                s_left = str(s_left.strip())
                s_right = str(tmp_list[1])
            if nr >= 3:
                s_left = str(tmp_list[0])
                s_left = str(s_left.strip())
                s_middle = str(tmp_list[1])
                s_right = str(tmp_list[2])
                if nr >= 4:
                    s_right = str(s_right + str(tmp_list[3]))
            if nr == 2:
                n1 = s_right.count(s_left)
                if n1 > 0:
                    s_right = str(s_right.replace(s_left, mynothing, 4))
                    s_right = str(s_right.strip())
                    s_right = str(__change_tuple_to_bytestring(s_right))
            if nr == 3:
                n1 = s_middle.count(s_left)
                n2 = s_right.count(s_left)
                if n1 > 0:
                    s_middle = str(s_middle.replace(s_left, mynothing, 4))
                    s_middle = str(s_middle.strip())
                if n2 > 0:
                    s_right = str(s_right.replace(s_left, mynothing, 4))
                    s_right = str(s_right.strip())
                    s_right = str(s_middle + " " + s_right)
                    s_right = str(__change_tuple_to_bytestring(s_right))
            new_title = str(str(s1) + " [" + str(s_left) + " " + "#" + str(s_right) + "]")
            new_title = str(__change_tuple_to_bytestring(new_title))
            need_to_update_title = True
    my_re1 = "^.+\s-\sArticles by [a-z]+\s[a-z]+"
    my_re2 = "^.+\s-\sby [a-z]+\s[a-z]+"
    my_re3 = "^.+\s-\sA Book by [a-z]+\s[a-z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    if ((not match1) and (not match2) and (not match3)) or need_to_update_title :
        pass
    else:
        if match1:
            tmp_title = str(tmp_title.replace("- Articles", mynothing, 1))
            series_valid_globally = True
        if match2:
            tmp_title = str(tmp_title.replace("-", mynothing, 1))
            series_valid_globally = True
        if match3:
            tmp_title = str(tmp_title.replace("- A Book", mynothing, 1))
            series_valid_globally = True
        n = tmp_title.find(" by ")
        tmp_auth = str(tmp_title[n: ])
        tmp_title = str(tmp_title[0:n])
        tmp_auth = str(tmp_auth.replace(" by ", mynothing, 1))
        tmp_auth = str(tmp_auth.strip())
        tmp_title = str(tmp_title.replace(" by ", mynothing, 1))
        tmp_title = str(tmp_title.strip())
        new_title = str(tmp_title)
        new_title = str(titlecase(new_title))
        need_to_update_title = True
        title_probably_good = True
        new_auth = str(tmp_auth)
        need_to_update_auth = True
        author_probably_good = True
    my_re1 = "^[a-z ]+:\sVolume One:\s[a-z ]+"
    my_re2 = "^[a-z ]+:\sVolume Two:\s[a-z ]+"
    my_re3 = "^[a-z ]+:\sVolume Three:\s[a-z ]+"
    my_re4 = "^[a-z ]+:\sVolume Four:\s[a-z ]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    p4 = re.compile(my_re4, re.IGNORECASE)
    match4 = p4.search(tmp_title)
    if ((not match1) and (not match2) and (not match3) and (not match4)) or need_to_update_title :
        pass
    else:
        if match1:
            tmp_title = str(tmp_title.replace(": Volume One:", " 1]", 1))
        if match2:
            tmp_title = str(tmp_title.replace(": Volume Two:", " 2]", 1))
        if match3:
            tmp_title = str(tmp_title.replace(": Volume Three:", " 3]", 1))
        if match4:
            tmp_title = str(tmp_title.replace(": Volume Four:", " 4]", 1))
        tmp_title = str("[" + str(tmp_title))
        need_to_update_title = True
        title_probably_good = False
        title_is_frozen = False
        new_title = str(tmp_title)
    my_re1 = "^[a-z ]+\s[IV]+\s-\s[a-z ]+\(Volume\s[0-9]+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:
        tmp_title = str(tmp_title[0:-11])
        tmp_title = str(tmp_title.replace(" I ", " 1]", 1))
        tmp_title = str(tmp_title.replace(" II ", " 2]", 1))
        tmp_title = str(tmp_title.replace(" III ", " 3]", 1))
        tmp_title = str(tmp_title.replace(" IV ", " 4]", 1))
        tmp_title = str(tmp_title.replace(" V ", " 5]", 1))
        tmp_title = str(tmp_title.replace(" VI ", " 6]", 1))
        tmp_title = str("[" + str(tmp_title))
        tmp_title = str(tmp_title.replace("-", mynothing, 1))
        tmp_title = str(tmp_title.replace("  ", " ", 4))
        need_to_update_title = True
        title_probably_good = False
        title_is_frozen = False
        new_title = str(tmp_title)
    my_re1 = "^.+\s-\s.+[0-9][0-9]*$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:
        tmp_list = tmp_title.split("-")
        tmp_title = str(tmp_list[0])
        s = str(tmp_list[1])
        s = str(s.strip())
        s = str(s.replace("0", mynothing, 2))
        tmp_series = str(" [" + str(s) + "]")
        tmp_title = str(str(tmp_title) + str(tmp_series))
        tmp_title = str(tmp_title.replace("-", mynothing, 4))
        tmp_title = str(tmp_title.replace("  ", " ", 4))
        need_to_update_title = True
        title_probably_good = False
        title_is_frozen = False
        new_title = str(tmp_title)
    my_re1 = "^Books of [a-z ]*\sVol[ume]*[.]*\s[0-9]+\s-\s[a-z ']+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:
        tmp_list = tmp_title.split("-")
        tmp_title = str(tmp_list[1])
        tmp_title = str(tmp_title.strip())
        s = str(tmp_list[0])
        s = str(s.replace("Volume", mynothing, 2))
        s = str(s.replace("Vol", mynothing, 2))
        s = str(s.replace(".", mynothing, 2))
        s = str(s.strip())
        tmp_series = str(" [" + str(s) + "]")
        tmp_title = str(str(tmp_title) + str(tmp_series))
        tmp_title = str(tmp_title.replace("-", mynothing, 4))
        tmp_title = str(tmp_title.replace("  ", " ", 4))
        need_to_update_title = True
        title_probably_good = False
        title_is_frozen = False
        new_title = str(tmp_title)
    my_re1 = "[(]Book\s[0-9]+[ ]of\sthe\s[a-z -]+\sseries[)]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_split = tmp_title.split(s1)
            s0 = str(s_split[0])
            s1 = str(s1.replace(" of the ", ": ", 2))
            s1 = str(s1.replace(" Series", mynothing, 2))
            tmp_title = str(str(s0) + " " + str(s1))
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    nc = tmp_title.find(":")
    ns = tmp_title.find("\\")
    nc1 = tmp_title.count(":")
    ns1 = tmp_title.count("\\")
    nd1 = tmp_title.count("-")
    nh1 = tmp_title.count("#")
    np1 = tmp_title.count("(")
    if nc1 == 0 or nc1 > 1 or (not ns1 > 1) or nd1 > 0 or nh1 > 0 or np1 > 0:
        pass
    else:
        if nc > 0 and ns > (nc + 2) :
            try:
                n = tmp_title.find(":")
                s1 = str(tmp_title[0:n])
                s1 = str("[" + str(s1) + "]")
                s2 = str(tmp_title[n+1: ])
                tmp_title = str(str(s2) + " " + str(s1))
                tmp_title = str(tmp_title.replace("\\", " & ", 10))
                tmp_title = str(tmp_title.replace("  ", " ", 4))
                tmp_title = str(tmp_title.strip())
                tmp_title = str(tmp_title.replace(" :", ":", 1))
                need_to_update_title = True
                title_probably_good = False
                title_is_frozen = False
                new_title = str(tmp_title)
            except:
                pass
        else:
            pass
    my_re1 = "^[0-9]+[)][ ]"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1)  or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(s1)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_split = tmp_title.split(s1)
            s0 = str(s_split[1])
            tmp_title = str(str(s0) )
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^(?P<g1>[a-z ]+[ ])[#][0-9]+[:][ ]+[a-z ]+[:][ ]+an[ ](?P=g1)[ ]*Novel$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = str(tmp_title)
            s1 = str(__change_tuple_to_bytestring(s1))
            n = s1.rfind(":")
            s2 = str(s1[0:n])
            if s2.endswith(":"):
                s2 = str(s2[0:-1])
            tmp_title = str(s2)
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z ]+[ ][1-9]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = str(tmp_title)
            s1 = str(__change_tuple_to_bytestring(s1))
            s2 = str(s1[-2: ])
            s2 = str(s2.strip())
            s1 = str(s1[0:-2])
            s1 = str(s1 + " 0" + s2)
            s1 = str(s1.strip())
            tmp_title = str("Series=" + s1)
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[series=]*[a-z ]+[0][1-9]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            n = s1.find("0")
            tmp_title = str(s1[ :n])
            tmp_title = str(tmp_title.replace("0",mynothing,1))
            tmp_title = str(tmp_title.replace("Series=",mynothing,1))
            tmp_title = str(tmp_title.replace("series=",mynothing,1))
            s1 = str(s1.replace("=",mynothing,1))
            tmp_title = str(tmp_title + " [" + s1 + "]")
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "\s[(][2][0-9][0-9][0-9][)]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            tmp_title = str(tmp_title.replace(s1,mynothing,1))
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "\s[(][1][9][0-9][0-9][)]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            tmp_title = str(tmp_title.replace(s1,mynothing,1))
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "[:]\sa[n]*\s[a-z ]+\sThriller$|[:]\sa[n]*\s[a-z ]+\sMystery$|[:]\sa[n]*\s[a-z ]+\sRomance$|[:]\sa[n]*\s[a-z ]+\sNovel$|[:]\sa[n]*\s[a-z ]+\sNovella$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            tmp_title = str(tmp_title.replace(s1,mynothing,1))
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z ]+[;][ ][a-z ]+[ ][0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            tmp_title = str(tmp_title.replace(";",":",1))
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z ]+[ ][[][0-9]+[]][ ][a-z -]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            tmp_title = str(tmp_title.replace("[",mynothing,1))
            tmp_title = str("[" + str(tmp_title))
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[0-9]+[ ][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            my_re1 = "^[0-9]+[ ]"
            p1 = re.compile(my_re1, re.IGNORECASE)
            match1 = p1.search(tmp_title)
            if (not match1):
                pass
            else:
                s1 = match1.group(0)
                s1 = str(__change_tuple_to_bytestring(s1))
                tmp_title = str(tmp_title.replace(s1,mynothing,1))
                tmp_title = str(tmp_title + " " + s1)
                tmp_title = str(tmp_title.replace("  ", " ", 4))
                tmp_title = str(tmp_title.strip())
                need_to_update_title = True
                title_probably_good = False
                title_is_frozen = False
                new_title = str(tmp_title)
        except:
            pass
    my_re1 = "[[][a][n]*[ ][a-z ]+[Novella][]]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s0 = str(s1)
            if s1.startswith("[An "):
                s1 = str(s1.replace("[An ", "[", 1))
            if s1.startswith("[A "):
                s1 = str(s1.replace("[A ", "[", 1))
            s1 = str(s1.replace("Novella", mynothing, 1))
            s1 = str(s1.replace("Novel", mynothing, 1))
            s1 = str(s1.replace("]", " #1]", 1))
            tmp_title = str(tmp_title.replace(s0, mynothing, 1))
            tmp_title = str(tmp_title + " " + s1)
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z ]+[:][a-z ]+[,][ ]*book[ ][0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s0 = str(s1)
            s_list = s0.split(":")
            s_left = str(s_list[0])
            s2 = str(s_list[1])
            s_list2 = s2.split(",")
            s_middle = str(s_list2[0])
            s_right = str(s_list2[1])
            s_right = str(s_right.strip())
            s_right = str(s_right.replace("Book"," ",1))
            s_right = str(s_right.replace("book"," ",1))
            s_right = str(s_right.strip())
            tmp_title = str(s_left + " [" + s_middle + " " + s_right + " ]")
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[a-z ]+[:][a-z ]+[:][ ]*$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_list = s1.split(":")
            s_left = str(s_list[0])
            s_right = str(s_list[1])
            s_right = str(s_right.strip())
            is_known = __check_title_substring_for_known_seriesname(my_db, my_cursor, s_right, my_current_book)
            if not is_known:
                tmp_title = str(s_left + ": " + s_right)
            else:
                tmp_title = str(s_left + " [" + s_right + " #1]")
                tmp_title = str(tmp_title.replace("  ", " ", 4))
                tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except Exception as e:
            pass
    my_re1 = "^[a-z ]+[:][ ]*the[a-z ]+series$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_list = s1.split(":")
            s_left = str(s_list[0])
            s_right = str(s_list[1])
            s_right = str(s_right.replace("The ", mynothing, 4))
            s_right = str(s_right.replace("the ", mynothing, 4))
            s_right = str(s_right.replace(" Series", mynothing, 4))
            s_right = str(s_right.replace(" series", mynothing, 4))
            s_right = str(s_right.strip())
            tmp_title = str(s_left + " [" + s_right + " #1]")
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except Exception as e:
            pass
    my_re1 = "^[0-9]+[ -][a-z ]+[-][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_list = s1.split("-")
            s_left = str(s_list[0])
            s_left = str(s_left.strip())
            s_middle = str(s_list[1])
            s_middle = str(s_middle.strip())
            s_right = str(s_list[2])
            s_right = str(s_right.replace("Stories", mynothing,2))
            s_right = str(s_right.replace("stories", mynothing,2))
            s_right = str(s_right.strip())
            tmp_title = str(s_middle + " [" + s_right + " #" + s_left + " ]")
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except Exception as e:
            pass
    my_re1 = "^[a-z ]+[:][ ]*[the]*[a-z ]+series[:][ ]*book[ ]+[0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_list = s1.split(":")
            s_left = str(s_list[0])
            s_left = str(s_left.strip())
            s_middle = str(s_list[1])
            s_middle = str(s_middle.strip())
            s_middle = str(s_middle.replace("Series", mynothing,2))
            s_middle = str(s_middle.replace("series", mynothing,2))
            s_middle = str(s_middle.strip())
            s_right = str(s_list[2])
            s_right = str(s_right.replace("Book", mynothing,2))
            s_right = str(s_right.replace("book", mynothing,2))
            s_right = str(s_right.strip())
            tmp_title = str(s_left + " [" + s_middle + " #" + s_right + " ]")
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except Exception as e:
            pass
    my_re1 = "^[a-z ]+[:][a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_split = s1.split(":")
            s_left = str(s_split[0])
            s_right = str(s_split[1])
            s_right = str(s_right.strip())
            is_known = __check_title_substring_for_known_seriesname(my_db, my_cursor, s_right, my_current_book)
            if not is_known:
                pass
            else:
                tmp_title = str(s_left + " [" + s_right + " #1]")
                tmp_title = str(tmp_title.replace("  ", " ", 4))
                tmp_title = str(tmp_title.strip())
                need_to_update_title = True
                title_probably_good = False
                title_is_frozen = False
                new_title = str(tmp_title)
        except:
            pass
    my_re1 = "^[0-9]+[ ]*[-][a-z ]+[:][a-z ]+[a-z][ ]*$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s1 = str(__change_tuple_to_bytestring(s1))
            s_list = s1.split("-")
            s_left = str(s_list[0])
            s_left = str(s_left.strip())
            s_right = str(s_list[1])
            s_list2 = s_right.split(":")
            s_middle = str(s_list2[0])
            s_middle = str(s_middle.strip())
            s_middle = str(s_middle.strip())
            s_right = str(s_list2[1])
            s_right = str(s_right.strip())
            tmp_title = str(s_middle + " [" + s_right + " #" + s_left + " ]")
            tmp_title = str(tmp_title.replace("  ", " ", 4))
            tmp_title = str(tmp_title.strip())
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except Exception as e:
            pass
    my_re1 = "^[\[][a-z ]+[0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if (not match1) or need_to_update_title :
        pass
    else:
        try:
            s1 = match1.group(0)
            s2 = s1
            s1 = s1 + " ]"
            s1 = s1.strip()
            my_re1 = "[0-9]+"
            p1 = re.compile(my_re1, re.IGNORECASE)
            match1 = p1.search(s1)
            s3 = match1.group(0)
            s2 = s2.replace(s3,"",1)
            s2 = s2.replace("[","",1)
            s2 = s2.strip()
            tmp_title = s2 + " " + s1
            tmp_title = tmp_title.replace(s3,"#"+s3,1)
            need_to_update_title = True
            title_probably_good = False
            title_is_frozen = False
            new_title = str(tmp_title)
        except:
            pass
    if (not need_to_update_title) and (not force_update):
        pass
    else:
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  new_title, my_current_book)
    if not need_to_update_auth:
        return
    else:
        author_probably_good = True
        tmp_id_rows = []
        del tmp_id_rows
        tmp_id_rows = []
        mysql = 'SELECT id from custom_column_4 WHERE value = "' + new_auth + '" '
        tmp_id_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if tmp_id_rows:
            tmp_id = tmp_id_rows[0]
            tmp_id = __strip_numerics(tmp_id)
            mysql = "UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  "
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_id, my_current_book)
        else:
            mysql = 'INSERT OR IGNORE INTO custom_column_4 (id,value) VALUES (null, "' + tmp_auth + '" ) ;'
            __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
            mysql = 'SELECT id from custom_column_4  WHERE value = "' + tmp_auth + '"  ;'
            tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
            if not tmp_auth_rows:
                return
            else:
                tmp_id = tmp_auth_rows[0]
                tmp_id = __strip_numerics(tmp_id)
            mysql = "DELETE FROM books_custom_column_4_link WHERE book = '" + my_current_book + "' ;"
            __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
            mysql = "INSERT  OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?)"
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_id)
def __check_title_substring_for_known_seriesname(my_db, my_cursor, s_substring, my_current_book):
    mysql = "SELECT Count(*)  WHERE \
                (   ? IN(SELECT name FROM _global_series) OR \
                    ? IN(SELECT name FROM _pristine_series) OR \
                    ? IN(SELECT value FROM custom_column_10 WHERE id <> ? ) OR \
                    ? IN(SELECT seriesname FROM _global_web_author_series)  )   "
    my_cursor.execute(mysql,(s_substring,s_substring,s_substring,my_current_book,s_substring))
    count1 = my_cursor.fetchall()
    count1 = __strip_numerics(count1)
    if count1 <> "0" and count1 <> "[0]":
        return True
    else:
        return False
def check_if_author_is_not_author_and_title_is_not_author(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_valid_globally
    global author_probably_good
    global title_probably_good
    global title_is_frozen
    if author_valid_globally:
        return
    if author_probably_good:
        return
    if title_is_frozen or title_probably_good:
        return
    mysql = "SELECT authname from  __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        tmp_auth = tmp_auth_rows[0]
    else:
        return
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    tmp_auth_rows = []
    del tmp_auth_rows
    tmp_title_rows = []
    del tmp_title_rows
    mysql = "SELECT booktitle from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        tmp_title = tmp_title_rows[0]
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    title_is_probably_a_title = False
    nt = tmp_title.count(" ")
    if nt > 2:
         title_is_probably_a_title = True
    else:
         pass
    try:
        s = str(tmp_title.lower())
    except:
        pass
    nt1 = tmp_title.find("A ")
    nt2 = s.find("the")
    nt3 = s.find(" an ")
    nt4 = s.find(" of ")
    nt5 = s.find(" a ")
    nt6 = tmp_title.find(":")
    nt7 = tmp_title.find(" - ")
    nt8 = tmp_title.find("#")
    nt9 = tmp_title.find("(")
    nt10 = tmp_title.find("[")
    nt11 = tmp_title.find("*")
    nt12 = tmp_title.find("1")
    nt13 = tmp_title.find("2")
    nt14 = s.find(" series ")
    nt15 = s.find(" book ")
    nt16 = s.find(" novel ")
    nt17 = s.find(" novella ")
    nt18 = tmp_title.find("3")
    nt19 = tmp_title.find(" & ")
    if nt1 >= 0 or nt2 >= 0 or nt3 >= 0 or nt4 >= 0 or nt5 >= 0 or nt6 >= 0 or nt7 >= 0 or nt8 >= 0 or nt9 >= 0 \
                       or nt10 >= 0 or nt11 >= 0 or nt12 >= 0 or nt13 >= 0  or nt14 >= 0  or nt15 >= 0 or nt16 >= 0  or nt17 >= 0 \
                       or nt18 >= 0 or nt19 >= 0 :
        title_is_probably_a_title = True
    else:
        pass
    auth_is_probably_an_auth = True
    nt = tmp_auth.count(" ")
    if nt > 2:
         auth_is_probably_an_auth = False
    else:
         pass
    try:
        s = str(tmp_auth.lower())
    except:
        pass
    nt1 = tmp_auth.find(" A ")
    nt2 = s.find(" the ")
    nt3 = s.find(" an ")
    nt4 = s.find(" of ")
    nt5 = s.find(" a ")
    nt6 = tmp_auth.find(":")
    nt7 = tmp_auth.find(" - ")
    nt8 = tmp_auth.find("#")
    nt9 = tmp_auth.find("(")
    nt10 = tmp_auth.find("[")
    nt11 = tmp_auth.find("*")
    nt12 = tmp_auth.find("1")
    nt13 = tmp_auth.find("2")
    nt14 = s.find(" series ")
    nt15 = s.find(" book ")
    nt16 = s.find(" novel ")
    nt17 = s.find(" novella ")
    nt18 = tmp_auth.find("3")
    if nt1 >= 0 or nt2 >= 0 or nt3 >= 0 or nt4 >= 0 or nt5 >= 0 or nt6 >= 0 or nt7 >= 0 or nt8 >= 0 or nt9 >= 0 \
                       or nt10 >= 0 or nt11 >= 0 or nt12 >= 0 or nt13 >= 0  or nt14 >= 0  or nt15 >= 0 or nt16 >= 0  or nt17 >= 0:
        auth_is_probably_an_auth = False
    else:
        pass
    if auth_is_probably_an_auth:
        return
    else:
        if title_is_probably_a_title:
            pass
        else:
            return
    s_auth = str(tmp_auth.lower())
    s_title = str(tmp_title.lower())
    na = s_auth.find(s_title)
    nt = s_title.find(s_auth)
    if nt >= 0:
        new_title = str(tmp_title)
    else:
        if na >= 0:
            new_title = str(tmp_auth )
        else:
            new_title = str(tmp_auth + " - " + tmp_title)
    new_auth = "_Unknown_"
    try:
        new_title = str(new_title.lower())
    except:
        pass
    new_title = str(titlecase(new_title))
    new_title = str(__change_tuple_to_bytestring(new_title))
    new_auth = str(__change_tuple_to_bytestring(new_auth))
    tmp_id_rows = []
    del tmp_id_rows
    tmp_id_rows = []
    mysql = "SELECT id from custom_column_4 WHERE value = '_Unknown_' "
    tmp_id_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_id_rows:
        tmp_id = tmp_id_rows[0]
        tmp_id = __strip_numerics(tmp_id)
        mysql = "UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  "
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_id, my_current_book)
    else:
        mysql = "INSERT OR IGNORE INTO custom_column_4 (id,value) VALUES (null, '_Unknown_') ;"
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        mysql = "SELECT id from custom_column_4  WHERE value = '_Unknown_' "
        tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_auth_rows:
            return
        else:
            tmp_id = tmp_auth_rows[0]
            tmp_id = __strip_numerics(tmp_id)
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = '" + my_current_book + "' ;"
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        mysql = "INSERT  OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?)"
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_id)
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, new_title, my_current_book)
    author_probably_good = True
    title_probably_good = False
def check_series_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log):
    global series_valid_globally
    global mynothing
    series_valid_globally = False
    mysql = 'SELECT seriesname from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_series_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_series_rows:
        for row in tmp_series_rows:
            for col in row:
                tmp_series =col
                if not tmp_series == None:
                    tmp_series = unicodedata.normalize('NFKD', tmp_series).encode('ascii', 'ignore')
                    tmp_series = str(tmp_series)
                    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
                    n = tmp_series.count('"')
                    if n > 0:
                        tmp_series = str(tmp_series.replace('"', mynothing, 10))
                    mysql = 'SELECT name from _global_series WHERE name = "' + tmp_series + '"  ;'
                    tmp_global_series_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
                    if tmp_global_series_rows:
                        series_valid_globally = True
                        break
                else:
                    pass
    else:
        pass
def scrub_title_is_author_index_series(my_db, my_cursor,  my_current_book, notifications, log): #fix:  "Drake, David - HS07 - the Sharp End"
    global author_valid_globally
    global author_probably_good
    global finished_scrub_title_index_series_in_title
    global mynothing
    global series_re_pattern_to_remove
    if author_valid_globally:
        return
    if author_probably_good:
        return
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    tmp_title_rows = []
    del tmp_title_rows
    mysql = 'SELECT booktitle from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title = str(row)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = str(tmp_title.replace("  ", " ", 4))
    tmp_title = tmp_title.strip()
    my_re1 = "^.+,[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    my_re2 = "^.+?\s.+?\s[-]\s[a-zA-Z]+[0-9]+\s[-]\s.+"
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    my_re3= "^.+,\s[a-zA-Z]+"
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    series_re_pattern_to_remove = str("-\s[a-z0-9]+\s-")
    if not match1 and not match2 and not match3:
        return
    if match1:
        match_type = "1"
    if match3:
        tmp_title = str(tmp_title.replace(", ", ",", 1))
        match_type = "1"
    if match2: #should have no comma if a true match2
        n1 = tmp_title.find(",")
        n2 = tmp_title.find("-")
        if  (n1 > 0) :
            if n1 < n2:
                match_type = "1"
            else:
                match_type = "2"
        else:
            match_type = "2"
    if match_type == "2":
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        tmp_title = str(tmp_title.replace("  ", " ", 10))
        s_tmp = str(tmp_title)
        s_list1 = s_tmp.split("-")
        s_tmp3 = str(s_list1[1])
        s_tmp3 = str(s_tmp3 + str(s_list1[2]) )
        s_tmp2 = s_list1[0] #so everything to the left of the first dash
        s_list2 = s_tmp2.split(" ")
        s_first = str(s_list2[0])
        s_last = str(s_list2[1])
        s_first = str(__change_tuple_to_bytestring(s_first))
        s_last = str(__change_tuple_to_bytestring(s_last))
        s_tmp3 = str(__change_tuple_to_bytestring(s_tmp3))
        s_new = str(s_tmp3)
        s_new = str(s_new.replace(s_last, mynothing, 2))
        s_new = str(s_new.replace(s_first, mynothing, 2))
        s_new = str(s_new.replace(s_tmp2, mynothing, 2))
        s_new = str(s_new.replace("  ", " ", 10))
        s_fullname = str(s_last + "," + s_first)
        tmp_title = str(s_fullname + " -" + s_new)
    else:
        pass
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    n = tmp_title.find(" ")
    if n > 0 :
        tmp_string = str(tmp_title[0:n])
        tmp_string = str(__change_tuple_to_bytestring(tmp_string))
        tmp_title = str(tmp_title.replace(tmp_string, mynothing, 1))
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    else:
        return
    orig_auth = str(tmp_string)
    s_split = tmp_string.split(",")
    n = len(s_split)
    if not n > 1:
        return
    else:
        for row in s_split:
            pass
        pass
    try:
        s_last = str(s_split[0])
        s_first = str(s_split[1])
    except:
        return
    s_last = str(titlecase(s_last))
    s_first = str(titlecase(s_first))
    s_last = str(__change_tuple_to_bytestring(s_last))
    s_first = str(__change_tuple_to_bytestring( s_first))
    tmp_auth = str(s_first + ' ' + s_last)
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    tmp_global_auth_rows = []
    del tmp_global_auth_rows
    tmp_auth_rows = []
    del tmp_auth_rows
    need_to_update_author = False
    mysql = 'SELECT name from _global_authors WHERE name = "' + tmp_auth + '"  ;'
    tmp_global_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_global_auth_rows:
        author_valid_globally = True
        need_to_update_author = True
    else:
        need_to_update_author = True
    if not need_to_update_author:
        return
    tmp_rows = []
    del tmp_rows
    mysql = 'SELECT authname,booktitle FROM __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        return
    else:
        n = len(tmp_rows)
        if n == 0:
            return
    w_auth = mynothing
    w_title = mynothing
    i = 0
    for row in tmp_rows:
        for col in row:
            if i == 0:
                w_auth = str(col)
                i = i + 1
            else:
                w_title = str(col)
                break
        break
    w_title = str(__change_tuple_to_bytestring(w_title))
    w_auth = str(__change_tuple_to_bytestring(w_auth))
    w_new_title = str(w_title)
    w_new_title = str(w_new_title.replace(tmp_auth, mynothing, 4))
    w_new_title = str(w_new_title.replace(s_first, mynothing, 4))
    w_new_title = str(w_new_title.replace(s_last, mynothing, 4))
    w_new_title = str(w_new_title.replace(orig_auth, mynothing, 4))
    w_new_title = str(w_new_title.replace("  ", " ", 8))
    n1 = w_new_title.find("-")
    w_new_title = str(w_new_title[n1: ])
    w_new_title = str(w_auth + " " + w_new_title)
    w_new_title = str(w_new_title.replace("  ", " ", 8))
    w_new_title = str(__change_tuple_to_bytestring(w_new_title))
    x_list = w_new_title.split("-")
    if not x_list:
        pass
    else:
        n = len(x_list)
        if n > 1:
            sx0 = str(x_list[0])
            sx0 = str(sx0.strip())
            sx1 = str(x_list[1])
            sx1 = str(sx1.strip())
            if sx0 == sx1:
                w_new_title = str(__change_tuple_to_bytestring(sx0))
            else:
                pass
        else:
            pass
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_auth, my_current_book)
    author_probably_good = True
    if str(w_new_title) <> mynothing:
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, w_new_title, my_current_book)
    else:
        log("ERROR [1] in scrub_title_is_author_index_series(my_db, my_cursor,  my_current_book, notifications, log): Notify Developer.  Thank you.")
        pass
    check_author_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
    finished_scrub_title_index_series_in_title = False
    scrub_title_index_series_in_title(my_db, my_cursor, my_current_book, notifications, log)
def scrub_title_is_author_series_index(my_db, my_cursor,  my_current_book, notifications, log): #fix: "David Drake - Hammer's Slammers 07"
    global author_valid_globally
    global author_probably_good
    global finished_scrub_title_series_index_in_title
    global mynothing
    if author_valid_globally:
        return
    if author_probably_good:
        return
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    tmp_title_rows = []
    del tmp_title_rows
    mysql = 'SELECT booktitle from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title = str(row)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = str(tmp_title.replace("  ", " ", 4))
    tmp_title = tmp_title.strip()
    my_re1 = "^.+,[a-zA-Z]+.+-[ 'a-zA-Z]+[0-9]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    my_re2 = "^.+[a-zA-Z]\s.+[a-zA-Z]+\s-[ 'a-zA-Z]+[0-9]+"
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    my_re3= "^.+,[ a-zA-Z]+.+-[ 'a-zA-Z]+[0-9]+"
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(tmp_title)
    if not match1 and not match2 and not match3:
        return
    if match1:
        match_type = "1"
    if match3:
        tmp_title = str(tmp_title.replace(", ", ",", 1))
        match_type = "1"
    if match2: #should have no comma if a true match2
        n1 = tmp_title.find(",")
        n2 = tmp_title.find("-")
        if  (n1 > 0) :
            if n1 < n2:
                match_type = "1"
            else:
                match_type = "2"
        else:
            match_type = "2"
    if match_type == "2":
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        tmp_title = str(tmp_title.replace("  ", " ", 10))
        s_tmp = str(tmp_title)
        s_list1 = []
        del s_list1
        s_list1 = s_tmp.split("-")
        s_tmp3 = str(s_list1[1])
        s_tmp2 = s_list1[0] #so everything to the left of the first dash
        s_list2 = s_tmp2.split(" ")
        s_first = str(s_list2[0])
        s_last = str(s_list2[1])
        s_first = str(__change_tuple_to_bytestring(s_first))
        s_last = str(__change_tuple_to_bytestring(s_last))
        s_tmp3 = str(__change_tuple_to_bytestring(s_tmp3))
        s_new = str(s_tmp3)
        s_new = str(s_new.replace(s_last, mynothing, 2))
        s_new = str(s_new.replace(s_first, mynothing, 2))
        s_new = str(s_new.replace(s_tmp2, mynothing, 2))
        s_new = str(s_new.replace("  ", " ", 10))
        s_fullname = str(s_last + "," + s_first)
        tmp_title = str(s_fullname + " -" + s_new)
    else:
        pass
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    n = tmp_title.find(" ")
    if n > 0 :
        tmp_string = str(tmp_title[0:n])
        tmp_string = str(__change_tuple_to_bytestring(tmp_string))
        tmp_title = str(tmp_title.replace(tmp_string, mynothing, 1))
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    else:
        return
    orig_auth = str(tmp_string)
    s_split = tmp_string.split(",")
    n = len(s_split)
    if not n > 1:
        return
    else:
        for row in s_split:
            pass
        pass
    try:
        s_last = str(s_split[0])
        s_first = str(s_split[1])
    except:
        return
    s_last = str(titlecase(s_last))
    s_first = str(titlecase(s_first))
    s_last = str(__change_tuple_to_bytestring(s_last))
    s_first = str(__change_tuple_to_bytestring( s_first))
    tmp_auth = str(s_first + ' ' + s_last)
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    tmp_global_auth_rows = []
    del tmp_global_auth_rows
    tmp_auth_rows = []
    del tmp_auth_rows
    need_to_update_author = False
    mysql = 'SELECT name from _global_authors WHERE name = "' + tmp_auth + '"  ;'
    tmp_global_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_global_auth_rows:
        author_valid_globally = True
        need_to_update_author = True
    else:
        need_to_update_author = True
    if not need_to_update_author:
        return
    tmp_rows = []
    del tmp_rows
    mysql = 'SELECT authname,booktitle FROM __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        return
    else:
        n = len(tmp_rows)
        if n == 0:
            return
    w_auth = mynothing
    w_title = mynothing
    i = 0
    for row in tmp_rows:
        for col in row:
            if i == 0:
                w_auth = str(col)
                i = i + 1
            else:
                w_title = str(col)
                break
        break
    w_title = str(__change_tuple_to_bytestring(w_title))
    w_auth = str(__change_tuple_to_bytestring(w_auth))
    w_new_title = str(w_title)
    w_new_title = str(w_new_title.replace(tmp_auth, mynothing, 4))
    w_new_title = str(w_new_title.replace(s_first, mynothing, 4))
    w_new_title = str(w_new_title.replace(s_last, mynothing, 4))
    w_new_title = str(w_new_title.replace(orig_auth, mynothing, 4))
    w_new_title = str(w_new_title.replace("  ", " ", 8))
    n1 = w_new_title.find("-")
    w_new_title = str(w_new_title[n1: ])
    w_new_title = str(w_auth + " " + w_new_title)
    w_new_title = str(w_new_title.replace("  ", " ", 8))
    w_new_title = str(__change_tuple_to_bytestring(w_new_title))
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_auth, my_current_book)
    author_probably_good = True
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, w_new_title, my_current_book)
    check_author_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
    finished_scrub_title_series_index_in_title = False
    scrub_title_series_index_in_title(my_db, my_cursor, my_current_book, notifications, log)
def scrub_first_first_author(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    mysql = "SELECT authname from  __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            for col in row:
                tmp_auth = col
                break
            break
    else:
        return
    try:
        tmp_auth = unicodedata.normalize('NFKD', tmp_auth).encode('ascii', 'ignore')
    except:
        tmp_auth = str(tmp_auth)
    force_update_author = False
    force_update_title = False
    n = tmp_auth.count('"')
    if n > 0:
        tmp_auth = str(tmp_auth.replace('"', mynothing, 10))
        force_update_author = True
    n = tmp_auth.count('|')
    if n > 0:
        tmp_auth = str(tmp_auth.replace('|', ",", 10))
        force_update_author = True
    if tmp_auth.startswith(";") or tmp_auth.startswith(",") :
        tmp_auth = str(tmp_auth[1: ])
        force_update_author = True
    ns = tmp_auth.find(';')
    if ns > 0:
        tmp_auth = str(tmp_auth[0:ns])
        tmp_auth = str(tmp_auth.replace(';', mynothing, 1))
        force_update_author = True
    nl = tmp_auth.count("(")
    nr = tmp_auth.count(")")
    if nl <> nr:
        tmp_auth = str(tmp_auth.replace("(", mynothing, 10))
        tmp_auth = str(tmp_auth.replace(")", mynothing, 10))
        force_update_author = True
    nl = tmp_auth.count("[")
    nr = tmp_auth.count("]")
    if nl <> nr:
        tmp_auth = str(tmp_auth.replace("[", mynothing, 10))
        tmp_auth = str(tmp_auth.replace("]", mynothing, 10))
        force_update_author = True
    nl = tmp_auth.count("{")
    nr = tmp_auth.count("}")
    if nl <> nr:
        tmp_auth = str(tmp_auth.replace("{", mynothing, 10))
        tmp_auth = str(tmp_auth.replace("}", mynothing, 10))
        force_update_author = True
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    orig_title = str(tmp_auth)
    nw = tmp_auth.count("ikipedia")
    if nw > 0:
        tmp_auth = str("Unknown")
        force_update_author = True
    if tmp_auth == "Anthology" :
        tmp_auth = str("Unknown")
        force_update_author = True
    if tmp_auth == "Release: storemags & fantamag" :
        tmp_auth = str("Magazines")
        force_update_author = True
    if tmp_auth.endswith(","):
        tmp_auth = str(tmp_auth[0:-1])
        tmp_auth = str(tmp_auth.strip())
        force_update_author = True
    if tmp_auth.startswith(","):
        tmp_auth = str(tmp_auth[1: ])
        tmp_auth = str(tmp_auth.strip())
        force_update_author = True
    my_re1 = "^[A-Z ]+$"
    p1 = re.compile(my_re1)
    match1 = p1.search(tmp_auth)
    if match1:
        try:
            tmp_auth = str(tmp_auth.lower())
            tmp_auth = str(titlecase(tmp_auth))
            force_update_author = True
        except:
            tmp_auth = str(titlecase(tmp_auth))
            force_update_author = True
    my_re1 = "^[a-z ]+[-]\s[a-z 0-9]+[-][a-z ]+$"
    p1 = re.compile(my_re1,re.IGNORECASE)
    match1 = p1.search(tmp_auth)
    if match1:
        n = tmp_auth.find("-")
        tmp_title = str(tmp_auth[n: ])
        if tmp_title.startswith("-"):
            tmp_title = str(tmp_title[1: ])
        tmp_title = str(tmp_title.strip())
        tmp_auth = str(tmp_auth[0:n])
        tmp_auth = str(tmp_auth.replace("-", mynothing, 1))
        tmp_auth = str(tmp_auth.strip())
        force_update_title = True
    my_re1 = "^[a-z]+,\s[a-z]+\s-\s[a-z ]+\s[/(][a-z ]+[#]*[0-9 ]+[/)]$"
    p1 = re.compile(my_re1,re.IGNORECASE)
    match1 = p1.search(tmp_auth)
    if match1:
        n = tmp_auth.find("-")
        tmp_title = str(tmp_auth[n: ])
        if tmp_title.startswith("-"):
            tmp_title = str(tmp_title[1: ])
        tmp_title = str(tmp_title.strip())
        tmp_auth = str(tmp_auth[0:n])
        tmp_auth = str(tmp_auth.replace("-", mynothing, 1))
        tmp_auth = str(tmp_auth.strip())
        force_update_title = True
    if (not force_update_title) and (not force_update_author):
        return
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_auth, my_current_book)
    if force_update_title:
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_title, my_current_book)
def fix_author_name_null(my_db, my_cursor,log):
    sleep(0.05)
    mysql = "DELETE FROM custom_column_4 WHERE value = null "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "DELETE FROM books_custom_column_4_link WHERE value NOT IN (SELECT id FROM custom_column_4 WHERE id > '0')"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "INSERT OR REPLACE INTO custom_column_4 SELECT book,name FROM __book_author_name_sort WHERE name not null\
                                               AND book NOT IN (SELECT book FROM books_custom_column_4_link WHERE book > '0' ) ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "INSERT or IGNORE INTO books_custom_column_4_link SELECT book,book,book FROM __book_author_name_sort \
                                                 WHERE book NOT IN (SELECT book FROM books_custom_column_4_link WHERE book > '0' );"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = 'UPDATE custom_column_8 SET value = "?" WHERE value = ""  '
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.02)
    mysql = "DELETE FROM books_custom_column_4_link WHERE book IN(SELECT book FROM __books_work_populate \
                                                                                            WHERE authname NOT NULL AND booktitle IS NULL \
                                                                                            AND seriesname  IS NULL AND seriesindex  IS NULL \
                                                                                            AND seriesfull  IS NULL AND tagsall  IS NULL)"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "DELETE FROM custom_column_4 WHERE id NOT IN(SELECT value FROM books_custom_column_4_link WHERE id > '0')"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
def scrub_author_name_goofy(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_valid_globally
    global author_probably_good
    global author_in_title
    global title_in_author
    global series_in_author
    global series_in_title
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global author_is_really_title
    global title_probably_good
    if author_valid_globally:
        return
    if author_probably_good:
        return
    scrub_isbn_in_author(my_db, my_cursor,  my_current_book, notifications, log)
    s = mynothing
    auth_list = []
    bstr_s = ""
    mysql = "SELECT authname from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
       for row in tmp_auth_rows:
            bstr_s = str(row)
            bstr_s = str(__change_tuple_to_bytestring(bstr_s))
            bstr_s = str(bstr_s.strip())
            bstr_s = str(bstr_s.replace(",", mynothing, 4))
            if bstr_s == str(mynothing) :
                bstr_s = "_Unknown_"
            break
    else:
        return
    s_new_author_name = "tobedetermined"
    author_not_author = False
    author_needs_updating = False
    s = str(bstr_s)
    s = str(__change_tuple_to_bytestring(s))
    if set(s).issubset(set_of_symbols):
        author_needs_updating = True
        s_new_author_name = "_Unknown_"
    else:
        if set(s).issubset(set_of_numbers):
            author_needs_updating = True
            s_new_author_name = "_Unknown_"
        else:
            if set(s).issubset(set_of_numbers_and_symbols):
                author_needs_updating = True
                s_new_author_name = "_Unknown_"
            else:
                pass
    if s_new_author_name <> "tobedetermined":
        s = str(s_new_author_name)
        s = str(s.strip())
    n = s.count(".")
    if n > 3:
        s = s.replace(".", mynothing, 50)
        s_new_author_name = str(s)
        s = str(s_new_author_name)
        author_needs_updating = True
    n = s.count("kindle@")
    if n > 0:
        s_new_author_name = "_Unknown_"
        s = str(s_new_author_name)
        author_needs_updating = True
    n = s.count("@")
    if n > 0 and ((s.endswith(".com")  or s.endswith(".net")) ):
        s_new_author_name = "_Unknown_"
        s = str(s_new_author_name)
        author_needs_updating = True
    n = s.count("http://")
    if n > 0:
        s_new_author_name = "_Unknown_"
        s = str(s_new_author_name)
        author_needs_updating = True
    if s == '_'  or s == '__'  or s == '___':
        s_new_author_name = "_Unknown_"
        s = str(s_new_author_name)
        author_needs_updating = True
    if s == 'admin'  or s == 'Admin'  or s == 'ADMIN':
        s_new_author_name = "_Unknown_"
        s = str(s_new_author_name)
        author_needs_updating = True
    n1 = s.count("Edited by")
    n2 = s.count("edited by")
    if n1 > 0 or n2 > 0:
        s = str(s.replace("edited by", "Edited by", 1))
        s_new_author_name = str(s)
        author_needs_updating = True
        author_probably_good = True
        author_not_author = False
    n1 = s.count("(retail)")
    n2 = s.count(" retail ")
    n3 = s.count("(pdf)")
    n4 = s.count("pdf")
    n5 = s.count(" ")
    n6 = s.count("-")
    n7 = s.count(":")
    if n1 > 0 or n2 > 0 or n3 > 0 or n4 > 0:
        author_needs_updating = True
        s = str(s.replace("(retail)", mynothing, 1))
        s = str(s.replace(" retail ", mynothing, 1))
        s = str(s.replace("(pdf)", mynothing, 1))
        s = str(s.replace("pdf", mynothing, 1))
        s_new_author_name = str(s)
    if n5 > 3 and (n6 > 0 or n7 > 0):
        author_is_really_title = True
        author_not_author = True
        s_new_author_name = str(s)
    n1 = s.count(" (ed)")
    if n1 > 0:
        s = str(s.replace(" (ed)", mynothing, 1))
        s_new_author_name = str(s)
        author_needs_updating = True
    n1 = s.count("(v1.0)")
    if n1 > 0:
        s = str(s.replace("(v1.0)", mynothing, 1))
        s_new_author_name = str(s)
        author_needs_updating = True
    n1 = s.count("-")
    if n1 == 0:
        pass
    else:
        bstr_s = ""
        mysql = "SELECT booktitle from __books_work_populate WHERE book = '" + my_current_book + "' ;"
        tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if tmp_title_rows:
           for row in tmp_title_rows:
                bstr_s = str(row)
                bstr_s = str(__change_tuple_to_bytestring(bstr_s))
                tmp_title = str(bstr_s.strip())
                break
        else:
            tmp_title = mynothing
        n1 = s.count(tmp_title)
        if n1 > 0:
            s = str(s.replace(tmp_title, mynothing, 1))
            s = str(s.replace("-", mynothing, 1))
            s = str(s.replace("  ", " ", 10))
            s_new_author_name = str(__change_tuple_to_bytestring(s))
            s_new_author_name = str(s_new_author_name.strip())
            author_not_author = False
            author_needs_updating = True
            author_is_really_title = False
            title_probably_good = True
    if (not author_needs_updating):
        if  s_new_author_name == "tobedetermined" :
            return
        else:
            pass
    s_new_author_name = str(__change_tuple_to_bytestring(s_new_author_name))
    s_new_author_name = str(s_new_author_name.strip())
    mysql = 'UPDATE custom_column_4 SET value = ? WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = ?  ) ;'
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, s_new_author_name, my_current_book)
    if not author_not_author:
        author_probably_good = True
    if author_is_really_title:
        author_probably_good = False
        s_bad_author_name = str(s_new_author_name)
        move_author_to_title(my_db, my_cursor,  my_current_book, notifications, log, s_bad_author_name)
    scrub_isbn_in_title(my_db, my_cursor,  my_current_book, notifications, log)
def move_author_to_title(my_db, my_cursor,  my_current_book, notifications, log, s_bad_author_name):
    global author_is_really_title
    global mynothing
    global author_probably_good
    if not author_is_really_title:
        return
    tmp_auth = str(s_bad_author_name)
    tmp_auth = __change_tuple_to_bytestring(tmp_auth)
    tmp_title_rows = []
    del tmp_title_rows
    mysql = "SELECT booktitle from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        tmp_title = str(tmp_title_rows[0])
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    else:
        tmp_title = str(mynothing)
    tmp_title = str(tmp_title + "  " + tmp_auth)
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    sleep(0.05)
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_title, my_current_book)
    s_unknown = str("__Unknown__")
    author_probably_good = False
    mysql = "SELECT id from custom_column_4 WHERE value = '" + s_unknown + "' ;"
    tmp_id_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_id_rows:
        tmp_id = tmp_id_rows[0]
        tmp_id = __strip_numerics(tmp_id)
        sleep(0.02)
        mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?   ;'
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_id, my_current_book)
    else:
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES (?,?)"
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, None, s_unknown)
        sleep(0.02)
        mysql = 'SELECT id from custom_column_4  WHERE value = "' + s_unknown + '" ;'
        tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_auth_rows:
            return
        else:
            tmp_id = str(tmp_auth_rows[0])
            tmp_id = __strip_numerics(tmp_id)
        sleep(0.02)
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = '" + my_current_book + "' ;"
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?) "
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_id)
        sleep(0.02)
def scrub_switched_author_title(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_valid_globally
    global author_probably_good
    global author_in_title
    global title_in_author
    global series_in_author
    global series_in_title
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global title_is_frozen
    if author_valid_globally:
        return
    if author_probably_good:
        return
    if title_is_frozen:
        return
    tmp_auth_rows = []
    del tmp_auth_rows
    mysql = "SELECT authname from  __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        tmp_auth = tmp_auth_rows[0]
    else:
        return
    tmp_auth = __change_tuple_to_bytestring(tmp_auth)
    tmp_auth_rows = []
    del tmp_auth_rows
    tmp_title_rows = []
    del tmp_title_rows
    mysql = "SELECT booktitle from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        tmp_title = tmp_title_rows[0]
    else:
        tmp_title = "IGNORE_ME"
    tmp_auth = tmp_auth.replace(".", mynothing, 20)
    tmp_auth = tmp_auth.replace(",", mynothing, 20)
    if set(tmp_auth).issubset(set_of_letters) :
        return
    else:
        if set(tmp_auth).issubset(set_of_letters_and_author_symbols):
            if set(tmp_title).issubset(set_of_title_characters):
                return
            else:
                pass
        else:
            pass
    author_in_title = False
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    na = tmp_auth.count(" ")
    nt = tmp_title.count(" ")
    if (na == 1 or na == 2) and (nt == 0 or nt > 2):
        return
    try:
        s = str(tmp_title.lower())
    except:
        pass
    nt1 = tmp_title.find("A ")
    nt2 = s.find("the")
    nt3 = s.find(" an ")
    nt4 = s.find(" of ")
    nt5 = s.find(" a ")
    nt6 = tmp_title.find(":")
    nt7 = tmp_title.find(" - ")
    nt8 = tmp_title.find("#")
    nt9 = tmp_title.find("(")
    nt10 = tmp_title.find("[")
    nt11 = tmp_title.find("*")
    nt12 = tmp_title.find("1")
    nt13 = tmp_title.find("2")
    nt14 = s.find(" series ")
    nt15 = s.find(" book ")
    nt16 = s.find(" novel ")
    nt17 = s.find(" novella ")
    nt18 = tmp_title.find("3")
    if nt1 >= 0 or nt2 >= 0 or nt3 >= 0 or nt4 >= 0 or nt5 >= 0 or nt6 >= 0 or nt7 >= 0 or nt8 >= 0 or nt9 >= 0 \
                       or nt10 >= 0 or nt11 >= 0 or nt12 >= 0 or nt13 >= 0  or nt14 >= 0  or nt15 >= 0 or nt16 >= 0  or nt17 >= 0:
        return
    else:
        pass
    tmp_auth_rows = []
    del tmp_auth_rows
    if tmp_title <> "IGNORE_ME":
        tmp_title = __change_tuple_to_bytestring(tmp_title)
        tmp_title = tmp_title.replace(",", mynothing, 2)
        mysql = 'SELECT book from __book_author_name_sort WHERE name = "' + tmp_title + '" ;'
        tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if tmp_auth_rows:
            n = len(tmp_auth_rows)
            if n > 0:
                author_in_title = True
                tmp_auth = str(tmp_title)
                tmp_auth = __change_tuple_to_bytestring(tmp_auth)
            else:
                pass
        else:
            pass
    else:
        pass
    if tmp_title <> "IGNORE_ME":
        tmp_title = __change_tuple_to_bytestring(tmp_title)
        mysql = 'SELECT name from _global_authors WHERE name = "' + tmp_title + '" ;'
        tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if tmp_auth_rows:
            n = len(tmp_auth_rows)
            if n > 0:
                author_in_title = True
                tmp_auth = tmp_auth_rows[0]
            else:
                pass
        else:
            pass
    else:
        pass
    mysql = "SELECT authname from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_auth_rows:
        return
    else:
        tmp_auth = tmp_auth_rows[0]
        tmp_auth = __change_tuple_to_bytestring(tmp_auth)
        tmp_auth = tmp_auth.replace(",", mynothing, 2)
    if set(tmp_title).issubset(set_of_letters_and_author_symbols) :
        if not set(tmp_auth).issubset(set_of_letters_and_author_symbols) :
            author_in_title = True
    else:
        pass
    if not author_in_title:
        return
    else:
        pass
    c_work_author_table = "custom_column_4"
    l_work_author_table = "books_custom_column_4_link"
    c_work_title_table = "custom_column_8"
    l_work_title_table = "books_custom_column_8_link"
    tmp_id_rows = []
    del tmp_id_rows
    tmp_id_rows = []
    mysql = 'SELECT id from custom_column_4 WHERE value = "' + tmp_title + '" ;'
    tmp_id_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_id_rows:
        tmp_id = tmp_id_rows[0]
        tmp_id = __strip_numerics(tmp_id)
        mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?   ;'
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_id, my_current_book)
    else:
        mysql = "INSERT OR REPLACE INTO custom_column_4 (id,value) VALUES (?,?)"
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, None, tmp_title)
        mysql = 'SELECT id from custom_column_4  WHERE value = "' + tmp_title + '" ;'
        tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_auth_rows:
            return
        else:
            tmp_id = tmp_auth_rows[0]
            tmp_id = __strip_numerics(tmp_id)
        mysql = "DELETE FROM books_custom_column_4_link WHERE book = '" + my_current_book + "' ;"
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        mysql = "INSERT OR REPLACE INTO books_custom_column_4_link (id, book, value) VALUES (null,?,?) "
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_id)
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_auth, my_current_book)
def scrub_series_substring(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_valid_globally
    global series_valid_globally
    global author_in_title
    global title_in_author
    global series_in_author
    global series_in_title
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global set_of_re_metacharacters
    global seriesindex_probably_good
    global title_probably_good
    global title_is_frozen
    global partial_blankout_scenario
    if title_probably_good and title_is_frozen:
        return
    if partial_blankout_scenario:
        return
    series = ""
    title = ""
    series_index = ""
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT booktitle, seriesname, seriesindex from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            title, series, series_index = row
    else:
        return
    title = __change_tuple_to_bytestring(title)
    series = __change_tuple_to_bytestring(series)
    series_index = __change_tuple_to_bytestring(series_index)
    series_index = series_index.replace(",", mynothing, 4)
    if series == mynothing:
        return
    else:
        if title == mynothing:
            return
        else:
            pass
    a = series
    b = title
    x = __similar(a,b)
    if not x >= 0.50 :
        return
    else:
        pass
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("/", "&", 1))
    s_string = str(title)
    n_start = 999
    n_end = 999
    s_string, n_start, n_end = __find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start <> 999 and n_end <> 999:
        s_number = str(s_string[n_start:n_end])
        tmp_index = str(s_number)
        tmp_index = __strip_numerics(tmp_index)
        title = str(title.replace(series, mynothing, 4) )
        series = str(series.replace(tmp_index, mynothing, 1))
        title = str(title.replace(tmp_index, mynothing, 1))
        series_index = __strip_numerics(tmp_index)
        mysql = "INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES (?,?,?)"
        __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book, series_index)
        seriesindex_probably_good = True
    else:
        pass
    backup_title = str(title)
    title = str(title.replace(series, mynothing, 4))
    title = str(title.replace(series_index, mynothing, 1))
    if not title > " ":
        title = str(backup_title)
    s0 = str(series_index)
    s0 = s0.replace(".0", mynothing, 10)
    n1 = s0.find("0")
    if n1 == 0:
        s0 = s0[1: ]
    s0 = s0.replace("0", mynothing, 10)
    series_index = s0
    s1 = series_index
    s2 = "0" + s1
    s3 = s1 + ":"
    s4 = s2 + ":"
    s5 = s1 + " -"
    s6 = s1 + "-"
    s7 = s2 + " -"
    s8 = s2 + "-"
    title = title.replace(s7, mynothing, 2)
    title = title.replace(s8, mynothing, 2)
    title = title.replace(s4, mynothing, 2)
    title = title.replace(s2, mynothing, 2)
    title = title.replace(s5, mynothing, 2)
    title = title.replace(s6, mynothing, 2)
    title = title.replace(s3, mynothing, 2)
    title = title.replace(s1, mynothing, 2)
    title = title.replace("()", mynothing, 4)
    title = title.replace("  ", " ", 4)
    n = title.find(" ")
    if n == 0: #leading space
        l = len(title)
        if l > 0:
            title = title[1: ]
        else:
            title = "None - Blank [1]"
    else:
        l = len(title)
        if l > 0:
            pass
        else:
            title = "None - Blank [2]"
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, title, my_current_book)
def scrub_author_good_but_author_also_in_title(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    mysql = "SELECT authname, booktitle from  __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            tmp_auth, tmp_title = row
            break
    else:
        return
    tmp_auth = str(__change_tuple_to_bytestring(tmp_auth))
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    orig_title = str(tmp_title)
    n_orig1 = len(tmp_title)
    my_re1 = "^[a-z ]+['][s]\s"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    my_re1 = "^[a-z]+[,][ ][a-z][.]*[ ][a-z][.]*[ ]"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        nd = tmp_auth.count(".")
        if nd > 2:
            pass
        else:
            s_auth_list = tmp_auth.split(" ")
            n = len(s_auth_list)
            if n == 1:
                s0 = str(s_auth_list[0])
                s0 = str(s0.replace(".", mynothing, 5))
                na = tmp_title.count(str(s0))
                if na == 0:
                    return
            if n == 2:
                s0 = str(s_auth_list[0])
                nd = s0.count(".")
                if nd > 0:
                    pass
                    f_similarity  =  __similar(str(orig_title), str(tmp_auth))
                    if f_similarity < .175 :
                        return
                    n = orig_title.count(" ")
                    if n < 3:
                        return
                else:
                    s0 = str(s0.replace(".", mynothing, 5))
                    s1 = str(s_auth_list[1])
                    s1 = str(s1.replace(".", mynothing, 5))
                    na = tmp_title.count(str(s0))
                    nb = tmp_title.count(str(s1))
                    if na == 0 and nb == 0:
                        return
            if n == 3:
                s0 = str(s_auth_list[0])
                nd = s0.count(".")
                if nd > 0:
                    pass
                else:
                    s0 = str(s0.replace(".", mynothing, 5))
                    s1 = str(s_auth_list[1])
                    s1 = str(s1.replace(".", mynothing, 5))
                    s2 = str(s_auth_list[2])
                    s2 = str(s2.replace(".", mynothing, 5))
                    na = tmp_title.count(str(s0))
                    nc = tmp_title.count(str(s2))
                    if na == 0 and nc == 0:
                        return
    else:
        s = str(match1.group(0))
        tmp_title = str(tmp_title.replace(str(s), mynothing, 1))
        tmp_title = str(tmp_title.strip())
        pass
    s = str(tmp_auth.replace(".", " ", 10))
    n = tmp_title.find(str(s))
    if n == 0:
        l = len(s)
        tmp_title = str(tmp_title[l: ])
        tmp_title = str(tmp_title.strip())
    tmp_title = str(tmp_title.replace(tmp_auth, mynothing, 1))
    tmp_title = str(tmp_title.strip())
    a = str(tmp_auth)
    a_split = a.split(" ")
    n1 = len(a_split)
    if n1 == 2:
        b = str(a_split[1] + " " + a_split[0])
        tmp_title = tmp_title.replace(b, mynothing, 1)
        b = str(a_split[1] + ", " + a_split[0])
        tmp_title = tmp_title.replace(b, mynothing, 1)
    else:
        if n1 == 3:
            b = str(a_split[2] + " " + a_split[0]  + " " + a_split[1]) #  Washington George Burt
            tmp_title = tmp_title.replace(b, mynothing, 1)
            b = str(a_split[2] + ", " + a_split[0]  + " " + a_split[1]) #  Washington, George Burt
            tmp_title = tmp_title.replace(b, mynothing, 1)
        else:
            pass
    tmp_title = str(tmp_title.strip())
    n_orig2 = len(tmp_title)
    if (n_orig1 <> n_orig2) or title_is_frozen:
        pass
    else:
        a = str(tmp_auth)
        t1 = tmp_title.replace(a, mynothing, 1)
        a = a.replace(".",". ", 4)
        t2 = t1.replace(a, mynothing, 1)
        a = a.replace(".", mynothing, 4)
        t3 = t2.replace(a, mynothing, 1)
        a_split = a.split(" ")
        for row in a_split:
            a0 = str(row)
            t4 = str(t3.replace(a0, mynothing, 1))
            a0 = str(a0.replace(".", ". ", 4))
            t5 = str(t4.replace(a0, mynothing, 1))
            t6 = str(t5.replace(". ", mynothing, 10))
            if t6.startswith(","):
                t6 = t6[1: ]
            t6 = t6.strip()
            t3 = t6 #for next row
        tmp_title = str(t6)
        tmp_title = str(tmp_title.replace("  ", " ", 4))
        tmp_title = str(tmp_title.strip())
        tmp_title = str(titlecase(tmp_title))
        tmp_title = str(tmp_title.strip())
    if tmp_title == mynothing:
        tmp_title = "_Unknown_"
    if tmp_title == orig_title or tmp_title == mynothing or (not (tmp_title > " ")):
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = str(tmp_title.strip())
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_title, my_current_book)
def scrub_author_is_title_but_title_is_title_with_author_too(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_valid_globally
    global author_probably_good
    global author_in_title
    global title_in_author
    if author_valid_globally:
        return
    if author_probably_good:
        return
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    tmp_rows = []
    del tmp_rows
    sleep(0.05)
    mysql = "DELETE FROM  _books_work WHERE  book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql =  "INSERT OR IGNORE INTO _books_work SELECT book,booktitle,authname,seriesname,seriesindex FROM  __books_work_populate "
    mysql = mysql + " WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "UPDATE _books_work SET booktitle = (make_utf8_lowercase(booktitle) )"
    mysql = mysql + " WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "UPDATE _books_work SET authorname = (make_utf8_lowercase(authorname) ) "
    mysql = mysql + " WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "DELETE FROM  _instr_title_author WHERE  book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "INSERT OR IGNORE INTO _instr_title_author (book, booktitle, authorname) \
                SELECT book, booktitle, authorname FROM __instr_title_author_author_title WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "SELECT booktitle, authorname FROM _instr_title_author WHERE book = '" + my_current_book + "' ; "
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            tmp_title, tmp_author = row
            tmp_title = str(tmp_title)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            tmp_author = str(tmp_author)
            tmp_author = str(__change_tuple_to_bytestring(tmp_author))
    p01 = "~"
    p02 = "-"
    p03 = ":"
    p04 = ";"
    s01 = "articles"
    s02 = "article"
    s03 = "a book"
    s04 = "books"
    s05 = "book"
    s06 = " by "
    a_in_t = tmp_title.find(tmp_author)
    author_in_title = False
    if a_in_t >= 0: author_in_title = True
    if author_in_title: #author is a substring of title
        tmp_title = str(tmp_title.replace(tmp_author, mynothing, 1))
        tmp_title = str(tmp_title.replace(p01, mynothing, 4))
        tmp_title = str(tmp_title.replace(p02, mynothing, 4))
        tmp_title = str(tmp_title.replace(p03, mynothing, 4))
        tmp_title = str(tmp_title.replace(p04, mynothing, 4))
        tmp_title = str(tmp_title.replace(s01, mynothing, 4))
        tmp_title = str(tmp_title.replace(s02, mynothing, 4))
        tmp_title = str(tmp_title.replace(s03, mynothing, 4))
        tmp_title = str(tmp_title.replace(s04, mynothing, 4))
        tmp_title = str(tmp_title.replace(s05, mynothing, 4))
        tmp_title = str(tmp_title.replace(s06, mynothing, 4))
        tmp_title = str(tmp_title.replace("  ", " ", 20))
        tmp_title = tmp_title.strip()
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        new_title = mynothing
        for char in tmp_title:
            s = str(char)
            if s.isalpha():
                pass
            else:
                if s == " ":
                    pass
                else:
                    s = mynothing
            new_title = str(new_title + s)
        tmp_title = str(new_title)
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    else:
        pass
    if str(tmp_title) > " ":
        sleep(0.05)
        tmp_title = str(titlecase(tmp_title))
        mysql =  'INSERT OR REPLACE INTO custom_column_8 (id,value) VALUES (?,?);'
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_title)
        mysql =  'UPDATE books_custom_column_8_link SET value = ? WHERE book = ?  '
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, my_current_book)
    else:
      pass
def scrub_series_substring_across_author(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_valid_globally
    global series_valid_globally
    global title_probably_good
    global author_in_title
    global title_in_author
    global series_in_author
    global series_in_title
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global set_of_re_metacharacters
    if series_valid_globally:
        return
    if title_probably_good:
        return
    if title_is_frozen:
        return
    set_title_probably_good_at_end = False
    series = ""
    title = ""
    series_index = ""
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT title, series, series_index from __book_meta_partial WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            c = -1
            if c > 2:
                break
            else:
                for col in row:
                    c = c + 1
                    if c == 0:
                        title = col
                    else:
                        if c == 1:
                            series = col
                        else:
                            if c == 2:
                                series_index = str(col)
                            else:
                                pass
    else:
        pass
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT booktitle from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            tmp_title = str(row)
            break
    else:
        return
    title = __change_tuple_to_bytestring(title)
    real_title_backup = str(title)
    title = title.replace(",", mynothing, 4)
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = tmp_title.replace(",", mynothing, 4)
    series = __change_tuple_to_bytestring(series)
    series = series.replace(",", mynothing, 4)
    series_index = __change_tuple_to_bytestring(series_index)
    series_index = series_index.replace(",", mynothing, 4)
    if series == "None":
        series = mynothing
    if series > " ":
        return
    else:
        if title == mynothing:
            return
        else:
            pass
    tmp_auth = ""
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT authname from __book_meta_auth_series WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
                tmp_auth = str(row)
                break
    else:
        return
    tmp_auth = __change_tuple_to_bytestring(tmp_auth)
    tmp_auth = tmp_auth.replace(",", mynothing, 4)
    tmp_rows = []
    del tmp_rows
    tmp_series = []
    mysql = 'SELECT series from __book_meta_auth_series WHERE authname = "' + tmp_auth + '" ;'
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            s = row
            s = __change_tuple_to_bytestring(s)
            s = s.replace(",", mynothing, 4)
            tmp_series.append(s)
    else:
        return
    is_match = False
    tmp_match = ""
    for row in tmp_series:
        s = row
        s = __change_tuple_to_bytestring(s)
        s = s.replace(",", mynothing, 4)
        b = title
        x = __similar(s,b)
        n = title.find(s)
        if x >= 0.50 or n >= 0:
            is_match = True
            tmp_match = s
        else:
            pass
        if is_match:
            break
        else:
            pass
    if not is_match:
        return
    else:
        if tmp_match == mynothing:
            return
        else:
            pass
    tmp_title_with_possible_index = str(real_title_backup)
    backup_real_title = str(real_title_backup)
    title = str(tmp_title)
    i = 100.5 #go in reverse so 10 is found before 01, and 01 is found before 0
    while i > 0.0 :
        i = (i - .5)
        s0 = str(i)
        s0 = s0.replace(".0", mynothing, 10)
        n1 = s0.find("0")
        if n1 == 0:
            s0 = s0[1: ]
        s0 = s0.replace("0", mynothing, 10)
        tmp_index = s0
        s1 = tmp_index
        s2 = "0" + s1
        s3 = s1 + ":"
        s4 = s2 + ":"
        s5 = s1 + " -"
        s6 = s1 + "-"
        s7 = s2 + " -"
        s8 = s2 + "-"
        title = title.replace(s7, mynothing, 2)
        title = title.replace(s8, mynothing, 2)
        title = title.replace(s4, mynothing, 2)
        title = title.replace(s2, mynothing, 2)
        title = title.replace(s5, mynothing, 2)
        title = title.replace(s6, mynothing, 2)
        title = title.replace(s3, mynothing, 2)
        title = title.replace(s1, mynothing, 2)
    title = title.replace("()", mynothing, 4)
    title = title.replace("  ", " ", 4)
    n = title.find(" ")
    if n == 0: #leading space
        title = title[1: ]
    backup_title = str(title)
    backup_title = str(backup_title.strip())
    n1  = len(title)
    title = str(title.replace(tmp_match, mynothing, 4))
    title = str(title.strip())
    n2 = len(title)
    if n1 <> n2:
        if title.startswith("s "):
            title = str(title[1: ])
        if title.startswith("es "):
            title = str(title[2: ])
        if title.startswith("[s "):
            title = str(title[2: ])
        if title.startswith("[es "):
            title = str(title[3: ])
        title = str(title.strip())
        title = str(title.replace("[#]", mynothing, 1))
        title = str(title.replace("[ #]", mynothing, 1))
        title = str(title.replace("#]", mynothing, 1))
        title = str(title.replace("#.]", mynothing, 1))
        title = str(title.strip())
        if title.endswith("["):
            title = str(title[0:-1])
            title = str(title.strip())
        if title.endswith("[s"):
            title = str(title[0:-2])
            title = str(title.strip())
        if title.endswith("[es"):
            title = str(title[0:-3])
            title = str(title.strip())
        if title.endswith("Mr.") or title.endswith("Mrs.") or title.endswith("Ms.") or title.endswith("Dr."):
            title = str(backup_title)
        if title.endswith("Mister"):
            title = str(backup_title)
    if title == mynothing or title <= " ":
        title = str(backup_title)
        title = str(title.strip())
        set_title_probably_good_at_end = True
        title_probably_good = False
    else:
        set_title_probably_good_at_end = False
    if not title_probably_good:
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id = ? ')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
    else:
        pass
    mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)"
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_match)
    sleep(0.05)
    mysql = "DELETE FROM books_custom_column_10_link WHERE book =  ? AND book = ?  "
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, my_current_book)
    sleep(0.05)
    mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)  ;"
    __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book, my_current_book)
    s_num = "99999"
    s_num = __find_part_number_in_title(str(real_title_backup))
    if s_num == "99999":
        s0 = "0"
    else:
        s0 = str(__strip_numerics(s_num))
    sleep(0.05)
    mysql = "DELETE FROM custom_column_12 WHERE book = '" + my_current_book + "' ;"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.05)
    mysql = "INSERT INTO custom_column_12 (id,book,value) VALUES (null, '" + my_current_book + "','" + s0 + "'  ) ;"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    if set_title_probably_good_at_end:
        title_probably_good = True
def scrub_isbn_in_author(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global author_valid_globally
    global author_probably_good
    if author_valid_globally:
        return
    if author_probably_good:
        return
    auth = ""
    orig_auth = ""
    mysql = "SELECT value FROM custom_column_4 WHERE custom_column_4.id IN \
                           (SELECT value from books_custom_column_4_link WHERE book = '" + my_current_book + "'   )"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            orig_auth = str(row)
            break
    else:
        return
    auth = str(orig_auth)
    auth = str(__change_tuple_to_bytestring(auth))
    auth = str(auth.replace(",", mynothing, 4))
    orig_auth = str(auth)
    if auth == mynothing:
        return
    else:
        pass
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p13a = re.compile(my_re13a, re.IGNORECASE)
    match13a = p13a.search(auth)
    if match13a:
        auth = re.sub(my_re13a, mynothing, auth)
    else:
        p13b = re.compile(my_re13b, re.IGNORECASE)
        match13b = p13b.search(auth)
        if match13b:
            auth = re.sub(my_re13b, mynothing, auth)
        else:
            p10a = re.compile(my_re10a, re.IGNORECASE)
            match10a = p10a.search(auth)
            if match10a:
                auth = re.sub(my_re10a, mynothing, auth)
            else:
                p10b = re.compile(my_re10b, re.IGNORECASE)
                match10b = p10b.search(auth)
                if match10b:
                    auth = re.sub(my_re10b, mynothing, auth)
                else:
                    return
    auth = str(__change_tuple_to_bytestring(str(auth)))
    auth = str(auth.replace("int.indd", mynothing, 4))
    auth = str(auth.replace("INT.INDD", mynothing, 4))
    auth = str(auth.replace(".indd", mynothing, 4))
    auth = str(auth.replace(".INDD", mynothing, 4))
    auth = str(auth.replace("_", mynothing, 20))
    auth = str(auth.replace(",", mynothing, 4))
    auth = str(auth.replace("  ", " ", 4))
    auth = str(auth.strip())
    auth = str(__add_missing_spaces_to_camelback_strings(auth))
    auth = str(auth.strip())
    auth = str(__change_tuple_to_bytestring(str(auth)))
    if str(auth) <> str(orig_auth):
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  auth, my_current_book)
        s_unknown = "_Unknown_"
        mysql = str('UPDATE custom_column_4 SET value =  ? WHERE  custom_column_4.id IN \
                                    (SELECT value FROM books_custom_column_4_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, s_unknown, my_current_book)
    else:
        return
    if match13a or match13b:
        isbn = orig_auth[0:13]
    else:
        isbn = orig_auth[0:10]
    good_isbn = False
    if match13a or match13b:
        good_isbn = str(__isbn13checksum(isbn))
    else:
        good_isbn = str(__isbn10checksum(isbn))
    if not good_isbn:
        return
    else:
        pass
    new_isbn = str(_convert_isbn_convert_10_to_13(isbn))
    if new_isbn:
        try:
            unicode_isbn = isbn.decode("utf8")
        except:
            pass
        if (new_isbn <> isbn) and (unicode_isbn.isnumeric()) and (len(new_isbn) == 13) and (not new_isbn.startswith("978978")):
            log("Valid ISBN10 Converted to ISBN13:" + str(isbn) + " >>> " + str(new_isbn))
            isbn = str(new_isbn)
        else:
            pass
    mysql = str('INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,"isbn",?)')
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(my_current_book,isbn))
        my_cursor.execute("commit")
        log("Valid ISBN extracted and updated for book with author of:", str(orig_auth))
    except Exception as e:
        log(str(e))
        pass #not going to stop just for this
    scrub_misc_title_issues(my_db, my_cursor, my_current_book, notifications, log)
def scrub_isbn_in_title(my_db, my_cursor,  my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    title = ""
    orig_title = ""
    mysql = "SELECT value FROM custom_column_8 WHERE custom_column_8.id IN \
                           (SELECT value from books_custom_column_8_link WHERE book = '" + my_current_book + "'   )"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            col = row[0]
            s = unicodedata.normalize('NFKD', col).encode('ascii', 'ignore')
            orig_title = str(s)
            break
    else:
        return
    title = str(orig_title)
    title = str(__change_tuple_to_bytestring(title))
    title = str(title.replace(",", mynothing, 4))
    orig_title = str(title)
    if title == mynothing:
        return
    else:
        pass
    n = title.count('"')
    if n > 0:
        title = str(title.replace('"', mynothing, 10))
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p13a = re.compile(my_re13a, re.IGNORECASE)
    match13a = p13a.search(title)
    if match13a:
        title = re.sub(my_re13a, mynothing, title)
    else:
        p13b = re.compile(my_re13b, re.IGNORECASE)
        match13b = p13b.search(title)
        if match13b:
            title = re.sub(my_re13b, mynothing, title)
        else:
            p10a = re.compile(my_re10a, re.IGNORECASE)
            match10a = p10a.search(title)
            if match10a:
                title = re.sub(my_re10a, mynothing, title)
            else:
                p10b = re.compile(my_re10b, re.IGNORECASE)
                match10b = p10b.search(title)
                if match10b:
                    title = re.sub(my_re10b, mynothing, title)
                else:
                    return
    title = str(__change_tuple_to_bytestring(str(title)))
    title = str(title.replace("int.indd", mynothing, 4))
    title = str(title.replace("INT.INDD", mynothing, 4))
    title = str(title.replace(".indd", mynothing, 4))
    title = str(title.replace(".INDD", mynothing, 4))
    title = str(title.replace("_", mynothing, 20))
    title = str(title.replace(",", mynothing, 4))
    title = str(title.replace("()", mynothing, 4))
    title = str(title.replace("[]", mynothing, 4))
    title = str(title.replace("  ", " ", 4))
    title = str(title.strip())
    title = str(__add_missing_spaces_to_camelback_strings(title))
    title = str(title.strip())
    title = str(__change_tuple_to_bytestring(str(title)))
    if str(title) <> str(orig_title):
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
    else:
        return
    if match13a or match13b:
        isbn = orig_title[0:13]
    else:
        isbn = orig_title[0:10]
    good_isbn = False
    if match13a or match13b:
        good_isbn = str(__isbn13checksum(isbn))
    else:
        good_isbn = str(__isbn10checksum(isbn))
    if not good_isbn:
        return
    else:
        pass
    new_isbn = str(_convert_isbn_convert_10_to_13(isbn))
    if new_isbn:
        try:
            unicode_isbn = isbn.decode("utf8")
        except:
            pass
        if (new_isbn <> isbn) and (unicode_isbn.isnumeric()) and (len(new_isbn) == 13) and (not new_isbn.startswith("978978")):
            log("Valid ISBN10 Converted to ISBN13:" + str(isbn) + " >>> " + str(new_isbn))
            isbn = str(new_isbn)
        else:
            pass
    mysql = str('INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,"isbn",?)')
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(my_current_book,isbn))
        my_cursor.execute("commit")
        log("Valid ISBN extracted and updated for book with title of:", str(orig_title))
    except Exception as e:
        log(str(e))
        pass #not going to stop just for this
def scrub_misc_title_issues(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    global title_is_frozen
    title = ""
    orig_title = ""
    mysql = str('SELECT value from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '" ) ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            for col in row:
                s = unicodedata.normalize('NFKD', col).encode('ascii','ignore')
                orig_title = str(s)
                break
            break
    else:
        pass
    title = str(orig_title)
    title = str(__change_tuple_to_bytestring(title))
    title = str(title.replace(",", mynothing, 4))
    orig_title = str(title)
    if title == mynothing:
        return
    title = str(__remove_bad_keywords(title))
    if title.endswith(" La") or title.endswith(" la"):
        title = str(title[0:-3])
    title = str(title.replace("of S & Novellas", "of Novels & Novellas", 4))
    my_re1 =  '\(.+\)'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s = str(match1.group(0))
        n = s.find("Publishing")
        if n >= 0:
            title = re.sub(my_re1, mynothing, title)
        else:
           return
    my_re2 =  '\[.+\]'
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(title)
    if match2:
        s = str(match2.group(0))
        n = s.find("Publishing")
        if n >= 0:
            title = re.sub(my_re2, mynothing, title)
        else:
           return
    title = str(__change_tuple_to_bytestring(title ))
    title = str(title.replace("  ", " ", 10))
    title = title.strip()
    if title.endswith("-"): title = str(title[0:-1])
    title = str(title.replace("  ", " ", 10))
    title = title.strip()
    title = str(__change_tuple_to_bytestring(title ))
    n = len(title)
    if n == 0 or title == " " or title == mynothing :
        title = "_Unknown_"
    else:
        pass
    title = str(titlecase(title))
    orig_title = str(__change_tuple_to_bytestring(orig_title))
    if title <> orig_title:
        title_probably_good = False
        title = str(__change_tuple_to_bytestring(title))
        title = str(title.replace(",", mynothing, 4))
        title = str(title.replace("  ", " ", 4))
        title = title.strip()
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
    else:
        pass
def scrub_first_first_title(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global probable_tags_to_add
    global author_valid_globally
    global author_in_title
    global title_in_author
    global series_in_author
    global series_in_title
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global set_of_re_metacharacters
    global title_probably_good
    global title_is_frozen
    title_probably_good = False
    title_is_frozen = False
    force_update = False
    scrub_publisher_from_title(my_db, my_cursor, my_current_book, notifications, log)
    scrub_isbn_in_title(my_db, my_cursor,  my_current_book, notifications, log)
    scrub_the_lewis_the_lover_scenario(my_db, my_cursor, my_current_book, notifications, log)
    check_title_for_special_patterns_to_genericize(my_db, my_cursor,  my_current_book, notifications, log)
    title = ""
    orig_title = ""
    mysql = str('SELECT value from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '" ) ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            for col in row:
                s = unicodedata.normalize('NFKD', col).encode('ascii', 'ignore')
                orig_title = str(s)
                break
            break
    else:
        pass
    title = str(orig_title)
    n = title.count('"')
    if n > 0:
        title = str(title.replace('"', mynothing , 10))
        force_update = True
    n = title.count(':')
    if n > 1:
        title = str(title.replace(':', ' ', 10))
    ns = title.count(" ")
    np = title.count("+")
    if np > ns:
        title = str(title.replace("+", " ", 50))
        force_update = True
    ns = title.count(" ")
    np = title.count("_")
    if np > ns:
        title = str(title.replace("_", " ", 50))
        force_update = True
    title = str(title.replace("()", mynothing, 10))
    title = str(title.replace("[]", mynothing, 10))
    title = str(title.replace("{}", mynothing, 10))
    nl = title.count("[")
    nr = title.count("]")
    if nl <> nr:
        title = str(title.replace("[", mynothing, 10))
        title = str(title.replace("]", mynothing, 10))
    nl = title.count("(")
    nr = title.count(")")
    if nl <> nr:
        title = str(title.replace("(", mynothing, 10))
        title = str(title.replace(")", mynothing, 10))
    if title.endswith(", the") or title.endswith(", The"):
        title = str(title[0:-5])
        title = str(title.strip())
    title = str(title.replace(",", ", ", 10))
    title = str(title.replace("  ", " ", 10))
    title = str(__change_tuple_to_bytestring(title))
    has_letters = False
    has_hash = False
    has_parens = False
    for item in title:
        s = str(item)
        if s.isalpha():
            has_letters = True
        if s == ")" or s == "(" :
            has_parens = True
            break
    if has_letters and (not has_parens):
        s_original = str(title)
        title = str(__add_missing_spaces_to_camelback_strings(title))
        if len(title) < len(s_original):
            title = str(s_original)
    else:
        pass
    orig_title = str(title)
    tag_found = False
    nt = title.count("Sex")
    if nt > 0:
        probable_tags_to_add.append("Sex")
        tag_found = True
    nt = title.count("Wolf Pack")
    if nt > 0:
        probable_tags_to_add.append("Werewolves")
        tag_found = True
    nt = title.count("Werewol")
    if nt > 0:
        probable_tags_to_add.append("Werewolves")
        tag_found = True
    nt = title.count("Fae ")
    if nt > 0:
        probable_tags_to_add.append("Faeries")
        tag_found = True
    nt = title.count("Faer")
    if nt > 0:
        probable_tags_to_add.append("Faeries")
        tag_found = True
    nt = title.count("Witch")
    if nt > 0:
        probable_tags_to_add.append("Witches&Warlocks")
        tag_found = True
    nt = title.count("Warlock")
    if nt > 0:
        probable_tags_to_add.append("Witches&Warlocks")
        tag_found = True
    nt = title.count("Thriller")
    if nt > 0:
        probable_tags_to_add.append("Thriller")
        tag_found = True
    nt = title.count("Mystery")
    if nt > 0:
        probable_tags_to_add.append("Mystery")
        tag_found = True
    nt = title.count("Mysteries")
    if nt > 0:
        probable_tags_to_add.append("Mystery")
        tag_found = True
    nt = title.count("Adventure")
    if nt > 0:
        probable_tags_to_add.append("Action&Adventure")
        tag_found = True
    nt = title.count("Suspense")
    if nt > 0:
        probable_tags_to_add.append("Suspense")
        tag_found = True
    nt = title.count("Erotic")
    if nt > 0:
        probable_tags_to_add.append("Romance")
        tag_found = True
    nt = title.count("Romance")
    if nt > 0:
        probable_tags_to_add.append("Romance")
        tag_found = True
    nt = title.count("Paranormal")
    if nt > 0:
        probable_tags_to_add.append("Paranormal")
        tag_found = True
    nt = title.count("Romantic")
    if nt > 0:
        probable_tags_to_add.append("Romance")
        tag_found = True
    nt = title.count("Crime")
    if nt > 0:
        probable_tags_to_add.append("Crime")
        tag_found = True
    nt = title.count("Historical Romance")
    if nt > 0:
        probable_tags_to_add.append("Historical Romance")
        tag_found = True
    nt = title.count("Walking Dead")
    if nt > 0:
        probable_tags_to_add.append("Zombies")
        tag_found = True
    nt = title.count("Living Dead")
    if nt > 0:
        probable_tags_to_add.append("Zombies")
        tag_found = True
    nt = title.count(" Undead")
    if nt > 0:
        probable_tags_to_add.append("Zombies")
        tag_found = True
    nt = title.count("Zombie")
    if nt > 0:
        probable_tags_to_add.append("Zombies")
        tag_found = True
    nt = title.count("Vampire")
    if nt > 0:
        probable_tags_to_add.append("Vampires")
        tag_found = True
    nt = title.count("Fantasy")
    if nt > 0:
        probable_tags_to_add.append("Fantasy")
        tag_found = True
    nt = title.count("Shifter")
    if nt > 0:
        probable_tags_to_add.append("Shapeshifter")
        tag_found = True
    nt = title.count("Werebear")
    if nt > 0:
        probable_tags_to_add.append("Shapeshifter")
        tag_found = True
    nt = title.count(": A Novel")
    if nt > 0:
        probable_tags_to_add.append("Fiction")
        tag_found = True
    nt = title.count(" Novel ")
    if nt > 0:
        probable_tags_to_add.append("Fiction")
        tag_found = True
    nt = title.count("Magazine")
    if nt > 0:
        probable_tags_to_add.append("Magazines")
        tag_found = True
    nt = title.count("True Story")
    if nt > 0:
        probable_tags_to_add.append("Factual:True Story")
        tag_found = True
    if tag_found :
        log("New Work Tag(s) derived from book: ", str(title))
    my_re1 = "^[A-Z ]+$"
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        try:
            title = str(title.lower())
        except:
            pass
        title = str(titlecase(title))
        title_probably_good = True
        title_is_frozen = True
        force_update = True
    else:
        pass
    my_re1 = "^THE BOOK OF BOOKS"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
        n1 = len(title)
        if n1 > 50:
            title = str(title[0:17])
            force_update = True
    else:
        pass
    my_re1 = "^[a-z ]+\s[0-9]+\s[a-z ]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
        return
    else:
        pass
    my_re1 = "^[a-z ]+[ ][0-9]+[-][0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
        return
    else:
        pass
    my_re1 = "^Microsoft Word - [a-z]+\s[a-z]\s[a-z]+\s-\s"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = False
        title_is_frozen = False
        title = str(title.replace("Microsoft Word - ", mynothing, 1))
        n = title.find("-")
        new_author = str(title[0:n-1])
        title = str(title[n+1: ])
        force_update = True
        force_author_update = True
    else:
        new_author = mynothing
        force_author_update = False
    n1 = len(title)
    title = str(title.replace("It's", "It is", 4))
    title = str(title.replace("Don't", "Do not", 4))
    title = str(title.replace("don't", "do not", 4))
    title = str(title.replace("we're", "we are", 4))
    title = str(title.replace("We're", "We are", 4))
    title = str(title.replace("Novellas", "Novels", 4))
    title = str(title.replace("Novella", "Novel", 4))
    title = str(title.strip())
    n2 = len(title)
    if n1 <> n2:
        force_update = True
    if "Epilogue" in title:
        title = title.replace("[Epilogue]", mynothing, 4)
        title = title.replace("(Epilogue)", mynothing, 4)
        force_update = True
    if "Free Magazines Download in PDF for iPad/PC" in title:
        title = title.replace("Free Magazines Download in PDF for iPad/PC", mynothing, 4)
        title = title.replace("Storemags -", "Magazine", 4)
        title = str(title.strip())
        force_update = True
    if force_update:
        title = str(__change_tuple_to_bytestring(title))
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
        orig_title = str(title)
        force_update = False
    if force_author_update:
        new_author = str(__change_tuple_to_bytestring(new_author))
        mysql = str('UPDATE custom_column_4 SET value =  ? WHERE  custom_column_4.id IN \
                                    (SELECT value FROM books_custom_column_4_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  new_author, my_current_book)
        new_author = mynothing
        force_author_update = False
    if not force_update:
        my_re1 = '^[0-9]*[0-9]:[0-9][0-9]$'
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[a-z ]+:\sA\s[a-z' ]+\s[NovelMysteryThrillerRomance]+$"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[a-z]+['][s]\s[a-z ]+$"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[a-z ]+$"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^[0-9]+[:]\sA\sPortrait\sof[a-z ]+$"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
        my_re1 = "^The\s[0-9]+[thstrdn]+[a-z ]+$"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            title_probably_good = True
            title_is_frozen = True
            return
        else:
            pass
    else:
        pass
    title = str(title.strip())
    if title == mynothing:
        title = "_Unknown_"
    if title == "_":
        title = "_Unknown_"
    if title == "Untitled" or title == "untitled":
        title = "_Unknown_"
    if title.startswith("-") or title.startswith(":") or title.startswith(";"):
        title = str(title[1: ])
        title = str(title.strip())
    if title.endswith("-") or title.endswith(":") or title.endswith(";"):
        title = str(title[0:-1])
        title = str(title.strip())
    title = str(__remove_bad_keywords(title))
    title = title.replace("()", mynothing, 4)
    title = title.replace("[]", mynothing, 4)
    n = title.count(" Boxed Set")
    if n > 0:
        title_probably_good = True
        title_is_frozen = True
    n = title.count("Multi-Author Bundle")
    if n > 0:
        title_probably_good = True
        title_is_frozen = True
    n = title.count("Bundle of Novel")
    if n > 0:
        title_probably_good = True
        title_is_frozen = True
    n1 = title.count("--")
    n2 = title.count("?")
    n3 = title.count(":")
    if n1 > 0 and (n2 > 0 or n3 > 0):
        title_probably_good = True
        title_is_frozen = True
    nl = title.count("(")
    nr = title.count(")")
    if nl == 0 and nr == 1:
        title = str(title.replace(")", mynothing, 1))
    if nl == 1 and nr == 0:
        title = str(title.replace("(", mynothing, 1))
    title = title.replace(" II ", " 2 ", 1)
    title = title.replace(" III ", " 3 ", 1)
    title = title.replace(" IV ", " 4 ", 1)
    title = title.replace("Ifan ", "If an ", 1)
    title = title.replace("Ifa ", "If a ", 1)
    if title == "Collected Stories Of" or title == "Collected Stories of" :
        title = str("Collected Stories")
    title = str(title.strip())
    n1 = title.count(": Part One:")
    n2 = title.count(": Part Two:")
    n3 = title.count(": Part Three:")
    n4 = title.count(": Part Four:")
    if n1 > 0 or n2 > 0 or n3 > 0 or n4 > 0:
        title = title.replace(": Part One:", " Part One [ #1  ", 4)
        title = title.replace(": Part Two:", " Part Two [ #2  ", 4)
        title = title.replace(": Part Three:", " Part Three [ #3  ", 4)
        title = title.replace(": Part Four:", " Part Four [ #4  ", 4)
        title = str(title + "]")
        title = title.replace("(", mynothing, 4)
        title = title.replace(")", mynothing, 4)
        title = title.replace("  ", " ", 10)
        title = str(title.strip())
    my_re1 = "http://.+.com"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = re.sub(my_re1, mynothing, title)
    my_re1 = "http://.+.org"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = re.sub(my_re1, mynothing, title)
    my_re1 = "http://.+.net"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = re.sub(my_re1, mynothing, title)
    title = title.replace(".com", ".xxxx", 4)
    title = title.replace(".org", ".xxxx", 4)
    title = title.replace(".html", ".xxxx", 4)
    title = title.replace(".htm", ".xxxx", 4)
    title = title.replace(".php", ".xxxx", 4)
    title = str(__change_tuple_to_bytestring(title))
    n1 = title.find("http")
    n2 = title.find(".xxxx")
    if n1 >= 0 and n2 >= 0:
        s = title[n1:n2+5]
        title = title.replace(s, mynothing, 1)
        if title == mynothing or title == " ":
            title = "_Unknown_"
    else:
        if n1 >= 0: #example: http://www.mindmined.com/public_library/nonfiction/claire_wolfe
            n3 = title.rfind("/")
            if n3 > n1:
                s = title[n1:n3+1]
                title = title.replace(s, mynothing, 1)
                if title == mynothing or title == " ":
                    title = "_Unknown_"
            else:
                pass
    my_re1 = '^[Mr.]+\s[a-z ]+:\sA\s[a-z ]+\s[NovelMysteryThrillerRomanceNovella]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
        return
    else:
        pass
    title = str(__remove_bad_keywords(title))
    title = str(title.strip())
    if title.endswith("a Thriller") or title.endswith("A Thriller"):
        title = str(title[0:-10])
        title = str(title.strip())
    if title.endswith("a Romance") or title.endswith("A Romance"):
        title = str(title[0:-9])
        title = str(title.strip())
    if title.endswith("-"):
        title = str(title[0:-1])
        title = str(title.strip())
    if title.endswith(":"):
        title = str(title[0:-1])
        title = str(title.strip())
    if title.endswith(";"):
        title = str(title[0:-1])
        title = str(title.strip())
    if title.endswith(","):
        title = str(title[0:-1])
        title = str(title.strip())
    if title.endswith(" La") or title.endswith(" la"):
        title = str(title[0:-3])
    title = str(title.replace("of S & Novellas", "of Novels & Novellas", 4))
    title = str(title.replace("[Epilogue]", mynothing, 4))
    title = str(title.replace("Dept.", "Department", 4))
    title = str(title.replace(": Vol ", " Volume ", 1))
    title = str(title.replace("Vol.1", " Volume 1", 1))
    title = str(title.replace("Vol1", " Volume 1", 1))
    title = str(title.replace("Vol.2", " Volume 2", 1))
    title = str(title.replace("Vol2", " Volume 2", 1))
    title = str(title.replace("Vol.3", " Volume 3", 1))
    title = str(title.replace("Vol3", " Volume 3", 1))
    title = str(title.replace("Vol.4", " Volume 4", 1))
    title = str(title.replace("Vol4", " Volume 4", 1))
    title = str(title.replace("Vol.5", " Volume 5", 1))
    title = str(title.replace("Vol5", " Volume 5", 1))
    title = str(title.replace(": Vol ", " Volume ", 1))
    title = str(title.replace("Vol.1", " Volume 1", 1))
    title = str(title.replace("Vol1", " Volume 1", 1))
    title = str(title.replace("Vol.2", " Volume 2", 1))
    title = str(title.replace("Vol2", " Volume 2", 1))
    title = str(title.replace("Vol.3", " Volume 3", 1))
    title = str(title.replace("Vol3", " Volume 3", 1))
    title = str(title.replace("Vol.4", " Volume 4", 1))
    title = str(title.replace("Vol4", " Volume 4", 1))
    title = str(title.replace("Vol.5", " Volume 5", 1))
    title = str(title.replace("Vol5", " Volume 5", 1))
    title = str(title.replace("Vol. 1", " Volume 1", 1))
    title = str(title.replace("Vol 1", " Volume 1", 1))
    title = str(title.replace("Vol. 2", " Volume 2", 1))
    title = str(title.replace("Vol 2", " Volume 2", 1))
    title = str(title.replace("Vol. 3", " Volume 3", 1))
    title = str(title.replace("Vol 3", " Volume 3", 1))
    title = str(title.replace("Vol. 4", " Volume 4", 1))
    title = str(title.replace("Vol 4", " Volume 4", 1))
    title = str(title.replace("Vol. 5", " Volume 5", 1))
    title = str(title.replace("Vol 5", " Volume 5", 1))
    title = str(title.replace("Vol. 1", " Volume 1", 1))
    title = str(title.replace("Vol 1", " Volume 1", 1))
    title = str(title.replace("Vol. 2", " Volume 2", 1))
    title = str(title.replace("Vol 2", " Volume 2", 1))
    title = str(title.replace("Vol. 3", " Volume 3", 1))
    title = str(title.replace("Vol 3", " Volume 3", 1))
    title = str(title.replace("Vol. 4", " Volume 4", 1))
    title = str(title.replace("Vol 4", " Volume 4", 1))
    title = str(title.replace("Vol. 5", " Volume 5", 1))
    title = str(title.replace("Vol 5", " Volume 5", 1))
    title = title.replace("[]", mynothing, 4)
    title = title.strip()
    title = title.replace("Not for Resale or Distribution", mynothing, 1)
    n = title.count(" Novel ")
    if n > 0:
        n = title.count("- a ")
        if n > 0:
            title = str(title.replace("- a ", "- ", 1))
            title = title.replace(" Novel ", " ", 1)
            n = title.count(": A ")
            if n > 0:
                title = str(title.replace(": A ", ": ", 1))
    title = title.replace(" Novels", " ", 1)
    title = title.replace(" Novel", " ", 1)
    if title.endswith(": A"):
        title = str(title[0:-3])
    title = title.replace("  ", " ", 10)
    title = title.strip()
    title = str(__remove_bad_keywords(title))
    if title.endswith(", the"):
        title = str(title[ 0:-5])
    title = str(__change_tuple_to_bytestring(title))
    title = title.replace("  ", " ", 10)
    title = title.strip()
    n = title.count(".")
    if n > 1:
        title = title.replace(". "," " , 50)
        title = title.replace("."," " , 50)
        title = title.replace("  ", " ", 10)
        title = title.strip()
    else:
        pass
    title = str(title.replace("\\", " & ", 8))
    title = title.replace("  ", " ", 10)
    title = str(__change_tuple_to_bytestring(title ))
    title = str(title.replace("  ", " ", 10))
    title = title.strip()
    if title.endswith("-"): title = str(title[0:-1])
    title = str(title.replace("  ", " ", 10))
    title = title.strip()
    title = str(__change_tuple_to_bytestring(title ))
    n = title.count("-")
    if n > 2:
        title_is_frozen = True
    title = str(title.replace("( - ", "(", 2))
    title = str(title.replace("  ", " ", 5))
    title = str(title.replace("( ", "(", 2))
    title = str(title.replace("|", mynothing, 10))
    title = str(title.replace(",:", mynothing, 10))
    np = title.count("(")
    nb = title.count("[")
    if np > 0 or nb > 0:
        n = title.count(".")
        if n > 1:
            title = title.replace(". ", " ", 50)
            title = title.replace(".", " ", 50)
        else:
            pass
    else:
        pass
    title = str(title.strip())
    title = title.replace("(-", "(", 4)
    title = title.replace("( -", "(", 4)
    title = str(title.replace("--", "-", 2))
    title = str(title.replace("- -", "-", 2))
    title = title.replace("()", mynothing, 4)
    title = title.replace("( )", mynothing, 4)
    title = title.replace("(  )", mynothing, 4)
    title = title.replace("(   )", mynothing, 4)
    if title.endswith(" La") or title.endswith(" la"):
        title = str(title[0:-3])
    title = str(title.replace("  ", " ", 8))
    title = title.strip()
    if str(orig_title) <> str(title):
        force_update = True
    n1 = title.count(":")
    n2 = title.count(",")
    n3 = title.count(" ")
    n4 = title.count("'")
    n5 = len(title)
    if n5 >= 50 or n3 >= 10 or (n2 >= 3 and n1 > 0) or n4 >= 4:
        title_probably_good = True
        title_is_frozen = True
    title = str(title.replace("( - ", "(", 2))
    title = str(title.replace("  ", " ", 5))
    title = str(title.replace("( ", "(", 2))
    title = str(title.replace("|", mynothing, 10))
    np = title.count("(")
    nb = title.count("[")
    if np > 0 or nb > 0:
        n = title.count(".")
        if n > 1:
            title = title.replace(". ", " ", 50)
            title = title.replace(".", " ", 50)
        else:
            pass
    else:
        pass
    title = str(title.strip())
    n = title.count(" ")
    if n == 0:
        title = str(__add_missing_spaces_to_camelback_strings(title))
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p1 = re.compile(my_re13a, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
       title = str(title.replace("(97", "97", 1))
    p1 = re.compile(my_re10a, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
       title = str(title.replace("(0", "0", 1))
       title = str(title.replace("(1", "1", 1))
    try:
        title = str(title.lower())
    except:
        pass
    title = str(titlecase(title))
    my_re1 = "\(A[n]*\s.+\s[ThrillerMysteryRomance]+\)$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s0 = match1.group(0)
        s1 = match1.group(0)
        s1 = str(s1.replace("An ", mynothing, 1))
        s1 = str(s1.replace("A ",  mynothing, 1))
        s1 = str(s1.replace(" Thriller",  mynothing, 1))
        s1 = str(s1.replace(" Mystery",  mynothing, 1))
        s1 = str(s1.replace(" Romance",  mynothing, 1))
        s1 = str(s1.replace("(", "[", 1))
        s1 = str(s1.replace(")", "]", 1))
        title = str(title.replace(s0, s1, 1))
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("/", "&", 1))
    my_re1 = "^.+\s\(.+\)\s\([a-z]+\s[0-9]+\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace(") (", " ", 1))
        title = str(title.replace("Volume ", "#", 1))
        title = str(title.replace("Part ", "#", 1))
    if title <> orig_title: #need to update prior to returning due to pattern matching logic just after this line
        title = str(__change_tuple_to_bytestring(title))
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
        orig_title = str(title)
    else:
        pass
    n1 = title.count("e-book boxed set")
    if n1 > 0:
        title = str(title.replace("e-book boxed set", mynothing, 1))
        title_probably_good = True
        title_is_frozen = True
    n1 = title.count("boxed set")
    if n1 > 0:
        title = str(title.replace("boxed set", mynothing, 1))
        title_probably_good = True
        title_is_frozen = True
    title = str(title.replace(" : ", ": ", 1))
    my_re1 = '^[a-z]+\s[0-9.]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        try:
            title = str(title.lower())
            title = str(titlecase(title))
            force_update = True
        except:
            pass
    else:
        pass
    my_re1 = '^[a-z ]+;\s[Oor,]+\s[a-z .]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z ]+:\s[a-z ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\([a-z ]+\s[MysteryThrillerSuspenseHorrorRomance]+\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("Mystery", mynothing, 1))
        title = str(title.replace("Thriller", mynothing, 1))
        title = str(title.replace("Suspense", mynothing, 1))
        title = str(title.replace("Horror", mynothing, 1))
        title = str(title.replace("Romance", mynothing, 1))
        title = str(title.replace("(", ":", 1))
        title = str(title.replace(")", " #1", 1))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s[0-9]+\s[a-z ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("-", ":", 1))
        title = str(title.replace(" :", ":", 1))
        title_probably_good = False
        title_is_frozen = False
    else:
        pass
    my_re1 = '^[a-z ]+\s[0-9]+\s[a-z ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+-[a-z ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+Dr\.\s[a-z]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+\s[0-9]+\s[a-z ]+'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z, ]+\sIssue\s[0-9]+'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z ]+Volumes\s[0-9]+-[0-9]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z, ]+\s\([a-z, ]+\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z, ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ,]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[0-9][0-9][0-9][0-9]$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
        return
    else:
        pass
    my_re1 = '^[a-z ]+\sVol.\s[0-9]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+\sEpisode\s[0-9]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[1-2][0-9][0-9][0-9]\s[a-z, ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z -]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = "^[a-z ]+[0-9]+$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title_probably_good = True
        title_is_frozen = True
    else:
        pass
    my_re1 = '^[a-z ]+:\sA Novel of [MysteryThrillerSuspenseHorrorRomance]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find(": ")
        title = str(title[0:n])
        title = str(title.replace(":", mynothing, 1))
        title_probably_good = True
        title_is_frozen = True
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z ]+\\*'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.count("\\")
        if n > 1:
            title_probably_good = True
            title_is_frozen = True
        else:
            pass
    else:
        ns = title.count("\\")
        nc = title.count(":")
        if nc == 1 and ns > 1:
            title_probably_good = True
            title_is_frozen = True
        else:
            pass
    my_re1 = '^[a-z ,]+:[a-z, ]+Trilogy\s\([a-z ,-]+Book\s[0-9]+\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        nc = title.find(":")
        np = title.find("(")
        s1 = str(title[0:nc])
        s2 = str(title[np: ])
        s1 = str(s1.replace(":", mynothing, 1))
        s2 = str(s2.replace("(", mynothing, 1))
        s2 = str(s2.replace(")", mynothing, 1))
        s1 = str(s1.strip())
        s2 = str(s2.strip())
        s2 = str(s2.replace("Book ", "#", 1))
        s2 = str(s2.replace("-", mynothing, 1))
        title = str(s1 + " [" + s2 + "]")
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z, ]+[\(]Book One in the[ ][a-z, ]+[ ]series[\)]$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("Book One in the", "#1", 1))
        title = str(title.replace(" Series", mynothing, 1))
        title = str(title.strip())
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z, ]+\(Book Two in the\s[a-z, ]+\sseries\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("Book Two in the", "#2", 1))
        title = str(title.replace(" Series", mynothing, 1))
        title = str(title.strip())
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z].+\sBook\sOne\s[a-z ]+:\s.+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n0 = title.find(":")
        sr = str(title[n0: ])
        sr = str(sr.replace(":", mynothing, 1))
        sr = str(sr.strip())
        n1 = title.find("One ")
        sl = str(title[0:n1+4])
        sl = str(sl.strip())
        title = str(sl + ":  " + sr)
        title = str(title.replace("Book One", "#1", 1))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z].+\sBook\sOne\s[a-z ]+:\s.+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n0 = title.find(":")
        sr = str(title[n0: ])
        sr = str(sr.replace(":", mynothing, 1))
        sr = str(sr.strip())
        n1 = title.find("Two ")
        sl = str(title[0:n1+4])
        sl = str(sl.strip())
        title = str(sl + ":  " + sr)
        title = str(title.replace("Book Two", "#2", 1))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '.+\([0-9]+\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find("(")
        s1 = str(title[0:n-1])
        s1 = str(s1.replace("(", mynothing, 1))
        s1 = str(s1.strip())
        s2 = str(title[n: ])
        s2 = str(s2.replace("(", mynothing, 1))
        s2 = str(s2.replace(")", mynothing, 1))
        s2 = str(s2.strip())
        title = str(s2 + "  " + s1)
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '.+\s9[0-9]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find("9")
        s1 = str(title[0:n-1])
        s1 = str(s1.strip())
        s2 = str(title[n: ])
        s2 = str(s2.strip())
        title = str(s2 + "  " + s1)
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\(A\s[a-z ]+\sShort\sStory\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find("(")
        title = str(title[0:n-1])
        title_probably_good = True
        title_is_frozen = True
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+[0-9.]+:\s[a-z, ]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        n = title.find(":")
        s1 = str(title[0:n])
        s2 = str(title[n: ])
        s1 = str(s1.replace(":", mynothing, 1))
        s1 = str(s1.strip())
        n = s1.rfind(" ")
        s1a = str(s1[0:n])
        s1b = str(s1[n: ])
        s1a = str(s1a.strip())
        s1b = str(s1b.strip())
        s1 = str(s1a + " #" + s1b)
        s2 = str(s2.replace(":", mynothing, 1))
        s2 = str(s2.strip())
        title = str("[" + str(s1) + "] " + str(s2))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\(.+\s-\sBook\s[0-9]+\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("- Book ", mynothing))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+\s\([a-z ]+\sBook\s[0-9.]+\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("Book ", mynothing, 1))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^.+,\sPart\s[0-9]+:\s.+'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace(", Part ", " #", 1))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^.+\s\(.+[,:]*\sNo\.\s[0-9]+\)$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace(", No. ", "", 1))
        title = str(title.replace(": No. ", "", 1))
        title = str(title.replace(" No. ", "", 1))
        title = str(title.replace("- No. ", "", 1))
        title = str(title.replace("(", "[", 1))
        title = str(title.replace(")", "]", 1))
        title_probably_good = False
        title_is_frozen = False
        force_update = True
    else:
        pass
    my_re1 = '^[a-z ]+:\s[a-z]+,\s[a-z]+,\s[a-z]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    my_re2 = '^[a-z ]+:\s[a-z]+,\s[a-z]+,\s[a-z]+,\s[a-z]+$'
    p2 = re.compile(my_re2, re.IGNORECASE)
    match2 = p2.search(title)
    my_re3 = '^[a-z ]+:\s[a-z&, ]+[0-9][0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]$'
    p3 = re.compile(my_re2, re.IGNORECASE)
    match3 = p3.search(title)
    if match1 or match2 or match3:
        title_probably_good = True
        title_is_frozen = True
        force_update = False
    else:
        pass
    title = str(title.strip())
    nc = title.count(", ")
    ns = title.count(" ")
    np = title.count("(")
    nb = title.count("[")
    n0 = title.count(":")
    if nc == ns:
        if np == 0 and nb == 0 and nb == 0:
            title_probably_good = True
            title_is_frozen = True
    n1 = title.count("And Other Stories")
    if n1 > 0:
         if np == 0 and nb == 0 and nb == 0:
            title_probably_good = True
            title_is_frozen = True
    n1 = title.count(" (ed)")
    if n1 > 0:
        title = str(title.replace(" (ed)", mynothing, 1))
    if title == mynothing:
        title = "_Unknown_"
    if title.endswith(":"):
        title = str(title[0:-1])
        title = title.strip()
    s_lower = str(title.lower())
    s_lower = str(title.replace(" ", mynothing, 50))
    if s_lower.isalpha():
        title_probably_good = True
        title_is_frozen = True
    if title <> orig_title or force_update:
        title = str(__change_tuple_to_bytestring(title))
        title = str(title.replace("  ", " ", 4))
        title = title.strip()
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
    else:
        pass
    scrub_isbn_in_title(my_db, my_cursor,  my_current_book, notifications, log)
def scrub_final_final_title(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    global title_is_frozen
    title = ""
    orig_title = ""
    mysql = str('SELECT value from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '" ) ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            for col in row:
                s = unicodedata.normalize('NFKD', col).encode('ascii','ignore')
                orig_title = str(s)
                break
            break
    else:
        pass
    orig_title = str(__change_tuple_to_bytestring(orig_title))
    title = str(orig_title)
    title = str(__change_tuple_to_bytestring(title))
    title = str(title.replace(",", mynothing, 4))
    title = str(__remove_bad_keywords(title))
    title = str(title.replace("&u2019", "'", 4))
    if title.endswith("-"):
        title = str(title[0:-1])
    if title.endswith("#"):
        title = str(title[0:-1])
    if title.endswith("\\"):
        title = str(title[0:-1])
    if title.endswith("/"):
        title = str(title[0:-1])
    if title.endswith("."):
        title = str(title[0:-1])
    if title.endswith(":"):
        title = str(title[0:-1])
    if title.endswith(","):
        title = str(title[0:-1])
    if title.endswith(" By"):
        title = str(title[0:-3])
    if title.endswith(" Of"):
        title = str(title[0:-3])
    if title.endswith("Number 1 In"):
        title = str(title[0:-11])
    if title.endswith("Number 2 In"):
        title = str(title[0:-11])
    if title.endswith("Number 3 In"):
        title = str(title[0:-11])
    if title.endswith("Number 4 In"):
        title = str(title[0:-11])
    if title.endswith("Number 5 In"):
        title = str(title[0:-11])
    if title.endswith(" The"):
        title = str(title[0:-4])
    if title.startswith("'s"):
        title = str(title[2: ])
    if title.startswith("'S"):
        title = str(title[2: ])
    if title.startswith(":"):
        title = str(title[1: ])
    if title.startswith("Book the "):
        title = str(title[5: ])
    if title.startswith("book the "):
        title = str(title[5: ])
    if title.startswith("The: "):
        title = str(title[5: ])
    if title.startswith("The : "):
        title = str(title[6: ])
    if title.startswith(".00"):
        title = str(title[3: ])
        title = str(title.strip())
    if title.startswith("-"):
        title = str(title[1: ])
        title = str(title.strip())
    force_update = False
    if title == mynothing or title == None:
        title = "?"
        force_update = True
    my_re1 = '[M][r][A-Z]'
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group(0)
        s2 = str("Mr. " + str(s1[2:3]))
        title = str(title.replace(s1, s2, 1))
        force_update = True
    my_re1 = '[M][r][s][A-Z]'
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group(0)
        s2 = str("Mrs. " + str(s1[4:5]))
        title = str(title.replace(s1, s2, 1))
        force_update = True
    my_re1 = '[M][s][A-Z]'
    p1 = re.compile(my_re1)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group(0)
        s2 = str("Ms. " + str(s1[4:5]))
        title = str(title.replace(s1, s2, 1))
        force_update = True
    title = str(title.replace("  ", " ", 10))
    title = str(title.strip())
    if title <> orig_title:
        title = str(__add_missing_spaces_to_camelback_strings(title))
        force_update = True
    if title.startswith("Mr "):
        title = str(title.replace("Mr ", "Mr. ", 1))
    if title.startswith("Ms "):
        title = str(title.replace("Ms ", "Ms. ", 1))
    s = str(title)
    title = str(_process_title_using_title_rules(s, log))
    if str(s) <> str(title):
        special_update = True
    else:
        special_update = False
    if not force_update:
        my_re1 = '^[a-z ]+:\s[a-z, ]+$'
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                _update_title_only_special(my_db, my_cursor, title, my_current_book, notifications, log)
            return
        else:
            pass
        my_re1 = '^[0-9]*[0-9]:[0-9][0-9]$'
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                _update_title_only_special(my_db, my_cursor, title, my_current_book, notifications, log)
            return
        else:
            pass
        my_re1 = '^[0-9][0-9][0-9][0-9]$'
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                _update_title_only_special(my_db, my_cursor, title, my_current_book, notifications, log)
            return
        else:
            pass
        my_re1 = '^[a-z ,]+$'
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                _update_title_only_special(my_db, my_cursor, title, my_current_book, notifications, log)
            return
        else:
            pass
        my_re1 = "^[a-z ]+[']s\s[a-z ]+$"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if match1:
            if special_update:
                _update_title_only_special(my_db, my_cursor, title, my_current_book, notifications, log)
            return
        else:
            pass
    else:
        pass
    n1 = title.count("(")
    n2 = title.count(")")
    if n1 == 1 and n2 == 0:
        title = str(title.replace("(", mynothing, 1))
        force_update = True
    if n1 == 0 and n2 == 1:
        title = str(title.replace(")", mynothing, 1))
        force_update = True
    if title == "Collected Stories of" :
        title = "Collected Stories"
        force_update = True
    title = str(title.replace("?s", "'s", 4))
    title = str(title.replace("?S", "'s", 4))
    title = str(title.replace("Lamour", "L'amour", 4))
    title = str(title.replace("Dont", "Don't", 4))
    title = str(title.replace("A?", "A", 4))
    title = str(title.replace("Thriller La -", "Thriller -", 4))
    title = str(title.replace(" [ 1]", mynothing, 4))
    title = str(title.replace(" [ 2]", mynothing, 4))
    title = str(title.replace(" [ 3]", mynothing, 4))
    title = str(title.replace(" [ 4]", mynothing, 4))
    title = str(title.replace(" [ 5]", mynothing, 4))
    title = str(title.replace(" [ 5]", mynothing, 4))
    if title.startswith("It Is "):
        title = str(title.replace("It Is ", "It's ", 1))
    if title.endswith(" The"):
        title = str("The " + str(title[0:-3]))
        title = str(title.strip())
    title = str(title.strip())
    n1 = len(title)
    n2 = title.count("_Unknown_")
    if n1 == 9 and n2 > 0:
        force_update = False
    else:
        title = str(title.replace("_Unknown_", mynothing, 4))
        title = str(title.strip())
        force_update = True
    if title == "Untitled" or title == "untitled":
        title = "_Unknown_"
        force_update = True
    if title == "Unknown_" :
        title = "_Unknown_"
        force_update = True
    n1 = title.count("Volume I")
    if n1 > 0:
        force_update = True
    if title_is_frozen:
        if (not force_update) and (not special_update):
            return
        else:
            pass
    else:
        pass
    orig_title = str(title)
    if title == mynothing:
        return
    if title == "_":
        title = "_Unknown_"
    title = str(__add_missing_spaces_to_camelback_strings(title))
    if title == "Untitled" or title == "untitled":
        title = "_Unknown_"
    if title == "Unknown_" :
        title = "_Unknown_"
    if title.isupper():
        title = str(title.lower())
    title = str(title.replace("()", mynothing, 4))
    title = str(title.replace("[]", mynothing, 4))
    title = str(title.replace("Dont", "Don't", 4))
    title = str(title.strip())
    n1 = len(title)
    n2 = title.count("_Unknown_")
    if n1 == 9 and n2 > 0:
        force_update = False
    else:
        title = str(title.replace("_Unknown_", mynothing, 4))
        title = str(title.strip())
        force_update = True
    title = str(titlecase(title))
    title = str(title.strip())
    my_re1 = "^(?P<grp1>[a-z]+\s[a-z]+)\s.+[ ](?P=grp1)$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s1 = match1.group('grp1')
        n = title.rfind(s1)
        if n == 0:
            pass
        else:
            title = str(title[0:n-1])
            if any(char.isdigit() for char in title):
                title = str(s1)
            else:
                pass
            title = str(title.strip())
            force_update = True
    else:
        pass
    s = str(title)
    title = str(_process_title_using_title_rules(s, log))
    if str(s) <> str(title):
        special_update = True
    if title == mynothing:
        title = "?"
        special_update = True
    if (title <> orig_title) or force_update or special_update:
        title_probably_good = True
        title = str(__change_tuple_to_bytestring(title))
        title = str(title.replace("  ", " ", 4))
        title = title.strip()
        if title == mynothing:
            title = "?"
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
    else:
        pass
def _update_title_only_special(my_db, my_cursor, title, my_current_book, notifications, log):
    global title_probably_good
    title_probably_good = True
    title = str(__change_tuple_to_bytestring(title))
    title = str(title.replace("  ", " ", 4))
    title = title.strip()
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
def scrub_obvious_series_still_in_title_within_delimiters(my_db, my_cursor, my_current_book, notifications, log): #fix: Pulse - Part Four (The Pulse Series)
    global mynothing
    global force_update_of_series
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        pass
    title = ""
    orig_title = ""
    real_title = ""
    tmp_rows = []
    del tmp_rows
    mysql = str('SELECT title from books WHERE id = "' + my_current_book + '"  ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            col = row[0]
            s = unicodedata.normalize('NFKD', col).encode('ascii', 'ignore')
            real_title = str(s)
            break
    else:
        return
    tmp_rows = []
    del tmp_rows
    mysql = str('SELECT value from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '" ) ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            col = row[0]
            s = unicodedata.normalize('NFKD', col).encode('ascii', 'ignore')
            orig_title = str(s)
            break
    else:
        return
    title = str(orig_title)
    title = str(__change_tuple_to_bytestring(title))
    orig_title = str(__change_tuple_to_bytestring(title))
    real_title =  str(__change_tuple_to_bytestring(real_title))
    if title == mynothing:
        return
    else:
        if not ("(" in title and ")" in title):
            if not ("[" in title and "]" in title):
                if not ("<" in title and ">" in title):
                    if not ("{" in title and "}" in title):
                        return
    p1 = title.find("(")
    p2 = title.find(")")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            title = title.replace("(","[",10)
            title = title.replace(")","]",10)
            pass
    p1 = title.find("[")
    p2 = title.find("]")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            pass
    p1 = title.find("<")
    p2 = title.find(">")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            pass
    p1 = title.find("{")
    p2 = title.find("}")
    if p1 >= 0 and p2 >= 0:
        if p2 < p1:
            return
        else:
            pass
    title = str(__change_tuple_to_bytestring(title))
    title = str(title.replace("Book One in the ", "1 ", 1))
    title = str(title.replace("Series", mynothing, 1))
    tmp_series = mynothing
    was_genericized = False
    title = title.strip()
    title = title.replace("  "," ",10)
    title = title.replace(", #",",#",2)
    if title.endswith("]") and (",#" in title):
        re_x = "[\[][\'\& \- a-z \.]+[,][ ]*[#][0-9]+[.]*[0-9]*[ ]*[\]]$"
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(title)
            if matchx:
                was_genericized = True
                s_split = title.split("[")
                title = s_split[0]
                title = title.strip()
                tmp_series = s_split[1]
                tmp_series = tmp_series.replace(", #",",#",1)
                tmp_series = tmp_series.replace(",#","   ,#  ",1)
                s_split = tmp_series.split(",#")
                tmp_series = s_split[0]
                tmp_series = tmp_series.strip()
                tmp_index = s_split[1]
                tmp_index = tmp_index.replace("]", mynothing,1)
                tmp_index = tmp_index.strip()
                mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
                __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
                title_probably_good = True
                title_is_frozen = True
                force_update_of_series = True
                __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
                return
            else:
                pass
        except Exception as e:
            log("ERROR: scrub_obvious_series_still_in_title_within_delimiters" + str(e) + "Please forward this log to the Developer.  Thank you.")
            pass
    was_genericized = False
    title = title.strip()
    if title.endswith("]") and "#" in title:
        re_x = "[\[][\'\& \- a-z \.]+[ ]*[#][0-9]+[.]*[0-9]*[ ]*[\]]$"
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(title)
            if matchx:
                was_genericized = True
                s_split = title.split("[")
                title = s_split[0]
                title = title.strip()
                tmp_series = s_split[1]
                tmp_series = tmp_series.replace("#"," #",1)
                s_split = tmp_series.split("#")
                tmp_series = s_split[0]
                tmp_series = tmp_series.strip()
                tmp_index = s_split[1]
                tmp_index = tmp_index.replace("]", mynothing,1)
                tmp_index = tmp_index.strip()
                mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
                __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
                title_probably_good = True
                title_is_frozen = True
                force_update_of_series = True
                __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
                return
            else:
                pass
        except:
            pass
    my_re1 = '\(.+\)'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        s = str(match1.group(0))
        title = str(title.replace(s, mynothing, 1))
        tmp_series = str(s)
    else:
        my_re2 =  '\[.+\]'
        p2 = re.compile(my_re2, re.IGNORECASE)
        match2 = p2.search(title)
        if match2:
            s = str(match2.group(0))
            title = str(title.replace(s, mynothing, 1))
            tmp_series = str(s)
        else:
           pass
    title = str(title.replace("[", "(", 4))
    title = str(title.replace("]", ")", 4))
    title = str(title.replace("<", "(", 4))
    title = str(title.replace(">", ")", 4))
    title = str(title.replace("{", "(", 4))
    title = str(title.replace("}", ")", 4))
    my_re3 = '\(.+\)'
    p3 = re.compile(my_re3, re.IGNORECASE)
    match3 = p3.search(title)
    if match3:
        s = str(match3.group(0))
        title = str(title.replace(s, mynothing, 3))
        tmp_series = str(s)
    else:
        pass
    if (not match1) and (not match2) and (not match3):
        return
    title = str(title.replace(":", mynothing, 4))
    title = str(title.replace(";", mynothing, 4))
    multi_book_book = False
    try:
        my_re1 = "[0-9]+[-][0-9]+"
        p1 = re.compile(my_re1, re.IGNORECASE)
        match1 = p1.search(title)
        if not match1:
            title = str(title.replace("-", mynothing, 4))
        else:
            s1 = str(match1.group(0))
            title = str(title.replace(s1,"^^|^|^^",1))
            title = str(title.replace("-", mynothing, 4))
            title = str(title.replace("^^|^|^^",s1,1))
            tmp_series = str(title.replace(s1,mynothing,1))
            multi_book_book = True
    except:
        title = str(title.replace("-", mynothing, 4))
    orig_title = str(__change_tuple_to_bytestring(orig_title))
    title = str(__change_tuple_to_bytestring(title))
    title = str(__change_tuple_to_bytestring(title))
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  title, my_current_book)
    title_probably_good = True
    tmp_series = str(tmp_series.replace("[", "(", 4))
    tmp_series = str(tmp_series.replace("]", ")", 4))
    tmp_series = str(tmp_series.replace("<", "(", 4))
    tmp_series = str(tmp_series.replace(">", ")", 4))
    tmp_series = str(tmp_series.replace("{", "(", 4))
    tmp_series = str(tmp_series.replace("}", ")", 4))
    tmp_series = str(tmp_series.replace("(", mynothing, 4))
    tmp_series = str(tmp_series.replace(")", mynothing, 4))
    tmp_series = str(tmp_series.replace("Book", mynothing, 4))
    tmp_series = str(tmp_series.replace("book", mynothing, 4))
    tmp_series = str(tmp_series.replace("#", mynothing, 2))
    tmp_series = str(tmp_series.strip())
    if not was_genericized:
        if not  multi_book_book:
            tmp_index = "0"
            tmp_index = str(__find_part_number_in_title(str(real_title)))
        else:
            tmp_index = "1"
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_index = str(__change_tuple_to_bytestring(tmp_index))
    tmp_series = str(tmp_series.replace(tmp_index, mynothing, 1))
    tmp_series = str(tmp_series.replace("  ", " ", 10))
    tmp_series = str(tmp_series.strip())
    force_update_of_series = True
    __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
def scrub_obvious_series_still_in_title_with_no_delimiters(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    title = ""
    orig_title = ""
    tmp_title = ""
    tmp_series = ""
    tmp_index = ""
    mysql = str('SELECT value from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '" ) ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            col = row[0]
            s = unicodedata.normalize('NFKD', col).encode('ascii', 'ignore')
            orig_title = str(s)
            break
    else:
        return
    orig_title = __change_tuple_to_bytestring(orig_title)
    title = __change_tuple_to_bytestring(orig_title)
    if title == mynothing:
        return
    elif ("(" in title and ")" in title):
        return
    elif ("[" in title and "]" in title):
        return
    elif ("<" in title and ">" in title):
        return
    elif ("{" in title and "}" in title):
        return
    n1 = title.count(":")
    n2 = title.count(",")
    n3 = title.count("-")
    n4 = title.count(".")
    n5 = title.count("#")
    n6 = 0
    if any(char.isdigit() for char in title):
        n6 = 1
    if n6 > 0:
        pass
    else:
        if n4 == 1:
            if n1 == 0 and n2 == 0 and n3 == 0 and n5 == 0:
                return
        else:
            if n2 == 1:
                if n1 == 0 and n3 == 0 and n4 == 0 and n5 == 0:
                    return
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(title)
    if match1:
        title = str(title.replace("/", "&", 1))
    p1 = title.find(":")
    p2 = title.find(",")
    p3 = title.find("-")
    p4 = title.find(".")
    p5 = title.find("#")
    title = __change_tuple_to_bytestring(title)
    t1 = title.find("Book")
    t2 = title.find("Series")
    t1a = title.find(" book")
    t2a = title.find(" series")
    if t1 >=0:
        pass
    else:
        if t1a >= 0:
            t1 = t1a
    if t2 >=0:
        pass
    else:
        if t2a >= 0:
            t2 = t2a
    found_digit = False
    dstart = 9999
    dend = 0
    i = -1
    for c in title:
        i = i + 1
        if c.isdigit():
            found_digit = True
            if dstart == 9999:
                dstart = i
                dend = i + 1 #init
            else:
                dend = i
        else:
            pass
    if found_digit:
        try:
            dend = dend + 1
            seriesindex = title[dstart:dend]
        except Exception as e:
            seriesindex = '0'
    else:
        seriesindex = '0'
    found_alpha = False
    for c in seriesindex:
        if not c.isdigit():
            found_alpha = True
    if found_alpha:
        seriesindex = '0'
        found_good_index = False
    else:
        found_good_index = True
    if p1 >= 0:
        is_colon = True
    else:
        is_colon = False
    if p2 >= 0:
        is_comma = True
    else:
        is_comma = False
    if p3 >= 0:
        is_dash = True
    else:
        is_dash = False
    if p4 >= 0:
        is_dot = True
    else:
        is_dot = False
    if p5 >= 0:
        is_hash = True
    else:
        is_hash = False
    if t1 >= 0:
        is_book = True
    else:
        is_book = False
    if t2 >= 0:
        is_series = True
    else:
        is_series = False
    colon_to_left_of_comma = False
    colon_to_left_of_dash = False
    colon_to_left_of_dot = False
    colon_to_left_of_hash = False
    colon_to_left_of_book = False
    colon_to_left_of_series = False
    comma_to_left_of_colon = False
    comma_to_left_of_dash = False
    comma_to_left_of_dot = False
    comma_to_left_of_hash = False
    comma_to_left_of_book = False
    comma_to_left_of_series = False
    dash_to_left_of_colon = False
    dash_to_left_of_comma = False
    dash_to_left_of_dot = False
    dash_to_left_of_hash = False
    dash_to_left_of_book = False
    dash_to_left_of_series = False
    dot_to_left_of_colon = False
    dot_to_left_of_comma = False
    dot_to_left_of_dash = False
    dot_to_left_of_hash = False
    dot_to_left_of_book = False
    dot_to_left_of_series = False
    hash_to_left_of_colon = False
    hash_to_left_of_comma = False
    hash_to_left_of_dash = False
    hash_to_left_of_dot = False
    hash_to_left_of_book = False
    hash_to_left_of_series = False
    book_to_left_of_colon = False
    book_to_left_of_comma = False
    book_to_left_of_dash = False
    book_to_left_of_dot = False
    book_to_left_of_hash = False
    book_to_left_of_series = False
    title_copy = str(title)
    try:
        title_copy = title_copy.lower()
    except:
        pass
    a1 = title_copy.find("ty-one")
    a2 = title_copy.find("ty-two")
    a3 = title_copy.find("ty-three")
    a4 = title_copy.find("ty-four")
    a5 = title_copy.find("ty-five")
    a6 = title_copy.find("ty-six")
    a7 = title_copy.find("ty-seven")
    a8 = title_copy.find("ty-eight")
    a9 = title_copy.find("ty-nine")
    if a1 >= 0 or a2 >=0 or a3 >=0 or a4 >=0 or a5 >= 0 or a6 >=0 or a7 >=0 or a8 >=0 or a9 >=0:
        is_dash = False
    if is_colon:
        if is_comma:
            if p1 < p2:
                colon_to_left_of_comma = True
            else:
                colon_to_left_of_comma = False
        if is_dash:
            if p1 < p3:
                colon_to_left_of_dash = True
            else:
                colon_to_left_of_dash = False
        if is_dot:
            if p1 < p4:
                colon_to_left_of_dot = True
            else:
                colon_to_left_of_dot = False
        if is_hash:
            if p1 < p5:
                colon_to_left_of_hash = True
            else:
                colon_to_left_of_hash = False
        if is_book:
            if p1 < t1:
                colon_to_left_of_book = True
            else:
                colon_to_left_of_book = False
        if is_series:
            if p1 < t2:
                colon_to_left_of_series = True
            else:
                colon_to_left_of_series = False
    if is_comma:
        if is_colon:
            if p2 < p1:
                comma_to_left_of_colon = True
            else:
                comma_to_left_of_colon = False
        if is_dash:
            if p2 < p3:
                comma_to_left_of_dash = True
            else:
                comma_to_left_of_dash = False
        if is_dot:
            if p2 < p4:
                comma_to_left_of_dot = True
            else:
                comma_to_left_of_dot = False
        if is_hash:
            if p2 < p5:
                comma_to_left_of_hash = True
            else:
                comma_to_left_of_hash = False
        if is_book:
            if p2 < t1:
                comma_to_left_of_book = True
            else:
                comma_to_left_of_book = False
        if is_series:
            if p2 < t2:
                comma_to_left_of_series = True
            else:
                comma_to_left_of_series = False
    if is_dash:
        if is_colon:
            if p3 < p1:
                dash_to_left_of_colon = True
            else:
                dash_to_left_of_colon = False
        if is_comma:
            if p3 < p2:
                dash_to_left_of_comma = True
            else:
                dash_to_left_of_comma = False
        if is_dot:
            if p3 < p4:
                dash_to_left_of_dot = True
            else:
                dash_to_left_of_dot = False
        if is_hash:
            if p3 < p5:
                dash_to_left_of_hash = True
            else:
                dash_to_left_of_hash = False
        if is_book:
            if p3 < t1:
                dash_to_left_of_book = True
            else:
                dash_to_left_of_book = False
        if is_series:
            if p3 < t2:
                dash_to_left_of_series = True
            else:
                dash_to_left_of_series = False
    if is_dot:
        if is_colon:
            if p4 < p1:
                dot_to_left_of_colon = True
            else:
                dot_to_left_of_colon = False
        if is_comma:
            if p4 < p2:
                dot_to_left_of_comma = True
            else:
                dot_to_left_of_comma = False
        if is_dash:
            if p4 < p3:
                dot_to_left_of_dash = True
            else:
                dot_to_left_of_dash = False
        if is_hash:
            if p4 < p5:
                dot_to_left_of_hash = True
            else:
                dot_to_left_of_hash = False
        if is_book:
            if p4 < t1:
                dot_to_left_of_book = True
            else:
                dot_to_left_of_book = False
        if is_series:
            if p4 < t2:
                dot_to_left_of_series = True
            else:
                dot_to_left_of_series = False
    if is_hash:
        if is_colon:
            if p5 < p1:
                hash_to_left_of_colon = True
            else:
                hash_to_left_of_colon = False
        if is_comma:
            if p5 < p2:
                hash_to_left_of_comma = True
            else:
                hash_to_left_of_comma = False
        if is_dash:
            if p5 < p3:
                hash_to_left_of_dash = True
            else:
                hash_to_left_of_dash = False
        if is_dot:
            if p5 < p4:
                hash_to_left_of_dot = True
            else:
                hash_to_left_of_dot = False
        if is_book:
            if p5 < t1:
                hash_to_left_of_book = True
            else:
                hash_to_left_of_book = False
        if is_series:
            if p5 < t2:
                hash_to_left_of_series = True
            else:
                hash_to_left_of_series = False
    if is_book:
        if is_colon:
            if t1 < p1:
                book_to_left_of_colon = True
            else:
                book_to_left_of_colon = False
        if is_comma:
            if t1 < p2:
                book_to_left_of_comma = True
            else:
                book_to_left_of_comma = False
        if is_dash:
            if t1 < p3:
                book_to_left_of_dash = True
            else:
                book_to_left_of_dash = False
        if is_dot:
            if t1 < p4:
                book_to_left_of_dot = True
            else:
                book_to_left_of_dot = False
        if is_hash:
            if t1 < p5:
                book_to_left_of_hash = True
            else:
                book_to_left_of_hash = False
        if is_series:
            if t1 < t2:
                book_to_left_of_series = True
            else:
                book_to_left_of_series = False
    else:
        pass
    tmp_title = __change_tuple_to_bytestring(title)
    '''
    '''
    tmp_title = str(tmp_title)
    tmp_title = __change_tuple_to_bytestring(title)
    tmp_title = str(tmp_title)
    my_re1 = "/^.+\d -/"
    my_re2 = "/^.+\d-/"
    my_re3 = "/^.+\d:/"
    my_re4 = "/^.+\d :/" #matches:  "Isles 4 : " or "ZZZZZZZ 9 : " or "ZZZZZZZ 99 :" but only if space between number and colon
    my_re5 = "^[a-z &]+[0-9]+[ -]+"
    my_re6 = "^.+\s[IV23456]+\s-\s.+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    p2 = re.compile(my_re2, re.IGNORECASE)
    p3 = re.compile(my_re3, re.IGNORECASE)
    p4 = re.compile(my_re4, re.IGNORECASE)
    p5 = re.compile(my_re5, re.IGNORECASE)
    p6 = re.compile(my_re6, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    match2 = p2.search(tmp_title)
    match3 = p3.search(tmp_title)
    match4 = p4.search(tmp_title)
    match5 = p5.search(tmp_title)
    match6 = p6.search(tmp_title)
    was_split_already = False
    if match1 and not was_split_already:
        tmp_title = tmp_title.replace(" -", "|", 1)
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
        tmp_title = str(tmp_title)
        tmp_title = __change_tuple_to_bytestring(tmp_title)
        tmp_title = str(tmp_title)
        tmp_series = str(tmp_series)
        tmp_series = __change_tuple_to_bytestring(tmp_series)
        tmp_series = str(tmp_series)
    if match2 and not was_split_already:
        tmp_title = tmp_title.replace("-", "|", 1)
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
        tmp_title = str(tmp_title)
        tmp_title = __change_tuple_to_bytestring(tmp_title)
        tmp_title = str(tmp_title)
        tmp_series = str(tmp_series)
        tmp_series = __change_tuple_to_bytestring(tmp_series)
        tmp_series = str(tmp_series)
    if match3 and not was_split_already:
        tmp_title = tmp_title.replace(":", "|", 1)
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
        tmp_title = str(tmp_title)
        tmp_title = __change_tuple_to_bytestring(title)
        tmp_title = str(tmp_title)
        tmp_series = str(tmp_series)
        tmp_series = __change_tuple_to_bytestring(tmp_series)
        tmp_series = str(tmp_series)
    if match4 and not was_split_already:
        tmp_title = tmp_title.replace(" :", "|", 1)
        title_split = tmp_title.split("|")
        tmp_title = title_split[1]
        tmp_series = title_split[0]
        was_split_already = True
        tmp_title = str(tmp_title)
        tmp_title = __change_tuple_to_bytestring(title)
        tmp_title = str(tmp_title)
        tmp_series = str(tmp_series)
        tmp_series = __change_tuple_to_bytestring(tmp_series)
        tmp_series = str(tmp_series)
    if (match5 or match6) and not was_split_already:
        n = tmp_title.count("-")
        if n == 0:
            return
        else:
            tmp_title = tmp_title.replace("-", "|", 1)
            title_split = tmp_title.split("|")
            tmp_title = title_split[1]
            tmp_series = title_split[0]
            was_split_already = True
            tmp_title = str(tmp_title)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            tmp_title = str(tmp_title.strip())
            tmp_series = str(tmp_series)
            tmp_series = str(__change_tuple_to_bytestring(tmp_series))
            tmp_series = str(tmp_series.strip())
    if was_split_already:
        s_string = str(tmp_series)
        n_start = 999
        n_end = 999
        s_string, n_start, n_end = __find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start <> 999 and n_end <> 999:
            s_number = tmp_series[n_start:n_end]
            tmp_series = tmp_series[0:(n_start - 1)]
            tmp_series = str(tmp_series)
            tmp_series = __change_tuple_to_bytestring(tmp_series)
            tmp_series = str(tmp_series)
            if set(s_number).issubset(set_of_numbers):
                seriesindex = s_number
                seriesindex = str(seriesindex)
                seriesindex = __strip_numerics(seriesindex)
                found_good_index = True
            else:
                found_good_index = False
                seriesindex = '0'
        else:
            found_good_index = False
    title_split = []
    del title_split
    scenario_passed = '0'
    if is_colon and not was_split_already:
        if (is_comma and colon_to_left_of_comma) or (not is_comma and not colon_to_left_of_comma):
            if (is_dash and colon_to_left_of_dash) or (not is_dash and not colon_to_left_of_dash):
                if (is_dot and colon_to_left_of_dot) or (not is_dot and not colon_to_left_of_dot):
                    if (is_hash and colon_to_left_of_hash) or (not is_hash and not colon_to_left_of_hash):
                        if (is_book and colon_to_left_of_book) or (not is_book and not colon_to_left_of_book):
                            if (is_series and colon_to_left_of_series) or (not is_series and not colon_to_left_of_series):
                                tmp_title = tmp_title.replace(":", "|", 1)
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '1'
                                    except:
                                        pass
                                else:
                                    pass
    if is_comma and not was_split_already:
        if (is_colon and comma_to_left_of_colon) or (not is_colon and not comma_to_left_of_colon):
           if (is_dash and comma_to_left_of_dash) or (not is_dash and not comma_to_left_of_dash):
                if (is_dot and comma_to_left_of_dot) or (not is_dot and not comma_to_left_of_dot):
                    if (is_hash and comma_to_left_of_hash) or (not is_hash and not comma_to_left_of_hash):
                        if (is_book and comma_to_left_of_book) or (not is_book and not comma_to_left_of_book):
                            if (is_series and comma_to_left_of_series) or (not is_series and not comma_to_left_of_series):
                                tmp_title = tmp_title.replace(",", "|", 1)
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '2'
                                    except:
                                        pass
                                else:
                                    pass
    if is_dash and not was_split_already:
        if (is_colon and dash_to_left_of_colon) or (not is_colon and not dash_to_left_of_colon):
            if (is_comma and dash_to_left_of_comma) or (not is_comma and not dash_to_left_of_comma):
                if (is_dot and dash_to_left_of_dot) or (not is_dot and not dash_to_left_of_dot):
                    if (is_hash and dash_to_left_of_hash) or (not is_hash and not dash_to_left_of_hash):
                        if (is_book and dash_to_left_of_book) or (not is_book and not dash_to_left_of_book):
                            if (is_series and dash_to_left_of_series) or (not is_series and not dash_to_left_of_series):
                                tmp_title = tmp_title.replace("-", "|", 1)
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '3'
                                    except:
                                        pass
                                else:
                                    pass
    if is_dot and not was_split_already:
        if (is_colon and dot_to_left_of_colon) or (not is_colon and not dot_to_left_of_colon):
            if (is_comma and dot_to_left_of_comma) or (not is_comma and not dot_to_left_of_comma):
                if (is_dash and dot_to_left_of_dash) or (not is_dash and not dot_to_left_of_dash):
                    if (is_hash and dot_to_left_of_hash) or (not is_hash and not dot_to_left_of_hash):
                        if (is_book and dot_to_left_of_book) or (not is_book and not dot_to_left_of_book):
                            if (is_series and dot_to_left_of_series) or (not is_series and not dot_to_left_of_series):
                                tmp_title = tmp_title.replace(".", "|", 1)
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[0]
                                        tmp_series = title_split[1]
                                        was_split_already = True
                                        scenario_passed = '4'
                                    except:
                                        pass
                                else:
                                    pass
    if is_book and not was_split_already:
       if (is_colon and book_to_left_of_colon) or (not is_colon and not book_to_left_of_colon):
           if (is_comma and book_to_left_of_comma) or (not is_comma and not book_to_left_of_comma):
               if (is_dash and book_to_left_of_dash) or (not is_dash and not book_to_left_of_dash):
                    if (is_dot and book_to_left_of_dot) or (not is_dot and not book_to_left_of_dot):
                        if (is_hash and book_to_left_of_hash) or (not is_hash and not book_to_left_of_hash):
                            if (is_series and book_to_left_of_series) or (not is_series and not book_to_left_of_series):
                                tmp_title = tmp_title.replace(" book", " Book", 1)
                                if is_colon:
                                    tmp_title = tmp_title.replace(":", "|", 1)
                                else:
                                    if is_dash:
                                        tmp_title = tmp_title.replace("-", "|", 1)
                                    else:
                                        pass
                                title_split = tmp_title.split("|")
                                if title_split:
                                    try:
                                        tmp_title = title_split[1]
                                        tmp_series = title_split[0]
                                        was_split_already = True
                                        scenario_passed = '5'
                                    except:
                                        pass
                                else:
                                    pass
    if is_hash and not was_split_already:
       if (is_colon and hash_to_left_of_colon) or (not is_colon and not hash_to_left_of_colon):
           if (is_comma and hash_to_left_of_comma) or (not is_comma and not hash_to_left_of_comma):
               if (is_dash and hash_to_left_of_dash) or (not is_dash and not hash_to_left_of_dash):
                    if (is_dot and hash_to_left_of_dot) or (not is_dot and not hash_to_left_of_dot):
                        if (is_book and hash_to_left_of_book) or (not is_book and not hash_to_left_of_book):
                            if (is_series and hash_to_left_of_series) or (not is_series and not hash_to_left_of_series):
                                if is_colon:
                                    tmp_title = tmp_title.replace(":", "|", 1)
                                else:
                                    if is_dash:
                                        tmp_title = tmp_title.replace("-", "|", 1)
                                    else:
                                        pass
                                    title_split = tmp_title.split("|")
                                    if title_split:
                                        try:
                                            tmp_title = title_split[1]
                                            tmp_series = title_split[0]
                                            was_split_already = True
                                            scenario_passed = '6'
                                        except:
                                            pass
                                    else:
                                        pass
    if not was_split_already:
        return
    n = len(tmp_title)
    tmp_title = str(tmp_title)
    tmp_title = str(tmp_title.replace("  ", " ", 20))
    tmp_title = tmp_title.strip()
    n = len(tmp_title)
    if scenario_passed == '3':
        tmp_title2 = mynothing
        tmp_series_number = mynothing
        need_to_swap1 = True
        tmp_title = str(tmp_title)
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        s_string = str(tmp_title)
        n_start = '999'
        n_end = '999'
        s_string,n_start,n_end = __find_numbers_in_letter_string(s_string, n_start, n_end)
        n_start = int(n_start)
        n_end = int(n_end)
        if n_start <> 999 and n_end <> 999:
            need_to_swap1 = True
            s_number = str(tmp_title[n_start:n_end + 1])
            tmp_title2 = tmp_title[0:(n_start - 1)]
            tmp_series_number = str(s_number)
            tmp_series_number = str(__strip_numerics(tmp_series_number))
        else:
            need_to_swap1 = False
        tmp_series2 = mynothing
        tmp_series_number2 = mynothing
        need_to_swap2 = True
        tmp_series = str(__change_tuple_to_bytestring(tmp_series))
        s_string = str(tmp_series)
        n_start = 999
        n_end = 999
        __find_numbers_in_letter_string(s_string, n_start, n_end)
        n_start = int(n_start)
        n_end = int(n_end)
        if n_start <> 999 and n_end <> 999:
            need_to_swap2 = False #tmp_series has numerics
            s_number = tmp_series[n_start:n_end]
            tmp_series2 = tmp_series[0:(n_start - 1)]
            tmp_series_number2 = s_number
            tmp_series_number2 = str(__strip_numerics(tmp_series_number2))
        else:
            need_to_swap2 = True
        if need_to_swap1 and need_to_swap2:
            tmp_title = tmp_series
            tmp_series = tmp_title2
            if tmp_series_number <> mynothing:
                seriesindex = tmp_series_number
                found_good_index = True
            else:
                pass
        else:
            pass
        if not need_to_swap2:
            if tmp_series_number2 <> mynothing:
                seriesindex = tmp_series_number2
                found_good_index = True
            else:
                pass
        else:
            pass
    else:
        pass
    tmp_title = str(tmp_title)
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = str(tmp_title.replace("|", " ", 10))
    tmp_title = str(tmp_title.replace("  ", " ", 10))
    tmp_title = str(tmp_title.strip())
    tmp_series = str(tmp_series)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_series = tmp_series.replace("|", " ", 10)
    tmp_series = tmp_series.replace("  ", " ", 10)
    tmp_series = str(tmp_series.strip())
    if found_good_index:
        tmp_series = str(tmp_series.replace(seriesindex, mynothing, 1))
        tmp_index = seriesindex
    else:
        pass
    if was_split_already:
        if not found_good_index:
            s_string = str(tmp_series)
            n_start = 999
            n_end = 999
            __find_numbers_in_letter_string(s_string, n_start, n_end)
            if n_start <> 999 and n_end <> 999:
                s_number = tmp_series[n_start:n_end]
                tmp_series = tmp_series[0:(n_start - 1)]
                tmp_series = str(tmp_series)
                tmp_series = __change_tuple_to_bytestring(tmp_series)
                tmp_series = str(tmp_series)
                if set(s_number).issubset(set_of_numbers):
                    seriesindex = s_number
                    seriesindex = str(seriesindex)
                    seriesindex = str(__strip_numerics(seriesindex))
                    found_good_index = True
                else:
                    found_good_index = False
            else:
                found_good_index = False
    if found_good_index:
        tmp_series = str(tmp_series.replace(seriesindex, mynothing, 1))
        tmp_index = seriesindex
        tmp_index = str(tmp_index)
        tmp_index = str(__strip_numerics(tmp_index))
    else:
        seriesindex = '0'
        tmp_index = '0'
    tmp_series = tmp_series.replace('#', mynothing, 10)
    tmp_series = tmp_series.replace('Book', mynothing, 10)
    tmp_series = tmp_series.replace('book', mynothing, 10)
    tmp_series = tmp_series.replace('-', mynothing, 10)
    tmp_series = tmp_series.replace('Series', mynothing, 10)
    tmp_series = tmp_series.replace('series', mynothing, 10)
    tmp_series = tmp_series.replace(',', mynothing, 10)
    tmp_series = tmp_series.replace("  ", " ", 10)
    tmp_series = tmp_series.strip()
    tmp_title = str(tmp_title)
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_title, my_current_book)
    tmp_index = str(tmp_index)
    tmp_index = str(__strip_numerics(tmp_index))
    tmp_series = str(tmp_series)
    tmp_series = __change_tuple_to_bytestring(tmp_series)
    if tmp_series <> "" and tmp_series <> " ":
        __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
def scrub_the_lewis_the_lover_scenario(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    mysql = "SELECT booktitle FROM __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            i = 0
            for col in row:
                if i == 0:
                    tmp_title = str(col)
                    break
                i = i + 1
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    n = tmp_title.count('"')
    if n > 0:
        tmp_title = str(tmp_title.replace('"', mynothing, 10))
    my_re1 = "^[a-z&]+\.[0-9]+\.[a-z]+\.[a-z]+\.[a-z.]+19[0-9][0-9]"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
       scrub_the_lewis_the_lover_scenario_more(my_db, my_cursor, my_current_book, notifications, log)
       return
    my_re_all = my_re1
    my_re_series_index =  "^[a-z&]+\.[0-9]+\."
    my_re_all_up_to_year = "^[a-z&]+\.[0-9]+\.[a-z]+\.[a-z]+\.[a-z.]+"
    p1 = re.compile(my_re_series_index, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
       return
    else:
        s1 = match1.group(0)
        s1 = str(s1)
        s1 = str(__change_tuple_to_bytestring(s1))
    p2 = re.compile(my_re_all_up_to_year, re.IGNORECASE)
    match2 = p2.search(tmp_title)
    if not match2:
       return
    else:
        s2 = match2.group(0)
        s2 = str(s2)
        s2 = str(__change_tuple_to_bytestring(s2))
    s3 = str(s2.replace(s1, mynothing, 1))
    tmp_series = str(s1.replace(".", " ", 50))
    tmp_series = str(tmp_series.strip())
    tmp_title = str(s3.replace(".", " ", 50))
    tmp_title = str(tmp_title.strip())
    new_title = str( str(tmp_title) + " " + "[" + str(tmp_series) + "]" )
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                            (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  new_title, my_current_book)
def scrub_the_lewis_the_lover_scenario_more(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    mysql = "SELECT booktitle FROM __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            i = 0
            for col in row:
                if i == 0:
                    tmp_title = str(col)
                    break
                i = i + 1
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    n = tmp_title.count('"')
    if n > 0:
        tmp_title = str(tmp_title.replace('"', mynothing, 10))
    my_re1 = "^Novel[.][0-9]+[.][a-z']+[.]*[a-z']*[.]*[a-z']*[.]+19[0-9][0-9]$"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
       return
    s0 = str(tmp_title[6: ])
    n1 = s0.find(".")
    s1 = str(s0[n+1: ])
    n2 = s1.rfind(".")
    s2 = str(s1[0:n2])
    s2 = str(s2.replace(".", " ", 50))
    new_title = str(s2.strip())
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                            (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  new_title, my_current_book)
def scrub_good_series_also_in_title(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    global title_is_frozen
    global partial_blankout_scenario
    partial_blankout_scenario = False
    if title_probably_good or title_is_frozen:
        return
    tmp_rows = []
    del tmp_rows
    tmp_title = mynothing
    tmp_series = mynothing
    tmp_seriesfull = mynothing
    mysql = "SELECT booktitle, seriesname, seriesfull FROM __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            i = 0
            for col in row:
                if i == 0:
                    tmp_title = str(col)
                if i == 1:
                    tmp_series = str(col)
                if i == 2:
                    tmp_seriesfull = str(col)
                    break
                i = i + 1
            break
    else:
        return
    if tmp_title == mynothing or tmp_series == mynothing or tmp_seriesfull == mynothing:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    orig_title = str(__change_tuple_to_bytestring(tmp_title))
    backup_title = str(orig_title)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_seriesfull = str(__change_tuple_to_bytestring(tmp_seriesfull))
    tmp_seriesfull = str(tmp_seriesfull.replace("[", mynothing, 1))
    tmp_seriesfull = str(tmp_seriesfull.replace("]", mynothing, 1))
    n_start = 999
    n_end = 999
    s_string = str(tmp_seriesfull)
    s_string, n_start, n_end = __find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start <> 999 and n_end <> 999:
        s_number = tmp_seriesfull[n_start:n_end]
    else:
        return
    s_number = str(__strip_numerics(s_number))
    if s_number == " " or s_number == mynothing:
        return
    try:
        s_int = int(s_number)
    except:
        pass
    if s_int < 10 :
        tmp_seriesfull = tmp_seriesfull.replace(" 1", " 01", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 2", " 02", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 3", " 03", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 4", " 04", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 5", " 05", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 6", " 06", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 7", " 07", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 8", " 08", 1)
        tmp_seriesfull = tmp_seriesfull.replace(" 9", " 09", 1)
    else:
        pass
    search_1 = str("(" + str(tmp_seriesfull) + ")")
    search_2 = str("(" + str(tmp_seriesfull) + ")")
    search_2 = str(search_2.replace("0", mynothing, 1))
    search_3 = str("(" + str(tmp_series) + ")")
    search_4 = str(tmp_series)
    search_5 = str(tmp_seriesfull)
    search_6 = str(tmp_seriesfull)
    search_6 = str(search_6.replace("0", mynothing, 1))
    n1 = tmp_title.find(search_1)
    n2 = tmp_title.find(search_2)
    n3 = tmp_title.find(search_3)
    n4 = tmp_title.find(search_4)
    n5 = tmp_title.find(search_5)
    n6 = tmp_title.find(search_6)
    if n1 >= 0:
        tmp_title = str(tmp_title.replace(search_1, mynothing, 1))
    if n2 >= 0:
        tmp_title = str(tmp_title.replace(search_2, mynothing, 1))
    if n3 >= 0:
        tmp_title = str(tmp_title.replace(search_3, mynothing, 1))
    if n5 >= 0:
        tmp_title = str(tmp_title.replace(search_5, mynothing, 1))
    if n6 >= 0:
        tmp_title = str(tmp_title.replace(search_6, mynothing, 1))
    if n4 >= 0:
        tmp_title = str(tmp_title.replace(search_4, mynothing, 1))
    tmp_title = str(tmp_title.strip())
    if tmp_title.startswith(":") or tmp_title.startswith("-"):
        tmp_title = str(tmp_title[1: ])
        tmp_title = str(tmp_title.strip())
    tmp_title = str(tmp_title.strip())
    if tmp_title.endswith("-"):
        tmp_title = str(tmp_title[0:-1])
    tmp_title = str(tmp_title.replace("  ", " ", 10))
    tmp_title = tmp_title.strip()
    if not tmp_title > " ": #example:  true title was Deadlocked but the true seriesname was also Deadlocked, so true title replaced/blanked out erroneously.
        tmp_title = str(tmp_series)
    force_update = False
    n = tmp_title.find("[")
    tmp_title1 = str(tmp_title[0:n])
    tmp_title1 = str(tmp_title1.strip())
    if tmp_title1.endswith(" the") or tmp_title1.endswith(" a") or tmp_title1.endswith(" an") \
                                                  or tmp_title1.endswith(" The") or tmp_title1.endswith(" A") or tmp_title1.endswith(" An") :
        tmp_title = str(orig_title)
        tmp_title = str(tmp_title.strip())
        partial_blankout_scenario = True
        force_update = True
    if not force_update:
        n_series = orig_title.count(str("[" + str(tmp_series)))
        n_far_test = orig_title.find("[")
        if n_series > 0 and n_far_test > 3:
            n_tmp_series = len(tmp_series)
            n_left_bracket_tmp = tmp_title.find("[")
            n_left_bracket_orig = orig_title.find("[")
            if n_left_bracket_tmp == n_left_bracket_orig:
                s_orig = str(orig_title[n_left_bracket_orig: ])
                s_tmp = str(tmp_title[n_left_bracket_tmp:])
                n_s_orig = len(s_orig)
                n_s_tmp = len(s_tmp)
                if n_s_orig <> n_s_tmp:
                    s_tmp_title = str(tmp_title[0:n_left_bracket_tmp])
                    s_tmp_title = str(str(s_tmp_title) + str(s_orig))
                    tmp_title = str(s_tmp_title)
                    partial_blankout_scenario = True
                else:
                    partial_blankout_scenario = False
            else:
                pass
        else:
            pass
    else:
        pass
    if orig_title <> tmp_title or force_update:
        if tmp_title > " ":
            title_probably_good = True
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            tmp_title = str(titlecase(tmp_title))
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                        (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_title, my_current_book)
        else:
            title_probably_good = True
            pass
    else:
        pass
def scrub_title_index_series_in_title(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global finished_scrub_title_index_series_in_title
    global series_re_pattern_to_remove
    if finished_scrub_title_index_series_in_title:
        return
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    tmp_title_rows = []
    del tmp_title_rows
    mysql = 'SELECT booktitle from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title = str(row)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = tmp_title.strip()
    tmp_title = str(tmp_title.replace("Book One in the ", "1 ", 1))
    tmp_title = str(tmp_title.replace("Series", mynothing, 1))
    my_re1 = "^.+[a-zA-Z]\s-\s[a-zA-Z]+[0-9]+\s-\s[a-zA-Z]+.+"
    my_re2 = "^.*[a-zA-Z]\s-"
    my_re3 = "\s-\s[a-zA-Z]+[0-9]+\s-\s"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    s_part1 = str(re.sub(my_re2, mynothing, tmp_title))
    s_part1 = str(__change_tuple_to_bytestring(s_part1))
    s_part2 = str(re.sub(my_re3, "|", tmp_title))
    s_part2 = str(__change_tuple_to_bytestring(s_part2))
    s_list1 = s_part1.split("-")
    s_list2 = s_part2.split("|")
    try:
        s_left = str(s_list2[0])
        s_middle = str(s_list1[0])
        s_right = str(s_list2[1])
    except:
        return
    s_part1 = str(__change_tuple_to_bytestring(s_left))
    s_part2 = str(__change_tuple_to_bytestring(s_middle))
    s_part3 = str(__change_tuple_to_bytestring(s_right))
    '''#ensure pattern to remove is removed here
    if series_re_pattern_to_remove <> mynothing:
        myrex = str(series_re_pattern_to_remove)
        s_part3 = str(re.sub(myrex, mynothing, s_part3, count=0, flags=0))
        series_re_pattern_to_remove = mynothing
        s_part3 = str(__change_tuple_to_bytestring(s_part3))
    '''
    s_part1 = s_part1.strip()
    s_part2 = str(s_part2.replace(" ", mynothing, 10))
    s_part2 = str(s_part2.replace("-", mynothing, 10))
    s_new2 = ""
    for c in s_part2:
        s = str(c)
        s = str(__change_tuple_to_bytestring(s))
        if s.isdigit():
            s_new2 = s_new2 + s
        else:
            pass
    s_part2 = s_new2
    s_new2 = str(__change_tuple_to_bytestring(s_new2))
    s_part3 = str(__change_tuple_to_bytestring(s_part3))
    s_part3 = s_part3.strip()
    s_part1 = str(__add_missing_spaces_to_camelback_strings(s_part1))
    s_part1 = str(titlecase(s_part1))
    seriesindex = str(__strip_numerics(s_new2))
    seriesindex = __strip_leading_trailing_zeroes_from_series_index(seriesindex)
    s_part3= str(__add_missing_spaces_to_camelback_strings(s_part3))
    s_part3 = str(titlecase(s_part3))
    s_answer = "NO"
    s_string = str(s_part1)
    s_answer = str(__check_string_is_valid_series(my_db, my_cursor, s_string, log))
    if s_answer == "YES":
        s1 = str(s_part3)
        s_part3 = str(s_part1)
        s_part1 = str(s1)
    if s_part3 > " " and seriesindex > '0':
        tmp_series = str(__change_tuple_to_bytestring(s_part3))
        tmp_index = str(__change_tuple_to_bytestring(seriesindex))
        __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
    if s_part1 > " ":
        s_part1 = str(__change_tuple_to_bytestring(s_part1))
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  s_part1, my_current_book)
        finished_scrub_title_index_series_in_title = True
def scrub_title_series_index_in_title(my_db, my_cursor, my_current_book, notifications, log): #fix: The Sharp End - Hammer's Slammers 07
    global mynothing
    global finished_scrub_title_series_index_in_title
    if finished_scrub_title_series_index_in_title:
        return
    global title_probably_good
    global title_is_frozen
    if title_probably_good or title_is_frozen:
        return
    tmp_title_rows = []
    del tmp_title_rows
    mysql = 'SELECT booktitle from  __books_work_populate WHERE book = "' + my_current_book + '"  ;'
    tmp_title_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_title_rows:
        for row in tmp_title_rows:
            tmp_title = str(row)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_title = tmp_title.strip()
    my_re1 = "^.+[ a-zA-Z]-[ a-zA-Z]+[' a-zA-Z]+[0-9]+"
    my_re2 = "^.+[ a-zA-Z]-"
    my_re3 = "[0-9]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if not match1:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    s_save_numerics = str(tmp_title)
    s_save_numerics = str(__change_tuple_to_bytestring(s_save_numerics))
    s_save_numerics = str(s_save_numerics.replace("-", mynothing, 4))
    s_save_numerics = str(s_save_numerics.replace("'", mynothing, 4))
    s_save_numerics = str(s_save_numerics.replace(" ", mynothing, 10))
    s_part1 = str(re.sub(my_re3, mynothing, tmp_title))
    s_part1= str(__change_tuple_to_bytestring(s_part1))
    s_part1 = s_part1.strip()
    tmp_title = str(s_part1.replace("-", "|", 1))
    s_part3 = str(s_save_numerics)
    s_part3 = str(__change_tuple_to_bytestring(s_part3))
    s_string = str(s_part3)
    n_start = 999
    n_end = 999
    s_string,n_start,n_end = __find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start <> 999 and n_end <> 999:
        s_number = str(s_string[n_start:n_end])
        tmp_index = str(s_number)
        tmp_index = __strip_numerics(tmp_index)
    else:
        tmp_index = mynothing
        pass
    s_list1 = tmp_title.split("|")
    n = len(s_list1)
    try:
        s_left = str(s_list1[0])
        tmp_title = str(__change_tuple_to_bytestring(s_left))
        s_right = str(s_list1[1])
        tmp_series = str(__change_tuple_to_bytestring(s_right))
    except:
        return
    tmp_title = tmp_title.strip()
    tmp_title = str(__add_missing_spaces_to_camelback_strings(tmp_title))
    tmp_title = str(titlecase(tmp_title))
    tmp_series= str(__add_missing_spaces_to_camelback_strings(tmp_series))
    tmp_series = str(titlecase(tmp_series))
    tmp_index = str(__strip_numerics(tmp_index))
    tmp_index = __strip_leading_trailing_zeroes_from_series_index(tmp_index)
    s_answer = "NO"
    s_string = str(tmp_title)
    s_answer = str(__check_string_is_valid_series(my_db, my_cursor, s_string, log))
    if s_answer == "YES":
        s1 = str(tmp_series)
        tmp_series = str(tmp_title)
        tmp_title = str(s1)
    if tmp_series > " " and tmp_index > '0':
        tmp_series = str(__change_tuple_to_bytestring(tmp_series))
        tmp_index = str(__change_tuple_to_bytestring(tmp_index))
        __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
    if tmp_title > " ":
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_title, my_current_book)
        finished_scrub_title_series_index_in_title = True
def __check_string_is_valid_series(my_db, my_cursor, s_string, log):
    s_answer = "NO"
    global mynothing
    tmp_series_rows = []
    del tmp_series_rows
    s_string = str(__change_tuple_to_bytestring(s_string ))
    s_string = str(s_string.replace("  ", " ", 10))
    s_string = str(s_string.replace(",", mynothing, 10))
    s_string = str(__change_tuple_to_bytestring(s_string ))
    s_string = str(s_string.replace("[", mynothing, 10))
    s_string = str(s_string.replace("]", mynothing, 10))
    s_string = str(s_string.replace("'", mynothing, 40))
    s_string = str(s_string.replace('"', mynothing, 40))
    s_string = str(s_string.replace("  ", " ", 10))
    s_string = s_string.strip()
    s_string = str(__change_tuple_to_bytestring(s_string ))
    mysql = 'SELECT id from  _global_series WHERE name = "%s"' + ' % "' + s_string + '"  '
    tmp_series_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_series_rows:
        s_answer = "YES"
        return s_answer
    else:
        pass
    s_string = str(__change_tuple_to_bytestring(s_string ))
    tmp_series_rows = []
    del tmp_series_rows
    mysql = 'SELECT id from  _pristine_series WHERE name = "%s"' + ' % "' + s_string + '"  '
    tmp_series_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_series_rows:
        s_answer = "YES"
        return s_answer
    else:
        pass
    return s_answer
def __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log):
    global mynothing
    global set_of_symbols
    global seriesindex_probably_good
    global series_valid_globally
    global force_update_of_series
    global freeze_current_book
    freeze_current_book = True
    s_space = " "
    tmp_index = str(__strip_numerics(tmp_index))
    tmp_series = str(tmp_series)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_series = str(tmp_series.replace(",", mynothing, 10))
    tmp_series = str(tmp_series)
    if not tmp_series:
        return
    if tmp_series == mynothing:
        return
    if tmp_series.isdigit():
        return
    if tmp_series == s_space:
        return
    if tmp_series is None:
        return
    if tmp_series == "None":
        return
    n = len(tmp_series)
    if n < 2:
        return
    x = set(tmp_series)
    if x.issubset(set_of_symbols):
        return
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_series)
    if match1:
        tmp_series = str(tmp_series.replace("/", "&", 1))
    tmp_series = str(tmp_series.replace("|", mynothing, 4))
    tmp_series, tmp_index = __scrub_work_series_with_trilogy(tmp_series, tmp_index)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_series = str(tmp_series.lower())
    tmp_series = str(titlecase(tmp_series))
    tmp_index = str(__change_tuple_to_bytestring(tmp_index))
    tmp_series_rows = []
    del tmp_series_rows
    mysql = 'SELECT seriesid FROM __books_work_ids WHERE book = "' + my_current_book + '" ;'
    tmp_series_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_series_rows:
        tmp_id = tmp_series_rows[0]
        tmp_id = str(__strip_numerics(tmp_id))
        no_series_id_found = False
    else:
        no_series_id_found = True
    if tmp_id == mynothing:
        no_series_id_found = True
    if not tmp_id:
        no_series_id_found = True
    if tmp_id is None:
        no_series_id_found = True
    if tmp_id == "None":
        no_series_id_found = True
    if not tmp_id.isdigit():
        no_series_id_found = True
    if tmp_id.isalpha():
        no_series_id_found = True
    tmp_series = str(__add_missing_spaces_to_camelback_strings(tmp_series))
    tmp_series = str(tmp_series.replace(" Fbi", "FBI", 2))
    tmp_series = str(tmp_series.replace(" Cia", "CIA", 2))
    tmp_series = str(tmp_series.replace(" Nsa", "NSA", 2))
    tmp_series = str(tmp_series.replace(" Usa", "USA", 2))
    tmp_series = str(tmp_series.replace("Fbi", "FBI", 2))
    tmp_series = str(tmp_series.replace("Cia", "CIA", 2))
    tmp_series = str(tmp_series.replace("Nsa", "NSA", 2))
    tmp_series = str(tmp_series.replace("Usa", "USA", 2))
    tmp_series = str(tmp_series.replace("AnFbi", "An FBI", 2))
    tmp_series = str(tmp_series.replace("AnFBI", "An FBI", 2))
    tmp_series = str(tmp_series.replace("ACia", "A CIA", 2))
    tmp_series = str(tmp_series.replace("ACIA", "A CIA", 2))
    tmp_series = str(tmp_series.strip())
    s = str(tmp_series)
    tmp_series = str(_process_series_using_series_rules(s, log))
    if str(s) <> str(tmp_series):
        force_update_of_series = True
    if force_update_of_series and tmp_series <> mynothing and tmp_series > " ":
        mysql = str('UPDATE custom_column_10 SET value =  ? WHERE  custom_column_10.id IN \
                                    (SELECT value FROM books_custom_column_10_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_series, my_current_book)
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)"
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_series)
        sleep(0.02)
        mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)"
        __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book, my_current_book)
        check_series_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
    else:
        if not series_valid_globally:
            if tmp_series <> mynothing and tmp_series > " ":
                if no_series_id_found: #work series name not found for this book, so add it and then link it
                    mysql = "INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)"
                    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_series)
                    sleep(0.02)
                    mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)"
                    __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book, my_current_book)
                else: #work series name was found, so link tmp_id to the current book
                    mysql = "INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?)"
                    __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book, tmp_id)
                check_series_against_global_valid_values(my_db, my_cursor,  my_current_book, notifications, log)
            else:
                seriesindex_probably_good = False
                force_update_of_series = False
                return
        else:
            pass
    if force_update_of_series:
        seriesindex_probably_good = False
    if seriesindex_probably_good:
        return
    if tmp_index == mynothing or tmp_index == s_space:
        return
    if __is_number(tmp_index):
        if float(tmp_index) > 500:
            tmp_index = str(0)
        try:
            tmp_index = str(tmp_index)
            tmp_index = str(__strip_numerics(tmp_index))
            mysql = 'DELETE FROM custom_column_12 WHERE book = "' + my_current_book + '" ;'
            __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
            mysql = 'INSERT INTO custom_column_12 (id,book,value) \
                            VALUES (null, "' + my_current_book + '" , "' + tmp_index + '" );'
            __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
            seriesindex_probably_good = True
        except Exception as e:
            return
    else:
        pass
    __refresh_custom_column_15(my_db, my_cursor, my_current_book, notifications, log)
    force_update_of_series = False
def __scrub_work_series_with_trilogy(tmp_series, tmp_index): #fix: The Unfailing Light (The Katerina Trilogy 2)
    global mynothing
    s = str(__change_tuple_to_bytestring(tmp_series))
    try:
        tmp_lc = str(s.lower())
        n1 = tmp_lc.count("trilogy")
        if n1 == 0:
            return tmp_series, tmp_index
    except:
        return tmp_series, tmp_index
    s = str(s.replace("- trilogy", mynothing, 1))
    s = str(s.replace("- Trilogy", mynothing, 1))
    tmp_series = str(__change_tuple_to_bytestring(s))
    found_good_index = False
    seriesindex = '0'
    s_string = str(s)
    n_start = 999
    n_end = 999
    s_string, n_start, n_end = __find_numbers_in_letter_string(s_string, n_start, n_end)
    if n_start <> 999 and n_end <> 999:
        s_number = tmp_series[n_start:n_end]
        tmp_series = tmp_series[0:(n_start - 1)]
        tmp_series = str(tmp_series)
        tmp_series = __change_tuple_to_bytestring(tmp_series)
        tmp_series = str(tmp_series)
        if set(s_number).issubset(set_of_numbers):
            seriesindex = s_number
            seriesindex = str(seriesindex)
            tmp_index = str(__strip_numerics(seriesindex))
        else:
            pass
    else:
        pass
    return tmp_series, tmp_index
def scrub_work_series_with_numerics(my_db, my_cursor, my_current_book, notifications, log): #fix: The Shadow Dance Club 4
    global mynothing
    global set_of_numbers
    global finished_scrub_title_series_index_in_title
    global finished_scrub_title_index_series_in_title
    global force_update_of_series
    if finished_scrub_title_series_index_in_title or finished_scrub_title_index_series_in_title:
        return
    tmp_series = mynothing
    tmp_index = mynothing
    mysql = "SELECT seriesname, seriesindex from  __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            i = -1
            for col in row:
                i = i + 1
                if i == 0:
                    tmp_series = col
                else:
                    if i == 1:
                        tmp_index = col
                    else:
                        break
            break
    else:
        return
    if tmp_series == None:
        return
    tmp_series = unicodedata.normalize('NFKD', tmp_series).encode('ascii', 'ignore')
    tmp_series = str(tmp_series)
    tmp_index = str(tmp_index)
    tmp_index = str(__strip_numerics(tmp_index))
    if tmp_series == mynothing:
        return
    else:
        tmp_series = str(__change_tuple_to_bytestring(tmp_series))
        tmp_series = tmp_series.replace(",", mynothing, 4)
        tmp_index = str(__strip_numerics(tmp_index))
    if tmp_series == mynothing:
        return
    else:
        pass
    my_re1 = "\s*[a-zA-Z]+/[a-zA-Z]+"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_series)
    if match1:
        tmp_series = str(tmp_series.replace("/", "&", 1))
    found_good_index = False
    seriesindex = '0'
    s_string = str(tmp_series)
    n_start = 999
    n_end = 999
    s_string, n_start, n_end = __find_numbers_in_letter_string(s_string, n_start, n_end)
    n_start = int(n_start)
    n_end = int(n_end)
    if n_start <> 999 and n_end <> 999 :
        s_number = tmp_series[n_start:n_end]
        if n_start <> 0:
            tmp_series = tmp_series[0:(n_start - 1)]
        tmp_series = str(tmp_series)
        tmp_series = __change_tuple_to_bytestring(tmp_series)
        tmp_series = str(tmp_series)
        if set(s_number).issubset(set_of_numbers):
            seriesindex = s_number
            seriesindex = str(seriesindex)
            seriesindex = __strip_numerics(seriesindex)
            found_good_index = True
            tmp_series = str(tmp_series.replace(str(s_number), mynothing, 1))
            force_update_of_series = True
        else:
            pass
    else:
        pass
    if found_good_index and seriesindex <> '0':
        tmp_index = str(seriesindex)
    if tmp_index == mynothing:
        tmp_index = str(seriesindex)
    tmp_index = str(tmp_index)
    tmp_index = str(__strip_numerics(tmp_index))
    tmp_series = str(tmp_series)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series ))
    tmp_series = tmp_series.replace(str(tmp_index), mynothing, 4)
    tmp_series = tmp_series.replace("  ", " ", 4)
    tmp_series = tmp_series.replace("[]", mynothing, 4)
    tmp_series = tmp_series.replace("()", mynothing, 4)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_series = str(tmp_series.replace("  ", " ", 10))
    tmp_series = str(tmp_series.replace(",", mynothing, 10))
    tmp_series = str(tmp_series.replace("[", mynothing, 10))
    tmp_series = str(tmp_series.replace("]", mynothing, 10))
    tmp_series = str(tmp_series.replace("'", mynothing, 40))
    tmp_series = str(tmp_series.replace('"', mynothing, 40))
    tmp_series = str(tmp_series.replace("  ", " ", 10))
    tmp_series = tmp_series.strip()
    tmp_series = str(__change_tuple_to_bytestring(tmp_series ))
    if tmp_series <> mynothing and tmp_series > " ":
        __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
def scrub_worktitle_workseries_swapped(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    global seriesindex_probably_good
    if title_probably_good:
        return
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT booktitle, seriesname, seriesindex from __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            c = -1
            if c > 2:
                break
            else:
                for col in row:
                    c = c + 1
                    if c == 0:
                        title = str(col)
                    else:
                        if c == 1:
                            series = str(col)
                        else:
                            if c == 2:
                                series_index = str(col)
                            else:
                                pass
    else:
        pass
    title = str(__change_tuple_to_bytestring(title))
    title = str(title.replace(",", mynothing, 4))
    series = str(__change_tuple_to_bytestring(series))
    series = str(series.replace(",", mynothing, 4))
    series_index = str(__change_tuple_to_bytestring(series_index))
    series_index = str(series_index.replace(",", mynothing, 4))
    series_index = str(series_index.replace(".0", mynothing,1))
    nt = title.find(series_index)
    ns = series.find(series_index)
    need_to_update = False
    if nt > 0 and ns < 0 and series_index <> "0":
        tmp_title = str(series)
        tmp_series = str(title)
        tmp_series = str(tmp_series.replace(series_index, mynothing, 2))
        need_to_update = True
    else:
        pass
    tmp_index = str( "0" + str(series_index))
    nt = title.find(tmp_index)
    ns = series.find(tmp_index)
    if nt > 0 and ns < 0 and tmp_index <> "00":
        tmp_title = str(series)
        tmp_series = str(title)
        tmp_series = str(tmp_series.replace(tmp_index, mynothing, 2))
        need_to_update = True
    else:
       pass
    case_b_valid = True
    if (not series_index == "0") and (not series_index == 0):
        case_b_valid = False
    if not (series.isalpha()):
        s_string = str(series)
        n_start = 999
        n_end = 999
        s_string, n_start, n_end  = __find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start <> 999 and n_end <> 999:
            case_b_valid = False
    if not title.isalpha():
        s_string = str(title)
        n_start = 999
        n_end = 999
        s_string, n_start, n_end  = __find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start <> 999 and n_end <> 999:
            pass
    else:
        case_b_valid = False
    if case_b_valid:
        mysql = "SELECT title from books WHERE id = '" + my_current_book + "' ;"
        tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if tmp_rows:
            for row in tmp_rows:
                s_title = str(row)
                s_title = str(__change_tuple_to_bytestring(s_title))
                s_title = str(s_title.strip())
                break
        else:
             return
        n1 = s_title.find(title)
        n2 = s_title.find(":")
        n3 = s_title.find("-")
        if n1 < 0:
            case_b_valid = False
        if n2 < 0 and n3 < 0:
            case_b_valid = False
    else:
        pass
    if not case_b_valid and not need_to_update:
        return
    if case_b_valid:
        tmp_title = str(series)
        tmp_series = str(title)
        s_string = str(tmp_series)
        s_start = 999
        s_end = 999
        s_string, n_start, n_end  = __find_numbers_in_letter_string(s_string, n_start, n_end)
        if n_start <> 999 and n_end <> 999:
            s_number = tmp_series[n_start:n_end]
            s_number =  str(__strip_numerics(s_number))
            tmp_series = str(tmp_series.replace(s_number, mynothing, 2))
            if not s_number.isalpha():
                tmp_index = s_number
            else:
                tmp_index = '0'
        else:
            return
        need_to_update = True
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_title, my_current_book)
    title_probably_good = True
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    mysql = str('UPDATE custom_column_10 SET value =  ? WHERE  custom_column_10.id IN \
                                (SELECT value FROM books_custom_column_10_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_series, my_current_book)
    tmp_index = str(__change_tuple_to_bytestring(tmp_index))
    mysql = str('UPDATE custom_column_12 SET value =  ? WHERE  book = ? ')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_index, my_current_book)
    seriesindex_probably_good = True
def scrub_tags(my_db, my_cursor, my_current_book, notifications, log, probable_tags_to_add):
    global mynothing
    global set_of_letters
    global set_of_numbers
    global set_of_numbers_letters
    global set_of_symbols
    global set_of_author_symbols
    global set_of_letters_and_author_symbols
    global set_of_title_characters
    global set_of_numbers_and_symbols
    global tag_regex_rules
    global tag_capitalization_regex_rules
    global single_work_tags_all
    temp = set(probable_tags_to_add)
    probable_tags_to_add = list(temp)
    del temp
    npt = len(probable_tags_to_add )
    tmp_temp = mynothing
    del tmp_temp
    tmp_tag_rows = []
    del tmp_tag_rows
    tmp_tag_rows1 = []
    del tmp_tag_rows1
    tmp_tags = mynothing
    del tmp_tags
    mysql = 'SELECT value FROM custom_column_13 WHERE custom_column_13.id IN \
                                (SELECT value FROM books_custom_column_13_link WHERE book = "' + my_current_book + '");'
    tmp_tag_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_tag_rows:
        if npt == 0:
            return
        else:
            tmp_temp = str("")
            for item in probable_tags_to_add:
                tmp_temp = str(tmp_temp) + str(str(item) + ", ")
            tmp_tag_rows = []
            tmp_tag_rows.append(str(tmp_temp))
    else:
        for row in tmp_tag_rows:
            for col in row:
                u0 = col
                u0 = unicodedata.normalize('NFKD',u0).encode('ascii', 'ignore')
                tmp_tag_rows[0] = u0
                break
            break
        if npt == 0:
            pass
        else:
            tmp_temp = str("")
            for item in probable_tags_to_add:
                tmp_temp = str(tmp_temp) + str(str(item) + ", ")
            tmp_tag_rows.append(str(tmp_temp))
    tmp_tag_rows.sort()
    tmp_tags_concat = str(mynothing)
    for row in tmp_tag_rows:
        try:
            tmp_tags = str(unicodedata.normalize('NFKD', row).encode('ascii','ignore'))
        except:
            tmp_tags = str(row)
        tmp_tags = str(__change_tuple_to_bytestring(tmp_tags))
        if tmp_tags <> mynothing:
            tmp_tags_concat = str(str(tmp_tags_concat) + ", " + str(tmp_tags))
            tmp_tags_concat = str(__change_tuple_to_bytestring(tmp_tags_concat))
        else:
            pass
    tmp_tags = str(tmp_tags_concat)
    tmp_tags = str(__change_tuple_to_bytestring(tmp_tags))
    orig_tags = str(tmp_tags)
    if tmp_tags == mynothing:
        tmp_tags = "DELETE"
    tmp_tags = str(tmp_tags.replace(",,", ",", 20))
    tmp_tags = str(tmp_tags.replace(", ,", ",", 20))
    if ";" in tmp_tags:
        tmp_tags = str(tmp_tags.replace(";", ",", 500))
    tmp_tags = str(tmp_tags.replace(" & ", "&", 10))
    tmp_tags = str(tmp_tags.replace(" &", "&", 10))
    tmp_tags = str(tmp_tags.replace("& ", "&", 10))
    new_tags = ""
    tag_rows = []
    del tag_rows
    tmp_tags = str(__change_tuple_to_bytestring(tmp_tags))
    tmp_tags = tmp_tags.strip()
    if tmp_tags.endswith(","): #erroneous, so fix it here
        tmp_tags = str(tmp_tags[ :-1])
    if tmp_tags.startswith(","): #erroneous, so fix it here
        tmp_tags = str(tmp_tags[ 1: ])
    if tmp_tags.startswith(", "): #erroneous, so fix it here
        tmp_tags = str(tmp_tags[ 2: ])
    tmp_tags = str(tmp_tags.strip())
    n = tmp_tags.count(",")
    if n > 0: #meaning at least 2 tags concatenated
        tag_rows = tmp_tags.split(",")
        multiple_tags = True
    else: #single tag with no commas so nothing to split
        tag_rows = []
        tag_rows.append(str(tmp_tags))
        multiple_tags = False
    if not tag_rows:
        return
    tag_rows.sort()
    tmp_set = set(tag_rows)
    tag_rows = list(tmp_set)
    tag_rows.sort()
    del tmp_set
    for row in tag_rows:
        force_update = False
        tmp_tag = str(row)
        tmp_tag = str(__change_tuple_to_bytestring(tmp_tag))
        n1 = tmp_tag.find("(*_*)")
        if n1 >= 0:
            tmp_tag = mynothing
        tmp_tag = str(tmp_tag)
        tmp_tag = str(tmp_tag.replace("(", mynothing, 10))
        tmp_tag = str(tmp_tag.replace(")", mynothing, 10))
        tmp_tag = str(tmp_tag.strip())
        tmp_tag = str(__change_tuple_to_bytestring(tmp_tag))
        tmp_tag = str(tmp_tag.strip())
        if tmp_tags.endswith(","):
            tmp_tags = str(tmp_tags[ :-1])
        if tmp_tags.startswith(", "):
            tmp_tags = str(tmp_tags[ 2: ])
        if tmp_tags.startswith(","):
            tmp_tags = str(tmp_tags[ 1: ])
        tmp_tag = str(tmp_tag.strip())
        tmp_tag = str(__remove_bad_keywords(tmp_tag))
        orig_tmp_tag = str(tmp_tag)
        tmp_tag = str(tmp_tag.lower())
        tmp_tag = str(__scrub_isbn_in_tags(my_db, my_cursor, my_current_book, tmp_tag, notifications, log))
        tmp_tag = str(__change_tuple_to_bytestring(tmp_tag))
        tmp_tag = str(tmp_tag.replace(", ", mynothing))
        tmp_tag = str(tmp_tag.strip())
        if tmp_tag == mynothing:
            tmp_tag = str("DELETE")
        if not tmp_tag == "DELETE":
            my_cursor.execute("SELECT oldtag,newtag,purgetag FROM _tag_rules WHERE oldtag = ?", (orig_tmp_tag,))
            tagdata = my_cursor.fetchall()
            if tagdata:
                if len(tagdata) > 0:
                    check_regex = False
                    for row in tagdata:
                        oldtag,newtag,purgetag = row
                        purgetag = str(purgetag)
                        if purgetag >= "1":
                            tmp_tag = "DELETE"
                        else:
                            tmp_tag = str(newtag)
                            if tmp_tag == mynothing:
                                tmp_tag = "DELETE"
                            else:
                                tmp_tag = str(__change_tuple_to_bytestring(tmp_tag))
                            if tmp_tag <> mynothing:
                                force_update = True
                                check_regex = True
                            else:
                                tmp_tag = "DELETE"
                else:
                    check_regex = True
            else:
                check_regex = True
            if not check_regex:
                pass
            else:
                for row in tag_regex_rules:
                    rule_list = row.split("<|!!|>")
                    re1 = str(rule_list[0])
                    try:
                        p1 = re.compile(re1, re.IGNORECASE)
                        match1 = p1.search(tmp_tag)
                        if match1:
                            if rule_list[2] >= '1':
                                tmp_tag = "DELETE"
                                break
                            else:
                                if rule_list[1] > " " and rule_list[1] <> "None" :
                                    tmp_tag = str(rule_list[1])
                                    force_update = True
                                    break
                                else:
                                    log("REGEX rule is inconsistent; please correct; rule bypassed:", str(re1))
                                    break
                        else:
                            continue
                    except Exception as e:
                        log("Table _tag_rules REGEX Rule Compile Error:" + str(e))
                        log("REGEX rule was:" + str(re1))
                        log("Please fix your REGEX rule via table _tag_rules maintenance.  Bypassing bad rule and continuing.")
                        continue
        else:
            pass
        new_tags = str(new_tags.replace(", None, ", ", ", 8))
        new_tags = str(new_tags.replace(",None, ", ",", 8))
        new_tags = str(new_tags.replace("None, ", mynothing, 8))
        tmp_tag = str(tmp_tag.replace("Glbt", "GLBT", 1))
        tmp_tag = str(tmp_tag.replace("Cia", "CIA", 1))
        tmp_tag = str(tmp_tag.replace("Nsa", "NSA", 1))
        tmp_tag = str(tmp_tag.replace("Usa", "Usa", 1))
        tmp_tag = str(tmp_tag.replace(" adult", " Adult", 1))
        if tmp_tag == mynothing:
            tmp_tag = str("DELETE")
        n1 = len(tmp_tag)
        if n1 > 50:
            tmp_tag = mynothing
        tmp_tag = str(tmp_tag.strip())
        n1 = tmp_tag.count(" ")
        if n1 > 5:
            tmp_tag = mynothing
        if tmp_tag == mynothing:
            tmp_tag = str("DELETE")
        if set(tmp_tag).issubset(set_of_numbers):
            tmp_tag = str("DELETE")
        if set(tmp_tag).issubset(set_of_symbols):
            tmp_tag =  str("DELETE")
        my_BISAC = "^[A-Z][A-Z][A-Z][0-9][0-9][0-9][0-9][0-9][$0-9]"
        p1 = re.compile(my_BISAC, re.IGNORECASE)
        match1 = p1.search(str(tmp_tag))
        if match1:
            try:
                tmp_tag = str(tmp_tag.upper())
            except:
                pass
            tmp_subject_rows = []
            del tmp_subject_rows
            mysql = 'SELECT subject FROM _global_subject_codes WHERE code = "' +  tmp_tag  + '" ;'
            tmp_subject_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
            if tmp_subject_rows:
                tmp_tag = str(tmp_subject_rows[0])
                tmp_tag = str(__change_tuple_to_bytestring(tmp_tag))
                force_update = True
            else:
                tmp_tag = str(tmp_tag.strip())
                s_tmp = str(tmp_tag[0:3])
                s_code = str(s_tmp + "000000"  )
                s_code = str(s_code)
                s_code = __change_tuple_to_bytestring(s_code)
                s_code = str(s_code.replace(",", mynothing, 4))
                tmp_subject_rows = []
                del tmp_subject_rows
                mysql = 'SELECT subject FROM _global_subject_codes WHERE code = "' +  s_code  + '" ;'
                tmp_subject_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
                if tmp_subject_rows:
                    tmp_tag = str(tmp_subject_rows[0])
                    tmp_tag = str(__change_tuple_to_bytestring(tmp_tag))
                    force_update = True
                else:
                    log("Subject Code Not Found in Q&S Table:", s_code)
                    pass
        else:
            pass
        tmp_tag = str(tmp_tag)
        if tmp_tag <> "DELETE" and tmp_tag <> mynothing and tmp_tag <> "NONE":
            if not force_update:
                try:
                    tmp_tag = str(tmp_tag.lower())
                except:
                    pass
                tmp_tag = str(titlecase(tmp_tag))
            if multiple_tags:
                tmp_tag = str(tmp_tag.strip())
                n = len(str(tmp_tag))
                if n > 0:
                    try:
                        if "(*_*)" in tmp_tag:
                            continue
                        else:
                            pass
                    except:
                        continue
                    tmp_tag = str(_check_other_names_as_tagname(my_db, my_cursor, log, tmp_tag, my_current_book))
                    if tmp_tag <> mynothing:
                        n1 = new_tags.find(tmp_tag)
                        single_work_tags_all.append(tmp_tag)
                        if n1 < 0:
                            new_tags = str(new_tags + str(tmp_tag + ', '))
                        else:
                            pass
                    else:
                        pass
                else:
                    pass
            else:
                pass
        else:
            pass
    if new_tags == "None":
        new_tags = "DELETE"
    if new_tags == mynothing:
        new_tags = "DELETE"
    if not multiple_tags:
        new_tags = str(tmp_tag)
        new_tags = str(new_tags.strip())
        if new_tags.endswith(","): #erroneous, so fix it here
            new_tags = str(new_tags[ :-1])
        single_work_tags_all.append(new_tags)
    if multiple_tags:
        new_tags = str(new_tags)
        new_tags = str(new_tags.strip())
        if new_tags.endswith(","): #erroneous, so fix it here
            new_tags = str(new_tags[ :-1])
        if new_tags.startswith(","): #erroneous, so fix it here
            new_tags = str(new_tags[ 1: ])
    new_tags = str(__change_tuple_to_bytestring(new_tags))
    new_tags = str(new_tags.strip())
    if new_tags == "None":
        new_tags = "DELETE"
    n1 = new_tags.count("None")
    if n1 > 0:
        new_tags = str(new_tags.replace("None", mynothing, 5))
        new_tags = str(new_tags.strip())
        if new_tags.endswith(","): #erroneous, so fix it here
            new_tags = str(new_tags[ :-1])
        if new_tags.startswith(","): #erroneous, so fix it here
            new_tags = str(new_tags[ 1: ])
        new_tags = str(new_tags.strip())
    tmp_tags = str(tmp_tags.replace(",,", ",", 8))
    tmp_tags = str(tmp_tags.replace(", , ", ", ", 8))
    tmp_tags = str(tmp_tags.replace(", ,", ",", 8))
    tmp_tags = str(tmp_tags.replace("«", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("»", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("‹", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("›", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("from:", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("From:", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("to:", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("To:", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("–", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("—", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("†", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("‡", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("§", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("•", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("¶", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("®", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("©", mynothing, 20))
    tmp_tags = str(tmp_tags.replace("°", mynothing, 20))
    if new_tags == "DELETE":
        new_tags = mynothing
        force_update = False
    new_tags = str(apply_tag_capitalization_rules(str(new_tags),log))
    if (orig_tags <> new_tags and new_tags <> mynothing) or (force_update):
        if new_tags == mynothing:
            log("LOGIC ERROR IN new_tags; == mynothing")
            pass
        else:
            if isinstance(new_tags, str):
                new_tags = unicode(new_tags)
            mysql = str('DELETE FROM books_custom_column_13_link WHERE book = ? AND book = ? ')
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, my_current_book)
            mysql = "INSERT OR REPLACE INTO custom_column_13 (id,value) VALUES (?,?)"
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, new_tags)
            sleep(0.05)
            mysql = str('INSERT OR REPLACE INTO books_custom_column_13_link (id,book,value) VALUES (?,?,?) ;')
            __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book, my_current_book)
    else:
        if new_tags == mynothing:
            mysql = str('DELETE FROM books_custom_column_13_link WHERE book = ? AND book = ? ')
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, my_current_book)
        else:
            pass
    del tag_rows
    del new_tags
    probable_tags_to_add[:] = [] #empties it, and does not change the existance of the list variable itself
def _check_other_names_as_tagname(my_db, my_cursor, log, tmp_tag, my_current_book):
    global mynothing
    tmp_tag = str(tmp_tag)
    tmp_tag = str(tmp_tag.strip())
    if tmp_tag == mynothing or (not len(tmp_tag) > 0 ):
        return
    try:
        s = str(tmp_tag)
        tmp_tag = str(tmp_tag.replace('"', mynothing, 10))
        if str(s) <> str(tmp_tag):
            return str(tmp_tag)
    except:
        return str(tmp_tag)
    sleep(0.05)
    mysql = 'SELECT  exists  (SELECT value FROM custom_column_4 WHERE value  = "' + tmp_tag + '"  \
                    AND id = [BOOK] ) '
    mysql = str(mysql.replace("[BOOK]", my_current_book, 1))
    tmp_exist = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = str(col)
                if answer == "1":
                    log(" ")
                    log("Author as a Tag Has Been Removed:   " + str(tmp_tag))
                    tmp_tag = str(mynothing)
                    return tmp_tag
                    break
            break
    sleep(0.05)
    mysql = 'SELECT  exists  (SELECT value FROM custom_column_8 WHERE value  = "' + tmp_tag + '"  \
                    AND id = [BOOK] ) '
    mysql = str(mysql.replace("[BOOK]", my_current_book, 1))
    tmp_exist = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = str(col)
                if answer == "1":
                    log(" ")
                    log("Title as a Tag Has Been Removed:   " + str(tmp_tag))
                    tmp_tag = str(mynothing)
                    return tmp_tag
                    break
            break
    sleep(0.05)
    mysql = 'SELECT  exists  (SELECT value FROM custom_column_10 WHERE value  = "' + tmp_tag + '"  \
                    AND id = [BOOK] ) '
    mysql = str(mysql.replace("[BOOK]", my_current_book, 1))
    tmp_exist = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = str(col)
                if answer == "1":
                    log(" ")
                    log("Series Name as a Tag Has Been Removed:   " + str(tmp_tag))
                    tmp_tag = str(mynothing)
                    return tmp_tag
                    break
            break
    sleep(0.05)
    n1 = tmp_tag.count(" ")
    if n1 == 0:
        return tmp_tag
    n1 = len(tmp_tag)
    if n1 < 11:
        return tmp_tag
    mysql = 'SELECT  exists  (SELECT value FROM custom_column_4 WHERE value LIKE  "%' + tmp_tag + '%"  ) '
    tmp_exist = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = str(col)
                if answer == "1":
                    log(" ")
                    log("Tag with Author Name Has Been Removed:   " + str(tmp_tag))
                    tmp_tag = str(mynothing)
                    return tmp_tag
                    break
            break
    sleep(0.05)
    mysql = 'SELECT  exists  (SELECT value FROM custom_column_10 WHERE value LIKE  "%' + tmp_tag + '%"  ) '
    tmp_exist = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_exist:
        return
    else:
        for row in tmp_exist:
            for col in row:
                answer = str(col)
                if answer == "1":
                    log(" ")
                    log("Tag with Series Name Has Been Removed:   " + str(tmp_tag))
                    tmp_tag = str(mynothing)
                    return tmp_tag
                    break
            break
    return str(tmp_tag)
def __scrub_isbn_in_tags(my_db, my_cursor, my_current_book, tmp_tag, notifications, log):
    global mynothing
    tmp_tag = str(tmp_tag.replace("isbn:", mynothing, 1))
    tmp_tag = str(tmp_tag.replace("isbn", mynothing, 1))
    tag = tmp_tag.strip()
    orig_tag = str(tag)
    my_re13a = "^97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re13b = "^97[8-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    my_re13c = "97[8-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]"
    my_re10a = "^[0-1][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9X]"
    my_re10b = "^[0-1][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9][-0-9]"
    p13a = re.compile(my_re13a, re.IGNORECASE)
    match13a = p13a.search(tag)
    if match13a:
        tag = re.sub(my_re13a, mynothing, tag)
    else:
        p13b = re.compile(my_re13b, re.IGNORECASE)
        match13b = p13b.search(tag)
        if match13b:
            tag = re.sub(my_re13b, mynothing, tag)
        else:
            p13c = re.compile(my_re13c, re.IGNORECASE)
            match13c = p13c.search(tag)
            if match13c:
                tag = re.sub(my_re13c, mynothing, tag)
            else:
                p10a = re.compile(my_re10a, re.IGNORECASE)
                match10a = p10a.search(tag)
                if match10a:
                    tag = re.sub(my_re10a, mynothing, tag)
                else:
                    p10b = re.compile(my_re10b, re.IGNORECASE)
                    match10b = p10b.search(tag)
                    if match10b:
                        tag = re.sub(my_re10b, mynothing, tag)
                    else:
                        return str(tag)
    tag = str(__change_tuple_to_bytestring(str(tag)))
    tag = str(tag.replace(",", mynothing, 8))
    tag = str(tag.replace("_", mynothing, 8))
    tag = str(tag.replace("'", mynothing, 8))
    tag = str(tag.replace("  ", " ", 8))
    tag = str(tag.strip())
    isbn = str(orig_tag.replace(str(tag), mynothing, 1))
    isbn = str(isbn.replace(" ", mynothing, 10))
    isbn = str(isbn.replace("-", mynothing, 10))
    isbn = str(isbn.replace("_", mynothing, 10))
    isbn = str(isbn.replace(":", mynothing, 10))
    isbn = str(isbn.strip())
    good_isbn = False
    if match13a or match13b:
        good_isbn = str(__isbn13checksum(isbn))
    else:
        good_isbn = str(__isbn10checksum(isbn))
    if not good_isbn:
        return str(tag)
    else:
        pass
    new_isbn = str(_convert_isbn_convert_10_to_13(isbn))
    if new_isbn:
        try:
            unicode_isbn = isbn.decode("utf8")
        except:
            pass
        if (new_isbn <> isbn) and (unicode_isbn.isnumeric()) and (len(new_isbn) == 13) and (not new_isbn.startswith("978978")):
            log("Valid ISBN10 Converted to ISBN13:" + str(isbn) + " >>> " + str(new_isbn))
            isbn = str(new_isbn)
        else:
            pass
    mysql = str('INSERT OR REPLACE INTO identifiers (id,book,type,val) VALUES (null,?,"isbn",?)')
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(my_current_book,isbn))
        my_cursor.execute("commit")
        log("Valid ISBN extracted and updated for book with tag of:", str(orig_tag))
    except Exception as e:
        log(str(e))
        pass #not going to stop just for this
    return str(tag)
def scrub_final_author_title_switched(my_db, my_cursor, my_current_book, notifications, log):
    global author_valid_globally
    global author_probably_good
    global title_probably_good
    if author_valid_globally:
        return
    if author_probably_good:
        return
    if title_probably_good:
        return
    tmp_rows = []
    del tmp_rows
    tmp_title = ""
    tmp_author_id = '0'
    mysql = str('SELECT value from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '" ) ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            col = row[0]
            s = unicodedata.normalize('NFKD', col).encode('ascii', 'ignore')
            tmp_title = str(s)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            break
    tmp_auth_rows = []
    del tmp_auth_rows
    author_valid_globally = False
    mysql = 'SELECT * from _global_authors WHERE name = "' + tmp_title + '"  ;'
    tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_auth_rows:
        for row in tmp_auth_rows:
            author_valid_globally = True
            break
    else:
        mysql = 'SELECT * from _pristine_authors WHERE name = "' + tmp_title + '"  ;'
        tmp_auth_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if tmp_auth_rows:
            for row in tmp_auth_rows:
                author_valid_globally = True
                break
    if not author_valid_globally:
        return
    tmp_rows = []
    del tmp_rows
    new_title = ""
    mysql = 'SELECT authname FROM  __books_work_populate  WHERE book = "' + my_current_book + '" ; '
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            new_title = str(row)
            new_title = str(__change_tuple_to_bytestring(new_title))
            break
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT value FROM books_custom_column_4_link WHERE book = '" + my_current_book + "' ; "
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        return
    else:
        for row in tmp_rows:
            tmp_author_id = str(row)
            tmp_author_id = str(__change_tuple_to_bytestring(tmp_author_id))
            break
    new_title = str(__add_missing_spaces_to_camelback_strings(new_title))
    mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  new_title, my_current_book)
    new_author = str(tmp_title)
    tmp_author_id = str(tmp_author_id)
    tmp_author_id = str(__change_tuple_to_bytestring(tmp_author_id))
    tmp_rows = []
    del tmp_rows
    new_author = str(__add_missing_spaces_to_camelback_strings(new_author))
    mysql = 'SELECT id FROM custom_column_4 WHERE value = "' + new_author + '" ;'
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        tmp_author_id = "00000"
    else:
        for row in tmp_rows:
            tmp_author_id = str(row)
            tmp_author_id = str(__change_tuple_to_bytestring(tmp_author_id))
            break
    tmp_author_id = str(__change_tuple_to_bytestring(tmp_author_id))
    tmp_author_id = str(tmp_author_id.replace("(", mynothing, 4))
    tmp_author_id = str(tmp_author_id.replace(")", mynothing, 4))
    tmp_author_id = str(tmp_author_id.replace(",", mynothing, 4))
    if tmp_author_id == "00000":
        mysql = "INSERT INTO custom_column_4 (id,value) VALUES (?,?)"
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, None, new_author)
        tmp_author_id = str(my_db.last_insert_rowid() )
        tmp_author_id = str(__change_tuple_to_bytestring(tmp_author_id))
        tmp_author_id = str(tmp_author_id.replace("(", mynothing, 4))
        tmp_author_id = str(tmp_author_id.replace(")", mynothing, 4))
        tmp_author_id = str(tmp_author_id.replace(",", mynothing, 4))
        mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  ;'
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_author_id, my_current_book)
    else:
        mysql = 'UPDATE books_custom_column_4_link SET value = ? WHERE book = ?  ;'
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_author_id, my_current_book)
def scrub_final_work_series_format(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global force_update_of_series
    global probable_seriesname_to_add
    force_update_of_series = False
    nps = len(probable_seriesname_to_add)
    if nps == 0:
        no_probable_seriesname_to_add = True
    else:
        no_probable_seriesname_to_add = False
    mysql = "SELECT seriesname, seriesindex from  __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            i = -1
            for col in row:
                i = i + 1
                if i == 0:
                    tmp_series = col
                else:
                    if i == 1:
                        tmp_index = col
                    else:
                        break
            break
    else:
        if no_probable_seriesname_to_add:
            return
        else:
            pass
    if tmp_series == None:
        if no_probable_seriesname_to_add:
            return
        else:
            tmp_series = str(probable_seriesname_to_add[0])
            tmp_index = "0"
    if isinstance(tmp_series,unicode):
        tmp_series = unicodedata.normalize('NFKD', tmp_series).encode('ascii', 'ignore')
    tmp_series = str(tmp_series)
    tmp_index = str(tmp_index)
    tmp_index = str(__strip_numerics(tmp_index))
    if (tmp_series == mynothing or tmp_series == "None" )  and no_probable_seriesname_to_add:
        return
    else:
        tmp_series = str(__change_tuple_to_bytestring(tmp_series))
        tmp_series = tmp_series.replace(",", mynothing, 4)
    if (tmp_series == mynothing or tmp_series == "None" ) and no_probable_seriesname_to_add:
        return
    else:
        pass
    if no_probable_seriesname_to_add:
        pass
    else:
        if tmp_series > " " and tmp_series <> "None" and tmp_series <> "None" :
            pass
        else:
            tmp_series = str(probable_seriesname_to_add[0])
            tmp_series = str(__change_tuple_to_bytestring(tmp_series))
            tmp_series = tmp_series.replace(",", mynothing, 4)
            force_update_of_series = True
    orig_series = str(tmp_series)
    tmp_series = str(tmp_series.replace("Series=", mynothing, 1))
    tmp_series = str(tmp_series.replace("#", mynothing, 2))
    tmp_series = str(tmp_series.replace("html", mynothing, 2))
    tmp_series = str(tmp_series.replace("Html", mynothing, 2))
    tmp_series = str(tmp_series.replace("bookzz.org", mynothing, 2))
    tmp_series = str(tmp_series.replace("Bookzz.org", mynothing, 2))
    tmp_series = str(tmp_series.replace("Fantasy Paranormal Romance", mynothing, 1))
    tmp_series = str(tmp_series.replace("BDSM Erotic Romance", mynothing, 1))
    tmp_series = str(tmp_series.replace("Short Story", mynothing, 1))
    tmp_series = str(tmp_series.replace("Kindle Single", mynothing, 1))
    tmp_series = str(tmp_series.replace("Book One in the", mynothing, 1))
    tmp_series = str(tmp_series.replace("S of ", mynothing, 1))
    tmp_series = str(tmp_series.replace("Romance / Romantic Suspense", mynothing, 1))
    tmp_series = str(tmp_series.replace("Domination / Erotic Romance", mynothing, 1))
    tmp_series = str(tmp_series.replace("With Bonus Material", mynothing, 1))
    tmp_series = str(tmp_series.replace("BBW Billionaire Erotic Romance Novella", mynothing, 1))
    tmp_series = str(tmp_series.replace("()", mynothing, 1))
    tmp_series = str(tmp_series.replace("[]", mynothing, 1))
    tmp_series = str(tmp_series.strip())
    if tmp_series.endswith(" Articles by"):
        tmp_series = str(tmp_series.replace(" Articles by", mynothing, 1))
    if tmp_series.endswith(" Novel"):
        tmp_series = str(tmp_series[0:-6])
    if tmp_series.startswith("A of the "):
        tmp_series = str(tmp_series[9: ])
    if tmp_series.startswith("Of the "):
        tmp_series = str(tmp_series[7: ])
    s0 = str(tmp_index)
    s0 = str(s0.replace(".0","",1))
    s0 = str(s0.strip())
    tmp_series = tmp_series.strip()
    if tmp_series.endswith(".0"):
        tmp_series = tmp_series[0:-2]
    if tmp_series.endswith(s0):
        n0 = len(tmp_series)
        n1 = len(s0)
        tmp_series = tmp_series[0:(n0-n1)]
    tmp_series = str(__remove_bad_keywords(tmp_series))
    tmp_series = tmp_series.replace(" Part One", mynothing, 4)
    tmp_series = tmp_series.replace(" Part Two", mynothing, 4)
    tmp_series = tmp_series.replace(" Part Three", mynothing, 4)
    tmp_series = tmp_series.replace("&&", "&", 4)
    tmp_series = str(tmp_series.replace("&", " & ", 2))
    tmp_series = str(tmp_series.replace("  ", " ", 10))
    tmp_series = str(titlecase(tmp_series))
    tmp_series = str(tmp_series.replace(" Fbi", "FBI", 2))
    tmp_series = str(tmp_series.replace(" Cia", "CIA", 2))
    tmp_series = str(tmp_series.replace(" Nsa", "NSA", 2))
    tmp_series = str(tmp_series.replace(" Usa", "USA", 2))
    tmp_series = str(tmp_series.replace("Fbi", "FBI", 2))
    tmp_series = str(tmp_series.replace("Cia", "CIA", 2))
    tmp_series = str(tmp_series.replace("Nsa", "NSA", 2))
    tmp_series = str(tmp_series.replace("Usa", "USA", 2))
    tmp_series = str(tmp_series.replace("Nypd", "NYPD", 2))
    tmp_series = str(tmp_series.replace("AnFBI ", "An FBI ", 1))
    tmp_series = str(tmp_series.replace("ACIA ", "A CIA ", 1))
    tmp_series = str(tmp_series.replace("Dci ", "DCI ", 1))
    tmp_series = str(tmp_series.replace("Di ", "DI ", 1))
    tmp_series = str(tmp_series.strip())
    if tmp_series.endswith("Novel"):
        if tmp_series.startswith("A ") or tmp_series.startswith("An "):
            tmp_series = str(tmp_series[2:-5])
            tmp_series = str(tmp_series.strip())
    if tmp_series == "Vol":
        tmp_series == "Volume"
    if tmp_series.endswith(" S"):
        if tmp_series.startswith("The "):
            tmp_series = str(tmp_series[ :-1] + "Books")
    if tmp_series.endswith("."):
        tmp_series = str(tmp_series[0:-1])
    if tmp_series.isupper():
        try:
            tmp_series = tmp_series.lower()
            tmp_series = tmp_series.title()
        except:
            pass
    if tmp_series == mynothing:
        force_update_of_series = True
    has_letters = False
    has_hash = False
    has_parens = False
    for item in tmp_series:
        s = str(item)
        if s.isalpha():
            has_letters = True
        if s == ")" or s == "(" :
            has_parens = True
            break
    if has_letters and (not has_parens):
        s_original = str(tmp_series)
        tmp_series = str(__add_missing_spaces_to_camelback_strings(tmp_series))
        if len(tmp_series) < len(s_original):
            tmp_series = str(s_original)
    else:
        pass
    tmp_series = str(tmp_series.strip())
    tmp_rows = []
    del tmp_rows
    mysql = str('SELECT value from custom_column_8 WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '" ) ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            col = row[0]
            s = unicodedata.normalize('NFKD', col).encode('ascii', 'ignore')
            tmp_title = str(s)
            tmp_title = str(__change_tuple_to_bytestring(tmp_title))
            break
        if tmp_index == 0 or tmp_index == "0":
            if tmp_series == tmp_title:
                tmp_series = mynothing
    tmp_series = tmp_series.replace("()", mynothing, 4)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    orig_series = str(__change_tuple_to_bytestring(orig_series))
    tmp_rows = []
    del tmp_rows
    mysql = "SELECT series_index FROM books where id = '" + my_current_book + "'  ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        tmp_index = mynothing #do not want to update it from here
    else:
        for row in tmp_rows:
            real_index = str(row)
            real_index = str(__strip_numerics(real_index))
            if (real_index > tmp_index) or (real_index > "0.0" and tmp_index == "0.0") :
                if (tmp_index == "0.5" or tmp_index == "0.50") and (real_index == "1" or real_index == "1.0"):
                    pass
                else:
                    tmp_index = str(real_index)
            else:
                tmp_index = mynothing #do not want to update it from here
            break
    s = str(tmp_series)
    tmp_series = str(_process_series_using_series_rules(s, log))
    if str(s) <> str(tmp_series):
        force_update_of_series = True
    if tmp_series <> orig_series or tmp_index <> mynothing or force_update_of_series :
        if (tmp_series <> mynothing and tmp_series > " "):
            force_update_of_series = True
            __generic_update_work_series_seriesindex(my_db, my_cursor, my_current_book, tmp_series, tmp_index, log)
        else:
            mysql = str('UPDATE custom_column_10 SET value =  ? WHERE  custom_column_10.id IN \
                            (SELECT value FROM books_custom_column_10_link WHERE book = ? ) ;')
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  "None", my_current_book)
            mysql = "DELETE FROM books_custom_column_10_link WHERE book = ? AND book <> ?  ;"
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  my_current_book, "DUMMY")
            mysql = "DELETE FROM custom_column_10 WHERE value = ?   AND value <> ? ;"
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  "None", "DUMMY")
            mysql = "UPDATE custom_column_12 SET value = 0 WHERE book = ? AND book <> ?  ;"
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  my_current_book, "DUMMY")
    else:
        pass
def scrub_misc_title_scenarios(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_probably_good
    mysql = "SELECT booktitle, seriesname, seriesindex FROM __books_work_populate WHERE book = '" + my_current_book + "' ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        for row in tmp_rows:
            i = 0
            for col in row:
                if i == 0:
                    tmp_title = str(col)
                if i == 1:
                    tmp_series = str(col)
                if i == 2:
                    tmp_seriesindex = str(col)
                    break
                i = i + 1
            break
    else:
        return
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_seriesindex = str(__strip_numerics(tmp_seriesindex))
    my_re1 = '^[0-9]*[0-9]:[0-9][0-9]$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    else:
        pass
    my_re1 = '^[0-9][0-9][0-9][0-9]$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    else:
        pass
    my_re1 = '^[a-z ]+\sEpisode\s[0-9]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    else:
        pass
    my_re1 = '^[a-z ]+[0-9]+$'
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(tmp_title)
    if match1:
        return
    else:
        pass
    if not ((tmp_title == "_Unknown_" or tmp_title == "" or tmp_title == " ") and tmp_series > " " \
                                                      and (tmp_seriesindex == "0.0" or tmp_seriesindex == "0")):
        fix_01 = False
    else:
        fix_01 = True
    fix_02 = False
    if fix_01:
        pass
    else:
        n1 = tmp_title.count("#")
        n2 = tmp_title.count("[ ")
        n3 = tmp_title.count("]")
        s = str(tmp_title[-2: ])
        s = str(s.strip())
        n4 = 0
        try:
            sn = int(s)
            n4 = 999
            nv = tmp_title.count("Vol")
            nb = tmp_title.count("Book")
            nd = tmp_title.count("-")
            nc = tmp_title.count(":")
            ni = tmp_title.count("Issue")
            if nv == 0 and nb == 0 and nd == 0 and ni == 0 and nc == 0:
                tmp_title = str(tmp_title.replace(str(sn), mynothing, 2))
                tmp_title = str(tmp_title.strip())
                fix_02 = True
        except:
            n4 == 0
        if n1 == 0 and n2 == 0 and n3 == 0:
            pass
        else:
            orig_title = str(tmp_title)
            if not fix_02:
                for i in range(0, 100):
                    s4 = str("[ #" + str(i) + "]")
                    n4 = tmp_title.count(s4)
                    s5 = str("[ #" + str("0" + str(i) + "]"))
                    n5 = tmp_title.count(s5)
                    s6 = str("#" + str(i))
                    n6 = tmp_title.count(s6)
                    if n4 > 0:
                        tmp_title = str(tmp_title.replace(s4, mynothing, 1))
                    if n5 > 0:
                        tmp_title = str(tmp_title.replace(s5, mynothing, 1))
                    if n6 > 0:
                        tmp_title = str(tmp_title.replace(s6, mynothing, 1))
            else:
                pass
            if orig_title <> tmp_title:
                fix_02 = True
    fix_03 = False #remove some garbage from title at very end of scrubbing (only)
    orig_title = str(tmp_title)
    tmp_title = str(tmp_title.replace("[]", mynothing, 1))
    tmp_title = str(tmp_title.replace("[ ]", mynothing, 1))
    tmp_title = str(tmp_title.replace(" C I A", " CIA ", 1))
    tmp_title = str(tmp_title.replace(" C I a", " CIA ", 1))
    tmp_title = str(tmp_title.replace(" W T C", " WTC ", 1))
    tmp_title = str(tmp_title.replace(" N S A", " NSA ", 1))
    tmp_title = str(tmp_title.replace(" U S A", " USA ", 1))
    tmp_title = str(tmp_title.replace(" F B I", " FBI ", 1))
    tmp_title = str(tmp_title.replace("L a ", "L.A. ", 1))
    tmp_title = str(tmp_title.replace(": A Thriller", mynothing, 1))
    tmp_title = str(tmp_title.replace(": a Thriller", mynothing, 1))
    tmp_title = str(tmp_title.replace(": An Thriller", mynothing, 1))
    tmp_title = str(tmp_title.replace(": an Thriller", mynothing, 1))
    tmp_title = str(tmp_title.replace(": A Novella", mynothing, 1))
    tmp_title = str(tmp_title.replace(": a Novella", mynothing, 1))
    tmp_title = str(tmp_title.replace(": A Novel", mynothing, 1))
    tmp_title = str(tmp_title.replace(": a Novel", mynothing, 1))
    tmp_title = str(tmp_title.replace(": A Mystery", mynothing, 1))
    tmp_title = str(tmp_title.replace(": a Mystery", mynothing, 1))
    tmp_title = str(tmp_title.replace(": An Novella", mynothing, 1))
    tmp_title = str(tmp_title.replace(": an Novella", mynothing, 1))
    tmp_title = str(tmp_title.replace(": An Novel", mynothing, 1))
    tmp_title = str(tmp_title.replace(": an Novel", mynothing, 1))
    tmp_title = str(tmp_title.replace(": An Mystery", mynothing, 1))
    tmp_title = str(tmp_title.replace(": an Mystery", mynothing, 1))
    if tmp_title.startswith("Book 1"):
        tmp_title = str(tmp_title.replace("Book 1", mynothing, 1))
    if tmp_title.startswith("Book 2"):
        tmp_title = str(tmp_title.replace("Book 2", mynothing, 1))
    if tmp_title.endswith(" La") or tmp_title.endswith(" la"):
        tmp_title = str(tmp_title[0:-3])
    if tmp_title.endswith("- 1"):
        tmp_title = str(tmp_title[0:-3])
        tmp_title = str(tmp_title.strip())
    tmp_title = str(titlecase(tmp_title))
    if orig_title <> tmp_title:
        if not fix_01:
            fix_03 = True
    if (not fix_01) and (not fix_02) and (not fix_03):
        return
    if not fix_01:
        pass
    else:
        tmp_title = str(tmp_series)
        tmp_series = "DELETEME"
        title_probably_good = True
        n = tmp_title.count(".")
        if n > 5:
            tmp_title = str(tmp_title.replace(".", " ", 50))
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        tmp_title = str(titlecase(tmp_title))
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_title, my_current_book)
        mysql = "DELETE FROM books_custom_column_10_link WHERE book = ?  OR book = ? "
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, my_current_book)
        fix_01 = False
    if (not fix_02) and (not fix_03):
        pass
    else:
        tmp_title = str(tmp_title)
        tmp_title = str(__change_tuple_to_bytestring(tmp_title))
        tmp_title = str(tmp_title.strip())
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                    (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql,  tmp_title, my_current_book)
        fix_02 = False
        fix_03 = False
    if not fix_01 and not fix_02 and not fix_03:
        return
def __set_work_freeze(my_db, my_cursor, my_current_book, notifications, log):
    global freeze_current_book
    if not freeze_current_book:
        return
    mysql = "DELETE FROM custom_column_16 WHERE book = '" + my_current_book + "' ;"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "INSERT INTO custom_column_16 (id,book,value) VALUES (null, ?, ?)"
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, "1")
    add_book_to_scrubbed_books_final_list(my_db, my_cursor,  my_current_book, notifications, log)
    tmp_id_rows = []
    del tmp_id_rows
    mysql = "SELECT id FROM custom_column_18 WHERE value = 'book_ok' "
    tmp_id_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_id_rows:
        sleep(.02)
        mysql = "INSERT OR IGNORE INTO custom_column_18 (id,value) VALUES (null, 'book_ok') "
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        sleep(.02)
        mysql = "SELECT id FROM custom_column_18 WHERE value = 'book_ok' "
        tmp_id_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_id_rows:
        return
    tmp_id = tmp_id_rows[0]
    tmp_id = __strip_numerics(tmp_id)
    sleep(.02)
    mysql = "DELETE FROM books_custom_column_18_link WHERE book = ? AND book > ?"
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, "0")
    sleep(.02)
    mysql = "INSERT OR REPLACE INTO books_custom_column_18_link (id,book,value) VALUES (null,?,?) "
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_id)
def add_book_to_scrubbed_books_final_list(my_db, my_cursor,  my_current_book, notifications, log):
    global scrubbed_books_final_list
    book_dict_book = {}
    book_dict_authname = {}
    book_dict_booktitle = {}
    book_dict_seriesname = {}
    book_dict_seriesindex = {}
    book_dict_seriesfull = {}
    book_dict_tags = {}
    book_list_of_dicts = []
    mysql = "SELECT book, authname, booktitle, seriesname, seriesindex, seriesfull, tagsall \
                                FROM __books_work_populate WHERE book = '" + my_current_book + "'   ;"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    for row in tmp_rows:
        book, authname, booktitle, seriesname, seriesindex, seriesfull, tagsall = row
        book_dict_book["calibre_id"] = str(book)
        book_list_of_dicts.append(book_dict_book)
        if str(authname) == "Unknown":
            authname = str("_Unknown_")
        book_dict_authname[book] = str(authname)
        book_list_of_dicts.append(book_dict_authname)
        book_dict_booktitle[book] = str(booktitle)
        book_list_of_dicts.append(book_dict_booktitle)
        book_dict_seriesname [book] = str(seriesname)
        book_list_of_dicts.append(book_dict_seriesname)
        book_dict_seriesindex[book] = str(seriesindex)
        book_list_of_dicts.append(book_dict_seriesindex)
        book_dict_seriesfull[book] = str(seriesfull)
        book_list_of_dicts.append(book_dict_seriesfull)
        book_dict_tags[book] = str(tagsall)
        book_list_of_dicts.append(book_dict_tags)
    scrubbed_books_final_list.append(book_list_of_dicts)
    del tmp_rows
    del book_list_of_dicts
    del book_dict_book
    del book_dict_authname
    del book_dict_booktitle
    del book_dict_seriesname
    del book_dict_seriesindex
    del book_dict_seriesfull
    del book_dict_tags
def __skip_frozen_book(my_db, my_cursor,  my_current_book, notifications, log):
    global book_is_frozen
    book_is_frozen = False
    tmp_rows = []
    del tmp_rows
    mysql = 'SELECT value FROM custom_column_16 WHERE book = "' + my_current_book +  '"  ;'
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        book_is_frozen = False
    else:
        s = str(tmp_rows[0])
        s =  __strip_numerics(s)
        if s == "1":
            book_is_frozen = True
    tmp_rows = []
    del tmp_rows
    if not book_is_frozen:
        mysql = str("SELECT exists  (SELECT book FROM books_custom_column_18_link WHERE book =  [BOOK] ) ")
        mysql = str(mysql.replace("[BOOK]", my_current_book, 1))
        tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                for col in row:
                    s = str(col)
                    s =  str(__strip_numerics(s))
                    if s <> "1":
                        book_is_frozen = True
def __delete_unused_values(my_db, my_cursor, notifications, log):
    mysql = 'DELETE FROM custom_column_4 WHERE id IN __author_unused'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = 'DELETE FROM custom_column_8 WHERE id IN __title_unused'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = 'DELETE FROM custom_column_10 WHERE id IN __series_unused'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = 'DELETE FROM custom_column_13 WHERE id IN __tags_unused'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
def __update_work_columns_for_utf8_display(my_db, my_cursor, my_current_book, notifications, log):
    sleep(0.04)
    mysql = 'UPDATE custom_column_4 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_4.id IN \
                                (SELECT value FROM books_custom_column_4_link WHERE book = "' + my_current_book + '"  ) ;'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.03)
    mysql = 'UPDATE custom_column_8 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_8.id IN \
                                (SELECT value FROM books_custom_column_8_link WHERE book = "' + my_current_book + '"  ) ;'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.03)
    mysql = 'UPDATE custom_column_10 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_10.id IN \
                                (SELECT value FROM books_custom_column_10_link WHERE book = "' + my_current_book + '"  ) ;'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.03)
    mysql = 'UPDATE custom_column_13 SET value = (update_utf8_for_display(value) ) WHERE  custom_column_13.id IN \
                                (SELECT value FROM books_custom_column_13_link WHERE book = "' + my_current_book + '"  ) ;'
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.03)
def __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql):
    sleep(0.05)
    tmp_rows = []
    del tmp_rows
    tmp_rows = []
    mysql = str(mysql)
    try:
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if tmp_rows:
            return tmp_rows
        else:
            tmp_rows = []
            return tmp_rows
    except:
        log("database LOCK error; sleeping, cursor reset and will then try again")
        sleep(10.0)
        tmp_rows = []
        del tmp_rows
        tmp_rows = []
        try:
            my_db, my_cursor = __reset_cursor(my_db,log)
            my_cursor.execute("begin") #apsw
            my_cursor.execute(mysql)
            tmp_rows = my_cursor.fetchall()
            if tmp_rows:
                return tmp_rows
            else:
                tmp_rows = []
                return tmp_rows
        except Exception as e:
            log(str(e))
            my_db.close()
            raise e
            sys.exit("ERROR in __execute_mysql_fetchall_generic....")
def __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql):
    global freeze_current_book
    freeze_current_book = True
    mysql = str(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except:
        log("[1] database locked; sleeping, cursor reset and then will retry")
        sleep(10.0)
        try:
            my_db, my_cursor = __reset_cursor(my_db,log)
            my_cursor.execute("begin") #apsw
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except:
            log("[2] database still locked; cursor reset again, and will retry")
            sleep(10.0)
            try:
                my_db, my_cursor = __reset_cursor(my_db,log)
                my_cursor.execute("begin") #apsw
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
            except Exception as e:
                log(str(e))
                my_db.close()
                log("database has been CLOSED")
                log("Fatal Database Lock Error.  Restart Calibre, and Run Job Again As Needed.")
                log("Avoid Doing Anything While Jobs Are Running Due To Potential Database Locking.")
                raise e
                sys.exit("Fatal Database Lock Error.  Restart Calibre, and Run Job Again As Needed.  See Job Log.")
    sleep(0.05)
def __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, v1, v2):
    global mynothing
    global freeze_current_book
    freeze_current_book = True
    s2 = mynothing
    if v2 == mynothing or v2 is None or v2 == None:
        s2 = str("IGNORE")
        s2 = str(__change_tuple_to_bytestring(s2))
    try:
        my_cursor.execute("begin")
        if s2 <> "IGNORE":
            my_cursor.execute(mysql,(v1,v2))
        else:
            my_cursor.execute(mysql,(v1))
        my_cursor.execute("commit")
    except:
        log("database LOCK error; sleeping and will then try again")
        sleep(10.0)
        try:
            my_db, my_cursor = __reset_cursor(my_db,log)
            my_cursor.execute("begin") #apsw
            if s2 <> "IGNORE":
                my_cursor.execute(mysql,(v1,v2))
            else:
                my_cursor.execute(mysql,(v1))
                my_cursor.execute("commit")
        except Exception as e:
            log(str(e))
            my_db.close()
            log("database has been CLOSED")
            raise e
            sys.exit("ERROR in __execute_mysql_for_custom_column_generic")
    sleep(0.05)
def __execute_mysql_for_custom_column_generic_1_arg(my_db, my_cursor, log, mysql, v1):
    global mynothing
    global freeze_current_book
    freeze_current_book = True
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1))
        my_cursor.execute("commit")
    except:
        log("database locked; sleeping and then will retry")
        sleep(10.0)
        try:
            my_db, my_cursor = __reset_cursor(my_db,log)
            my_cursor.execute("begin") #apsw
            my_cursor.execute(mysql,(v1))
            my_cursor.execute("commit")
        except Exception as e:
            log(str(e))
            my_db.close()
            log("database has been CLOSED")
            raise e
            sys.exit("ERROR in __execute_mysql_for_custom_column_generic_1_arg")
    sleep(0.05)
def __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, v1, v2, v3):
    global mynothing
    global freeze_current_book
    freeze_current_book = True
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,(v1,v2,v3))
        my_cursor.execute("commit")
    except:
        log("database locked; sleeping and then will retry")
        sleep(10.0)
        try:
            my_db, my_cursor = __reset_cursor(my_db,log)
            my_cursor.execute("begin") #apsw
            my_cursor.execute(mysql,(v1,v2,v3))
            my_cursor.execute("commit")
        except Exception as e:
            log(str(e))
            my_db.close()
            log("database has been CLOSED")
            raise e
            sys.exit("ERROR in __execute_mysql_for_custom_column_generic_3_args")
    sleep(0.05)
def __add_missing_spaces_to_camelback_strings(s):
    s = str(s)
    s = str(__change_tuple_to_bytestring(s))
    s = str(s.replace("  ", " ", 10))
    s = str(s.strip())
    n = s.find(" ")
    if n > 0: #multiple words
        if n > 1: #do not change if has more than 2 words
            s = str(s.replace("NotSo", "Not-So-"))
            s = str(s.replace("notso", "not-so-"))
            return s
        else:
            s_list = s.split(" ")
            n = len(s_list)
    else:
        n = 0
    found_reason_to_return = False
    if n > 1:
        i = 0
        while i < n:
            s1 = s_list[i]
            if s1.islower() or s1.isupper(): #e.g. SEAL or any lowercase; they are not camelback
                pass
            else:
                s2 = s1[0:-1]
                if s2.isupper():
                    found_reason_to_return = True
                else:
                    pass
            i = i + 1
    else:
        if s.islower() or s.isupper():
            found_reason_to_return = True
        else:
            s1 = s[0:-1] #e.g. SEAL in SEALs
            if s1.isupper():
                found_reason_to_return = True
            else:
                pass
    if found_reason_to_return:
        return s
    try:
        s[0] = str(s[0].upper())
    except:
        pass
    try:
        pos = [i for i,e in enumerate(s) if e.isupper()]
        parts = []
        for j in xrange(len(pos)):
            try:
                parts.append(str(s[pos[j]:pos[j+1]]))
            except IndexError:
                parts.append(str(s[pos[j]:]))
        parts = str(parts)
        parts = str(__change_tuple_to_bytestring(parts))
        parts = str(parts.replace(",", mynothing, 10))
        parts = str(__change_tuple_to_bytestring(parts ))
        parts = str(parts.replace("[", mynothing, 10))
        parts = str(parts.replace("]", mynothing, 10))
        parts = str(parts.replace("'", mynothing, 40))
        parts = str(parts.replace('"', mynothing, 40))
        parts = str(parts.replace("  ", " ", 10))
        if parts.startswith(" "):
            parts = str(parts[1: ])
        parts = str(__change_tuple_to_bytestring(parts))
        return parts
    except:
        return s
def __change_tuple_to_bytestring(tuple):
    global mynothing
    s_string = str(tuple)
    try:
        s_string = s_string.replace('(u"', mynothing, 100)
        s_string = s_string.replace("(u'", mynothing, 100)
        s_string = s_string.replace("',))", mynothing, 100)
        s_string = s_string.replace("',)", mynothing, 100)
        s_string = s_string.replace('",)', mynothing, 100)
        s_string = s_string.replace('u"', mynothing, 100)
        s_string = s_string.replace("u'", mynothing, 100)
        s_string = s_string.replace("'(", "'", 100)
        s_string = s_string.replace(")'", "'", 100)
        s_string = s_string.replace('u"', mynothing, 100)
        s_string = s_string.replace('")', mynothing, 100)
    except:
        s_string = str("Corrupt Data Requires Manual Correction")
        return s_string
    s_string = str(s_string)
    n1 = s_string.find("(")
    n2 = s_string.find(")")
    if n1 >= 0:
        if n2 >= 0 and n2 > n1:
            return s_string
        else:
            pass
    n1 = s_string.count("(")
    n2 = s_string.count(")")
    if n2 == 2 and n1 == 1:
        return s_string
    if n2 == 1 and n1 == 0:
        return s_string
    n = s_string.find("(")
    if n == 0: #example:  is (199)
        s_string = s_string.replace("(", mynothing, 1)
        c = s_string.count(")")
        if c == 1:
            s_string = s_string.replace(")", mynothing, 1)
        else:
            pass
    n = s_string.rfind("'")
    l = len(s_string)
    if n == (l - 1):
        z = (n - 1)
        s_string = s_string[0:z]
    else:
        pass
    n = s_string.rfind(")")
    l = len(s_string)
    if n == (l - 1):
        z = (n - 1)
        s_string = s_string[0:z]
        pass
    n = s_string.rfind("'")
    l = len(s_string)
    if n == (l - 1):
        z = (n - 1)
        s_string = s_string[0:z]
    else:
        pass
    n = s_string.rfind(")")
    l = len(s_string)
    if n == (l - 1):
        z = (n - 1)
        s_string = s_string[0:z]
        pass
    s_string = s_string.strip()
    if isinstance(s_string, unicode):
        s_string = str(s_string)
        if isinstance(s_string, unicode):
            pass
    return s_string
def __is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        return False
def __strip_numerics(s):
    global mynothing
    s = str(s)
    s = __change_tuple_to_bytestring(s)
    s = s.replace(',', mynothing, 4)
    s = s.replace("(", mynothing, 4)
    s = s.replace(")", mynothing, 4)
    s = s.replace(" ", mynothing, 10)
    s = s.strip()
    return s
def __find_numbers_in_letter_string(s_string, n_start, n_end):
    s_apostrophe = "'"
    s_space = " "
    s_split_symbol = "|"
    s_colon = ":"
    s_bracketl = "["
    s_bracketr = "]"
    s_amp = "&"
    s_string = str(__change_tuple_to_bytestring(s_string))
    n_utf8 = s_string.count("\\")
    if n_utf8 > 0:
        n_start = 999
        n_end = 999
        return s_string, n_start, n_end
    for item in s_string:
        c = item
        if ( (not c.isalpha()) and (not c.isdigit()) and (not (c == s_space)) and (not (c == s_apostrophe)) and (not( c == s_split_symbol)) \
                                         and (not (c == s_colon)) and (not (c == s_bracketl)) and (not (c == s_bracketr)) \
                                        and (not (c == s_amp))         ):
            n_start = 999
            n_end = 999
            return s_string, n_start, n_end
        else:
            pass
    n_start = 999
    n_end = 999
    i = -1
    for item in s_string:
        c = item
        i = i + 1
        if (not c.isdigit()):
            if n_start <> 999:
                if (not c == "."):
                    n_end = i -1
                    break
                else:
                    n_end = i
            else:
                    pass #a letter or space, not a number, prior to the first number, such as:  abcdefg 98
        else:
            if n_start == 999:
                n_start = i
            else:
                n_end = i
    if n_start <> 999 :
        if n_end == 999 :
            n = len(s_string)
            n_end = n
            return s_string, n_start, n_end
    if n_end <> 999 :
        n_end = n_end + 1
    return s_string, n_start, n_end
def __find_part_number_in_title(s):
    s = str(s)
    s_orig = str(s)
    s = str(__change_tuple_to_bytestring(s))
    s = s.lower()
    n1 = 0
    n2 = 0
    n3 = 0
    n4 = 0
    n5 = 0
    n6 = 0
    n7 = 0
    n8 = 0
    n9 = 0
    n10 = 0
    n1 = s.count("part one")
    n2 = s.count("part two")
    n3 = s.count("part three")
    n4 = s.count("part four")
    n5 = s.count("part five")
    n6 = s.count("part six")
    n7 = s.count("part seven")
    n8 = s.count("part eight")
    n9 = s.count("part nine")
    n10 = s.count("part ten")
    n = "0"
    if n1 > 0: n = "1"
    if n2 > 0: n = "2"
    if n3 > 0: n = "3"
    if n4 > 0: n = "4"
    if n5 > 0: n = "5"
    if n6 > 0: n = "6"
    if n7 > 0: n = "7"
    if n8 > 0: n = "8"
    if n9 > 0: n = "9"
    if n10 > 0: n = "10"
    n = __strip_numerics(n)
    if n <> "0":
        return n
    my_re1 = "[0-9]+[.]*[5]*[0]*"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(s_orig)
    if match1:
        s_num = str(match1.group(0))
        s_num = str(__strip_numerics(s_num))
        return s_num
    n0 = 0
    n1 = 0
    n15 = 0
    n2 = 0
    n25 = 0
    n3 = 0
    n35 = 0
    n4 = 0
    n5 = 0
    n6 = 0
    n7 = 0
    n8 = 0
    n9 = 0
    n10 = 0
    n0 = s.count("#.5")
    if n0 == 0:
        n0 = s.count("#0.5")
    n1 = s.count("#1")
    n15 = s.count("#1.5")
    n2 = s.count("#2")
    n25 = s.count("#2.5")
    n3 = s.count("#3")
    n35 = s.count("#3.5")
    n4 = s.count("#4")
    n5 = s.count("#5")
    n6 = s.count("#6")
    n7 = s.count("#7")
    n8 = s.count("#8")
    n9 = s.count("#9")
    n10 = s.count("#10")
    n = "0"
    if n0 > 0: n = "0.5"
    if n1 > 0: n = "1"
    if n15 > 0: n = "1.5"
    if n2 > 0: n = "2"
    if n25 > 0: n = "2.5"
    if n3 > 0: n = "3"
    if n35 > 0: n = "3.5"
    if n4 > 0: n = "4"
    if n5 > 0: n = "5"
    if n6 > 0: n = "6"
    if n7 > 0: n = "7"
    if n8 > 0: n = "8"
    if n9 > 0: n = "9"
    if n10 > 0: n = "10"
    n = __strip_numerics(n)
    if n <> "0":
        return n
    n0 = 0
    n1 = 0
    n15 = 0
    n2 = 0
    n25 = 0
    n3 = 0
    n35 = 0
    n4 = 0
    n5 = 0
    n6 = 0
    n7 = 0
    n8 = 0
    n9 = 0
    n10 = 0
    n0 = s.count("# .5")
    if n0 == 0:
        n0 = s.count("# 0.5")
    n1 = s.count("# 1")
    n2 = s.count("# 2")
    n3 = s.count("# 3")
    n15 = s.count("# 1")
    n25 = s.count("# 2")
    n35 = s.count("# 3")
    n4 = s.count("# 4")
    n5 = s.count("# 5")
    n6 = s.count("# 6")
    n7 = s.count("# 7")
    n8 = s.count("# 8")
    n9 = s.count("# 9")
    n10 = s.count("# 10")
    n = "0"
    if n0 > 0: n = "0.5"
    if n1 > 0: n = "1"
    if n15 > 0: n = "1.5"
    if n2 > 0: n = "2"
    if n25 > 0: n = "2.5"
    if n3 > 0: n = "3"
    if n35 > 0: n = "3.5"
    if n4 > 0: n = "4"
    if n5 > 0: n = "5"
    if n6 > 0: n = "6"
    if n7 > 0: n = "7"
    if n8 > 0: n = "8"
    if n9 > 0: n = "9"
    if n10 > 0: n = "10"
    n = __strip_numerics(n)
    if n <> "0":
        return n
    return "0"
def __find_regex_in_series(s):
    global mynothing
    s = str(s)
    my_re1 = "\(A\s.+\s[NovelBook]*[s]*\)"
    p1 = re.compile(my_re1, re.IGNORECASE)
    match1 = p1.search(s)
    if match1:
        s = str(s.replace("(A ", mynothing, 1))
        s = str(s.replace(" Novels)", mynothing, 1))
        s = str(s.replace(" Novel)", mynothing, 1))
        s = str(s.replace(" Books)", mynothing, 1))
        s = str(s.replace(" Book)", mynothing, 1))
        return str(s)
    my_re3 = "\strilogy$"
    p3 = re.compile(my_re3)
    match3 = p3.search(s)
    if match3:
        s = str(s.replace(" trilogy", mynothing, 1))
        return str(s)
def __strip_leading_trailing_zeroes_from_series_index(s_string):
    global mynothing
    s_string = str(s_string)
    s_string = str(__change_tuple_to_bytestring(s_string))
    s_string = s_string.replace(" 01", " 1", 1)
    s_string = s_string.replace(" 02", " 2", 1)
    s_string = s_string.replace(" 03", " 3", 1)
    s_string = s_string.replace(" 04", " 4", 1)
    s_string = s_string.replace(" 05", " 5", 1)
    s_string = s_string.replace(" 06", " 6", 1)
    s_string = s_string.replace(" 07", " 7", 1)
    s_string = s_string.replace(" 08", " 8", 1)
    s_string = s_string.replace(" 09", " 9", 1)
    s_string = s_string.replace(".000", mynothing, 1)
    s_string = s_string.replace(".00", mynothing, 1)
    s_string = s_string.replace(".0", mynothing, 1)
    s_string = s_string.replace(".10", ".1", 1)
    s_string = s_string.replace(".20", ".2", 1)
    s_string = s_string.replace(".30", ".3", 1)
    s_string = s_string.replace(".40", ".4", 1)
    s_string = s_string.replace(".50", ".5", 1)
    s_string = s_string.replace(".60", ".6", 1)
    s_string = s_string.replace(".70", ".7", 1)
    s_string = s_string.replace(".80", ".8", 1)
    s_string = s_string.replace(".90", ".9", 1)
    s_string = str(s_string)
    s_string = str(__change_tuple_to_bytestring(s_string))
    return s_string
def __refresh_custom_column_15(my_db, my_cursor, my_current_book, notifications, log):
    c_work_series_full_table = "custom_column_15"
    mysql = "DELETE FROM custom_column_15 WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    c_work_series_full_table = "custom_column_15"
    mysql = "INSERT or IGNORE INTO custom_column_15 SELECT book,book,seriesfull FROM __series_work_full WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    c_work_series_full_table = "custom_column_15"
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.0','') WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    c_work_series_full_table = "custom_column_15"
    mysql =  "UPDATE custom_column_15 SET value=REPLACE(value,'.5]','.50]') WHERE book = '" + my_current_book + "' ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
def __similar(a,b):
    try:
        p = SequenceMatcher(None, a, b).ratio()
        if p:
            return p
        else:
            return 0.0000
    except:
        return 0.0000
def __printblanks(n):
    n1 = int(n)
    if n1 <1:
        n1 = 1
    for i in range (1, n1):
        pass
def __printsafe(*arg):
    try:
        pass
    except:
        pass
def __reformat_author_initials(author):
    author = __change_tuple_to_bytestring(author)
    initials_mode = 'A.B.'
    ignore_words = ['von', 'van', 'jr', 'jr.', 'sr', 'sr.', 'st', 'st.',
                    'ed', 'ed.', 'dr', 'dr.', 'phd', 'ph.d', 'ph.d.']
    ignore_upper_words = ['ii', 'iii']
    ignore_words_map = dict((k,True) for k in ignore_words)
    parts = author.split()
    new_parts = []
    append_to_previous = False
    for tok in parts:
        if len(tok) == 0:
            continue
        handled = False
        if tok.lower() in ignore_words_map and tok.upper() != tok:
            pass
        elif tok.lower() in ignore_upper_words:
            pass
        elif tok.isdigit():
            pass
        elif '.' in tok or (tok.upper() == tok and len(tok) <= 2):
            if initials_mode == 'A.B.':
                new_tok = ''
                for c in tok.replace('.',''):
                    new_tok += c + '.'
                if append_to_previous:
                    new_parts[-1] = new_parts[-1] + new_tok
                else:
                    new_parts.append(new_tok)
                    append_to_previous = True
            else:
                return author
            handled = True
        if not handled:
            new_parts.append(tok)
            append_to_previous = False
    return ' '.join(new_parts)
def Create_SQLite_User_Functions(my_db, my_cursor, log):
        global my_terminate_early
        try:
            my_db.createscalarfunction("update_utf8_for_display", SQLite_User_Function_1)
        except:
            my_terminate_early = True
            log("Create_SQLite_User_Function 1 failed...cannot proceed...")
        sleep(0.1)
        try:
            my_db.createscalarfunction("make_utf8_lowercase", SQLite_User_Function_2)
        except:
            my_terminate_early = True
            log("Create_SQLite_User_Function 2 failed...cannot proceed...")
        sleep(0.1)
        try:
            my_db.createscalarfunction("regexp", SQLite_User_Function_3)
        except Exception as e:
            my_terminate_early = True
            log("Create_SQLite_User_Function [3] failed...cannot proceed...")
        sleep(0.1)
def SQLite_User_Function_1(s):
    mynothing = ""
    t = s
    if t is None: #ignore Nulls being passed by SQLite
        return s
    else:
        try:
            s_string = str(t)
            t = str(__change_tuple_to_bytestring(s_string))
            t = str(titlecase(t))
            t = t.strip()
            t = "u'" + s_string + "'"
            if isinstance(t, unicode):
                t = eval(t)
                return t
            else:
                log(("SQLite_User_Function_1...........not unicode:" + str(t)))
                pass
        except Exception as e:
            pass
    return s
def SQLite_User_Function_2(s):
    t = s
    if t is None: #ignore Nulls being passed by SQLite
        return s
    else:
        try:
            if isinstance(t, unicode):
                t = t.lower()
                return t
            else:
                pass
        except:
            pass
    return s
def SQLite_User_Function_3(regexpr,avalue):
    global re_already_imported
    if not re_already_imported:
        import re
        re_already_imported = True
    if regexpr:
        if avalue:
            try:
                s_string = str(avalue)
                s_string = str(__change_tuple_to_bytestring(s_string))
                re_string = str(regexpr)
                re_string = str(__change_tuple_to_bytestring(re_string))
                import re
                p = re.compile(re_string, re.IGNORECASE)
                match = p.search(s_string)
                if match:
                    return True
                else:
                    return False
            except Exception as e:
                return false
from string import digits
from locale import atoi
def __isbn10checksum(isbn):
    try:
        if len(isbn)!=10:
            s = "INVALID"
            return s
        else:
            return 0 == sum((10-w)*atoi('10' if d == 'X' else d)
                            for w,d in enumerate(isbn.upper()))%11
    except:
        s = "INVALID"
        return s
def __isbn13checksum(isbn):
    try:
        if len(isbn)!=13 :
            s = "INVALID"
            return s
        c=(10-(sum(atoi(d) for d in isbn[0:12:2])
                     +sum(3*atoi(d) for d in isbn[1:12:2]))%10)%10
        return atoi(isbn[12]) == c
    except:
        s = "INVALID"
        return s
def __explode_custom_column_10_if_needed(my_db, my_cursor, log):
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_10 (id,value) SELECT book, seriesname FROM __books_work_populate WHERE seriesname > ' '  ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_10_link  SET value = books_custom_column_10_link.book "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_10 WHERE id NOT IN (SELECT value FROM books_custom_column_10_link)"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
def __explode_custom_column_4_if_needed(my_db, my_cursor, log):
    sleep(0.5)
    mysql = "DELETE FROM custom_column_4 WHERE value = null "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_4 (id,value) SELECT book, authname FROM __books_work_populate WHERE authname not null ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_4_link  SET value = books_custom_column_4_link.book "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_4 WHERE id NOT IN (SELECT value FROM books_custom_column_4_link)"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "UPDATE custom_column_4 SET value = (SELECT authorname FROM _books_work WHERE book = custom_column_4.id) \
                    WHERE custom_column_4.id IN(SELECT book FROM _books_work WHERE book NOT NULL)"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.5)
def __explode_custom_column_8_if_needed(my_db, my_cursor, log):
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_8 (id,value) SELECT book, booktitle FROM __books_work_populate WHERE booktitle > ' '  ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_8_link  SET value = books_custom_column_8_link.book "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_8 WHERE id NOT IN (SELECT value FROM books_custom_column_8_link)"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
def __explode_custom_column_13_if_needed(my_db, my_cursor, log):
    sleep(0.1)
    mysql = "INSERT or REPLACE INTO custom_column_13 (id,value) SELECT book, tagsall FROM __books_work_populate WHERE tagsall not null  ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "UPDATE books_custom_column_13_link  SET value = books_custom_column_13_link.book "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "DELETE FROM custom_column_13 WHERE id NOT IN (SELECT value FROM books_custom_column_13_link)"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
def __update_table_books_work(my_db, my_cursor, log):
    sleep(0.5)
    mysql = "DELETE FROM  _books_work WHERE book >= '0' "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql =  "INSERT OR IGNORE INTO _books_work SELECT book,booktitle,authname,seriesname,seriesindex FROM  __books_work_populate"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.5)
    mysql = "UPDATE _books_work SET booktitle = (make_utf8_lowercase(booktitle) );"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "UPDATE _books_work SET authorname = (make_utf8_lowercase(authorname) );"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.5)
    mysql = "DELETE FROM  _instr_title_author WHERE book >= '0' "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = "INSERT INTO _instr_title_author (book,booktitle,authorname) SELECT * FROM __instr_title_author_author_title"
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.5)
def __build_regex_list_from_tag_rules(my_db, my_cursor, log):
    global tag_regex_rules
    tag_regex_rules[:] = []
    sleep(0.5)
    mysql = "SELECT oldtag,newtag,purgetag FROM _tag_rules WHERE oldtag LIKE '/%' AND oldtag LIKE '%/'   ;  "
    tmp_rule_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rule_list:
          return
    else:
        if len(tmp_rule_list) == 0:
            tag_regex_rules.append(str("^DELETE$"))
            return
        else:
            for item in tmp_rule_list:
                oldtag, newtag, purgetag = item
                s = str(oldtag)
                s = str(s[1:])
                if s.endswith("/"):
                    s = str(s[0: -1])
                new_row = str(str(s) + "<|!!|>" + str(newtag) + "<|!!|>" + str(purgetag))
                tag_regex_rules.append(str(new_row))
def __build_regex_list_from_tag_capitalization_rules(my_db, my_cursor, log):
    global tag_capitalization_regex_rules
    tag_capitalization_regex_rules[:] = []
    sleep(1.0)
    mysql = "SELECT regex,rule,priority FROM _tag_capitalization_rules WHERE regex NOT NULL \
                    AND rule NOT NULL AND priority NOT NULL  AND regex NOT LIKE '%,%'   "
    tmp_rule_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rule_list:
          return
    else:
        if len(tmp_rule_list) == 0:
            tag_capitalization_regex_rules.append(str("^DELETE$"))
            return
        else:
            for item in tmp_rule_list:
                regex, rule, priority = item
                s1 = str(regex)
                s2 = str(rule)
                s3 = str(priority)
                s3 = str("000" + str(s3))
                s3 = str(s3[-3: ])
                new_row = str(str(s3) + "<|!!|>" + str(s1) + "<|!!|>" + str(s2))
                tag_capitalization_regex_rules.append(str(new_row))
    tag_capitalization_regex_rules.sort(reverse=True)
def apply_tag_capitalization_rules(tmp_tag,log):
    global tag_capitalization_regex_rules
    for row in tag_capitalization_regex_rules:
        rule_list = row.split("<|!!|>")
        priority = str(rule_list[0])
        re1 = str(rule_list[1])
        rule = str(rule_list[2])
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(tmp_tag)
            if match1:
                if str(rule) == str("titlecase"):
                    tmp_tag = re.sub(re1, do_titlecase, tmp_tag, count=0, flags=re.IGNORECASE)
                    continue
                else:
                    if str(rule) == str("uppercase"):
                        tmp_tag = re.sub(re1, do_uppercase, tmp_tag, count=0, flags=re.IGNORECASE)
                        continue
                    else:
                        if str(rule) == str("lowercase"):
                            tmp_tag = re.sub(re1, do_lowercase, tmp_tag, count=0, flags=re.IGNORECASE)
                            continue
                        else:
                            if str(rule) == str("delete"):
                                tmp_tag = re.sub(re1, do_delete, tmp_tag, count=0, flags=re.IGNORECASE)
                                continue
                            else:
                                if str(rule) == str("addspace_left"):
                                    tmp_tag = re.sub(re1, do_addspace_left, tmp_tag, count=0, flags=re.IGNORECASE)
                                    continue
                                else:
                                    if str(rule) == str("addspace_right"):
                                        tmp_tag = re.sub(re1, do_addspace_right, tmp_tag, count=0, flags=re.IGNORECASE)
                                        continue
                                    else:
                                        continue
            else:
                continue
        except Exception as e:
            continue
    return tmp_tag
def do_titlecase(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = s.title()
    return s
def do_uppercase(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = s.upper()
    return s
def do_lowercase(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = s.lower()
    return s
def do_delete(matchobj):
    s = ""
    return s
def do_addspace_left(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s = " " + s
    return s
def do_addspace_right(matchobj):
    s = ""
    if matchobj.group(0):
        s = matchobj.group(0)
    s =  s + " "
    return s
def __reset_cursor(my_db, log):
    global my_guidb
    my_db.close()
    db = my_guidb
    path = db.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log(str(e))
        raise e
        return
    my_cursor = my_db.cursor()
    mysql = str("PRAGMA main.locking_mode=EXCLUSIVE;")
    my_cursor.execute(mysql)
    mysql = "PRAGMA main.busy_timeout = 5000;"
    my_cursor.execute(mysql)
    sleep(1.0)
    Create_SQLite_User_Functions(my_db, my_cursor, log)
    sleep(1.0)
    return my_db, my_cursor
def __set_null_seriesname_index_to_zero(my_db, my_cursor, notifications, log):
    my_cursor.execute("begin")
    mysql = str("UPDATE custom_column_12 SET value = '0' WHERE book IN(SELECT book  FROM __books_work_populate WHERE seriesname IS NULL AND seriesindex <> '0')")
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
    sleep(0.05)
def change_work_title_to_web_title_for_previously_validated_work_series(my_db, my_cursor, notifications, log):
    sleep(0.02)
    try:
        miscellaneous_scrubbing_5_mine_global_historical_data_for_use_in_renaming(my_db, my_cursor, notifications, log)
    except:
        pass
    mysql = "SELECT work_author FROM _web_series_rename_detail"
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows:
        n = len(tmp_rows)
        if n == 0:
            table_is_empty = True
        else:
            table_is_empty = False
        del tmp_rows
    else:
        table_is_empty = True
    if table_is_empty:
        try:
            mysql = "DELETE FROM _web_series_rename_detail_cumulative WHERE  work_series = web_series \
                                OR web_series IS NULL OR work_series IS NULL OR work_series = 'Novel'  OR  work_series = 'novel' \
                                OR work_series = ' '  OR  work_series = ''      ;  "
            __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
            sleep(0.02)
            mysql = "INSERT OR IGNORE INTO _web_series_rename_detail SELECT * FROM _web_series_rename_detail_cumulative \
                                                            WHERE work_series IN(SELECT value FROM custom_column_10 WHERE value NOT NULL)  "
            __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
            sleep(0.02)
        except:
            try:
                my_cursor.execute("commit")
            except:
                pass
    book_ok_list = []
    mysql = "SELECT book,book FROM __books_work_status WHERE value = 'book_ok' "
    tmp_rows_bws = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows_bws:
        n = len(tmp_rows_bws)
        if n == 0:
            log("No Work Titles to Rename[no statuses of book_ok found]")
            return
        else:
            for row in tmp_rows_bws:
                book,dummy = row
                book = int(book)
                book_ok_list.append(book)
            del tmp_rows_bws
            book_ok_set = set(book_ok_list)
            del book_ok_list
            log("Books with a status of 'book_ok' found for potential renaming: " + str(n))
    else:
        log("No Work Titles to Rename[no statuses of book_ok found]")
        del book_ok_list
        return
    gwsd_dict = {}
    mysql = "SELECT booktitle,authname FROM _global_web_series_detail"
    tmp_rows_gwsd = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows_gwsd:
        n = len(tmp_rows_gwsd)
        if n == 0:
            log("No Work Titles to Rename[no wssvd found]")
            return
        else:
            for row in tmp_rows_gwsd:
                booktitle,authname = row
                booktitle = booktitle.lower()
                authname = authname.lower()
                gwsd_dict[booktitle] = authname
            del tmp_rows_gwsd
            log("WSSVD history items available for use in potential renaming: " + str(n))
    else:
        log("No Work Titles to Rename[no wssvd found]")
        del gwsd_dict
        return
    mysql = "SELECT web_authname, web_seriesname, web_booktitle, web_seriesindex, work_booktitle, work_index, book \
                    FROM __web_booktitle_wrong_work_booktitle_part2  "
    tmp_rows_wbwwbp2 = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows_wbwwbp2:
        n = len(tmp_rows_wbwwbp2)
        if n == 0:
            log("No Work Titles to Rename[no candidates found]")
            return
        else:
            log("Number of candidates for potential renaming of Work Title to Web Title: " + str(n))
    else:
        log("No Work Titles to Rename[no candidates found]")
        return
    working_list = []
    for row in tmp_rows_wbwwbp2:
        web_authname, web_seriesname, web_booktitle, web_seriesindex, work_booktitle, work_index, book = row
        book = int(book)
        web_booktitle = web_booktitle.lower()
        web_authname = web_authname.lower()
        if not book in book_ok_set:
            continue
        if work_booktitle in gwsd_dict:
            authname = gwsd_dict[work_booktitle]
            if str(authname) == str(web_authname):
                continue
        working_list.append(row)
    del gwsd_dict
    del tmp_rows_wbwwbp2
    del book_ok_set
    if len(working_list) == 0:
        del working_list
        log("No Work Titles to Rename[all candidates already match]")
        return
    n_counter = 0
    for row in working_list:
        web_authname, web_seriesname, web_booktitle, web_seriesindex, work_booktitle, work_index, book = row
        work_booktitle = str(work_booktitle.lower())
        web_booktitle = str(web_booktitle.lower())
        n_similarity = __similar(work_booktitle, web_booktitle)
        if (work_booktitle in web_booktitle) or (web_booktitle in work_booktitle) or n_similarity >= .80 :
            sleep(0.02)
            book = int(book)
            try:
                web_booktitle = web_booktitle.title()
            except:
                pass
            mysql = str("UPDATE custom_column_8 SET value = ?  WHERE  custom_column_8.id = ? ")
            __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, web_booktitle, book)
            n_counter = n_counter + 1
            log(" ")
            log(str("[ " + str(work_booktitle) + " ] Changed to:  [" + str(web_booktitle) + " ] for Series:  [ " + str(web_seriesname) + " ]   Similarity was: [ " + str(n_similarity) + " ]" ))
        else:
            if str(web_seriesindex) <> str("0"):
                log(str("[ " + str(work_booktitle) + " ] Was NOT Changed to:  [" + str(web_booktitle) + " ] for Series:  [ " + str(web_seriesname) + " ]   Similarity was: [ " + str(n_similarity) + " ]   Manual Review of Work Series Index Required." ))
                pass
    del working_list
    log(" ")
    log("-------------------------------------------------------------------------------------------------------------------------------------------")
    log(" ")
    log("Total Incorrect Book Work Titles Changed to Correct Book Web Titles for Identical Series/Indexes:  " + str(n_counter))
    log(" ")
    log("-------------------------------------------------------------------------------------------------------------------------------------------")
    sleep(0.05)
    try:
        my_cursor.execute("begin")
        mysql = "UPDATE custom_column_12 SET value = 1 WHERE book IN(SELECT book FROM custom_column_15 WHERE custom_column_15.value LIKE '%[0]%' )"
        my_cursor.execute(mysql)
        mysql = "UPDATE custom_column_15 SET value = (replace(value,'[0]','[1]')) WHERE custom_column_15.value LIKE '%[0]%'  "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except:
        try:
            my_cursor.execute("commit")
        except:
            pass
    if table_is_empty:
        try:
            my_cursor.execute("begin")
            mysql = "DELETE FROM _web_series_rename_detail"
            my_cursor.execute(mysql)
            my_cursor.execute("commit")
        except:
            try:
                my_cursor.execute("commit")
            except:
                pass
def remove_all_double_quotes(my_db, my_cursor, notifications, log):
    s1 = '"'
    s2 = ''
    s1 = str(s1)
    s2 = str(s2)
    try:
        my_cursor.execute("begin")
        mysql = str('UPDATE custom_column_4 SET value = replace(custom_column_4.value,?,?)' )
        my_cursor.execute(mysql,(s1,s2))
        mysql = str('UPDATE custom_column_8 SET value = replace(custom_column_8.value,?,?)' )
        my_cursor.execute(mysql,(s1,s2))
        mysql = str('UPDATE custom_column_10 SET value = replace(custom_column_10.value,?,?)' )
        my_cursor.execute(mysql,(s1,s2))
        mysql = str('UPDATE custom_column_13 SET value = replace(custom_column_13.value,?,?)' )
        my_cursor.execute(mysql,(s1,s2))
        mysql = str('UPDATE custom_column_15 SET value = replace(custom_column_15.value,?,?)' )
        my_cursor.execute(mysql,(s1,s2))
        my_cursor.execute("commit")
    except Exception as e:
        raise e
def _insert_single_tags_into_work_tags_single(my_db, my_cursor, notifications, log):
    global single_work_tags_all
    mynothing = ""
    if not single_work_tags_all:
        return
    else:
        n = len(single_work_tags_all)
        if n == 0:
            return
    tmp_set = set(single_work_tags_all)
    single_work_tags_all = list(tmp_set)
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        for row in single_work_tags_all:
            s1 = str(row)
            if (not s1 > " "):
                continue
            s1 = str(s1.replace(" & ", "&", 4))
            s1 = str(s1.replace(" / ", ":", 4))
            s1 = str(s1.replace("Fiction - ", "Fiction:", 1))
            for x in range(1,4):
                n = s1.count(":")
                if n > 1:
                    three_tuple = s1.rpartition(":")
                    a,b,c = three_tuple
                    b = str("-")
                    s1 = str(a) + str(b) + str(c)
                else:
                    break
            n = s1.count(":")
            s1 = str(s1.replace(" Stories", mynothing, 1))
            s1 = str(s1.replace(" Tales", mynothing, 1))
            s2 = str('tbd')
            try:
                s1_0 = str(s1)
                s1 = "u'" + s1 + "'"
                s1 = eval(s1)
            except:
                s1 = str(s1_0)
            mysql = str('INSERT OR IGNORE INTO _tags_work_single (tag,subject) VALUES (?,?)')
            my_cursor.execute(mysql,(s1,s2))
        my_cursor.execute("commit")
    except Exception as e:
        raise e
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        mysql = str("INSERT OR REPLACE INTO _tags_work_single SELECT tag, subject FROM __tags_work_single_subject WHERE tag NOT NULL AND subject NOT NULL")
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except Exception as e:
        raise e
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        mysql = 'UPDATE _tags_work_single SET tag = (update_utf8_for_display(tag) ) '
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
    except:
        try:
            my_cursor.execute("commit")
        except:
            pass
    try:
        sleep(0.3)
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO _tag_priorities SELECT tag,'0' FROM _tags_work_single \
                        WHERE tag NOT IN(SELECT tag FROM _tag_priorities WHERE tag = _tags_work_single.tag)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        log(" ")
        log("Work Tags missing from table _tag_priorities (if any) have been added with a Priority = 0. ")
        log(" ")
    except:
        try:
            my_cursor.execute("commit")
        except:
            pass
    try:
        mysql = "SELECT tag,priority FROM _tag_priorities WHERE priority = 0  AND (tag LIKE '%fict%' OR tag LIKE '%fact%') AND tag LIKE '%:%' AND tag LIKE 'F%'"
        tmp_rule_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_rule_list:
            pass
        else:
            if len(tmp_rule_list) == 0:
                pass
            else:
                my_cursor.execute("begin")
                for item in tmp_rule_list:
                    tag,priority = item
                    tag = str(tag)
                    tag = str(apply_tag_capitalization_rules(str(tag),log))
                    n_100 = 100
                    mysql = "INSERT OR IGNORE INTO _tag_priorities (tag,priority) VALUES (?,?) ;"
                    my_cursor.execute(mysql,(tag,n_100))
                my_cursor.execute("commit")
                sleep(0.1)
                my_cursor.execute("begin")
                mysql = "DELETE FROM _tag_priorities WHERE priority = 0  AND (tag LIKE '%fict%' OR tag LIKE '%fact%') AND tag LIKE '%:%' AND tag LIKE 'F%'"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.05)
                my_cursor.execute("begin")
                mysql = "DELETE FROM _tag_priorities WHERE tag LIKE '%978%' OR tag IN(SELECT code FROM _global_subject_codes WHERE code = tag)  "
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                sleep(0.05)
    except Exception as e:
        try:
            my_cursor.execute("commit")
        except:
            pass
def __build_regex_list_from_title_rules(my_db, my_cursor, log):
    global title_regex_rules
    title_regex_rules[:] = []
    sleep(0.5)
    mysql = "SELECT priority,oldword,newword,purgeword FROM _title_rules ORDER BY priority DESC  ;  "
    tmp_rule_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rule_list:
        log("ERROR: No Title Rules Table Entries Found")
        return
    else:
        if len(tmp_rule_list) == 0:
            title_regex_rules.append(str("^DELETE$"))
            log("WARNING: No Title Rules Table Entries Found")
            return
        else:
            for item in tmp_rule_list:
                priority,oldword, newword, purgeword = item
                s = str(oldword)
                if s.startswith("/"):
                    s = str(s[1:])
                if s.endswith("/"):
                    s = str(s[0: -1])
                new_row = str(str(s) + "<|!!|>" + str(newword) + "<|!!|>" + str(purgeword))
                title_regex_rules.append(str(new_row))
def __build_regex_list_from_series_rules(my_db, my_cursor, log):
    global series_regex_rules
    series_regex_rules[:] = []
    sleep(0.5)
    mysql = "SELECT priority,oldword,newword,purgeword FROM _series_rules ORDER BY priority DESC  ;  "
    tmp_rule_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rule_list:
        log("ERROR: No series Rules Table Entries Found")
        return
    else:
        if len(tmp_rule_list) == 0:
            series_regex_rules.append(str("^DELETE$"))
            log("WARNING: No series Rules Table Entries Found")
            return
        else:
            for item in tmp_rule_list:
                priority,oldword, newword, purgeword = item
                s = str(oldword)
                if s.startswith("/"):
                    s = str(s[1:])
                if s.endswith("/"):
                    s = str(s[0: -1])
                new_row = str(str(s) + "<|!!|>" + str(newword) + "<|!!|>" + str(purgeword))
                series_regex_rules.append(str(new_row))
def _process_title_using_title_rules(s, log):
    global mynothing
    global title_regex_rules
    title = str(s)
    for row in title_regex_rules:
        rule_list = row.split("<|!!|>")
        re1 = str(rule_list[0])
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(title)
            if match1:
                newword = str(rule_list[1])
                purgeword = str(rule_list[2])
                if ((not newword) or newword == "None") and purgeword == "1" :
                    title = str(re.sub(re1, mynothing, title))
                    continue
                else:
                    if (newword) and (newword <> "None") and (purgeword <> "1") :
                        newword = str(newword.replace('"', mynothing, 10))
                        newword = str(newword.replace("'", mynothing, 10))
                        s = str(match1.group(0))
                        title = str(title.replace(s, newword, 20))
                        title = str(title.strip())
                        title = str(title.replace("  ", " ", 20))
                        continue
                    else:
                        continue
            else:
                continue
        except Exception as e:
            log("Table _title_rules REGEX Rule Compile Error:" + str(e))
            log("REGEX rule was:" + str(re1))
            log("Please fix your REGEX rule via table _title_rules maintenance.  Bypassing bad rule and continuing.")
            continue
    return str(title)
def _process_series_using_series_rules(s, log):
    global mynothing
    global series_regex_rules
    series = str(s)
    for row in series_regex_rules:
        rule_list = row.split("<|!!|>")
        re1 = str(rule_list[0])
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(series)
            if match1:
                newword = str(rule_list[1])
                purgeword = str(rule_list[2])
                if ((not newword) or newword == "None") and purgeword == "1" :
                    series = str(re.sub(re1, mynothing, series))
                    continue
                else:
                    if (newword) and (newword <> "None") and (purgeword <> "1") :
                        newword = str(newword.replace('"', mynothing, 10))
                        newword = str(newword.replace("'", mynothing, 10))
                        s = str(match1.group(0))
                        series = str(series.replace(s, newword, 20))
                        series = str(series.strip())
                        series = str(series.replace("  ", " ", 20))
                        continue
                    else:
                        continue
            else:
                continue
        except Exception as e:
            log("Table _series_rules REGEX Rule Compile Error:" + str(e))
            log("REGEX rule was:" + str(re1))
            log("Please fix your REGEX rule via table _series_rules maintenance.  Bypassing bad rule and continuing.")
            continue
    series = str(series.replace("  ", " ", 10))
    series = str(series.strip())
    return str(series)
def derive_tags_from_comments(my_db, my_cursor, my_current_book, notifications, log):
    global probable_tags_to_add
    global mynothing
    tmp_list = []
    del tmp_list
    mysql = str("SELECT tag FROM _tags_by_comment WHERE EXISTS (SELECT text FROM comments  WHERE book = '[CURRENTBOOK]' \
                        AND comments.text LIKE '%'||_tags_by_comment.comment||'%'  ) ")
    mysql = str(mysql.replace("[CURRENTBOOK]", my_current_book, 1))
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                for col in row:
                    u0 = col
                    try:
                        tmp_tag = unicodedata.normalize('NFKD',u0).encode('ascii', 'ignore')
                    except:
                        pass
                    tmp_tag = str(tmp_tag)
                    tmp_tag = str(__change_tuple_to_bytestring(tmp_tag))
                    if tmp_tag <> mynothing:
                        probable_tags_to_add.append(tmp_tag)
def add_tag_combinations(my_db, my_cursor, notifications, log):
    for x in range(0, 5):
        mysql = "UPDATE custom_column_13 SET value = (SELECT bigtag FROM __tag_combination_rules_by_id_part2 \
                    WHERE  __tag_combination_rules_by_id_part2.id = custom_column_13.id) \
                    WHERE custom_column_13.id IN(SELECT id FROM  __tag_combination_rules_by_id_part2)"
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
def _convert_isbn_check_digit_13(isbn):
    try:
        assert len(isbn) == 12
        sum = 0
        for i in range(len(isbn)):
            c = int(isbn[i])
            if i % 2: w = 3
            else: w = 1
            sum += w * c
        r = 10 - (sum % 10)
        if r == 10: return '0'
        else: return str(r)
    except:
        return isbn
def _convert_isbn_convert_10_to_13(isbn):
    try:
        assert len(isbn) == 10
        prefix = '978' + isbn[:-1]
        check = _convert_isbn_check_digit_13(prefix)
        return prefix + check
    except:
        return isbn
def __purge_transient_tables(my_db, my_cursor, log):
    sleep(0.1)
    mysql = "DELETE FROM  _books_work  ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "DELETE FROM  _instr_title_author  ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
    mysql = "DELETE FROM  _instr_series_series  ; "
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    sleep(0.1)
def apply_tag_string_replacement_rules(my_db, my_cursor, log):
    sleep(0.1)
    tmp_list = []
    del tmp_list
    mysql = str("SELECT book, tagsall,old_string,new_string FROM __tag_string_replacement_rules_part1 ")
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,tagsall,old_string,new_string = row
                sleep(0.1)
                try:
                    my_cursor.execute("begin")
                    mysql = "UPDATE custom_column_13 SET value = (replace(value,?,?)) WHERE custom_column_13.id = ?"
                    my_cursor.execute(mysql,(old_string,new_string,book))
                    my_cursor.execute("commit")
                except:
                    try:
                        my_cursor.execute("commit")
                        continue
                    except:
                        continue
            try:
                my_cursor.execute("commit")
            except:
                pass
def scrub_manga_control(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    re1 = "[c][h]*[apter]*[ ]*[0-9]+[-][0-9]+"
    re2 = "v[olume ]*[0-9]+[ _]*c[hapter ]*[0-9]+"
    re3 = "ch[0-9]+"
    re4 = "[0-9]+"
    re_list = []
    re_list.append(str(re1))
    re_list[0] = str(re1)
    re_list.append(str(re2))
    re_list[1] = str(re2)
    re_list.append(str(re3))
    re_list[2] = str(re3)
    re_list.append(str(re4))
    re_list[3] = str(re4)
    update_auth = False
    update_title = False
    update_series = False
    update_index = False
    update_tags = False
    tmp_list = []
    del tmp_list
    mysql = str("SELECT  booktitle,seriesname,seriesindex FROM __manga_metadata \
                            WHERE book = [BOOK] ")
    mysql = str(mysql.replace("[BOOK]", my_current_book, 1))
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                booktitle,seriesname,seriesindex = row
                break
    if not booktitle:
        booktitle = "NONE"
        update_title = True
    if not seriesname:
        seriesname = "NONE"
        update_series = True
    if not seriesindex:
        seriesindex = "0"
        update_index = True
    tmp_title = booktitle
    tmp_series = seriesname
    tmp_seriesindex = seriesindex
    tmp_title = unicodedata.normalize('NFKD', tmp_title).encode('ascii', 'ignore')
    tmp_title = str(tmp_title)
    tmp_title = str(__change_tuple_to_bytestring(tmp_title))
    tmp_series = unicodedata.normalize('NFKD', tmp_series).encode('ascii', 'ignore')
    tmp_series = str(tmp_series)
    tmp_series = str(__change_tuple_to_bytestring(tmp_series))
    tmp_seriesindex = str(tmp_seriesindex)
    tmp_seriesindex = str(__strip_numerics(tmp_seriesindex))
    log(" ")
    log("Special Manga Processing for:  " + str(tmp_title) )
    for x in range(0,4):
        re_x = re_list[x]
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:
                if x == 0:
                    s0 = str(matchx.group(0))
                    s_split = tmp_title.split(s0)
                    tmp_title = str(s_split[0])
                    tmp_title = tmp_title.replace("_"," ",20)
                    update_title = True
                    if tmp_series == str("NONE"):
                        tmp_series = str(matchx.group(0))
                        update_series = True
                        tmp_seriesindex = str("1")
                        update_index = True
                    break
                elif x == 1:
                    s1 = matchx.group(0)
                    s1 = str(s1)
                    s1 = str(s1.lower())
                    s0 = str(s1)
                    s_split = s1.split("c")
                    s2 = str(s_split[1])
                    case_1 = False
                    if tmp_series == str("NONE"):
                        tmp_series = str(s0)
                        tmp_series = str(tmp_series.strip())
                        ns = tmp_series.count(" ")
                        nu = tmp_series.count("_")
                        nv = tmp_series.count("volume")
                        if nv == 0:
                            case_1 = True
                        if case_1:
                            if ns > 0:
                                s_split = tmp_series.split(" ")
                            else:
                                s_split = tmp_series.split("_")
                            tmp_series = str(s_split[0])
                            tmp_series = str(tmp_series.strip())
                            tmp_series = str(tmp_series.replace("v","Manga Volume ",1))
                        else:
                            s_split = tmp_series.split("c")
                            tmp_series = str(s_split[0])
                            tmp_series = str(tmp_series.strip())
                            tmp_series = str(tmp_series.replace("volume", "Manga Volume ",1))
                        update_series = True
                        tmp_seriesindex = str(__strip_numerics(s2))
                    if not case_1:
                        tmp_seriesindex = str(tmp_seriesindex.replace("hapter", mynothing, 1))
                    if tmp_seriesindex.startswith("0"):
                        tmp_seriesindex = str(tmp_seriesindex[1: ])
                        if len(tmp_seriesindex) == 0:
                            tmp_seriesindex = str("0")
                    update_index = True
                    s0 = str(matchx.group(0))
                    s_split = tmp_title.split(s0)
                    tmp_title = str(s_split[0])
                    tmp_title = tmp_title.replace("_"," ",20)
                    update_title = True
                    break
                elif x == 2:
                    s1 = matchx.group(0)
                    s1 = str(s1)
                    s0 = str(s1)
                    s1 = str(s1.lower())
                    s1 = str(s1.replace("ch", mynothing, 2))
                    if tmp_series == "NONE":
                        tmp_series = str("Chapter")
                        update_series = True
                    tmp_seriesindex = str(__strip_numerics(s1))
                    update_index = True
                    s0 = str(matchx.group(0))
                    s_split = tmp_title.split(s0)
                    tmp_title = str(s_split[0])
                    tmp_title = tmp_title.replace("_"," ",20)
                    update_title = True
                    break
                elif x == 3:
                    s1 = matchx.group(0)
                    s1 = str(s1)
                    s0 = str(tmp_title.replace(s1,mynothing,2))
                    if tmp_series == str("NONE"):
                        tmp_series = str("Manga")
                        update_series = True
                    tmp_seriesindex = str(__strip_numerics(s1))
                    update_index = True
                    break
                else:
                    log("No Manga Pattern Found: " + str(tmp_title))
                    break
        except Exception as e:
            log("Manga regex error: " + str(re_x) + "  " + str(e))
            continue
    re_x = "^[\[][a-z ]+[\]]"
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(tmp_title)
        if matchx:
            s1 = matchx.group(0)
            s1 = str(s1)
            tmp_title = str(tmp_title.replace(s1,mynothing,2))
            update_title = True
    except:
        pass
    re_x = "[(][size]+.+GB[)]"
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(tmp_title)
        if matchx:
            s1 = matchx.group(0)
            s1 = str(s1)
            tmp_title = str(tmp_title.replace(s1,mynothing,2))
            update_title = True
    except:
        pass
    n0 = len(tmp_title)
    tmp_title = str(tmp_title.replace("[", mynothing, 10))
    tmp_title = str(tmp_title.replace("]", mynothing, 10))
    tmp_title = str(tmp_title.replace("(", mynothing, 10))
    tmp_title = str(tmp_title.replace(")", mynothing, 10))
    tmp_title = str(tmp_title.replace(".png", mynothing, 10))
    tmp_title = str(tmp_title.replace(".zip", mynothing, 10))
    tmp_title = str(tmp_title.replace(".rar", mynothing, 10))
    n1 = len(tmp_title)
    if n0 <> n1:
        update_title = True
    s_old = tmp_title
    tmp_title = tmp_title.replace("_"," ",20)
    if s_old <> tmp_title:
        update_title = True
    tmp_title = str(tmp_title.strip())
    n = len(tmp_title)
    if n < 3:
        tmp_title = str("Japan " + tmp_title)
        tmp_title = str(tmp_title.title())
        update_title = True
    old_tmp_title = tmp_title
    tmp_title = tmp_title.replace("volume", "  Volume", 1)
    tmp_title = tmp_title.replace("Volume", "  Volume", 1)
    tmp_title = tmp_title.replace("  ", " ", 10)
    tmp_title = tmp_title.strip()
    if old_tmp_title <> tmp_title:
        update_title = True
    old_tmp_series = tmp_series
    tmp_series = tmp_series.replace("MangaVolume", "Manga Volume", 1)
    tmp_series = tmp_series.replace("Mangavolume", "Manga Volume", 1)
    tmp_series = tmp_series.replace("mangavolume", "Manga Volume", 1)
    tmp_series = tmp_series.replace("mangaVolume", "Manga Volume", 1)
    tmp_series = tmp_series.replace("olume0", "olume  0", 1)
    tmp_series = tmp_series.replace("volume", "  Volume", 1)
    tmp_series = tmp_series.replace("  ", " ", 10)
    tmp_series = tmp_series.strip()
    if old_tmp_series <> tmp_series:
        update_series = True
    if update_title:
        tmp_title = str(tmp_title.strip())
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id = ? ')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_title, my_current_book)
    if update_series:
        tmp_series = str(tmp_series.strip())
        tmp_series = str(tmp_series.title())
        mysql = str('INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?) ')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, my_current_book, tmp_series)
        mysql = str('INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?) ')
        __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book,my_current_book)
    if update_index:
        tmp_seriesindex = str(tmp_seriesindex.strip())
        mysql = str('INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES (?,?,?) ')
        __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, my_current_book, my_current_book,tmp_seriesindex)
def add_missing_seriesname_from_web_detail(my_db, my_cursor, my_current_book,notifications, log):
    tmp_list = []
    del tmp_list
    mysql =  "SELECT __books_work_populate.book AS book, \
                                 __books_work_populate.booktitle AS title,\
                                 _global_web_series_detail.seriesname AS globalseries,\
                                 _global_web_series_detail.seriesindex AS globalindex \
                      FROM __books_work_populate,_global_web_series_detail \
                    WHERE __books_work_populate.book = [BOOK] \
                    AND __books_work_populate.seriesname IS NULL \
                    AND __books_work_populate.authname NOT NULL \
                    AND __books_work_populate.booktitle NOT NULL \
                    AND __books_work_populate.authname = _global_web_series_detail.authname \
                    AND __books_work_populate.booktitle = _global_web_series_detail.booktitle"
    mysql = str(mysql.replace("[BOOK]", str(my_current_book), 1))
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,title,seriesname,seriesindex = row
                mysql = str('INSERT OR REPLACE INTO custom_column_10 (id,value) VALUES (?,?)  ')
                __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, book,seriesname)
                sleep(0.02)
                mysql = str('INSERT OR REPLACE INTO books_custom_column_10_link (id,book,value) VALUES (?,?,?) ')
                __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, book,book,book)
                sleep(0.02)
                mysql = str('INSERT OR REPLACE INTO custom_column_12 (id,book,value) VALUES (?,?,?) ')
                __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, book,book,seriesindex)
                sleep(0.02)
            seriesname = unicodedata.normalize('NFKD', seriesname).encode('ascii', 'ignore')
            seriesname = str(seriesname)
            seriesname = str(__change_tuple_to_bytestring(seriesname))
            seriesindex = str(__strip_numerics(seriesindex))
            title = unicodedata.normalize('NFKD', title).encode('ascii', 'ignore')
            title = str(title)
            title = str(__change_tuple_to_bytestring(title))
            log("[For Book]: " + str(title) + " [Missing Work Series Added per Historically Cumulative Web Data]: " + str(seriesname) + "    [Index]: " + str(seriesindex))
def scrub_first_first_series(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    tmp_list = []
    del tmp_list
    mysql = "SELECT seriesname FROM __books_work_populate \
                    WHERE __books_work_populate.seriesname IS NOT NULL \
                    AND book = [BOOK]  "
    mysql = str(mysql.replace("[BOOK]", str(my_current_book), 1))
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                for col in row:
                    seriesname = col
    seriesname = unicodedata.normalize('NFKD', seriesname).encode('ascii', 'ignore')
    seriesname = str(seriesname)
    force_update = False
    re1 = "^[a-z ]+[0-9]+[;:,-]+[a-z ]+[0-9]+$"
    try:
        p1 = re.compile(re1, re.IGNORECASE)
        match1 = p1.search(seriesname)
        if match1:
            newseries = str(seriesname)
            newseries = str(newseries.replace(";", "~~~", 2))
            newseries = str(newseries.replace(":", "~~~", 2))
            newseries = str(newseries.replace(",", "~~~", 2))
            newseries = str(newseries.replace("-", "~~~", 2))
            s_split = newseries.split("~~~")
            newseries = str(s_split[0])
            newseries = str(newseries.strip())
            force_update = True
        else:
            pass
    except:
        pass
    if not force_update:
        newseries = seriesname
        newseries = newseries.replace(".ICA ",".",2)
        newseries = newseries.replace("._."," ",4)
        n = newseries.count(".")
        if n > 2:
            newseries = newseries.replace("."," ",10)
        newseries = newseries.replace(" SciFan ","",4)
        newseries = newseries.replace(" ICA ","",4)
        newseries = newseries.replace("Serified","",4)
        re1 = "[\(][#]*[0-9]+[ ]of[ ][0-9]+[\)]"
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(newseries)
            if match1:
                s0 = match1.group(0)
                newseries = newseries.replace(s0,"",2)
        except:
            pass
        if newseries <> seriesname:
            newseries = newseries.replace("  ", " ", 10)
            newseries = newseries.strip()
            force_update = True
    else:
        pass
    if not force_update:
        return
    mysql = "UPDATE custom_column_10 SET value = ? WHERE id = ?"
    __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, newseries, my_current_book)
    sleep(0.02)
def scrub_with_special_custom_column_title_cc_control_rules(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global title_cc_control_rules
    if len(title_cc_control_rules) == 0 :
        return
    rule_1 = False
    rule_2 = False
    rule_3 = False
    rule_list = []
    del rule_list
    tmp_list = []
    del tmp_list
    mysql = "SELECT booktitle FROM __books_work_populate  WHERE book = [BOOK] "
    mysql = str(mysql.replace("[BOOK]", str(my_current_book),1))
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        log("ERROR: No Work Title Found For Book: " + str(my_current_book))
        return
    else:
        if len(tmp_list) == 0:
            log("ERROR: No Work Title Found For Book: " + str(my_current_book))
            return
        else:
            for row in tmp_list:
                for col in row:
                    title = col
    n1 = title.count("{{")
    n2 = title.count("]:")
    if n1 == 0 and n2 == 0:
        return
    new_title = "tbd"
    force_update = False
    for row in title_cc_control_rules:
        cc_number, datatype, rule = row
        rule = str(rule)
        rule_1 = False
        rule_2 = False
        if rule == "1":
            rule_1 = True
        if rule == "2":
            rule_2 = True
        if not rule_1 and not rule_2 :
            log("Invalid rule configured in table _title_cc_control: " + str(rule))
            continue
        re1 = __get_table_title_cc_control_rule_regex(rule)
        try:
            p1 = re.compile(re1, re.IGNORECASE)
            match1 = p1.search(title)
            if match1:
                s = match1.group(0)
                s_test = str(s)
                n = s_test.count(str(cc_number))
                if n == 0:
                    continue
                if rule_1:
                    new_title,new_cc_value = __apply_table_title_cc_control_rule_1(title,s,cc_number,log)
                    if new_title == "NONE":
                        continue
                    else:
                        force_update = True
                if rule_2:
                    new_title,new_cc_value = __apply_table_title_cc_control_rule_2(title,s,cc_number,log)
                    if new_title == "NONE":
                        continue
                    else:
                        force_update = True
                if new_title == title:
                    log("data error:  new_title == title")
                    continue
                if not force_update:
                    continue
                __update_non_qs_custom_columns_generic(my_db, my_cursor, log,cc_number,datatype,new_cc_value, my_current_book)
                mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id IN \
                                            (SELECT value FROM books_custom_column_8_link WHERE book = ? ) ;')
                __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, new_title, my_current_book)
                log(" ")
                log("Custom Column Value Derived from book with a title of: " + title )
                return
            else:
                continue
        except Exception as e:
            log("Table title_cc_control related processing Error:" + str(e))
            log("Rule was:" + str(rule))
            log("Please notify the developer of these messages by Private Message so it can be corrected.")
            return
def __update_non_qs_custom_columns_generic(my_db, my_cursor, log,cc_number,datatype,new_cc_value,book):
    global mynothing
    text_cc_table = str("custom_column_ZZ")
    text_cc_link_table = str("books_custom_column_ZZ_link")
    comment_cc_table = str("custom_column_ZZ")
    if datatype <> 'text' and datatype <> 'comments' :
        log("ERROR: table _title_cc_control row has a datatype value error: " + str(datatype))
        return
    else:
        if datatype == "text":
            text_cc_table = str(text_cc_table.replace("ZZ", str(cc_number), 1))
            text_cc_link_table = str(text_cc_link_table.replace("ZZ", str(cc_number), 1))
            normalized = True
        else:
            comment_cc_table = str(comment_cc_table.replace("ZZ", str(cc_number), 1))
            normalized = False
    sleep(0.1)
    if not normalized:
        mysql = str("DELETE FROM  [TABLE]  WHERE book = [BOOK]  ")
        mysql = str(mysql.replace("[TABLE]", str(comment_cc_table),1))
        mysql = str(mysql.replace("[BOOK]", str(book),1))
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        sleep(0.1)
        mysql = str("INSERT OR REPLACE INTO  [TABLE]  (id,book,value) VALUES (?,?,?) ")
        mysql = str(mysql.replace("[TABLE]", str(comment_cc_table),1))
        __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, book, book, new_cc_value)
        return
    if normalized:
        mysql = "SELECT id FROM [TABLE]  WHERE value = ?"
        mysql = str(mysql.replace("[TABLE]", str(text_cc_table),1))
        tmp_rows = []
        del tmp_rows
        my_cursor.execute(mysql, (new_cc_value,))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            id = "0"
        else:
            if len(tmp_rows) == 0:
                id = "0"
            else:
                for row in tmp_rows:
                    for col in row:
                        id = col
        if str(id) == "0":
            mysql = str("INSERT OR REPLACE INTO  [TABLE]  (id,value) VALUES (null,?) ")
            mysql = str(mysql.replace("[TABLE]", str(text_cc_table),1))
            __execute_mysql_for_custom_column_generic_1_arg(my_db, my_cursor, log, mysql, ([new_cc_value]) )
            sleep(0.1)
        mysql = str("DELETE FROM  [TABLE]  WHERE book = [BOOK]  ")
        mysql = str(mysql.replace("[TABLE]", str(text_cc_link_table),1))
        mysql = str(mysql.replace("[BOOK]", str(book),1))
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        sleep(0.1)
        mysql = "SELECT id FROM [TABLE]  WHERE value = ?"
        mysql = str(mysql.replace("[TABLE]", str(text_cc_table),1))
        tmp_rows = []
        del tmp_rows
        my_cursor.execute(mysql, (new_cc_value,))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            id = "0"
        else:
            if len(tmp_rows) == 0:
                id = "0"
            else:
                for row in tmp_rows:
                    for col in row:
                        id = col
        if str(id) == "0":
            log("ERROR: base custom table value does not exist although it was just added; continuing.")
            log("Book: " + str(book) + "  Table: " + str(text_cc_table))
            return
        else:
            mysql = str("INSERT OR REPLACE INTO [LINKTABLE]  (id,book,value) VALUES ( null,?,?) ")
        mysql = str(mysql.replace("[LINKTABLE]", str(text_cc_link_table),1))
        mysql = str(mysql.replace("[TABLE]", str(text_cc_link_table),1))
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, book, id)
        sleep(0.1)
        mysql = str("DELETE FROM  [TABLE]  WHERE id NOT IN(SELECT value FROM [LINKTABLE] WHERE book NOT NULL )")
        mysql = str(mysql.replace("[TABLE]", str(text_cc_table),1))
        mysql = str(mysql.replace("[LINKTABLE]", str(text_cc_link_table),1))
        __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
        return
def __build_rules_list_from_title_cc_control(my_db, my_cursor, log):
    global title_cc_control_rules
    title_cc_control_rules[:] = []
    mysql = "SELECT cc_number, datatype, rule FROM _title_cc_control   WHERE active = '1'   "
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                cc_number, datatype, rule = row
                title_cc_control_rules.append(row)
    title_cc_control_rules.sort()
def __get_table_title_cc_control_rule_regex(rule):
    regex = "NONE"
    if rule == "1":
        regex = "[\{][\{][2-9][0-9][\}][:].+[\}]"
    else:
        if rule == "2":
            regex = "[\[][0-9]+[\]][:].+[\]]"
    return regex
def __apply_table_title_cc_control_rule_1(title,group0,cc_number,log):
    n = group0.count("}:")
    if n == 0:
        log("__apply_table_title_cc_control_rule_1 Error:  invalid pattern passed to it.")
        return "NONE", "NONE"
    s_remove = group0
    new_cc_value = group0
    s_list = new_cc_value.split("}:")
    s0 = s_list[0]
    s0 = s0 + "}:"
    new_cc_value = new_cc_value.replace(s0,"",1)
    new_cc_value = new_cc_value[0:-1]
    new_cc_value = new_cc_value.strip()
    new_title = title.replace(s_remove,"",1)
    new_title = new_title.strip()
    return new_title,new_cc_value
def __apply_table_title_cc_control_rule_2(title,group0,cc_number,log):
    n = group0.count("]:")
    if n == 0:
        log("__apply_table_title_cc_control_rule_2 Error:  invalid pattern passed to it.")
        return "NONE", "NONE"
    s_remove = group0
    new_cc_value = group0
    s_list = new_cc_value.split("]:")
    s0 = s_list[0]
    s0 = s0 + "]:"
    new_cc_value = new_cc_value.replace(s0,"",1)
    new_cc_value = new_cc_value[0:-1]
    new_cc_value = new_cc_value.strip()
    new_title = title.replace(s_remove,"",1)
    new_title = new_title.strip()
    return new_title,new_cc_value
def __add_title_rule_table_rules(my_db, my_cursor, log):
    try:
        sleep(0.05)
        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[ ]raf[ ]/',' RAF ','0');"
        my_cursor.execute (mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^raf[ ]/','RAF ','0');"
        my_cursor.execute (mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^I[ ]AM[ ]/','I Am ','0');"
        my_cursor.execute (mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[ ]atm[ ]/',' ATM ','0');"
        my_cursor.execute (mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^atm[ ]*/','ATM ','0');"
        my_cursor.execute (mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[-;:,]$/',' ','0');"
        my_cursor.execute (mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/[\[]the$/',' ','0');"
        my_cursor.execute (mysql)
        mysql = "INSERT OR REPLACE INTO _title_rules VALUES (null,'20','/^the[ ][:]/',' ','0');"
        my_cursor.execute (mysql)
        my_cursor.execute("commit")
    except Exception as e:
        try:
            my_cursor.execute("commit")
        except:
            pass
def scrub_comicbook_control(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global author_probably_good
    global title_probably_good
    global title_is_frozen
    global finished_scrub_title_index_series_in_title
    global finished_scrub_title_series_index_in_title
    global seriesindex_probably_good
    global probable_tags_to_add
    author_probably_good = False
    title_probably_good = False
    title_is_frozen = False
    finished_scrub_title_index_series_in_title = False
    finished_scrub_title_series_index_in_title = False
    seriesindex_probably_good = False
    re1 = "^[a-z ]+[0-9]+[ ]+[\(][1-2][0-9][0-9][0-9][\)][ ][\(][a-z -]+[\)][ ][\(][a-z -]+[\)]$"
    re2 = "^[a-z ']+[ ][-][ ][a-z ']+[ ][-][ ][a-z -']+[,]*[#]*[0-9]+$"
    re3 = "^[a-z -]+[&][a-z -]+[ ][-][ ][a-z '-]+[,]*[#]*[0-9]+$"
    re4 = "^Marvel\'s[ ]['a-z -]+[,]*[#]*[0-9]+$"
    re5 = "^['a-z -]+[,]*[#]*[0-9]+$"
    re6 = "^['a-z ]+[ ][-][a-z .&]+[ ][,]*[#]*[0-9]+$"
    re_list = []
    re_list.append(str(re1))
    re_list[0] = str(re1)
    re_list.append(str(re2))
    re_list[1] = str(re2)
    re_list.append(str(re3))
    re_list[2] = str(re3)
    re_list.append(str(re4))
    re_list[3] = str(re4)
    re_list.append(str(re5))
    re_list[4] = str(re5)
    re_list.append(str(re6))
    re_list[5] = str(re6)
    update_author = False
    update_title = False
    update_series = False
    update_index = False
    tmp_list = []
    del tmp_list
    mysql = str("SELECT book,authname,booktitle FROM __books_work_populate \
                            WHERE ( book IN(SELECT book FROM data WHERE format = 'CBR' OR format = 'CBZ' ) \
                            OR tagsall LIKE '%CBR%' OR tagsall LIKE '%CBZ%' OR tagsall LIKE '%Graphic Novel%'  ) \
                            AND book NOT IN(SELECT book FROM __manga_metadata WHERE book = [BOOK] ) \
                            AND book = [BOOK] ")
    mysql = str(mysql.replace("[BOOK]", my_current_book, 2))
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,authname,booktitle = row
                break
    if not authname:
        authname = "unknown"
        update_author = True
    if not booktitle:
        booktitle = "NONE"
        update_title = True
    tmp_author = authname
    tmp_title = booktitle
    orig_title = booktitle
    probable_tags_to_add.append("Graphic Novel")
    probable_tags_to_add.append("Comics")
    log(" ")
    log("Special CBZ/CBR/Graphic Novel Processing for Title: " + str(tmp_title) )
    if tmp_author == 'unknown' or tmp_author == 'Unknown':
        tmp_author = "C.B. Artist"
        update_author = True
        author_probably_good = True
    else:
        if (any(char.isdigit() for char in tmp_title)) and (any(char.isdigit() for char in tmp_author)):
            if tmp_title.count(" ") == 1:
                s_new = ""
                n_new = ""
                for char in tmp_title:
                    if char.isdigit():
                        n_new = n_new + char
                    else:
                        s_new = s_new + char
                s1 = ""
                if n_new.isdigit():
                    if n_new == "1":
                        s1 = "One"
                    if n_new == "2":
                        s1 = "Two"
                    if n_new == "3":
                        s1 = "Three"
                    if n_new == "4":
                        s1 = "Four"
                    if n_new == "5":
                        s1 = "Five"
                else:
                    pass
                tmp_title = s_new + " " + s1
                tmp_title = tmp_title.strip()
            else:
                pass
        else:
            pass
        tmp_title = tmp_title + "  [ " + tmp_author + "  ] "
        tmp_author = "C.B. Artist"
        author_probably_good = True
        update_author = True
        update_title = True
    tmp_title = __remove_bad_keywords(tmp_title)
    re_x = "[\(][1-2][0-9][0-9][0-9][\)]"
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(tmp_title)
        if matchx:
            s0 = matchx.group(0)
            tmp_title = tmp_title.replace(s0, mynothing, 1)
            update_title = True
        else:
            pass
    except:
        pass
    for x in range(0,10):
        re_x = "[a-z][-][a-z]"
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:
                s0 = matchx.group(0)
                s1 = s0.replace("-"," ",1)
                tmp_title = tmp_title.replace(s0, s1, 1)
                update_title = True
            else:
                break
        except:
            pass
    tmp_title = tmp_title.replace(" 1", " ,#1", 1)
    tmp_title = tmp_title.replace(" 2", " ,#2", 1)
    tmp_title = tmp_title.replace(" 3", " ,#3", 1)
    tmp_title = tmp_title.replace(" 4", " ,#4", 1)
    tmp_title = tmp_title.replace(" 5", " ,#5", 1)
    tmp_title = tmp_title.replace(" 6", " ,#6", 1)
    tmp_title = tmp_title.replace(" 7", " ,#7", 1)
    tmp_title = tmp_title.replace(" 8", " ,#8", 1)
    tmp_title = tmp_title.replace(" 9", " ,#9", 1)
    tmp_title = tmp_title.replace(" 01", " ,#1", 1)
    tmp_title = tmp_title.replace(" 02", " ,#2", 1)
    tmp_title = tmp_title.replace(" 03", " ,#3", 1)
    tmp_title = tmp_title.replace(" 04", " ,#4", 1)
    tmp_title = tmp_title.replace(" 05", " ,#5", 1)
    tmp_title = tmp_title.replace(" 06", " ,#6", 1)
    tmp_title = tmp_title.replace(" 07", " ,#7", 1)
    tmp_title = tmp_title.replace(" 08", " ,#8", 1)
    tmp_title = tmp_title.replace(" 09", " ,#9", 1)
    tmp_title = tmp_title.replace(" 00000", " 0", 1)
    tmp_title = tmp_title.replace(" 0000", " 0", 1)
    tmp_title = tmp_title.replace(" 000", " 0", 1)
    tmp_title = tmp_title.replace(" 00", " 0", 1)
    tmp_title = tmp_title.replace(" 0", " ,#", 1)
    tmp_title = tmp_title.replace("#0","#", 4)
    tmp_title = tmp_title.replace(" #"," ,#", 2)
    tmp_title = tmp_title.replace("0 ","0.0 ",1)
    if ",#" in tmp_title:
        tmp_title = tmp_title.replace(".1 ",".0 ",1)
        tmp_title = tmp_title.replace(".2 ",".0 ",1)
        tmp_title = tmp_title.replace(".3 ",".0 ",1)
        tmp_title = tmp_title.replace(".4 ",".0 ",1)
        tmp_title = tmp_title.replace(".6 ",".0 ",1)
        tmp_title = tmp_title.replace(".7 ",".0 ",1)
        tmp_title = tmp_title.replace(".8 ",".0 ",1)
        tmp_title = tmp_title.replace(".9 ",".0 ",1)
        tmp_title = tmp_title.replace(".00",".0",1)
        tmp_title = tmp_title.replace("1 ","1.0 ",1)
        tmp_title = tmp_title.replace("2 ","2.0 ",1)
        tmp_title = tmp_title.replace("3 ","3.0 ",1)
        tmp_title = tmp_title.replace("4 ","4.0 ",1)
        tmp_title = tmp_title.replace("5 ","5.0 ",1)
        tmp_title = tmp_title.replace("6 ","6.0 ",1)
        tmp_title = tmp_title.replace("7 ","7.0 ",1)
        tmp_title = tmp_title.replace("8 ","8.0 ",1)
        tmp_title = tmp_title.replace("9 ","9.0 ",1)
    tmp_title = tmp_title.strip()
    tmp_title = tmp_title.replace("  "," ",20)
    tmp_author = tmp_author.strip()
    pattern = 999
    if not update_title:
        for x in range(0,6):
            re_x = re_list[x]
            try:
                px = re.compile(re_x, re.IGNORECASE)
                matchx = px.search(tmp_title)
                if matchx:
                    if x == 0:
                        pattern = 0
                        break
                    elif x == 1:
                        pattern = 1
                        break
                    elif x == 2:
                        pattern = 2
                        break
                    elif x == 3:
                        pattern = 3
                        break
                    elif x == 4:
                        pattern = 4
                        break
                    elif x == 5:
                        pattern = 5
                        break
                else:
                    pass
            except:
                log("Graphic Novel Title Search Pattern Compile Error:" + str(re_x))
                pass
    else:
        pass
    if pattern == 0  :
        update_title = True
    if pattern == 1:
        re_x = re2
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:
                s0 = matchx.group(0)
                s0 = s0.strip()
                s_split = s0.split(" - ")
                n = len(s_split)
                if n <> 3:
                    pass
                else:
                    tmp_title = s_split[0] + "  "  + s_split[1] + "   [ " + s_split[2] + " ]"
                    update_title = True
            else:
                pass
        except:
            pass
    if pattern == 2:
        re_x = re3
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            if matchx:
                s0 = matchx.group(0)
                s0 = s0.strip()
                s_split = s0.split(" - ")
                n = len(s_split)
                if n <> 2:
                    pass
                else:
                    s_split[1] = s_split[1].replace(" #"," ,#",1)
                    tmp_title = s_split[0] + "   [ " + s_split[1] + " ]"
                    update_title = True
            else:
                pass
        except:
            pass
    if pattern == 3:
        pass
    if pattern == 4:
        s0 = tmp_title
        s_split = s0.split(" - ")
        n = len(s_split)
        if n <> 2:
            pass
        else:
            s_split[1] = s_split[1].replace(" #"," ,#",1)
            tmp_title = s_split[0] + "   [ " + s_split[1] + " ]"
            update_title = True
    if pattern == 5:
        s0 = tmp_title
        s_split = s0.split(" - ")
        n = len(s_split)
        if n <> 2:
            pass
        else:
            s_split[1] = s_split[1].replace(" #"," ,#",1)
            tmp_title = s_split[0] + "   [ " + s_split[1] + " ]"
            update_title = True
    tmp_title = tmp_title.replace(" #"," ,#", 2)
    tmp_title = tmp_title.replace(",,"," ,", 2)
    if ",#" in tmp_title and (not "[" in tmp_title):
        update_title = True
        s_split = tmp_title.split(",#")
        s0 = s_split[0]
        tmp_title = s0 + "  [ " + tmp_title + " ]"
    tmp_title = tmp_title.strip()
    if tmp_title.endswith("]"):
        re_x = "[\(][a-z ]+[\)]"
        try:
            px = re.compile(re_x, re.IGNORECASE)
            matchx = px.search(tmp_title)
            for x in range(0,7):
                if matchx:
                    s0 = matchx.group(0)
                    tmp_title = tmp_title.replace(s0,mynothing,2)
                    update_title = True
                else:
                    break
        except:
            pass
    if orig_title <> tmp_title:
        update_title = True
    if update_author:
        tmp_author = tmp_author.strip()
        mysql = str('UPDATE custom_column_4 SET value =  ? WHERE  custom_column_4.id = ? ')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_author, my_current_book)
        sleep(.1)
    if update_title:
        tmp_title = tmp_title.strip()
        mysql = str('UPDATE custom_column_8 SET value =  ? WHERE  custom_column_8.id = ? ')
        __execute_mysql_for_custom_column_generic(my_db, my_cursor, log, mysql, tmp_title, my_current_book)
        sleep(.1)
def scrub_magazine_control(my_db, my_cursor, my_current_book, notifications, log):
    global mynothing
    global is_scrubbable
    tmp_list = []
    del tmp_list
    mysql = str("SELECT book,authname,booktitle FROM __books_work_populate \
                        WHERE book = [BOOK] ")
    mysql = str(mysql.replace("[BOOK]", my_current_book, 1))
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book,authname,booktitle = row
                break
    re_x = "^[a-z '&]+[ ]*[-][ ]*(January|February|March|April|May|June|July|August|September|October|November|December)[ ][0-9]*[,]*[ ]*[1-2][0-9][0-9][0-9]"
    try:
        px = re.compile(re_x, re.IGNORECASE)
        matchx = px.search(booktitle)
        if matchx:
            is_scrubbable = False
            log(" ")
            log("Book or Magazine Not Scrubbed (Not Changed): " + str(booktitle))
            return
        else:
            return
    except:
        return
def add_book_awards(my_db, my_cursor, my_current_book, notifications, log, probable_tags_to_add):
    global book_awards_list
    tmp_list = []
    del tmp_list
    mysql = "SELECT authname,booktitle FROM __books_work_populate WHERE book = [BOOK]"
    mysql = mysql.replace("[BOOK]",my_current_book,1)
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return probable_tags_to_add
    else:
        if len(tmp_list) == 0:
            return probable_tags_to_add
        else:
            for row in tmp_list:
                authname,booktitle = row
                break
    for row in book_awards_list:
        author,title,award = row
        try:
            author = author.title()
            title = title.title()
            authname = authname.title()
            booktitle = booktitle.title()
        except:
            pass
        x1 = __similar(author,authname)
        x2 = __similar(title,booktitle)
        if x1 >= 0.85 and x2 >= 0.85 :
            probable_tags_to_add.append(str(award))
            log("Award Added as Work Tag: " + str(award) + "  " + str(booktitle) + "  " + str(authname) )
            try:
                my_cursor.execute("begin")
                mysql = "INSERT OR REPLACE INTO _book_awards_mapping (book,award) VALUES (?,?)"
                my_cursor.execute (mysql,(my_current_book,award))
                my_cursor.execute("commit")
                sleep(.05)
            except Exception as e:
                log(str(e))
                try:
                    my_cursor.execute("commit")
                except:
                    pass
    n = len(probable_tags_to_add)
    for row in probable_tags_to_add:
        pass
    return probable_tags_to_add
def  __build_book_awards_list(my_db, my_cursor, log):
    global book_awards_list
    tmp_list = []
    del tmp_list
    book_awards_list = []
    mysql = "SELECT author,title,award FROM _book_awards"
    tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_list:
        return
    else:
        if len(tmp_list) == 0:
            return
        else:
            for row in tmp_list:
                book_awards_list.append(row)
def  scrub_publisher_from_title(my_db, my_cursor, my_current_book, notifications, log):
    tmp_list = []
    del tmp_list
    try:
        mysql = "SELECT book FROM __instr_publisher_title WHERE book = [BOOK] AND __instr_publisher_title.booktitle <> __instr_publisher_title.publisher ; "
        mysql = mysql.replace("[BOOK]", my_current_book, 4)
        tmp_list = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_list:
            return
        else:
            if len(tmp_list) == 0:
                return
            else:
                pass
    except Exception as e:
        log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
        log("ERROR in scrub_publisher_from_title: " + str(e))
        log("Did you run the After Version Upgrade job first?  It creates new Tables and Views, including __instr_publisher_title .")
        log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
        try:
            my_cursor.execute("commit")
            return
        except:
            return
    try:
        sleep(0.05)
        my_cursor.execute("begin")
        mysql = "UPDATE custom_column_8 SET value =(SELECT newtitle FROM __instr_publisher_title WHERE __instr_publisher_title.book = [BOOK] ) \
                        WHERE custom_column_8.id = [BOOK] "
        mysql = mysql.replace("[BOOK]", my_current_book, 4)
        my_cursor.execute (mysql)
        my_cursor.execute("commit")
        sleep(.02)
    except Exception as e:
        log("ERROR in scrub_publisher_from_title: " + str(e))
        try:
            my_cursor.execute("commit")
        except:
            pass
def miscellany_change_work_index_to_web_index_standalone(my_db, my_cursor, notifications, log):
    tmp_rows_bwp = []
    del tmp_rows_bwp
    tmp_rows_wgasti = []
    del tmp_rows_wgasti
    working_list = []
    del working_list
    tmp_rows_wgsnmwsi = []
    del tmp_rows_wgsnmwsi
    tmp_dict = {}
    del tmp_dict
    n3 = 0
    sleep(0.5)
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed [Part 8.1]'))
    mysql = "SELECT book, authname, booktitle, seriesname, seriesindex  FROM __books_work_populate WHERE seriesname NOT NULL AND authname NOT NULL AND booktitle NOT NULL AND BOOK NOT NULL"
    tmp_rows_bwp = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows_bwp:
        pass
    else:
        log("a.Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
        return
    if len(tmp_rows_bwp) == 0:
        log("b.Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
        return
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed [Part 8.2]'))
    mysql = "SELECT web_authname, web_seriesname, web_booktitle, web_seriesindex  \
                     FROM __web_global_authors_series_titles_indexes \
                     WHERE web_seriesindex NOT NULL AND web_seriesindex <> '0' \
                         AND web_seriesname NOT NULL AND web_booktitle NOT NULL AND web_authname NOT NULL"
    tmp_rows_wgasti = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows_wgasti:
        pass
    else:
        log("a..Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
        return
    if len(tmp_rows_wgasti) == 0:
        log("b..Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
        return
    working_list = []
    for row in tmp_rows_bwp:
        book, authname, booktitle, seriesname, seriesindex = row
        for item in tmp_rows_wgasti:
            web_authname, web_seriesname, web_booktitle, web_seriesindex = item
            try:
                if authname.lower() == web_authname.lower():
                    if seriesname.lower() == web_seriesname.lower():
                        if booktitle.lower() == web_booktitle.lower():
                            working_list.append(book)
                            break
            except:
                pass
    if len(working_list) == 0:
        log("...Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
        return
    notifications.put((0.99, 'Doing Miscellaneous Scrubbing for All Books [8 of 10]: Changing Work Series Index to Web Series Index as Needed [Part 8.3]'))
    mysql = "SELECT book,work_seriesindex,web_seriesindex FROM __web_global_seriesindex_not_match_work_seriesindex WHERE book NOT NULL"
    tmp_rows_wgsnmwsi = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if tmp_rows_wgsnmwsi:
        n2 = len(tmp_rows_wgsnmwsi)
        if n2 > 0:
            log("-------------------------------------------------------------------------------------------------------------------------------------------")
            tmp_dict = {}
            for item in tmp_rows_wgsnmwsi:
                book,work_seriesindex,web_seriesindex = item
                book = str(book)
                tmp_dict[book] = item
            for row in working_list:
                book = str(row)
                book = __strip_numerics(book)
                book = str(book.strip())
                if book in tmp_dict:
                    line = tmp_dict[book]
                    book,work_seriesindex,web_seriesindex = line
                    if not web_seriesindex:
                        continue
                    if not web_seriesindex > 0:
                        continue
                    if work_seriesindex == web_seriesindex:
                        continue
                else:
                    continue
                book = int(book)
                mysql = "UPDATE custom_column_12 SET value = ? \
                                    WHERE custom_column_12.book = ? \
                                        AND custom_column_12.value = ? "
                __execute_mysql_for_custom_column_generic_3_args(my_db, my_cursor, log, mysql, web_seriesindex, book, work_seriesindex)
                n3 = n3 + 1
                log("book, work series index, web series index: " + str(book) + "   " + str(work_seriesindex) + "   " +str(web_seriesindex))
                book = str(book)
                __refresh_custom_column_15(my_db, my_cursor, book, None, log)
            log(" ")
            log("-------------------------------------------------------------------------------------------------------------------------------------------")
            log(" ")
            log("Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
            log(" ")
            log("-------------------------------------------------------------------------------------------------------------------------------------------")
            log(" ")
        else:
            log("....Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
            return
    else:
        log(".....Total Incorrect Book Work Series Indexes Changed to Correct Book Web Series Indexes for Identical Series/Titles:  " + str(n3))
        return
def change_work_series_full_to_standard(my_db, my_cursor, log):
    try:
        my_cursor.execute("\
                            BEGIN TRANSACTION;\
                            UPDATE custom_columns SET datatype = 'comments' WHERE id = 15 AND label = 'work_series_full' AND normalized = 0 AND datatype = 'text' ; \
                            COMMIT;")
    except Exception as e:
        pass
def miscellaneous_scrubbing_5_mine_global_historical_data_for_use_in_renaming(my_db, my_cursor, notifications, log):
    mynothing = ""
    n_count = 0
    tmp_books_list = miscellaneous_scrubbing_5_fetch_all_books_with_series(my_db, my_cursor, log)
    tmp_series_list = miscellaneous_scrubbing_5_fetch_series(my_db, my_cursor, log, tmp_books_list)
    for row in tmp_series_list:
        s = str(row)
        s_list = s.split("||@||")
        work_auth = str(s_list[0])
        work_series = str(s_list[1])
        work_series = str(work_series.replace("'", mynothing, 10))
        work_series = str(work_series.replace('"', mynothing, 10))
        work_auth = str(work_auth.replace("'", mynothing, 10))
        work_auth = str(work_auth.replace('"', mynothing, 10))
        generic_series = str(miscellaneous_scrubbing_5__genericize_seriesname(work_series))
        mysql = "SELECT authname,seriesname FROM _global_web_author_series \
                                WHERE (authname = '[work_auth]' ) \
                                    AND ( (seriesname = '[work_series]' ) OR \
                                             (seriesname like '%[work_series]%' ) OR \
                                             (seriesname like '%[generic_series]%' ) OR \
                                             (seriesname = '[generic_series]' ) \
                                            ) "
        mysql = str(mysql.replace("[work_auth]", str(work_auth), 3))
        mysql = str(mysql.replace("[work_series]", str(work_series), 3))
        mysql = str(mysql.replace("[generic_series]", str(generic_series), 3))
        tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_rows:
            continue
        else:
            for row in tmp_rows:
                web_auth, web_series_name = row
                web_auth = str(__change_tuple_to_bytestring(web_auth))
                web_series_name = str(__change_tuple_to_bytestring(web_series_name))
                mysql = str('INSERT OR IGNORE INTO _web_series_rename_detail_cumulative (work_series,work_author,web_series,web_author) VALUES (?,?,?,?) ')
                __execute_mysql_for_custom_column_generic_4_args(my_db, my_cursor, log, mysql, work_series, work_auth, web_series_name, web_auth)
                sleep(0.02)
                n_count = n_count + 1
            del tmp_rows
    log("Number of Historically Cumulative Web Source Records Matching Current List of Work Series Names: " + str(n_count) )
    mysql = str('INSERT OR REPLACE INTO _web_author_series SELECT * FROM _global_web_author_series')
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    mysql = str('INSERT OR REPLACE INTO _web_series_detail SELECT * FROM _global_web_series_detail')
    __execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)
    log(" ")
    log("All Historically Cumulative Web Source Records from All Q&S Libraries are Available for Use in Renaming in This Q&S Library.")
    log(" ")
def miscellaneous_scrubbing_5_fetch_series(my_db, my_cursor, log, tmp_books_list):
    tmp_series_list = []
    tmp_rows_save = []
    tmp_rows = []
    for row in tmp_books_list:
        del tmp_rows
        my_book = str(row)
        mysql = str('SELECT authname,seriesname FROM __books_work_populate  WHERE seriesname NOT NULL AND book = [BOOK]  ;')
        mysql = str(mysql.replace("[BOOK]", str(my_book), 1))
        sleep(0.01)
        tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
        if not tmp_rows:
            tmp_rows = []
        else:
            for item in tmp_rows:
                tmp_rows_save.append(item)
    if not tmp_rows_save:
        return tmp_series_list
    tmp_rows_save_set = set(tmp_rows_save)
    tmp_rows_save = list(tmp_rows_save_set)
    n = len(tmp_rows_save)
    log("Number of Unique Series Selected: " + str(n))
    if n == 0:
        return tmp_series_list
    for row in tmp_rows_save:
        authname, seriesname = row
        try:
            authname = unicodedata.normalize('NFKD', authname).encode('ascii', 'ignore')
        except:
            pass
        try:
            seriesname = unicodedata.normalize('NFKD', seriesname).encode('ascii', 'ignore')
        except:
            pass
        authname = str(authname)
        authname = str(__change_tuple_to_bytestring(str(authname)))
        auth_list = authname.split(" ")
        n = len(auth_list)
        if n == 0:
            pass
        else:
            if n == 1:
                pass
            else:
                if n == 2:
                    pass
                else:
                    if n == 3:
                        authname = str(str(auth_list[0]) + " " + str(auth_list[2]))
                    else:
                        pass
        seriesname = str(seriesname)
        seriesname = str(__change_tuple_to_bytestring(str(seriesname)))
        s = str(str(authname) + str("||@||") + str(seriesname))
        tmp_series_list.append(str(s))
    tmp_series_list.sort()
    return tmp_series_list
def miscellaneous_scrubbing_5_fetch_all_books_with_series(my_db, my_cursor, log):
    tmp_books_list = []
    mysql = str('SELECT id FROM custom_column_10 ;')
    tmp_rows = __execute_mysql_fetchall_generic(my_db, my_cursor, log, mysql)
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            book = str(row)
            book = str(__strip_numerics(book))
            tmp_books_list.append(book)
    return  tmp_books_list
