# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015, DaltonST <DaltonShiTzu@outlook.com>'
__docformat__ = 'restructuredtext en'

__my_version__ = "3.6.24"

from PyQt5.Qt import (Qt, QDialog, QLabel, QVBoxLayout, QHBoxLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut)


class AutoPopChoicesDialog(QDialog):


    def __init__(self, gui,icon,guidb,chosen_option,autopopulate_tags_by_comment_part2):


        QDialog.__init__(self, gui)
        self.gui = gui

        self.guidb = guidb
        self.chosen_option = chosen_option
        self.autopopulate_tags_by_comment_part2  = autopopulate_tags_by_comment_part2

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(11)

        self.layout.addSpacing(2)

        self.text_heading = QLabel()
        self.text_heading.setTextFormat(1)
        self.text_heading.setText("<center><font color='#0404B4'>Tags by Comments: Table Maintenance Steps</font></center>")
        self.text_heading.setFont(font)
        self.layout.addWidget(self.text_heading)
        self.layout.addSpacing(20)


        self.setWindowTitle('Quarantine And Scrub                                                                                                                          ')
        self.setWindowIcon(icon)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button1 = QPushButton(" ", self)
        self.push_button1.setText("Step 1: Select and Add Candidates to the Tags by Comments Candidates Table")
        self.push_button1.clicked.connect(self.__do_push_button1)
        self.push_button1.setFont(font)
        self.layout.addWidget(self.push_button1)


        self.layout.addSpacing(15)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button2 = QPushButton(" ", self)
        self.push_button2.setText("Step 2: Add Reviewed and Approved Candidates to the Tags by Comments Table")
        self.push_button2.clicked.connect(self.__do_push_button2)
        self.push_button2.setFont(font)
        self.layout.addWidget(self.push_button2)


        self.layout.addSpacing(20)

        font.setBold(True)
        font.setPointSize(8)

        button_box = QDialogButtonBox(QDialogButtonBox.Cancel)
        button_box.rejected.connect(self.reject)
        self.layout.addWidget(button_box)

        self.resize(self.sizeHint())


    def __do_push_button1(self):
        self.chosen_option = "1"
        self.autopopulate_tags_by_comment_part2(self.guidb,self.chosen_option)


    def __do_push_button2(self):
        self.chosen_option = "2"
        self.autopopulate_tags_by_comment_part2(self.guidb,self.chosen_option)



#END of autopopchoicesdialog.py