# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.20" # Technical changes

from PyQt5.Qt import QMenu, QDialog, QIcon, QAction

from calibre import isbytestring, force_unicode, prints
from calibre.constants import DEBUG, iswindows, filesystem_encoding, isosx
from calibre.gui2.actions import InterfaceAction
#~ from calibre.ptempfile import PersistentTemporaryDirectory
from calibre.utils.config import config_dir, JSONConfig

from calibre_plugins.media_file_importer.common_utils import set_plugin_icon_resources, get_icon
from calibre_plugins.media_file_importer.mfi_dialog import MediaFileImporterDialog
from calibre_plugins.media_file_importer.config import prefs

import os
import tempfile
import time
from time import sleep

PLUGIN_ICONS = ['images/mfi.png']

#-------------------------------------------------------------------------------------------
class ActionMediaFileImporter(InterfaceAction):

    name = 'Media File Importer'
    action_spec = ('MFI','images/drop.png', "Drag media file paths and Drop them to automatically create new books within Calibre having dynamically created metadata, plus a copy of the original media file placed into the same directory as the new book.", None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def genesis(self):
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.drag_and_drop_control)
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def initialization_complete(self):
        self.guidb = self.gui.library_view.model().db
        for k,v in prefs.defaults.iteritems():
            if not k in prefs:
                prefs[k] = v
        #END FOR
        prefs

        self.tmp_directory = ""

        self.original_tempdir = tempfile.gettempdir()

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def library_changed(self,guidb):
        self.guidb = self.gui.library_view.model().db
        try:
            self.mediafileimporterdialog.close()
        except:
            pass
    #-----------------------------------------------------------------------------------------
    def shutting_down(self):
        try:
            if self.tmp_directory == "":
                #~ if DEBUG: print("MFI has shutdown.")
                return True
            else:
                try:
                    if os.path.isdir(self.tmp_directory):
                        import shutil
                        for i in range(10):
                            try:
                                shutil.rmtree(self.tmp_directory)
                                if DEBUG: print("MFI: [0] shutil.rmtree(self.tmp_directory) successful...")
                                break
                            except Exception as e:
                                if DEBUG: print("MFI: [1] shutil.rmtree(self.tmp_directory): ",e)
                                if os.path.isdir(self.tmp_directory):
                                    # In case some other program has one of the temp files open.
                                    sleep(0.1)
                                else:
                                    break
                        #END FOR
                        try:
                            shutil.rmtree(self.tmp_directory, ignore_errors=True)
                        except Exception as e:
                            if DEBUG: print("MFI: [2] shutil.rmtree(self.tmp_directory, ignore_errors=True): ",e)
                except Exception as e:
                    if DEBUG: print("MFI: [3] for i in range: ",e)
                n_total_empty_books_created = prefs['TOTAL_EMPTY_BOOKS_ADDED']
                prefs['TOTAL_EMPTY_BOOKS_ADDED'] = 0
                prefs
                if isinstance(n_total_empty_books_created,int):
                    if n_total_empty_books_created > 0:
                        sleep_time = n_total_empty_books_created * .01
                        sleep_time = int(sleep_time + 0.999)
                        if sleep_time > 5:
                            sleep_time = 5
                        #~ msg = "MFI is cleaning up its temporary work files and directories; please wait for: " + str(sleep_time) + " second(s)."
                        #~ self.gui.status_bar.showMessage(msg)
                        sleep(sleep_time)
                if DEBUG: print("MFI has shut down...and all of its temporary files and directories have already been removed...")
        except Exception as e:
            if DEBUG: print("MFI shutting_down exception: ", e)

        return True
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def drag_and_drop_control(self):
        if self.tmp_directory == "":
            self.tmp_directory =  tempfile.mkdtemp(suffix='_mfi_', prefix='', dir=self.original_tempdir)
            if isbytestring(self.tmp_directory):
                self.tmp_directory = self.tmp_directory.decode(filesystem_encoding)
            self.tmp_directory = self.tmp_directory.replace(os.sep,'/')
        self.guidb = self.gui.library_view.model().db
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.mediafileimporterdialog = MediaFileImporterDialog(self.gui,self.guidb,self.qaction.icon(),self.ui_exit,self.tmp_directory)
        self.mediafileimporterdialog.show()
   #-----------------------------------------------------------------------------------------
    def ui_exit(self,restart=False):
        self.mediafileimporterdialog.close()
        tempfile.tempdir = self.original_tempdir
        if restart:
            self.drag_and_drop_control()
    #-----------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#END of ui.py