# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.12"

from PyQt5.Qt import (Qt, QDialog, QFont, QIcon, QGridLayout, QGroupBox, QLabel, QMargins, QVBoxLayout, QWidget)

from calibre.utils.config import JSONConfig

S_FALSE = unicode("False")
S_TRUE = unicode("True")

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/Media File Importer')

# Set defaults
prefs.defaults['MODE'] = unicode("image")
prefs.defaults['TITLE'] = unicode("{file_name}")
prefs.defaults['AUTHORS'] = unicode("{directory_name:1}")
prefs.defaults['SERIES'] = unicode("{directory_name:0}")
prefs.defaults['PUBLISHER'] = unicode("me")
prefs.defaults['TAGS'] = unicode("{file_extension}")
prefs.defaults['IDENTIFIER'] = unicode("")
prefs.defaults['COMMENTS'] = unicode("")
prefs.defaults['COVER_PATH'] = unicode("{path}")
prefs.defaults['CUSTOM_COLUMN_1'] = unicode("")
prefs.defaults['CUSTOM_COLUMN_2'] = unicode("")
prefs.defaults['CUSTOM_COLUMN_3'] = unicode("")
prefs.defaults['CUSTOM_COLUMN_4'] = unicode("")
prefs.defaults['CUSTOM_COLUMN_1_VALUE'] = unicode("")
prefs.defaults['CUSTOM_COLUMN_2_VALUE'] = unicode("")
prefs.defaults['CUSTOM_COLUMN_3_VALUE'] = unicode("")
prefs.defaults['CUSTOM_COLUMN_4_VALUE'] = unicode("")
prefs.defaults['COPY_ORIGINAL_FILE_TOO'] = S_TRUE
prefs.defaults['KEEP_ORIGINAL_PATH_IDENTIFIER'] = S_TRUE
prefs.defaults['TOTAL_EMPTY_BOOKS_ADDED'] = 0
prefs.defaults['COPY_SAME_BASE_FILENAMES_TO_SAME_CALIBRE_DIRECTORY'] = S_TRUE
prefs.defaults['FILE_EXTENSION_PRIORITY_SEQUENCE'] = unicode("Image=.jpg;Image=.png;Audio=.mp3;Audio=.acc;Video=.mkv;Video=.mp4;Video=.avi;Binary=.pcs;Binary=.hus")

class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within Library Codes             </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False

#END of config.py

