# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016,2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.20" # Technical changes

from calibre.customize import InterfaceActionBase

class ActionBaseMediaFileImporter(InterfaceActionBase):

    name                    = 'Media File Importer'
    description           = "Drag media file paths and Drop them to automatically create new books within Calibre having dynamically created metadata, plus a copy of the original media file placed into the same directory as the new book."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 20)
    minimum_calibre_version = (2, 63, 0)

    actual_plugin       = 'calibre_plugins.media_file_importer.ui:ActionMediaFileImporter'

    gui_name = 'Media File Importer'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__py