# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2017, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.0"

from PyQt5.Qt import (Qt, QDialog, QFont, QIcon, QGridLayout, QGroupBox, QLabel, QMargins, QVBoxLayout, QWidget)

from calibre.utils.config import JSONConfig

S_FALSE = unicode("False")
S_TRUE = unicode("True")

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/Library Splitter')

# Set defaults
prefs.defaults['LS_TARGET_LIBRARY_TEXT_CUSTOM_COLUMN'] = unicode("#target_library_name")


class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within Library Splitter             </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False

#END of config.py

