# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.37"  #LCEAD Tags and FAST Tags: option to prepend any specified prefix to each Tag.

from PyQt5.Qt import (Qt, QDialog, QFont, QIcon, QGridLayout, QGroupBox, QLabel, QMargins, QVBoxLayout, QWidget)

from calibre.utils.config import JSONConfig

S_FALSE = unicode("False")
S_TRUE = unicode("True")

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/Library Codes')

# Set defaults
prefs.defaults['DDC'] = unicode("#ddc")
prefs.defaults['LCC'] = unicode("#lcc")
prefs.defaults['FAST'] = unicode("#fast")
prefs.defaults['OCLC'] = unicode("#oclc_owi")
prefs.defaults['DDC_IS_ACTIVE'] = unicode(S_FALSE)
prefs.defaults['LCC_IS_ACTIVE'] = unicode(S_FALSE)
prefs.defaults['FAST_IS_ACTIVE'] = unicode(S_FALSE)
prefs.defaults['FAST_PREFIX'] = unicode("")  #deprecated--to be removed in the next release
prefs.defaults['OCLC_IS_ACTIVE'] = unicode(S_FALSE)
prefs.defaults['OCLC_IDENTIFIER'] = unicode(S_TRUE)
prefs.defaults['EXTRA_AUTHOR_DETAILS'] = unicode('#lcead')
prefs.defaults['EXTRA_AUTHOR_DETAILS_IS_ACTIVE'] = unicode(S_TRUE)
prefs.defaults['EXTRA_AUTHOR_DETAILS_PREFIX'] = unicode("")  #deprecated--to be removed in the next release
prefs.defaults['GENRE'] = unicode("#lc_genre")
prefs.defaults['GENRE_DDC_IS_ACTIVE'] = unicode(S_FALSE)
prefs.defaults['GENRE_LCC_IS_ACTIVE'] = unicode(S_FALSE)
prefs.defaults['GENRE_IS_INACTIVE'] = unicode(S_TRUE)
prefs.defaults['GENRE_EXACT_MATCH'] = unicode(S_TRUE)
prefs.defaults['GENRE_LCC_MATCH_LENGTH'] = 2

class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within Library Codes             </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False

#END of config.py

