# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016,2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.89"  # changes to ensure successful deprecation of ui.py code re: table _js_settings

import os,sys,apsw,copy,ast
from PyQt5.Qt import (Qt, QDialog, QVBoxLayout, QFont, QWidget, QHBoxLayout,
                                       QTableWidget, QTableWidgetItem, QSize, QPushButton,QDialogButtonBox,
                                       QIcon, QAbstractItemView, QCheckBox, QInputDialog)
from calibre.constants import DEBUG
from calibre import isbytestring
from calibre.constants import filesystem_encoding
from calibre.gui2 import gprefs, question_dialog, info_dialog, error_dialog

from calibre_plugins.job_spy.config import prefs

CUSTOM_COLUMN_EDITABLE_MATRIX = "CUSTOM_COLUMN_EDITABLE_MATRIX"
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(300, 300)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class CustomColumnEditableDialog(SizePersistedDialog):

    def __init__(self,gui,guidb,icon,mode,easygroup):

        parent = gui
        unique_pref_name = 'job_spy:custom_column_editable_dialog_'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        self.gui = gui
        self.guidb = guidb
        self.icon = icon
        self.mode = mode
        self.easygroup = easygroup

        self.custom_column_editable_dict = {}

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Job Spy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            return

        self.get_table_custom_columns(my_db,my_cursor)

        my_db.close()

        nrows = len(self.custom_column_list)

        if nrows == 0:
            error_dialog(self.gui, _('Job Spy'),_('No Custom Columns exist in this Calibre Library.  Nothing to do.'), show=True)

        self.setToolTip("<p style='white-space:wrap'>Set a Custom Column as 'editable' ('unprotected'/'visible') or 'not editable' ('protected'/'hidden') so that it does or does not appear in the the 'Edit Metadata' dialogs. \
                                <br><br>Note: 'Composite' (virtual) Custom Columns are excluded by this GUI Tool.\
                                <br><br>Warning: User Discretion is Advised.\
                                <br><br>Caution: The 'Bulk Edit Search and Replace' tab ignores this setting.\
                                <br><br>Warning: Plug-ins that update Custom Columns, such as Count Pages, may or may not fail if you set its Custom Column (such as '#pages') to 'protected'/'not editable'/'hidden'.\
                                <br><br>Reminder: A 'Calibre Restart' is required for these changes to take effect as far as the 'Edit Metadata' dialogs are concerned.")

        self.setWindowTitle('JS+ GUI Tool: Protect/Unprotect Custom Columns')
        self.setWindowIcon(icon)

        self.get_reserved_prefs()

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()

        #~ ------------------------

        font.setBold(True)
        font.setPointSize(7)

        self.buttonbox_0 = QDialogButtonBox()
        self.buttonbox_0.setCenterButtons(True)
        self.layout.addWidget(self.buttonbox_0)

        self.push_button_rename_group1 = QPushButton(" ", self)
        s = "Rename " + self.group1_name
        self.push_button_rename_group1.setText(s)
        self.push_button_rename_group1.clicked.connect(self.rename_group1)
        self.push_button_rename_group1.setFont(font)
        self.push_button_rename_group1.setToolTip("<p style='white-space:wrap'>Rename this Column Heading (representing a custom group that you define) as you wish in order to aid you in remembering what scenario it is for. Example: Rename it to 'Amazon' or 'GoodReads' or 'Google' or 'Basic Metadata' etc. ")
        self.buttonbox_0.addButton(self.push_button_rename_group1,0)

        self.push_button_rename_group2 = QPushButton(" ", self)
        s = "Rename " + self.group2_name
        self.push_button_rename_group2.setText(s)
        self.push_button_rename_group2.clicked.connect(self.rename_group2)
        self.push_button_rename_group2.setFont(font)
        self.push_button_rename_group2.setToolTip("<p style='white-space:wrap'>Rename this Column Heading (representing a custom group that you define) as you wish in order to aid you in remembering what scenario it is for. Example: Rename it to 'Amazon' or 'GoodReads' or 'Google' or 'Basic Metadata' etc. ")
        self.buttonbox_0.addButton(self.push_button_rename_group2,0)


        self.push_button_rename_group3 = QPushButton(" ", self)
        s = "Rename " + self.group3_name
        self.push_button_rename_group3.setText(s)
        self.push_button_rename_group3.clicked.connect(self.rename_group3)
        self.push_button_rename_group3.setFont(font)
        self.push_button_rename_group3.setToolTip("<p style='white-space:wrap'>Rename this Column Heading (representing a custom group that you define) as you wish in order to aid you in remembering what scenario it is for. Example: Rename it to 'Amazon' or 'GoodReads' or 'Google' or 'Basic Metadata' etc. ")
        self.buttonbox_0.addButton(self.push_button_rename_group3,0)

        self.push_button_rename_group4 = QPushButton(" ", self)
        s = "Rename " + self.group4_name
        self.push_button_rename_group4.setText(s)
        self.push_button_rename_group4.clicked.connect(self.rename_group4)
        self.push_button_rename_group4.setFont(font)
        self.push_button_rename_group4.setToolTip("<p style='white-space:wrap'>Rename this Column Heading (representing a custom group that you define) as you wish in order to aid you in remembering what scenario it is for. Example: Rename it to 'Amazon' or 'GoodReads' or 'Google' or 'Basic Metadata' etc. ")
        self.buttonbox_0.addButton(self.push_button_rename_group4,0)

        self.push_button_rename_group5 = QPushButton(" ", self)
        s = "Rename " + self.group5_name
        self.push_button_rename_group5.setText(s)
        self.push_button_rename_group5.clicked.connect(self.rename_group5)
        self.push_button_rename_group5.setFont(font)
        self.push_button_rename_group5.setToolTip("<p style='white-space:wrap'>Rename this Column Heading (representing a custom group that you define) as you wish in order to aid you in remembering what scenario it is for. Example: Rename it to 'Amazon' or 'GoodReads' or 'Google' or 'Basic Metadata' etc. ")
        self.buttonbox_0.addButton(self.push_button_rename_group5,0)

        self.push_button_rename_group6 = QPushButton(" ", self)
        s = "Rename " + self.group6_name
        self.push_button_rename_group6.setText(s)
        self.push_button_rename_group6.clicked.connect(self.rename_group6)
        self.push_button_rename_group6.setFont(font)
        self.push_button_rename_group6.setToolTip("<p style='white-space:wrap'>Rename this Column Heading (representing a custom group that you define) as you wish in order to aid you in remembering what scenario it is for. Example: Rename it to 'Amazon' or 'GoodReads' or 'Google' or 'Basic Metadata' etc. ")
        self.buttonbox_0.addButton(self.push_button_rename_group6,0)

        #~ ------------------------

        font.setBold(False)
        font.setPointSize(10)

        self.column_label_dict = {}
        self.column_label_dict[0] = "ID"
        self.column_label_dict[1] = "#Lookup Name"
        self.column_label_dict[2] = "Column Name"
        self.column_label_dict[3] = "Editable"                     # offset = 3
        self.column_label_dict[4] = self.group1_name        # so 1 + 3 = 4, which is k
        self.column_label_dict[5] = self.group2_name        # so 2 + 3 = 5, which is k
        self.column_label_dict[6] = self.group3_name
        self.column_label_dict[7] = self.group4_name
        self.column_label_dict[8] = self.group5_name
        self.column_label_dict[9] = self.group6_name

        self.column_label_list = []
        self.column_label_list.append(self.column_label_dict[0])
        self.column_label_list.append(self.column_label_dict[1])
        self.column_label_list.append(self.column_label_dict[2])
        self.column_label_list.append(self.column_label_dict[3])
        self.column_label_list.append(self.column_label_dict[4])
        self.column_label_list.append(self.column_label_dict[5])
        self.column_label_list.append(self.column_label_dict[6])
        self.column_label_list.append(self.column_label_dict[7])
        self.column_label_list.append(self.column_label_dict[8])
        self.column_label_list.append(self.column_label_dict[9])


        self.js_qtablewidget = QTableWidget(nrows,10)     # number of rows and columns
        self.js_qtablewidget.setToolTip("<p style='white-space:wrap'>This matrix contains the Protection Status ('editable'/'unprotected'/'visible' or 'not editable'/'protected'/'hidden') of each of this Calibre Library's Custom Columns, plus your personal scenarios for protecting or unprotecting each Custom Column.<br><br>'Checked' in this matrix means 'Editable'/'Unprotected'/'Visible' in 'Edit Metadata' ")

        self.js_qtablewidget.setSortingEnabled(False)         # required prior to loop...or bad things happen...

        self.js_qtablewidget.setHorizontalHeaderLabels(self.column_label_list)

        r = 0
        for row in self.custom_column_list:

            id,label,name,editable = row
            id = int(id)
            editable = self.custom_column_editable_dict[id]
            editable = int(editable)

            id = str(id)
            label = str(label)
            name = str(name)

            c0 = QTableWidgetItem("",0)
            c1 = QTableWidgetItem("",0)
            c2 = QTableWidgetItem("",0)

            c0.setText(id)
            c1.setText(label)
            c2.setText(name)

            c0.setFlags(Qt.NoItemFlags)
            c1.setFlags(Qt.NoItemFlags)
            c2.setFlags(Qt.NoItemFlags)

            self.js_qtablewidget.setItem(r,0,c0)
            self.js_qtablewidget.setItem(r,1,c1)
            self.js_qtablewidget.setItem(r,2,c2)

            c3 = QTableWidgetItem("",0)
            c4 = QTableWidgetItem("",0)
            c5 = QTableWidgetItem("",0)
            c6 = QTableWidgetItem("",0)
            c7 = QTableWidgetItem("",0)
            c8 = QTableWidgetItem("",0)
            c9 = QTableWidgetItem("",0)

            c3.setFlags(Qt.ItemIsUserCheckable)
            c4.setFlags(Qt.ItemIsUserCheckable)
            c5.setFlags(Qt.ItemIsUserCheckable)
            c6.setFlags(Qt.ItemIsUserCheckable)
            c7.setFlags(Qt.ItemIsUserCheckable)
            c8.setFlags(Qt.ItemIsUserCheckable)
            c9.setFlags(Qt.ItemIsUserCheckable)

            self.js_qtablewidget.setItem(r,3,c3)
            self.js_qtablewidget.setItem(r,4,c4)
            self.js_qtablewidget.setItem(r,5,c5)
            self.js_qtablewidget.setItem(r,6,c6)
            self.js_qtablewidget.setItem(r,7,c7)
            self.js_qtablewidget.setItem(r,8,c8)
            self.js_qtablewidget.setItem(r,9,c9)

            checkbox_tooltip ="<p style='white-space:wrap'>'Checked' means 'Editable'/'Unprotected'/'Visible' in 'Edit Metadata'"

            editable_checkbox = QCheckBox("")
            editable_checkbox.setToolTip(checkbox_tooltip)
            if editable == 1:
                editable_checkbox.setChecked(True)
            else:
                editable_checkbox.setChecked(False)
            self.js_qtablewidget.setCellWidget(r,3,editable_checkbox)

            group1 = QCheckBox("")
            group1.setToolTip(checkbox_tooltip)
            answer = self.get_group_checked_answer(id,1)
            group1.setChecked(answer)
            self.js_qtablewidget.setCellWidget(r,4,group1)
            group2 = QCheckBox("")
            group2.setToolTip(checkbox_tooltip)
            answer = self.get_group_checked_answer(id,2)
            group2.setChecked(answer)
            self.js_qtablewidget.setCellWidget(r,5,group2)
            group3 = QCheckBox("")
            group3.setToolTip(checkbox_tooltip)
            answer = self.get_group_checked_answer(id,3)
            group3.setChecked(answer)
            self.js_qtablewidget.setCellWidget(r,6,group3)
            group4 = QCheckBox("")
            group4.setToolTip(checkbox_tooltip)
            answer = self.get_group_checked_answer(id,4)
            group4.setChecked(answer)
            self.js_qtablewidget.setCellWidget(r,7,group4)
            group5 = QCheckBox("")
            group5.setToolTip(checkbox_tooltip)
            answer = self.get_group_checked_answer(id,5)
            group5.setChecked(answer)
            self.js_qtablewidget.setCellWidget(r,8,group5)
            group6 = QCheckBox("")
            group6.setToolTip(checkbox_tooltip)
            answer = self.get_group_checked_answer(id,6)
            group6.setChecked(answer)
            self.js_qtablewidget.setCellWidget(r,9,group6)

            r = r + 1

        #END FOR
        #~ ------------------------

        self.js_qtablewidget.resizeColumnToContents(0)
        self.js_qtablewidget.resizeColumnToContents(1)
        self.js_qtablewidget.resizeColumnToContents(2)
        self.js_qtablewidget.resizeColumnToContents(3)
        self.js_qtablewidget.resizeColumnToContents(4)
        self.js_qtablewidget.resizeColumnToContents(5)
        self.js_qtablewidget.resizeColumnToContents(6)
        self.js_qtablewidget.resizeColumnToContents(7)
        self.js_qtablewidget.resizeColumnToContents(8)
        self.js_qtablewidget.resizeColumnToContents(9)

        self.js_qtablewidget.setSortingEnabled(True)

        self.js_qtablewidget.sortItems(1,Qt.AscendingOrder)

        self.layout.addWidget(self.js_qtablewidget)
        #~ ------------------------

        font.setPointSize(7)
        font.setBold(True)
        #~ ------------------------

        self.buttonbox_1 = QDialogButtonBox()
        self.buttonbox_1.setCenterButtons(True)
        self.layout.addWidget(self.buttonbox_1)

        self.push_button_protect1 = QPushButton(" ", self)
        s = "Protect " + self.group1_name
        self.push_button_protect1.setText(s)
        self.push_button_protect1.clicked.connect(self.protect_group_1)
        self.push_button_protect1.setFont(font)
        self.push_button_protect1.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Protected'/'Not Editable'/'Hidden'")
        self.buttonbox_1.addButton(self.push_button_protect1,0)

        self.push_button_protect2 = QPushButton(" ", self)
        s = "Protect " + self.group2_name
        self.push_button_protect2.setText(s)
        self.push_button_protect2.clicked.connect(self.protect_group_2)
        self.push_button_protect2.setFont(font)
        self.push_button_protect2.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Protected'/'Not Editable'/'Hidden'")
        self.buttonbox_1.addButton(self.push_button_protect2,0)

        self.push_button_protect3 = QPushButton(" ", self)
        s = "Protect " + self.group3_name
        self.push_button_protect3.setText(s)
        self.push_button_protect3.clicked.connect(self.protect_group_3)
        self.push_button_protect3.setFont(font)
        self.push_button_protect3.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Protected'/'Not Editable'/'Hidden'")
        self.buttonbox_1.addButton(self.push_button_protect3,0)

        self.push_button_protect4 = QPushButton(" ", self)
        s = "Protect " + self.group4_name
        self.push_button_protect4.setText(s)
        self.push_button_protect4.clicked.connect(self.protect_group_4)
        self.push_button_protect4.setFont(font)
        self.push_button_protect4.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Protected'/'Not Editable'/'Hidden'")
        self.buttonbox_1.addButton(self.push_button_protect4,0)

        self.push_button_protect5 = QPushButton(" ", self)
        s = "Protect " + self.group5_name
        self.push_button_protect5.setText(s)
        self.push_button_protect5.clicked.connect(self.protect_group_5)
        self.push_button_protect5.setFont(font)
        self.push_button_protect5.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Protected'/'Not Editable'/'Hidden'")
        self.buttonbox_1.addButton(self.push_button_protect5,0)

        self.push_button_protect6 = QPushButton(" ", self)
        s = "Protect " + self.group6_name
        self.push_button_protect6.setText(s)
        self.push_button_protect6.clicked.connect(self.protect_group_6)
        self.push_button_protect6.setFont(font)
        self.push_button_protect6.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Protected'/'Not Editable'/'Hidden'")
        self.buttonbox_1.addButton(self.push_button_protect6,0)

        #~ ------------------------

        self.buttonbox_2 = QDialogButtonBox()
        self.buttonbox_2.setCenterButtons(True)
        self.layout.addWidget(self.buttonbox_2)

        self.push_button_unprotect1 = QPushButton(" ", self)
        s = "Unprotect " + self.group1_name
        self.push_button_unprotect1.setText(s)
        self.push_button_unprotect1.clicked.connect(self.unprotect_group_1)
        self.push_button_unprotect1.setFont(font)
        self.push_button_unprotect1.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Unprotected'/'Editable'/'Visible' ")
        self.buttonbox_2.addButton(self.push_button_unprotect1,0)

        self.push_button_unprotect2 = QPushButton(" ", self)
        s = "Unprotect " + self.group2_name
        self.push_button_unprotect2.setText(s)
        self.push_button_unprotect2.clicked.connect(self.unprotect_group_2)
        self.push_button_unprotect2.setFont(font)
        self.push_button_unprotect2.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Unprotected'/'Editable'/'Visible' ")
        self.buttonbox_2.addButton(self.push_button_unprotect2,0)

        self.push_button_unprotect3 = QPushButton(" ", self)
        s = "Unprotect " + self.group3_name
        self.push_button_unprotect3.setText(s)
        self.push_button_unprotect3.clicked.connect(self.unprotect_group_3)
        self.push_button_unprotect3.setFont(font)
        self.push_button_unprotect3.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Unprotected'/'Editable'/'Visible' ")
        self.buttonbox_2.addButton(self.push_button_unprotect3,0)

        self.push_button_unprotect4 = QPushButton(" ", self)
        s = "Unprotect " + self.group4_name
        self.push_button_unprotect4.setText(s)
        self.push_button_unprotect4.clicked.connect(self.unprotect_group_4)
        self.push_button_unprotect4.setFont(font)
        self.push_button_unprotect4.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Unprotected'/'Editable'/'Visible' ")
        self.buttonbox_2.addButton(self.push_button_unprotect4,0)

        self.push_button_unprotect5 = QPushButton(" ", self)
        s = "Unprotect " + self.group5_name
        self.push_button_unprotect5.setText(s)
        self.push_button_unprotect5.clicked.connect(self.unprotect_group_5)
        self.push_button_unprotect5.setFont(font)
        self.push_button_unprotect5.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Unprotected'/'Editable'/'Visible' ")
        self.buttonbox_2.addButton(self.push_button_unprotect5,0)

        self.push_button_unprotect6 = QPushButton(" ", self)
        s = "Unprotect " + self.group6_name
        self.push_button_unprotect6.setText(s)
        self.push_button_unprotect6.clicked.connect(self.unprotect_group_6)
        self.push_button_unprotect6.setFont(font)
        self.push_button_unprotect6.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in this custom group to 'Unprotected'/'Editable'/'Visible' ")
        self.buttonbox_2.addButton(self.push_button_unprotect6,0)

        #~ ------------------------
        self.buttonbox_5 = QDialogButtonBox()
        self.buttonbox_5.setCenterButtons(True)
        self.layout.addWidget(self.buttonbox_5)

        self.push_button_use_group_1 = QPushButton(" ", self)
        s = "Use " + self.group1_name
        self.push_button_use_group_1.setText(s)
        self.push_button_use_group_1.clicked.connect(self.use_group_1)
        self.push_button_use_group_1.setFont(font)
        self.push_button_use_group_1.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in the 'Editable' column of this matrix row-by-row to be identical to each row's checkbox for this specific custom grouping.")
        self.buttonbox_5.addButton(self.push_button_use_group_1,0)

        self.push_button_use_group_2 = QPushButton(" ", self)
        s = "Use " + self.group2_name
        self.push_button_use_group_2.setText(s)
        self.push_button_use_group_2.clicked.connect(self.use_group_2)
        self.push_button_use_group_2.setFont(font)
        self.push_button_use_group_2.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in the 'Editable' column of this matrix row-by-row to be identical to each row's checkbox for this specific custom grouping.")
        self.buttonbox_5.addButton(self.push_button_use_group_2,0)

        self.push_button_use_group_3 = QPushButton(" ", self)
        s = "Use " + self.group3_name
        self.push_button_use_group_3.setText(s)
        self.push_button_use_group_3.clicked.connect(self.use_group_3)
        self.push_button_use_group_3.setFont(font)
        self.push_button_use_group_3.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in the 'Editable' column of this matrix row-by-row to be identical to each row's checkbox for this specific custom grouping.")
        self.buttonbox_5.addButton(self.push_button_use_group_3,0)

        self.push_button_use_group_4 = QPushButton(" ", self)
        s = "Use " + self.group4_name
        self.push_button_use_group_4.setText(s)
        self.push_button_use_group_4.clicked.connect(self.use_group_4)
        self.push_button_use_group_4.setFont(font)
        self.push_button_use_group_4.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in the 'Editable' column of this matrix row-by-row to be identical to each row's checkbox for this specific custom grouping.")
        self.buttonbox_5.addButton(self.push_button_use_group_4,0)

        self.push_button_use_group_5 = QPushButton(" ", self)
        s = "Use " + self.group5_name
        self.push_button_use_group_5.setText(s)
        self.push_button_use_group_5.clicked.connect(self.use_group_5)
        self.push_button_use_group_5.setFont(font)
        self.push_button_use_group_5.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in the 'Editable' column of this matrix row-by-row to be identical to each row's checkbox for this specific custom grouping.")
        self.buttonbox_5.addButton(self.push_button_use_group_5,0)

        self.push_button_use_group_6 = QPushButton(" ", self)
        s = "Use " + self.group6_name
        self.push_button_use_group_6.setText(s)
        self.push_button_use_group_6.clicked.connect(self.use_group_6)
        self.push_button_use_group_6.setFont(font)
        self.push_button_use_group_6.setToolTip("<p style='white-space:wrap'>Set all of the checkboxes in the 'Editable' column of this matrix row-by-row to be identical to each row's checkbox for this specific custom grouping.")
        self.buttonbox_5.addButton(self.push_button_use_group_6,0)

        #~ ------------------------

        self.buttonbox_3 = QDialogButtonBox()
        self.buttonbox_3.setCenterButtons(True)
        self.layout.addWidget(self.buttonbox_3)

        self.push_button_protect_all = QPushButton(" ", self)
        self.push_button_protect_all.setText("Protect All")
        self.push_button_protect_all.clicked.connect(self.protect_all)
        self.push_button_protect_all.setFont(font)
        self.push_button_protect_all.setToolTip("<p style='white-space:wrap'>Set all Custom Columns in this matrix to have an 'Editable' column value of 'Protect'/'Not Editable'/'Hidden'")
        self.buttonbox_3.addButton(self.push_button_protect_all,0)

        self.push_button_unprotect_all = QPushButton(" ", self)
        self.push_button_unprotect_all.setText("Unprotect All")
        self.push_button_unprotect_all.clicked.connect(self.unprotect_all)
        self.push_button_unprotect_all.setFont(font)
        self.push_button_unprotect_all.setToolTip("<p style='white-space:wrap'>Set all Custom Columns in this matrix to have an 'Editable' column value of 'Unprotected'/'Editable'/'Visible'")
        self.buttonbox_3.addButton(self.push_button_unprotect_all,0)

        self.buttonbox_4 = QDialogButtonBox()
        self.buttonbox_4.setCenterButtons(True)
        self.layout.addWidget(self.buttonbox_4)

        self.push_button_save_matrix_all = QPushButton(" ", self)
        self.push_button_save_matrix_all.setText("Save Group Assignments to Custom Columns")
        self.push_button_save_matrix_all.clicked.connect(self.save_group_assignments)
        self.push_button_save_matrix_all.setFont(font)
        self.push_button_save_matrix_all.setToolTip("<p style='white-space:wrap'>Save the user-defined checks for each custom group for each Custom Column.  Nothing else is saved.")
        self.buttonbox_4.addButton(self.push_button_save_matrix_all,0)

        self.push_button_apply_to_db = QPushButton(" ", self)
        self.push_button_apply_to_db.setText("Update 'Editable' per Current Settings")
        self.push_button_apply_to_db.clicked.connect(self.update_table_custom_columns)
        self.push_button_apply_to_db.setFont(font)
        self.push_button_apply_to_db.setToolTip("<p style='white-space:wrap'>Save the Group Assignments to Custom Columns, then immediately update metadata.db Table 'custom_columns', column 'editable', to the value shown for each Custom Column in the 'Editable' matrix column.")
        self.buttonbox_4.addButton(self.push_button_apply_to_db,0)

        self.push_button_save_geometry = QPushButton(" ", self)
        self.push_button_save_geometry.setText("Exit")
        #~ self.push_button_save_geometry.setMaximumWidth(200)
        self.push_button_save_geometry.clicked.connect(self.save_geometry_and_exit)
        self.push_button_save_geometry.setFont(font)
        self.push_button_save_geometry.setToolTip("<p style='white-space:wrap'>Save only the current size of this dialog, then exit")

        self.layout.addWidget(self.push_button_save_geometry)

        #~ ------------------------

        self.resize(self.sizeHint())

        self.resize_dialog()

        #~ ------------------------
        if mode == "normal":
            return
        if self.easygroup == 0:
            return
        self.do_easy_menu_selection()
        return
    #----------------------------------------------------
    def get_group_checked_answer(self,id,group):

        if len(self.cc_matrix_dict) == 0:
            #~ if DEBUG: print("self.cc_matrix_dict: len == 0; nothing to do")
            return False

        id = int(id)

        if not id in self.cc_matrix_dict:
            id = str(id)
            if not id in self.cc_matrix_dict:
                if DEBUG: print("id not in self.cc_matrix_dict: ", str(id))
                return False

        cc_row = self.cc_matrix_dict[id]         #  saved as a str(list)
        cc_row = str(cc_row)
        tmp_list = ast.literal_eval(cc_row)
        if not isinstance(tmp_list,list):
            if DEBUG: print("error: cc_row not converted to a list via ast.literal_eval; error...")
            return False

        #~ if DEBUG: print("cc_row: ", str(tmp_list))

        is_group1s = str(tmp_list[1])
        is_group2s = str(tmp_list[2])
        is_group3s = str(tmp_list[3])
        is_group4s = str(tmp_list[4])
        is_group5s = str(tmp_list[5])
        is_group6s = str(tmp_list[6])

        if is_group1s == str("True"):     # checkbox was checked...meaning editable...meaning unprotected...meaning visible... in Edit Metadata dialogs
            is_group1 = True
        else:
            is_group1 = False
        if is_group2s == str("True"):
            is_group2 = True
        else:
            is_group2 = False
        if is_group3s == str("True"):
            is_group3 = True
        else:
            is_group3 = False
        if is_group4s == str("True"):
            is_group4 = True
        else:
            is_group4 = False
        if is_group5s == str("True"):
            is_group5 = True
        else:
            is_group5 = False
        if is_group6s == str("True"):
            is_group6 = True
        else:
            is_group6 = False

        if group == 1:
            if is_group1: return True
        elif group == 2:
            if is_group2: return True
        elif group == 3:
            if is_group3: return True
        elif group == 4:
            if is_group4: return True
        elif group == 5:
            if is_group5: return True
        elif group == 6:
            if is_group6: return True

        return False
    #----------------------------------------------------
    def save_geometry_and_exit(self):
        self.save_dialog_geometry()
        self.close()
    #----------------------------------------------------
    def get_table_custom_columns(self,my_db,my_cursor):
        self.custom_column_list = []
        mysql = "SELECT label,id,name,editable,datatype FROM custom_columns"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        tmp_rows.sort()
        for row in tmp_rows:
            if row:
                label,id,name,editable,datatype = row
                if datatype <> 'composite':
                    r = id,label,name,editable
                    self.custom_column_list.append(r)
                    self.custom_column_editable_dict[id] = editable
        del tmp_rows
    #----------------------------------------------------
    def apsw_connect_to_library(self):

        my_db = self.guidb

        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        try:
            my_db =apsw.Connection(path)
            is_valid = True
            #~ if DEBUG: print("Library Path: ", path)
        except Exception as e:
            if DEBUG: print("path to metadata.db is: ", path)
            if DEBUG: print("error: ", str(e))
            is_valid = False
            return None,None,is_valid

        my_cursor = my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)

        return my_db,my_cursor,is_valid
    #-----------------------------------------------------------------------------------------
    def get_reserved_prefs(self):

        try:
            try:
                my_db,my_cursor,is_valid = self.apsw_connect_to_library()
                if not is_valid:
                    error_dialog(self.gui, _('Job Spy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
                    return

                #-------------------------------------
                # the use of table preferences by JS is long-deprecated.  delete JS from it if it exists.
                #-------------------------------------
                my_cursor.execute("begin")
                mysql = "DELETE FROM preferences WHERE key = 'reserved:JobSpyPlugin:settings'  "
                my_cursor.execute(mysql)
                my_cursor.execute("commit")

                #-------------------------------------
                my_cursor.execute("begin")
                mysql = "CREATE TABLE IF NOT EXISTS __js_settings (id INTEGER PRIMARY KEY, key TEXT NOT NULL, val TEXT NOT NULL, UNIQUE(key))"
                my_cursor.execute(mysql)
                my_cursor.execute("commit")
                #-------------------------------------

                mysql = "SELECT id,val FROM __js_settings WHERE key = 'reserved:JobSpyPlugin:settings' "
                my_cursor.execute(mysql)
                tmp_rows = my_cursor.fetchall()
                my_db.close()
                if not tmp_rows:
                    tmp_rows = []
                    self.library_config = None
                if len(tmp_rows) == 0:
                    self.library_config = None
                for row in tmp_rows:
                    id,val = row
                    self.library_config = val
                del tmp_rows
                if not self.library_config:
                    self.library_config = {}
            except Exception as e:
                if DEBUG: print("Exception in get_reserved_prefs: ", str(e))
                self.library_config = {}

            self.matrix_dict = self.library_config
            self.matrix_dict = str(self.matrix_dict)
            if not isinstance(self.matrix_dict,dict):
                self.matrix_dict = str(self.matrix_dict)
                self.matrix_dict = ast.literal_eval(self.matrix_dict)
            #~ if DEBUG:
                #~ for k,v in self.matrix_dict.iteritems():
                    #~ print("initial self.matrix_dict: ", str(k),str(v))
            self.unpack_cc_matrix_dict()
            self.unpack_matrix_column_labels()
        except Exception as e:
            if DEBUG: print("Exception in get_reserved_prefs: ", str(e))
            self.library_config = {}
            self.matrix_dict = {}
            self.unpack_cc_matrix_dict()
            self.unpack_matrix_column_labels()
            if DEBUG: print("Exception resulted in initializing the prefs...")
    #-----------------------------------------------------------------------------------------
    def save_reserved_prefs(self):
        self.freshen_custom_column_editable_dict()
        self.pack_cc_matrix_dict()
        self.pack_matrix_column_labels()
        self.library_config = self.matrix_dict
        self.library_config = str(self.library_config)

        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Job Spy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            return
        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO __js_settings (id,key,val) VALUES (null,'reserved:JobSpyPlugin:settings',?) "         # this is the 'real' preferences key used here...
        my_cursor.execute(mysql,[self.library_config])
        my_cursor.execute("commit")

        my_db.close()
    #-----------------------------------------------------------------------------------------
    def pack_cc_matrix_dict(self):
        nrows = self.js_qtablewidget.rowCount()
        r = 0
        while r < nrows:
            item = self.js_qtablewidget.item(r,0)   # id
            id = item.text()
            checkbox = self.js_qtablewidget.cellWidget(r,4)   # group1
            if checkbox.isChecked():
                is_group1s = "True"
            else:
                is_group1s = "False"
            checkbox = self.js_qtablewidget.cellWidget(r,5)   # group2
            if checkbox.isChecked():
                is_group2s = "True"
            else:
                is_group2s = "False"
            checkbox = self.js_qtablewidget.cellWidget(r,6)   # group3
            if checkbox.isChecked():
                is_group3s = "True"
            else:
                is_group3s = "False"
            checkbox = self.js_qtablewidget.cellWidget(r,7)   # group4
            if checkbox.isChecked():
                is_group4s = "True"
            else:
                is_group4s = "False"
            checkbox = self.js_qtablewidget.cellWidget(r,8)   # group5
            if checkbox.isChecked():
                is_group5s = "True"
            else:
                is_group5s = "False"
            checkbox = self.js_qtablewidget.cellWidget(r,9)   # group6
            if checkbox.isChecked():
                is_group6s = "True"
            else:
                is_group6s = "False"

            id = int(id)
            is_group1s = str(is_group1s)
            is_group2s = str(is_group2s)
            is_group3s = str(is_group3s)
            is_group4s = str(is_group4s)
            is_group5s = str(is_group5s)
            is_group6s = str(is_group6s)

            cc_row = id,is_group1s,is_group2s,is_group3s,is_group4s,is_group5s,is_group6s
            cc_row = list(cc_row)
            cc_row = str(cc_row)
            self.cc_matrix_dict[id] = cc_row
            r = r + 1
        #END FOR

        self.matrix_dict[CUSTOM_COLUMN_EDITABLE_MATRIX] = self.cc_matrix_dict
    #-----------------------------------------------------------------------------------------
    def unpack_cc_matrix_dict(self):
        try:
            if not CUSTOM_COLUMN_EDITABLE_MATRIX in self.matrix_dict:
                #~ if DEBUG: print("unpacking; not CUSTOM_COLUMN_EDITABLE_MATRIX in self.matrix_dict")
                self.cc_matrix_dict = {}
                return
            self.cc_matrix_dict = self.matrix_dict[CUSTOM_COLUMN_EDITABLE_MATRIX]
            self.cc_matrix_dict = str(self.cc_matrix_dict)
            self.cc_matrix_dict = ast.literal_eval(self.cc_matrix_dict)
            if not isinstance(self.cc_matrix_dict,dict):
                if self.mode == "normal":
                    info_dialog(self.gui, "JS+ GUI Tool - Protect/Unprotect Custom Columns", "Error[1]: Saved Preferences Unable to be Retrieved...Sorry...").show()
                    self.cc_matrix_dict = {}
            #~ if DEBUG:
                #~ print("unpacking self.cc_matrix_dict from preferences........")
                #~ for k,v in self.cc_matrix_dict.iteritems():
                    #~ print(str(k),str(v))
                #~ #END FOR
        except Exception as e:
            if DEBUG: print("Error in unpack_cc_matrix_dict: ", str(e))
    #-----------------------------------------------------------------------------------------
    def pack_matrix_column_labels(self):
        self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1'] = unicode(self.column_label_list[4])
        self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2'] = unicode(self.column_label_list[5])
        self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3'] = unicode(self.column_label_list[6])
        self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4'] = unicode(self.column_label_list[7])
        self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5'] = unicode(self.column_label_list[8])
        self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6'] = unicode(self.column_label_list[9])
    #-----------------------------------------------------------------------------------------
    def unpack_matrix_column_labels(self):
        #default to the generic, cross-library prefs values, but these will be overridden by self.matrix_dict if one exists...
        self.group1_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1']
        self.group2_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2']
        self.group3_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3']
        self.group4_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4']
        self.group5_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5']
        self.group6_name = prefs.defaults['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6']

        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1' in self.matrix_dict:
            self.group1_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP1']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2' in self.matrix_dict:
            self.group2_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP2']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3' in self.matrix_dict:
            self.group3_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP3']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4' in self.matrix_dict:
            self.group4_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP4']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5' in self.matrix_dict:
            self.group5_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP5']
        if  'GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6' in self.matrix_dict:
            self.group6_name = self.matrix_dict['GUI_TOOLS_PROTECT_CUSTOM_COLUMNS_NAME_GROUP6']
    #-----------------------------------------------------------------------------------------
    def rename_group1(self):
        self.rename_group_generic(1,self.group1_name)
    def rename_group2(self):
        self.rename_group_generic(2,self.group2_name)
    def rename_group3(self):
        self.rename_group_generic(3,self.group3_name)
    def rename_group4(self):
        self.rename_group_generic(4,self.group4_name)
    def rename_group5(self):
        self.rename_group_generic(5,self.group5_name)
    def rename_group6(self):
        self.rename_group_generic(6,self.group6_name)
    def rename_group_generic(self,group,group_name):
        newname, okay = QInputDialog.getText(self, 'Change the Group Name', 'Enter the new name for this Group [up to 10 characters]:', text=group_name)
        if not okay:
            return

        newname = newname.replace(":","")  #colons not allowed in preferences dict...
        newname = newname.strip()
        if len(newname) > 10:
            newname = newname[0:10]
            newname = newname.strip()
        #~ if DEBUG: print("newname for group is: ", newname)

        k = group + 3    # so Group 1 is in column 4, so k = 1 + 3 = 4

        self.column_label_dict[k] = newname
        self.column_label_list[k] = newname

        self.js_qtablewidget.setHorizontalHeaderLabels(self.column_label_list)

        if group == 1:
            s = "Rename " + newname
            self.push_button_rename_group1.setText(s)
            s = "Protect " + newname
            self.push_button_protect1.setText(s)
            s = "Unprotect " + newname
            self.push_button_unprotect1.setText(s)
            s = "Use " + newname
            self.push_button_use_group_1.setText(s)
            self.js_qtablewidget.resizeColumnToContents(4)       # 3 + 1 = 4
        elif group == 2:
            s = "Rename " + newname
            self.push_button_rename_group2.setText(s)
            s = "Protect " + newname
            self.push_button_protect2.setText(s)
            s = "Unprotect " + newname
            self.push_button_unprotect2.setText(s)
            s = "Use " + newname
            self.push_button_use_group_2.setText(s)
            self.js_qtablewidget.resizeColumnToContents(5)
        elif group == 3:
            s = "Rename " + newname
            self.push_button_rename_group3.setText(s)
            s = "Protect " + newname
            self.push_button_protect3.setText(s)
            s = "Unprotect " + newname
            self.push_button_unprotect3.setText(s)
            s = "Use " + newname
            self.push_button_use_group_3.setText(s)
            self.js_qtablewidget.resizeColumnToContents(6)
        elif group == 4:
            s = "Rename " + newname
            self.push_button_rename_group4.setText(s)
            s = "Protect " + newname
            self.push_button_protect4.setText(s)
            s = "Unprotect " + newname
            self.push_button_unprotect4.setText(s)
            s = "Use " + newname
            self.push_button_use_group_4.setText(s)
            self.js_qtablewidget.resizeColumnToContents(7)
        elif group == 5:
            s = "Rename " + newname
            self.push_button_rename_group5.setText(s)
            s = "Protect " + newname
            self.push_button_protect5.setText(s)
            s = "Unprotect " + newname
            self.push_button_unprotect5.setText(s)
            s = "Use " + newname
            self.push_button_use_group_5.setText(s)
            self.js_qtablewidget.resizeColumnToContents(8)
        elif group == 6:
            s = "Rename " + newname
            self.push_button_rename_group6.setText(s)
            s = "Protect " + newname
            self.push_button_protect6.setText(s)
            s = "Unprotect " + newname
            self.push_button_unprotect6.setText(s)
            s = "Use " + newname
            self.push_button_use_group_6.setText(s)
            self.js_qtablewidget.resizeColumnToContents(9)

            self.save_group_assignments()
    #-----------------------------------------------------------------------------------------
    def save_group_assignments(self):
        self.save_reserved_prefs()
        self.save_dialog_geometry()
    #-----------------------------------------------------------------------------------------
    def freshen_custom_column_editable_dict(self):
        nrows = self.js_qtablewidget.rowCount()
        r = 0
        while r < nrows:
            item = self.js_qtablewidget.item(r,0)
            id = item.text()
            id = int(id)
            checkbox = self.js_qtablewidget.cellWidget(r,3)   # editable
            if checkbox.isChecked():
                editable = 1
            else:
                editable = 0
            self.custom_column_editable_dict[id] = editable
            r = r + 1
    #-----------------------------------------------------------------------------------------
    def protect_all(self):
        tmp_dict = self.custom_column_editable_dict.copy()
        for id,editable in tmp_dict.iteritems():
            id = int(id)
            self.custom_column_editable_dict[id] = 0
        #END FOR

        nrows = self.js_qtablewidget.rowCount()
        r = 0
        while r < nrows:
            checkbox = self.js_qtablewidget.cellWidget(r,3)   # editable
            checkbox.setChecked(False)
            r = r + 1
    #-----------------------------------------------------------------------------------------
    def unprotect_all(self):
        tmp_dict = self.custom_column_editable_dict.copy()
        for id,editable in tmp_dict.iteritems():
            id = int(id)
            self.custom_column_editable_dict[id] = 1
        #END FOR
        nrows = self.js_qtablewidget.rowCount()
        r = 0
        while r < nrows:
            checkbox = self.js_qtablewidget.cellWidget(r,3)   # editable
            checkbox.setChecked(True)
            r = r + 1
    #-----------------------------------------------------------------------------------------
    def protect_group_1(self):
        self.protect_unprotect_groups_generic(0,1)
    def protect_group_2(self):
        self.protect_unprotect_groups_generic(0,2)
    def protect_group_3(self):
        self.protect_unprotect_groups_generic(0,3)
    def protect_group_4(self):
        self.protect_unprotect_groups_generic(0,4)
    def protect_group_5(self):
        self.protect_unprotect_groups_generic(0,5)
    def protect_group_6(self):
        self.protect_unprotect_groups_generic(0,6)
    #-----------------------------------------------------------------------------------------
    def unprotect_group_1(self):
        self.protect_unprotect_groups_generic(1,1)
    def unprotect_group_2(self):
        self.protect_unprotect_groups_generic(1,2)
    def unprotect_group_3(self):
        self.protect_unprotect_groups_generic(1,3)
    def unprotect_group_4(self):
        self.protect_unprotect_groups_generic(1,4)
    def unprotect_group_5(self):
        self.protect_unprotect_groups_generic(1,5)
    def unprotect_group_6(self):
        self.protect_unprotect_groups_generic(1,6)
    #-----------------------------------------------------------------------------------------
    def use_group_1(self):
        self.use_group_generic(1)
    def use_group_2(self):
        self.use_group_generic(2)
    def use_group_3(self):
        self.use_group_generic(3)
    def use_group_4(self):
        self.use_group_generic(4)
    def use_group_5(self):
        self.use_group_generic(5)
    def use_group_6(self):
        self.use_group_generic(6)
    #-----------------------------------------------------------------------------------------
    def use_group_generic(self,group):
        column = group + 3
        nrows = self.js_qtablewidget.rowCount()
        r = 0
        while r < nrows:
            checkbox = self.js_qtablewidget.cellWidget(r,column)
            editable_checkbox = self.js_qtablewidget.cellWidget(r,3)
            if checkbox.isChecked():
                editable_checkbox.setChecked(True)
                editable = 0  # Protected/Not Editable/Hidden
            else:
                editable_checkbox.setChecked(False)
                editable = 1  # Unprotected/Editable/Visible
            item = self.js_qtablewidget.item(r,0)
            id = item.text()
            id = int(id)
            self.custom_column_editable_dict[id] = editable
            r = r + 1
    #-----------------------------------------------------------------------------------------
    def protect_unprotect_groups_generic(self,editable,group):

        if editable == 0:
            s = False
        else:
            s = True
        column = group + 3
        nrows = self.js_qtablewidget.rowCount()
        r = 0
        while r < nrows:
            checkbox = self.js_qtablewidget.cellWidget(r,column)
            checkbox.setChecked(s)
            item = self.js_qtablewidget.item(r,0)
            id = item.text()
            id = int(id)
            self.custom_column_editable_dict[id] = editable
            r = r + 1
    #-----------------------------------------------------------------------------------------
    def update_table_custom_columns(self):
        self.save_group_assignments()
        self.freshen_custom_column_editable_dict()
        if len(self.custom_column_editable_dict) == 0:
            return
        my_db,my_cursor,is_valid = self.apsw_connect_to_library()
        if not is_valid:
            error_dialog(self.gui, _('Job Spy'),_('Database Connection Error.  Cannot Connect to the Current Library.'), show=True)
            return
        my_cursor.execute("begin")
        mysql = "UPDATE custom_columns SET editable = ? WHERE id = ? "
        for id,editable in self.custom_column_editable_dict.iteritems():
            editable = int(editable)
            id = int(id)
            my_cursor.execute(mysql,(editable,id))
            #~ if DEBUG: print("table custom columns changed for/to: ", str(id), str(editable))
        #END FOR
        my_cursor.execute("commit")
        my_db.close()
        if self.mode == "normal":
            info_dialog(self.gui, "JS+ GUI Tool - Protect/Unprotect Custom Columns", "Table 'custom_columns' has been updated per your settings.").show()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def do_easy_menu_selection(self):
        #~ if DEBUG: print("do_easy_menu_selection: ", str(self.easygroup))
        if not isinstance(self.easygroup,int):
            return
        self.use_group_generic(self.easygroup)
        self.update_table_custom_columns()
        self.gui.quit(restart=True)

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
#END OF custom_column_editable_dialog.py