# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016,2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.86"     # JS+:GUI Tool:  Add Null to all Custom Columns for books with no existing real values in them [All Books]
import os, sys
from calibre.gui2.threaded_jobs import ThreadedJob, BaseJob
import traceback, cStringIO
from functools import partial
from threading import RLock
from threading import Thread, RLock, Event
from Queue import Empty, Queue
from calibre.utils.ipc.job import BaseJob
from calibre.utils.logging import Log

from calibre_plugins.job_spy.extract_orig_title_translator_job import main_js_ot_t_extract
from calibre_plugins.job_spy.add_null_values_to_custom_columns_job import main_js_add_null_values

# ------------------------------------------------------------------------------
#    Function to perform JS Jobs using ThreadedJob
# ------------------------------------------------------------------------------
def start_threaded_js_extract_original_title_translator(self, guidb, plugin_path, book_ids, param_dict, callback):

    job = ThreadedJob('jobspyplugin','Extract Original Title/Translator',main_js_ot_t_extract,(self,guidb, plugin_path, book_ids, param_dict), {}, callback)
    self.gui.job_manager.run_threaded_job(job)

def start_threaded_js_add_null_values(self, guidb, book_ids, wait_seconds,callback):
    job = ThreadedJob('jobspyplugin','Add Null to all Custom Columns for books with no existing real values',main_js_add_null_values,(self,guidb, book_ids,wait_seconds), {}, callback)
    self.gui.job_manager.run_threaded_job(job)

#END of jobs.py
