# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.77"   #New GUI Tool: Custom Columns Technical Listing


from PyQt5.Qt import (Qt, QDialog, QLabel,  QFont, QWidget, QApplication,
                                       QIcon, QGridLayout, QGroupBox, QMargins, QScrollArea,
                                       QTableWidget, QTableWidgetItem, QDialogButtonBox,
                                       QSize, QPushButton, QVBoxLayout, QHBoxLayout)

from calibre.constants import DEBUG
from calibre.gui2 import gprefs
from calibre.gui2.ui import get_gui
from calibre.utils.config import JSONConfig

from calibre_plugins.job_spy.config import prefs

#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(90, 90)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)
        self.finished.connect(self.dialog_closing)

    def resize_dialog(self):

        #~ if DEBUG: self.geom = None

        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def dialog_closing(self, result):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class CustomColumnsTechnicalListingDialog(SizePersistedDialog):

    def __init__(self, parent, table_custom_columns_list):
        unique_pref_name = 'Job_Spy:custom_columns_technical_listing_dialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        mytitle = 'JS+ GUI Tool:  Custom Columns Technical Listing'
        self.setWindowTitle(_(mytitle))

        layout = QVBoxLayout(self)
        self.setLayout(layout)

        #~ table_custom_columns_list.sort()               #row = id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized

        self.n_log_rows = len(table_custom_columns_list)

        #--------------------------------------------------
        column_label_list = []
        column_label_list.append("label")
        column_label_list.append("name")
        column_label_list.append("datatype")
        column_label_list.append("id")
        column_label_list.append("mark_for_delete")
        column_label_list.append("editable")
        column_label_list.append("display")
        column_label_list.append("is_multiple")
        column_label_list.append("normalized")


        self.n_total_cols = 9

        self.logtable = QTableWidget(self.n_log_rows,self.n_total_cols)

        self.logtable.setSortingEnabled(False)

        self.logtable.setHorizontalHeaderLabels(column_label_list)

        self.logtable.setColumnWidth(0, 200)
        self.logtable.setColumnWidth(1, 200)
        self.logtable.setColumnWidth(2, 200)
        self.logtable.setColumnWidth(3, 200)
        self.logtable.setColumnWidth(4, 200)
        self.logtable.setColumnWidth(5, 200)
        self.logtable.setColumnWidth(6, 200)
        self.logtable.setColumnWidth(7, 200)
        self.logtable.setColumnWidth(8, 200)

        self.logtable.clearContents()
        #--------------------------------------------------

        r = 0
        for row in table_custom_columns_list:
            try:
                #~ if DEBUG: print(str(row))
                #---------------------------
                #---------------------------
                id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized = row

                id = str(id)
                label = str(label)
                mark_for_delete = str(mark_for_delete)
                editable = str(editable)
                is_multiple = str(is_multiple)
                normalized = str(normalized)

                if not display:
                    display = "None"

                #---------------------------
                #---------------------------
                id_ = QTableWidgetItem(id)
                label_ = QTableWidgetItem(label)
                name_ = QTableWidgetItem(name)
                datatype_ = QTableWidgetItem(datatype)
                mark_for_delete_ = QTableWidgetItem(mark_for_delete)
                editable_ = QTableWidgetItem(editable)
                display_ = QTableWidgetItem(display)
                is_multiple_ = QTableWidgetItem(is_multiple)
                normalized_ = QTableWidgetItem(normalized)

                #---------------------------
                #---------------------------

                self.logtable.setItem(r,0,label_)
                self.logtable.setItem(r,1,name_)
                self.logtable.setItem(r,2,datatype_)
                self.logtable.setItem(r,3,id_)
                self.logtable.setItem(r,4,mark_for_delete_)
                self.logtable.setItem(r,5,editable_)
                self.logtable.setItem(r,6,display_)
                self.logtable.setItem(r,7,is_multiple_)
                self.logtable.setItem(r,8,normalized_)

                #--------------------------------------
                r = r + 1
                #--------------------------------------
            except Exception as e:
                if DEBUG: print("class CustomColumnsTechnicalListingDialog(SizePersistedDialog):", str(e))
                return
        #END FOR

        self.n_total_rows = r

        layout.addWidget(self.logtable)

        self.logtable.sortItems(0,Qt.AscendingOrder )

        self.logtable.setSortingEnabled(True)

        self.resize_all_columns()

        #-----------------------------------------------------

        self.bottom_buttonbox = QDialogButtonBox(QDialogButtonBox.Cancel)
        self.bottom_buttonbox.rejected.connect(self.reject)
        layout.addWidget(self.bottom_buttonbox)

        self.push_button_optimize_column_widths = QPushButton(" ", self)
        self.push_button_optimize_column_widths.setText("Optimize")
        self.push_button_optimize_column_widths.setToolTip("<p style='white-space:wrap'>The listing columns will be resized based on their longest row contents for each column.")
        self.push_button_optimize_column_widths.clicked.connect(self.optimize_column_widths)
        self.bottom_buttonbox.addButton(self.push_button_optimize_column_widths,0)

        self.push_button_deoptimize_column_widths = QPushButton(" ", self)
        self.push_button_deoptimize_column_widths.setText("Deoptimize")
        self.push_button_deoptimize_column_widths.setToolTip("<p style='white-space:wrap'>The listing columns will be resized to a fixed width regardless of their contents.")
        self.push_button_deoptimize_column_widths.clicked.connect(self.deoptimize_column_widths)
        self.bottom_buttonbox.addButton(self.push_button_deoptimize_column_widths,0)

        self.push_button_copy_to_clipboard = QPushButton(" ", self)
        self.push_button_copy_to_clipboard.setText("Export to Clipboard")
        self.push_button_copy_to_clipboard.setToolTip("<p style='white-space:wrap'>The Listing in its entirety will be copied to the Clipboard in a tab-delimited format.  Paste Special into a Spreadsheet, or Paste into a Text Document.")
        self.push_button_copy_to_clipboard.clicked.connect(self.copy_log_to_clipboard)
        self.bottom_buttonbox.addButton(self.push_button_copy_to_clipboard,0)

        self.bottom_buttonbox.setCenterButtons(True)

        #-----------------------------------------------------
        self.resize_dialog()

        self.clip = QApplication.clipboard()

        self.maingui = get_gui()

        self.optimize_column_widths()

    #-----------------------------------------------------
    def resize_all_columns(self):
        self.logtable.resizeColumnsToContents()
        self.save_custom_columns_listing_dialog_geometry()
    #-----------------------------------------------------
    #-----------------------------------------------------
    def optimize_column_widths(self):
        self.logtable.resizeColumnsToContents()
        self.save_custom_columns_listing_dialog_geometry()
    #-----------------------------------------------------
    def deoptimize_column_widths(self):
        self.logtable.setColumnWidth(0, 200)
        self.logtable.setColumnWidth(1, 200)
        self.logtable.setColumnWidth(2, 200)
        self.logtable.setColumnWidth(3, 200)
        self.logtable.setColumnWidth(4, 200)
        self.logtable.setColumnWidth(5, 200)
        self.logtable.setColumnWidth(6, 200)
        self.logtable.setColumnWidth(7, 200)
        self.logtable.setColumnWidth(8, 200)

    #-----------------------------------------------------
    def copy_log_to_clipboard(self):
        #tab delimited, ready to "paste special" into Calc or just paste into text document

        self.logtable.selectAll()

        s = ''
        s = s + "\t".join([str(self.logtable.horizontalHeaderItem(i).text()) for i in xrange(0, self.n_total_cols)])
        s = s +  '\n'
        for r in xrange(0, self.n_total_rows):
            for c in xrange(0, self.n_total_cols):
                try:
                    s = s + str(self.logtable.item(r,c).text()) + "\t"
                except AttributeError:
                    s = s + "\t"
            s = s[:-1] + "\n"        #eliminate last '\t'
        self.clip.setText(s)

        self.save_custom_columns_listing_dialog_geometry()
    #-----------------------------------------------------
    def save_custom_columns_listing_dialog_geometry(self):
        self.dialog_closing(None)
    #-----------------------------------------------------
    #-----------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------

#END OF custom_columns_technical_listing_dialog.py