# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2017, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.88"     # JS+:GUI Tool:  Add Null to all Custom Columns for books with no existing real values in them [All Books]
import os, sys
import apsw
import datetime
from calibre import isbytestring, force_unicode, prints
from calibre.constants import filesystem_encoding, preferred_encoding, DEBUG
from Queue import Empty, Queue
from calibre.utils.logging import Log as log
import time
from time import sleep

from calibre_plugins.job_spy.config import prefs
from calibre_plugins.job_spy.heading import log_heading_common

#----------------------------------------------
#----------------------------------------------
#----------------------------------------------
notifications = Queue()
#----------------------------------------------
my_book_ids = []
#----------------------------------------------
#----------------------------------------------
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None
#----------------------------------------------
#----------------------------------------------
NULL_TEXT = "␀"
NULL_COMMENTS = "␀"
NULL_SERIES = "␀"
NULL_TAGLIKE = "␀"
NULL_BOOL = 0
NULL_INT = 0
NULL_FLOAT = 0.0
NULL_DATETIME = "0102-01-01 00:00:00.000"
#--------------------------------------------------------------

#------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#------------------------------------------------------------------------------------------------------------------------------------------------------------------------
def main_js_add_null_values(self, guidb, book_ids, wait_seconds,log=None, abort=None, notifications=True):

    clear_or_initialize_globals()

    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5

    global my_guidb
    global my_book_ids

    my_book_ids = book_ids

    log("Starting 'Add Null Values to Custom Columns'")
    notifications.put((0.002, 'Add Null Values to Custom Columns'))
    #-----------------------------------------------------------------
    #-----------------------------------------------------------------
    my_guidb = guidb
    path = my_guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')

    log("Library DB: " + path)

    sleep(wait_seconds)  # to avoid conflicts with Calibre db locking at startup due to initializing built-ins...

    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log(str(e))
        raise e
        return

    my_cursor = my_db.cursor()

    header_s1 =  str("SQLite Version: " + str(apsw.SQLITE_VERSION_NUMBER) + "    [APSW]")
    mysql = str("PRAGMA main.busy_timeout = 15000")         #milliseconds
    my_cursor.execute(mysql)
    header_s2 = mysql

    header_s3 = "Beginning 'Add Null Values to Custom Columns' Processing"

    log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)

   #----------------------------------------------------------------------------------------------------------------
    log(" ")
    if wait_seconds > 1:
        msg = "...waited for NN seconds to continue so as to avoid potental conflicts with Calibre at startup or change in Library..."
        msg = msg.replace("NN",str(wait_seconds))
        log(msg)
        log(" ")

    JS_Control(my_db,my_cursor,log,notifications)

    log(" ")
    #----------------------------------------------------------------------------------------------------------------

    my_db.close()

    log(" ")
    log(" ")
    log("Job complete.")

    clear_or_initialize_globals()

    return
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def clear_or_initialize_globals():
    # called both at the beginning and the end of the job.
    # clear all lists, sets, dicts, and ordered dicts from the previous job that persist from that job to the next job(s) submitted (unless calibre is exited first)
    # initialize all other globals

    global my_book_ids
    global  header_s1
    global  header_s2
    global  header_s3
    global  header_s4
    global  header_s5

    del my_book_ids[:]
    header_s1 = None
    header_s2 = None
    header_s3 = None
    header_s4 = None
    header_s5 = None

#-----------------------------------------------------------------
#-----------------------------------------------------------------
def JS_Control(my_db,my_cursor,log,notifications):

    global my_book_ids

    log("JS: Number of books to process: " + str(len(my_book_ids)) )

    mysql = "SELECT * FROM custom_columns"
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()

    if not tmp_rows:
       log('No custom columns exist in the current Calibre Library.')
       return
    if len(tmp_rows) == 0:
       log('No custom columns exist in the current Calibre Library.')
       return

    bad_datatypes_list = []
    bad_datatypes_list.append("composite")
    bad_datatypes_list.append("rating")
    bad_datatypes_list.append("enumeration")

    active_datatypes_list = []

    if prefs['GUI_TOOLS_ADD_NULL_VALUES_COMMENTS'] == unicode("True"):
        active_datatypes_list.append("comments")
    if prefs['GUI_TOOLS_ADD_NULL_VALUES_TEXT'] == unicode("True"):
        active_datatypes_list.append("text")
    if prefs['GUI_TOOLS_ADD_NULL_VALUES_TAGLIKE'] == unicode("True"):
        active_datatypes_list.append("tag-like")
    if prefs['GUI_TOOLS_ADD_NULL_VALUES_SERIES'] == unicode("True"):
        active_datatypes_list.append("series")
    if prefs['GUI_TOOLS_ADD_NULL_VALUES_BOOL'] == unicode("True"):
        active_datatypes_list.append("bool")
    if prefs['GUI_TOOLS_ADD_NULL_VALUES_INT'] == unicode("True"):
        active_datatypes_list.append("int")
    if prefs['GUI_TOOLS_ADD_NULL_VALUES_FLOAT'] == unicode("True"):
        active_datatypes_list.append("float")
    if prefs['GUI_TOOLS_ADD_NULL_VALUES_DATETIME'] == unicode("True"):
        active_datatypes_list.append("datetime")

    if len(active_datatypes_list) == 0:
        log('User did not activate any qualifying Custom Columns for this GUI Tool.  Cancelled.')
        del bad_datatypes_list
        del active_datatypes_list
        return

    labels_to_ignore_set = set([])
    ignore_labels = prefs['GUI_TOOLS_ADD_NULL_VALUES_IGNORE_NAMES']
    if "#" in ignore_labels:
        ignore_labels = ignore_labels + "|"
        s_split = ignore_labels.split("|")
        for label in s_split:
            label = label.strip()
            if "#" in label:
                label = label.replace("#","")
                labels_to_ignore_set.add(label)
        #END FOR

    log("  ")
    log("  ")

    custom_columns_id_dict = {}

    for row in tmp_rows:
        id,label,name,datatype,mark_for_delete,editable,display,is_multiple,normalized = row
        if datatype in bad_datatypes_list:
            continue
        elif label in labels_to_ignore_set:
            log("Custom Column: " + label + "   with datatype:  " + datatype + "     was ignored (user-specified).")
            continue
        elif label.startswith("zotero_"):   #Zotero Metadata Importer (ZMI) plug-in has 26 special custom columns that are all 'comments' in Calibre
            continue
        elif datatype in active_datatypes_list:
            if datatype == "text" and is_multiple == 1:
                datatype = 'tag-like'  # virtual datatype
            data = label,datatype
            custom_columns_id_dict[id] = data
            continue
        else:
            continue
    #END FOR
    del tmp_rows

    log("  ")
    log("  ")
    log("  ")

    process_custom_columns(my_db,my_cursor,log,notifications,custom_columns_id_dict)

    del custom_columns_id_dict
    del bad_datatypes_list
    del active_datatypes_list

#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_custom_columns(my_db,my_cursor,log,notifications,custom_columns_id_dict):

    for id,data in custom_columns_id_dict.iteritems():
        id = str(id)
        label,datatype = data
        if datatype == "int":
            process_int(my_db,my_cursor,log,notifications,id)
        elif datatype == "float":
            process_float(my_db,my_cursor,log,notifications,id)
        elif datatype == "bool":
            process_bool(my_db,my_cursor,log,notifications,id)
        elif datatype == "comments":
            process_comments(my_db,my_cursor,log,notifications,id)
        elif datatype == "text":
            process_text(my_db,my_cursor,log,notifications,id)
        elif datatype == "tag-like":
            process_taglike(my_db,my_cursor,log,notifications,id)
        elif datatype == "datetime":
            process_datetime(my_db,my_cursor,log,notifications,id)
        elif datatype == "series":
            process_series(my_db,my_cursor,log,notifications,id)
        else:
            log("unknown datatype for Custom Column id: " + str(id) + "  " + datatype)
            continue
        log("Custom Column: " + label + " with datatype: " + datatype + "   was successfully processed.")
    #END FOR
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_int(my_db,my_cursor,log,notifications,id):
    mysql = "INSERT INTO custom_column_NN (id,book,value) SELECT NULL,id,? FROM books WHERE id NOT IN (SELECT book FROM custom_column_NN WHERE custom_column_NN.book = books.id);"
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_INT]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating INT Custom Column table id: " + id + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_float(my_db,my_cursor,log,notifications,id):
    mysql = "INSERT INTO custom_column_NN (id,book,value) SELECT NULL,id,? FROM books WHERE id NOT IN (SELECT book FROM custom_column_NN WHERE custom_column_NN.book = books.id);"
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_FLOAT]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating FLOAT Custom Column table id: " + id + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_bool(my_db,my_cursor,log,notifications,id):
    mysql = "INSERT INTO custom_column_NN (id,book,value) SELECT NULL,id,? FROM books WHERE id NOT IN (SELECT book FROM custom_column_NN WHERE custom_column_NN.book = books.id);"
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_BOOL]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating BOOL Custom Column table id: " + id + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_comments(my_db,my_cursor,log,notifications,id):
    mysql = "INSERT INTO custom_column_NN (id,book,value) SELECT NULL,id,? FROM books WHERE id NOT IN (SELECT book FROM custom_column_NN WHERE custom_column_NN.book = books.id);"
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_COMMENTS]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating COMMENTS Custom Column table id: " + id + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_datetime(my_db,my_cursor,log,notifications,id):
    mysql = "INSERT INTO custom_column_NN (id,book,value) SELECT null,id,? FROM books WHERE id NOT IN (SELECT book FROM custom_column_NN WHERE custom_column_NN.book = books.id);"
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_DATETIME]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating DATETIME Custom Column table id: " + id + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_text(my_db,my_cursor,log,notifications,id):

    global my_book_ids

    mysql = "INSERT OR IGNORE INTO custom_column_NN (id,value) VALUES (null,?) "
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_TEXT]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating TEXT Custom Column base table id: " + str(id) + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    tmp_set = set([])
    mysql1 = "SELECT book,book FROM books_custom_column_NN_link"
    mysql1 = mysql1.replace("NN",id)
    my_cursor.execute(mysql1)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        tmp_rows = []
    for row in tmp_rows:
        book,dummy = row
        tmp_set.add(book) #sets very much faster than lists for lookups...
    #END FOR
    del tmp_rows
    del mysql1

    mysql2 = "INSERT OR IGNORE INTO books_custom_column_NN_link (id,book,value)  VALUES (null,?,(SELECT id FROM custom_column_NN WHERE value = ?) ) "
    mysql2 = mysql2.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        for id in my_book_ids:
            book = int(id)
            if not book in tmp_set:
                my_cursor.execute(mysql2,(book,NULL_TEXT))
        #END FOR
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating TEXT Custom Column book-link table id: " + str(id) + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql2
    del tmp_set

#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_taglike(my_db,my_cursor,log,notifications,id):

    global my_book_ids

    mysql = "INSERT OR IGNORE INTO custom_column_NN (id,value) VALUES (null,?) "
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_TAGLIKE]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating TAGLIKE Custom Column base table id: " + str(id) + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql

    tmp_set = set([])
    mysql1 = "SELECT book FROM books_custom_column_NN_link GROUP BY book"
    mysql1 = mysql1.replace("NN",id)
    my_cursor.execute(mysql1)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        tmp_rows = []
    for row in tmp_rows:
        for col in row:
            book = int(col)
            tmp_set.add(book) #sets very much faster than lists for lookups...
            #~ if DEBUG: print("taglike book found: ", str(book))
            break
        #END FOR
    #END FOR
    del tmp_rows
    del mysql1

    mysql2 = "INSERT INTO books_custom_column_NN_link (id,book,value) VALUES (null,?,(SELECT id FROM custom_column_NN WHERE value = ?) ) "
    mysql2 = mysql2.replace("NN",id)
    #~ if DEBUG: print(mysql2)
    try:
        my_cursor.execute("begin")
        for book in my_book_ids:
            book = int(book)
            if not book in tmp_set:
                my_cursor.execute(mysql2,(book,NULL_TAGLIKE))
        #END FOR
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating TAG-LIKE Custom Column book-link table id: " + str(book) + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql2
    del tmp_set
#-----------------------------------------------------------------
#-----------------------------------------------------------------
def process_series(my_db,my_cursor,log,notifications,id):

    global my_book_ids

    mysql = "INSERT OR IGNORE INTO custom_column_NN (id,value) VALUES (null,?) "
    mysql = mysql.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([NULL_TEXT]))
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating SERIES Custom Column base table id: " + str(id) + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    tmp_set = set([])
    mysql1 = "SELECT book,book FROM books_custom_column_NN_link"
    mysql1 = mysql1.replace("NN",id)
    my_cursor.execute(mysql1)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        tmp_rows = []
    for row in tmp_rows:
        book,dummy = row
        tmp_set.add(book) #sets very much faster than lists for lookups...
    #END FOR
    del tmp_rows
    del mysql1

    mysql2 = "INSERT OR IGNORE INTO books_custom_column_NN_link (id,book,value,extra)  VALUES (null,?,(SELECT id FROM custom_column_NN WHERE value = ?),0 ) "
    mysql2 = mysql2.replace("NN",id)
    #~ if DEBUG: print(mysql)
    try:
        my_cursor.execute("begin")
        for id in my_book_ids:
            book = int(id)
            if not book in tmp_set:
                my_cursor.execute(mysql2,(book,NULL_SERIES))
        #END FOR
        my_cursor.execute("commit")
    except Exception as e:
        msg = "Exception in updating SERIES Custom Column book-link table id: " + str(id) + "  " + str(e)
        log(msg)
        try:
            my_cursor.execute("commit")
        except:
            pass

    del mysql2
    del tmp_set
#-----------------------------------------------------------------
#-----------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------------------------------------
#END of job