# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.7"  #Enhancements.

import os,sys,apsw

from PyQt5.Qt import (Qt, QDialog, QLabel,  QFont, QApplication, QLineEdit, QComboBox, QUrl,
                                       QSize, QVBoxLayout, QHBoxLayout, QGroupBox, QPushButton, QPixmap, QImage,
                                       QRadioButton, QButtonGroup, QCheckBox, QFrame, QInputDialog, QTimer)
from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG
from calibre.gui2 import gprefs, error_dialog

from calibre_plugins.entities_manager.common_utils import get_icon
from calibre_plugins.entities_manager.ui import PLUGIN_ICONS, ASSOCIATION_ENTITY_TYPE

AVAILABLE = "available"
EXISTING = "existing"
ASSOCIATED = "associated"
UNASSOCIATED = "unassociated"
ORPHANED = "orphaned"
ENTITY = "entity"
MEMBER = "member"
TARGET = "target"

REFLECT_CREATE_ENTITY = "create_entity"
REFLECT_ASSOCIATE_ENTITIES = "associate_entities"
REFLECT_UNASSOCIATE_FROM_SINGLE = "unasssociate_from_single"
REFLECT_UNASSOCIATE_FROM_ALL_OTHERS = "unasssociate_from_all_others"
REFLECT_DELETE_ENTITY = "delete_entity"
REFLECT_DELETE_ENTITIES = "delete_entities"

ADD_NEW_VALUE = "➕"

#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(0, 0)

    def __init__(self, parent, unique_pref_value):
        QDialog.__init__(self, parent)
        self.unique_pref_value = unique_pref_value
        self.geom = gprefs.get(unique_pref_value, None)
        self.finished.connect(self.dialog_closing)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def dialog_closing(self, result=None):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_value] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class EntitiesManagerDialog(SizePersistedDialog):

    def __init__(self, parent, icon, guidb, plugin_path,list_all_entities_all_info,user_types_list):
        self.parent = parent
        self.guidb = guidb
        self.plugin_path = plugin_path
        self.list_all_entities_all_info = list_all_entities_all_info
        self.user_types_list = user_types_list
        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()
        del get_gui
        #--------------------------------------------------
        self.library_path = self.guidb.library_path
        is_valid = self.apsw_connect_to_library()
        if not is_valid:
            if DEBUG: print("Entities Manager: Fatal Error - apsw_connect_to_library failed.  Try Again.")
            self.exit()
        #--------------------------------------------------
        self.create_tables()
        #--------------------------------------------------
        unique_pref_value = 'Manage_Entities:manage_entities_dialog'
        SizePersistedDialog.__init__(self, self.parent, unique_pref_value)
        #--------------------------------------------------
        self.setWindowIcon(icon)
        mytitle = 'Entities Manager'
        self.setWindowTitle(mytitle)
        self.setWindowFlags( Qt.Window | Qt.WindowTitleHint | Qt.WindowSystemMenuHint | Qt.WindowMinMaxButtonsHint)              # http://doc.qt.io/qt-5/qt.html#WindowType-enum
        #--------------------------------------------------
        self.get_icons()
        #--------------------------------------------------
        t = "<p style='white-space:wrap'>"
        t = t + "• <b>What is an 'Entity'?</b>&nbsp;&nbsp;An Entity is the name of a Calibre Standard or Custom Column plus a value of that Column.  The name is its 'Entity Type'. "
        t = t + "<br>• <b>Which Standard Columns are valid Entity 'Types'</b>?&nbsp;&nbsp;Authors, Series, Publisher, Tags and Title."
        t = t + "<br>• <b>Which Custom Columns are valid Entity 'Types'</b>?&nbsp;&nbsp;Any textual (except for composite/built-from-others) Custom Column. "
        t = t + "<br>• <b>Which Column values are valid Entity 'Values'</b>?&nbsp;&nbsp;Any existing value is valid and may be used to create a new Entity."
        t = t + "<br>• <b>What is an example of an Entity?</b>&nbsp;&nbsp;Example:  Type = 'Author' and Value = 'Charles Darwin'."
        t = t + "<br>• <b>What is a 'User Defined' Entity Type</b>?&nbsp;&nbsp;A pseudo-Column that exists only in EM, and for which the Entity Values must be manually entered."
        t = t + "<br>• <b>What is an example of a 'User Defined' Entity Type</b>?&nbsp;&nbsp;Examples:  ~Pseudonym; ~FutureBooks; ~Association."
        t = t + "<br>• <b>What is an Entity 'Link'?</b>&nbsp;&nbsp;A Link is an URL or file-path with an appropriate Name, and which can be 'executed' by opening the Link. "
        t = t + "<br>• <b>How many Links may a single Entity have?</b>&nbsp;&nbsp;Unlimited, but each Link must have a Name."
        t = t + "<br>• <b>What is an Entity 'Note'?</b>&nbsp;&nbsp;A Note is text with an appropriate Name, and which can be 'displayed'. "
        t = t + "<br>• <b>How many Notes may a single Entity have?</b>&nbsp;&nbsp;Unlimited, but each Note must have a Name."
        t = t + "<br>• <b>What is an Entity 'Association'?</b>&nbsp;&nbsp;An Entity may be easily attached to/linked with/associated with any other Entity."
        t = t + "<br>• <b>How many Associations may a single Entity have?</b>&nbsp;&nbsp;Unlimited."
        t = t + "<br>• <b>What are some examples of an Entity Association?</b>\
        <br>&nbsp;&nbsp;&nbsp;&nbsp;--Example:<i> Entity 'Author' & 'Larry Niven' might have associated Tags of 'Fiction:Science-Classic',  \
        'Award:Nebula', 'Award:Hugo', 'Award:Locus', 'Award:Ditmar', and 'Award:Damon Knight Memorial Grand Master', \
        plus several associated Series of 'Ringworld', 'Man-Kzin Wars', 'Known Space', and 'The Mote in God's Eye'.</i> \
        <br>&nbsp;&nbsp;&nbsp;&nbsp;--Example:<i> Entity 'Series' & 'Man-Kzin Wars' might have an associated Tag of 'Fiction:Science-Classic' and be associated to Entities \
        'Author' & 'Larry Niven', 'Author' & 'Poul Anderson', 'Author' & 'Dean Ing', 'Author' & 'Greg Bear', and others.</i>"
        t = t + "<br>• <b>What can be done with an Entity Association?</b>&nbsp;&nbsp;Entities may be easily listed together with all of their Associations, Links, and Notes.\
        Listings may be searched or displayed, or copied to the clipboard and pasted into a text document for other uses."
        t = t + "<br>• <b>What is '~Association'?</b>&nbsp;&nbsp;Created by EM, '~Association' is the Entity Type used to create a new Entity that has an Entity Value of the Association Entities' Types and Values."
        t = t + "  Example:  ~Association & (Author & Larry Niven ⇄ Tag & Fiction:Science-Classic) which may have Links and Notes, and may itself be Associated."
        t = t + "<br>• <b>Is there an Association 'Hierarchy'?</b>&nbsp;&nbsp;There can be, including a 'circular' one, if you create your Associations in that way. \
        An Association is always 'from' Entity A 'to' Entity B, \
        but Entity A could also point 'to' Entity C and Entity D.  Entity D could point back to Entity B.  It is up to you. The 'hierarchy' is fluid and flexible, and the 'from' can be easily swapped (inverted) with the 'to' in any Association."
        t = t + "<br>"
        self.t = t
        self.setToolTip(self.t)
        #--------------------------------------------------
        minwidth = 200
        maxwidth = 200
        #--------------------------------------------------
        self.font = QFont()
        self.font.setBold(False)
        self.font.setPointSize(8)
        #--------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.setLayout(self.layout_top)
        #--------------------------------------------------
        self.entities_groupbox = QGroupBox('Entity')
        self.entities_groupbox.setMinimumWidth(minwidth * 4)
        self.entities_groupbox.setMaximumWidth(maxwidth * 4)
        self.entities_groupbox.setToolTip("<p style='white-space:wrap'>Manage Entities.<br><br>For complete ToolTips, hover mouse over the edges of this window.")
        self.layout_top.addWidget(self.entities_groupbox)
        #--------------------------------------------------
        self.vlayout_entities_groupbox = QVBoxLayout()
        self.vlayout_entities_groupbox.setAlignment(Qt.AlignLeft)
        self.entities_groupbox.setLayout(self.vlayout_entities_groupbox)
        #--------------------------------------------------
        self.hlayout_entity_mode = QHBoxLayout()
        self.hlayout_entity_mode.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_entities_groupbox.addLayout(self.hlayout_entity_mode)
        #--------------------------------------------------
        t = "<p style='white-space:wrap'>Specify the 'Scope' of the Types and Values to be selected for the drop-downs just below."
        t = t + "<br><br>•<b>Available:</b>&nbsp;&nbsp;All Types and Values that exist in the current Library."
        t = t + "<br><br>•<b>Existing:</b>&nbsp;&nbsp;Only Type and Value combinations that have already been created as an Entity.     "
        t = t + "<br><br>•<b>Associated:</b>&nbsp;&nbsp;Same as Existing plus have at least one Association."
        t = t + "<br><br>•<b>Unassociated:</b>&nbsp;&nbsp;Same as Existing but have no Associations at all.     "
        t = t + "<br><br>•<b>Orphaned:</b>&nbsp;&nbsp;Same as Existing, but the original Value no longer exists in Calibre.  Example: a Tag Entity was deleted, but the Entity still exists with (possibly) Links and Notes and Associations."

        self.view_available_radio = QRadioButton('Available?')
        self.view_available_radio.setFont(self.font)
        self.view_available_radio.setToolTip(t)
        self.hlayout_entity_mode.addWidget(self.view_available_radio)
        self.view_existing_radio = QRadioButton('Existing?')
        self.view_existing_radio.setFont(self.font)
        self.view_existing_radio.setToolTip(t)
        self.hlayout_entity_mode.addWidget(self.view_existing_radio)
        self.view_associated_radio = QRadioButton('Associated?')
        self.view_associated_radio.setFont(self.font)
        self.view_associated_radio.setToolTip(t)
        self.hlayout_entity_mode.addWidget(self.view_associated_radio)
        self.view_unassociated_radio = QRadioButton('Unassociated?')
        self.view_unassociated_radio.setFont(self.font)
        self.view_unassociated_radio.setToolTip(t)
        self.hlayout_entity_mode.addWidget(self.view_unassociated_radio)
        self.view_orphaned_radio = QRadioButton('Orphaned?')
        self.view_orphaned_radio.setFont(self.font)
        self.view_orphaned_radio.setToolTip(t)
        self.hlayout_entity_mode.addWidget(self.view_orphaned_radio)

        self.view_button_group = QButtonGroup(self.hlayout_entity_mode)
        self.view_button_group.setExclusive(True)

        self.view_button_group.addButton(self.view_available_radio)
        self.view_button_group.addButton(self.view_existing_radio)
        self.view_button_group.addButton(self.view_associated_radio)
        self.view_button_group.addButton(self.view_unassociated_radio)
        self.view_button_group.addButton(self.view_orphaned_radio)

        self.view_available_radio.setChecked(True)

        self.view_available_radio.clicked.connect(self.view_available_entities)
        self.view_existing_radio.clicked.connect(self.view_existing_entities)
        self.view_associated_radio.clicked.connect(self.view_associated_entities)
        self.view_unassociated_radio.clicked.connect(self.view_unassociated_entities)
        self.view_orphaned_radio.clicked.connect(self.view_orphaned_entities)
        #--------------------------------------------------
        self.hlayout_entity_mode.addStretch(1)

        t = "<p style='white-space:wrap'>Additionally filter the selected 'Scope' of the Types and Values to be selected for the drop-downs below by also requiring any selected Entities to also have at least one Link and/or Note."

        self.select_only_if_links_checkbox = QCheckBox("Only if Links?")
        self.select_only_if_links_checkbox.setFont(self.font)
        self.select_only_if_links_checkbox.setToolTip(t)
        self.hlayout_entity_mode.addWidget(self.select_only_if_links_checkbox)

        self.select_only_if_links_checkbox.setChecked(False)

        self.select_only_if_links_checkbox.toggled.connect(self.event_links_checkbox_toggled)

        self.select_only_if_notes_checkbox = QCheckBox("Only if Notes?")
        self.select_only_if_notes_checkbox.setFont(self.font)
        self.select_only_if_notes_checkbox.setToolTip(t)
        self.hlayout_entity_mode.addWidget(self.select_only_if_notes_checkbox)

        self.select_only_if_notes_checkbox.setChecked(False)

        self.select_only_if_notes_checkbox.toggled.connect(self.event_notes_checkbox_toggled)

        self.quick_pick_entity_pushbutton = QPushButton(self.entity_icon,"QP",self)
        self.quick_pick_entity_pushbutton.setFont(self.font)
        self.quick_pick_entity_pushbutton.setMaximumWidth(50)
        self.quick_pick_entity_pushbutton.setDefault(False)
        self.quick_pick_entity_pushbutton.setToolTip("<p style='white-space:wrap'>'Quick Pick' the Entity selected from the current Library View cursor column and row.")
        self.quick_pick_entity_pushbutton.clicked.connect(self.quick_pick_entity)
        self.hlayout_entity_mode.addWidget(self.quick_pick_entity_pushbutton)

        #--------------------------------------------------
        self.line_1 = QFrame()
        self.line_1.setFrameShape(QFrame.HLine);
        self.line_1.setFrameShadow(QFrame.Sunken);
        self.vlayout_entities_groupbox.addWidget(self.line_1);
        #--------------------------------------------------
        self.hlayout_entity_types = QHBoxLayout()
        self.hlayout_entity_types.setAlignment(Qt.AlignCenter)
        #--------------------------------------------------
        self.vlayout_entities_groupbox.addLayout(self.hlayout_entity_types)
        #--------------------------------------------------
        self.font.setPointSize(11)

        self.entity_pixmap_label = QLabel("")
        self.entity_pixmap_label.setPixmap(self.entity_pixmap)
        self.entity_pixmap_label.setMinimumWidth(20)
        self.entity_pixmap_label.setMaximumWidth(20)
        self.entity_pixmap_label.setAlignment(Qt.AlignCenter)
        self.entity_pixmap_label.setFont(self.font)
        self.hlayout_entity_types.addWidget(self.entity_pixmap_label)

        self.entity_type_label = QLabel("<b>Type:</b>&nbsp;&nbsp;")
        self.entity_type_label.setAlignment(Qt.AlignRight)
        self.entity_type_label.setFont(self.font)
        self.hlayout_entity_types.addWidget(self.entity_type_label)

        self.entity_type_combobox = QComboBox()
        self.entity_type_combobox.setEditable(False)
        self.entity_type_combobox.setFrame(True)
        self.entity_type_combobox.setDuplicatesEnabled(False)
        self.entity_type_combobox.setMaxVisibleItems(25)
        self.entity_type_combobox.setMinimumWidth(minwidth)
        self.entity_type_combobox.setMaximumWidth(maxwidth)
        self.entity_type_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.entity_type_combobox.setFont(self.font)
        self.entity_type_combobox.setToolTip("<p style='white-space:wrap'>Select Type to be used to select a Value for an Entity.")
        self.hlayout_entity_types.addWidget(self.entity_type_combobox)

        self.entity_type_existing_list = []
        self.entity_type_associated_list = []
        self.entity_type_unassociated_list = []
        self.entity_type_orphaned_list = []

        self.get_available_entity_types()

        self.entity_type_desc_label = QLabel("")
        self.entity_type_desc_label.setAlignment(Qt.AlignLeft)
        self.entity_type_desc_label.setFont(self.font)
        self.entity_type_desc_label.setMinimumWidth(minwidth * 3)
        self.hlayout_entity_types.addWidget(self.entity_type_desc_label)

        self.current_entity_type = None
        self.entity_type_combobox.currentIndexChanged.connect(self.event_entity_type_changed)
        #--------------------------------------------------
        self.hlayout_values = QHBoxLayout()
        self.hlayout_values.setAlignment(Qt.AlignLeft)
        self.vlayout_entities_groupbox.addLayout(self.hlayout_values)

        self.entity_label = QLabel("<b>Value:</b>&nbsp;")
        self.entity_label.setAlignment(Qt.AlignRight)
        self.entity_label.setFont(self.font)
        self.hlayout_values.addWidget(self.entity_label)

        self.entity_value_combobox = QComboBox()
        self.entity_value_combobox.setEditable(False)
        self.entity_value_combobox.setFrame(True)
        self.entity_value_combobox.setDuplicatesEnabled(False)
        self.entity_value_combobox.setMaxVisibleItems(25)
        self.entity_value_combobox.setMinimumWidth(minwidth * 3.5)
        self.entity_value_combobox.setMaximumWidth(maxwidth * 3.5)
        self.entity_value_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.entity_value_combobox.setFont(self.font)
        self.entity_value_combobox.setToolTip("<p style='white-space:wrap'>Select the Value for the previously selected Type, both of which together define an Entity.")
        self.hlayout_values.addWidget(self.entity_value_combobox)

        self.current_entity_value = None
        self.entity_value_combobox.currentIndexChanged.connect(self.event_entity_value_changed)
        #--------------------------------------------------
        #--------------------------------------------------
        self.font.setPointSize(8)

        self.entity_id_label = QLabel("")
        self.entity_id_label.setAlignment(Qt.AlignCenter)
        self.entity_id_label.setFont(self.font)
        self.vlayout_entities_groupbox.addWidget(self.entity_id_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.hlayout_creation_1 = QHBoxLayout()
        self.hlayout_creation_1.setAlignment(Qt.AlignCenter)
        self.vlayout_entities_groupbox.addLayout(self.hlayout_creation_1)

        self.font.setPointSize(8)

        self.create_entity_pushbutton = QPushButton(self.create_icon,"Create Entity",self)
        self.create_entity_pushbutton.setFont(self.font)
        self.create_entity_pushbutton.setMinimumWidth(minwidth - 25)
        self.create_entity_pushbutton.setToolTip("<p style='white-space:wrap'>Create a new Entity (if it does not already exist) using the current Type and Value.")
        self.create_entity_pushbutton.clicked.connect(self.create_entity)
        self.hlayout_creation_1.addWidget(self.create_entity_pushbutton)

        self.manage_associations_pushbutton = QPushButton(self.association_icon,"Hide/Show 'Manage Associations'",self)
        self.manage_associations_pushbutton.setFont(self.font)
        self.manage_associations_pushbutton.setMinimumWidth(minwidth - 25)
        self.manage_associations_pushbutton.setToolTip("<p style='white-space:wrap'>The 'Manage Associations' section will be hidden or shown.")
        self.manage_associations_pushbutton.clicked.connect(self.manage_associations)
        self.hlayout_creation_1.addWidget(self.manage_associations_pushbutton)

        self.unassociate_first_entity_pushbutton = QPushButton(self.delete_all_associations_icon,"Unassociate from All Entities",self)
        self.unassociate_first_entity_pushbutton.setFont(self.font)
        self.unassociate_first_entity_pushbutton.setMinimumWidth(minwidth - 25)
        self.unassociate_first_entity_pushbutton.setToolTip("<p style='white-space:wrap'>Delete any Associations that the current Entity may have.")
        self.unassociate_first_entity_pushbutton.clicked.connect(self.unassociate_first_entity_from_all_entities)
        self.hlayout_creation_1.addWidget(self.unassociate_first_entity_pushbutton)

        self.delete_entity_pushbutton = QPushButton(self.delete_icon,"Delete Entity",self)
        self.delete_entity_pushbutton.setFont(self.font)
        self.delete_entity_pushbutton.setMinimumWidth(minwidth - 25)
        self.delete_entity_pushbutton.setToolTip("<p style='white-space:wrap'>Delete the current Entity, along with its Links, Notes and Associations.")
        self.delete_entity_pushbutton.clicked.connect(self.delete_entity)
        self.hlayout_creation_1.addWidget(self.delete_entity_pushbutton)
        #--------------------------------------------------
        #--------------------------------------------------
        self.font.setPointSize(11)
       #--------------------------------------------------
        self.line_5 = QFrame()
        self.line_5.setFrameShape(QFrame.HLine);
        self.line_5.setFrameShadow(QFrame.Sunken);
        self.vlayout_entities_groupbox.addWidget(self.line_5);
       #--------------------------------------------------
        self.hlayout_links_notes = QHBoxLayout()
        self.hlayout_links_notes.setAlignment(Qt.AlignCenter)
        self.vlayout_entities_groupbox.addLayout(self.hlayout_links_notes)
        #--------------------------------------------------
        self.links_label = QLabel("")
        self.links_label.setPixmap(self.link_pixmap)
        self.links_label.setMinimumWidth(20)
        self.links_label.setMaximumWidth(20)
        self.links_label.setAlignment(Qt.AlignCenter)
        self.links_label.setFont(self.font)
        self.hlayout_links_notes.addWidget(self.links_label)

        self.entity_links_combobox = QComboBox()
        self.entity_links_combobox.setEditable(False)
        self.entity_links_combobox.setFrame(True)
        self.entity_links_combobox.setDuplicatesEnabled(False)
        self.entity_links_combobox.setMaxVisibleItems(25)
        self.entity_links_combobox.setMinimumWidth(minwidth * 1.5  )
        self.entity_links_combobox.setMaximumWidth(maxwidth * 1.5 )
        self.entity_links_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.entity_links_combobox.setFont(self.font)
        self.entity_links_combobox.setToolTip("<p style='white-space:wrap'>Select a Link Name for the current Entity.")
        self.hlayout_links_notes.addWidget(self.entity_links_combobox)

        self.current_entity_link = None
        self.entity_links_combobox.currentIndexChanged.connect(self.event_entity_link_changed)

        self.notes_label = QLabel("")
        self.notes_label.setPixmap(self.note_pixmap)
        self.notes_label.setMinimumWidth(20)
        self.notes_label.setMaximumWidth(20)
        self.notes_label.setAlignment(Qt.AlignCenter)
        self.notes_label.setFont(self.font)
        self.hlayout_links_notes.addWidget(self.notes_label)

        self.entity_notes_combobox = QComboBox()
        self.entity_notes_combobox.setEditable(False)
        self.entity_notes_combobox.setFrame(True)
        self.entity_notes_combobox.setDuplicatesEnabled(False)
        self.entity_notes_combobox.setMaxVisibleItems(25)
        self.entity_notes_combobox.setMinimumWidth(minwidth * 1.5 )
        self.entity_notes_combobox.setMaximumWidth(maxwidth * 1.5 )
        self.entity_notes_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.entity_notes_combobox.setFont(self.font)
        self.entity_notes_combobox.setToolTip("<p style='white-space:wrap'>Select a Note Name for the current Entity.")
        self.hlayout_links_notes.addWidget(self.entity_notes_combobox)

        self.current_entity_note = None
        self.entity_notes_combobox.currentIndexChanged.connect(self.event_entity_note_changed)

        self.font.setPointSize(8)
        #--------------------------------------------------
        self.hlayout_manage_links_notes = QHBoxLayout()
        self.hlayout_manage_links_notes.setAlignment(Qt.AlignCenter)
        self.vlayout_entities_groupbox.addLayout(self.hlayout_manage_links_notes)

        self.spacer_3_label = QLabel("<i></i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;")
        self.spacer_3_label.setAlignment(Qt.AlignCenter)
        self.spacer_3_label.setFont(self.font)
        self.spacer_3_label.setMinimumWidth(70)
        self.hlayout_manage_links_notes.addWidget(self.spacer_3_label)

        self.font.setPointSize(7)
        self.execute_link_pushbutton = QPushButton(self.open_icon,"Execute",self)
        self.execute_link_pushbutton.setFont(self.font)
        self.execute_link_pushbutton.setMinimumWidth(75)
        self.execute_link_pushbutton.setMaximumWidth(75)
        self.execute_link_pushbutton.setToolTip("<p style='white-space:wrap'>Open the URL or file-path using your OS' default application for the current Link.")
        self.execute_link_pushbutton.clicked.connect(self.execute_link)
        self.hlayout_manage_links_notes.addWidget(self.execute_link_pushbutton)
        self.font.setPointSize(8)

        self.manage_links_pushbutton = QPushButton(self.link_icon,"Hide/Show 'Manage Link'",self)
        self.manage_links_pushbutton.setFont(self.font)
        self.manage_links_pushbutton.setMinimumWidth(minwidth)
        self.manage_links_pushbutton.setToolTip("<p style='white-space:wrap'>The 'Manage Link' section will be hidden or shown..")
        self.manage_links_pushbutton.clicked.connect(self.manage_links)
        self.hlayout_manage_links_notes.addWidget(self.manage_links_pushbutton)

        self.spacer_3a_label = QLabel("<i></i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;")
        self.spacer_3a_label.setAlignment(Qt.AlignCenter)
        self.spacer_3a_label.setFont(self.font)
        self.spacer_3a_label.setMinimumWidth(105)
        self.spacer_3a_label.setMaximumWidth(105)
        self.hlayout_manage_links_notes.addWidget(self.spacer_3a_label)

        self.font.setPointSize(7)
        self.display_note_pushbutton = QPushButton(self.open_icon,"Display",self)
        self.display_note_pushbutton.setFont(self.font)
        self.display_note_pushbutton.setMinimumWidth(75)
        self.display_note_pushbutton.setMaximumWidth(75)
        self.display_note_pushbutton.setToolTip("<p style='white-space:wrap'>Open the current Note using the EM 'Note Viewer'.")
        self.display_note_pushbutton.clicked.connect(self.display_note)
        self.hlayout_manage_links_notes.addWidget(self.display_note_pushbutton)
        self.font.setPointSize(8)

        self.manage_notes_pushbutton = QPushButton(self.note_icon,"Hide/Show 'Manage Note'",self)
        self.manage_notes_pushbutton.setFont(self.font)
        self.manage_notes_pushbutton.setMinimumWidth(minwidth)
        self.manage_notes_pushbutton.setToolTip("<p style='white-space:wrap'>The 'Manage Note' section will be hidden or shown.")
        self.manage_notes_pushbutton.clicked.connect(self.manage_notes)
        self.hlayout_manage_links_notes.addWidget(self.manage_notes_pushbutton)

        self.font.setPointSize(11)
        #--------------------------------------------------
        #--------------------------------------------------
        #--------------------------------------------------
        #--------------------------------------------------
        self.manage_links_groupbox = QGroupBox('Manage Link')
        self.manage_links_groupbox.setMinimumWidth(minwidth * 4)
        self.manage_links_groupbox.setMaximumWidth(maxwidth * 4)
        self.manage_links_groupbox.setToolTip("<p style='white-space:wrap'>Manage Links.<br><br>For complete ToolTips, hover mouse over the edges of this window.")
        self.layout_top.addWidget(self.manage_links_groupbox)
        #--------------------------------------------------
        self.vlayout_manage_links_groupbox = QVBoxLayout()
        self.vlayout_manage_links_groupbox.setAlignment(Qt.AlignLeft)
        self.manage_links_groupbox.setLayout(self.vlayout_manage_links_groupbox)
        #--------------------------------------------------
        self.hlayout_manage_links_1 = QHBoxLayout()
        self.hlayout_manage_links_1.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_manage_links_groupbox.addLayout(self.hlayout_manage_links_1)
        #--------------------------------------------------
        self.link_pixmap_label = QLabel("")
        self.link_pixmap_label.setPixmap(self.link_pixmap)
        self.link_pixmap_label.setMinimumWidth(20)
        self.link_pixmap_label.setMaximumWidth(20)
        self.link_pixmap_label.setAlignment(Qt.AlignCenter)
        self.link_pixmap_label.setFont(self.font)
        self.hlayout_manage_links_1.addWidget(self.link_pixmap_label)

        self.manage_link_name_label = QLabel("<b>Name:</b>&nbsp;")
        self.manage_link_name_label.setAlignment(Qt.AlignRight)
        self.manage_link_name_label.setFont(self.font)
        self.manage_link_name_label.setMinimumWidth(minwidth * 0.25)
        self.manage_link_name_label.setMaximumWidth(maxwidth * 0.25)
        self.hlayout_manage_links_1.addWidget(self.manage_link_name_label)

        self.manage_link_name_qlineedit = QLineEdit(self)
        self.manage_link_name_qlineedit.setText("")
        self.manage_link_name_qlineedit.setFont(self.font)
        self.manage_link_name_qlineedit.setToolTip("<p style='white-space:wrap'>Name of the current Link.")
        self.manage_link_name_qlineedit.setCursorPosition(0)
        self.manage_link_name_qlineedit.setMinimumWidth(minwidth)
        self.manage_link_name_qlineedit.setMaximumWidth(maxwidth)
        self.hlayout_manage_links_1.addWidget(self.manage_link_name_qlineedit)

        self.manage_link_value_label = QLabel("<b>Value:</b>&nbsp;")
        self.manage_link_value_label.setAlignment(Qt.AlignRight)
        self.manage_link_value_label.setFont(self.font)
        self.manage_link_value_label.setMinimumWidth(minwidth * 0.25)
        self.manage_link_value_label.setMaximumWidth(maxwidth * 0.25)
        self.hlayout_manage_links_1.addWidget(self.manage_link_value_label)

        self.manage_link_value_qlineedit = QLineEdit(self)
        self.manage_link_value_qlineedit.setText("")
        self.manage_link_value_qlineedit.setFont(self.font)
        self.manage_link_value_qlineedit.setToolTip("<p style='white-space:wrap'>Link value of the current named Link.")
        self.manage_link_value_qlineedit.setCursorPosition(0)
        self.manage_link_value_qlineedit.setMinimumWidth(minwidth * 2)
        self.manage_link_value_qlineedit.setMaximumWidth(maxwidth * 2)
        self.hlayout_manage_links_1.addWidget(self.manage_link_value_qlineedit)
        #--------------------------------------------------
        self.hlayout_manage_links_2 = QHBoxLayout()
        self.hlayout_manage_links_2.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_manage_links_groupbox.addLayout(self.hlayout_manage_links_2)
        #--------------------------------------------------
        self.font.setPointSize(8)

        self.clear_links_pushbutton = QPushButton(self.clear_input_icon,"Clear Link",self)
        self.clear_links_pushbutton.setFont(self.font)
        self.clear_links_pushbutton.setMaximumWidth(maxwidth)
        self.clear_links_pushbutton.setToolTip("<p style='white-space:wrap'>Set the current named link to blank text.")
        self.clear_links_pushbutton.clicked.connect(self.clear_link)
        self.hlayout_manage_links_2.addWidget(self.clear_links_pushbutton)

        self.refresh_links_pushbutton = QPushButton(self.refresh_icon,"Refresh Link",self)
        self.refresh_links_pushbutton.setFont(self.font)
        self.refresh_links_pushbutton.setMaximumWidth(maxwidth)
        self.refresh_links_pushbutton.setToolTip("<p style='white-space:wrap'>Reload the current named Link from the database, restoring it.")
        self.refresh_links_pushbutton.clicked.connect(self.refresh_link)
        self.hlayout_manage_links_2.addWidget(self.refresh_links_pushbutton)

        self.add_links_pushbutton = QPushButton(self.add_link_icon,"Add Link",self)
        self.add_links_pushbutton.setFont(self.font)
        self.add_links_pushbutton.setMaximumWidth(maxwidth)
        self.add_links_pushbutton.setToolTip("<p style='white-space:wrap'>Add a new named Link using the current Link name and Link value.")
        self.add_links_pushbutton.clicked.connect(self.add_link)
        self.hlayout_manage_links_2.addWidget(self.add_links_pushbutton)

        self.change_links_pushbutton = QPushButton(self.change_icon,"Change Link",self)
        self.change_links_pushbutton.setFont(self.font)
        self.change_links_pushbutton.setMaximumWidth(maxwidth)
        self.change_links_pushbutton.setToolTip("<p style='white-space:wrap'>Change the Link value for the current named Link.")
        self.change_links_pushbutton.clicked.connect(self.change_link)
        self.hlayout_manage_links_2.addWidget(self.change_links_pushbutton)

        self.copy_links_pushbutton = QPushButton(self.copy_link_icon,"Copy Link",self)
        self.copy_links_pushbutton.setFont(self.font)
        self.copy_links_pushbutton.setMaximumWidth(maxwidth)
        self.copy_links_pushbutton.setToolTip("<p style='white-space:wrap'>Copy the current named Link to another Entity.")
        self.copy_links_pushbutton.clicked.connect(self.copy_link)
        self.hlayout_manage_links_2.addWidget(self.copy_links_pushbutton)

        self.delete_links_pushbutton = QPushButton(self.delete_icon,"Delete Link",self)
        self.delete_links_pushbutton.setFont(self.font)
        self.delete_links_pushbutton.setMaximumWidth(maxwidth)
        self.delete_links_pushbutton.setToolTip("<p style='white-space:wrap'>Delete the current named Link from the current Entity.")
        self.delete_links_pushbutton.clicked.connect(self.delete_link)
        self.hlayout_manage_links_2.addWidget(self.delete_links_pushbutton)

        self.font.setPointSize(11)
        #--------------------------------------------------
        #--------------------------------------------------
        #--------------------------------------------------
        #--------------------------------------------------
        self.manage_notes_groupbox = QGroupBox('Manage Note')
        self.manage_notes_groupbox.setMinimumWidth(minwidth * 4)
        self.manage_notes_groupbox.setMaximumWidth(maxwidth * 4)
        self.manage_notes_groupbox.setToolTip("<p style='white-space:wrap'>Manage Notes.<br><br>For complete ToolTips, hover mouse over the edges of this window.")
        self.layout_top.addWidget(self.manage_notes_groupbox)
        #--------------------------------------------------
        self.vlayout_manage_notes_groupbox = QVBoxLayout()
        self.vlayout_manage_notes_groupbox.setAlignment(Qt.AlignLeft)
        self.manage_notes_groupbox.setLayout(self.vlayout_manage_notes_groupbox)
        #--------------------------------------------------
        self.hlayout_manage_notes_1 = QHBoxLayout()
        self.hlayout_manage_notes_1.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_manage_notes_groupbox.addLayout(self.hlayout_manage_notes_1)
         #--------------------------------------------------
        self.note_pixmap_label = QLabel("")
        self.note_pixmap_label.setPixmap(self.note_pixmap)
        self.note_pixmap_label.setMinimumWidth(20)
        self.note_pixmap_label.setMaximumWidth(20)
        self.note_pixmap_label.setAlignment(Qt.AlignCenter)
        self.note_pixmap_label.setFont(self.font)
        self.hlayout_manage_notes_1.addWidget(self.note_pixmap_label)

        self.manage_note_name_label = QLabel("<b>Name:</b>&nbsp;")
        self.manage_note_name_label.setAlignment(Qt.AlignRight)
        self.manage_note_name_label.setFont(self.font)
        self.manage_note_name_label.setMinimumWidth(minwidth * 0.25)
        self.manage_note_name_label.setMaximumWidth(maxwidth * 0.25)
        self.hlayout_manage_notes_1.addWidget(self.manage_note_name_label)

        self.manage_note_name_qlineedit = QLineEdit(self)
        self.manage_note_name_qlineedit.setText("")
        self.manage_note_name_qlineedit.setFont(self.font)
        self.manage_note_name_qlineedit.setToolTip("<p style='white-space:wrap'>Name of the current Note.")
        self.manage_note_name_qlineedit.setCursorPosition(0)
        self.manage_note_name_qlineedit.setMinimumWidth(minwidth)
        self.manage_note_name_qlineedit.setMaximumWidth(maxwidth)
        self.hlayout_manage_notes_1.addWidget(self.manage_note_name_qlineedit)
        #--------------------------------------------------
        self.hlayout_manage_notes_2 = QHBoxLayout()
        self.hlayout_manage_notes_2.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_manage_notes_groupbox.addLayout(self.hlayout_manage_notes_2)
        #--------------------------------------------------
        from calibre_plugins.entities_manager.note_editor import  Editor
        self.manage_note_value_editor = Editor(parent=None, one_line_toolbar=True, toolbar_prefs_name=None)
        self.vlayout_manage_notes_groupbox.addWidget(self.manage_note_value_editor)
        del Editor
        self.manage_note_value_editor.html = ""
        self.manage_note_value_editor.setToolTip("<p style='white-space:wrap'>Current text of the current named Note.")
        #--------------------------------------------------
        self.hlayout_manage_notes_3 = QHBoxLayout()
        self.hlayout_manage_notes_3.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_manage_notes_groupbox.addLayout(self.hlayout_manage_notes_3)
        #--------------------------------------------------
        self.font.setPointSize(8)

        self.clear_notes_pushbutton = QPushButton(self.clear_input_icon,"Clear Note",self)
        self.clear_notes_pushbutton.setFont(self.font)
        self.clear_notes_pushbutton.setMaximumWidth(maxwidth)
        self.clear_notes_pushbutton.setToolTip("<p style='white-space:wrap'>Remove all text from the current named Note.")
        self.clear_notes_pushbutton.clicked.connect(self.clear_note)
        self.hlayout_manage_notes_3.addWidget(self.clear_notes_pushbutton)

        self.refresh_notes_pushbutton = QPushButton(self.refresh_icon,"Refresh Note",self)
        self.refresh_notes_pushbutton.setFont(self.font)
        self.refresh_notes_pushbutton.setMaximumWidth(maxwidth)
        self.refresh_notes_pushbutton.setToolTip("<p style='white-space:wrap'>Reload the text of the current named Note from the database to restore it.")
        self.refresh_notes_pushbutton.clicked.connect(self.refresh_note)
        self.hlayout_manage_notes_3.addWidget(self.refresh_notes_pushbutton)

        self.add_notes_pushbutton = QPushButton(self.add_note_icon,"Add Note",self)
        self.add_notes_pushbutton.setFont(self.font)
        self.add_notes_pushbutton.setMaximumWidth(maxwidth)
        self.add_notes_pushbutton.setToolTip("<p style='white-space:wrap'>Add a new named Note.")
        self.add_notes_pushbutton.clicked.connect(self.add_note)
        self.hlayout_manage_notes_3.addWidget(self.add_notes_pushbutton)

        self.change_notes_pushbutton = QPushButton(self.change_icon,"Change Note",self)
        self.change_notes_pushbutton.setFont(self.font)
        self.change_notes_pushbutton.setMaximumWidth(maxwidth)
        self.change_notes_pushbutton.setToolTip("<p style='white-space:wrap'>Change the existing named Note using the current Note text.")
        self.change_notes_pushbutton.clicked.connect(self.change_note)
        self.hlayout_manage_notes_3.addWidget(self.change_notes_pushbutton)

        self.copy_notes_pushbutton = QPushButton(self.copy_note_icon,"Copy Note",self)
        self.copy_notes_pushbutton.setFont(self.font)
        self.copy_notes_pushbutton.setMaximumWidth(maxwidth)
        self.copy_notes_pushbutton.setToolTip("<p style='white-space:wrap'>Copy the current named Note to another Entity.")
        self.copy_notes_pushbutton.clicked.connect(self.copy_note)
        self.hlayout_manage_notes_3.addWidget(self.copy_notes_pushbutton)

        self.delete_notes_pushbutton = QPushButton(self.delete_icon,"Delete Note",self)
        self.delete_notes_pushbutton.setFont(self.font)
        self.delete_notes_pushbutton.setMaximumWidth(maxwidth)
        self.delete_notes_pushbutton.setToolTip("<p style='white-space:wrap'>Delete the current named Note from the current Entity.")
        self.delete_notes_pushbutton.clicked.connect(self.delete_note)
        self.hlayout_manage_notes_3.addWidget(self.delete_notes_pushbutton)

        self.font.setPointSize(11)
        #--------------------------------------------------
        #--------------------------------------------------
        #--------------------------------------------------
        #--------------------------------------------------
        self.associated_groupbox = QGroupBox('Manage Associations')
        self.associated_groupbox.setMinimumWidth(minwidth * 4)
        self.associated_groupbox.setMaximumWidth(maxwidth * 4)
        self.associated_groupbox.setToolTip("<p style='white-space:wrap'>Manage Associations.<br><br>For complete ToolTips, hover mouse over the edges of this window.")
        self.layout_top.addWidget(self.associated_groupbox)
        #--------------------------------------------------
        self.vlayout_associated_groupbox = QVBoxLayout()
        self.vlayout_associated_groupbox.setAlignment(Qt.AlignLeft)
        self.associated_groupbox.setLayout(self.vlayout_associated_groupbox)
        #--------------------------------------------------
        self.hlayout_member_mode = QHBoxLayout()
        self.hlayout_member_mode.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_associated_groupbox.addLayout(self.hlayout_member_mode)
        #--------------------------------------------------
        self.font.setPointSize(8)

        t = "<p style='white-space:wrap'>Specify the 'Scope' of the Types and Values to be selected for the drop-downs just below for the Associated Entity."
        t = t + "<br><br>•<b>Available:</b>&nbsp;&nbsp;All Types and Values that exist in the current Library."
        t = t + "<br><br>•<b>Associated:</b>&nbsp;&nbsp;Entities already exist, and have at least one Association."
        t = t + "<br><br>•<b>Unassociated:</b>&nbsp;&nbsp;Entities already exist, but have no Associations at all.     "

        self.view_available_member_radio = QRadioButton('Available?')
        self.view_available_member_radio.setFont(self.font)
        self.view_available_member_radio.setToolTip(t)
        self.hlayout_member_mode.addWidget(self.view_available_member_radio)
        self.view_associated_member_radio = QRadioButton('Associated?')
        self.view_associated_member_radio.setFont(self.font)
        self.view_associated_member_radio.setToolTip(t)
        self.hlayout_member_mode.addWidget(self.view_associated_member_radio)
        self.view_unassociated_member_radio = QRadioButton('Unassociated?')
        self.view_unassociated_member_radio.setFont(self.font)
        self.view_unassociated_member_radio.setToolTip(t)
        self.hlayout_member_mode.addWidget(self.view_unassociated_member_radio)

        self.view_member_button_group = QButtonGroup(self.hlayout_member_mode)
        self.view_member_button_group.setExclusive(True)

        self.view_member_button_group.addButton(self.view_available_member_radio)
        self.view_member_button_group.addButton(self.view_associated_member_radio)
        self.view_member_button_group.addButton(self.view_unassociated_member_radio)

        self.view_available_member_radio.setChecked(True)

        self.view_available_member_radio.clicked.connect(self.view_available_members)
        self.view_associated_member_radio.clicked.connect(self.view_associated_members)
        self.view_unassociated_member_radio.clicked.connect(self.view_unassociated_members)

        self.hlayout_member_mode.addStretch(1)

        self.quick_pick_member_pushbutton = QPushButton(self.entity_icon,"QP",self)
        self.quick_pick_member_pushbutton.setFont(self.font)
        self.quick_pick_member_pushbutton.setMaximumWidth(50)
        self.quick_pick_member_pushbutton.setDefault(False)
        self.quick_pick_member_pushbutton.setToolTip("<p style='white-space:wrap'>Quick Pick the Associated Entity selected from the current Library View cursor column and row.")
        self.quick_pick_member_pushbutton.clicked.connect(self.quick_pick_member)
        self.hlayout_member_mode.addWidget(self.quick_pick_member_pushbutton)

        #--------------------------------------------------
        self.line_5 = QFrame()
        self.line_5.setFrameShape(QFrame.HLine);
        self.line_5.setFrameShadow(QFrame.Sunken);
        self.vlayout_associated_groupbox.addWidget(self.line_5);
        #--------------------------------------------------
        self.hlayout_associated_1 = QHBoxLayout()
        self.hlayout_associated_1.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_associated_groupbox.addLayout(self.hlayout_associated_1)
        #--------------------------------------------------
        self.font.setPointSize(11)

        self.member_pixmap_label = QLabel("")
        self.member_pixmap_label.setPixmap(self.entity_pixmap)
        self.member_pixmap_label.setMinimumWidth(20)
        self.member_pixmap_label.setMaximumWidth(20)
        self.member_pixmap_label.setAlignment(Qt.AlignCenter)
        self.member_pixmap_label.setFont(self.font)
        self.hlayout_associated_1.addWidget(self.member_pixmap_label)

        self.member_type_label = QLabel("<b>Type:</b>&nbsp;&nbsp;")
        self.member_type_label.setAlignment(Qt.AlignRight)
        self.member_type_label.setFont(self.font)
        self.hlayout_associated_1.addWidget(self.member_type_label)

        self.member_type_combobox = QComboBox()
        self.member_type_combobox.setEditable(False)
        self.member_type_combobox.setFrame(True)
        self.member_type_combobox.setDuplicatesEnabled(False)
        self.member_type_combobox.setMaxVisibleItems(25)
        self.member_type_combobox.setMinimumWidth(minwidth)
        self.member_type_combobox.setMaximumWidth(maxwidth)
        self.member_type_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.member_type_combobox.setFont(self.font)
        self.member_type_combobox.setToolTip("<p style='white-space:wrap'>Select the Entity Type for the Associated Entity.")
        self.hlayout_associated_1.addWidget(self.member_type_combobox)

        self.view_available_members()

        self.member_type_combobox.setCurrentIndex(-1)

        self.member_type_desc_label = QLabel("")
        self.member_type_desc_label.setAlignment(Qt.AlignLeft)
        self.member_type_desc_label.setFont(self.font)
        self.member_type_desc_label.setMinimumWidth(minwidth * 3.5)
        self.hlayout_associated_1.addWidget(self.member_type_desc_label)

        self.current_member_type = None
        self.member_type_combobox.currentIndexChanged.connect(self.event_member_type_changed)
        #--------------------------------------------------
        self.hlayout_associated_2 = QHBoxLayout()
        self.hlayout_associated_2.setAlignment(Qt.AlignLeft)
        #--------------------------------------------------
        self.vlayout_associated_groupbox.addLayout(self.hlayout_associated_2)
        #--------------------------------------------------
        self.member_value_label = QLabel("<b>Value:</b>&nbsp;")
        self.member_value_label.setAlignment(Qt.AlignRight)
        self.member_value_label.setFont(self.font)
        self.hlayout_associated_2.addWidget(self.member_value_label)

        self.member_value_combobox = QComboBox()
        self.member_value_combobox.setEditable(False)
        self.member_value_combobox.setFrame(True)
        self.member_value_combobox.setDuplicatesEnabled(False)
        self.member_value_combobox.setMaxVisibleItems(25)
        self.member_value_combobox.setMinimumWidth(minwidth * 3.5)
        self.member_value_combobox.setMaximumWidth(maxwidth * 3.5)
        self.member_value_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.member_value_combobox.setFont(self.font)
        self.member_value_combobox.setToolTip("<p style='white-space:wrap'>Select the Entity Value for the Associated Entity Type.")
        self.hlayout_associated_2.addWidget(self.member_value_combobox)

        self.current_member_value = None
        self.member_value_combobox.currentIndexChanged.connect(self.event_member_value_changed)
        #--------------------------------------------------
        #--------------------------------------------------
        self.font.setPointSize(8)
        self.member_entity_id_label = QLabel("")
        self.member_entity_id_label.setAlignment(Qt.AlignCenter)
        self.member_entity_id_label.setFont(self.font)
        self.vlayout_associated_groupbox.addWidget(self.member_entity_id_label)
        #--------------------------------------------------
        #--------------------------------------------------
        self.hlayout_associated_3 = QHBoxLayout()
        self.hlayout_associated_3.setAlignment(Qt.AlignCenter)

        self.vlayout_associated_groupbox.addLayout(self.hlayout_associated_3)

        self.font.setPointSize(8)

        self.associate_entities_quick_create_pushbutton = QPushButton(self.create_icon,"QP Create",self)
        self.associate_entities_quick_create_pushbutton.setFont(self.font)
        self.associate_entities_quick_create_pushbutton.setToolTip("'Quick Pick' then Create a new Entity (if it does not already exist).<br><br> 'Quick Pick' means that the Entity is selected from the current Library View cursor column and row.")
        self.associate_entities_quick_create_pushbutton.clicked.connect(self.associate_entities_quick_create)
        self.hlayout_associated_3.addWidget(self.associate_entities_quick_create_pushbutton)

        self.associate_entities_pushbutton = QPushButton(self.create_icon,"Create && Associate with First Entity",self)
        self.associate_entities_pushbutton.setFont(self.font)
        self.associate_entities_pushbutton.setToolTip("Create a new Entity (if it does not already exist) and associate it to the Entity selected at the top.")
        self.associate_entities_pushbutton.clicked.connect(self.associate_entities)
        self.hlayout_associated_3.addWidget(self.associate_entities_pushbutton)

        self.unassociate_from_first_entity_pushbutton = QPushButton(self.delete_association_icon,"Unassociate from First Entity",self)
        self.unassociate_from_first_entity_pushbutton.setFont(self.font)
        self.unassociate_from_first_entity_pushbutton.setToolTip("<p style='white-space:wrap'>Remove any association to the Entity selected at the top.")
        self.unassociate_from_first_entity_pushbutton.clicked.connect(self.unassociate_from_single_entity)
        self.hlayout_associated_3.addWidget(self.unassociate_from_first_entity_pushbutton)

        self.unassociate_member_all_entities_pushbutton = QPushButton(self.delete_all_associations_icon,"Unassociate from All Entities",self)
        self.unassociate_member_all_entities_pushbutton.setFont(self.font)
        self.unassociate_member_all_entities_pushbutton.setToolTip("<p style='white-space:wrap'>Remove all associations with any other Entities.")
        self.unassociate_member_all_entities_pushbutton.clicked.connect(self.unassociate_member_from_all_entities)
        self.hlayout_associated_3.addWidget(self.unassociate_member_all_entities_pushbutton)

        self.delete_member_entity_pushbutton = QPushButton(self.delete_icon,"Delete Entity",self)
        self.delete_member_entity_pushbutton.setFont(self.font)
        self.delete_member_entity_pushbutton.setToolTip("<p style='white-space:wrap'>Delete the Associated Entity specified above.")
        self.delete_member_entity_pushbutton.clicked.connect(self.delete_member_entity)
        self.hlayout_associated_3.addWidget(self.delete_member_entity_pushbutton)
        #--------------------------------------------------
        self.line_6 = QFrame()
        self.line_6.setFrameShape(QFrame.HLine)
        self.line_6.setFrameShadow(QFrame.Sunken)
        self.vlayout_associated_groupbox.addWidget(self.line_6)
        #--------------------------------------------------
        #--------------------------------------------------
        self.hlayout_associated_4 = QHBoxLayout()
        self.hlayout_associated_4.setAlignment(Qt.AlignCenter)

        self.vlayout_associated_groupbox.addLayout(self.hlayout_associated_4)
        #--------------------------------------------------
        self.font.setPointSize(8)
        #--------------------------------------------------
        self.refresh_association_matrix_pushbutton = QPushButton(self.matrix_icon,"Associations:",self)
        self.refresh_association_matrix_pushbutton.setFont(self.font)
        self.refresh_association_matrix_pushbutton.setMinimumWidth(minwidth *.5)
        self.refresh_association_matrix_pushbutton.setToolTip("<p style='white-space:wrap'>Refresh the 'Association Matrix' drop-down to the right.")
        self.refresh_association_matrix_pushbutton.clicked.connect(self.refresh_association_matrix)
        self.hlayout_associated_4.addWidget(self.refresh_association_matrix_pushbutton)

        self.ffont = QFont("Courier")
        self.ffont.setStyleHint(QFont.Courier)
        self.ffont.setFixedPitch(True)
        self.ffont.setWeight(QFont.Normal)
        self.ffont.setPointSize(10)

        self.association_matrix_combobox = QComboBox()
        self.association_matrix_combobox.setFont(self.ffont)
        self.association_matrix_combobox.setEditable(False)
        self.association_matrix_combobox.setFrame(True)
        self.association_matrix_combobox.setDuplicatesEnabled(False)
        self.association_matrix_combobox.setMaxVisibleItems(25)
        self.association_matrix_combobox.setMinimumWidth(minwidth)
        self.association_matrix_combobox.setMaximumWidth(maxwidth)
        self.association_matrix_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.association_matrix_combobox.setToolTip("<p style='white-space:wrap'>All Associations.")
        self.hlayout_associated_4.addWidget(self.association_matrix_combobox)

        self.select_association_matrix_pushbutton = QPushButton(self.select_matrix_item_icon,"Select",self)
        self.select_association_matrix_pushbutton.setFont(self.font)
        self.select_association_matrix_pushbutton.setMinimumWidth(minwidth *.25)
        self.select_association_matrix_pushbutton.setToolTip("<p style='white-space:wrap'>Select and load the current Association shown in the 'Association Matrix' drop-down to the left.")
        self.select_association_matrix_pushbutton.clicked.connect(self.select_association_matrix)
        self.hlayout_associated_4.addWidget(self.select_association_matrix_pushbutton)

        self.invert_association_matrix_pushbutton = QPushButton(self.invert_icon,"Invert",self)
        self.invert_association_matrix_pushbutton.setFont(self.font)
        self.invert_association_matrix_pushbutton.setMinimumWidth(minwidth *.25)
        self.invert_association_matrix_pushbutton.setToolTip("<p style='white-space:wrap'>If Entity A now points to Entity B, use this 'Invert' function to 'swap' the association direction so that Entity B points to Entity A.")
        self.invert_association_matrix_pushbutton.clicked.connect(self.invert_association)
        self.hlayout_associated_4.addWidget(self.invert_association_matrix_pushbutton)

        self.create_association_type_entity_pushbutton = QPushButton(self.add_icon,"Create Association Entity",self)
        self.create_association_type_entity_pushbutton.setFont(self.font)
        self.create_association_type_entity_pushbutton.setMinimumWidth(minwidth *.25)
        self.create_association_type_entity_pushbutton.setToolTip("<p style='white-space:wrap'>Create a unique Entity for the current Association selected to the left.\
        <br><br>This means that the Association of 2 Entities itself becomes a 3d Entity having an Entity Type of '~Association'.")
        self.create_association_type_entity_pushbutton.clicked.connect(self.create_association_type_entity)
        self.hlayout_associated_4.addWidget(self.create_association_type_entity_pushbutton)

        self.font.setPointSize(8)
        #--------------------------------------------------
        #--------------------------------------------------
        self.hlayout_bottom = QHBoxLayout()
        self.hlayout_bottom.setAlignment(Qt.AlignCenter)
        self.layout_top.addLayout(self.hlayout_bottom)

        self.clear_all_input_pushbutton = QPushButton(self.clear_input_icon,"Clear All",self)
        self.clear_all_input_pushbutton.setFont(self.font)
        self.clear_all_input_pushbutton.setToolTip("<p style='white-space:wrap'>Clear all current data.")
        self.clear_all_input_pushbutton.clicked.connect(self.clear_all_input)
        self.hlayout_bottom.addWidget(self.clear_all_input_pushbutton)

        self.entity_browser_pushbutton = QPushButton(self.list_entities_icon,"List Entities, Links, Notes && Associations",self)
        self.entity_browser_pushbutton.setFont(self.font)
        self.entity_browser_pushbutton.setToolTip("<p style='white-space:wrap'>List all Entities with their Links, Notes and Associations.")
        self.entity_browser_pushbutton.clicked.connect(self.list_all_entities_all_info)
        self.hlayout_bottom.addWidget(self.entity_browser_pushbutton)

        self.exit_pushbutton = QPushButton(self.close_icon,"Exit",self)
        self.exit_pushbutton.setFont(self.font)
        self.exit_pushbutton.setToolTip("<p style='white-space:wrap'>Close this window.")
        self.exit_pushbutton.clicked.connect(self.exit)
        self.hlayout_bottom.addWidget(self.exit_pushbutton)

        self.scope = AVAILABLE
        self.block_all_signals = False
        self.block_entity_link_signals = False
        self.block_entity_note_signals = False
        self.current_entity_id = None
        self.current_entity_type = None
        self.current_entity_value = None
        self.current_entity_link_id = None
        self.current_entity_note_id = None
        self.current_member_entity_id = None
        self.current_member_type = None
        self.current_member_value = None
        self.current_links_dict = {}
        self.current_notes_dict = {}
        self.open_url = None
        self.view_available_entities()
        self.resize_dialog()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #~ EVENTS
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_entity_type_changed(self,event):
        if self.block_all_signals:
            return
        self.current_entity_type = self.entity_type_combobox.currentText()
        self.current_entity_value = None
        self.current_entity_id = None
        if self.current_entity_type in self.standard_columns_list:
            if self.current_entity_type == "Author":
                desc = "<b>Name:</b>&nbsp;" + "Author" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "authors"
            elif self.current_entity_type == "Publisher":
                desc = "<b>Name:</b>&nbsp;" + "Publisher" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "publishers"
            elif self.current_entity_type == "Series":
                desc = "<b>Name:</b>&nbsp;" + "Series" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "series"
            elif self.current_entity_type == "Tags":
                desc = "<b>Name:</b>&nbsp;" + "Tags" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "tags"
            elif self.current_entity_type == "Title":
                desc = "<b>Name:</b>&nbsp;" + "Title" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "books"
            else:
                desc = "Error[1]"
        elif self.current_entity_type in self.custom_column_label_list:
            if self.current_entity_type in self.custom_column_label_dict:
                id,label,name,datatype,display,is_multiple,normalized = self.custom_column_label_dict[self.current_entity_type]
                desc = "<b>Name:</b>&nbsp;" + name + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "Custom Column&nbsp;#" + id
            else:
                desc = "Error[2]"
        else:
            desc = "" #when combo index set to -1 whenever link/note checkboxes toggled...
        self.entity_type_desc_label.setText(desc)
        self.block_all_signals = True
        self.get_values_for_type(source=ENTITY)
        self.block_all_signals = False

        self.entity_links_combobox.setCurrentIndex(-1)
        self.manage_link_name_qlineedit.setText("")
        self.manage_link_value_qlineedit.setText("")
        self.entity_notes_combobox.setCurrentIndex(-1)
        self.manage_note_name_qlineedit.setText("")
        self.manage_note_value_editor.html = ""
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_entity_value_changed(self,event):
        if self.block_all_signals:
            return
        self.block_all_signals = True
        #~ -----------------------------------------
        self.current_entity_type = self.entity_type_combobox.currentText()
        self.current_entity_value = self.entity_value_combobox.currentText()
        self.current_entity_id = self.get_entity_id(self.current_entity_type,self.current_entity_value)
        count = self.count_entity_id_associations(self.current_entity_id)
        self.entity_id_label.setText("<i>Entity ID: </i>&nbsp;" + str(self.current_entity_id) + "&nbsp;&nbsp;&nbsp;<i>Associated Entities: </i>&nbsp;" + str(count))
        #~ -----------------------------------------
        if self.current_entity_id is not None:
            self.block_entity_link_signals = True
            self.current_links_dict.clear()
            self.entity_links_combobox.clear()
            links_list = self.get_links_for_entity()
            for row in links_list:
                link_id,name,link = row
                self.entity_links_combobox.addItem(name)
                self.current_links_dict[name] = link_id,link
            #END FOR
            self.entity_links_combobox.model().sort(0)
            self.entity_links_combobox.setCurrentIndex(0)
            self.block_entity_link_signals = False
            self.event_entity_link_changed(None)
            #~ -----------------------------------------
            self.block_entity_note_signals = True
            self.current_notes_dict.clear()
            self.entity_notes_combobox.clear()
            notes_list = self.get_notes_for_entity()
            for row in notes_list:
                note_id,name,note = row
                item = name
                self.entity_notes_combobox.addItem(item)
                self.current_notes_dict[name] = note_id,note
            #END FOR
            self.entity_notes_combobox.model().sort(0)
            self.entity_notes_combobox.setCurrentIndex(0)
            self.block_entity_note_signals = False
            self.event_entity_note_changed(None)
        #~ -----------------------------------------
        self.block_all_signals = False

        if self.current_entity_value == ADD_NEW_VALUE:
            if self.current_entity_type == ASSOCIATION_ENTITY_TYPE:
                self.entity_value_combobox.setCurrentIndex(-1)
                return
            title = "Add New Value for User Defined Entity Type"
            label = "Specify the Value for the new Entity"
            value,ok = QInputDialog.getText(None, title, label)
            if not ok:
                self.entity_value_combobox.setCurrentIndex(-1)
                return
            value = value.strip()
            if value > "  " and value <> ADD_NEW_VALUE:
                self.entity_value_combobox.insertItem(1,value)
                self.entity_value_combobox.setCurrentIndex(1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_member_type_changed(self,event):
        self.current_member_type = self.member_type_combobox.currentText()
        if self.current_member_type in self.standard_columns_list:
            if self.current_member_type == "Author":
                desc = "<b>Name:</b>&nbsp;" + "Author" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "authors"
            elif self.current_member_type == "Publisher":
                desc = "<b>Name:</b>&nbsp;" + "Publisher" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "publishers"
            elif self.current_member_type == "Series":
                desc = "<b>Name:</b>&nbsp;" + "Series" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "series"
            elif self.current_member_type == "Tags":
                desc = "<b>Name:</b>&nbsp;" + "Tags" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "tags"
            elif self.current_member_type == "Title":
                desc = "<b>Name:</b>&nbsp;" + "Title" + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "books"
            else:
                desc = "Error[1]"
        elif self.current_member_type in self.custom_column_label_list:
            if self.current_member_type in self.custom_column_label_dict:
                id,label,name,datatype,display,is_multiple,normalized = self.custom_column_label_dict[self.current_member_type]
                desc = "<b>Name:</b>&nbsp;" + name + "&nbsp;&nbsp;<b>Source:</b>&nbsp;" + "Custom Column&nbsp;#" + id
            else:
                desc = "Error[2]"
        else:
            desc = ""   #when combo index set to -1
        self.member_type_desc_label.setText(desc)
        self.get_values_for_type(source=MEMBER)
        self.member_entity_id_label.setText("")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_member_value_changed(self,event):
        self.current_member_type = self.member_type_combobox.currentText()
        self.current_member_value = self.member_value_combobox.currentText()
        self.current_member_entity_id = self.get_entity_id(self.current_member_type,self.current_member_value)
        count = self.count_entity_id_associations(self.current_member_entity_id)
        self.member_entity_id_label.setText("<i>Entity ID: </i>&nbsp;" + str(self.current_member_entity_id) + "&nbsp;&nbsp;&nbsp;<i>Associated Entities: </i>&nbsp;" + str(count))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_entity_link_changed(self,event):
        if self.block_entity_link_signals:
            return
        self.manage_link_name_qlineedit.setText("")
        self.manage_link_value_qlineedit.setText("")
        name = self.entity_links_combobox.currentText()
        name = unicode(name)
        self.current_entity_link = name
        if name in self.current_links_dict:
            link_id,link = self.current_links_dict[name]
            self.manage_link_name_qlineedit.setText(name)
            self.manage_link_value_qlineedit.setText(link)
            self.current_entity_link_id = link_id
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_entity_note_changed(self,event):
        if self.block_entity_note_signals:
            return
        self.manage_note_name_qlineedit.setText("")
        self.manage_note_value_editor.html = ""
        name = self.entity_notes_combobox.currentText()
        name = unicode(name)
        self.current_entity_note = name
        if name in self.current_notes_dict:
            note_id,note = self.current_notes_dict[name]
            self.manage_note_name_qlineedit.setText(name)
            self.manage_note_value_editor.html = note
            self.current_entity_note_id = note_id
        else:
            pass
        QApplication.instance().processEvents()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_links_checkbox_toggled(self):
        self.entity_type_combobox.setCurrentIndex(-1)
        self.entity_value_combobox.setCurrentIndex(-1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_notes_checkbox_toggled(self):
        self.entity_type_combobox.setCurrentIndex(-1)
        self.entity_value_combobox.setCurrentIndex(-1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #~ ENTITY
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_entity(self,type=None,value=None,target=None):
        if self.block_all_signals:
            return

        self.block_all_signals = True

        if not type or not value or not target:
            target = "first_entity"
            type = self.current_entity_type
            value = self.current_entity_value
            if not type or not value:
                self.block_all_signals = False
                return
        else:
            pass

        mysql = "INSERT OR IGNORE INTO _entities(entity_id,type,value) VALUES (null,?,?)"

        self.my_cursor.execute("begin")
        if target == "first_entity":
            self.my_cursor.execute(mysql,(self.current_entity_type,self.current_entity_value))
        elif target == "member_entity":
            self.my_cursor.execute(mysql,(self.current_member_type,self.current_member_value))
        self.my_cursor.execute("commit")

        if target == "first_entity":
            self.current_entity_id = self.get_entity_id(self.current_entity_type,self.current_entity_value)
            self.entity_id_label.setText("<i>Entity ID: </i>&nbsp;" + str(self.current_entity_id))
            self.block_all_signals = False
            self.reflect_entity_changes(source=REFLECT_CREATE_ENTITY,source_id=1,id_1=self.current_entity_id,id_1_type=self.current_entity_type,id_1_value=self.current_entity_value,\
                                                               id_2=None,id_2_type=None,id_2_value=None)
        elif target == "member_entity":
            self.current_member_type = self.member_type_combobox.currentText()
            self.current_member_value = self.member_value_combobox.currentText()
            self.current_member_entity_id = self.get_entity_id(self.current_member_type,self.current_member_value)
            count = self.count_entity_id_associations(self.current_member_entity_id)
            self.member_entity_id_label.setText("<i>Entity ID: </i>&nbsp;" + str(self.current_member_entity_id) + "&nbsp;&nbsp;&nbsp;<i>Associated Entities: </i>&nbsp;" + str(count))
            self.block_all_signals = False
            self.reflect_entity_changes(source=REFLECT_CREATE_ENTITY,source_id=2,id_1=None,id_1_type=None,id_1_value=None,\
                                                                id_2=self.current_member_entity_id,id_2_type=self.current_member_type,id_2_value=self.current_member_value)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_association_type_entity(self):
        is_valid = self.select_association_matrix()
        if not is_valid:
            return

        if self.current_entity_type is None:
            return
        if self.current_entity_value is None:
            return
        if self.current_member_type is None:
            return
        if self.current_member_value is None:
            return
        if self.current_entity_type == self.current_member_type and self.current_entity_value == self.current_member_value:
            return

        self.block_all_signals = True

        association_type = ASSOCIATION_ENTITY_TYPE
        association_value = "(" + self.current_entity_type + " 🙴 " + self.current_entity_value + " ⇄ " + self.current_member_type + " 🙴 " + self.current_member_value + ")"
        #~ Important:  a heavy ampersand, 🙴, is used above so that the splitting of the association matrix item is correct when it splits on a regular ampersand, &.  Ditto for the "⇄".

        mysql = "INSERT OR IGNORE INTO _entities(entity_id,type,value) VALUES (null,?,?)"
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(association_type,association_value))
        self.my_cursor.execute("commit")

        self.block_all_signals = False

        msg = "Entity Created: " + association_type + " : " + association_value
        self.maingui.status_bar.show_message(_(msg), 5000)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_entity_id(self,type,value):

        entity_id = None

        mysql = "SELECT entity_id FROM _entities WHERE type = ? AND value = ?"
        self.my_cursor.execute(mysql,(type,value))
        tmp_rows = self.my_cursor.fetchall()
        if not tmp_rows:
            return None
        if len(tmp_rows) == 0:
            return None
        for row in tmp_rows:
            for col in row:
                entity_id = col
                break
        #END FOR
        return entity_id
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manage_associations(self):
        if self.associated_groupbox.isVisible():
            self.associated_groupbox.hide()
            self.resize_dialog()
        else:
            self.associated_groupbox.show()
            self.resize_dialog()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def associate_entities(self):

        if self.block_all_signals:
            return
        if not self.current_entity_type or not self.current_entity_value:
            return
        if not self.current_member_type or not self.current_member_value:
            return
        if self.current_member_type == self.current_entity_type and self.current_member_value == self.current_entity_value:
            return

        self.create_entity(type=self.current_member_type,value=self.current_member_value,target="member_entity")

        if not self.current_entity_id or not self.current_member_entity_id:
            return

        if self.current_entity_id == self.current_member_entity_id:
            return

        if self.current_member_entity_id is None:
            return

        #~ The 'unifying_id' is always set here to the first (top) entity_id, entity_id_1, which is always self.current_entity_id.

        mysql = "INSERT OR REPLACE INTO _entities_associations(entity_id_1,entity_id_2,unifying_id) VALUES (?,?,?)"

        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(self.current_entity_id,self.current_member_entity_id,self.current_entity_id))
        self.my_cursor.execute("commit")

        self.reflect_entity_changes(source=REFLECT_ASSOCIATE_ENTITIES,source_id=0,id_1=self.current_entity_id,id_1_type=self.current_entity_type,id_1_value=self.current_entity_type,\
                                                            id_2=self.current_member_entity_id,id_2_type=self.current_member_type,id_2_value=self.current_member_value)

        self.event_entity_value_changed(None)        #number of associations has changed
        self.event_member_value_changed(None)    #number of associations has changed
    #---------------------------------------------------------------------------------------------------------------------------------------
    def invert_association(self):

        is_valid = self.select_association_matrix()
        if not is_valid:
            return

        if self.current_entity_id is None:
            return
        if self.current_member_entity_id is None:
            return

        self.block_all_signals = True

        old_id_1 = self.current_entity_id
        old_id_2 = self.current_member_entity_id
        old_unifying_id = old_id_1 # possible future to do: will need to get the actual value in order to allow any future functionality allowing the unifying_id to <> either of the other 2 entity ids.
        new_id_1 = old_id_2
        new_id_2 = old_id_1
        if old_unifying_id == old_id_1:
            new_unifying_id = new_id_1
        else:
            new_unifying_id = old_unifying_id

        self.my_cursor.execute("begin")
        mysql = "DELETE FROM _entities_associations WHERE entity_id_1 = ? AND entity_id_2 = ?  "
        self.my_cursor.execute(mysql,(old_id_1,old_id_2))
        self.my_cursor.execute("commit")
        self.my_cursor.execute("begin")
        mysql = "INSERT INTO _entities_associations (entity_id_1,entity_id_2,unifying_id) VALUES(?,?,?) "
        self.my_cursor.execute(mysql,(new_id_1,new_id_2,new_unifying_id))
        self.my_cursor.execute("commit")
        self.block_all_signals = False

        self.entity_type_combobox.setCurrentIndex(-1)
        self.entity_value_combobox.setCurrentIndex(-1)
        self.member_type_combobox.setCurrentIndex(-1)
        self.member_value_combobox.setCurrentIndex(-1)

        #user must select from the refreshed Association Matrix to populate both of the entities...if they wish...
        self.refresh_association_matrix()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def unassociate_from_single_entity(self):
        if self.block_all_signals:
            return
        if self.current_entity_id is None or self.current_member_entity_id is None:
            return

        self.my_cursor.execute("begin")
        mysql = "DELETE FROM _entities_associations WHERE entity_id_1 = ? AND entity_id_2 = ?"
        self.my_cursor.execute(mysql,(self.current_entity_id,self.current_member_entity_id))
        self.my_cursor.execute("commit")

        self.current_entity_type = self.entity_type_combobox.currentText()
        self.current_entity_value = self.entity_value_combobox.currentText()

        self.reflect_entity_changes(source=REFLECT_UNASSOCIATE_FROM_SINGLE,source_id=0,id_1=self.current_entity_id,id_1_type=self.current_entity_type,id_1_value=self.current_entity_type,\
                                                            id_2=self.current_member_entity_id,id_2_type=self.current_member_type,id_2_value=self.current_member_value)

        self.event_entity_value_changed(None)        #number of associations has changed
        self.event_member_value_changed(None)    #number of associations has changed
    #---------------------------------------------------------------------------------------------------------------------------------------
    def unassociate_first_entity_from_all_entities(self):
        if self.block_all_signals:
            return
        if self.current_entity_id is None:
            return
        self.my_cursor.execute("begin")
        mysql = "DELETE FROM _entities_associations WHERE entity_id_1 = ? OR entity_id_2 = ? or unifying_id = ?"
        self.my_cursor.execute(mysql,(self.current_entity_id,self.current_entity_id,self.current_entity_id))
        self.my_cursor.execute("commit")

        self.current_entity_type = self.entity_type_combobox.currentText()
        self.current_entity_value = self.entity_value_combobox.currentText()

        self.reflect_entity_changes(source=REFLECT_UNASSOCIATE_FROM_ALL_OTHERS,source_id=1,id_1=self.current_entity_id,id_1_type=self.current_entity_type,id_1_value=self.current_entity_type,\
                                                            id_2=None,id_2_type=None,id_2_value=None)

        self.event_entity_value_changed(None)        #number of associations has changed
        self.event_member_value_changed(None)    #number of associations has changed
    #---------------------------------------------------------------------------------------------------------------------------------------
    def unassociate_member_from_all_entities(self):
        if self.block_all_signals:
            return
        if self.current_member_entity_id is None:
            return
        self.my_cursor.execute("begin")
        mysql = "DELETE FROM _entities_associations WHERE entity_id_1 = ? OR entity_id_2 = ? or unifying_id = ?"
        self.my_cursor.execute(mysql,(self.current_member_entity_id,self.current_member_entity_id,self.current_member_entity_id))
        self.my_cursor.execute("commit")

        self.current_member_entity_type = self.member_type_combobox.currentText()
        self.current_member_entity_value = self.member_value_combobox.currentText()

        self.reflect_entity_changes(source=REFLECT_UNASSOCIATE_FROM_ALL_OTHERS,source_id=2,id_1=None,id_1_type=None,id_1_value=None,\
                                                            id_2=self.current_member_entity_id,id_2_type=self.current_member_entity_type,id_2_value=self.current_member_entity_value)

        self.event_entity_value_changed(None)        #number of associations has changed
        self.event_member_value_changed(None)    #number of associations has changed
    #---------------------------------------------------------------------------------------------------------------------------------------
    def delete_entity(self):
        type = self.entity_type_combobox.currentText()
        value = self.entity_value_combobox.currentText()
        self.delete_entities(type,value)

        self.reflect_entity_changes(source=REFLECT_DELETE_ENTITY,source_id=1,id_1=self.current_entity_id,id_1_type=self.current_entity_type,id_1_value=self.current_entity_type,\
                                                            id_2=None,id_2_type=None,id_2_value=None)

        self.event_member_value_changed(None)    #number of associations has changed
    #---------------------------------------------------------------------------------------------------------------------------------------
    def delete_member_entity(self):
        if self.block_all_signals:
            return
        type = self.member_type_combobox.currentText()
        value = self.member_value_combobox.currentText()
        self.delete_entities(type,value)
        self.member_type_combobox.setCurrentIndex(-1)
        self.member_value_combobox.setCurrentIndex(-1)

        self.reflect_entity_changes(source=REFLECT_DELETE_ENTITY,source_id=2,id_1=None,id_1_type=None,id_1_value=None,\
                                                            id_2=self.current_member_entity_id,id_2_type=self.current_member_entity_type,id_2_value=self.current_member_entity_value)

        self.event_entity_value_changed(None)        #number of associations has changed
    #---------------------------------------------------------------------------------------------------------------------------------------
    def delete_entities(self,type,value):
        entity_id = self.get_entity_id(type,value)
        self.my_cursor.execute("begin")
        mysql = "DELETE FROM _entities_associations WHERE entity_id_1 = ? OR entity_id_2 = ? or unifying_id = ?"
        self.my_cursor.execute(mysql,(entity_id,entity_id,entity_id))
        mysql = "DELETE FROM _entities_links WHERE entity_id = ? "
        self.my_cursor.execute(mysql,([entity_id]))
        mysql = "DELETE FROM _entities_notes WHERE entity_id = ? "
        self.my_cursor.execute(mysql,([entity_id]))
        mysql = "DELETE FROM _entities WHERE entity_id = ? "
        self.my_cursor.execute(mysql,([entity_id]))
        self.my_cursor.execute("commit")

        self.reflect_entity_changes(source=REFLECT_DELETE_ENTITIES,source_id=1,id_1=entity_id,id_1_type=type,id_1_value=value,\
                                                            id_2=None,id_2_type=None,id_2_value=None)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def count_entity_id_associations(self,entity_id):
        mysql = "Select COUNT(*) FROM _entities_associations WHERE entity_id_1 = ? or entity_id_2 = ?"
        self.my_cursor.execute(mysql,(entity_id,entity_id))
        tmp_rows = self.my_cursor.fetchall()
        if not tmp_rows:
            return 0
        if len(tmp_rows) == 0:
            return 0
        count = 0
        for row in tmp_rows:
            for col in row:
                if isinstance(col,int):
                    count = col
                    break
            #END FOR
            break
        #END FOR
        return count
    #---------------------------------------------------------------------------------------------------------------------------------------
    def reflect_entity_changes(self,source=None,source_id=None,id_1=None,id_1_type=None,id_1_value=None,id_2=None,id_2_type=None,id_2_value=None):

        if source == REFLECT_CREATE_ENTITY:
            if source_id == 1:
                i = self.entity_value_combobox.findText(id_1_value)
                if i == -1:
                    self.entity_value_combobox.insertItem(0,id_1_value)
                    self.entity_value_combobox.model().sort(0)
                    i = self.entity_value_combobox.findText(id_1_value)
                    self.entity_value_combobox.setCurrentIndex(i)
                #~ -------------
                if self.current_member_type == self.current_entity_type:
                    i = self.member_value_combobox.findText(id_1_value)
                    if i == -1:
                        self.member_value_combobox.insertItem(0,id_1_value)
                        self.member_value_combobox.model().sort(0)
                        i = self.member_value_combobox.findText(self.current_member_value)
                        self.member_value_combobox.setCurrentIndex(i)
                #~ -------------
            elif source_id == 2:
                i = self.member_value_combobox.findText(id_2_value)
                if i == -1:
                    self.member_value_combobox.insertItem(0,id_2_value)
                    self.member_value_combobox.model().sort(0)
                    i = self.member_value_combobox.findText(id_2_value)
                    self.member_value_combobox.setCurrentIndex(i)
                #~ -------------
                if  self.current_entity_type == self.current_member_type:
                    i = self.entity_value_combobox.findText(id_2_value)
                    if i == -1:
                        self.entity_value_combobox.insertItem(0,id_2_value)
                        self.entity_value_combobox.model().sort(0)
                        i = self.entity_value_combobox.findText(self.current_entity_value)
                        self.entity_value_combobox.setCurrentIndex(i)
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        elif source == REFLECT_ASSOCIATE_ENTITIES:
            QTimer.singleShot(0,self.refresh_association_matrix)
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        elif source == REFLECT_UNASSOCIATE_FROM_SINGLE:
            QTimer.singleShot(0,self.refresh_association_matrix)
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        elif source == REFLECT_UNASSOCIATE_FROM_ALL_OTHERS:
            QTimer.singleShot(0,self.refresh_association_matrix)
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        elif source == REFLECT_DELETE_ENTITY:
            QTimer.singleShot(0,self.refresh_association_matrix)
            if source_id == 1:
                if self.scope == AVAILABLE:
                    return
                else:
                    i = self.entity_value_combobox.findText(id_1_value)
                    if i > -1:
                        self.entity_value_combobox.removeItem(i)
                        self.entity_value_combobox.setCurrentIndex(-1)
            elif source_id == 2:
                if self.member_scope == AVAILABLE:
                    return
                else:
                    i = self.member_value_combobox.findText(id_2_value)
                    if i > -1:
                        self.member_value_combobox.removeItem(i)
                        self.member_value_combobox.setCurrentIndex(-1)
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        elif source == REFLECT_DELETE_ENTITIES:
            QTimer.singleShot(0,self.refresh_association_matrix)
            if self.scope <> AVAILABLE:
                i = self.entity_value_combobox.findText(id_1_value)
                if i > -1:
                    self.entity_value_combobox.removeItem(i)
                    self.entity_value_combobox.setCurrentIndex(-1)
            if self.member_scope <> AVAILABLE:
                id_2_value = id_1_value  #only id_1 is used for this source
                i = self.member_value_combobox.findText(id_2_value)
                if i > -1:
                    self.member_value_combobox.removeItem(i)
                    self.member_value_combobox.setCurrentIndex(-1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #~ LINKS
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_links_for_entity(self):
        if self.current_entity_id is not None:
            links_list = self.get_entity_links(self.current_entity_id)
        else:
            links_list = []
        return links_list
   #---------------------------------------------------------------------------------------------------------------------------------------
    def get_entity_links(self,entity_id):
        links_list = []

        mysql = "SELECT link_id,name,link FROM _entities_links WHERE entity_id = ?"
        self.my_cursor.execute(mysql,([entity_id]))
        tmp_rows = self.my_cursor.fetchall()

        if not tmp_rows:
            return links_list
        if len(tmp_rows) == 0:
            return links_list
        for row in tmp_rows:
            links_list.append(row)
        #END FOR
        return links_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def refresh_links_for_entity(self):
        self.block_entity_link_signals = True
        self.current_links_dict.clear()
        self.entity_links_combobox.clear()
        self.manage_link_name_qlineedit.setText("")
        self.manage_link_value_qlineedit.setText("")
        links_list = self.get_links_for_entity()
        for row in links_list:
            link_id,name,link = row
            name = unicode(name)
            self.entity_links_combobox.addItem(name)
            self.current_links_dict[name] = link_id,link
        #END FOR
        del links_list
        self.entity_links_combobox.model().sort(0)
        self.entity_links_combobox.setCurrentIndex(0)
        self.entity_links_combobox.update()
        self.block_entity_link_signals = False
        self.event_entity_link_changed(None)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manage_links(self):
        if self.manage_links_groupbox.isVisible():
            self.manage_links_groupbox.hide()
            self.resize_dialog()
        else:
            self.manage_links_groupbox.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def clear_link(self):
        try:
            self.manage_link_name_qlineedit.setText("")
            self.manage_link_value_qlineedit.setText("")
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def refresh_link(self):
        name = self.entity_links_combobox.currentText()
        name = unicode(name)
        self.current_entity_link = name
        if not name in self.current_links_dict:
            return
        link_id,link = self.current_links_dict[name]
        self.manage_link_name_qlineedit.setText(name)
        self.manage_link_value_qlineedit.setText(link)
        self.current_entity_link_id = link_id
    #---------------------------------------------------------------------------------------------------------------------------------------
    def add_link(self):
        entity_id = self.current_entity_id
        name = self.manage_link_name_qlineedit.text()
        link = self.manage_link_value_qlineedit.text()

        if entity_id is None or name is None or link is None:
            return

        name = name.title().strip()
        link = link.strip()

        if not name > " " or not link > " ":
            return

        mysql = "INSERT OR IGNORE INTO _entities_links (link_id,entity_id,name,link) VALUES (null,?,?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,link))
        self.my_cursor.execute("commit")

        self.refresh_links_for_entity()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def change_link(self):
        entity_id = self.current_entity_id
        name = self.manage_link_name_qlineedit.text()
        link = self.manage_link_value_qlineedit.text()

        if entity_id is None or name is None or link is None:
            return

        name = name.title().strip()
        link = link.strip()

        if not name > " " or not link > " ":
            return

        mysql = "DELETE FROM _entities_links WHERE entity_id = ? AND link_id = ?"
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,self.current_entity_link_id))
        self.my_cursor.execute("commit")
        mysql = "INSERT INTO _entities_links (link_id,entity_id,name,link) VALUES (null,?,?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,link))
        self.my_cursor.execute("commit")

        self.refresh_links_for_entity()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_link(self):
        if self.entity_type_combobox.currentText() is None or self.entity_value_combobox.currentText() is None:
            return
        name = self.entity_links_combobox.currentText()
        name = unicode(name)
        if not name in self.current_links_dict:
            return error_dialog(self, _('Entities Manager: Copy Link'),_('Link does not exist. Copy Canceled.'), show=True)

        title = "Target Type?"
        label = "Copy to Target Type && Value (ENTITY)"
        items = self.entity_type_available_list
        target_type,ok = QInputDialog.getItem(None, title, label, items,0,False)
        if not ok:
            return
        if target_type is None:
            return
        if not target_type > " ":
            return
        del items
        title = "Target Value?"
        label = "Copy to Target Type && Value (Entity)"
        self.get_values_for_type(source=TARGET,type=target_type)
        items = self.target_value_list
        target_value,ok = QInputDialog.getItem(None, title, label, items,0,False)
        if not ok:
            return
        if target_value is None:
            return
        if not target_value > " ":
            return
        if target_type == self.entity_type_combobox.currentText() and target_value == self.entity_value_combobox.currentText():
            return error_dialog(self, _('Entities Manager: Copy Link'),_('Cannot copy a Link to the source Entity. Copy Canceled.'), show=True)

        entity_id = self.get_entity_id(target_type,target_value)
        if entity_id is None:
            return error_dialog(self, _('Entities Manager: Copy Link'),_('No Entity exists for the selected Type and Value.  Copy Canceled.'), show=True)

        link_id,link = self.current_links_dict[name]

        if entity_id is None or name is None or link is None:
            return

        name = name.title().strip()
        link = link.strip()
        if not name > " " or not link > " ":
            return

        mysql = "INSERT OR REPLACE INTO _entities_links (link_id,entity_id,name,link) VALUES (null,?,?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,link))
        self.my_cursor.execute("commit")

        msg = "Link: " + name + " was copied to Entity: " + target_type + "," + target_value + " successfully"
        return info_dialog(self, _('Entities Manager: Copy Link'),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def delete_link(self):
        entity_id = self.current_entity_id
        name = self.manage_link_name_qlineedit.text()
        link = self.manage_link_value_qlineedit.text()

        if entity_id is None or name is None or link is None:
            return

        name = name.strip()
        link = link.strip()

        mysql = "DELETE FROM _entities_links WHERE entity_id = ? AND name = ? AND link = ? AND link_id = ? "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,link,self.current_entity_link_id))
        self.my_cursor.execute("commit")

        self.refresh_links_for_entity()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def execute_link(self):

        name = self.current_entity_link
        if name in self.current_links_dict:
            link_id,link = self.current_links_dict[name]
        else:
            return

        link = link.replace("\\","/")
        if link.startswith('"') and link.endswith('"'):  #Windows copy-path artifacts
            link = link[1:-1]

        if not link > " ":
            return

        if self.open_url is None:
            from calibre.gui2 import open_url
            self.open_url = open_url
            del open_url

        try:
            self.open_url(QUrl(link, QUrl.TolerantMode))
            del link
        except Exception as e:
            msg = "Open URL Error for Link:  " + str(e)
            if DEBUG: print(msg)
            error_dialog(None, _('EM'),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #~ NOTES
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def manage_notes(self):
        if self.manage_notes_groupbox.isVisible():
            self.manage_notes_groupbox.hide()
            self.resize_dialog()
        else:
            self.manage_notes_groupbox.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_notes_for_entity(self):
        if self.current_entity_id is not None:
            notes_list = self.get_entity_notes(self.current_entity_id)
        else:
            notes_list = []
        return notes_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_entity_notes(self,entity_id):
        notes_list = []

        mysql = "SELECT note_id,name,note FROM _entities_notes WHERE entity_id = ?"
        self.my_cursor.execute(mysql,([entity_id]))
        tmp_rows = self.my_cursor.fetchall()

        if not tmp_rows:
            return notes_list
        if len(tmp_rows) == 0:
            return notes_list
        for row in tmp_rows:
            notes_list.append(row)
        #END FOR
        return notes_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def refresh_notes_for_entity(self):
        self.block_entity_note_signals = True
        self.current_notes_dict.clear()
        self.entity_notes_combobox.clear()
        self.manage_note_name_qlineedit.setText("")
        self.manage_note_value_editor.html = ""
        notes_list = self.get_notes_for_entity()
        for row in notes_list:
            note_id,name,note = row
            name = unicode(name)
            self.entity_notes_combobox.addItem(name)
            self.current_notes_dict[name] = note_id,note
        #END FOR
        del notes_list
        self.entity_notes_combobox.model().sort(0)
        self.entity_notes_combobox.setCurrentIndex(0)
        self.entity_notes_combobox.update()
        name = self.entity_notes_combobox.currentText()
        name = unicode(name)
        self.current_entity_note = name
        self.block_entity_note_signals = False
        self.event_entity_note_changed(None)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def clear_note(self):
        try:
            self.manage_note_name_qlineedit.setText("")
            self.manage_note_value_editor.html = ""
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def refresh_note(self):
        name = self.entity_notes_combobox.currentText()
        name = unicode(name)
        self.current_entity_note = name
        if name in self.current_notes_dict:
            note_id,note = self.current_notes_dict[name]
            self.manage_note_name_qlineedit.setText(name)
            self.manage_note_value_editor.html = note
            self.current_entity_note_id = note_id
    #---------------------------------------------------------------------------------------------------------------------------------------
    def add_note(self):
        entity_id = self.current_entity_id
        name = self.manage_note_name_qlineedit.text()
        note = self.manage_note_value_editor.html

        if entity_id is None or name is None or note is None:
            return

        name = name.title().strip()
        note = note.strip()

        if not name > " " or not note > " ":
            return

        mysql = "INSERT OR IGNORE INTO _entities_notes (note_id,entity_id,name,note) VALUES (null,?,?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,note))
        self.my_cursor.execute("commit")

        self.refresh_notes_for_entity()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def change_note(self):
        entity_id = self.current_entity_id
        name = self.manage_note_name_qlineedit.text()
        note = self.manage_note_value_editor.html

        if entity_id is None or name is None or note is None:
            return

        name = name.title().strip()
        note = note.strip()

        if not name > " " or not note > " ":
            return

        mysql = "DELETE FROM _entities_notes WHERE entity_id = ? AND note_id = ?"
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,self.current_entity_note_id))
        self.my_cursor.execute("commit")
        mysql = "INSERT INTO _entities_notes (note_id,entity_id,name,note) VALUES (null,?,?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,note))
        self.my_cursor.execute("commit")

        self.refresh_notes_for_entity()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def copy_note(self):
        if self.entity_type_combobox.currentText() is None or self.entity_value_combobox.currentText() is None:
            return
        name = self.entity_notes_combobox.currentText()
        name = unicode(name)
        if not name in self.current_notes_dict:
            return error_dialog(self, _('Entities Manager: Copy Note'),_('Note does not exist. Copy Canceled.'), show=True)

        title = "Target Type?"
        label = "Copy to Target Type && Value (ENTITY)"
        items = self.entity_type_available_list
        target_type,ok = QInputDialog.getItem(None, title, label, items,0,False)
        if not ok:
            return
        if target_type is None:
            return
        if not target_type > " ":
            return
        del items
        title = "Target Value?"
        label = "Copy to Target Type && Value (Entity)"
        self.get_values_for_type(source=TARGET,type=target_type)
        items = self.target_value_list
        target_value,ok = QInputDialog.getItem(None, title, label, items,0,False)
        if not ok:
            return
        if target_value is None:
            return
        if not target_value > " ":
            return
        if target_type == self.entity_type_combobox.currentText() and target_value == self.entity_value_combobox.currentText():
            return error_dialog(self, _('Entities Manager: Copy Note'),_('Cannot copy a Note to the source Entity. Copy Canceled.'), show=True)

        entity_id = self.get_entity_id(target_type,target_value)
        if entity_id is None:
            return error_dialog(self, _('Entities Manager: Copy Note'),_('No Entity exists for the selected Type and Value.  Copy Canceled.'), show=True)

        note_id,note = self.current_notes_dict[name]

        if entity_id is None or name is None or note is None:
            return

        name = name.title().strip()
        note = note.strip()
        if not name > " " or not note > " ":
            return

        mysql = "INSERT OR REPLACE INTO _entities_notes (note_id,entity_id,name,note) VALUES (null,?,?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,note))
        self.my_cursor.execute("commit")

        msg = "Note: " + name + " was copied to Entity: " + target_type + "," + target_value + " successfully"
        return info_dialog(self, _('Entities Manager: Copy Note'),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def delete_note(self):
        entity_id = self.current_entity_id
        name = self.manage_note_name_qlineedit.text()

        if entity_id is None or name is None:
            return
        if self.current_entity_note_id is None:
            return

        name = name.strip()

        mysql = "DELETE FROM _entities_notes WHERE entity_id = ? AND name = ? AND note_id = ? "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(entity_id,name,self.current_entity_note_id))
        self.my_cursor.execute("commit")

        self.refresh_notes_for_entity()
     #---------------------------------------------------------------------------------------------------------------------------------------
    def display_note(self):

        type = self.current_entity_type
        value = self.current_entity_value

        name = self.current_entity_note
        if name in self.current_notes_dict:
            note_id,note = self.current_notes_dict[name]
        else:
            return

        try:
            self.note_viewer_dialog.close()
        except:
            pass

        title = "Note '" + name + "' for Entity  '" + type + " - " + value + "'"

        from calibre_plugins.entities_manager.note_viewer_dialog import NoteViewerDialog
        self.note_viewer_dialog = NoteViewerDialog(self.entities_manager_icon,title,note,self.font)
        self.note_viewer_dialog.show()
        self.note_viewer_dialog.setAttribute(Qt.WA_DeleteOnClose)
        del NoteViewerDialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    #~ SCOPE
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_available_entities(self):
        if self.block_all_signals:
            return
        self.block_all_signals = True

        self.scope = AVAILABLE
        self.entity_type_combobox.clear()
        self.entity_type_desc_label.setText("")
        self.entity_value_combobox.clear()
        self.entity_id_label.setText("")
        self.entity_links_combobox.clear()
        self.entity_notes_combobox.clear()

        #~ self.get_available_entity_types() -  done only once at startup in __init__ since new custom columns require a Calibre restart...

        for entity_type in self.entity_type_available_list:
            self.entity_type_combobox.addItem(entity_type)
        #END FOR
        self.entity_type_combobox.setCurrentIndex(-1)

        self.block_all_signals = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_existing_entities(self):
        if self.block_all_signals:
            return

        self.block_all_signals = True

        self.scope = EXISTING
        self.entity_type_combobox.clear()
        self.entity_type_desc_label.setText("")
        self.entity_value_combobox.clear()
        self.entity_id_label.setText("")
        self.entity_links_combobox.clear()
        self.entity_notes_combobox.clear()

        self.get_existing_entity_types()

        for entity_type in self.entity_type_existing_list:
            self.entity_type_combobox.addItem(entity_type)
        #END FOR
        self.entity_type_combobox.setCurrentIndex(-1)

        self.block_all_signals = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_associated_entities(self):
        if self.block_all_signals:
            return

        self.block_all_signals = True

        self.scope = ASSOCIATED
        self.entity_type_combobox.clear()
        self.entity_type_desc_label.setText("")
        self.entity_value_combobox.clear()
        self.entity_id_label.setText("")
        self.entity_links_combobox.clear()
        self.entity_notes_combobox.clear()

        self.get_associated_entity_types()

        for entity_type in self.entity_type_associated_list:
            self.entity_type_combobox.addItem(entity_type)
        #END FOR
        self.entity_type_combobox.setCurrentIndex(-1)

        self.block_all_signals = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_unassociated_entities(self):
        if self.block_all_signals:
            return

        self.block_all_signals = True

        self.scope = UNASSOCIATED
        self.entity_type_combobox.clear()
        self.entity_type_desc_label.setText("")
        self.entity_value_combobox.clear()
        self.entity_id_label.setText("")
        self.entity_links_combobox.clear()
        self.entity_notes_combobox.clear()

        self.get_unassociated_entity_types()

        for entity_type in self.entity_type_unassociated_list:
            self.entity_type_combobox.addItem(entity_type)
        #END FOR
        self.entity_type_combobox.setCurrentIndex(-1)

        self.block_all_signals = False
   #---------------------------------------------------------------------------------------------------------------------------------------
    def view_orphaned_entities(self):
        if self.block_all_signals:
            return

        self.block_all_signals = True

        self.scope = ORPHANED
        self.entity_type_combobox.clear()
        self.entity_type_desc_label.setText("")
        self.entity_value_combobox.clear()
        self.entity_id_label.setText("")
        self.entity_links_combobox.clear()
        self.entity_notes_combobox.clear()

        self.get_orphaned_entity_types()

        for entity_type in self.entity_type_orphaned_list:
            self.entity_type_combobox.addItem(entity_type)
        #END FOR
        self.entity_type_combobox.setCurrentIndex(-1)

        self.block_all_signals = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_available_members(self):
        self.member_scope = AVAILABLE
        self.member_type_combobox.clear()
        #~ self.get_available_entity_types() - done at startup in __init__
        for entity_type in self.entity_type_available_list:
            self.member_type_combobox.addItem(entity_type)
        #END FOR
        self.member_type_combobox.setCurrentIndex(-1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_associated_members(self):
        self.member_scope = ASSOCIATED
        self.member_type_combobox.clear()
        self.get_associated_entity_types()
        for entity_type in self.entity_type_associated_list:
            self.member_type_combobox.addItem(entity_type)
        #END FOR
        self.member_type_combobox.setCurrentIndex(-1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def view_unassociated_members(self):
        self.member_scope = UNASSOCIATED
        self.member_type_combobox.clear()
        self.get_unassociated_entity_types()
        for entity_type in self.entity_type_unassociated_list:
            self.member_type_combobox.addItem(entity_type)
        #END FOR
        self.member_type_combobox.setCurrentIndex(-1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_available_entity_types(self):

        self.entity_type_available_list = []
        self.entity_type_available_list.append("Author")
        self.entity_type_available_list.append("Publisher")
        self.entity_type_available_list.append("Series")
        self.entity_type_available_list.append("Tags")
        self.entity_type_available_list.append("Title")

        self.standard_columns_list = []
        for et in self.entity_type_available_list:
            self.standard_columns_list.append(et)
        #END FOR

        self.entity_type_table_mapping_dict = {}
        self.entity_type_table_mapping_dict["Author"] = "authors"
        self.entity_type_table_mapping_dict["Publisher"] = "publishers"
        self.entity_type_table_mapping_dict["Series"] = "series"
        self.entity_type_table_mapping_dict["Tags"] = "tags"
        self.entity_type_table_mapping_dict["Title"] = "books"

        for row in self.user_types_list:
            type,label = row
            self.entity_type_available_list.append(type)
            if type == ASSOCIATION_ENTITY_TYPE:
                self.entity_type_table_mapping_dict[type] = "EM Reserved Entity Type"
            else:
                self.entity_type_table_mapping_dict[type] = "User Defined Entity Type"
        #END FOR

        self.get_table_custom_columns()

        self.update_entity_type_table_mapping_table()

        for cc in self.custom_column_label_list:
            self.entity_type_available_list.append(cc)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_existing_entity_types(self):
        del self.entity_type_existing_list[:]
        mysql = "SELECT DISTINCT type FROM _entities ORDER BY type ASC "
        self.my_cursor.execute(mysql)
        tmp_rows = self.my_cursor.fetchall()
        if tmp_rows is None:
            tmp_rows = []
        for row in tmp_rows:
            for col in row:
                self.entity_type_existing_list.append(col)
                break
            #END FOR
        #END FOR
        del tmp_rows
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_associated_entity_types(self):
        del self.entity_type_associated_list[:]
        mysql = "SELECT DISTINCT type FROM _entities WHERE ((entity_id IN (SELECT entity_id_1 FROM _entities_associations)) OR \
         (entity_id IN (SELECT entity_id_2 FROM _entities_associations))) ORDER BY type ASC"
        self.my_cursor.execute(mysql)
        tmp_rows = self.my_cursor.fetchall()
        if tmp_rows is None:
            tmp_rows = []
        for row in tmp_rows:
            for col in row:
                self.entity_type_associated_list.append(col)
                break
            #END FOR
        #END FOR
        del tmp_rows
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_unassociated_entity_types(self):
        del self.entity_type_unassociated_list[:]
        mysql = "SELECT DISTINCT type FROM _entities WHERE ((entity_id NOT IN (SELECT entity_id_1 FROM _entities_associations)) AND \
         (entity_id NOT IN (SELECT entity_id_2 FROM _entities_associations))) ORDER BY type ASC"
        self.my_cursor.execute(mysql)
        tmp_rows = self.my_cursor.fetchall()
        if tmp_rows is None:
            tmp_rows = []
        for row in tmp_rows:
            for col in row:
                self.entity_type_unassociated_list.append(col)
                break
            #END FOR
        #END FOR
        del tmp_rows
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_orphaned_entity_types(self):
        del self.entity_type_orphaned_list[:]
        for type in self.entity_type_available_list:  #values not known yet, so potentially all types could easily have values that are orphaned...
            if type.startswith("~"):  #orphans by design...
                continue
            self.entity_type_orphaned_list.append(type)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #~ OTHER
    #---------------------------------------------------------------------------------------------------------------------------------------
   #---------------------------------------------------------------------------------------------------------------------------------------
    def get_values_for_type(self,source=None,type=None):
        if source == ENTITY:
            self.current_entity_type = self.entity_type_combobox.currentText()
            current_type = self.current_entity_type
        elif source == MEMBER:
            self.current_member_type = self.member_type_combobox.currentText()
            current_type = self.current_member_type
        elif source == TARGET:  #copy-to target
            if type is None:
                return
            current_type = type
        else:
            return

        data_list = []

        if current_type in self.standard_columns_list:
            if current_type == "Author":
                table = "authors"
                column = "name"
            elif current_type == "Publisher":
                table = "publishers"
                column = "name"
            elif current_type == "Series":
                table = "series"
                column = "name"
            elif current_type == "Tags":
                table = "tags"
                column = "name"
            elif current_type == "Title":
                table = "books"
                column = "title"
            else:
                return
            data_list = self.get_column_data_generic(table,column,source)
        elif current_type in self.custom_column_label_list:
            if current_type in self.custom_column_label_dict:
                id,label,name,datatype,display,is_multiple,normalized = self.custom_column_label_dict[current_type]
                table = "custom_column_[N]"
                table = table.replace("[N]",id)
                column = "value"
                data_list = self.get_column_data_generic(table,column,source)
            else:
                return
        elif current_type.startswith("~"):
            data_list = self.get_user_defined_entity_type_values(current_type)
            data_list.insert(0,ADD_NEW_VALUE)
        else:
            return

        if source == ENTITY:
            self.entity_value_combobox.clear()
            for value in data_list:
                self.entity_value_combobox.addItem(value)
            #END FOR
            self.entity_value_combobox.setCurrentIndex(-1)
        elif source == MEMBER:
            self.member_value_combobox.clear()
            for value in data_list:
                self.member_value_combobox.addItem(value)
            #END FOR
            self.member_value_combobox.setCurrentIndex(-1)
        elif source == TARGET:  #copy-to target
            self.target_value_list = data_list

        del data_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_column_data_generic(self,table,column,source):

        self.select_only_if_links()
        self.select_only_if_notes()

        data_list = []

        if source == ENTITY or source == MEMBER or source == TARGET:
            if (self.scope == AVAILABLE and source == ENTITY) or (self.member_scope == AVAILABLE and source == MEMBER) or (self.member_scope == AVAILABLE and source == TARGET):
                mysql = "SELECT DISTINCT [COLUMN] FROM [TABLE] ORDER BY [COLUMN] ASC"
                mysql = mysql.replace("[COLUMN]",column)
                mysql = mysql.replace("[TABLE]",table)
            elif (self.scope == EXISTING and source == ENTITY) or (self.member_scope == EXISTING and source == MEMBER):
                #~ different entity types can have the identical values, so must also compare types when searching for values...by using table _entities_type_table_mapping
                mysql = "SELECT [COLUMN] FROM [TABLE] "
                mysql = mysql + "WHERE [COLUMN] IN (SELECT value FROM _entities WHERE (_entities.type IN \
                (SELECT type FROM _entities_type_table_mapping WHERE _entities_type_table_mapping.type = _entities.type \
                AND _entities_type_table_mapping.type_table = '[TABLE]')) "
                if self.only_if_links:
                    mysql = mysql +" AND _entities.entity_id IN (SELECT entity_id FROM _entities_links WHERE _entities_links.entity_id = _entities.entity_id) "
                if self.only_if_notes:
                    mysql = mysql + " AND _entities.entity_id IN (SELECT entity_id FROM _entities_notes WHERE _entities_notes.entity_id = _entities.entity_id) "
                mysql = mysql + ")"
                mysql = mysql + " ORDER BY [COLUMN] ASC"
                mysql = mysql.replace("[COLUMN]",column)
                mysql = mysql.replace("[TABLE]",table)
            elif (self.scope == ASSOCIATED and source == ENTITY) or (self.member_scope == ASSOCIATED and source == MEMBER):
                #~ different entity types can have the identical values, so must also compare types when searching for values...by using table _entities_type_table_mapping
                mysql = "SELECT [COLUMN] FROM [TABLE] "
                mysql = mysql + "WHERE [COLUMN] IN (SELECT value FROM _entities \
                WHERE (_entities.type IN \
                (SELECT type FROM _entities_type_table_mapping WHERE _entities_type_table_mapping.type = _entities.type \
                AND _entities_type_table_mapping.type_table = '[TABLE]' ) ) \
                AND  (_entities.entity_id IN (SELECT entity_id_1 FROM _entities_associations) OR _entities.entity_id IN (SELECT entity_id_2 FROM _entities_associations) )    "
                if self.only_if_links:
                    mysql = mysql +" AND _entities.entity_id IN (SELECT entity_id FROM _entities_links WHERE _entities_links.entity_id = _entities.entity_id) "
                if self.only_if_notes:
                    mysql = mysql + " AND _entities.entity_id IN (SELECT entity_id FROM _entities_notes WHERE _entities_notes.entity_id = _entities.entity_id) "
                mysql = mysql + ")"
                mysql = mysql + " ORDER BY [COLUMN] ASC"
                mysql = mysql.replace("[COLUMN]",column)
                mysql = mysql.replace("[TABLE]",table)
            elif (self.scope == UNASSOCIATED and source == ENTITY) or (self.member_scope == UNASSOCIATED and source == MEMBER):
                 #~ different entity types can have the identical values, so must also compare types when searching for values...by using table _entities_type_table_mapping
                mysql = "\
                SELECT value FROM _entities \
                    WHERE (_entities.entity_id NOT IN (SELECT entity_id_1 FROM _entities_associations) AND \
                                  _entities.entity_id NOT IN (SELECT entity_id_2 FROM _entities_associations) ) \
                        AND (_entities.type IN \
                                    (SELECT type FROM _entities_type_table_mapping WHERE _entities_type_table_mapping.type = _entities.type \
                                                                                                                     AND _entities_type_table_mapping.type_table = '[TABLE]' ) )"
                if self.only_if_links:
                    mysql = mysql +" AND _entities.entity_id IN (SELECT entity_id FROM _entities_links WHERE _entities_links.entity_id = _entities.entity_id) "
                if self.only_if_notes:
                    mysql = mysql + " AND _entities.entity_id IN (SELECT entity_id FROM _entities_notes WHERE _entities_notes.entity_id = _entities.entity_id) "
                mysql = mysql + " ORDER BY value ASC"
                mysql = mysql.replace("[TABLE]",table)
            elif (self.scope == ORPHANED and source == ENTITY):
                 #~ different entity types can have the identical values, so must also compare types when searching for values...by using table _entities_type_table_mapping
                mysql = "\
                SELECT value FROM _entities \
                WHERE (_entities.value NOT IN (SELECT [COLUMN] FROM [TABLE] )) \
                    AND (_entities.type IN \
                                (SELECT type FROM _entities_type_table_mapping WHERE _entities_type_table_mapping.type = _entities.type \
                                                                                                                     AND _entities_type_table_mapping.type_table = '[TABLE]' ) )"
                mysql = mysql + " ORDER BY _entities.value ASC"
                mysql = mysql.replace("[COLUMN]",column)
                mysql = mysql.replace("[TABLE]",table)
            else:
                return data_list
        else:
            return data_list

        try:
            self.my_cursor.execute(mysql)
            tmp_rows = self.my_cursor.fetchall()
        except Exception as e:
            if DEBUG: print("Select Entity Types Exception: ", str(e), mysql)
            tmp_rows = None

        if tmp_rows is None:
            tmp_rows = []
        n = len(tmp_rows)
        if n == 0:
            return data_list

        for row in tmp_rows:
            for col in row:
                data_list.append(col)
                break
            #END FOR
        #END FOR
        del tmp_rows

        return data_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_user_defined_entity_type_values(self,user_type):
        data_list = []
        try:
            mysql = "SELECT value FROM _entities WHERE type = ? ORDER BY value ASC"
            self.my_cursor.execute(mysql,([user_type]))
            tmp_rows = self.my_cursor.fetchall()
        except Exception as e:
            if DEBUG: print("Select User Defined Entity Types Exception: ", str(e), mysql)
            tmp_rows = None

        if tmp_rows is None:
            tmp_rows = []
        n = len(tmp_rows)
        if n == 0:
            del tmp_rows
            return data_list

        for row in tmp_rows:
            for col in row:
                data_list.append(col)
                break
            #END FOR
        #END FOR
        del tmp_rows
        return data_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def select_only_if_links(self):
        if self.select_only_if_links_checkbox.isChecked():
            self.only_if_links = True
        else:
            self.only_if_links = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def select_only_if_notes(self):
        if self.select_only_if_notes_checkbox.isChecked():
            self.only_if_notes = True
        else:
            self.only_if_notes = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_table_custom_columns(self):

        self.custom_column_label_dict = {}
        self.custom_column_label_list = []

        try:
            mysql = "SELECT id,label,name,datatype,display,is_multiple,normalized FROM custom_columns"
            self.my_cursor.execute(mysql)
            tmp_rows = self.my_cursor.fetchall()
            if tmp_rows is None:
                tmp_rows = []
            for row in tmp_rows:
                id,label,name,datatype,display,is_multiple,normalized = row
                if datatype <> "composite" and datatype <> "ratings" and datatype <> "int" and datatype <> "float" and datatype <> "bool" and datatype <> "datetime":
                    if datatype == "comments":
                        if not '"interpret_as": "short-text"' in display:
                            continue
                    label = "#" + label
                    id = str(id)
                    r = id,label,name,datatype,display,is_multiple,normalized
                    self.custom_column_label_dict[label] = r
                    self.custom_column_label_list.append(label)
                    table = "custom_column_[N]".replace("[N]",str(id))
                    self.entity_type_table_mapping_dict[label] = table
            #END FOR
            self.custom_column_label_list.sort()
            del tmp_rows
        except Exception as e:
            if DEBUG: print("Error in get_table_custom_columns: ", str(e))
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_entity_type_table_mapping_table(self):
        self.my_cursor.execute("begin")
        mysql = "DELETE FROM _entities_type_table_mapping WHERE type IS NOT NULL"
        self.my_cursor.execute(mysql)
        self.my_cursor.execute("commit")
        self.my_cursor.execute("begin")
        mysql = "INSERT INTO _entities_type_table_mapping(type,type_table) VALUES(?,?) "
        for type,table in self.entity_type_table_mapping_dict.iteritems():
            self.my_cursor.execute(mysql,(type,table))
        #END FOR
        self.my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def refresh_association_matrix(self):
        self.association_matrix_combobox.clear()
        entity_association_matrix_list = self.create_entity_association_matrix()
        w1,w2,w3,w4 = self.find_matrix_maximum_column_widths(entity_association_matrix_list)
        s = "                                                                                                                                                                                                                                                  "
        for row in entity_association_matrix_list:
            entity, associated, entity_type, associated_type, entity_value, associated_value, entity_table, associated_table = row
            c1 = w1 - len(entity_type)
            c2 = w2 - len(associated_type)
            c3 = w3 - len(entity_value)
            c4 = w4 - len(associated_value)
            r1 = s[:c1]
            r2 = s[:c2]
            r3 = s[:c3]
            r4 = s[:c4]
            if entity_type == "~Associations":
                entity_value = entity_value + "   " #padding due to wide unicode symbols
            r = entity_type + r1 + " & " + entity_value + r3 + " ↔ " + associated_type + r2   + " & " + associated_value + r4
            self.association_matrix_combobox.addItem(r)
        #END FOR
        del entity_association_matrix_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_entity_association_matrix(self):

        mysql = "\
        SELECT entity_id_1 AS entity,entity_id_2 AS associated, \
        (SELECT type FROM _entities WHERE _entities.entity_id = _entities_associations.entity_id_1) AS entity_type, \
        (SELECT type FROM _entities WHERE _entities.entity_id = _entities_associations.entity_id_2) AS associated_type, \
        (SELECT value FROM _entities WHERE _entities.entity_id = _entities_associations.entity_id_1) AS entity_value, \
        (SELECT value FROM _entities WHERE _entities.entity_id = _entities_associations.entity_id_2) AS associated_value, \
        (SELECT type_table FROM _entities_type_table_mapping WHERE type = (SELECT type FROM _entities WHERE _entities.entity_id = _entities_associations.entity_id_1)) AS entity_table, \
        (SELECT type_table FROM _entities_type_table_mapping WHERE type = (SELECT type FROM _entities WHERE _entities.entity_id = _entities_associations.entity_id_2)) AS associated_table \
        FROM _entities_associations  ORDER BY entity_type,entity_value,associated_type,associated_value  "

        entity_association_matrix_list = []

        self.my_cursor.execute(mysql)
        tmp_rows = self.my_cursor.fetchall()
        if tmp_rows is None:
            tmp_rows = []
        for row in tmp_rows:
            entity_association_matrix_list.append(row)
        #END FOR
        return entity_association_matrix_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def find_matrix_maximum_column_widths(self,entity_association_matrix_list):
        w1 = 0
        w2 = 0
        w3 = 0
        w4 = 0
        for row in entity_association_matrix_list:
            entity, associated, entity_type, associated_type, entity_value, associated_value, entity_table, associated_table = row
            if len(entity_type) > w1:
                w1 = len(entity_type)
            if len(associated_type) > w2:
                w2 = len(associated_type)
            if len(entity_value) > w3:
                w3 = len(entity_value)
            if len(associated_value) > w4:
                w4 = len(associated_value)
        #END FOR
        del entity_association_matrix_list

        return w1,w2,w3,w4
    #---------------------------------------------------------------------------------------------------------------------------------------
    def select_association_matrix(self):
        self.current_association_matrix_item = self.association_matrix_combobox.currentText()
        if self.current_association_matrix_item is None:
            return False
        if not "↔" in self.current_association_matrix_item:
            return False

        s_split = self.current_association_matrix_item.split("↔")
        e1 = s_split[0].strip()
        e2 = s_split[1].strip()

        s_split = e1.split("&")
        e1_type = s_split[0].strip()
        e1_value = s_split[1].strip()

        s_split = e2.split("&")
        e2_type = s_split[0].strip()
        e2_value = s_split[1].strip()

        del s_split

        #~ fully populate the comboboxes since might have been almost empty
        if not self.view_available_radio.isChecked():
            self.view_available_radio.setChecked(True)

        self.entity_type_combobox.setCurrentIndex(-1)
        self.entity_value_combobox.setCurrentIndex(-1)

        i = self.entity_type_combobox.findText(e1_type)
        if i == -1:
            self.entity_type_combobox.insertItem(0,e1_type)
            self.entity_type_combobox.model().sort(0)
            i = self.entity_type_combobox.findText(e1_type)
            self.entity_type_combobox.setCurrentIndex(i)
        else:
            self.entity_type_combobox.setCurrentIndex(i)

        i = self.entity_value_combobox.findText(e1_value)
        if i == -1:
            self.entity_value_combobox.insertItem(0,e1_value)
            self.entity_value_combobox.model().sort(0)
            i = self.entity_value_combobox.findText(e1_value)
            self.entity_value_combobox.setCurrentIndex(i)
        else:
            self.entity_value_combobox.setCurrentIndex(i)

        #~ fully populate the comboboxes since might have been almost empty
        if not self.view_available_member_radio.isChecked():
            self.view_available_member_radio.setChecked(True)

        self.event_member_type_changed(None)
        self.event_member_value_changed(None)

        self.member_type_combobox.setCurrentIndex(-1)
        self.member_value_combobox.setCurrentIndex(-1)

        i = self.member_type_combobox.findText(e2_type)
        if i == -1:
            self.member_type_combobox.insertItem(0,e2_type)
            self.member_type_combobox.model().sort(0)
            i = self.member_type_combobox.findText(e2_type)
            self.member_type_combobox.setCurrentIndex(i)
        else:
            self.member_type_combobox.setCurrentIndex(i)

        self.event_member_type_changed(None)

        i = self.member_value_combobox.findText(e2_value)
        if i == -1:
            self.member_value_combobox.insertItem(0,e2_value)
            self.member_value_combobox.model().sort(0)
            i = self.member_value_combobox.findText(e2_value)
            self.member_value_combobox.setCurrentIndex(i)
        else:
            self.member_value_combobox.setCurrentIndex(i)

        self.event_member_value_changed(None)

        return True
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_icons(self):
        self.entities_manager_icon = get_icon(PLUGIN_ICONS[0])
        self.add_link_icon = get_icon(PLUGIN_ICONS[1])
        self.add_note_icon = get_icon(PLUGIN_ICONS[2])
        self.change_icon = get_icon(PLUGIN_ICONS[3])
        self.clear_input_icon = get_icon(PLUGIN_ICONS[4])
        self.close_icon = get_icon(PLUGIN_ICONS[5])
        self.delete_icon = get_icon(PLUGIN_ICONS[6])
        self.information_icon = get_icon(PLUGIN_ICONS[7])
        self.invert_icon = get_icon(PLUGIN_ICONS[8])
        self.matrix_icon = get_icon(PLUGIN_ICONS[9])
        self.ok_icon = get_icon(PLUGIN_ICONS[10])
        self.refresh_icon = get_icon(PLUGIN_ICONS[11])
        self.reload_icon = get_icon(PLUGIN_ICONS[12])
        self.create_icon = get_icon(PLUGIN_ICONS[13])
        self.select_matrix_item_icon = get_icon(PLUGIN_ICONS[14])
        self.open_icon = get_icon(PLUGIN_ICONS[15])
        self.association_icon = get_icon(PLUGIN_ICONS[16])
        self.delete_association_icon = get_icon(PLUGIN_ICONS[17])
        self.delete_all_associations_icon = get_icon(PLUGIN_ICONS[18])
        self.link_icon = get_icon(PLUGIN_ICONS[19])
        self.note_icon = get_icon(PLUGIN_ICONS[20])
        self.copy_link_icon = get_icon(PLUGIN_ICONS[21])
        self.copy_note_icon = get_icon(PLUGIN_ICONS[22])
        self.entity_icon = get_icon(PLUGIN_ICONS[23])
        self.element_icon = get_icon(PLUGIN_ICONS[24])
        self.list_entities_icon = get_icon(PLUGIN_ICONS[25])
        self.utilities_icon = get_icon(PLUGIN_ICONS[26])
        self.add_icon = get_icon(PLUGIN_ICONS[27])
        self.user_type_icon = get_icon(PLUGIN_ICONS[28])

        self.entity_pixmap = self.entity_icon.pixmap(20,20)
        self.link_pixmap = self.link_icon.pixmap(20,20)
        self.note_pixmap = self.note_icon.pixmap(20,20)
        self.add_pixmap = self.add_icon.pixmap(20,20)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def associate_entities_quick_create(self):
        self.quick_pick(source=MEMBER)
        self.create_entity(type=self.current_member_type,value=self.current_member_value,target="member_entity")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def quick_pick_entity(self):
        self.quick_pick(source=ENTITY)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def quick_pick_member(self):
        self.quick_pick(source=MEMBER)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def quick_pick(self,source=None):
        if source is None:
            return

        book_id = self.maingui.library_view.current_book
        if book_id is None:
            return

        bcol = self.get_bcol()      #selected library_view column
        if not bcol:
            return error_dialog(self, _('EM'),_('No Column Was Selected. Your cursor must be within a cell underneath the desired Column.'), show=True)

        mi = self.guidb.new_api.get_metadata(book_id)
        fm = None

        if bcol.startswith("#"):
            type = bcol
            fm = mi.metadata_for_field(bcol)  # field metadata...not values...
            datatype = fm['datatype']
            if  datatype == "int" or datatype == "float" or datatype == "bool" or datatype == "ratings" or datatype == "composite":
                del mi
                del fm
                return #unsupported custom column
        else:
            if bcol == "authors":
                type = "Author"
            elif bcol == "publisher":
                type = "Publisher"
            elif bcol == "series":
                type = "Series"
            elif bcol == "tags":
                type = "Tags"
            elif bcol == "title":
                type = "Title"
            else:
                return  #unsupported standard column

        value = mi.get(bcol, None)
        if isinstance(value,list):
            if len(value) > 0:
                if len(value) > 1:
                    title = "Value?"
                    label = "Multiple Values for Selected Column: Choose One (1)"
                    value,ok = QInputDialog.getItem(None, title, label, value,0,False)
                    if not ok:
                        return
                else:
                    value = value[0]
            else:
                value = None

        del mi
        del fm

        msg = "Quick Pick Entity Type: " + bcol + "  Value: " + str(value)
        self.maingui.status_bar.show_message(_(msg), 3000)

        entity_id = self.get_entity_id(type,value)

        if source == ENTITY:
            if entity_id is not None:
                self.view_existing_radio.setChecked(True)
            else:
                self.view_available_radio.setChecked(True)
            self.entity_type_combobox.setCurrentText(type)
            self.entity_value_combobox.setCurrentText(value)
        else:
            self.view_available_member_radio.setChecked(True)
            self.member_type_combobox.setCurrentText(type)
            self.member_value_combobox.setCurrentText(value)
   #---------------------------------------------------------------------------------------------------------------------------------------
    def get_bcol(self):
        bcol = None
        current_col = self.maingui.library_view.currentIndex().column()
        bcol = self.maingui.library_view.column_map[current_col]
        return bcol
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def clear_all_input(self):
        self.view_available_radio.setChecked(True)
        self.entity_type_combobox.setCurrentIndex(-1)
        self.entity_value_combobox.setCurrentIndex(-1)
        self.clear_link()
        self.clear_note()
        self.view_available_member_radio.setChecked(True)
        self.member_type_combobox.setCurrentIndex(-1)
        self.member_value_combobox.setCurrentIndex(-1)
        self.association_matrix_combobox.setCurrentIndex(-1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def apsw_connect_to_library(self):

        if isbytestring(self.library_path):
            self.library_path = self.library_path.decode(filesystem_encoding)
        self.library_path = self.library_path.replace(os.sep, '/')

        path = os.path.join(self.library_path, 'metadata.db')
        path = path.replace(os.sep, '/')

        if isbytestring(path):
            path = path.decode(filesystem_encoding)

        if path.endswith("/"):
            path = path[0:-1]

        self.library_metadatadb_path = path

        try:
            self.my_db = apsw.Connection(path)
            is_valid = True
        except Exception as e:
            if DEBUG: print("path to metadata.db is: ", path)
            if DEBUG: print("error: ", str(e))
            is_valid = False
            return is_valid

        self.my_cursor = self.my_db.cursor()

        mysql = "PRAGMA main.busy_timeout = 25000;"      #milliseconds;
        self.my_cursor.execute(mysql)

        return is_valid
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_tables(self):

        mysql = \
        """
        CREATE TABLE IF NOT EXISTS _entities(entity_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,type TEXT NOT NULL COLLATE NOCASE,value TEXT NOT NULL COLLATE NOCASE,UNIQUE(type,value));
        CREATE TABLE IF NOT EXISTS _entities_associations(entity_id_1 INTEGER NOT NULL,entity_id_2 INTEGER NOT NULL,unifying_id INTEGER NOT NULL,PRIMARY KEY(entity_id_1,entity_id_2));
        CREATE TABLE IF NOT EXISTS _entities_links(link_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,entity_id INTEGER NOT NULL,name TEXT NOT NULL DEFAULT '' COLLATE NOCASE,link TEXT NOT NULL COLLATE NOCASE);
        CREATE TABLE IF NOT EXISTS _entities_notes(note_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,entity_id INTEGER NOT NULL,name TEXT NOT NULL DEFAULT '' COLLATE NOCASE,note TEXT NOT NULL COLLATE NOCASE);
        CREATE TABLE IF NOT EXISTS _entities_type_table_mapping(type TEXT NOT NULL COLLATE NOCASE,type_table TEXT NOT NULL COLLATE NOCASE,PRIMARY KEY(type,type_table));
        CREATE TABLE IF NOT EXISTS _entities_user_types(type_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,type TEXT NOT NULL COLLATE NOCASE,label TEXT NOT NULL COLLATE NOCASE,UNIQUE(type));
        CREATE TABLE IF NOT EXISTS _entities_type_preferences(type TEXT NOT NULL COLLATE NOCASE,preference TEXT NOT NULL COLLATE NOCASE,value TEXT NOT NULL COLLATE NOCASE,PRIMARY KEY(type,preference));
        CREATE TABLE IF NOT EXISTS _entities_preferences(entity_id INTEGER NOT NULL,preference TEXT NOT NULL COLLATE NOCASE,value TEXT NOT NULL COLLATE NOCASE,PRIMARY KEY(entity_id,preference));
        CREATE TABLE IF NOT EXISTS _entities_manager_preferences(preference TEXT NOT NULL COLLATE NOCASE,value TEXT NOT NULL COLLATE NOCASE,PRIMARY KEY(preference));
        """
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql)
        self.my_cursor.execute("commit")

        mysql = \
        """
        CREATE INDEX IF NOT EXISTS _entities_idx ON _entities(type,value);
        CREATE INDEX IF NOT EXISTS _entities_associations_idx ON _entities_associations(unifying_id,entity_id_1,entity_id_2);
        CREATE INDEX IF NOT EXISTS _entities_associations_alt_1_idx ON _entities_associations(entity_id_1,unifying_id);
        CREATE INDEX IF NOT EXISTS _entities_associations_alt_2_idx ON _entities_associations(entity_id_2,unifying_id);
        CREATE INDEX IF NOT EXISTS _entities_links_idx ON _entities_links(entity_id,link_id);
        CREATE INDEX IF NOT EXISTS _entities_notes_idx ON _entities_notes(entity_id,note_id);
        CREATE INDEX IF NOT EXISTS _entities_user_types_idx ON _entities_user_types(type);
        CREATE INDEX IF NOT EXISTS _entities_type_preferences_idx ON _entities_type_preferences(type,preference);
        CREATE INDEX IF NOT EXISTS _entities_preferences_idx ON _entities_preferences(entity_id,preference);
        CREATE INDEX IF NOT EXISTS _entities_manager_preferences_idx ON _entities_manager_preferences(preference);
        """
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql)
        self.my_cursor.execute("commit")

        mysql = "INSERT OR IGNORE INTO _entities_user_types (type_id,type,label) VALUES (null,?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,(ASSOCIATION_ENTITY_TYPE,"EM Reserved Entity Type"))
        self.my_cursor.execute("commit")

        self.my_cursor.execute("begin")

        mysql = "INSERT OR IGNORE INTO _entities_type_preferences (type,preference,value) \
        SELECT type,'add_column_icon_rule','0' FROM _entities_type_table_mapping WHERE type NOT LIKE '~%'  "
        self.my_cursor.execute(mysql)

        mysql = "INSERT OR IGNORE INTO _entities_type_preferences (type,preference,value) \
        SELECT type,'add_column_color_rule','0' FROM _entities_type_table_mapping WHERE  _entities_type_table_mapping.type NOT LIKE '~%'  "
        self.my_cursor.execute(mysql)

        mysql = "INSERT OR IGNORE INTO _entities_type_preferences (type,preference,value) \
        SELECT type ,'column_icon_filename','entity_reserved' FROM _entities_type_table_mapping WHERE  _entities_type_table_mapping.type NOT LIKE '~%'   "
        self.my_cursor.execute(mysql)

        mysql = "INSERT OR IGNORE INTO _entities_type_preferences (type,preference,value) \
        SELECT type,'column_color_code','#e715dd' FROM _entities_type_table_mapping WHERE  _entities_type_table_mapping.type NOT LIKE '~%'   "
        self.my_cursor.execute(mysql)

        mysql = "INSERT OR IGNORE INTO _entities_type_preferences (type,preference,value) \
        SELECT type,'icon_if_link_note','1' FROM _entities_type_table_mapping WHERE  _entities_type_table_mapping.type NOT LIKE '~%'   "
        self.my_cursor.execute(mysql)

        mysql = "INSERT OR IGNORE INTO _entities_type_preferences (type,preference,value) \
        SELECT type,'color_if_link_note','1' FROM _entities_type_table_mapping WHERE  _entities_type_table_mapping.type NOT LIKE '~%'   "
        self.my_cursor.execute(mysql)

        self.my_cursor.execute("commit")

        mysql = "INSERT OR IGNORE INTO _entities_manager_preferences (preference,value) VALUES (?,?)   "
        self.my_cursor.execute("begin")
        self.my_cursor.execute(mysql,("unique_column_color_rules_reserved_color_default","#e715dd"))
        self.my_cursor.execute(mysql,("unique_column_color_rules_reserved_color_list","['#e715dd']"))
        self.my_cursor.execute(mysql,("column_icon_rules_reserved_icon_filename_prefix","entity_reserved"))
        self.my_cursor.execute(mysql,("column_icon_rules_reserved_icon_filename_default","entity_reserved.png"))
        self.my_cursor.execute(mysql,("automatic_icon_rules_backup_is_active","1"))
        self.my_cursor.execute(mysql,("automatic_color_rules_backup_is_active","1"))
        self.my_cursor.execute("commit")
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def exit(self):
        self.my_db.close()
        self.dialog_closing()
        self.hide()
        self.done
        self.close()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
#END OF entities_manager_dialog.py