# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2019 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.7"  #Enhancements.

from PyQt5.Qt import (Qt, QDialog, QLabel, QComboBox, QVBoxLayout)

class BooksFoundDialog(QDialog):

    def __init__(self,maingui,icon,font,pick_list):

        QDialog.__init__(self, maingui)

        self.maingui = maingui
        self.icon = icon
        self.font = font
        self.font.setBold(False)
        self.pick_list = pick_list

        self.setWindowIcon(self.icon)
        self.setWindowTitle('Entities')
        self.setWindowFlags( Qt.Window | Qt.WindowTitleHint | Qt.WindowSystemMenuHint | Qt.WindowMinMaxButtonsHint | Qt.WindowCloseButtonHint)              # http://doc.qt.io/qt-5/qt.html#WindowType-enum
        #--------------------------------------------------

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout)

        self.font.setPointSize(12)

        n = len(self.pick_list)

        s_msg = "Distinct Entities found in Books: " + str(n)

        self.text_line = QLabel()
        self.text_line.setTextFormat(1)
        self.text_line.setFont(font)
        self.text_line.setText("<center><font color='#0404B4'>" + s_msg + "</font></center>")
        self.layout.addWidget(self.text_line)

        self.entity_combobox = QComboBox()
        self.entity_combobox.setFont(self.font)
        self.entity_combobox.setEditable(False)
        self.entity_combobox.setFrame(True)
        self.entity_combobox.setDuplicatesEnabled(False)
        self.entity_combobox.setMaxVisibleItems(25)
        self.entity_combobox.setMinimumWidth(500)
        self.entity_combobox.setMaximumWidth(500)
        self.entity_combobox.setSizeAdjustPolicy(QComboBox.AdjustToContents)
        self.entity_combobox.setFont(self.font)
        self.entity_combobox.setToolTip("<p style='white-space:wrap'>zzzzzzzzzzzzzzzzzzzzzzzzzzzz")
        self.layout.addWidget(self.entity_combobox)

        for row in self.pick_list:
            type,value = row
            s = type + " & " + value
            self.entity_combobox.addItem(s)
        #END FOR

        self.resize(self.sizeHint())

#END OF books_found_dialog.py