# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.9"     #  Obfuscation of obscenities now optional.

from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.Qt import (Qt, QDialog, QLabel, QHBoxLayout, QWidget, QPushButton,
                                        QTextEdit, QListWidget, QListWidgetItem, QComboBox, QSize,
                                        QGridLayout, QFont, QTabWidget, QVBoxLayout, QScrollArea, QLayout,
                                        QPalette, QColor, QMargins, QSizePolicy, QAbstractItemView, QTextOption,
                                        QIcon, QGroupBox, QSpacerItem, QLineEdit, QDialogButtonBox,
                                        QCheckBox, QSpinBox,QRadioButton, QButtonGroup, QToolTip )
from PyQt5.Qt import QFileDialog,QObject,QApplication

import os,sys
import platform
import subprocess
import unicodedata
import codecs

from calibre import isbytestring
from calibre.constants import filesystem_encoding, preferred_encoding, iswindows, get_windows_username, DEBUG, isosx
from calibre.gui2 import __init__, FileDialog
from calibre.gui2 import error_dialog, info_dialog, warning_dialog, question_dialog
from calibre.gui2 import gprefs
from calibre.utils.config import JSONConfig
from calibre.utils.filenames import expanduser

from calibre_plugins.english_noun_frequency.config import prefs
from calibre_plugins.english_noun_frequency.config import ConfigWidget

ACCUMULATED_MOST_FREQUENT_NOUNS_CSV_FILENAME = "accumulated_most_frequent_nouns.csv"
ACCUMULATED_MOST_FREQUENT_NOUNS_TUPLES_FILENAME = "accumulated_most_frequent_nouns.tuples"
USER_CUSTOM_WORD_RULES_SINGULAR_PLURAL_PAIRS_FILENAME = "user_singular_plural_pairs.string"
USER_CUSTOM_WORD_RULES_CHANGE_PAIRS_FILENAME = "user_change_pairs.string"
USER_CUSTOM_WORD_RULES_GOOD_WORDS_FILENAME = "user_good_words.string"
USER_CUSTOM_WORD_RULES_BAD_WORDS_FILENAME = "user_bad_words.string"

user_csv_file_directory = "unknown"
protected_data_directory = "unknown"
my_plugin_path = "unknown"

param_dict = {}

windows_user_name = ""

#--------------------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(0, 0)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom

#--------------------------------------------------------------------------------------------------
class ENFDialog(SizePersistedDialog):

    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,plugin_path,enf_job_control):
        parent = gui
        unique_pref_name = 'English_Noun_Frequency:gui_parameters_dialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)
        #-----------------------------------------------------
        self.gui = gui
        self.guidb = guidb

        self.icon = icon
        #-----------------------------------------------------
        global my_plugin_path
        my_plugin_path = plugin_path
        self.my_plugin_path = plugin_path
        #-----------------------------------------------------
        self.enf_job_control = enf_job_control
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #1: ENFParameterTab
        #-----------------------------------------------------
        from calibre_plugins.english_noun_frequency.enf_dialog import ENFParameterTab
        self.ENFParameterTab = ENFParameterTab(self.gui,icon,self.guidb,self.my_plugin_path,self.enf_job_control)

        self.build_dict = self.ENFParameterTab.build_dict
        self.validate = self.ENFParameterTab.validate

        self.ENFParameterTab.setToolTip("This Tab controls how the ENF jobs execute.")

        #-----------------------------------------------------
        #-----------------------------------------------------

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #2: ENFUserListsTab_A
        #-----------------------------------------------------
        from calibre_plugins.english_noun_frequency.enf_dialog import ENFUserListsTab_A
        self.ENFUserListsTab_A = ENFUserListsTab_A(self.gui,icon,self.guidb,self.my_plugin_path)

        self.save_good_words  =  self.ENFUserListsTab_A.save_good_words
        self.save_bad_words  =  self.ENFUserListsTab_A.save_bad_words
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #3: ENFUserListsTab_B
        #-----------------------------------------------------
        from calibre_plugins.english_noun_frequency.enf_dialog import ENFUserListsTab_B
        self.ENFUserListsTab_B = ENFUserListsTab_B(self.gui,icon,self.guidb,self.my_plugin_path,self.ENFUserListsTab_A)

        self.save_plurals = self.ENFUserListsTab_B.save_plurals
        self.save_change_pairs = self.ENFUserListsTab_B.save_change_pairs
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #4: ENFFaqTab
        #-----------------------------------------------------
        from calibre_plugins.english_noun_frequency.enf_dialog import ENFFaqTab
        self.ENFFaqTab = ENFFaqTab(self.gui,icon,self.guidb,self.my_plugin_path)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #                                  ENFDialog
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(8)

        tablabel_font = QFont()
        tablabel_font.setBold(False)
        tablabel_font.setPointSize(8)

        #-----------------------------------------------------
        self.setWindowTitle('English Noun Frequency')
        self.setWindowIcon(icon)
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout_frame)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        n_width = 600
        self.tabWidget = QTabWidget()
        self.tabWidget.setMaximumWidth(n_width)
        self.tabWidget.setFont(tablabel_font)
        self.tabWidget.addTab(self.ENFParameterTab,"Options")
        self.ENFParameterTab.setToolTip("<p style='white-space:nowrap'>The 'Options' Tab provides the mechanism to set the parameters that control not  <br>\
                                                                only the very next Job, but also your chosen strategic goals for <br>\
                                                                the use of ENF within and among your Calibre Libraries.")
        self.ENFParameterTab.setMaximumWidth(n_width)

        self.tabWidget.addTab(self.ENFUserListsTab_A,"Custom Rules: Single Words")
        self.ENFUserListsTab_A.setToolTip("<p style='white-space:nowrap'>The 'Custom Rules: Single Words Tab' contains any 'Custom Word Rules' <br>\
                                                                that specify single words rather than pairs of words.")
        self.ENFUserListsTab_A.setMaximumWidth(n_width)

        self.tabWidget.addTab(self.ENFUserListsTab_B,"Custom Rules: Word Pairs")
        self.ENFUserListsTab_B.setToolTip("<p style='white-space:nowrap'>The 'Custom Rules: Word Pairs Tab' contains any 'Custom Word Rules'  <br>\
                                                                that specify pairs of words rather than single words.")
        self.ENFUserListsTab_B.setMaximumWidth(n_width)

        self.tabWidget.addTab(self.ENFFaqTab,"FAQ")
        self.ENFFaqTab.setToolTip("<p style='white-space:nowrap'>The FAQ Tab contains the Frequently Asked Questions,  <br>\
                                                    and also an Example of the Comments that can be created if desired.")
        self.ENFFaqTab.setMaximumWidth(n_width)

        #-----------------------------------------------------
        self.layout_frame.addWidget(self.tabWidget)
        #-----------------------------------------------------
        #-----------------------------------------------------

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.bottom_buttonbox = QDialogButtonBox()
        self.bottom_buttonbox.setOrientation(Qt.Horizontal)
        self.bottom_buttonbox.setCenterButtons(True)

        self.layout_frame.addWidget(self.bottom_buttonbox,1)
        #-----------------------------------------------------
        self.push_button3 = QPushButton(" ", self)
        self.push_button3.setText("Validate Custom Word Rules")
        self.push_button3.clicked.connect(self.cross_check_all_custom_rules)
        self.push_button3.setFont(font)
        self.push_button3.setToolTip("<p style='white-space:wrap'>Cross-checks the User Custom Word Rules for overlapping and conflicting choices, \
                                                        such as a 'good word' that is also a 'bad word'")
        self.bottom_buttonbox.addButton(self.push_button3,0)

        #-----------------------------------------------------
        self.push_button1 = QPushButton(" ", self)
        self.push_button1.setText("Execute  [Selected Books]")
        self.push_button1.clicked.connect(self.execute_enf_selected)
        self.push_button1.setFont(font)
        self.push_button1.setToolTip("Execute the Job for only those books currently selected")
        self.bottom_buttonbox.addButton(self.push_button1,0)
        #-----------------------------------------------------
        self.push_button2 = QPushButton(" ", self)
        self.push_button2.setText("   Execute [All Books]   ")
        self.push_button2.clicked.connect(self.execute_enf_all)
        self.push_button2.setFont(font)
        self.push_button2.setToolTip("Execute the Job for books in the current Library")
        self.bottom_buttonbox.addButton(self.push_button2,0)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_cancel = QPushButton("Exit")
        self.push_button_cancel.clicked.connect(self.reject)
        self.push_button_cancel.setDefault(False)
        self.push_button_cancel.setToolTip("Exit without first saving any changes not previously saved.")
        self.bottom_buttonbox.addButton(self.push_button_cancel,0)
        #-----------------------------------------------------

        self.resize_dialog()      # inherited from SizePersistedDialog

   #-----------------------------------------------------------------------------------------------
    def execute_enf_selected(self):
        sel_type = "selected"
        self.execute_enf(sel_type)
    #-----------------------------------------------------------------------------------------------
    def execute_enf_all(self):
        sel_type = "all"
        if not question_dialog(self.gui, _('Execute for All Books?'),_('Execute for <b>All</b> Books?  Are you quite sure?')) :
            return
        self.execute_enf(sel_type)
    #-----------------------------------------------------------------------------------------------
    def execute_enf(self,sel_type):
        self.save_dialog_geometry()          #  inherited from SizePersistedDialog
        global param_dict
        self.build_dict()
        is_valid = self.validate_param_dict()
        if is_valid:
            self.enf_job_control(self.guidb,param_dict,sel_type)
        else:
            return
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------

    def validate_param_dict(self):

        global param_dict

        self.build_dict()  # and save

        is_valid = True

        if param_dict['COMMENTS_CHECKBOX'] == 'False':
            if param_dict['TAGS_CHECKBOX'] == 'False':
                if param_dict['CUSTOM_COLUMN_CHECKBOX'] == 'False':
                    if param_dict['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] == "False":
                        if param_dict['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] == "False":
                            is_valid = False
                            error_dialog(self.gui, _('English Noun Frequency'),_('No Actions Were Selected.'), show=True)
                            return is_valid

        if param_dict['COMMENTS_CHECKBOX'] <> 'False' or \
                param_dict['TAGS_CHECKBOX'] <> 'False' or \
                param_dict['CUSTOM_COLUMN_CHECKBOX'] <> 'False':
            if param_dict['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] == "True" or param_dict['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] == "True":
                is_valid = False
                error_dialog(self.gui, _('English Noun Frequency'),_('Conflicting Actions Were Selected.  De-select an Action.'), show=True)
                return is_valid

        if not param_dict['CUSTOM_COLUMN_NAME'].startswith("#"):
            if param_dict['CUSTOM_COLUMN_CHECKBOX'] == 'True':
                is_valid = False
                error_dialog(self.gui, _('English Noun Frequency'),_("Custom Column Specified is Invalid.  No leading '#'.  "), show=True)
                return is_valid

        s = str(param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH'])
        default = str("[WINDOWSUSERNAME]")
        program_string = str("Program Files")
        programdata_string = str("ProgramData")
        zip_string = str("zip")
        if s.count(default) > 0 or s.count(program_string) > 0 or s.count(programdata_string) > 0 or s.count(zip_string) > 0:
            is_valid = False
            error_dialog(self.gui, _('English Noun Frequency'),_("Your personal .csv file path directory is invalid.  <br><br>Please use the pushbutton to change it before continuing."), show=True)
            return is_valid

        if param_dict['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] == unicode('True'):
            if not param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'] > " ":
                is_valid = False
                error_dialog(self.gui, _('English Noun Frequency'),_('Translation is Active, but the Specified Language is Invalid'), show=True)
                return is_valid

        return is_valid

#--------------------------------------------------------------------------------------------------
    def cross_check_all_custom_rules(self):

        self.save_dialog_geometry()     # inherited from SizePersistedDialog

        self.build_dict()  # and save

        is_valid = False

        is_valid = self.save_good_words()
        if not is_valid:
            warning_dialog(self.gui, _("'Custom Good Words' Have Cross-check Errors!"),\
            _("You have at least one 'Custom Good Word' that contains one of your custom 'Bad' words."), show=True)
            self.tabWidget.setCurrentIndex(1)
            return

        is_valid = self.save_bad_words()
        if not is_valid:
            warning_dialog(self.gui, _("'Custom Bad Words' Have Cross-check Errors!"),\
            _("You have at least one 'Custom Bad Word' that contains one of your custom 'Good' words."), show=True)
            self.tabWidget.setCurrentIndex(1)
            return

        is_valid = self.save_plurals()
        if not is_valid:
            self.tabWidget.setCurrentIndex(2)    # tab column has its own warning dialog
            return

        is_valid = self.save_change_pairs()
        if not is_valid:
            self.tabWidget.setCurrentIndex(2)   # tab column has its own warning dialog
            return

        self.tabWidget.setCurrentIndex(0)
        info_dialog(self.gui, 'All Custom Rule Checks Passed','All Custom Rule Checks Passed.').show()

#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class ENFParameterTab(QWidget):

    def __init__(self,gui,icon,guidb,plugin_path,enf_action_control):
        super(ENFParameterTab, self).__init__()

        #-----------------------------------------------------
        self.gui = gui
        self.guidb = guidb

        global my_plugin_path
        my_plugin_path = plugin_path
        self.my_plugin_path = plugin_path

        self.enf_action_control = enf_action_control

        global user_csv_file_directory
        user_csv_file_directory = "unknown"
        self.user_csv_file_directory = "unknown"

        global protected_data_directory
        protected_data_directory = "unknown"
        self.protected_data_directory = "unknown"

        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(8)

        self.setWindowTitle("'English Noun Frequency'")
        self.setWindowIcon(icon)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignLeft)
        self.setLayout(self.layout_top)
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignLeft)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(800,800)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top, which is:  self .

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .

        #-----------------------------------------------------
        self.misc_groupbox = QGroupBox('Creation Maxima:')  #maximums
        self.misc_groupbox.setToolTip("<p style='white-space:nowrap'>Maximum numbers of Most Frequent Nouns <br>\
                                                            to create per Metadata category.")
        self.layout_frame.addWidget(self.misc_groupbox)

        self.misc_layout = QGridLayout()
        self.misc_groupbox.setLayout(self.misc_layout)
        #-----------------------------------------------------
        self.spin_1 = QSpinBox(self)
        self.spin_1.setMinimum(001)
        self.spin_1.setMaximum(100)
        self.spin_1.setProperty('value',prefs['COMMENTS_MAX'])
        self.spin_1.setMaximumWidth(200)
        self.spin_1.setSuffix("     Words in Comments         ")
        self.spin_1.setToolTip("<p style='white-space:nowrap'>Maximum number of Most Frequent Nouns <br>\
                                            for a book that will be added to that book's Comments.")
        self.misc_layout.addWidget(self.spin_1,0,0)   #row 0 column 0
        #-----------------------------------------------------
        self.spin_2 = QSpinBox(self)
        self.spin_2.setMinimum(001)
        self.spin_2.setMaximum(100)
        self.spin_2.setProperty('value',prefs['TAGS_MAX'])
        self.spin_2.setMaximumWidth(200)
        self.spin_2.setSuffix("      Tags from Words             ")
        self.spin_2.setToolTip("<p style='white-space:nowrap'>Maximum number of Most Frequent Nouns <br>\
                                            for a book that will be added to that book's Tags.")
        self.misc_layout.addWidget(self.spin_2,2,0)   #row 0 column 0
        #-----------------------------------------------------
        self.spin_3 = QSpinBox(self)
        self.spin_3.setMinimum(001)
        self.spin_3.setMaximum(100)
        self.spin_3.setProperty('value',prefs['CUSTOM_COLUMN_MAX'])
        self.spin_3.setMaximumWidth(200)
        self.spin_3.setSuffix("      Words in Custom Column")
        self.spin_3.setToolTip("<p style='white-space:nowrap'>Maximum number of Most Frequent Nouns for a book <br>\
                                            that will be added to that book's specified Custom Column.")
        self.misc_layout.addWidget(self.spin_3,4,0)

        #-----------------------------------------------------
        self.comments_checkbox_groupbox = QGroupBox('Comments:')
        self.comments_checkbox_groupbox.setToolTip("<p style='white-space:nowrap'>Options to control If, How, How Many, <br>\
                                                                                    and Where Comments should be updated.")
        self.comments_checkbox_groupbox.setAlignment(Qt.AlignCenter)

        self.layout_frame.addWidget(self.comments_checkbox_groupbox)

        self.comments_checkbox_layout = QVBoxLayout()
        self.comments_checkbox_layout.setAlignment(Qt.AlignCenter)
        self.comments_checkbox_groupbox.setLayout(self.comments_checkbox_layout)
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.create_comments_checkbox = QCheckBox("Create Comments from Words?")
        self.create_comments_checkbox.setToolTip("<p style='white-space:nowrap'>Do you want a book's Most Frequent <br>\
                                                                                Nouns added to its Comments?")


        self.comments_checkbox_layout.addWidget(self.create_comments_checkbox)

        if prefs['COMMENTS_CHECKBOX'] == unicode("True"):
            self.create_comments_checkbox.setChecked(True)

        self.prepend_radio = QRadioButton('Prepend to Existing Comments?')
        self.comments_checkbox_layout.addWidget(self.prepend_radio)

        self.append_radio = QRadioButton('Append to Existing Comments?')
        self.comments_checkbox_layout.addWidget(self.append_radio)

        self.replace_radio = QRadioButton('Replace All Existing Comments?')
        self.comments_checkbox_layout.addWidget(self.replace_radio)

        self.comments_button_group = QButtonGroup(self.comments_checkbox_layout)
        self.comments_button_group.addButton(self.prepend_radio)
        self.comments_button_group.addButton(self.append_radio)
        self.comments_button_group.addButton(self.replace_radio)

        if prefs['COMMENTS_PREPEND_APPEND_REPLACE'] == unicode("prepend"):
            self.prepend_radio.setChecked(True)
        else:
            if prefs['COMMENTS_PREPEND_APPEND_REPLACE'] == unicode("append"):
                self.append_radio.setChecked(True)
            else:
                self.replace_radio.setChecked(True)

        self.comments_remove_previous_checkbox = QCheckBox("Remove Previous ENF Comments First?")
        self.comments_remove_previous_checkbox.setToolTip("<p style='white-space:nowrap'>Do you want a book's previously added ENF Comments <br>\
                                                                                                                                                    removed before adding any new ones? <br><br>\
                                                                                                    <p style='white-space:wrap'>This is highly recommended, especially if you want to <br>\
                                                                                                                                                    flip-flop between Prepending and Appending the ENF Comments.")
        self.comments_checkbox_layout.addWidget(self.comments_remove_previous_checkbox)

        if prefs['COMMENTS_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX']  == unicode("True"):
            self.comments_remove_previous_checkbox.setChecked(True)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.tags_checkbox_groupbox = QGroupBox('Tags:')
        self.tags_checkbox_groupbox.setToolTip("Options to control If, How, and How Many Tags should be created.")
        self.layout_frame.addWidget(self.tags_checkbox_groupbox)

        self.tags_checkbox_layout = QVBoxLayout()
        self.tags_checkbox_layout.setAlignment(Qt.AlignCenter)
        self.tags_checkbox_groupbox.setLayout(self.tags_checkbox_layout)

        self.create_tags_checkbox = QCheckBox("Create New Tags from Words?")
        self.create_tags_checkbox.setToolTip("Do you want a book's Most Frequent Nouns added to its Tags?")
        self.tags_checkbox_layout.addWidget(self.create_tags_checkbox)

        if prefs['TAGS_CHECKBOX'] == unicode("True"):
            self.create_tags_checkbox.setChecked(True)

        self.add_radio = QRadioButton('Add New Tags to Existing Tags?')
        self.tags_checkbox_layout.addWidget(self.add_radio)
        self.replace_radio = QRadioButton('Replace All Existing Tags with New Tags?')
        self.tags_checkbox_layout.addWidget(self.replace_radio)
        self.tags_button_group = QButtonGroup(self.tags_checkbox_layout)
        self.tags_button_group.addButton(self.add_radio)
        self.tags_button_group.addButton(self.replace_radio)

        if prefs['TAGS_REPLACE_ADD'] == unicode("add"):
            self.add_radio.setChecked(True)
        else:
            self.replace_radio.setChecked(True)

        #-----------------------------------------------------
        #-----------------------------------------------------

        #-----------------------------------------------------
        self.cc_checkbox_groupbox = QGroupBox('Custom Column:')
        self.cc_checkbox_groupbox.setToolTip("<p style='white-space:nowrap'>Options to control If, How, and How Many Most Frequent Words <br>\
                                                                        should be created for the specified Custom Column.")
        self.layout_frame.addWidget(self.cc_checkbox_groupbox)

        self.cc_checkbox_layout = QVBoxLayout()
        self.cc_checkbox_layout.setAlignment(Qt.AlignCenter)
        self.cc_checkbox_groupbox.setLayout(self.cc_checkbox_layout)
        #-----------------------------------------------------

        self.update_custom_column_checkbox = QCheckBox("Update a Custom Column with Words?")
        self.update_custom_column_checkbox.setToolTip("<p style='white-space:nowrap'>Do you want a book's Most Frequent Nouns <br>\
                                                                                        added to the specified Custom Column?")
        self.cc_checkbox_layout.addWidget(self.update_custom_column_checkbox)

        if prefs['CUSTOM_COLUMN_CHECKBOX'] == unicode("True"):
            self.update_custom_column_checkbox.setChecked(True)

        self.custom_column = QLineEdit(self)
        self.custom_column.setText(prefs['CUSTOM_COLUMN_NAME'])
        self.custom_column.setToolTip("What is the Custom Column Lookup/Search-Name (beginning with a '#') that you want updated?")
        self.custom_column.setMaximumWidth(100)
        self.cc_checkbox_layout.addWidget(self.custom_column)

        self.sort_custom_column_checkbox = QCheckBox("Sort Words Alphabetically (not by Frequency)?")
        self.sort_custom_column_checkbox.setToolTip("<p style='white-space:nowrap'>Do you want the words updated in the specified Custom Column <br>\
                                                                                    to be sorted Alphabetically (ascending) or by Frequency (descending)?")
        self.cc_checkbox_layout.addWidget(self.sort_custom_column_checkbox)

        if prefs['CUSTOM_COLUMN_SORT_ALPHA'] == unicode("True"):
            self.sort_custom_column_checkbox.setChecked(True)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.special_execution_checkbox_groupbox = QGroupBox('Special Execution Options:')
        self.special_execution_checkbox_groupbox.setToolTip("Special options to control what the next ENF job will do.")
        self.layout_frame.addWidget(self.special_execution_checkbox_groupbox)

        self.other2_checkbox_layout = QVBoxLayout()
        self.other2_checkbox_layout.setAlignment(Qt.AlignLeft)
        self.special_execution_checkbox_groupbox.setLayout(self.other2_checkbox_layout)

        #-----------------------------------------------------
        self.obfuscate_obscenities_checkbox = QCheckBox("Obfuscate Obscenities?")
        self.obfuscate_obscenities_checkbox.setToolTip("<p style='white-space:nowrap'>Change ENF's list of obscene words by adding one or more asterisks ('*') in the middle of the obscenity.")
        self.other2_checkbox_layout.addWidget(self.obfuscate_obscenities_checkbox)

        if prefs['OBFUSCATE_OBSCENITIES'] == unicode("True"):
            self.obfuscate_obscenities_checkbox.setChecked(True)

        #-----------------------------------------------------
        self.remove_english_first_names_checkbox = QCheckBox("Discard All Globally Frequent First Names?")
        self.remove_english_first_names_checkbox.setToolTip("<p style='white-space:nowrap'>This option allows you to remove any word <br>\
                                                                                                that is in the standard list of Global First Names. <br><br>\
                                                                                                If desired, any encountered names that are not in the standard list<br>\
                                                                                                may be added to the 'user custom list of words to delete'.")
        self.other2_checkbox_layout.addWidget(self.remove_english_first_names_checkbox)

        if prefs['REMOVE_GLOBAL_FIRST_NAMES'] == unicode("True"):
            self.remove_english_first_names_checkbox.setChecked(True)

        #-----------------------------------------------------
        self.remove_top_100_nouns_checkbox = QCheckBox("Discard Top 100 Most Common Nouns (time,year,people,way,day,...,moment,air,teacher)?")
        self.remove_top_100_nouns_checkbox.setToolTip("<p style='white-space:wrap'>This option allows you to discard extremely repetitive nouns that are common to most books, especially fiction.")
        self.other2_checkbox_layout.addWidget(self.remove_top_100_nouns_checkbox)

        if prefs['REMOVE_TOP_100_NOUNS'] == unicode("True"):
            self.remove_top_100_nouns_checkbox.setChecked(True)

        #-----------------------------------------------------
        self.translate_layout = QHBoxLayout()
        self.translate_layout.setAlignment(Qt.AlignLeft)
        self.other2_checkbox_layout.addLayout(self.translate_layout)

        self.translate_english_to_other_is_active_checkbox = QCheckBox("Translate the English Nouns?")
        self.translate_english_to_other_is_active_checkbox.setToolTip("<p style='white-space:wrap'>Activate Translation of the Most Frequent Nouns shown in the ENF Comments?")
        self.translate_layout.addWidget(self.translate_english_to_other_is_active_checkbox)

        if prefs['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] == unicode('True'):
            self.translate_english_to_other_is_active_checkbox.setChecked(True)

        self.translate_english_to_other_language_combobox = QComboBox()
        self.translate_english_to_other_language_combobox.addItem("Español")
        self.translate_english_to_other_language_combobox.addItem("Other Language")
        self.translate_english_to_other_language_combobox.setEditable(False)
        self.translate_english_to_other_language_combobox.setToolTip("<p style='white-space:wrap'>Only Spanish is standard at this time.  \
                                                                                                                                                                If you wish to supplement and/or override the standard English-Spanish dictionary, simply specify an additional mapping file to use. \
                                                                                                                                                                If you wish to translate to another language, select the only translation file that will be used.  ")
        self.translate_layout.addWidget(self.translate_english_to_other_language_combobox)

        font.setPointSize(6)
        font.setBold(True)
        self.user_custom_translation_dictionary_full_path_button = QPushButton(" ", self)
        s = unicode(prefs['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'])
        self.user_custom_translation_dictionary_full_path_button.setText(s)

        self.user_custom_translation_dictionary_full_path_button.setToolTip("<p style='white-space:wrap'>Select the full file path to your personal User Custom English-to-Other Language translation mapping file.  If your language selection is Español, then this file will be a custom addition/override to the standard Spanish dictionary.  If your language selection is 'Other Language', this will be the only dictionary that will be used.  If the ENF Job cannot find this file, it will cause no errors, but it will result in a Job log message stating it was not found and hence not used.")
        self.user_custom_translation_dictionary_full_path_button.clicked.connect(self.get_full_file_path_for_custom_translation_dictionary_to_use)
        self.user_custom_translation_dictionary_full_path_button.setFont(font)
        self.translate_layout.addWidget(self.user_custom_translation_dictionary_full_path_button)
        font.setPointSize(8)
        font.setBold(False)
        #-----------------------------------------------------
        self.update_log_only_checkbox = QCheckBox("Update Nothing, but Log the Word Frequency List?")
        self.update_log_only_checkbox.setToolTip("<p style='white-space:nowrap'>This option allows you to view the theoretical <br>\
                                                                            'Most Frequent Nouns' that otherwise would be <br>\
                                                                            updated as Comments, Tags and/or Custom Column values.")
        self.other2_checkbox_layout.addWidget(self.update_log_only_checkbox)

        if prefs['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] == unicode("True"):
            self.update_log_only_checkbox.setChecked(True)

        self.update_log_only_checkbox.clicked.connect(self.event_uncheck_all_update_action_checkboxes)

        #-----------------------------------------------------
        self.remove_previous_enf_comments_checkbox = QCheckBox("Update Nothing, but Remove Previous ENF Comments?")
        self.remove_previous_enf_comments_checkbox.setToolTip("<p style='white-space:nowrap'>This option allows you to remove any previously created ENF Comments, <br>\
                                                                                                        and do nothing else. <br><br>\
                                                                                                        CAUTION: If you have alternated 'Prepend' with 'Append' for the <br>\
                                                                                                        Location of the updated ENF Comments, and if a book previously had <br>\
                                                                                                        'Real Comments', then the 'Real Comments' would become layered<br>\
                                                                                                        between the Prepended ENF Comments and the Appended ENF Comments.  <br>\
                                                                                                        Checking this 'Remove Previous ENF Comments' box for those books <br>\
                                                                                                        would result in everything between the Prepended and<br>\
                                                                                                        Appended ENF Comments to be removed too.  <br><br>\
                                                                                                        For that reason, and to avoid this occurring, you should normally check <br>\
                                                                                                        the box above named 'Remove Previous ENF Comments First?'.  <br>\
                                                                                                        So, if you Prepended in the previous job, and now want to Append, <br>\
                                                                                                        the job will remove the Prepended ENF Comments before adding <br>\
                                                                                                        the new Appended ENF Comments.<br><br>\
                                                                                                        If your books have no 'Real Comments', and you are using ENF<br>\
                                                                                                        to create them, then this option is moot.")
        self.other2_checkbox_layout.addWidget(self.remove_previous_enf_comments_checkbox)

        if prefs['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] == unicode("True"):
            self.remove_previous_enf_comments_checkbox.setChecked(True)

        self.remove_previous_enf_comments_checkbox.clicked.connect(self.event_uncheck_all_update_action_checkboxes)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.accumulation_checkbox_groupbox = QGroupBox('Continuous Accumulation of Most Frequent Word Frequencies:')
        self.accumulation_checkbox_groupbox.setToolTip("<p style='white-space:nowrap'>Options to control whether or not you wish to accumulate <br>\
                                                                                        the 'Most Frequent Words' for all books in your Libraries.")
        self.layout_frame.addWidget(self.accumulation_checkbox_groupbox)

        self.other3_checkbox_layout = QVBoxLayout()
        self.other3_checkbox_layout.setAlignment(Qt.AlignLeft)
        self.accumulation_checkbox_groupbox.setLayout(self.other3_checkbox_layout)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.other4_checkbox_layout = QHBoxLayout()
        self.other4_checkbox_layout.setAlignment(Qt.AlignLeft)
        self.other3_checkbox_layout.addLayout(self.other4_checkbox_layout)

        self.save_aggregate_most_frequent_checkbox = QCheckBox("Accumulate?")
        self.save_aggregate_most_frequent_checkbox.setToolTip("<p style='white-space:nowrap'>This activates an interesting and powerful feature.  <br><br>\
                                                                                                    If you wish to accumulate the 'Most Frequent Words' <br>\
                                                                                                    for all books in your Library or Libraries, then checking this <br>\
                                                                                                    option will do so.  <br><br>\
                                                                                                    A spreadsheet .csv file for your personal use will be created <br>\
                                                                                                    with an inception-to-date Frequency Count for the union of <br>\
                                                                                                    all Most Frequent Words for all books.  <br><br>\
                                                                                                    This spreadsheet .csv file is pre-sorted by Frequency Count then Word <br>\
                                                                                                    to provide an interesting snapshot of the overall contents of your Libraries. <br><br>\
                                                                                                    CAUTION:  the accumulated results are at the Calibre User Name level, <br>\
                                                                                                    not the Calibre Library level, so temporarily switching Libraries will cause the <br>\
                                                                                                    identical accumulation files to continue to be updated unless you 'Pause' the accumulation.")
        self.other4_checkbox_layout.addWidget(self.save_aggregate_most_frequent_checkbox)

        if prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE'] == unicode("True"):
            self.save_aggregate_most_frequent_checkbox.setChecked(True)

        self.select_file_fullpath_button = QPushButton(" ", self)
        self.select_file_fullpath_button.setText("Select Folder")
        self.select_file_fullpath_button.setToolTip("<p style='white-space:nowrap'>Select the directory where you would like your personal <br>\
                                                                            spreadsheet .csv file of accumulated frequencies by word saved. <br><br>\
                                                                            You may easily change this location in the future, as ENF would <br>\
                                                                            then simply save the latest accumulated frequencies to a new .csv in the new location. <br><br>\
                                                                            ENF itself does not use this spreadsheet .csv file at all.  <br>\
                                                                            It stores the 'real' accumulated frequencies elsewhere.  <br>\
                                                                            The .csv file is for your personal use to do with as you wish.")
        self.select_file_fullpath_button.clicked.connect(self.choose_accumulated_most_common_words_csv_file)
        self.select_file_fullpath_button.setFont(font)
        self.other4_checkbox_layout.addWidget(self.select_file_fullpath_button)

        #-----------------------------------------------------------------------------------------------------------
        global  windows_user_name

        if iswindows:
            windows_user_name = get_windows_username()
            if DEBUG: print("windows_user_name",windows_user_name)
            default_windows_user_app_csv_data_path = str("C:/Users/[WINDOWSUSERNAME]/AppData/Roaming/calibre/plugins/enf_files/accumulated_most_frequent_nouns.csv")
            s = prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']
            default = str("[WINDOWSUSERNAME]")
            if s.count(default) > 0:
                default_windows_user_app_csv_data_path = default_windows_user_app_csv_data_path.replace(default, windows_user_name)
                save_directory = unicode(default_windows_user_app_csv_data_path)
            else:
                save_directory = prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']
        else:
            save_directory = prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']

        font.setPointSize(6)
        font.setBold(True)
        self.save_aggregate_most_frequent_csv_file_full_path = QLabel()
        self.save_aggregate_most_frequent_csv_file_full_path.setTextFormat(0)
        self.save_aggregate_most_frequent_csv_file_full_path.setText(save_directory)    # This is the ONLY directory the user gets to choose, and it is ONLY for the .csv file.  ALL  other files go in:  calibre/plugins/enf_files/...
        self.save_aggregate_most_frequent_csv_file_full_path.setFont(font)
        self.save_aggregate_most_frequent_csv_file_full_path.setToolTip("<p style='white-space:nowrap'>Select the directory where you would like your personal <br>\
                                                                                                                spreadsheet .csv file of accumulated frequencies by word saved. <br><br>\
                                                                                                                You may easily change this location in the future, as ENF would <br>\
                                                                                                                then simply save the latest accumulated frequencies to <br>\
                                                                                                                a new .csv in the new location. <br><br>\
                                                                                                                ENF itself does not use this spreadsheet .csv file at all. <br>\
                                                                                                                It stores the 'real' accumulated frequencies elsewhere.  <br>\
                                                                                                                The .csv file is only for your personal use to do with as you wish.")
        self.other4_checkbox_layout.addWidget(self.save_aggregate_most_frequent_csv_file_full_path)
        font.setPointSize(8)
        font.setBold(False)
        #-----------------------------------------------------------------------------------------------------------
        self.pause_aggregate_most_frequent_checkbox = QCheckBox("Pause Accumulation While Some Books are 'Reprocessed'?   Pause is only for the next execution.")
        self.pause_aggregate_most_frequent_checkbox.setToolTip("<p style='white-space:nowrap'>Pausing the accumulation is prudent if you do not wish to <br>\
                                                                                                        contaminate the inception-to-date accumulated frequencies <br>\
                                                                                                        with 'bad data' derived from running ENF in Calibre Libraries <br>\
                                                                                                        that contain books of dubious quality, or if you wish to 'rerun' <br>\
                                                                                                        previously updated books because (for example), you wish <br>\
                                                                                                        to change the 'maximum' number of created Tags from the <br>\
                                                                                                        previously used number to a different number.")
        self.other3_checkbox_layout.addWidget(self.pause_aggregate_most_frequent_checkbox)
        self.pause_aggregate_most_frequent_checkbox.setChecked(False)   # this is not a saved parameter, and is always set to False.  Temporary flag good for the first next execution only.

        self.other5_pushbutton_layout = QHBoxLayout()
        self.other5_pushbutton_layout.setAlignment(Qt.AlignLeft)
        self.other3_checkbox_layout.addLayout(self.other5_pushbutton_layout)

        self.show_only_csv_accumulated_file_button = QPushButton(" ", self)
        self.show_only_csv_accumulated_file_button.setText("Show Personal Accumulation .csv File?")
        self.show_only_csv_accumulated_file_button.setToolTip("<p style='white-space:nowrap'>Opens the directory where your personal <br>\
                                                                                                    spreadsheet .csv file is currently located.")
        self.show_only_csv_accumulated_file_button.clicked.connect(self.show_only_csv_accumulated_frequencies_file)
        self.show_only_csv_accumulated_file_button.setFont(font)
        self.show_only_csv_accumulated_file_button.setMaximumWidth(200)
        self.other5_pushbutton_layout.addWidget(self.show_only_csv_accumulated_file_button)

        font.setPointSize(6)
        font.setBold(True)
        self.purge_all_aggregation_files_button = QPushButton(" ", self)
        self.purge_all_aggregation_files_button.setText("Purge All Accumulation Files, including Backups?")
        self.purge_all_aggregation_files_button.setToolTip("<p style='white-space:nowrap'>This option allows you to 'start fresh' with the accumulation <br>\
                                                                                            of word frequencies if you wish to do so.<br><br>\
                                                                                            This is useful for users who wish to experiment.")
        self.purge_all_aggregation_files_button.clicked.connect(self.purge_all_accumulated_frequencies_files)
        self.purge_all_aggregation_files_button.setFont(font)
        self.purge_all_aggregation_files_button.setMaximumWidth(200)
        self.other5_pushbutton_layout.addWidget(self.purge_all_aggregation_files_button)

        font.setPointSize(8)
        font.setBold(False)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------


        global param_dict

        param_dict.clear()

        param_dict['COMMENTS_MAX'] = prefs['COMMENTS_MAX']
        param_dict['TAGS_MAX']  = prefs['TAGS_MAX']
        param_dict['CUSTOM_COLUMN_MAX'] = prefs['CUSTOM_COLUMN_MAX']

        param_dict['COMMENTS_PREPEND_APPEND_REPLACE'] = prefs['COMMENTS_PREPEND_APPEND_REPLACE']
        param_dict['COMMENTS_CHECKBOX'] = prefs['COMMENTS_CHECKBOX']

        param_dict['TAGS_CHECKBOX'] = prefs['TAGS_CHECKBOX']
        param_dict['TAGS_REPLACE_ADD'] = prefs['TAGS_REPLACE_ADD']

        param_dict['CUSTOM_COLUMN_CHECKBOX'] = prefs['CUSTOM_COLUMN_CHECKBOX']
        param_dict['CUSTOM_COLUMN_NAME'] = prefs['CUSTOM_COLUMN_NAME']
        param_dict['CUSTOM_COLUMN_SORT_ALPHA'] = prefs['CUSTOM_COLUMN_SORT_ALPHA']

        param_dict['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] = prefs['OTHER_CHECKBOX_ONLY_LOG_COMMENTS']

        param_dict['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = prefs['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX']

        param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE']  = prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE']
        param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']  = prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']
        param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE_PAUSE']  = unicode("False") #does not use saved prefs; always initializes as False.

        param_dict['REMOVE_GLOBAL_FIRST_NAMES'] = prefs['REMOVE_GLOBAL_FIRST_NAMES']
        param_dict['REMOVE_TOP_100_NOUNS'] = prefs['REMOVE_TOP_100_NOUNS']

        param_dict['OBFUSCATE_OBSCENITIES'] = prefs['OBFUSCATE_OBSCENITIES']

        param_dict['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] = prefs['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE']
        param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'] = prefs['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE']
        param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'] = prefs['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE']

    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    # EVENTS
    #-----------------------------------------------------------------------------------------------
    def event_uncheck_all_update_action_checkboxes(self,event):
        # If any of the "no update" checkboxes are checked, then no "update" checkboxes may continue to be checked.

        if  self.update_log_only_checkbox.isChecked():
            self.create_comments_checkbox.setChecked(False)
            self.create_tags_checkbox.setChecked(False)
            self.update_custom_column_checkbox.setChecked(False)
            return

        if  self.remove_previous_enf_comments_checkbox.isChecked():
            self.create_comments_checkbox.setChecked(False)
            self.create_tags_checkbox.setChecked(False)
            self.update_custom_column_checkbox.setChecked(False)
            return

        if (not self.remove_previous_enf_comments_checkbox.isChecked()) and (not self.update_log_only_checkbox.isChecked()):
            self.create_comments_checkbox.setChecked(True)

    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    # OTHER
    #-----------------------------------------------------------------------------------------------
    def build_dict(self):

        global param_dict

        param_dict.clear()
    #--------------------------------
    #--------------------------------
        value1 = self.spin_1.value()
        value2 = self.spin_2.value()
        value3 = self.spin_3.value()

        param_dict['COMMENTS_MAX'] = unicode(value1)
        param_dict['TAGS_MAX']  = unicode(value2)
        param_dict['CUSTOM_COLUMN_MAX'] = unicode(value3)
    #--------------------------------
    #--------------------------------
        if self.prepend_radio.isChecked():
            value4 = unicode('prepend')
        else:
            if self.append_radio.isChecked():
                value4 = unicode('append')
            else:
                value4 = unicode('replace')

        param_dict['COMMENTS_PREPEND_APPEND_REPLACE'] = unicode(value4)
    #--------------------------------
        if self.create_comments_checkbox.isChecked():
            value5 = unicode('True')
        else:
            value5 = unicode('False')

        param_dict['COMMENTS_CHECKBOX'] = unicode(value5)
    #--------------------------------
        if self.comments_remove_previous_checkbox.isChecked():
            value5a = unicode('True')
        else:
            value5a = unicode('False')

        param_dict['COMMENTS_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode(value5a)

    #--------------------------------
    #--------------------------------
        if self.create_tags_checkbox.isChecked():
            value6 = unicode('True')
        else:
            value6 = unicode('False')

        param_dict['TAGS_CHECKBOX'] = unicode(value6)
    #--------------------------------
        if self.add_radio.isChecked():
            value6a = unicode('add')
        else:
            value6a = unicode('replace')

        param_dict['TAGS_REPLACE_ADD'] = unicode(value6a)
    #--------------------------------
    #--------------------------------
        if self.update_custom_column_checkbox.isChecked():
            value7 = unicode('True')
        else:
            value7 = unicode('False')

        param_dict['CUSTOM_COLUMN_CHECKBOX'] = unicode(value7)
    #--------------------------------
        value8 = unicode(self.custom_column.text())
        param_dict['CUSTOM_COLUMN_NAME'] = unicode(value8)
    #--------------------------------
    #--------------------------------
        if self.sort_custom_column_checkbox.isChecked():
            value9 = unicode('True')
        else:
            value9 = unicode('False')

        param_dict['CUSTOM_COLUMN_SORT_ALPHA'] = unicode(value9)
    #--------------------------------
    #--------------------------------
    #--------------------------------
    #--------------------------------
        if self.remove_english_first_names_checkbox.isChecked():
            value10a = unicode('True')
        else:
            value10a = unicode('False')

        param_dict['REMOVE_GLOBAL_FIRST_NAMES'] = unicode(value10a)


        if self.obfuscate_obscenities_checkbox.isChecked():
            value10c = unicode('True')
        else:
            value10c = unicode('False')

        param_dict['OBFUSCATE_OBSCENITIES'] = unicode(value10c)



        if self.remove_top_100_nouns_checkbox.isChecked():
            value10b = unicode('True')
        else:
            value10b = unicode('False')

        param_dict['REMOVE_TOP_100_NOUNS'] = unicode(value10b)



        if self.translate_english_to_other_is_active_checkbox.isChecked():
            param_dict['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] = unicode('True')
            param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'] = unicode(self.translate_english_to_other_language_combobox.currentText())
        else:
            param_dict['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] = unicode('False')
            param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'] = unicode("none")

        param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'] = unicode(self.user_custom_translation_dictionary_full_path_button.text())




        if self.update_log_only_checkbox.isChecked():
            value10 = unicode('True')
        else:
            value10 = unicode('False')

        param_dict['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] = unicode(value10)

        if self.remove_previous_enf_comments_checkbox.isChecked():
            value11 = unicode('True')
        else:
            value11 = unicode('False')

        param_dict['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode(value11)
    #--------------------------------
    #--------------------------------
    #--------------------------------
    #--------------------------------
        if self.save_aggregate_most_frequent_checkbox.isChecked():
            value14 = unicode('True')
        else:
            value14 = unicode('False')

        param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE'] = unicode(value14)

        value15 = self.save_aggregate_most_frequent_csv_file_full_path.text()
        param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH'] = unicode(value15)

        if self.pause_aggregate_most_frequent_checkbox.isChecked():
            value16 = unicode('True')
        else:
            value16 = unicode('False')

        param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE_PAUSE'] = unicode(value16)

    #--------------------------------
    #--------------------------------
    # Save prefs using param_dict
    #--------------------------------
    #--------------------------------
        prefs['COMMENTS_MAX'] = unicode(param_dict['COMMENTS_MAX'])
        prefs['COMMENTS_CHECKBOX'] = unicode(param_dict['COMMENTS_CHECKBOX'])
        prefs['COMMENTS_PREPEND_APPEND_REPLACE'] = unicode(param_dict['COMMENTS_PREPEND_APPEND_REPLACE'])
        prefs['COMMENTS_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode(param_dict['COMMENTS_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'])

        prefs['TAGS_MAX']  = unicode(param_dict['TAGS_MAX'])
        prefs['TAGS_CHECKBOX'] = unicode(param_dict['TAGS_CHECKBOX'])
        prefs['TAGS_REPLACE_ADD'] = unicode(param_dict['TAGS_REPLACE_ADD'])

        prefs['CUSTOM_COLUMN_MAX'] = unicode(param_dict['CUSTOM_COLUMN_MAX'])
        prefs['CUSTOM_COLUMN_CHECKBOX'] = unicode(param_dict['CUSTOM_COLUMN_CHECKBOX'])
        prefs['CUSTOM_COLUMN_NAME'] = unicode(param_dict['CUSTOM_COLUMN_NAME'])
        prefs['CUSTOM_COLUMN_SORT_ALPHA'] = unicode(param_dict['CUSTOM_COLUMN_SORT_ALPHA'])

        prefs['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] = unicode(param_dict['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'])
        prefs['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode(param_dict['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'])

        prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE']    =  unicode(param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE'])
        prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']  =  unicode(param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH'])
        prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE_PAUSE'] = unicode("False")  # this flag is valid for only a single execution, and is not saved as a pref for later use.

        prefs['REMOVE_GLOBAL_FIRST_NAMES'] = unicode(param_dict['REMOVE_GLOBAL_FIRST_NAMES'])
        prefs['REMOVE_TOP_100_NOUNS'] = unicode(param_dict['REMOVE_TOP_100_NOUNS'])

        prefs['OBFUSCATE_OBSCENITIES'] = unicode(param_dict['OBFUSCATE_OBSCENITIES'])

        prefs['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] = unicode(param_dict['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'])
        prefs['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'] = unicode(param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'])
        prefs['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'] = unicode(param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'])

        prefs    #save each time param_dict is built
    #--------------------------------
    #-----------------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------------
    def choose_accumulated_most_common_words_csv_file(self):

        global param_dict
        global user_csv_file_directory

        self.build_csv_file_default_path()

        directory_name = self.choose_csv_file_filedialog()
        if not directory_name:
            directory_name = user_csv_file_directory   # the default directory based on os
            return
        else:
            accumulated_csv_file_full_path = os.path.join(directory_name,ACCUMULATED_MOST_FREQUENT_NOUNS_CSV_FILENAME)
            accumulated_csv_file_full_path = accumulated_csv_file_full_path.replace(os.sep, '/')
            accumulated_csv_file_full_path = accumulated_csv_file_full_path.decode(filesystem_encoding)
            self.save_aggregate_most_frequent_csv_file_full_path.setText(accumulated_csv_file_full_path)
            param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH'] = unicode(accumulated_csv_file_full_path)
            prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH'] = unicode(accumulated_csv_file_full_path)

    #--------------------------------------------------------------------------------------------------
    def build_csv_file_default_path(self):

        global my_plugin_path
        global user_csv_file_directory

        s = prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']

        if s == unicode("/"):  #from prefs.defaults       user has not done this before...
            if iswindows:
                self.user_csv_file_directory = os.path.expanduser('~/Desktop')
                user_csv_file_directory = self.user_csv_file_directory
            else:
                if isosx:
                    self.user_csv_file_directory = os.path.expanduser('~/Desktop')
                    user_csv_file_directory = self.user_csv_file_directory
                else:
                    try:
                        home_directory = os.getenv("HOME", 'unknown')
                    except:
                        home_directory = "unknown"
                    if home_directory:
                        if home_directory <> "unknown":
                            self.user_csv_file_directory = home_directory
                            user_csv_file_directory = self.user_csv_file_directory
                        else:
                            self.user_csv_file_directory = "/"
                            user_csv_file_directory = self.user_csv_file_directory
                    else:
                        self.user_csv_file_directory = "/"
                        user_csv_file_directory = self.user_csv_file_directory
            accumulated_csv_file_full_path = os.path.join(user_csv_file_directory,ACCUMULATED_MOST_FREQUENT_NOUNS_CSV_FILENAME)
            accumulated_csv_file_full_path = accumulated_csv_file_full_path.replace(os.sep, '/')
            accumulated_csv_file_full_path = accumulated_csv_file_full_path.decode(filesystem_encoding)
            self.save_aggregate_most_frequent_csv_file_full_path.setText(accumulated_csv_file_full_path)
            prefs['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH'] = unicode(accumulated_csv_file_full_path)
            param_dict['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH'] = unicode(accumulated_csv_file_full_path)
        else:
            return

    #-----------------------------------------------------------------------------------------------
    def choose_csv_file_filedialog(self):

        default_user_csv_directory =  self.save_aggregate_most_frequent_csv_file_full_path.text()         # first time, built by:  self.build_csv_file_default_path()
        default_user_csv_directory = default_user_csv_directory.replace(ACCUMULATED_MOST_FREQUENT_NOUNS_CSV_FILENAME,"")

        title = "Choose the Directory for your personal .csv file to store the 'Accumulated Frequencies of Most Common Words' "

        chosen_directory_name = QFileDialog.getExistingDirectory(None,title,default_user_csv_directory,QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks )

        return chosen_directory_name

#--------------------------------------------------------------------------------------------------
    def purge_all_accumulated_frequencies_files(self):

        if not question_dialog(self.gui, _('Purge All Accumulation Files, Including Backups?'),_('Purge All of the files?  Are you sure?')) :
            self.purge_all_aggregation_files_button.setText('Purge All Accumulation Files, Including Backups?')
            return info_dialog(self.gui, 'Purge Has Been Canceled','Purge Canceled').show()
        else:

            # the .csv file may or may not be in a user-selected, random directory. it may be in its *default* directory, which is the same as the protected_data_directory.  or not.
            s_filename_csv = self.save_aggregate_most_frequent_csv_file_full_path.text()
            if os.path.exists(s_filename_csv):
                os.remove(s_filename_csv)
                if DEBUG: print("file has been removed: ", s_filename_csv)

            # the other files are ALWAYS in:  calibre/plugins/enf_files/..
            full_protected_path = self.build_full_protected_path("tuples")
            s_filename_dict = full_protected_path
            s_filename_dict_backup_1 = s_filename_dict.replace(".tuples",".backup1")
            s_filename_dict_backup_2 = s_filename_dict.replace(".tuples",".backup2")
            if os.path.exists(s_filename_dict):
                os.remove(s_filename_dict)
                if DEBUG: print("file has been removed: ", s_filename_dict)
            if os.path.exists(s_filename_dict_backup_1):
                os.remove(s_filename_dict_backup_1)
                if DEBUG: print("file has been removed: ", s_filename_dict_backup_1)
            if os.path.exists(s_filename_dict_backup_2):
                os.remove(s_filename_dict_backup_2)
                if DEBUG: print("file has been removed: ", s_filename_dict_backup_2)

            self.purge_all_aggregation_files_button.hide()

    #-----------------------------------------------------------------------------------------------
    def show_only_csv_accumulated_frequencies_file(self):

        path = self.save_aggregate_most_frequent_csv_file_full_path.text()
        path = path.encode("ascii","strict")
        path = str(path)
        path = path.replace(ACCUMULATED_MOST_FREQUENT_NOUNS_CSV_FILENAME,"")
        if path.endswith("/"):
            path = path[0:-1]
        path = path.replace(os.sep,"/")
        path = path.decode(filesystem_encoding)

        if DEBUG: print("ACCUMULATED_MOST_FREQUENT_NOUNS_CSV   currently chosen directory is: ",path)

        try:
            if platform.system() == "Windows":
                os.startfile(path)
            elif platform.system() == "Darwin":
                subprocess.Popen(["open", path])
            else:
                subprocess.Popen(["xdg-open", path])
        except Exception as e:
            msg = 'Python Code by Supported OS:  [Windows = os.startfile(path)] <br> [Darwin = subprocess.Popen(["open", path])] <br> [Linux = subprocess.Popen(["xdg-open", path])] \
                        <br> Please Private Message the developer, DaltonST, <br> with the correct Python for your OS via mobileread.com, <br> and it will be fixed for the next release. <br>\
                         Sorry, but DaltonST only has Win10 for development and testing. Thanks in advance for submitting the correct Python for your OS.'
            msg = msg + " <br> Your specific exception message was: " + str(e)
            return info_dialog(self.gui, 'The OS-specific Python Code for Your OS Failed',msg).show()

    #-----------------------------------------------------------------------------------------------
    def build_full_protected_path(self,selection):

        global protected_data_directory

        self.build_protected_subdirectory_path()

        if selection == "tuples":
            file_name = ACCUMULATED_MOST_FREQUENT_NOUNS_TUPLES_FILENAME
            file_name.encode("ascii", "strict")
            file_name = str(file_name)
            file_name = file_name.decode(filesystem_encoding)
            full_protected_path = os.path.join(protected_data_directory, file_name )       #   /calibre/plugins/enf_files/
            full_protected_path = full_protected_path.replace(os.sep, '/')

            if DEBUG: print("ACCUMULATED_MOST_FREQUENT_NOUNS_TUPLES full protected path is: ",full_protected_path)

            return  full_protected_path

        else:
            return  None

    #--------------------------------------------------------------------------------------------------
    def build_protected_subdirectory_path(self):
        # ALWAYS the identical subdirectory as the .html files:           #  /calibre/plugins/enf_files/

        global protected_data_directory

        self.protected_data_path = self.my_plugin_path
        self.protected_data_path = self.protected_data_path.replace("\English Noun Frequency.zip", "")
        self.protected_data_path = self.protected_data_path.replace("/English Noun Frequency.zip", "")

        self.protected_data_directory = self.protected_data_path

        sub_directory = str("enf_files")
        sub_directory = sub_directory.decode(filesystem_encoding)

        self.protected_data_directory =  os.path.join(self.protected_data_directory, sub_directory)

        self.protected_data_directory.encode("ascii", "strict")

        self.protected_data_directory = str(self.protected_data_directory)

        self.protected_data_directory = self.protected_data_directory.decode(filesystem_encoding)

        self.protected_data_directory = self.protected_data_directory.replace(os.sep, '/')         #   /calibre/plugins/enf_files

        if not os.path.exists(self.protected_data_directory):
            os.makedirs(self.protected_data_directory)

        protected_data_directory = self.protected_data_directory

        if DEBUG: print("protected_data_directory: ",protected_data_directory)

    #--------------------------------------------------------------------------------------------------
    def get_full_file_path_for_custom_translation_dictionary_to_use(self):

        dialog = QFileDialog(self)
        dialog.setWindowTitle("Select User Custom UTF8-Encoded 'English:Spanish Pairs' Text File")
        dialog.setNameFilter('Text (*.txt *.text *.csv)')
        dialog.setFileMode(QFileDialog.ExistingFile)
        if dialog.exec_() == QDialog.Accepted:
            filename = dialog.selectedFiles()[0]
        else:
            filename = "Select Custom Translation File"

        self.user_custom_translation_dictionary_full_path_button.setText(filename)

        param_dict['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'] = unicode(filename)

#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class ENFUserListsTab_A(QWidget):
    def __init__(self,gui,icon,guidb,my_plugin_path):
        super(ENFUserListsTab_A, self).__init__()

        #-----------------------------------------------------
        self.gui = gui
        self.guidb = guidb
        self.my_plugin_path = my_plugin_path
        self.user_protected_data_directory = "unknown"
        #-----------------------------------------------------
        self.good_words_already_loaded = False
        self.bad_words_already_loaded = False
        #-----------------------------------------------------
        self.my_saved_good_words_crossheck_list =  []
        self.my_saved_bad_words_crossheck_list = []
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)

        heading_font = QFont()
        heading_font.setBold(False)
        heading_font.setPointSize(9)

        self.text_font = QFont()
        self.text_font.setBold(True)
        self.text_font.setPointSize(14)

        self.text_medium_font = QFont()
        self.text_medium_font.setBold(True)
        self.text_medium_font.setPointSize(8)
        self.text_medium_font_minimum_length = 20

        self.text_long_font = QFont()
        self.text_long_font.setBold(True)
        self.text_long_font.setPointSize(7)
        self.text_long_font_minimum_length = 30
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.user_data_a_layout = QGridLayout()
        self.user_data_a_layout.setSpacing(0)
        self.user_data_a_layout.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.user_data_a_layout)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.user_good_words_qlist_layout = QVBoxLayout()
        self.user_good_words_qlist_layout.setAlignment(Qt.AlignCenter)

        self.good_words_groupbox_title_literal =  "                    'Good' Words to Not Delete"
        self.good_words_groupbox_title_full = self.good_words_groupbox_title_literal + " [0]"
        self.user_good_words_groupbox = QGroupBox(self.good_words_groupbox_title_full)
        self.user_good_words_groupbox.setAlignment(Qt.AlignCenter)
        self.user_good_words_groupbox.setFont(heading_font)
        self.user_data_a_layout.addWidget(self.user_good_words_groupbox,4,1)

        self.user_good_words_groupbox.setLayout(self.user_good_words_qlist_layout)

        self.user_good_words_qlist = QListWidget()
        self.user_good_words_qlist.setToolTip("<p style='white-space:nowrap'>User Custom Word Rules for 'Good' Words supplement <br>\
                                                                        and/or override the Standard Word Rules.  <br><br>\
                                                                        EXAMPLE:  A Standard Word Rule says that  Word1 is 'bad', <br>\
                                                                        and will always discard it.  However, suppose you never want <br>\
                                                                        Word1 to be discarded.  You consider it a 'good' word. <br>\
                                                                        To do so, you simply create a Custom Word Rule for Word1 <br>\
                                                                        in the 'Good Words' column.  Your Custom Word Rules will <br>\
                                                                        always override any Standard Word Rules for the identical word.<br><br>\
                                                                        IMPORTANT: when you add your custom 'Good Words', be sure <br>\
                                                                        to also add a custom 'Plural Pair' for the same word so that ENF <br>\
                                                                        will be sure to change their plurals to the correct singulars so that <br>\
                                                                        the sum of both forms will be consolidated on one (1) line, <br>\
                                                                        that of the singular form.<br><br>\
                                                                        All 'standard' 'Good Words' already have a standard 'Plural Pair'.<br><br>\
                                                                        A special ENF 'English Grammar Engine' will try to reverse-engineer any plural<br>\
                                                                        that is not in either the standard 'Plural Pair' list or the custom 'Plural Pair' list,<br>\
                                                                        but it is limited to words it knows or words that are not 'irregular'.")
        self.user_good_words_qlist.setFont(font)
        self.user_good_words_qlist_layout.addWidget(self.user_good_words_qlist)
        self.user_good_words_qlist.setSortingEnabled(True)

        #-----
        self.good_words_buttonbox = QDialogButtonBox()
        self.good_words_buttonbox.setOrientation(Qt.Horizontal)
        self.good_words_buttonbox.setCenterButtons(True)

        self.user_good_words_qlist_layout.addWidget(self.good_words_buttonbox,1)

        self.add_item_good_words_push_button = QPushButton(" ", self)
        self.add_item_good_words_push_button.setText("Add Word")
        self.add_item_good_words_push_button.setToolTip("Adds a new 'Good Word' placeholder that you then must change, but does not save the placeholder.")
        self.add_item_good_words_push_button.clicked.connect(self.add_item_good_words)
        self.add_item_good_words_push_button.setFont(font)
        self.good_words_buttonbox.addButton(self.add_item_good_words_push_button,0)

        self.delete_item_good_words_push_button = QPushButton(" ", self)
        self.delete_item_good_words_push_button.setText("Delete Word")
        self.delete_item_good_words_push_button.setToolTip("Deletes the currently selected 'Good Word', but does not save the changed list.")
        self.delete_item_good_words_push_button.clicked.connect(self.delete_item_good_words)
        self.delete_item_good_words_push_button.setFont(font)
        self.good_words_buttonbox.addButton(self.delete_item_good_words_push_button,0)

        self.purge_all_good_words_push_button = QPushButton(" ", self)
        self.purge_all_good_words_push_button.setText("Purge All")
        self.purge_all_good_words_push_button.setToolTip("Deletes all of the current 'Good Words', and immediately saves the empty list.")
        self.purge_all_good_words_push_button.clicked.connect(self.purge_all_good_words)
        self.purge_all_good_words_push_button.setFont(font)
        self.good_words_buttonbox.addButton(self.purge_all_good_words_push_button,0)
        #-----

        self.save_good_words_push_button = QPushButton(" ", self)
        self.save_good_words_push_button.setText("Save && Validate")
        self.save_good_words_push_button.setToolTip("Saves the current 'Good Words', then cross-checks them with the 'Bad Words'.")
        self.save_good_words_push_button.clicked.connect(self.save_good_words)
        self.save_good_words_push_button.setFont(font)
        self.user_good_words_qlist_layout.addWidget(self.save_good_words_push_button,0)

        #-----
        self.validate_good_words_push_button = QPushButton(" ", self)
        self.validate_good_words_push_button.setText("Cross-check 'Good' with 'Bad'")
        self.validate_good_words_push_button.setToolTip("<p style='white-space:wrap'>Good' Words should not ever be identical to 'Bad' Words. \
                                                                                            It is not possible to say 'keep it' and also say 'discard it'.<br><br>\
                                                                                            This function cross-checks the 'Good' Words against the 'Bad' Words, \
                                                                                            and changes the color of any conflicting words. \
                                                                                            You then need to delete one of the Word Rules.<br><br>\
                                                                                            IMPORTANT:  the Custom Rules for Pairs in the next Tab are also \
                                                                                            cross-checked against the 'Bad' Words for the identical reasons.")
        self.validate_good_words_push_button.clicked.connect(self.save_good_words)
        self.validate_good_words_push_button.setFont(font)
        self.user_good_words_qlist_layout.addWidget(self.validate_good_words_push_button,0)

        #-----
        self.import_good_words_push_button = QPushButton(" ", self)
        self.import_good_words_push_button.setText("Import from a File")
        self.import_good_words_push_button.setToolTip("<p style='white-space:nowrap'>You may import a plain text file to add new 'Good' Word Rules en masse. <br>\
                                                                        The syntax for each line of the plain text file requires that there be no spaces and no punctuation at all. <br>\
                                                                        Use no tabs, and add no spaces.  One condensed single word per line, and then press 'Enter'<br><br>\
                                                                        Each line must have ended with an 'Enter' being pressed by the user creating the plain text file.<br><br>\
                                                                        Every letter of each word will automatically be converted to lower case, so proper capitalization is not useful.<br><br>\
                                                                        Any imported items that do not conform exactly to the above syntax will be discarded.<br>\
                                                                        After import, they will automatically be saved and cross-checked against the 'Bad' Words.")
        self.import_good_words_push_button.clicked.connect(self.import_list_of_good_words)
        self.import_good_words_push_button.setFont(font)
        self.user_good_words_qlist_layout.addWidget(self.import_good_words_push_button,0)


        self.export_good_words_push_button = QPushButton(" ", self)
        self.export_good_words_push_button.setText("Export to a File")
        self.export_good_words_push_button.setToolTip("<p style='white-space:nowrap'>You may export all 'Good' Word Rules to a plain text file for mass editing. <br><br>\
                                                                                    That file will be identical in format to the required format for importing 'Good' Word Rules.<br><br>\
                                                                                    You may import the identical file after editing as long as <br>\
                                                                                    you have adhered to the 'Good' Word import file syntax requirements.")
        self.export_good_words_push_button.clicked.connect(self.export_good_words)
        self.export_good_words_push_button.setFont(font)
        self.user_good_words_qlist_layout.addWidget(self.export_good_words_push_button,0)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.user_bad_words_qlist_layout = QVBoxLayout()
        self.user_bad_words_qlist_layout.setAlignment(Qt.AlignCenter)

        self.bad_words_groupbox_title_literal =  "                       'Bad' Words to Delete"
        self.bad_words_groupbox_title_full = self.bad_words_groupbox_title_literal + " [0]"
        self.user_bad_words_groupbox = QGroupBox(self.bad_words_groupbox_title_full)
        self.user_bad_words_groupbox.setAlignment(Qt.AlignCenter)
        self.user_bad_words_groupbox.setFont(heading_font)
        self.user_data_a_layout.addWidget(self.user_bad_words_groupbox,4,2)
        self.user_bad_words_groupbox.setLayout(self.user_bad_words_qlist_layout)

        self.user_bad_words_qlist = QListWidget()
        self.user_bad_words_qlist.setToolTip("User Custom Word Rules for 'Bad' Words supplement and/or override the Standard Word Rules.  <br><br>\
                                                                        EXAMPLE:  A Standard Word Rule says that  Word1 is 'good', and will always keep it.  However,  \
                                                                        you never want Word1 to be kept.  You consider it a 'bad' word.  So, you simply create a Custom Word Rule \
                                                                        for Word1 in the 'Bad Words' column so it will always be discarded.  <br><br>\
                                                                        Your Custom Word Rules will always override any Standard Word Rules for the identical word.  <br><br>\
                                                                        IMPORTANT: if you create a bad rule for a noun, also create one for its plural.  \
                                                                        Otherwise, after the plural is changed to its singular, the singular will appear again.")
        self.user_bad_words_qlist .setFont(font)
        self.user_bad_words_qlist_layout.addWidget(self.user_bad_words_qlist)
        self.user_bad_words_qlist.setSortingEnabled(True)

        #-----
        self.bad_words_buttonbox = QDialogButtonBox()
        self.bad_words_buttonbox.setOrientation(Qt.Horizontal)
        self.bad_words_buttonbox.setCenterButtons(True)

        self.user_bad_words_qlist_layout.addWidget(self.bad_words_buttonbox,1)

        self.add_item_bad_words_push_button = QPushButton(" ", self)
        self.add_item_bad_words_push_button.setText("Add Word")
        self.add_item_bad_words_push_button.setToolTip("Adds a new 'Bad Word' placeholder that you then must change, but does not save the placeholder.")
        self.add_item_bad_words_push_button.clicked.connect(self.add_item_bad_words)
        self.add_item_bad_words_push_button.setFont(font)
        self.bad_words_buttonbox.addButton(self.add_item_bad_words_push_button,0)

        self.delete_item_bad_words_push_button = QPushButton(" ", self)
        self.delete_item_bad_words_push_button.setText("Delete Word")
        self.delete_item_bad_words_push_button.setToolTip("Deletes the currently selected 'Bad Word', but does not save the changed list.")
        self.delete_item_bad_words_push_button.clicked.connect(self.delete_item_bad_words)
        self.delete_item_bad_words_push_button.setFont(font)
        self.bad_words_buttonbox.addButton(self.delete_item_bad_words_push_button,0)

        self.purge_all_bad_words_push_button = QPushButton(" ", self)
        self.purge_all_bad_words_push_button.setText("Purge All")
        self.purge_all_bad_words_push_button.setToolTip("Deletes all of the current 'Bad Words', and immediately saves the empty list.")
        self.purge_all_bad_words_push_button.clicked.connect(self.purge_all_bad_words)
        self.purge_all_bad_words_push_button.setFont(font)
        self.bad_words_buttonbox.addButton(self.purge_all_bad_words_push_button,0)
        #-----

        self.save_bad_words_push_button = QPushButton(" ", self)
        self.save_bad_words_push_button.setText("Save && Validate")
        self.save_bad_words_push_button.setToolTip("Saves the current 'Bad Words', then cross-checks them with the 'Good Words'.")
        self.save_bad_words_push_button.clicked.connect(self.save_bad_words)
        self.save_bad_words_push_button.setFont(font)
        self.user_bad_words_qlist_layout.addWidget(self.save_bad_words_push_button,0)
        #-----
        self.validate_bad_words_push_button = QPushButton(" ", self)
        self.validate_bad_words_push_button.setText("Cross-check 'Bad' with 'Good'")
        self.validate_bad_words_push_button.setToolTip("<p style='white-space:wrap'>'Bad' Words should not ever be identical to 'Good' Words. \
                                                                                            It is not possible to say 'keep it' simultaneously with 'discard it'.  <br><br>\
                                                                                            This function cross-checks the 'Bad' Words against the 'Good' Words, \
                                                                                            and changes the color of any conflicting words.  You then need to delete one of the Word Rules.")
        self.validate_bad_words_push_button.clicked.connect(self.save_bad_words)
        self.validate_bad_words_push_button.setFont(font)
        self.user_bad_words_qlist_layout.addWidget(self.validate_bad_words_push_button,0)
        #-----
        self.import_bad_words_push_button = QPushButton(" ", self)
        self.import_bad_words_push_button.setText("Import from a File")
        self.import_bad_words_push_button.setToolTip("<p style='white-space:nowrap'>You may import a plain text file to add new 'Bad' Word Rules en masse. <br>\
                                                                        The syntax for each line of the plain text file requires that there be no spaces and no punctuation at all. <br>\
                                                                        Use no tabs, and add no spaces.  One condensed single word per line, and then press 'Enter'.<br><br>\
                                                                        Each line must have ended with an 'Enter' being pressed by the user creating the plain text file.<br><br>\
                                                                        Every letter of each word will automatically be converted to lower case, so proper capitalization is not useful.<br><br>\
                                                                        Any imported items that do not conform exactly to the above syntax will be discarded.<br>\
                                                                        After import, they will automatically be saved and cross-checked against the 'Good' Words.")
        self.import_bad_words_push_button.clicked.connect(self.import_list_of_bad_words)
        self.import_bad_words_push_button.setFont(font)
        self.user_bad_words_qlist_layout.addWidget(self.import_bad_words_push_button,0)

        self.export_bad_words_push_button = QPushButton(" ", self)
        self.export_bad_words_push_button.setText("Export to a File")
        self.export_bad_words_push_button.setToolTip("<p style='white-space:nowrap'>You may export all 'Bad' Word Rules to a plain text file for mass editing. <br><br>\
                                                                                    That file will be identical in format to the required format for importing 'Bad' Word Rules.<br><br>\
                                                                                    You may import the identical file after editing as long as you have adhered to the 'Bad' Word import file syntax requirements.")
        self.export_bad_words_push_button.clicked.connect(self.export_bad_words)
        self.export_bad_words_push_button.setFont(font)
        self.user_bad_words_qlist_layout.addWidget(self.export_bad_words_push_button,0)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------

        self.edit_good_words()    # initial load of the good words     the good words are validated against words that do not exist until the next step, so no errors are possible
        self.save_good_words()   # builds a good:bad cross-validation list to use in edit, then calls edit which will show errors by changing them to red

        self.edit_bad_words()      # initial load of the bad words
        self.save_bad_words()    # builds a good:bad cross-validation list to use in edit, then calls edit which will show errors by changing them to green

        self.save_good_words()  # the good words can be validated properly now that the bad words have already been loaded (and validated since good was already loaded by then)
        self.save_bad_words()    # for Tab B cross-validation to Tab A bad_words
    #-----------------------------------------------------------------------------------------------
    def edit_good_words(self):

        is_valid = True

        selection = "good"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        self.user_good_words_qlist.clear()

        saved_user_good_words = []

        if os.path.exists(user_protected_data_full_path):
            try:
                with open(user_protected_data_full_path, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        line = str(line)
                        line = line.encode("ascii", "strict")
                        saved_user_good_words.append(str(line))
                    f.close()
            except Exception as e:
                saved_user_good_words.append("?:?| ")
        else:
            saved_user_good_words.append("?:?| ")

        saved_user_good_words.sort()
        tmp_list = []
        for word in saved_user_good_words:
            if not "|" in word:
                word = word + "|"
            s_list = word.split("|")
            for row in s_list:
                if row > " ":
                    tmp_list.append(row)

        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)   #no more duplicates
        for row in tmp_list:
            if row > "  ":
                row = row.replace(" ","")
                row = row.strip()
                row = row.lower()
                word = row.encode("ascii","strict")
                word = str(word)
                new_good_words_item = QListWidgetItem(row)
                new_good_words_item.setFlags(new_good_words_item.flags() | Qt.ItemIsEditable)
                if len(row) > self.text_long_font_minimum_length:
                    new_good_words_item.setFont(self.text_long_font)
                else:
                    if len(row) > self.text_medium_font_minimum_length:
                        new_good_words_item.setFont(self.text_medium_font)
                    else:
                        new_good_words_item.setFont(self.text_font)
                if not str(word) in self.my_saved_bad_words_crossheck_list:    # for cross-validation of good & bad to check for overlaps.
                    new_good_words_item.setForeground(Qt.darkGreen)
                else:
                    new_good_words_item.setForeground(Qt.darkBlue)
                    is_valid = False
                self.user_good_words_qlist.addItem(new_good_words_item)                                 #  http://doc.qt.io/qt-5/qqlist.html
                del new_good_words_item

        try:
            del saved_user_good_words
            del tmp_list
            del s_list
            del tmp_set
            del user_protected_data_full_path
            del f
        except:
            pass

        self.good_words_already_loaded = True

        return is_valid

    #-----------------------------------------------------------------------------------------------
    def add_item_good_words(self):

        new_good_words_item = QListWidgetItem("?")
        new_good_words_item.setFlags(new_good_words_item.flags() | Qt.ItemIsEditable)
        new_good_words_item.setFont(self.text_font)
        new_good_words_item.setForeground(Qt.darkGreen)
        self.user_good_words_qlist.insertItem(0,new_good_words_item)
        del new_good_words_item

        self.update_good_words_groupbox_title()

    #-----------------------------------------------------------------------------------------------
    def delete_item_good_words(self):
        current_row = self.user_good_words_qlist.currentRow()
        self.user_good_words_qlist.takeItem(current_row)
        self.update_good_words_groupbox_title()

    #-----------------------------------------------------------------------------------------------
    def purge_all_good_words(self):

        if not self.good_words_already_loaded:
            return

        if question_dialog(self.gui, _('Purge All of the Good Words?'),_('Purge All of the Good Words?  Are you sure?')) :
            self.user_good_words_qlist.clear()

        self.update_good_words_groupbox_title()

    #-----------------------------------------------------------------------------------------------
    def save_good_words(self):

        is_valid = False

        if not self.good_words_already_loaded:
            return is_valid

        items = []
        for index in xrange(self.user_good_words_qlist.count()):
             items.append(self.user_good_words_qlist.item(index))
        words_list = [(unicode(i.text()) + "|") for i in items]

        selection = "good"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        my_outfile = open(user_protected_data_full_path, 'w')

        del self.my_saved_good_words_crossheck_list[:]   # clear it

        for word in words_list:
            if word > " ":
                if  not "?" in word:
                    if "|" in word:
                        word = word.lower()
                        word = word.replace(" ", "")
                        word = word.strip()
                        if len(word) > 1:
                            word = word.encode("ascii","strict")
                            my_outfile.write(word)  # keeps the |
                            word = word.replace("|", "")
                            self.my_saved_good_words_crossheck_list.append(str(word))          # for cross-validation of good & bad to check for overlaps.
        my_outfile.close()

        del items
        del words_list
        del my_outfile
        del user_protected_data_full_path

        self.good_words_already_loaded = True

        is_valid = self.edit_good_words()   #reload the saved list, resorted and with no duplicates

        self.update_good_words_groupbox_title()

        return is_valid

    #-----------------------------------------------------------------------------------------------
    def update_good_words_groupbox_title(self):
        n = self.user_good_words_qlist.count()
        n = unicode(n)
        count =  " [" + n + "]"
        self.good_words_groupbox_title_full = self.good_words_groupbox_title_literal + count
        self.user_good_words_groupbox.setTitle(self.good_words_groupbox_title_full)

    #-----------------------------------------------------------------------------------------------
    def import_list_of_good_words(self):

        if iswindows:
            windows_user_name = get_windows_username()
            if DEBUG: print("windows_user_name",windows_user_name)
            s = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']
            if s == unicode("/"):  #prefs.defaults
                s = "C:/Users/[WINDOWSUSERNAME]/Desktop"
                s = s.replace("[WINDOWSUSERNAME]",windows_user_name)
                prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH'] = unicode(s)

        self.import_last_file_path = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_import_list_of_good_words"
        title = "Choose the text file with the list of good words you wish to import"

        if iswindows:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New Good Words",self.import_last_file_path,("Text Files (*.txt *.text)") )
        else:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New Good Words",self.import_last_file_path,("Text Files (*.*)") )

        import_file, dummy = import_tuple

        self.import_last_file_path = import_file

        self.import_last_file_path = import_file

        prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.import_last_file_path)

        prefs

        imported_user_good_words = []

        if os.path.exists(import_file):
            try:
                with open(import_file, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        if line:
                            line = line.encode("ascii", "strict")
                            line = str(line)
                            line = str(line.replace("\r",""))
                            line = str(line.replace("\n",""))
                            line = str(line.replace("\t",""))
                            line = str(line.replace("\v",""))
                            line = str(line.replace(" ",""))
                            if not line.isalpha():
                                continue
                            else:
                                imported_user_good_words.append(str(line))
                                continue
                        else:
                            continue
                    #END FOR
                #END WITH
                f.close()
                del import_file
            except Exception as e:
                return
        else:
            return

        imported_user_good_words.sort()
        tmp_list = []
        for word in imported_user_good_words:
            if word:
                if word > " ":
                    if word.isalpha():
                        word = str(word)
                        word = str(word.replace(" ",""))
                        word = str(word.strip())
                        word = str(word.lower())
                        tmp_list.append(str(word))
                    else:
                        continue
                else:
                    continue
            else:
                continue
        #END FOR
        del imported_user_good_words

        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)   #no more duplicates
        del tmp_set

        tmp_list.sort()
        for row in tmp_list:
            row = row.encode("ascii","strict")
            row = str(row)
            row = row.decode("utf8")
            new_good_words_item = QListWidgetItem("dummy")
            value =  new_good_words_item.text()
            new_good_words_item.setText(row)
            value =  new_good_words_item.text()
            new_good_words_item.setFlags(new_good_words_item.flags() | Qt.ItemIsEditable)
            new_good_words_item.setFont(self.text_font)
            new_good_words_item.setForeground(Qt.darkMagenta)
            self.user_good_words_qlist.insertItem(0,new_good_words_item)
            value =  new_good_words_item.text()
        #END FOR

        self.good_words_already_loaded = True

        is_valid = self.save_good_words()

    #-----------------------------------------------------------------------------------------------
    def export_good_words(self):
        if iswindows:
            windows_user_name = get_windows_username()
            s = prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']
            if s == unicode("/"):  #prefs.defaults
                s = "C:/Users/[WINDOWSUSERNAME]/Desktop"
                s = s.replace("[WINDOWSUSERNAME]",windows_user_name)
                prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH'] = unicode(s)

        self.export_last_file_path = prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_export_list_of_good_words"
        title = "Choose the text file name that you wish to create or replace"

        tmp_full_path = os.path.join(self.export_last_file_path,'enf_export_good_words.txt')

        export_tuple = QFileDialog.getSaveFileName(self,"export Simple Text File List of New Good Words",tmp_full_path,("Text Files (*.txt *.text *.csv )") )

        export_file, dummy = export_tuple

        if DEBUG: print("export file: ", export_file)

        self.export_last_file_path = export_file

        prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.export_last_file_path)

        prefs

        items = []
        for index in xrange(self.user_good_words_qlist.count()):
            items.append(self.user_good_words_qlist.item(index))
        #END FOR

        words_list = [(unicode(i.text()) + "\n") for i in items]

        del items

        words_string = ""
        for row in words_list:
            words_string = words_string + row

        del words_list

        words_string = words_string.encode("ascii","strict")
        words_string = str(words_string)

        try:
            with open(export_file, 'w') as f:
                f.write(words_string)
            #END WITH
            f.close()
            del export_file
            del words_string
        except Exception as e:
            if DEBUG: print("export file error: ", str(e))
            return

    #-----------------------------------------------------------------------------------------------
    def edit_bad_words(self):

        is_valid = True

        selection = "bad"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        self.user_bad_words_qlist.clear()

        saved_user_bad_words = []

        if os.path.exists(user_protected_data_full_path):
            try:
                with open(user_protected_data_full_path, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        line = str(line)
                        line = line.encode("ascii", "strict")
                        saved_user_bad_words.append(str(line))
                    f.close()
            except Exception as e:
                saved_user_bad_words.append("?:?| ")
        else:
            saved_user_bad_words.append("?:?| ")

        saved_user_bad_words.sort()
        tmp_list = []
        for word in saved_user_bad_words:
            if not "|" in word:
                word = word + "|"
            s_list = word.split("|")
            for row in s_list:
                if row > " ":
                    tmp_list.append(row)

        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)   #no more duplicates
        for row in tmp_list:
            if row > "  ":
                row = row.replace(" ","")
                row = row.strip()
                row = row.lower()
                word = row.encode("ascii","strict")
                word = str(word)
                new_bad_words_item = QListWidgetItem(row)
                new_bad_words_item.setFlags(new_bad_words_item.flags() | Qt.ItemIsEditable)
                if len(row) > self.text_long_font_minimum_length:
                    new_bad_words_item.setFont(self.text_long_font)
                else:
                    if len(row) > self.text_medium_font_minimum_length:
                        new_bad_words_item.setFont(self.text_medium_font)
                    else:
                        new_bad_words_item.setFont(self.text_font)
                if not str(word) in self.my_saved_good_words_crossheck_list:        # for cross-validation of good & bad to check for overlaps.
                    new_bad_words_item.setForeground(Qt.darkRed)
                else:
                    new_bad_words_item.setForeground(Qt.darkBlue)
                    is_valid = False

                self.user_bad_words_qlist.addItem(new_bad_words_item)
                del new_bad_words_item

        try:
            del saved_user_bad_words
            del tmp_list
            del s_list
            del tmp_set
            del user_protected_data_full_path
            del f
        except:
            pass

        self.bad_words_already_loaded = True

        return is_valid

    #-----------------------------------------------------------------------------------------------
    def add_item_bad_words(self):

        if not self.bad_words_already_loaded:
            return

        new_bad_words_item = QListWidgetItem("?")
        new_bad_words_item.setFlags(new_bad_words_item.flags() | Qt.ItemIsEditable)
        new_bad_words_item.setFont(self.text_font)
        new_bad_words_item.setForeground(Qt.darkRed)
        self.user_bad_words_qlist.insertItem(0,new_bad_words_item)
        del new_bad_words_item
        self.update_bad_words_groupbox_title()
    #-----------------------------------------------------------------------------------------------
    def delete_item_bad_words(self):

        if not self.bad_words_already_loaded:
            return

        current_row = self.user_bad_words_qlist.currentRow()
        self.user_bad_words_qlist.takeItem(current_row)
        self.update_bad_words_groupbox_title()
    #-----------------------------------------------------------------------------------------------
    def purge_all_bad_words(self):

        if not self.bad_words_already_loaded:
            return

        if question_dialog(self.gui, _('Purge All of the bad Words?'),_('Purge All of the bad Words?  Are you sure?')) :
            self.user_bad_words_qlist.clear()

        self.update_bad_words_groupbox_title()

    #-----------------------------------------------------------------------------------------------
    def save_bad_words(self):

        is_valid = False

        if not self.bad_words_already_loaded:
            return is_valid

        items = []
        for index in xrange(self.user_bad_words_qlist.count()):
             items.append(self.user_bad_words_qlist.item(index))
        words_list = [(unicode(i.text()) + "|") for i in items]

        selection = "bad"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        my_outfile = open(user_protected_data_full_path, 'w')

        del self.my_saved_bad_words_crossheck_list[ : ]   # clear it
        self.my_saved_bad_words_crossheck_list[:] = []    #clear it again

        for word in words_list:
            if word > " ":
                if  not "?" in word:
                    if "|" in word:
                        word = word.lower()
                        word = word.replace(" ", "")
                        word = word.strip()
                        if len(word) > 1:
                            word = word.encode("ascii","strict")
                            my_outfile.write(word)   #  keeps the |
                            word = word.replace("|", "")
                            self.my_saved_bad_words_crossheck_list.append(str(word))   # for cross-validation of good & bad to check for overlaps.
        my_outfile.close()

        del items
        del words_list
        del my_outfile
        del user_protected_data_full_path

        is_valid = self.edit_bad_words()   #reload the saved list, resorted and with no duplicates

        self.update_bad_words_groupbox_title()

        return is_valid

    #-----------------------------------------------------------------------------------------------
    def update_bad_words_groupbox_title(self):
        n = self.user_bad_words_qlist.count()
        n = unicode(n)
        count =  " [" + n + "]"
        self.bad_words_groupbox_title_full = self.bad_words_groupbox_title_literal + count
        self.user_bad_words_groupbox.setTitle(self.bad_words_groupbox_title_full)

    #-----------------------------------------------------------------------------------------------
    def import_list_of_bad_words(self):

        if iswindows:
            windows_user_name = get_windows_username()
            if DEBUG: print("windows_user_name",windows_user_name)
            s = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']
            if s == unicode("/"):  #prefs.defaults
                s = "C:/Users/[WINDOWSUSERNAME]/Desktop"
                s = s.replace("[WINDOWSUSERNAME]",windows_user_name)
                prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH'] = unicode(s)

        self.import_last_file_path = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_import_list_of_bad_words"
        title = "Choose the text file with the list of bad words you wish to import"

        if iswindows:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New bad Words",self.import_last_file_path,("Text Files (*.txt *.text)") )
        else:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New bad Words",self.import_last_file_path,("Text Files (*.*)") )

        import_file, dummy = import_tuple

        self.import_last_file_path = import_file

        prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.import_last_file_path)

        prefs

        imported_user_bad_words = []

        if os.path.exists(import_file):
            try:
                with open(import_file, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        if line:
                            line = line.encode("ascii", "strict")
                            line = str(line)
                            line = str(line.replace("\r",""))
                            line = str(line.replace("\n",""))
                            line = str(line.replace("\t",""))
                            line = str(line.replace("\v",""))
                            line = str(line.replace(" ",""))
                            if not line.isalpha():
                                continue
                            else:
                                imported_user_bad_words.append(str(line))
                                continue
                        else:
                            continue
                    #END FOR
                #END WITH
                f.close()
                del import_file
            except Exception as e:
                return
        else:
            return

        imported_user_bad_words.sort()
        tmp_list = []
        for word in imported_user_bad_words:
            if word:
                if word > " ":
                    if word.isalpha():
                        word = str(word)
                        word = str(word.replace(" ",""))
                        word = str(word.strip())
                        word = str(word.lower())
                        tmp_list.append(str(word))
                    else:
                        continue
                else:
                    continue
            else:
                continue
        #END FOR
        del imported_user_bad_words

        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)   #no more duplicates
        del tmp_set

        tmp_list.sort()
        for row in tmp_list:
            row = row.encode("ascii","strict")
            row = str(row)
            row = row.decode("utf8")
            new_bad_words_item = QListWidgetItem("dummy")
            value =  new_bad_words_item.text()
            new_bad_words_item.setText(row)
            value =  new_bad_words_item.text()
            new_bad_words_item.setFlags(new_bad_words_item.flags() | Qt.ItemIsEditable)
            new_bad_words_item.setFont(self.text_font)
            new_bad_words_item.setForeground(Qt.darkMagenta)
            self.user_bad_words_qlist.insertItem(0,new_bad_words_item)
            value =  new_bad_words_item.text()
        #END FOR

        self.bad_words_already_loaded = True

        is_valid = self.save_bad_words()

    #-----------------------------------------------------------------------------------------------
    def export_bad_words(self):

        if iswindows:
            windows_user_name = get_windows_username()
            if DEBUG: print("windows_user_name",windows_user_name)
            s = prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']
            if s == unicode("/"):  #prefs.defaults
                s = "C:/Users/[WINDOWSUSERNAME]/Desktop"
                s = s.replace("[WINDOWSUSERNAME]",windows_user_name)
                prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH'] = unicode(s)

        self.export_last_file_path = prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_export_list_of_bad_words"
        title = "Choose the text file name that you wish to create or replace"

        tmp_full_path = os.path.join(self.export_last_file_path,'enf_export_bad_words.txt')

        export_tuple = QFileDialog.getSaveFileName(self,"export Simple Text File List of New bad Words",tmp_full_path,("Text Files (*.txt *.text *.csv )") )

        export_file, dummy = export_tuple

        if DEBUG: print("export file: ", export_file)

        self.export_last_file_path = export_file

        prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.export_last_file_path)

        prefs

        items = []
        for index in xrange(self.user_bad_words_qlist.count()):
            items.append(self.user_bad_words_qlist.item(index))
        #END FOR

        words_list = [(unicode(i.text()) + "\n") for i in items]

        del items

        words_string = ""
        for row in words_list:
            words_string = words_string + row

        del words_list

        words_string = words_string.encode("ascii","strict")
        words_string = str(words_string)

        try:
            with open(export_file, 'w') as f:
                f.write(words_string)
            #END WITH
            f.close()
            del export_file
            del words_string
        except Exception as e:
            if DEBUG: print("export file error: ", str(e))
            return

    #-----------------------------------------------------------------------------------------------
    def build_user_protected_data_full_path(self,selection):

        if self.user_protected_data_directory == "unknown":
            self.build_user_protected_directory_path()

        user_protected_data_full_path = "unknown"

        if selection == "good":
            file_name = USER_CUSTOM_WORD_RULES_GOOD_WORDS_FILENAME
            file_name.encode("ascii", "strict")
            file_name = str(file_name)
            file_name = file_name.decode(filesystem_encoding)
            user_protected_data_full_path = os.path.join(self.user_protected_data_directory, file_name )       #   /calibre/plugins/enf/user_good_words.txt
            return  user_protected_data_full_path

        if selection == "bad":
            file_name = USER_CUSTOM_WORD_RULES_BAD_WORDS_FILENAME
            file_name.encode("ascii", "strict")
            file_name = str(file_name)
            file_name = file_name.decode(filesystem_encoding)
            user_protected_data_full_path = os.path.join(self.user_protected_data_directory, file_name )        #   /calibre/plugins/enf/user_bad_words.txt
            return  user_protected_data_full_path

        return user_protected_data_full_path

    #--------------------------------------------------------------------------------------------------
    def build_user_protected_directory_path(self):

        self.user_protected_data_path = self.my_plugin_path
        self.user_protected_data_path = self.user_protected_data_path.replace("\English Noun Frequency.zip", "")
        self.user_protected_data_path = self.user_protected_data_path.replace("/English Noun Frequency.zip", "")

        self.user_protected_data_directory = self.user_protected_data_path

        sub_directory = str("enf_files")
        sub_directory = sub_directory.decode(filesystem_encoding)

        self.user_protected_data_directory =  os.path.join(self.user_protected_data_directory, sub_directory)

        self.user_protected_data_directory.encode("ascii", "strict")

        self.user_protected_data_directory = str(self.user_protected_data_directory)

        self.user_protected_data_directory = self.user_protected_data_directory.decode(filesystem_encoding)

        self.user_protected_data_directory = self.user_protected_data_directory.replace(os.sep, '/')         #   /calibre/plugins/enf

        if not os.path.exists(self.user_protected_data_directory):
            os.makedirs(self.user_protected_data_directory)

#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class ENFUserListsTab_B(QWidget):
    def __init__(self,gui,icon,guidb,my_plugin_path, ENFUserListsTab_A):
        super(ENFUserListsTab_B, self).__init__()

        #-----------------------------------------------------
        self.gui = gui
        self.guidb = guidb
        self.my_plugin_path = my_plugin_path
        self.user_protected_data_directory = "unknown"
        #-----------------------------------------------------
        self.ENFUserListsTab_A = ENFUserListsTab_A
        self.my_saved_good_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_good_words_crossheck_list
        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list
        self.save_bad_words =  self.ENFUserListsTab_A.save_bad_words
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)

        heading_font = QFont()
        heading_font.setBold(False)
        heading_font.setPointSize(9)

        self.text_font = QFont()
        self.text_font.setBold(True)
        self.text_font.setPointSize(12)

        self.text_medium_font = QFont()
        self.text_medium_font.setBold(True)
        self.text_medium_font.setPointSize(8)
        self.text_medium_font_minimum_length = 25

        self.text_long_font = QFont()
        self.text_long_font.setBold(True)
        self.text_long_font.setPointSize(7)
        self.text_long_font_minimum_length = 35
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.user_data_b_layout = QGridLayout()
        self.user_data_b_layout.setSpacing(0)
        self.user_data_b_layout.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.user_data_b_layout)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.user_plurals_qlist_layout = QVBoxLayout()
        self.user_plurals_qlist_layout.setAlignment(Qt.AlignCenter)

        self.plurals_groupbox_title_literal =  '                          Singular:Plural Pairs'
        self.plurals_groupbox_title_full = self.plurals_groupbox_title_literal + " [0]"
        self.user_plurals_groupbox = QGroupBox(self.plurals_groupbox_title_full)
        self.user_plurals_groupbox.setAlignment(Qt.AlignCenter)
        self.user_plurals_groupbox.setFont(heading_font)
        self.user_data_b_layout.addWidget(self.user_plurals_groupbox,4,0)

        self.user_plurals_groupbox.setLayout(self.user_plurals_qlist_layout)

        self.user_plurals_qlist =  QListWidget()
        self.user_plurals_qlist.setToolTip("<p style='white-space:wrap'>User Custom Word Rules for 'Singular:Plural Pairs' supplement and/or override the Standard Word Rules. <br><br>\
                                                                        EXAMPLE:  A Standard Word Rule says that the Plural of Word1 is 'Word1s'.  However, \
                                                                        you always want the Plural of Word1 to be 'Word1es', or even just 'Word1'.  So, you simply create a Custom Word Rule \
                                                                        for Word1 in the 'Singular:Plural Pairs' column, such as  word1:word1es  .  Your Custom Word Rules will always override any Standard Word Rules for the identical word. <br><br><br>\
                                                                        IMPORTANT:  the syntax for any 'pair' is exactly:   singular:plural   .  No spaces and no punctuation at all except for the colon ':' in the middle.  \
                                                                        This means that you may not use words with spaces or dashes.  For the pupose of creating English Noun Frequencies, no words may have spaces or punctuation.<br><br>\
                                                                        Any items in either of the 'pairs' columns that do not conform exactly to the above rule will be discarded the next time anything is saved.<br><br>\
                                                                        Don't use plural pairs to be a proxy for change pairs.  Don't try to finesse the rules.  Go for the final result immediately, bypassing any intermediate steps.<br><br>\
                                                                        EXAMPLE:  'mouses' shows up in your comments.  Do not create the plural rule  'mouse:mouses'.   Instead, create a change rule 'mouses:mouse'.<br>\
                                                                        Go to the final singular word.  Do not create a change rule  'mouses:mice'.   Although that would certainly work, it might not happen early enough <br>\
                                                                        in the process to keep the word 'mice' from appearing on its own line in the comments.  So,  create the change rule:  'mouses:mouse'.<br>\
                                                                        That is what you want to see in the Comments for 'mouses', so that is what the rule needs to be. <br><br>\
                                                                        Keep it simple.  Don't use the transitive rule of algebra to finesse the process, because the sequence of events in the Job is important too.<br><br>\
                                                                        If you want a normally deleted word to start appearing, and if that word is odd in that it has no plural without first adding punctuation marks (e.g. Z's),<br>\
                                                                        you should create a custom plural pair where singular = plural.<br>\
                                                                        EXAMPLE: You want the letter 'Z' to appear in your Comments, but single letters are part of the standard 'bad' list.<br>\
                                                                        So, (1) you add 'z' as a 'good' word .  There is no 'real' plural for 'z' except z's , so (2) you should add a user custom plural pair of 'z:z'.<br><br>\
                                                                        We want the word 'rights', as in 'human rights', to appear.  However, 'right' and 'left' are standard 'bad' words.<br>\
                                                                        The plural of 'right' is 'rights'.  'Rights' would be changed to its singular, 'right', and deleted.  You can avoid this by creating a user custom plural pair of 'rights:rights'.<br>\
                                                                        All words in a plural pair are 'good', so 'rights' will not be deleted, although 'right' will continue to be deleted.<br><br>\
                                                                        IMPORTANT:  user custom change pairs are applied to words BEFORE plural pairs are used to convert plurals to singulars.")

        self.user_plurals_qlist.setFont(font)
        self.user_plurals_qlist_layout.addWidget(self.user_plurals_qlist)
        self.user_plurals_qlist.setSortingEnabled(True)

        #-----
        self.plurals_buttonbox = QDialogButtonBox()
        self.plurals_buttonbox.setOrientation(Qt.Horizontal)
        self.plurals_buttonbox.setCenterButtons(True)

        self.user_plurals_qlist_layout.addWidget(self.plurals_buttonbox,1)

        self.add_item_plurals_push_button = QPushButton(" ", self)
        self.add_item_plurals_push_button.setText("Add Pair")
        self.add_item_plurals_push_button.setToolTip("Adds a new 'Plural Pair' placeholder that you then must change, but does not save the placeholder.")
        self.add_item_plurals_push_button.clicked.connect(self.add_item_plurals)
        self.add_item_plurals_push_button.setFont(font)
        self.plurals_buttonbox.addButton(self.add_item_plurals_push_button,0)

        self.delete_item_plurals_push_button = QPushButton(" ", self)
        self.delete_item_plurals_push_button.setText("Delete Pair")
        self.delete_item_plurals_push_button.setToolTip("Deletes the currently selected 'Plural Pair', but does not save the changed list.")
        self.delete_item_plurals_push_button.clicked.connect(self.delete_item_plurals)
        self.delete_item_plurals_push_button.setFont(font)
        self.plurals_buttonbox.addButton(self.delete_item_plurals_push_button,0)

        self.purge_item_plurals_push_button = QPushButton(" ", self)
        self.purge_item_plurals_push_button.setText("Purge All")
        self.purge_item_plurals_push_button.setToolTip("Deletes all of the current 'Plural Pairs', and immediately saves the empty list.")
        self.purge_item_plurals_push_button.clicked.connect(self.purge_all_plurals)
        self.purge_item_plurals_push_button.setFont(font)
        self.plurals_buttonbox.addButton(self.purge_item_plurals_push_button,0)
        #-----

        self.save_plurals_push_button = QPushButton(" ", self)
        self.save_plurals_push_button.setText("Save && Validate")
        self.save_plurals_push_button.setToolTip("<p style='white-space:wrap'>Saves the current 'Plural Pair' list and cross-checks it against the list of 'Bad' Words.")
        self.save_plurals_push_button.clicked.connect(self.save_plurals)
        self.save_plurals_push_button.setFont(font)
        self.user_plurals_qlist_layout.addWidget(self.save_plurals_push_button,0)

        #-----
        self.validate_plurals_push_button = QPushButton(" ", self)
        self.validate_plurals_push_button.setText("Cross-check with 'Bad' Words")
        self.validate_plurals_push_button.setToolTip("<p style='white-space:wrap'>Words in a 'Plural Pair' should not ever be identical to 'Bad' Words. \
                                                                                            It is not possible to say 'keep it' and also say 'discard it'.<br><br>\
                                                                                            This function cross-checks the 'Plural Pairs' against the 'Bad' Words, \
                                                                                            and changes the color of any conflicting words. \
                                                                                            You then need to delete one of the Word Rules.<br><br>")
        self.validate_plurals_push_button.clicked.connect(self.save_plurals)
        self.validate_plurals_push_button.setFont(font)
        self.user_plurals_qlist_layout.addWidget(self.validate_plurals_push_button,0)

        #-----
        self.delete_source_bad_for_plurals_push_button = QPushButton(" ", self)
        self.delete_source_bad_for_plurals_push_button.setText("Fix Errors: Delete the Related 'Bad' Word")
        self.delete_source_bad_for_plurals_push_button.setToolTip("<p style='white-space:wrap'>Deletes any 'Bad' Word that is identical to any word in any current 'Plural Pair'.")
        self.delete_source_bad_for_plurals_push_button.clicked.connect(self.delete_plural_errors_from_user_bad_words_list)
        self.delete_source_bad_for_plurals_push_button.setFont(font)
        self.user_plurals_qlist_layout.addWidget(self.delete_source_bad_for_plurals_push_button,0)

        #-----
        self.import_plural_pairs_push_button = QPushButton(" ", self)
        self.import_plural_pairs_push_button.setText("Import from a File")
        self.import_plural_pairs_push_button.setToolTip("<p style='white-space:nowrap'>You may import a plain text file to add new 'Singular:Plural Pairs' Word Rules en masse. <br><br>\
                                                                        The syntax for each line of the plain text file requires that there be no spaces and no punctuation, <br>\
                                                                        excluding a colon (':') in the middle of each pair. Use no tabs, and add no spaces.  <br><br>\
                                                                        Enter one condensed single word pair per line, and then press 'Enter'. <br><br>\
                                                                        Each line must have ended with an 'Enter' being pressed by the user creating the plain text file.<br><br>\
                                                                        Every letter of each word of each pair will automatically be converted to lower case, so proper capitalization is not useful.<br><br>\
                                                                        Any imported items that do not conform exactly to the above syntax will be discarded.<br><br>\
                                                                        After import, the words that conform to the required syntax will automatically be saved.  <br><br>\
                                                                        Both the Singular and the Plural words will be individually cross-checked against the 'Bad' Words, <br>\
                                                                        since by definition 'Singular:Plural Pairs' are 'Good' Words.  You will be notified of any conflicting word rules.")
        self.import_plural_pairs_push_button.clicked.connect(self.import_list_of_plural_pairs)
        self.import_plural_pairs_push_button.setFont(font)
        self.user_plurals_qlist_layout.addWidget(self.import_plural_pairs_push_button,0)

        self.export_plurals_push_button = QPushButton(" ", self)
        self.export_plurals_push_button.setText("Export to a File")
        self.export_plurals_push_button.setToolTip("<p style='white-space:nowrap'>You may export all 'Singular:Plural Pair' Word Rules to a plain text file for mass editing. <br><br>\
                                                                                    That file will be identical in format to the required format for importing 'Singular:Plural Pair' Word Rules.<br><br>\
                                                                                    You may import the identical file after editing as long as you have adhered to the 'Singular:Plural Pair' import file syntax requirements.")
        self.export_plurals_push_button.clicked.connect(self.export_plural_pairs)
        self.export_plurals_push_button.setFont(font)
        self.user_plurals_qlist_layout.addWidget(self.export_plurals_push_button,0)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.user_change_pairs_qlist_layout = QVBoxLayout()
        self.user_change_pairs_qlist_layout.setAlignment(Qt.AlignCenter)

        self.change_pairs_groupbox_title_literal =  '                          Word Change Pairs'
        self.change_pairs_groupbox_title_full = self.change_pairs_groupbox_title_literal + " [0]"
        self.user_change_pairs_groupbox = QGroupBox(self.change_pairs_groupbox_title_full)
        self.user_change_pairs_groupbox.setAlignment(Qt.AlignCenter)
        self.user_change_pairs_groupbox.setFont(heading_font)
        self.user_data_b_layout.addWidget(self.user_change_pairs_groupbox,4,1)

        self.user_change_pairs_groupbox.setLayout(self.user_change_pairs_qlist_layout)

        self.user_change_pairs_qlist =  QListWidget()
        self.user_change_pairs_qlist.setToolTip("<p style='white-space:nowrap'>User Custom Word Rules for 'Word Change Pairs' supplement and/or override the Standard Word Rules.  <br><br>\
                                                                        EXAMPLE:  In American English, acronyms are fully capitalized, such as 'NATO'. <br>\
                                                                        There is a Standard Acronym Word Rule for many common Acronyms,<br>\
                                                                        including one that says 'Change nato to NATO'.  <br>\
                                                                        However, assume you were born in the U.K. and strongly prefer 'Nato'.<br>\
                                                                        To activate your preference, you simply create a <br>\
                                                                        Custom Change Pair Word Rule:  nato:Nato  .  <br><br><br>\
                                                                        IMPORTANT:  the syntax for any 'pair' is exactly:   word:word   .  <br>\
                                                                        No spaces and no punctuation at all except for the colon ':' in the middle.  <br>\
                                                                        That means that you may not use words with spaces or dashes.  <br><br>\
                                                                        For the pupose of creating English Noun Frequencies, <br>\
                                                                        no words may have spaces or punctuation.<br><br>\
                                                                        Any items in either of the 'pairs' columns that do not conform exactly <br>\
                                                                        to the above rule will be discarded the next time anything is saved.<br><br><br>\
                                                                        IMPORTANT:  user custom change pairs are applied to words <br>\
                                                                        BEFORE plural pairs are used to convert plurals to singulars.")
        self.user_change_pairs_qlist.setSelectionMode(QAbstractItemView.ExtendedSelection)
        self.user_change_pairs_qlist.setFont(font)
        self.user_change_pairs_qlist_layout.addWidget(self.user_change_pairs_qlist)
        self.user_change_pairs_qlist.setSortingEnabled(True)

        #-----
        self.change_pairs_buttonbox = QDialogButtonBox()
        self.change_pairs_buttonbox.setOrientation(Qt.Horizontal)
        self.change_pairs_buttonbox.setCenterButtons(True)

        self.user_change_pairs_qlist_layout.addWidget(self.change_pairs_buttonbox,1)

        self.add_item_change_pairs_push_button = QPushButton(" ", self)
        self.add_item_change_pairs_push_button.setText("Add Pair")
        self.add_item_change_pairs_push_button.setToolTip("Adds a new 'Word Change Pair' placeholder that you then must change, but does not save the placeholder.")
        self.add_item_change_pairs_push_button.clicked.connect(self.add_item_change_pairs)
        self.add_item_change_pairs_push_button.setFont(font)
        self.change_pairs_buttonbox.addButton(self.add_item_change_pairs_push_button,0)

        self.delete_item_change_pairs_push_button = QPushButton(" ", self)
        self.delete_item_change_pairs_push_button.setText("Delete Pair")
        self.delete_item_change_pairs_push_button.setToolTip("Deletes the currently selected 'Word Change Pair', but does not save the changed list.")
        self.delete_item_change_pairs_push_button.clicked.connect(self.delete_item_change_pairs)
        self.delete_item_change_pairs_push_button.setFont(font)
        self.change_pairs_buttonbox.addButton(self.delete_item_change_pairs_push_button,0)

        self.purge_item_change_pairs_push_button = QPushButton(" ", self)
        self.purge_item_change_pairs_push_button.setText("Purge All")
        self.purge_item_change_pairs_push_button.setToolTip("Deletes all of the current 'Word Change Pairs', and immediately saves the empty list.")
        self.purge_item_change_pairs_push_button.clicked.connect(self.purge_all_change_pairs)
        self.purge_item_change_pairs_push_button.setFont(font)
        self.change_pairs_buttonbox.addButton(self.purge_item_change_pairs_push_button,0)
        #-----

        self.save_change_pairs_push_button = QPushButton(" ", self)
        self.save_change_pairs_push_button.setText("Save && Validate")
        self.save_change_pairs_push_button.setToolTip("<p style='white-space:wrap'>Saves the current 'Word Change Pair' list and cross-checks it against the list of 'Bad' Words.")
        self.save_change_pairs_push_button.clicked.connect(self.save_change_pairs)
        self.save_change_pairs_push_button.setFont(font)
        self.user_change_pairs_qlist_layout.addWidget(self.save_change_pairs_push_button,0)
        #-----

        self.validate_change_pairs_push_button = QPushButton(" ", self)
        self.validate_change_pairs_push_button.setText("Cross-check with 'Bad' Words")
        self.validate_change_pairs_push_button.setToolTip("<p style='white-space:wrap'>'Word Change Pair' words should not ever be identical to 'Bad' Words. \
                                                                                            It is not possible to say 'keep it' and also say 'discard it'.<br><br>\
                                                                                            This function cross-checks the 'Word Change Pair' words against the 'Bad' Words, \
                                                                                            and changes the color of any conflicting words. \
                                                                                            You then need to delete one of the Word Rules.")
        self.validate_change_pairs_push_button.clicked.connect(self.save_change_pairs)
        self.validate_change_pairs_push_button.setFont(font)
        self.user_change_pairs_qlist_layout.addWidget(self.validate_change_pairs_push_button,0)
        #-----

        self.delete_source_bad_for_change_pairs_push_button = QPushButton(" ", self)
        self.delete_source_bad_for_change_pairs_push_button.setText("Fix Errors: Delete the Related 'Bad' Word")
        self.delete_source_bad_for_change_pairs_push_button.setToolTip("<p style='white-space:wrap'>Deletes any 'Bad' Word that is identical to any word in any current 'Word Change Pair'.")
        self.delete_source_bad_for_change_pairs_push_button.clicked.connect(self.delete_change_pairs_errors_from_user_bad_words_list)
        self.delete_source_bad_for_change_pairs_push_button.setFont(font)
        self.user_change_pairs_qlist_layout.addWidget(self.delete_source_bad_for_change_pairs_push_button,0)

        #-----
        self.import_change_pairs_push_button = QPushButton(" ", self)
        self.import_change_pairs_push_button.setText("Import from a File")
        self.import_change_pairs_push_button.setToolTip("<p style='white-space:nowrap'>You may import a plain text file to add new 'Change Pair' Word Rules en masse. <br><br>\
                                                                        The syntax for each line of the plain text file requires that there be no spaces and no punctuation, <br>\
                                                                        excluding a colon (':') in the middle of each pair. Use no tabs, and add no spaces.  <br><br>\
                                                                        Enter one condensed single word pair per line, and then press 'Enter'. <br><br>\
                                                                        Each line must have ended with an 'Enter' being pressed by the user creating the plain text file.<br><br>\
                                                                        After import, the words that conform to the required syntax will automatically be saved.  <br><br>\
                                                                        Any imported items that do not conform exactly to the above syntax will be discarded.<br><br>\
                                                                        Every letter of each word of each pair will NOT automatically be converted to lower case. <br><br>\
                                                                        Proper capitalization IS useful if you wish to change a frequent word to all UPPERCASE, <br>\
                                                                        or you wish to change an all UPPERCASE word (e.g. a Standard Acronym such as 'NATO') to title case.<br><br>\
                                                                        'Title casing' is the default capitalization rule for every word without an overriding rule, whether Standard or Custom. <br><br>\
                                                                        'Title casing'  means 'capitalize the first letter of each word'.<br><br>\
                                                                        Both 'Word-In' and 'Word-Out' will be individually cross-checked against the 'Bad' Words, <br>\
                                                                        since by definition 'Change Pairs' are 'Good' Words.  You will be notified of any conflicting word rules.<br><br>")
        self.import_change_pairs_push_button.clicked.connect(self.import_list_of_change_pairs)
        self.import_change_pairs_push_button.setFont(font)
        self.user_change_pairs_qlist_layout.addWidget(self.import_change_pairs_push_button,0)


        self.export_change_pairs_push_button = QPushButton(" ", self)
        self.export_change_pairs_push_button.setText("Export to a File")
        self.export_change_pairs_push_button.setToolTip("<p style='white-space:nowrap'>You may export all 'Change Pair' Word Rules to a plain text file for mass editing. <br><br>\
                                                                                    That file will be identical in format to the required format for importing 'Change Pair' Word Rules.<br><br>\
                                                                                    You may import the identical file after editing as long as you have adhered to the 'Change Pair' import file syntax requirements.")
        self.export_change_pairs_push_button.clicked.connect(self.export_change_pairs)
        self.export_change_pairs_push_button.setFont(font)
        self.user_change_pairs_qlist_layout.addWidget(self.export_change_pairs_push_button,0)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------

        self.plurals_already_loaded = False
        self.change_pairs_already_loaded = False

        self.found_plurals_crosscheck_errors = False
        self.found_change_pairs_crosscheck_errors = False

        #----------------------------------------
        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist
        self.save_bad_words()   # must do first to get self.my_saved_bad_words_crossheck_list updated
        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh since rebuilt by self.save_bad_words()
        #----------------------------------------
        self.edit_plurals()   # this first one only loads the plurals, but cannot yet cross-check them to hide them
        #----------------------------------------
        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist
        self.save_bad_words()   # must do first to get self.my_saved_bad_words_crossheck_list updated
        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh since rebuilt by self.save_bad_words()
        #----------------------------------------
        self.edit_change_pairs()    # this first one only loads the change_pairs, but cannot yet cross-check them to hide them
        #----------------------------------------
        self.save_plurals()                     # now already loaded, selects and shows only the errors, hides the rest
        self.save_change_pairs()           # now already loaded, selects and shows only the errors, hides the rest
        #----------------------------------------

    #-----------------------------------------------------------------------------------------------
    def edit_plurals(self):

        is_valid = True

        selection = "plural_pairs"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        self.user_plurals_qlist.clear()

        word_list_of_crosscheck_errors_string = " --- "
        error_found_list = []

        saved_user_plurals = []

        if os.path.exists(user_protected_data_full_path):
            try:
                with open(user_protected_data_full_path, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        line = str(line)
                        line = line.encode("ascii", "strict")
                        saved_user_plurals.append(str(line))
                    f.close()
            except Exception as e:
                if DEBUG: print("in edit_plurals, exception:  ", str(e) )
                saved_user_plurals.append("?:?| ")
        else:
            saved_user_plurals.append("?:?| ")

        saved_user_plurals.sort()
        tmp_list = []
        for word in saved_user_plurals:
            if not "|" in word:
                word = word + "|"
            word = word.replace("||","|")
            s_list = word.split("|")
            for row in s_list:
                if row > " ":
                    tmp_list.append(row)
        #END FOR

        #----------------------------------------
        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist
        self.save_bad_words()   # must do first to get self.my_saved_bad_words_crossheck_list updated
        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh since rebuilt by self.save_bad_words()
        #----------------------------------------

        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)   #no more duplicates
        for row in tmp_list:
            if ":" in row:
                row = row.replace(" ","")
                row = row.strip()
                row = row.lower()  #plurals are always all lowercase, unlike change_pairs.
                word = str(row)     #plurals are always all lowercase, unlike change_pairs.
                new_plurals_item = QListWidgetItem(row)
                new_plurals_item.setFlags(new_plurals_item.flags() | Qt.ItemIsEditable)
                if len(row) > self.text_long_font_minimum_length:
                    new_plurals_item.setFont(self.text_long_font)
                else:
                    if len(row) > self.text_medium_font_minimum_length:
                        new_plurals_item.setFont(self.text_medium_font)
                    else:
                        new_plurals_item.setFont(self.text_font)

                new_plurals_item.setForeground(Qt.darkGreen)

                if ":" in word:
                    s_split = word.split(":")
                    singular_word = str(s_split[0])
                    plural_word = str(s_split[1])
                    if (not str(singular_word) in self.my_saved_bad_words_crossheck_list) and \
                        (not str(plural_word) in self.my_saved_bad_words_crossheck_list):        # for cross-validation of bad words to check for overlaps.
                        new_plurals_item.setForeground(Qt.darkGreen)
                    else:
                        self.found_plurals_crosscheck_errors = True
                        new_plurals_item.setForeground(Qt.darkRed)
                        word_list_of_crosscheck_errors_string = word_list_of_crosscheck_errors_string + word + " --- "
                        error_found_list.append(word)     #plurals are always all lowercase, unlike change_pairs.
                        is_valid = False
                else:
                    new_plurals_item.setForeground(Qt.darkBlue)
                    is_valid = False

                self.user_plurals_qlist.addItem(new_plurals_item)
                new_plurals_item.setHidden(False)
                del new_plurals_item
        #END FOR
        try:
            del saved_user_plurals_
            del tmp_list
            del s_list
            del tmp_set
            del user_protected_data_full_path
            del f
        except:
            pass

        found_list = []
        all_items = []

        if self.plurals_already_loaded:     # so must execute self.edit_plurals() twice upon startup to check for errors
            if self.found_plurals_crosscheck_errors:
                warning_dialog(self.gui, _("'Plural Pairs' Have Cross-check Errors!"),\
                _("You have at least one 'Plural Pair' that contains one of your custom 'Bad' words: <br><br>" + word_list_of_crosscheck_errors_string + "  "), show=True)
                for search_string in error_found_list:
                    found_items = self.user_plurals_qlist.findItems(search_string,(Qt.MatchContains|Qt.MatchWrap) )
                    if found_items:
                        if isinstance(found_items,list):
                            for item in found_items:
                                found_list.append(item)
                            del found_items
                        else:
                            pass
                    else:
                        pass
                #END FOR
                if found_list:
                    is_valid = False
                    for index in xrange(self.user_plurals_qlist.count()):
                         all_items.append(self.user_plurals_qlist.item(index))
                    #END FOR
                    for item in all_items:
                        if item in found_list:
                            item.setHidden(False)     #only show the items failing the crosscheck with bad words, and hide the rest
                            #~ item.setSelected(True)
                        else:
                            item.setSelected(False)
                            item.setHidden(True)
                    #END FOR
                else:
                    pass
            else:
                pass
        else:
            pass

        self.error_found_plurals_list = list(error_found_list)

        del word_list_of_crosscheck_errors_string
        del error_found_list
        del found_list
        del all_items

        self.plurals_already_loaded = True

        return  is_valid

    #-----------------------------------------------------------------------------------------------
    def add_item_plurals(self):

        if not self.plurals_already_loaded:
            return

        new_plurals_item = QListWidgetItem("? : ?")
        new_plurals_item.setFlags(new_plurals_item.flags() | Qt.ItemIsEditable)
        new_plurals_item.setFont(self.text_font)
        new_plurals_item.setForeground(Qt.darkGreen)
        self.user_plurals_qlist.insertItem(0,new_plurals_item)
        del new_plurals_item
        self.update_plurals_groupbox_title()
    #-----------------------------------------------------------------------------------------------
    def delete_item_plurals(self):

        if not self.plurals_already_loaded:
            return

        current_row = self.user_plurals_qlist.currentRow()
        self.user_plurals_qlist.takeItem(current_row)
        self.update_plurals_groupbox_title()
    #-----------------------------------------------------------------------------------------------
    def purge_all_plurals(self):

        if not self.plurals_already_loaded:
            return

        if question_dialog(self.gui, _('Purge All of the Singular:Plural Pairs?'),_('Purge All of the Singular:Plural Pairs?  Are you sure?')) :
            self.user_plurals_qlist.clear()

        self.update_plurals_groupbox_title()

    #-----------------------------------------------------------------------------------------------
    def save_plurals(self):

        is_valid = False

        if not self.plurals_already_loaded:
            return  is_valid

        items = []
        for index in xrange(self.user_plurals_qlist.count()):
             items.append(self.user_plurals_qlist.item(index))
        words_list = [(unicode(i.text()) + "|") for i in items]

        selection = "plural_pairs"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        my_outfile = open(user_protected_data_full_path, 'w')

        for pair in words_list:
            if pair > " ":
                if  not "? : ?" in pair:
                    if  not "?" in pair:
                        if ":" in pair:
                            if "|" in pair:
                                pair = pair.replace("||","|")
                                pair = pair.lower()
                                pair = pair.replace(" ", "")
                                pair = pair.strip()
                                if len(pair) > 6:
                                    pair = pair.encode("ascii","strict")
                                    my_outfile.write(pair)
        my_outfile.close()

        del items
        del words_list
        del my_outfile
        del user_protected_data_full_path

        self.found_plurals_crosscheck_errors = False

        is_valid = self.edit_plurals()   #reload the saved list, resorted and with no duplicates

        self.update_plurals_groupbox_title()

        return  is_valid
    #-----------------------------------------------------------------------------------------------
    def update_plurals_groupbox_title(self):
        n = self.user_plurals_qlist.count()
        n = unicode(n)
        count =  " [" + n + "]"
        self.plurals_groupbox_title_full = self.plurals_groupbox_title_literal + count
        self.user_plurals_groupbox.setTitle(self.plurals_groupbox_title_full)

    #-----------------------------------------------------------------------------------------------
    def delete_plural_errors_from_user_bad_words_list(self):

        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh      # this is created by   self.save_bad_words() from Tab A
        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist  # refresh

        n_num = self.user_bad_words_qlist.count()
        for word in self.error_found_plurals_list:
            s_split = word.split(":")
            if len(s_split) == 2:
                singular = s_split[0]
                plural = s_split[1]
                for x in range(0,2):
                    if x == 0:
                        word = singular
                    else:
                        word = plural
                        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist   #the qlist has changed since an item was taken
                    for index in range(0,n_num):
                        self.user_bad_words_qlist.setCurrentRow(index)
                        item = self.user_bad_words_qlist.currentItem()
                        if item:
                            value = item.text()
                        else:
                            self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist   #the qlist has changed since an item was taken
                            self.user_bad_words_qlist.setCurrentRow(index)
                            item = self.user_bad_words_qlist.currentItem()
                            if item:
                                value = item.text()
                            else:
                                continue

                        if value == word:
                            if DEBUG: print("value: ", str(value), " of index: ", str(index) )
                            if DEBUG: print("word: ", word)
                            if DEBUG: print("MATCH:  bad word will be deleted: ", value, str(index))
                            try:
                                self.user_bad_words_qlist.takeItem(index)
                            except Exception as e:
                                if DEBUG: print("exception: ", str(e))
                            self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist   #the qlist has changed since an item was taken
                            self.my_saved_bad_words_crossheck_list.remove(word)  #otherwise list will not be refreshed until the user switches to that tab and does something to that tab's data
                            break
                        else:
                            continue
                    #END FOR
                #END FOR
            else:
                continue
        #END FOR

        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist

        self.save_bad_words()   # must do first to get self.my_saved_bad_words_crossheck_list updated before saving plurals

        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh since rebuilt by self.save_bad_words()

        self.save_plurals()  # which calls self.edit_change_pairs after saving, which will re-validate using the refreshed list from above.
    #-----------------------------------------------------------------------------------------------
    def import_list_of_plural_pairs(self):

        if iswindows:
            windows_user_name = get_windows_username()
            if DEBUG: print("windows_user_name",windows_user_name)
            s = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']
            if s == unicode("/"):  #prefs.defaults
                s = "C:/Users/[WINDOWSUSERNAME]/Desktop"
                s = s.replace("[WINDOWSUSERNAME]",windows_user_name)
                prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH'] = unicode(s)

        self.import_last_file_path = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_import_list_of_plurals"
        title = "Choose the text file with the list of plurals words you wish to import"
        if iswindows:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New plurals Words",self.import_last_file_path,("Text Files (*.txt *.text)") )
        else:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New plurals Words",self.import_last_file_path,("Text Files (*.*)") )

        import_file, dummy = import_tuple

        self.import_last_file_path = import_file

        prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.import_last_file_path)

        prefs

        imported_user_plurals = []

        if os.path.exists(import_file):
            try:
                with open(import_file, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        if line:
                            line = line.encode("ascii", "strict")
                            line = str(line)
                            line = str(line.replace("\r",""))
                            line = str(line.replace("\n",""))
                            line = str(line.replace("\t",""))
                            line = str(line.replace("\v",""))
                            line = str(line.replace(" ",""))
                            line = str(line.strip())
                            if not line.isalpha():  #should not be; needs a : delimiter
                                s = str(line.replace(":",""))
                                s = s.strip()
                                if s.isalpha():  # okay; must be all alpha excluding the colon :
                                    line = str(line.lower())
                                    imported_user_plurals.append(str(line))
                                    if DEBUG: print("file line cleaned and appended: ", str(line))
                                else:
                                    continue
                            else:
                                continue
                        else:
                            continue
                    #END FOR
                #END WITH
                f.close()
                del import_file
            except Exception as e:
                return
        else:
            return

        tmp_set = set(imported_user_plurals)
        tmp_list = list(tmp_set)   #no more duplicates
        del tmp_set
        del imported_user_plurals

        tmp_list.sort()
        for row in tmp_list:
            row = row.encode("ascii","strict")
            row = str(row)
            row = row.decode("utf8")
            new_plurals_item = QListWidgetItem("dummy")
            value =  new_plurals_item.text()
            new_plurals_item.setText(row)
            value =  new_plurals_item.text()
            new_plurals_item.setFlags(new_plurals_item.flags() | Qt.ItemIsEditable)
            new_plurals_item.setFont(self.text_font)
            new_plurals_item.setForeground(Qt.darkMagenta)
            self.user_plurals_qlist.insertItem(0,new_plurals_item)
            value =  new_plurals_item.text()
            if DEBUG: print("value of new_plurals_item.text(): ", value)
        #END FOR

        self.plurals_already_loaded = True

        is_valid = self.save_plurals()
    #-----------------------------------------------------------------------------------------------
    def export_plural_pairs(self):

        if iswindows:
            windows_user_name = get_windows_username()
            if DEBUG: print("windows_user_name",windows_user_name)
            s = prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']
            if s == unicode("/"):  #prefs.defaults
                s = "C:/Users/[WINDOWSUSERNAME]/Desktop"
                s = s.replace("[WINDOWSUSERNAME]",windows_user_name)
                prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH'] = unicode(s)

        self.export_last_file_path = prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_export_list_of_plural_pairs"
        title = "Choose the text file name that you wish to create or replace"

        tmp_full_path = os.path.join(self.export_last_file_path,'enf_export_singular_plural_pairs.txt')

        export_tuple = QFileDialog.getSaveFileName(self,"export Simple Text File List of Plural Pairs",tmp_full_path,("Text Files (*.txt *.text *.csv )") )

        export_file, dummy = export_tuple

        if DEBUG: print("export file: ", export_file)

        self.export_last_file_path = export_file

        prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.export_last_file_path)

        prefs

        items = []
        for index in xrange(self.user_plurals_qlist.count()):
            items.append(self.user_plurals_qlist.item(index))
        #END FOR

        words_list = [(unicode(i.text()) + "\n") for i in items]

        del items

        words_string = ""
        for row in words_list:
            words_string = words_string + row

        del words_list

        words_string = words_string.encode("ascii","strict")
        words_string = str(words_string)

        try:
            with open(export_file, 'w') as f:
                f.write(words_string)
            #END WITH
            f.close()
            del export_file
            del words_string
        except Exception as e:
            if DEBUG: print("export file error: ", str(e))
            return

    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def edit_change_pairs(self):

        is_valid = True

        selection = "change_pairs"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        self.user_change_pairs_qlist.clear()

        word_list_of_crosscheck_errors_string = " --- "
        error_found_list = []

        saved_user_change_pairs = []

        if os.path.exists(user_protected_data_full_path):
            try:
                with open(user_protected_data_full_path, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        line = str(line)
                        line = line.encode("ascii", "strict")
                        saved_user_change_pairs.append(str(line))
                    f.close()
            except Exception as e:
                saved_user_change_pairs.append("?:?| ")
        else:
            saved_user_change_pairs.append("?:?| ")

        saved_user_change_pairs.sort()
        tmp_list = []
        for word in saved_user_change_pairs:
            if not "|" in word:
                word = word + "|"
            s_list = word.split("|")
            for row in s_list:
                if row > " ":
                    tmp_list.append(row)
        #END FOR

        #----------------------------------------
        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist
        self.save_bad_words()   # must do first to get self.my_saved_bad_words_crossheck_list updated
        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh since rebuilt by self.save_bad_words()
        #----------------------------------------

        tmp_set = set(tmp_list)
        tmp_list = list(tmp_set)   #no more duplicates
        for row in tmp_list:
            if ":" in row:
                row = row.replace(" ","")
                row = row.strip()
                original_word = row  #keeps the capitalization of the original word
                word = str(row)
                word = str(word.lower())  # for cross-checking only
                #~ row = row.lower()      # allow uppercase and titlecase change_pair word rules.
                new_change_pairs_item = QListWidgetItem(row)
                new_change_pairs_item.setFlags(new_change_pairs_item.flags() | Qt.ItemIsEditable)
                if len(row) > self.text_long_font_minimum_length:
                    new_change_pairs_item.setFont(self.text_long_font)
                else:
                    if len(row) > self.text_medium_font_minimum_length:
                        new_change_pairs_item.setFont(self.text_medium_font)
                    else:
                        new_change_pairs_item.setFont(self.text_font)

                new_change_pairs_item.setForeground(Qt.darkGreen)

                if ":" in word:
                    s_split = word.split(":")
                    word_in = str(s_split[0])
                    word_out = str(s_split[1])
                    if (not str(word_in.lower()) in self.my_saved_bad_words_crossheck_list) and \
                        (not str(word_out.lower()) in self.my_saved_bad_words_crossheck_list):     # for cross-validation of bad words to check for overlaps.  also checks the lower case version of the word, to catch same pair with different capitalizations
                        new_change_pairs_item.setForeground(Qt.darkGreen)
                    else:
                        self.found_change_pairs_crosscheck_errors = True
                        new_change_pairs_item.setForeground(Qt.darkRed)
                        word_list_of_crosscheck_errors_string = word_list_of_crosscheck_errors_string + word + " --- "
                        original_word = original_word.encode("ascii","strict")
                        original_word = str(original_word)
                        original_word = original_word.decode("utf8")  # has to exactly match the qlistwidget items
                        error_found_list.append(original_word)  #keeps the capitalization of the original word.
                        is_valid = False
                else:
                    new_change_pairs_item.setForeground(Qt.darkBlue)
                    is_valid = False

                self.user_change_pairs_qlist.addItem(new_change_pairs_item)
                new_change_pairs_item.setHidden(False)
                del new_change_pairs_item
        #END FOR
        try:
            del saved_user_change_pairs
            del tmp_list
            del s_list
            del tmp_set
            del user_protected_data_full_path
            del f
        except:
            pass

        found_list = []
        all_items = []

        if self.change_pairs_already_loaded:        # so must execute self.edit_change_pairs() twice upon startup to check for errors
            if self.found_change_pairs_crosscheck_errors:
                warning_dialog(self.gui, _("'Change Pairs' Have Cross-check Errors!"),\
                _("You have at least one 'Change Pair' that contains one of your custom 'Bad' words: <br><br>" + word_list_of_crosscheck_errors_string + "  "), show=True)
                for search_string in error_found_list:
                    found_items = self.user_change_pairs_qlist.findItems(search_string,(Qt.MatchContains|Qt.MatchWrap) )
                    if found_items:
                        if isinstance(found_items,list):
                            for item in found_items:
                                found_list.append(item)
                            del found_items
                        else:
                            pass
                    else:
                        pass
                #END FOR
                if found_list:
                    is_valid = False
                    for index in xrange(self.user_change_pairs_qlist.count()):
                        all_items.append(self.user_change_pairs_qlist.item(index))
                    #END FOR
                    for item in all_items:
                        if item in found_list:
                            item.setHidden(False)     #only show the items failing the crosscheck with bad words, and hide the rest
                            #~ item.setSelected(True)
                        else:
                            item.setSelected(False)
                            item.setHidden(True)
                    #END FOR
                else:
                    pass
            else:
                pass
        else:
            pass

        self.error_found_change_pairs_list = list(error_found_list)

        del word_list_of_crosscheck_errors_string
        del error_found_list
        del found_list
        del all_items

        self.change_pairs_already_loaded = True

        return is_valid

    #-----------------------------------------------------------------------------------------------
    def add_item_change_pairs(self):

        if not self.change_pairs_already_loaded:
            return

        new_change_pairs_item = QListWidgetItem("? : ?")
        new_change_pairs_item.setFlags(new_change_pairs_item.flags() | Qt.ItemIsEditable)
        new_change_pairs_item.setFont(self.text_font)
        new_change_pairs_item.setForeground(Qt.darkGreen)
        self.user_change_pairs_qlist.insertItem(0,new_change_pairs_item)
        del new_change_pairs_item
        self.update_change_pairs_groupbox_title()
    #-----------------------------------------------------------------------------------------------
    def delete_item_change_pairs(self):

        if not self.change_pairs_already_loaded:
            return

        current_row = self.user_change_pairs_qlist.currentRow()
        self.user_change_pairs_qlist.takeItem(current_row)
        self.update_change_pairs_groupbox_title()

    #-----------------------------------------------------------------------------------------------
    def purge_all_change_pairs(self):

        if not self.change_pairs_already_loaded:
            return

        if question_dialog(self.gui, _('Purge All of the Change Pairs?'),_('Purge All of the Change Pairs?  Are you sure?')) :
            self.user_change_pairs_qlist.clear()
        self.update_change_pairs_groupbox_title()
    #-----------------------------------------------------------------------------------------------
    def save_change_pairs(self):

        is_valid = False

        if not self.change_pairs_already_loaded:
            return is_valid

        items = []
        for index in xrange(self.user_change_pairs_qlist.count()):
             items.append(self.user_change_pairs_qlist.item(index))
        words_list = [(unicode(i.text()) + "|") for i in items]

        selection = "change_pairs"
        user_protected_data_full_path = self.build_user_protected_data_full_path(selection)

        my_outfile = open(user_protected_data_full_path, 'w')

        for pair in words_list:
            if pair > " ":
                if  not "? : ?" in pair:
                    if  not "?" in pair:
                        if ":" in pair:
                            if "|" in pair:
                                #~ pair = pair.lower()       # no.   change pairs support UPPERCASE, Titlecase, and lowercase rules.
                                pair = pair.replace(" ", "")
                                pair = pair.strip()
                                if len(pair) > 6:
                                    pair = pair.encode("ascii","strict")
                                    my_outfile.write(pair)
        my_outfile.close()

        del items
        del words_list
        del my_outfile
        del user_protected_data_full_path

        self.found_change_pairs_crosscheck_errors = False

        is_valid = self.edit_change_pairs()   #reload the saved list, resorted and with no duplicates

        self.update_change_pairs_groupbox_title()

        return is_valid

    #-----------------------------------------------------------------------------------------------
    def update_change_pairs_groupbox_title(self):
        n = self.user_change_pairs_qlist.count()
        n = unicode(n)
        count =  " [" + n + "]"
        self.change_pairs_groupbox_title_full = self.change_pairs_groupbox_title_literal + count
        self.user_change_pairs_groupbox.setTitle(self.change_pairs_groupbox_title_full)
    #-----------------------------------------------------------------------------------------------
    def delete_change_pairs_errors_from_user_bad_words_list(self):

        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh
        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist  # refresh

        n_num = self.user_bad_words_qlist.count()
        for word in self.error_found_change_pairs_list:
            s_split = word.split(":")
            if len(s_split) == 2:
                word_in = s_split[0]
                word_out = s_split[1]
                for x in range(0,2):
                    if x == 0:
                        word = word_in
                    else:
                        word = word_out
                    for index in range(0,n_num):
                        self.user_bad_words_qlist.setCurrentRow(index)
                        item = self.user_bad_words_qlist.currentItem()
                        if item:
                            value = item.text()
                        else:
                            self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist   #the qlist has changed since an item was taken
                            self.user_bad_words_qlist.setCurrentRow(index)
                            item = self.user_bad_words_qlist.currentItem()
                            if item:
                                value = item.text()
                            else:
                                continue

                        if value == word:
                            if DEBUG: print("value: ", str(value), " of index: ", str(index) )
                            if DEBUG: print("word: ", word)
                            if DEBUG: print("MATCH:  bad word will be deleted: ", value, str(index))
                            try:
                                self.user_bad_words_qlist.takeItem(index)
                            except Exception as e:
                                if DEBUG: print("exception: ", str(e))
                            self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist   #the qlist has changed since an item was taken
                            self.my_saved_bad_words_crossheck_list.remove(word)  #otherwise list will not be refreshed until the user switches to that tab and does something to that tab's data
                            break
                        else:
                            continue
                    #END FOR
                #END FOR
            else:
                continue
        #END FOR

        self.user_bad_words_qlist = self.ENFUserListsTab_A.user_bad_words_qlist

        self.save_bad_words()   # must do first to get self.my_saved_bad_words_crossheck_list updated before saving plurals

        self.my_saved_bad_words_crossheck_list =  self.ENFUserListsTab_A.my_saved_bad_words_crossheck_list    # refresh since rebuilt by self.save_bad_words()

        self.save_change_pairs()  # which calls self.edit_change_pairs after saving, which will re-validate using the refreshed list from above.

    #-----------------------------------------------------------------------------------------------
    def import_list_of_change_pairs(self):

        if iswindows:
            windows_user_name = get_windows_username()
            if DEBUG: print("windows_user_name",windows_user_name)
            s = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']
            if s == unicode("/"):  #prefs.defaults
                s = "C:/Users/[WINDOWSUSERNAME]/Desktop"
                s = s.replace("[WINDOWSUSERNAME]",windows_user_name)
                prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH'] = unicode(s)

        self.import_last_file_path = prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_import_list_of_change_pairs"
        title = "Choose the text file with the list of change_pairs words you wish to import"

        if iswindows:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New change_pairs Words",self.import_last_file_path,("Text Files (*.txt *.text)") )
        else:
            import_tuple = QFileDialog.getOpenFileName(self,"Import Simple Text File List of New change_pairs Words",self.import_last_file_path,("Text Files (*.*)") )

        import_file, dummy = import_tuple

        self.import_last_file_path = import_file

        prefs['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.import_last_file_path)

        prefs

        imported_user_change_pairs = []

        if os.path.exists(import_file):
            try:
                with open(import_file, 'r') as f:
                    lines = f.readlines()
                    for line in lines:
                        if line:
                            line = line.encode("ascii", "strict")
                            line = str(line)
                            line = str(line.replace("\r",""))
                            line = str(line.replace("\n",""))
                            line = str(line.replace("\t",""))
                            line = str(line.replace("\v",""))
                            line = str(line.replace(" ",""))
                            line = str(line.strip())
                            if not line.isalpha():  #should not be alpha, since it needs a : delimiter
                                s = str(line.replace(":",""))
                                s = s.strip()
                                if s.isalpha():  # okay; must be all alpha excluding the colon :
                                    #~ line = str(line.lower())    # no.  mixed cases are supported for change pairs.
                                    imported_user_change_pairs.append(str(line))
                                else:
                                    continue
                            else:
                                continue
                        else:
                            continue
                    #END FOR
                #END WITH
                f.close()
                del import_file
            except Exception as e:
                return
        else:
            return

        tmp_set = set(imported_user_change_pairs)
        tmp_list = list(tmp_set)   #no more duplicates
        del tmp_set
        del imported_user_change_pairs

        tmp_list.sort()
        for row in tmp_list:
            row = row.encode("ascii","strict")
            row = str(row)
            row = row.decode("utf8")
            new_change_pairs_item = QListWidgetItem("dummy")
            value =  new_change_pairs_item.text()
            new_change_pairs_item.setText(row)
            value =  new_change_pairs_item.text()
            new_change_pairs_item.setFlags(new_change_pairs_item.flags() | Qt.ItemIsEditable)
            new_change_pairs_item.setFont(self.text_font)
            new_change_pairs_item.setForeground(Qt.darkMagenta)
            self.user_change_pairs_qlist.insertItem(0,new_change_pairs_item)
            value =  new_change_pairs_item.text()
        #END FOR

        self.change_pairs_already_loaded = True

        is_valid = self.save_change_pairs()

    #-----------------------------------------------------------------------------------------------
    def export_change_pairs(self):

        self.export_last_file_path = prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']

        name = "choose_export_list_of_change_pairs"
        title = "Choose the text file name that you wish to create or replace"

        tmp_full_path = os.path.join(self.export_last_file_path,'enf_export_change_pairs.txt')

        export_tuple = QFileDialog.getSaveFileName(self,"export Simple Text File List of Change Pairs",tmp_full_path,("Text Files (*.txt *.text *.csv )") )

        export_file, dummy = export_tuple

        if DEBUG: print("export file: ", export_file)

        self.export_last_file_path = export_file

        prefs['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']  = unicode(self.export_last_file_path)

        prefs

        items = []
        for index in xrange(self.user_change_pairs_qlist.count()):
            items.append(self.user_change_pairs_qlist.item(index))
        #END FOR

        words_list = [(unicode(i.text()) + "\n") for i in items]

        del items

        words_string = ""
        for row in words_list:
            words_string = words_string + row

        del words_list

        words_string = words_string.encode("ascii","strict")
        words_string = str(words_string)

        try:
            with open(export_file, 'w') as f:
                f.write(words_string)
            #END WITH
            f.close()
            del export_file
            del words_string
        except Exception as e:
            if DEBUG: print("export file error: ", str(e))
            return

    #--------------------------------------

    #-----------------------------------------------------------------------------------------------
    def build_user_protected_data_full_path(self,selection):

        if self.user_protected_data_directory == "unknown":
            self.build_user_protected_directory_path()

        user_protected_data_full_path = "unknown"

        if selection == "plural_pairs":
            file_name = USER_CUSTOM_WORD_RULES_SINGULAR_PLURAL_PAIRS_FILENAME
            file_name.encode("ascii", "strict")
            file_name = str(file_name)
            file_name = file_name.decode(filesystem_encoding)
            user_protected_data_full_path = os.path.join(self.user_protected_data_directory, file_name )       #   /calibre/plugins/enf/user_singular_plural_pairs.txt
            user_protected_data_full_path = user_protected_data_full_path.replace(os.sep, '/')
            return  user_protected_data_full_path

        if selection == "change_pairs":
            file_name = USER_CUSTOM_WORD_RULES_CHANGE_PAIRS_FILENAME
            file_name.encode("ascii", "strict")
            file_name = str(file_name)
            file_name = file_name.decode(filesystem_encoding)
            user_protected_data_full_path = os.path.join(self.user_protected_data_directory, file_name )       #   /calibre/plugins/enf/user_change_pairs.txt
            user_protected_data_full_path = user_protected_data_full_path.replace(os.sep, '/')
            return  user_protected_data_full_path

        if DEBUG: print("user_protected_data_full_path: ", user_protected_data_full_path)

        return user_protected_data_full_path

    #--------------------------------------------------------------------------------------------------
    def build_user_protected_directory_path(self):

        self.user_protected_data_path = self.my_plugin_path
        self.user_protected_data_path = self.user_protected_data_path.replace("\English Noun Frequency.zip", "")
        self.user_protected_data_path = self.user_protected_data_path.replace("/English Noun Frequency.zip", "")

        self.user_protected_data_directory = self.user_protected_data_path

        sub_directory = str("enf_files")
        sub_directory = sub_directory.decode(filesystem_encoding)

        self.user_protected_data_directory =  os.path.join(self.user_protected_data_directory, sub_directory)

        self.user_protected_data_directory.encode("ascii", "strict")

        self.user_protected_data_directory = str(self.user_protected_data_directory)

        self.user_protected_data_directory = self.user_protected_data_directory.decode(filesystem_encoding)

        self.user_protected_data_directory = self.user_protected_data_directory.replace(os.sep, '/')         #   /calibre/plugins/enf_files

        if not os.path.exists(self.user_protected_data_directory):
            os.makedirs(self.user_protected_data_directory)

#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class ENFFaqTab(QWidget):

    def __init__(self,gui,icon,guidb,my_plugin_path):
        super(ENFFaqTab, self).__init__()


        #-----------------------------------------------------
        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        self.icon = icon
        #-----------------------------------------------------
        self.my_plugin_path = my_plugin_path

        self.plugins_directory = self.my_plugin_path
        self.plugins_directory =  self.plugins_directory.replace("\English Noun Frequency.zip","/")     #  "C:\Users\DaltonST\AppData\Roaming\calibre\plugins\English Noun Frequency.zip"
        self.plugins_directory =  self.plugins_directory.replace("/English Noun Frequency.zip","/")

        if isbytestring(self.plugins_directory):
            self.plugins_directory = self.plugins_directory.decode(filesystem_encoding)
        self.plugins_directory = self.plugins_directory.replace(os.sep, '/')

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.faq_tab_layout = QGridLayout()
        self.faq_tab_layout.setSpacing(0)
        self.faq_tab_layout.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.faq_tab_layout)
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(12)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.faq_buttonbox = QDialogButtonBox()
        self.faq_buttonbox.setOrientation(Qt.Horizontal)
        self.faq_buttonbox.setCenterButtons(True)
        self.faq_tab_layout.addWidget(self.faq_buttonbox,1,0,6,0)

        self.faq_button = QPushButton(" ", self)
        self.faq_button.setText("Frequently Asked Questions")
        self.faq_button.clicked.connect(self.open_browser_faq)
        self.faq_button.setFont(font)
        self.faq_button.setToolTip("<p style='white-space:nowrap'>'Frequently Asked Questions' comprise the bulk of the User Guide, <br>\
                                                    which by design is made available to you on a 'decentralized' basis.<br><br>\
                                                    In addition to the FAQs, the User Guide is comprised of:  <br><br>\
                                                    Widget 'Tooltips';<br><br>\
                                                    Clear labeling of the 'name' or 'purpose' of each Widgets; <br><br>\
                                                    Detailed statistics, counts, and other information within each Job Log;  and,<br><br>\
                                                    The 'Example' shown below the FAQ push-button. <br><br>")
        self.faq_button.setMaximumWidth(250)
        self.faq_button.setMinimumHeight(30)
        self.faq_button.setMaximumHeight(30)

        self.faq_buttonbox.addButton(self.faq_button,0)
        #-----------------------------------------------------
        font.setBold(False)
        font.setPointSize(9)

        self.about_qtextedit =  QTextEdit("")
        self.about_qtextedit.setReadOnly(True)

        self.about_qtextedit.setWordWrapMode(QTextOption.NoWrap)
        self.about_qtextedit.clear()

        self.about_html = self.initialize_about_html()

        self.about_qtextedit.setHtml(self.about_html)

        self.faq_tab_layout.addWidget(self.about_qtextedit,15,0,40,0)

        self.about_qtextedit.setToolTip("<p style='white-space:nowrap'>This is a typical example of how Comments created by ENF might look, <br>\
                                                            excluding of course the explanatory text above the phrase 'Most Frequent Nouns'. <br><br>")

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------

        self.faq_html_path,self.faq_html = self.initialize_faq_html()
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
    def open_browser_faq(self):
        try:
            p_pid = subprocess.Popen(self.faq_html_path, shell=True)
        except:
            return
#--------------------------------------------------------------------------------------------------
    def initialize_about_html(self):
        self.about_html = self.return_about_html()      #about does not use a browser, so no file needed to launch a subprocess
        return self.about_html
#--------------------------------------------------------------------------------------------------
    def initialize_faq_html(self):
        self.faq_html = self.return_faq_html()
        #----------------------------
        #----------------------------------------------------------------------------------------------
        # FAQ is too large for a Calibre info_dialog box to fit ergonomically.  So, a browser will be opened using the file path below. The data is still html in a single string down below.
        #----------------------------------------------------------------------------------------------
        path = self.plugins_directory
        s_subdirectory = str("enf_files")
        s_subdirectory =  s_subdirectory.decode(filesystem_encoding)
        path = os.path.join(path, s_subdirectory)
        path = path.replace(os.sep, '/')
        if not os.path.exists(path):
            os.makedirs(path)
        s_filename = "faq.html"
        if isbytestring(s_filename):
             s_filename =  s_filename.decode(filesystem_encoding)
        path = os.path.join(path, s_filename)
        path = path.replace(os.sep, '/')

        self.faq_html_path = path

        my_outfile = open(self.faq_html_path, 'w')
        s = str(self.faq_html)
        my_outfile.write(s)
        my_outfile.close()
        #----------------------------
        return self.faq_html_path,self.faq_html
#--------------------------------------------------------------------------------------------------
    def return_about_html(self):
        #very simple html since a Calibre info_dialog will be used, not a browser.
        about_html = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><html><head><meta http-equiv="content-type" content="text/html; charset=utf-8"/><title></title><meta name="generator" content="LibreOffice 4.4.3.2 (Windows)"/></head><body lang="en-US" dir="ltr"><p align="center" style="margin-bottom: 0in"> <font size="4" style="font-size: 16pt"><b>Word Frequencies for Nouns</b></font> <br/> <font face="Times New Roman, serif"> <font size="4" style="font-size: 14pt"><b>__________________________________________________</b></font></font> <font face="Times New Roman, serif"> <br/> <br/></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt">The Selfish Gene by Richard Dawkins (1977)</font></font> <font color="#000000"> <font face="Times New Roman, serif"></font></font></p><div> <br> <br><center><b>Most Frequent Words</b> <br>                    Gene <br>                    Individual <br>                    Male <br>                    Female <br>                    Species <br>                    Strategy <br>                    Population <br>                    Selection <br>                    Egg <br>                    Cell <br>                    Animal <br>                    Survival <br>                    Theory <br>                    Evolution <br>                    Machine <br>                    Behaviour <br>                    Benefit <br>                    Example <br>                    Effect <br>                    Human <br>                    Chapter <br>                    Genetics <br>                    Replicator <br>                    Pool <br>                    Altruism <br>                    Generation <br>                    Unit <br>                    Sex <br>                    Term <br>                    Means <br>                    Brother <br>                    Meme <br>                    Use <br>                    Bird <br>                    Whole <br>                    Cuckoo <br>                    Chromosome <br>                    Look <br>                    Average <br>                    Sperm <br>                    Worker <br>                    Tat <br>                    Sense <br>                    Molecule <br>                    Advantage <br>                    Baby <br>                    Dove <br>                    Future <br>                    Rival <br>                    Cost <br>                    Chance <br>                    View <br>                    Form <br>                    Matter <br>                    Plant <br>                    Sister <br>                    Computer <br>                    Copy <br>                    Organism <br>                    Predator <br>                    General <br>                    Set <br>                    Fight <br>                    Nest <br>                    Host <br>                    Turn <br>                    Hawk <br>                    Defect <br>                    Half <br>                    Order <br>                    Play <br>                    Parasite <br>                    Size <br>                    Resource <br>                    Call <br>                    Instance <br>                    Share <br>                    Snail <br>                    Win <br>                    DNA <br>                    Interest <br>                    Living <br>                    Nature <br>                    Course <br>                    Need <br>                    Relatedness <br>                    Risk <br>                    Mutual <br>                    Argument <br>                    Investment <br>                    Player <br>                    Purpose <br>                    Queen <br>                    Favour <br>                    Influence <br>                    Ratio <br>                    Start <br>                    Axelrod <br>                    Complex <br>                    Brain <br><b>_______________________</b></center> <br> <br></div></body></html>'
        return about_html
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
    def return_faq_html(self):
        #valid html document since this html will be opened in a browser.
        faq_html = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><html><head><meta http-equiv="content-type" content="text/html; charset=utf-8"/><title></title><meta name="generator" content="LibreOffice 4.4.4.3 (Windows)"/><meta name="created" content="00:00:00"/><meta name="changed" content="2015-08-02T15:06:58.880000000"/><style type="text/css">  @page { size: landscape; margin: 0.12in }   p { margin-bottom: 0.1in; line-height: 120% }   a:link { so-language: zxx }</style></head><body lang="en-US" dir="ltr"><p align="left" style="margin-left: 0.49in; margin-top: 0.17in; margin-bottom: 0.2in; line-height: 150%"><u> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <font size="6" style="font-size: 22pt"><b>Frequently Asked Questions about “English Noun Frequency</b></u></font> <font size="6" style="font-size: 22pt"> <span style="text-decoration: none"><b>”</b></span></font> <span style="text-decoration: none"></span> <span style="text-decoration: none"> <font size="2" style="font-size: 10pt">[</font></span> <span style="text-decoration: none"> <font size="2" style="font-size: 10pt"> <span style="font-weight: normal">V1.0.0]</span></font></span></font></font></p><p align="center" style="line-height: 150%"> <br/> <br/></p><ol> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>Wh</b><b>ere  is the User Guide? <br/> <br/></b> <span style="text-decoration: none"><u><b>Answer:</b></u></span> <span style="text-decoration: none"><b> </b></span> <span style="font-weight: normal">The “User Guide” is  decentralized.  The “tool tips” provide clear, detailed  information.  The labels of buttons and checkboxes also   are clear.   The Job Log has a great deal of information to help you understand  your results and how they came about.  Finally, the “Frequently  Asked Questions” provide additional information about ENF as a  whole.  Taken together, these elements comprise the “User Guide”. <br/></span></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>What  is the strategic purpose of “English Noun Frequency”? </b> <br/> <br/> <span style="text-decoration: none"><u><b>Answer:</b></u></span> <span style="text-decoration: none"></span>To allow you to grok at a glance what a book is about in  English and, optionally, a second language. <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>Why  </b><b>is</b><b> it needed? Books have authors, titles, tags and  comments.</b> <br/> <br/> <span style="text-decoration: none"><i><u><b>Answer:</b></u></i></span> <span style="text-decoration: none"></span>As a solution for plain-text ebooks with no title, author,  tags or comments. Nothing necessary to download basic metadata from  the web. Just plain text. <br/> <br/>Additionally, regardless of  the English metadata available, those readers for whom English is a  second language have the option of viewing the results not only in  English, but a second language.  That ability would not otherwise  exist. <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>What  second languages are available for use? <br/></b> <br/> <span style="text-decoration: none"><i><u><b>Answer:</b></u></i></span>Spanish is offered as a "standard" second language choice. That is because it is the only language for which the developer desired to build and test a digital file with 5,000+ UTF8-encoded noun translation pairs (in this case, English noun to Spanish noun).                            Any other language can easily be used by specifying a user custom "English to Other Language" translation pairs file to use. For Spanish, since it is "standard", any optionally specified user custom file may be used to supplement and/or override the "standard" translation list.  The user custom list takes precedence over the standard list. <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>Why  would someone with “real” books that have full metadata need or  want to use this?</b> <br/> <br/> <span style="text-decoration: none"><i><u><b>Answer:</b></u></i></span> They do not “need” it, but they may “want” it, because it  can create very interesting results. It not only achieves its  strategic objective of allowing you to grok at a glance what a  single, particular book is about, but also allows you to have  automatically accumulated into a single spreadsheet .csv file the  frequency results of all of your books in all of your Calibre  libraries. You then have a database of what nouns are the most  common, not only relative to each other, but also absolutely. The  exact word-count for each noun used in every book in your library is  summarized into a single number across all of your books for which  you executed ENF. <br/> <br/>For example, you might find that the  word “neuroscience” occurs 468 times in your library. You could  then simply search the comments (to which ENF can prepend or append  the Top Nouns) of all of your books (even cross-library using the  MultiColumnSearch plug-in) to find the word “neuroscience”. <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>How  does it fulfill that goal?</b> <br/> <br/> <span style="text-decoration: none"><i><u><b>Answer:</b></u></i></span> <span style="text-decoration: none"></span>It creates Comments and/or Tags and/or updates a Custom  Column with the “Top N Most Frequent Nouns”. N is a number from  1-100 that you choose separately for Comments, Tags and a Custom  Column for the books you select to be updated. <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>What  formats of ebooks are supported?</b> <br/> <br/> <span style="text-decoration: none"><i><u><b>Answer:</b></u></i></span> TXT, EPUB, PDF. Other formats can be easily converted by Calibre to  any of the supported formats. ENF uses only plain text lower case  English letters from a to z. It converts all extracted text to lower  case before analyzing. <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>What  genres of ebooks create meaningful results?</b> <br/> <br/> <span style="text-decoration: none"><i><u><b>Answer:</b></u></i></span> The continuum ranges from Factual/Nonfiction (the best results with  the fewest proper nouns) to “Tawdry Romance Fiction”.  For the  latter, the most frequent common nouns are predictable.  Fortunately  for young readers, no verbs, words derived from verbs, adjectives or  obscenities are ever in the final list.   For Fiction in general,  there tend to be many more proper nouns (names of fictional  characters) than for Factual books. <br/> <br/>There is a Job option  for ENF to discard any proper noun found in its globally-derived  list of first names, which as of version 1.0.0 contained over 3,800. <br/> <br/>Surnames are unavoidable due to the immeasurable number  of them.  Not many characters in fictional works have last names  such as “Smith”, “Jones”, “Williams”, “Brown” or  “Wilson”. <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>What  dialects of English are supported?</b> <br/> <br/><u><b>Answer:</b></u> No specific version of English was targeted “by design”.  Indeed, a grammar engine that it uses to determine the singular for  plural nouns that ENF does not already know was developed based  primarily on the Oxford English Dictionary, although with a nod  towards American English spelling.  For basic common nouns, ENF was  loaded with a true mixture of both British English and American  English spellings.  Since Canadian English is a mixture of British  and American English, it was implicitly loaded as well. <br/> <br/>It  has been tested with hundreds of books written in British English  and American English, but there is no reason it should not perform  comparably for Australian English, New Zealand English, Indian  English, South African English, and the rest. <br/></font></font> <br/> <br/></p> <li/><p align="left" style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>Why  would the dialect of English matter?</b></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <br/> <br/></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><u><b>Answer:</b></u></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt">Overwhelmingly,  it would not.</font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt">At  all.</font></font> <font face="Times New Roman, serif"><font size="4" style="font-size: 16pt">  However, the methodology that ENF uses to ignore non-nouns could  not possibly take into account verbs, words derived from verbs,  adjectives, adverbs, pronouns, interjections, conjunctions,  articles, and other parts of speech that simply do not exist in  Standard English. However, written English, not spoken English, is  what matters to ENF, and written English tends to adhere much more  closely to Standard English than any spoken English dialect.  Although “you” would be written, its spoken form might be,  besides “you”,</font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt">a</font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt">colloquial  replacement such as: “</font></font> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal">you  all”, “yous” or “youse"</span></span></font></font></span></span> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal"></span></span></font></font></span></span> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal">,  “you lot”, “you guys”, “you-uns”, “yinz”, “yall”,</span></span></font></font></span></span> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal">and</span></span></font></font></span></span> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal">“ye”,  as in  “Whitre ye daeing, mon?”,</span></span></font></font></span></span> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal">plus</span></span></font></font></span></span> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal">others</span></span></font></font></span></span> <span style="font-variant: normal"> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-style: normal"> <span style="font-weight: normal">.</span></span></font></font></span></span> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <br/></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>What  </b></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>could  an ENF user do to alter the outcome of certain English nouns that  they may find undesirable, or would like changed to a synonym</b></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>?</b></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <br/> <br/></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><u><b>Answer:</b></u></font></font> <span style="text-decoration: none"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"></font></font></span> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-weight: normal">ENF  contains extensive functionality for “Custom User Word Lists”  that can be used to add, delete</span></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-weight: normal">or  combine</span></font></font> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"> <span style="font-weight: normal"> words. <br/></span></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>My  books have many words borrowed by English from languages that use  diacritics. The diacritics disappear when shown as new Tags. Why?</b> <br/> <span style="font-weight: normal"> <br/></span><u><b>Answer:</b></u><span style="font-weight: normal">All text extracted from a book is  converted to plain text. Any character that is not a simple a to z  (everything is converted to lower case so determining frequency will  be accurate), or a blank space (which delimits each single word), is  discarded. Letters with diacritics are converted to their closest  English equivalent. Example:</span> <span style="font-variant: normal"> <span style="font-style: normal"> <span style="font-weight: normal">fiancée</span></span></span> <span style="font-weight: normal">becomes  “fiancee.” In some English dialects, notably American English,  the proper spelling is “fiancee”. <br/></span></font></font> <br/> <br/></p> <li/><p style="line-height: 150%"> <font face="Times New Roman, serif"> <font size="4" style="font-size: 16pt"><b>I  have </b><b>mostly PDFs.</b><b> I get odd results. Why? <br/> <br/></b><u><b>Answer:</b></u> <span style="font-weight: normal">The PDF format was</span><u> <span style="font-weight: normal">specifically  designed</span></u> to accurately print to a <u>physical piece of  paper</u> on any printer that prints to paper. <br/>Any text  extraction issues encountered by ENF are due to the PDF format, and  nothing can be done unless you convert from PDF to a “proper”  ebook format, and then manually correct any conversion errors caused  by conflicts between the PDF-specific design objectives and design  specifications and the need to extract properly formatted text to  save to a file rather than to print to a printer. <br/> <br/>“Text”  that is really an image (such as from scanned books converted to a  PDF) cannot be extracted because there is precious little “text”  to extract. <br/> <br/> <span style="font-weight: normal">Having said  the above, ENF uses a modified copy of the Calibre PDF  conversion-to-text logic, so it performs a best-efforts</span> <span style="font-weight: normal">attempt to extract its plain text  in a proper manner.</span></font></font></p></ol></body></html>'
        return faq_html
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#END of enf_dialog.py