# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.9"     #  Obfuscation of obscenities now optional.

from PyQt5.Qt import (Qt, QDialog, QLabel, QVBoxLayout, QHBoxLayout, QFormLayout, QWidget, QPushButton,
        QGridLayout, pyqtSignal, QDialogButtonBox, QScrollArea, QFont, QPalette, QColor, QCheckBox,
        QTabWidget, QIcon, QToolButton, QSplitter, QGroupBox, QSpacerItem, QLineEdit,QSpinBox,
        QSizePolicy, QFrame, QSize, QKeySequence, QMenu, QShortcut, QMargins)

from calibre.utils.config import JSONConfig

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/English Noun Frequency')

# Set defaults
prefs.defaults['COMMENTS_MAX'] = unicode(100)
prefs.defaults['COMMENTS_CHECKBOX'] = unicode("True")
prefs.defaults['COMMENTS_PREPEND_APPEND_REPLACE'] = unicode("append")
prefs.defaults['COMMENTS_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode("True")

prefs.defaults['TAGS_MAX']  = unicode(3)
prefs.defaults['TAGS_CHECKBOX'] = unicode("False")
prefs.defaults['TAGS_REPLACE_ADD'] = unicode("add")

prefs.defaults['CUSTOM_COLUMN_MAX'] = unicode(10)
prefs.defaults['CUSTOM_COLUMN_CHECKBOX'] = unicode("False")
prefs.defaults['CUSTOM_COLUMN_NAME'] = unicode("#enf")
prefs.defaults['CUSTOM_COLUMN_SORT_ALPHA'] = unicode("False")

prefs.defaults['OTHER_CHECKBOX_ONLY_LOG_COMMENTS'] = unicode("False")
prefs.defaults['OTHER_REMOVE_PREVIOUS_ENF_COMMENTS_CHECKBOX'] = unicode("False")

prefs.defaults['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE']  = unicode("False")
prefs.defaults['OTHER_SAVE_ALL_MOST_COMMON_TO_CSV_FILE_FULL_PATH']  = unicode("/")
prefs.defaults['OTHER_SAVE_ALL_MOST_COMMON_TO_FILE_PAUSE']  = unicode("False")

prefs.defaults['DIALOG_ONLY_LAST_IMPORTED_TEXT_FILE_FULL_PATH']  = unicode("/")
prefs.defaults['DIALOG_ONLY_LAST_EXPORTED_TEXT_FILE_FULL_PATH']  = unicode("/")

prefs.defaults['REMOVE_GLOBAL_FIRST_NAMES'] = unicode("True")
prefs.defaults['REMOVE_TOP_100_NOUNS'] = unicode("True")

prefs.defaults['TRANSLATE_ENGLISH_TO_OTHER_IS_ACTIVE'] = unicode("False")
prefs.defaults['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE'] = unicode("Español")
prefs.defaults['TRANSLATE_ENGLISH_TO_OTHER_LANGUAGE_USER_DICT_FILE'] = unicode("Select Custom Translation File")

prefs.defaults['OBFUSCATE_OBSCENITIES'] = unicode("True")


class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(12)

        self.label1 = QLabel()
        self.label1.setTextFormat(1)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within ENF               </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False

#END of config.py

