# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2016, 2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.8"   # Create a simple menu so there can be a Preferences > Keyboard shortcut...

from calibre.customize import InterfaceActionBase

class ActionBaseDropSearchResults(InterfaceActionBase):

    name                    = 'Drop Search Results'
    description           = "Drag-and-Drop Search Results from most search software (e.g. 'Agent Ransack', 'X1', Windows Search) into Calibre so that the books that were found can be automatically marked and displayed."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 8)
    minimum_calibre_version = (2, 52, 0)

    actual_plugin       = 'calibre_plugins.drop_search_results.ui:ActionDropSearchResults'

    gui_name = 'Drop Search Results'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__py
#This plugin cannot be run in command-line mode.