# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.0.30"  # Technical changes for Calibre 3.0.0 compatibility.

from calibre.constants import DEBUG, iswindows
from calibre.db.legacy import LibraryDatabase
from calibre.utils.config import prefs

#-----------------------------------------------------------------------------------------
def calm_cli_add_custom_column(param,dbpath):

    #~ param = '--is-multiple(or mdummy)|||' + display  + '|||' + label + '|||' + '"[NAME]"' + '|||' +  datatype


    if "is-multiple" in param:
        is_multiple = True
        param = param.replace("--is-multiple","").strip()
    else:
        is_multiple = False
        param = param.replace("mdummy","").strip()

    if param.startswith("|||"):
        param = param.replace("|||","",1).strip()

    param = param.strip()

    if DEBUG: print("final param:", param)

    args = param.split("|||")
    args_list = []
    for s in args:
        args_list.append(s)
        if DEBUG: print("arg: ", str(s))
    #END FOR

    display = args_list[0]

    if "dblank" in display:
        display = {}
    else:
        #~ --display="{\"enum_values\":[\"a\", \"b\", \"c\", \"d\", \"e\", \"f\", \"g\", \"h\"]}"      # JSON format works too...since calibredb uses a JSON format...
        display = display.replace("--display=","")
        display = display.strip()

    label = args_list[1]

    name = args_list[2]
    name = name.replace('"','').strip()

    datatype = args_list[3]

    if DEBUG:
        msg = "The final values to be used are: " + str(label) + " " + str(name) + " " + str(datatype) +" with display: " +  str(display) + " with is-multiple: " + str(is_multiple)

    db = LibraryDatabase(dbpath)

    msg = None

    try:
        db.create_custom_column(label, name, datatype, is_multiple, display=display)
    except Exception as e:
        msg = "Exception in db.create_custom_column creating new custom column: " + str(e)
        msg = msg + "   The failed parameter used was: "  + str(label) + " " + str(name) + " " + str(datatype) +" with display: " +  str(display) + " with is-multiple: " + str(is_multiple)
        if (str("unique") in msg or str("Unique") in msg) and (str("enumeration") in msg):
            msg = msg + "<br><br> You MUST standardize your enumeration (fixed set of values) custom column search names (labels) before continuing!  <br><br>"
        if DEBUG: print(msg)
        return msg

    if DEBUG: print("CALM Custom Column created:  ", label, "  ", name, "  ", datatype)

    # Re-open the DB so that  field_metadata is reflects the column changes
    db.prefs['field_metadata'] = db.field_metadata.all_metadata()

    del param

    return msg

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
#END of calm_cli_custom_columns.py
