# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.0.32"  # Calibre Standard Schema Version of template metadata.db updated to Version 23 by Calibre itself.

from calibre.customize import InterfaceActionBase

class ActionBaseConsolidateAllLibraryMetadata(InterfaceActionBase):

    name                    = 'Consolidate All Library Metadata'
    description           = "Consolidate a Snapshot of All Metadata, including Custom Columns, from All of the Books in All of your Libraries for Review, Analysis and Standardization using Powerful Tools; Shuffle Books Among your Calibre Library Ecosystem; Perform Centralized Library Maintenance."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (2, 0, 32)
    minimum_calibre_version = (2, 40, 0)

    actual_plugin           = 'calibre_plugins.consolidate_all_library_metadata.ui:ActionConsolidateAllLibraryMetadata'                             # the special .txt file name has the substring "consolidate_all_library_metadata"

    gui_name = 'Consolidate All Library Metadata'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):

        pass

    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):

        return True

    #--------------------------------------------------------------------------------------------------------------------------
    def config_widget(self):

        from calibre_plugins.consolidate_all_library_metadata.config import ConfigWidget

        return ConfigWidget()


    #--------------------------------------------------------------------------------------------------------------------------
    def save_settings(self, ConfigWidget):

        ConfigWidget.save_settings()

        # Apply the changes
        ac = self.actual_plugin_
        if ac is not None:
            ac.apply_settings()


    #-------------------------------------------

#END of __init__py