# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.0"

from PyQt5.Qt import (Qt, QDialog, QLabel, QVBoxLayout, QFont, QWidget)

class UIToastDialog(QDialog):

    def __init__(self,gui,icon,msg_num):

        QDialog.__init__(self, gui)

        self.gui = gui

        self.msg_num = msg_num

        s_msg = "Wait..."

        if self.msg_num == 0:
            s_msg = "CALM..."
        else:
            if self.msg_num == 1:
                s_msg = "...Preparing CALM Job Parameters..."
            else:
                if self.msg_num == 2:
                    s_msg = "Switch from the Special CALM Library to Elsewhere for a DB Upgrade"

        self.setWindowFlags( Qt.Widget | Qt.CustomizeWindowHint )

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()
        font.setBold(True)
        font.setPointSize(20)

        self.text_line = QLabel()
        self.text_line.setTextFormat(1)
        self.text_line.setFont(font)
        self.text_line.setText("<center><font color='#0404B4'>" + s_msg + "</font></center>")
        self.layout.addWidget(self.text_line)

        self.resize(self.sizeHint())

#END OF ui_toastdialog.py