# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.0.0"
import os, sys
from calibre.gui2.threaded_jobs import ThreadedJob, BaseJob
import traceback, cStringIO
from functools import partial
from threading import RLock
from threading import Thread, RLock, Event
from Queue import Empty, Queue
from calibre.utils.ipc.job import BaseJob
from calibre.utils.logging import Log

from calibre_plugins.consolidate_all_library_metadata.calm_consolidation import main_calm_consolidation
from calibre_plugins.consolidate_all_library_metadata.calm_derivegenres import main_calm_derive_genres
# ------------------------------------------------------------------------------
#    Functions to perform CALM using ThreadedJob
# ------------------------------------------------------------------------------
def start_threaded_calm_consolidation(self, target_db, param_dict, callback):

    job = ThreadedJob('consolidatealllibrarymetadataplugin','CALM Consolidation',main_calm_consolidation,(self,target_db,param_dict), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('The CALM Consolidation Job will update the Target Library from Selected Source Libraries'), 5000)

def start_threaded_calm_derive_genres(self, mygui, param_dict, book_ids, results_status, callback):

    guidb = mygui.library_view.model().db
    job = ThreadedJob('consolidatealllibrarymetadataplugin','CALM Derive Genres',main_calm_derive_genres,(self,guidb,book_ids,results_status), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('The CALM Derive Genres Job will update the Target Library'), 5000)

#END of jobs.py