# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2015,2016, DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.0.18"
import os, sys
import apsw
from calibre import isbytestring, force_unicode, prints
from calibre.constants import filesystem_encoding, preferred_encoding, DEBUG
from Queue import Empty, Queue
from calibre.utils.logging import Log as log
import codecs
import collections
import datetime
from datetime import datetime
import time
from time import sleep
import unicodedata
import re, sre_constants
import collections
import uuid
import zipfile
#---------------------------------------------------------------------------------------------------
from calibre_plugins.consolidate_all_library_metadata.heading import log_heading_common
from calibre_plugins.consolidate_all_library_metadata.config import prefs
#---------------------------------------------------------------------------------------------------

#----------------------------------------------
notifications = Queue()
#----------------------------------------------
my_param_dict = {}
#----------------------------------------------
source_cc_to_target_cc_mapping_dict = {}
source_custom_columns_list = []
target_cc_normalized_dict = {}
target_cc_datatype_dict = {}
#----------------------------------------------
my_target_db = "/CALM/metadata.db"
#----------------------------------------------
header_s1 = None
header_s2 = None
header_s3 = None
header_s4 = None
header_s5 = None
#----------------------------------------------
CUSTOM_COLUMN_ORIGINAL_LIBRARY_PATH_TABLE = "custom_column_6"
CUSTOM_COLUMN_ORIGINAL_BOOK_PATH_TABLE = "custom_column_5"

#----------------------------------------------------------------------------------------------------------------
def main_calm_consolidation(self, target_db,param_dict, log=None, abort=None, notifications=True):
    #----------------------------------------------------------------------------------------------------------------
    log("Starting CALM Consolidation")
    notifications.put((0.002, 'Beginning CALM Consolidation'))
    #----------------------------------------------------------------------------------------------------------------
    clear_or_initialize_globals()
    #----------------------------------------------------------------------------------------------------------------
    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    #----------------------------------------------------------------------------------------------------------------
    global my_target_db
    my_target_db = target_db
    #----------------------------------------------------------------------------------------------------------------
    global my_param_dict
    my_param_dict =  param_dict.copy()
    del param_dict

    for k,v in my_param_dict.iteritems():
        if DEBUG: print("my_param_dict: ", k, v)
    #----------------------------------------------------------------------------------------------------------------
    my_cursor,my_db,my_target_db = apsw_connect_to_target(log,my_target_db)
    mysql = str("PRAGMA main.busy_timeout = 5000")         #milliseconds
    my_cursor.execute(mysql)
    mysql = str("PRAGMA main.locking_mode = EXCLUSIVE;")
    my_cursor.execute(mysql)
    #----------------------------------------------------------------------------------------------------------------
    header_s1 =  str("SQLite Version: " + str(apsw.SQLITE_VERSION_NUMBER) + "    [APSW]")
    header_s2 = mysql
    header_s3 = "Beginning 'Consolidate All Library Metadata' "
    log_heading_common(log,header_s1,header_s2,header_s3,header_s4,header_s5)
    #----------------------------------------------------------------------------------------------------------------
    # The CALM Target Library is, by its nature, transient and temporary.  By design, it is very easy to refresh and recreate if there is a catastrophic failure.
    mysql = str("PRAGMA main.journal_mode = TRUNCATE;")     # on most os's, much faster than DELETE
    my_cursor.execute(mysql)
    mysql = str("PRAGMA main.temp_store = MEMORY;")           # always faster than FILE
    my_cursor.execute(mysql)
    mysql = str("PRAGMA main.synchronous = NORMAL;")         # faster than FULL
    my_cursor.execute(mysql)
    log(" ")
    #----------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------
    CALM_Control(my_cursor,my_db,log,notifications)
    #----------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------------------------------
    save_job_statistics(my_cursor,my_db,log,notifications)
    log(" ")
    # note:  the metadata.db in the .zip already includes a template SQLITE_STAT1 table that was manually pre-populated after multiple real CALM Consolidation test executions totalling ~50,000 books in ~18 Source Libraries
    my_cursor.execute("ANALYZE")  # https://sqlite.org/lang_analyze.html       # this will remove any SQLITE_STAT1 table rows for custom columns not in the current 'real' metadata.db, and add new ones.
    my_db.close()
    clear_or_initialize_globals()
    log(" ")
    log(" ")
    localtime = time.asctime( time.localtime(time.time()) )
    log("Job complete: " + localtime)

#----------------------------------------------------------------------------------------------------------------
def save_job_statistics(my_cursor,my_db,log,notifications):
    # Release 2.0.0

    s = datetime.strftime(datetime.now(), '%Y-%m-%d %H:%M:%S')
    prefs['CALM_LAST_CONSOLIDATION_JOB_DATETIME'] = unicode(s.strip())

    number_libraries_consolidated = unicode(0)

    mysql = "SELECT count(DISTINCT orig_library) AS number_source_libraries FROM  _all_author_xref"
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        number_libraries_consolidated = 0
    else:
        if len(tmp_rows) == 0:
            number_libraries_consolidated = 0
        else:
            for row in tmp_rows:
                for col in row:
                    number_libraries_consolidated = unicode(col)
                    if DEBUG: print("number_libraries_consolidated = unicode(col): ", number_libraries_consolidated)
                    break
                #END FOR
                break
            #END FOR


    prefs['CALM_LAST_CONSOLIDATION_NUMBER_LIBRARIES'] = unicode(number_libraries_consolidated)

    number_books_consolidated = unicode(0)

    mysql = "SELECT count(DISTINCT id) AS number_consolidated_books FROM main.books"
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        number_books_consolidated = 0
    else:
        if len(tmp_rows) == 0:
            number_books_consolidated = 0
        else:
            for row in tmp_rows:
                for col in row:
                    number_books_consolidated = unicode(col)
                    if DEBUG: print("number_books_consolidated = unicode(col): ", number_books_consolidated)
                    break
                #END FOR
                break
            #END FOR

    prefs['CALM_LAST_CONSOLIDATION_NUMBER_BOOKS'] = unicode(number_books_consolidated)

    prefs
#----------------------------------------------------------------------------------------------------------------
def CALM_Control(my_cursor,my_db,log,notifications):

    global source_custom_columns_list
    global source_cc_to_target_cc_mapping_dict
    global target_cc_normalized_dict
    global target_cc_datatype_dict

    apsw_attach_to_tools_db(my_db,my_cursor)
    source_custom_columns_list,source_cc_to_target_cc_mapping_dict = get_source_to_target_mapping_data(my_db,my_cursor,log)
    apsw_detach_from_tools_db(my_db, my_cursor)

    target_cc_normalized_dict,target_cc_datatype_dict = get_target_cc_normalized(my_db,my_cursor)

    source_path_list = determine_active_sources()

    n_total = len(source_path_list)
    if n_total == 0:
        return

    n_done = 0

    n_percent = 0.01

    log(" ")

    my_cursor.execute("PRAGMA shrink_memory;")

    purge_xref_table_data(my_db, my_cursor, notifications, log)

    mcs_create_txt_format_word_index_table(my_db,my_cursor)    # for legacy CALM Target Libraries missing it...

    for source_path in source_path_list:

        notifications.put((n_percent, ("Starting: " + str(source_path) ) ) )

        source_control(my_db, my_cursor, notifications, log, source_path)

        n_done = n_done + 1
        n_percent = float(n_done/n_total)
        notifications.put((n_percent, ("Finished: " + str(source_path) ) ) )
        n_list = apsw.status(apsw.SQLITE_STATUS_MEMORY_USED)
        n_current = n_list[0]
        n_max = n_list[1]
        s_current = '{:,}'.format(n_current)
        s_max = '{:,}'.format(n_max)
        s = "Library SQLite memory usage (in bytes) --  Currently: " + s_current + "  Job Maximum: " +  s_max
        log(str(s))
        log(" ")
        log("----------------------------------------")
        log(" ")
        my_cursor.execute("ANALYZE")
        my_cursor.execute("PRAGMA shrink_memory;")
        sleep(0)
        sleep(0.25)  # cede some cpu
    #END FOR
    log(" ")
    log(" ")
    log("═════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════════")
    log(" ")
    log(" ")
    n_list = apsw.status(apsw.SQLITE_STATUS_MEMORY_USED)
    n_current = n_list[0]
    n_max = n_list[1]
    s_current = '{:,}'.format(n_current)
    s_max = '{:,}'.format(n_max)
    s = "Library SQLite memory usage (in bytes) --  Currently: " + s_current + "  Job Maximum: " +  s_max
    log(str(s))
    log(" ")
    log(" ")
    log("Defragmenting & Compressing the Special CALM metadata.db file.")
    my_cursor.execute('VACUUM')
    log(" ")
    log(" ")
    empty_target_table_metadata_dirtied(my_db,my_cursor) # opf files are of no value whatsoever in the CALM target db.
    log("Removing Empty Subdirectories (Automatically Created by Calibre) from the Target Library.")
    remove_empty_subdirectories()
    log(" ")
    log(" ")
    global my_target_db
    s = my_target_db
    s = s.replace("/metadata.db","")
    log("You may now 'Quick Switch' from the current Calibre Library to  " + s + " in order to view the consolidated metadata.")
    log(" ")
    prefs['CALM_FORCE_RECONSOLIDATION'] == unicode("False")
    prefs
#----------------------------------------------------------------------------------------------------------------
def get_source_to_target_mapping_data(my_db,my_cursor,log):
    # all sources...

    global source_custom_columns_list
    global source_cc_to_target_cc_mapping_dict

    del source_custom_columns_list[0:len(source_custom_columns_list)]
    source_custom_columns_list[ : ] = []

    source_cc_to_target_cc_mapping_dict.clear()

    mysql = "SELECT source_library,source_library_cc_id,target_cc_id FROM TOOLS._source_cc_to_target_cc_mapping"
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            source_library,source_library_cc_id,target_cc_id = row         #  "s:/calibre/qs/quarantineandscrub_testdg"	"19"	"24"  = row
            id = str(source_library_cc_id)
            key = unicode(source_library + '--' + id)       # '--' avoids duplicate keys: calibremcs26 for both calibremcs2 6 and calibremcs 26
            key = key.lower()
            source_cc_to_target_cc_mapping_dict[key] = int(target_cc_id)     #  s:/calibre/qs/quarantineandscrub_testdg19 = 24
        #END FOR
        del tmp_rows

    mysql = "SELECT source_library,source_library_cc_id FROM _source_library_custom_columns \
                                                                                      WHERE activate_for_calm = 1 \
                                                                                          AND source_library_cc_id IN(SELECT source_library_cc_id \
                                                                                                                                        FROM _source_cc_to_target_cc_mapping \
                                                                                                                                      WHERE (source_library_cc_id = _source_library_custom_columns.source_library_cc_id \
                                                                                                                                           AND source_library = _source_library_custom_columns.source_library) )   "
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            source_library,source_library_cc_id = row
            source_library = source_library.lower()                   # standardize on all lower case for paths related to dicts and metadata_tools.db tables used for source custom columns...
            newrow = source_library,source_library_cc_id
            source_custom_columns_list.append(newrow)
        #END FOR
        del newrow
        del tmp_rows

    tmp_set = set(source_custom_columns_list)
    source_custom_columns_list = list(tmp_set)  # guarantees no duplicates...not there should be any...
    del tmp_set
    source_custom_columns_list.sort()

    return source_custom_columns_list,source_cc_to_target_cc_mapping_dict
#----------------------------------------------------------------------------------------------------------------
def get_target_cc_normalized(my_db,my_cursor):

    global target_cc_normalized_dict
    target_cc_normalized_dict.clear()
    global target_cc_datatype_dict
    target_cc_datatype_dict.clear()

    mysql = "SELECT id,normalized,datatype FROM custom_columns"
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        pass
    else:
        for row in tmp_rows:
            id,normalized,datatype = row
            normalized = str(normalized)
            target_cc_normalized_dict[id] = normalized
            target_cc_datatype_dict[id] = datatype
        #END FOR

    return target_cc_normalized_dict,target_cc_datatype_dict
#----------------------------------------------------------------------------------------------------------------
def empty_target_table_metadata_dirtied(my_db,my_cursor):

    my_cursor.execute("begin")
    mysql = "DELETE FROM main.metadata_dirtied"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def remove_empty_subdirectories():
    # Delete everything reachable from the directory named in "top",
    # assuming there are no symbolic links.
    # CAUTION:  This is dangerous!  For example, if top == '/', it
    # could delete all your disk files.

    #  os.walk(top, topdown=True, onerror=None, followlinks=False)

    global my_target_db
    top = my_target_db.replace("/metadata.db","")
    if DEBUG: print("Directory of Target Library: " + top)

    for root, dirs, files in os.walk(top, topdown=False, followlinks=False):
        for name in files:
            if not 'metadata.db' in name:
                if not '.json' in name:
                    if not 'tools.db' in name:
                        try:
                            os.remove(os.path.join(root, name))
                            #~ if DEBUG: print(root,name)
                        except Exception as e:
                            if DEBUG: print(str(e))
                            pass
        for name in dirs:
            if not top == '/':
                if not top == '\\':
                    if not name == '/':
                        if not name == '\\':
                            if not 'CALM' in name:
                                if not 'Calm' in name:
                                    if not 'calm' in name:
                                        if name <> top:
                                            try:
                                                os.rmdir(os.path.join(root, name))
                                                #~ if DEBUG: print(root,name)
                                            except Exception as e:
                                                if DEBUG: print(str(e))
                                                pass
#----------------------------------------------------------------------------------------------------------------
def source_control(my_db, my_cursor, notifications, log, source_path):

    has_existing_data = check_for_existing_data(my_db, my_cursor, notifications, log, source_path)
    if has_existing_data:
        log("ERROR: Source Already Has Books in This Target Library.  Ignoring:  " + source_path)
        return

    apsw_attach_to_source(my_db, my_cursor, notifications, log, source_path)

    localtime = time.asctime( time.localtime(time.time()) )
    log("Consolidating Source Standard Metadata: " + localtime)

    source_copy_control(my_db, my_cursor, notifications, log, source_path)

    apsw_detach_from_source(my_db, my_cursor, notifications, log, source_path)

    localtime = time.asctime( time.localtime(time.time()) )
    log("Consolidation Finished for Source Library: " + localtime)

    my_cursor.execute("ANALYZE")

    copy_xref_tables_to_all_xref_tables(my_db, my_cursor, notifications, log)

    purge_xref_table_data(my_db, my_cursor, notifications, log)

    my_cursor.execute("begin")
    mysql = "INSERT OR REPLACE INTO _calm_consolidation_status (source_library,started,completed) VALUES (?,1,1)"
    my_cursor.execute(mysql,([source_path]))
    my_cursor.execute("commit")

    sleep(0)
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
def source_copy_control(my_db, my_cursor, notifications, log, source_path):

    is_valid_db = add_new_language_codes(my_db, my_cursor, notifications, log)
    if not is_valid_db:
        return

    insert_author_xref_table(my_db, my_cursor, notifications, log, source_path)
    add_new_authors(my_db, my_cursor, notifications, log, source_path)
    update_author_xref_table(my_db, my_cursor, notifications, log, source_path)

    insert_series_xref_table(my_db, my_cursor, notifications, log, source_path)
    add_new_series(my_db, my_cursor, notifications, log, source_path)
    update_series_xref_table(my_db, my_cursor, notifications, log, source_path)

    insert_publisher_xref_table(my_db, my_cursor, notifications, log, source_path)
    add_new_publishers(my_db, my_cursor, notifications, log, source_path)
    update_publisher_xref_table(my_db, my_cursor, notifications, log, source_path)

    insert_book_xref_table(my_db, my_cursor, notifications, log, source_path)

    orig_bookid_orig_authid_dict = add_new_books(my_db, my_cursor, notifications, log, source_path)

    if orig_bookid_orig_authid_dict:
        if len(orig_bookid_orig_authid_dict) == 0:
            log("No books for this library.")
            return
        else:
            pass
    else:
        log("No books for this library.")
        return

    orig_bookid_list = update_book_xref_table(my_db, my_cursor, notifications, log, source_path,orig_bookid_orig_authid_dict)

    link_new_authors_to_books(my_db, my_cursor, notifications, log, orig_bookid_list)
    link_new_series_to_books(my_db, my_cursor, notifications, log, orig_bookid_list)
    link_new_publishers_to_books(my_db, my_cursor, notifications, log, orig_bookid_list)
    link_new_languages_to_books(my_db, my_cursor, notifications, log, orig_bookid_list)

    finalize_table_books(my_db, my_cursor, notifications, log, source_path)

    update_standard_custom_columns(my_db, my_cursor, notifications, log, orig_bookid_list, source_path)

    add_source_comments(my_db, my_cursor, notifications, log, orig_bookid_list)

    add_source_identifiers(my_db, my_cursor, notifications, log, orig_bookid_list)

    add_source_ratings(my_db, my_cursor, notifications, log, orig_bookid_list)

    add_source_tags(my_db, my_cursor, notifications, log, orig_bookid_list)

    add_source_custom_columns_control(my_db, my_cursor, notifications, log, orig_bookid_list, source_path)

    add_mcs_word_book_index(my_db, my_cursor, notifications, log, orig_bookid_list, source_path)

    count_books_added_for_source(my_db, my_cursor, notifications, log, source_path)

    del orig_bookid_list
    del orig_bookid_orig_authid_dict
#----------------------------------------------------------------------------------------------------------------
def add_new_language_codes(my_db, my_cursor, notifications, log):

    try:
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO main.languages SELECT null,lang_code FROM SOURCE.languages;"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        return True
    except Exception as e:
        try:
            my_cursor.execute("commit")  #hanging transaction
        except:
            pass
        log("----------------------------------------------------------------------------------------------")
        log("The current Source Library metadata.db is corrupted.  It cannot be processed further. ")
        log("----------------------------------------------------------------------------------------------")
        log(str(e))
        log("----------------------------------------------------------------------------------------------")
        return False
#----------------------------------------------------------------------------------------------------------------
def insert_author_xref_table(my_db, my_cursor, notifications, log, source_path):

    add_unknown_author(my_db, my_cursor, notifications, log)

    my_cursor.execute("begin")
    # to avoid later non-matches due only to lowercase-uppercase differences, all author names will be title-cased.
    mysql = "INSERT OR IGNORE INTO main._author_xref   SELECT null,?,id,(titlecase_names(name)),sort,0,'','' FROM SOURCE.authors;"
    my_cursor.execute(mysql,([source_path]))
    my_cursor.execute("commit")

    my_cursor.execute("begin")
    mysql = "UPDATE main._author_xref  SET orig_authsort = title_sort(orig_authname) WHERE orig_authsort IS NULL ;"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def insert_series_xref_table(my_db, my_cursor, notifications, log, source_path):

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main._series_xref   SELECT null,?,id,name,sort,0,'','' FROM SOURCE.series;"
    my_cursor.execute(mysql,([source_path]))
    my_cursor.execute("commit")

    my_cursor.execute("begin")
    mysql = "UPDATE main._series_xref  SET orig_seriessort = title_sort(orig_seriesname) WHERE orig_seriessort IS NULL ;"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def insert_publisher_xref_table(my_db, my_cursor, notifications, log, source_path):
    # note: the publishers.sort column is apparently always null in Calibre.

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main._publisher_xref   SELECT null,?,id,name,sort,0,'','' FROM SOURCE.publishers;"
    my_cursor.execute(mysql,([source_path]))
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def insert_book_xref_table(my_db, my_cursor, notifications, log, source_path):

    # all books, regardless of whether they have any book format in table data ...
    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main._book_xref SELECT null,?,id,0,'',author_sort,path,'',0,'',0,'',0,0,0,0 FROM SOURCE.books"
    my_cursor.execute(mysql,([source_path]))
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def add_new_authors(my_db, my_cursor, notifications, log, source_path):

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main.authors SELECT null,(titlecase_names(name)),sort,link FROM SOURCE.authors;"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def add_new_series(my_db, my_cursor, notifications, log, source_path):

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main.series SELECT null,name,sort FROM SOURCE.series;"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def add_new_publishers(my_db, my_cursor, notifications, log, source_path):

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main.publishers SELECT null,name,sort FROM SOURCE.publishers;"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def update_author_xref_table(my_db, my_cursor, notifications, log, source_path):
    # populate the 'new' columns...

    tmp_list = []

    mysql = "SELECT id FROM main._author_xref WHERE orig_library = ?"
    my_cursor.execute(mysql,([source_path]))
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        log("No authors were found.")
        return
    else:
        if len(tmp_rows) == 0:
            log("No authors were found.")
            del tmp_rows
            return
        else:
            for row in tmp_rows:
                for col in row:
                    tmp_list.append(int(col))

    del tmp_rows

    my_cursor.execute("begin")
    for id in tmp_list:
        mysql = "UPDATE main._author_xref SET new_authid=(SELECT id FROM main.authors WHERE titlecase_names(main.authors.name) = main._author_xref.orig_authname) WHERE main._author_xref.id = ?"
        my_cursor.execute(mysql,([id]))
        mysql = "UPDATE main._author_xref SET new_authname=(SELECT name FROM main.authors WHERE titlecase_names(main.authors.name) = main._author_xref.orig_authname) WHERE main._author_xref.id = ?"
        my_cursor.execute(mysql,([id]))
        mysql = "UPDATE main._author_xref SET new_authsort=(SELECT sort FROM main.authors WHERE titlecase_names(main.authors.name) = main._author_xref.orig_authname) WHERE main._author_xref.id = ?"
        my_cursor.execute(mysql,([id]))
    #END FOR
    my_cursor.execute("commit")

    del tmp_list
#----------------------------------------------------------------------------------------------------------------
def update_series_xref_table(my_db, my_cursor, notifications, log, source_path):
    # populate the 'new' columns...

    tmp_list = []

    mysql = "SELECT id FROM main._series_xref WHERE orig_library = ?"
    my_cursor.execute(mysql,([source_path]))
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        log("No series were found.")
        return
    else:
        if len(tmp_rows) == 0:
            log("No series were found.")
            return
        else:
            for row in tmp_rows:
                for col in row:
                    tmp_list.append(int(col))

    del tmp_rows

    my_cursor.execute("begin")
    for id in tmp_list:
        mysql = "UPDATE main._series_xref SET new_seriesid=(SELECT id FROM series WHERE series.name = main._series_xref.orig_seriesname) WHERE main._series_xref.id = ?"
        my_cursor.execute(mysql,([id]))
        mysql = "UPDATE main._series_xref SET new_seriesname=(SELECT name FROM series WHERE series.name = main._series_xref.orig_seriesname) WHERE main._series_xref.id = ?"
        my_cursor.execute(mysql,([id]))
        mysql = "UPDATE main._series_xref SET new_seriessort=(SELECT sort FROM series WHERE series.name = main._series_xref.orig_seriesname) WHERE main._series_xref.id = ?"
        my_cursor.execute(mysql,([id]))
    #END FOR
    my_cursor.execute("commit")

    del tmp_list
#----------------------------------------------------------------------------------------------------------------
def update_publisher_xref_table(my_db, my_cursor, notifications, log, source_path):
    # populate the 'new' columns...

    tmp_list = []

    mysql = "SELECT id FROM main._publisher_xref WHERE orig_library = ?"
    my_cursor.execute(mysql,([source_path]))
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        log("No publishers were found.")
        return
    else:
        if len(tmp_rows) == 0:
            log("No publishers were found.")
            return
        else:
            for row in tmp_rows:
                for col in row:
                    tmp_list.append(int(col))

    del tmp_rows

    my_cursor.execute("begin")
    for id in tmp_list:
        mysql = "UPDATE main._publisher_xref SET new_pubid=(SELECT id FROM publishers WHERE publishers.name = main._publisher_xref.orig_pubname) WHERE main._publisher_xref.id = ?"
        my_cursor.execute(mysql,([id]))
        mysql = "UPDATE main._publisher_xref SET new_pubname=(SELECT name FROM publishers WHERE publishers.name = main._publisher_xref.orig_pubname) WHERE main._publisher_xref.id = ?"
        my_cursor.execute(mysql,([id]))
        mysql = "UPDATE main._publisher_xref SET new_pubsort=(SELECT sort FROM publishers WHERE publishers.name = main._publisher_xref.orig_pubname) WHERE main._publisher_xref.id = ?"
        my_cursor.execute(mysql,([id]))
    #END FOR
    my_cursor.execute("commit")

    del tmp_list
#----------------------------------------------------------------------------------------------------------------
def add_new_books(my_db, my_cursor, notifications, log, source_path):

    #~ mysql = "INSERT OR IGNORE INTO main.books SELECT null,title,sort,timestamp,pubdate,series_index,author_sort,isbn,lccn,path,flags,uuid,has_cover,last_modified FROM SOURCE.books;"

    # since isbn and lccn are not used in modern Calibre (they are identifiers now), isbn will be repurposed to hold the original library path, and lccn will be repurposed hold the original book 'id' to create a direct link to table main._book_xref .

    # author_sort will be repurposed to hold the original author_id (or at least the first one)

    # has_cover set to 0 since no files are being copied, and a library check would otherwise create errors.

    #-----------
    # First, build a dict of the orig bookid and its first authorid

    orig_bookid_orig_authid_dict = {}

    mysql = "SELECT book,author FROM SOURCE.books_authors_link ORDER BY book, author"
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        return
    else:
        if len(tmp_rows) == 0:
            return
        else:
            for row in tmp_rows:
                k,v = row   # bookid,authorid
                if k:
                    if v:
                        if k in orig_bookid_orig_authid_dict:
                            continue   # we want only the first (lowest) authorid
                        orig_bookid_orig_authid_dict[k] = v

    del tmp_rows

    #-----------
    my_cursor.execute("begin")
    for k,v in orig_bookid_orig_authid_dict.iteritems():    # k=bookid, v=authorid
        mysql = "INSERT OR ABORT INTO main.books SELECT null,title,sort,timestamp,pubdate,series_index,\
                                                                                                ?,?,id,path,flags,uuid,0,last_modified \
                        FROM SOURCE.books \
                        WHERE SOURCE.books.id = ?"
        my_cursor.execute(mysql,(v,source_path,k))
    #END FOR
    my_cursor.execute("commit")

    return orig_bookid_orig_authid_dict
#----------------------------------------------------------------------------------------------------------------
def update_book_xref_table(my_db, my_cursor, notifications, log, source_path,orig_bookid_orig_authid_dict):

    orig_bookid_list = []
    for k,v in orig_bookid_orig_authid_dict.iteritems():
        orig_bookid_list.append(k)

    orig_bookid_list.sort()

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        #~ update  "new_bookid"  so author,series,publisher and language can be linked to each book.              new_bookid is stored in lccn in main.books.  lccn is a text field, not an integer field.
        #~ ensure that the new_bookid selected has not previously been used by another source library, because there may be many orig_bookids that are identical across the union of all of the source libraries.
        mysql = "UPDATE main._book_xref SET new_bookid =(   SELECT id FROM main.books  \
                                                                                                WHERE  (make_string_integer(main.books.lccn) ) =  (SELECT orig_bookid FROM main._book_xref WHERE orig_bookid = ?   AND orig_library = ?  ) \
                                                                                                    AND (main.books.id NOT IN (SELECT new_bookid FROM main._all_book_xref WHERE new_bookid = main.books.id )  )     )\
                                                         WHERE orig_bookid = ?  AND orig_library = ? "
        my_cursor.execute(mysql,(orig_bookid,source_path,orig_bookid,source_path))
    #END FOR
    my_cursor.execute("commit")

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        #~ update orig_language with the language code from SOURCE
        mysql = "UPDATE main._book_xref SET orig_language =(SELECT lang_code FROM SOURCE.languages \
                                                                                                  WHERE SOURCE.languages.id =(SELECT lang_code FROM SOURCE.books_languages_link  WHERE SOURCE.books_languages_link.book = ? )   )\
                                    WHERE main._book_xref.orig_bookid = ? "
        my_cursor.execute(mysql,(orig_bookid,orig_bookid))
    #END FOR
    my_cursor.execute("commit")


    # ensure there is a lang_code for every book; default to very first lang_code ever created in SOURCE.languages.
    for x in range(1,11):       # Cannot assume there is an id of  '1' to always use.
        my_cursor.execute("begin")
        mysql = "UPDATE main._book_xref SET orig_language =(SELECT lang_code FROM SOURCE.languages WHERE SOURCE.languages.id = ? AND SOURCE.languages.lang_code NOT NULL  )  \
                                                                WHERE main._book_xref.orig_language IS NULL OR main._book_xref.orig_language <= ' '       "
        my_cursor.execute(mysql,([x]))
        my_cursor.execute("commit")
    #END FOR

    #---------------------------------------
    # Goal: update orig_authid in table book_xref
    #---------------------------------------

    my_cursor.execute("begin")
    for k,v in orig_bookid_orig_authid_dict.iteritems():
        mysql = "UPDATE main._book_xref SET orig_authid = ?  \
                        WHERE main._book_xref.orig_bookid = ?   AND main._book_xref.orig_library = ? "
        my_cursor.execute(mysql,(v,k,source_path))
    #END FOR
    my_cursor.execute("commit")

    #---------------------------------------
    # Goal: update orig_authname in table book_xref
    #---------------------------------------
    # now that have orig_authid, can update orig_authname...

    my_cursor.execute("begin")
    for k,v in orig_bookid_orig_authid_dict.iteritems():
        mysql = "UPDATE main._book_xref SET orig_authname =(SELECT (lower(name)) FROM SOURCE.authors \
                                                                                                                        WHERE SOURCE.authors.id = ? \
                                                                                                                            AND  SOURCE.authors.name NOT NULL ) \
                                WHERE main._book_xref.orig_bookid = ? AND main._book_xref.orig_library = ?"
        my_cursor.execute(mysql,(v,k,source_path))
    #END FOR
    my_cursor.execute("commit")

    #---------------------------------------
    # Goal: Update orig_seriesid in table main._book_xref
    #---------------------------------------
    # only 1 series per bookid, if any, so can get it directly if there is one...
    my_cursor.execute("begin")
    for k,v in orig_bookid_orig_authid_dict.iteritems():
        mysql = "UPDATE main._book_xref SET orig_seriesid =(SELECT series FROM SOURCE.books_series_link WHERE SOURCE.books_series_link.book = ? ) WHERE main._book_xref.orig_bookid = ?"
        my_cursor.execute(mysql,(k,k))
    #END FOR
    my_cursor.execute("commit")

    #---------------------------------------
    # Goal: Update orig_seriesname in table main._book_xref
    #---------------------------------------
    # now that have orig_seriesid, can update orig_seriesname...
    my_cursor.execute("begin")
    for k,v in orig_bookid_orig_authid_dict.iteritems():
        mysql = "UPDATE main._book_xref SET orig_seriesname =(SELECT name FROM SOURCE.series WHERE SOURCE.series.id = main._book_xref.orig_seriesid) WHERE main._book_xref.orig_bookid = ?"
        my_cursor.execute(mysql,([k]))
    #END FOR
    my_cursor.execute("commit")

    #---------------------------------------
    # Goal: Update orig_pubid in table main._book_xref
    #---------------------------------------
    # only 1 publisher per bookid, if any, so can get it directly if there is one...
    my_cursor.execute("begin")
    for k,v in orig_bookid_orig_authid_dict.iteritems():
        mysql = "UPDATE main._book_xref SET orig_pubid =(SELECT publisher FROM SOURCE.books_publishers_link WHERE SOURCE.books_publishers_link.book = ?  ) WHERE main._book_xref.orig_bookid = ?"
        my_cursor.execute(mysql,(k,k))
    #END FOR
    my_cursor.execute("commit")

    #---------------------------------------
    # Goal: Update orig_pubname in table main._book_xref
    #---------------------------------------
    # now that have orig_pubid, can update orig_pubname...
    my_cursor.execute("begin")
    for k,v in orig_bookid_orig_authid_dict.iteritems():
        mysql = "UPDATE main._book_xref SET orig_pubname =(SELECT name FROM SOURCE.publishers WHERE SOURCE.publishers.id = main._book_xref.orig_pubid) WHERE main._book_xref.orig_bookid = ?"
        my_cursor.execute(mysql,([k]))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_orig_authid_dict

    #---------------------------------------
    # Goal: Update the 'new' columns in table main._book_xref using what was just updated above...
    #---------------------------------------

    my_cursor.execute("begin")
    mysql = "UPDATE main._book_xref SET new_authid=(SELECT new_authid FROM main._author_xref  WHERE  main._author_xref.orig_authid = main._book_xref.orig_authid)"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    #---------------------------------------

    my_cursor.execute("begin")
    mysql = "UPDATE main._book_xref SET new_seriesid=(SELECT new_seriesid FROM main._series_xref  WHERE  main._series_xref.orig_seriesid = main._book_xref.orig_seriesid) "
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
    #---------------------------------------

    my_cursor.execute("begin")
    mysql = "UPDATE main._book_xref SET new_pubid=(SELECT new_pubid FROM main._publisher_xref  WHERE  main._publisher_xref.orig_pubid = main._book_xref.orig_pubid)"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    #---------------------------------------

    my_cursor.execute("begin")
    mysql = "UPDATE main._book_xref SET orig_language=(SELECT lang_code FROM SOURCE.languages  \
                                                                                        WHERE SOURCE.languages.id  =(SELECT lang_code FROM SOURCE.books_languages_link  \
                                                                                                                                            WHERE book =  main._book_xref.orig_bookid ) )"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
    #---------------------------------------
    #---------------------------------------
    return orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def link_new_authors_to_books(my_db, my_cursor, notifications, log, orig_bookid_list):

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO main.books_authors_link SELECT null,new_bookid,new_authid FROM main._book_xref WHERE orig_bookid = ? "
        my_cursor.execute(mysql,([orig_bookid]))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def link_new_series_to_books(my_db, my_cursor, notifications, log, orig_bookid_list):

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO main.books_series_link SELECT null,new_bookid,new_seriesid FROM main._book_xref WHERE orig_bookid = ? \
                        AND main._book_xref.new_seriesid NOT NULL AND main._book_xref.new_seriesid > 0"
        my_cursor.execute(mysql,([orig_bookid]))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def link_new_publishers_to_books(my_db, my_cursor, notifications, log, orig_bookid_list):

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO main.books_publishers_link SELECT null,new_bookid,new_pubid FROM main._book_xref WHERE orig_bookid = ? \
                       AND main._book_xref.new_pubid NOT NULL AND main._book_xref.new_pubid > 0"
        my_cursor.execute(mysql,([orig_bookid]))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def link_new_languages_to_books(my_db, my_cursor, notifications, log, orig_bookid_list):

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO main.books_languages_link SELECT null, new_bookid,\
                                                                                                            (SELECT id FROM main.languages WHERE lang_code =(SELECT orig_language FROM main._book_xref WHERE orig_bookid = ? \
                                                                                                            AND main._book_xref.orig_language NOT NULL AND main._book_xref.orig_language > '  ' )  \
                                                                                                            AND main.languages.id NOT NULL \
                                                                                                            AND main.languages.lang_code NOT NULL ) \
                                                                                                            , 0  \
                                                                                                            FROM main._book_xref WHERE orig_bookid = ? \
                                                                                                                                                      AND orig_language NOT NULL"
        my_cursor.execute(mysql,(orig_bookid,orig_bookid))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def finalize_table_books(my_db, my_cursor, notifications, log, source_path):
    # restore the SOURCE.books.author_sort to the new main.books.author_sort because it currently has the original author id in it for linking purposes

    my_cursor.execute("begin")
    mysql = "UPDATE main.books SET author_sort =(SELECT author_sort FROM SOURCE.books WHERE SOURCE.books.id = (make_string_integer(main.books.lccn)  )  )\
                                                     WHERE  ? = (trim(main.books.isbn)) "
    my_cursor.execute(mysql,([source_path]))
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def update_standard_custom_columns(my_db, my_cursor, notifications, log, orig_bookid_list, source_path):

    cust_table_library = CUSTOM_COLUMN_ORIGINAL_LIBRARY_PATH_TABLE
    cust_table_book = CUSTOM_COLUMN_ORIGINAL_BOOK_PATH_TABLE

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO [??] SELECT null, new_bookid, (replace(main._book_xref.orig_library,'metadata.db','')) FROM main._book_xref WHERE orig_bookid = ?"
        mysql = mysql.replace("[??]",str(cust_table_library))
        my_cursor.execute(mysql,([orig_bookid]))
    #END FOR
    my_cursor.execute("commit")

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO [??]  SELECT null, new_bookid, orig_path FROM main._book_xref WHERE orig_bookid = ?"
        mysql = mysql.replace("[??]",str(cust_table_book))
        my_cursor.execute(mysql,([orig_bookid]))
    #END FOR
    my_cursor.execute("commit")

    # add the Target Book ID to custom column 9 for ease of auditing of book shuffling processes
    my_cursor.execute("begin")
    mysql = "INSERT OR REPLACE INTO main.custom_column_9 SELECT null,id,id from main.books "
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    # add number of source library book formats to custom column 10
    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        orig_bookid = int(orig_bookid)
        s_id= str(orig_bookid)
        mysql = "INSERT OR REPLACE INTO main.custom_column_10 \
                                                      SELECT null,id,\
                                                      (SELECT count(*) FROM SOURCE.data WHERE SOURCE.data.book = ?  )  \
                                                      FROM main.books  WHERE main.books.lccn = ? AND main.books.isbn = ? "
        my_cursor.execute(mysql,(orig_bookid,s_id, source_path))
        #~ log(str(orig_bookid),s_id,source_path)
    #END FOR
    my_cursor.execute("commit")

    try:  # version 2.0.7
        # add type of source library book formats to custom column 15
        my_cursor.execute("begin")
        mysql = "INSERT OR IGNORE INTO main.custom_column_15 SELECT null,format FROM SOURCE.data WHERE format NOT NULL AND format > ' ' "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        sleep(0.1)
        # add type of source library book formats by book to books_custom_column_15_link
        mysql = "SELECT book,format FROM SOURCE.data WHERE format NOT NULL AND format > ' ' "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        my_cursor.execute("begin")
        for row in tmp_rows:
            orig_bookid,format = row
            s_id= str(orig_bookid)
            #~ if DEBUG: print(s_id + " - " + format)
            mysql = "INSERT OR IGNORE INTO main.books_custom_column_15_link \
                                                          SELECT null,\
                                                          (SELECT id FROM main.books WHERE main.books.lccn = ? AND main.books.isbn = ? ), \
                                                          (SELECT id FROM main.custom_column_15 WHERE value = ? )"
            my_cursor.execute(mysql,(s_id, source_path,format))
        #END FOR
        my_cursor.execute("commit")
        del tmp_rows
    except Exception as e:
        if DEBUG: print("Exception: ", str(e))
        try:
            my_cursor.execute("commit")
        except:
            pass
        log("CALM Target metadata.db is an older version without custom_column_15 for source library book format types; skipping that (new) CALM standard custom column.")
        if DEBUG: print("CALM Target metadata.db is an older version without custom_column_15 for source library book format types; skipping that (new) CALM standard custom column.")


    try:  # version 2.0.8
        # add books.has_cover to custom column 16, which is non-normalized and boolean:   #source_cover
        my_cursor.execute("begin")
        for orig_bookid in orig_bookid_list:
            orig_bookid = int(orig_bookid)
            s_id= str(orig_bookid)
            mysql = "INSERT OR IGNORE INTO main.custom_column_16 \
                                                          SELECT null,id,\
                                                          (SELECT has_cover FROM SOURCE.books WHERE id = ?  )  \
                                                          FROM main.books  WHERE main.books.lccn = ? AND main.books.isbn = ? "
            my_cursor.execute(mysql,(orig_bookid,s_id, source_path))
        #END FOR
        my_cursor.execute("commit")
    except Exception as e:
        if DEBUG: print("Exception: ", str(e))
        try:
            my_cursor.execute("commit")
        except:
            pass
        log("CALM Target metadata.db is an older version without custom_column_16 for source library book has_cover; skipping that (new) CALM standard custom column.")
        if DEBUG: print("CALM Target metadata.db is an older version without custom_column_16 for source library book has_cover; skipping that (new) CALM standard custom column.")

    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def add_source_comments(my_db, my_cursor, notifications, log, orig_bookid_list):

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO main.comments SELECT null, new_bookid,(SELECT text FROM SOURCE.comments WHERE SOURCE.comments.book = ? )  \
                                                                                            FROM main._book_xref WHERE orig_bookid = ? "
        my_cursor.execute(mysql,(orig_bookid,orig_bookid))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def add_source_identifiers(my_db, my_cursor, notifications, log, orig_bookid_list):

    mysql = "SELECT book,type,val FROM SOURCE.identifiers "
    my_cursor.execute(mysql)
    orig_book_identifiers_list = my_cursor.fetchall()
    if  not orig_book_identifiers_list:
        log("No identifiers were found.")
        return
    if len(orig_book_identifiers_list ) == 0:
        log("No identifiers were found.")
        return

    orig_book_identifiers_list.sort()

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        for row in orig_book_identifiers_list:
            book,type,val = row
            if book == orig_bookid:
                mysql = "INSERT OR IGNORE INTO main.identifiers SELECT null, new_bookid, ?,? FROM main._book_xref WHERE orig_bookid = ? "
                my_cursor.execute(mysql,(type,val,orig_bookid))
    #END FOR
    my_cursor.execute("commit")

    del orig_book_identifiers_list
    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def add_source_ratings(my_db, my_cursor, notifications, log, orig_bookid_list):

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main.ratings SELECT null,rating FROM SOURCE.ratings "
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO main.books_ratings_link SELECT null, new_bookid,\
                                                                                                            (SELECT id FROM main.ratings WHERE main.ratings.rating =(SELECT rating FROM SOURCE.ratings \
                                                                                                            WHERE id =(SELECT rating FROM SOURCE.books_ratings_link  WHERE SOURCE.books_ratings_link.book = ? ) ) )\
                                                                                                            FROM main._book_xref WHERE orig_bookid = ? \
                                                                                                                                                      AND orig_bookid IN(SELECT book FROM SOURCE.books_ratings_link WHERE book = orig_bookid) "
        my_cursor.execute(mysql,(orig_bookid,orig_bookid))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_list
#----------------------------------------------------------------------------------------------------------------
def add_source_tags(my_db, my_cursor, notifications, log, orig_bookid_list):

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main.tags SELECT null,name FROM SOURCE.tags "
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    mysql = "SELECT book,(SELECT name FROM SOURCE.tags WHERE id = SOURCE.books_tags_link.tag) as name \
                    FROM SOURCE.books_tags_link "
    my_cursor.execute(mysql)
    orig_books_tags_link_list = my_cursor.fetchall()
    if  not orig_books_tags_link_list:
        log("No tags were found.")
        return
    if len(orig_books_tags_link_list) == 0:
        log("No tags were found.")
        return

    orig_books_tags_link_list.sort()

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        for row in orig_books_tags_link_list:
            book,tagname = row
            if orig_bookid == book:
                mysql = "INSERT OR IGNORE INTO main.books_tags_link SELECT null, new_bookid,\
                                                                                                                        (SELECT id FROM main.tags WHERE main.tags.name = ? )\
                                                                                                            FROM main._book_xref \
                                                                                                            WHERE orig_bookid = ? \
                                                                                                                AND orig_bookid IN(SELECT book FROM SOURCE.books_tags_link WHERE book = orig_bookid) "
                my_cursor.execute(mysql,(tagname,orig_bookid))
    #END FOR
    my_cursor.execute("commit")

    del orig_books_tags_link_list
    del orig_bookid_list

#----------------------------------------------------------------------------------------------------------------
def add_source_custom_columns_control(my_db, my_cursor, notifications, log, orig_bookid_list, source_path):

    global source_custom_columns_list

    source_path = source_path.lower()   # standardize on lower case related to matching values...

    source_lib = source_path.replace("/metadata.db","")
    source_lib = source_lib.replace("metadata.db","")
    if source_lib.endswith("/"):
        source_lib = source_lib[0:-1]
        source_lib = source_lib.strip()

    localtime = time.asctime( time.localtime(time.time()) )
    log("Consolidating Source Custom Columns: " + localtime)

    for row in source_custom_columns_list:
        source_library,source_library_cc_id = row
        source_library = source_library.lower()      # standardize on lower case related to matching values...
        source_library = source_library.replace("/metadata.db","")
        source_library = source_library.replace("metadata.db","")
        if source_library.endswith("/"):
            source_library = source_library[0:-1]
        source_library = source_library.strip()
        if str(source_library) == str(source_lib):
            #------------------------------------------
            is_valid = add_source_custom_column_data_to_target(my_db, my_cursor, notifications, log, orig_bookid_list,source_library,source_library_cc_id)
            if is_valid:
                continue
            else:
                log("FATAL ERROR in adding Source Custom Column data to the Target Library for Source Library: " + source_library + "  --- Skipping its remaining Custom Columns..." )
                break
            #------------------------------------------
        else:
            continue
    #END FOR
#----------------------------------------------------------------------------------------------------------------
def add_source_custom_column_data_to_target(my_db, my_cursor, notifications, log, orig_bookid_list,source_library,source_library_cc_id):

    global target_cc_normalized_dict
    global source_cc_to_target_cc_mapping_dict                # created from view:  __source_cc_to_target_cc_mapping_direct_only

    matchkey = source_library + '--' + str(source_library_cc_id)     #   x:/calibre/CalibreENF--9      '--' avoids duplicate keys: calibremcs26 for both calibremcs2 6 and calibremcs 26
    matchkey = matchkey.lower()
    if matchkey in source_cc_to_target_cc_mapping_dict:
        #~ log("matchkey is: " + matchkey)
        target_cc_id = source_cc_to_target_cc_mapping_dict[matchkey]
        #~ log("target_cc_id is: " + str(target_cc_id) )
        if target_cc_id in target_cc_normalized_dict:
            normalized = target_cc_normalized_dict[target_cc_id]
            #~ log("normalized is: " + str(normalized) )
            if str(normalized) == str("1"):
                is_normalized = True
            else:
                if str(normalized) == str("0"):
                    is_normalized = False
                else:
                    log("[3] add_source_custom_column_data_to_target ---  'normalized' has an invalid value (not 0 or 1) ")
                    log("<<<<---------------------ADDITIONAL INFO: BEGIN ----------------------------------->>>>")
                    log("source_library: " + source_library)
                    log("source_library_cc_id: " + str(source_library_cc_id))
                    log("matchkey for source_cc_to_target_cc_mapping_dict: " + matchkey)
                    log("target_cc_id that was not found in target_cc_normalized_dict: " + str(target_cc_id))
                    log("'normalized' has an invalid value (not 0 or 1): " + str(normalized))
                    log("<<<<---------------------ADDITIONAL INFO: END   ----------------------------------->>>>")
                    return False
        else:
            log("[2] add_source_custom_column_data_to_target --- target_cc_id not found in target_cc_normalized_dict.")
            log("<<<<---------------------ADDITIONAL INFO: BEGIN ----------------------------------->>>>")
            log("source_library: " + source_library)
            log("source_library_cc_id: " + str(source_library_cc_id))
            log("matchkey for source_cc_to_target_cc_mapping_dict: " + matchkey)
            log("target_cc_id that was not found in target_cc_normalized_dict: " + str(target_cc_id))
            log("<<<<---------------------ADDITIONAL INFO: END   ----------------------------------->>>>")
            return False
    else:
        log("[1] add_source_custom_column_data_to_target --- matchkey of source library plus source cc not found in source_cc_to_target_cc_mapping_dict.")
        log("<<<<---------------------ADDITIONAL INFO: BEGIN ----------------------------------->>>>")
        log("source_library: " + source_library)
        log("source_library_cc_id: " + str(source_library_cc_id))
        log("matchkey for source_cc_to_target_cc_mapping_dict: " + matchkey)
        log("target_cc_normalized_dict: target_cc_id has not yet been determined.")
        log("<<<<---------------------ADDITIONAL INFO: END   ----------------------------------->>>>")
        return False

    if is_normalized:
        is_valid = target_cc_table_is_normalized_control(my_db, my_cursor, notifications, log, orig_bookid_list,source_library_cc_id,target_cc_id)
        return is_valid
    else:
        is_valid = target_cc_table_is_not_normalized_control(my_db, my_cursor, notifications, log, orig_bookid_list,source_library_cc_id,target_cc_id)
        return is_valid

#----------------------------------------------------------------------------------------------------------------
def target_cc_table_is_normalized_control(my_db, my_cursor, notifications, log, orig_bookid_list,source_library_cc_id,target_cc_id):

    ccname = str("custom_column_[N]")
    cclinkname = str("books_custom_column_[N]_link")

    #~ if DEBUG: print("[0]      Generic:  " + ccname + "  --  " + cclinkname)

    n = str(target_cc_id)
    target_ccname = ccname.replace("[N]",n)
    target_cclinkname = cclinkname.replace("[N]",n)

    #~ if DEBUG: print("[1a]      TARGET:  " + target_ccname + "  --  " + target_cclinkname)

    n = str(source_library_cc_id)
    source_ccname = ccname.replace("[N]",n)
    source_cclinkname = cclinkname.replace("[N]",n)

    #~ if DEBUG: print("[1b]      SOURCE:  " + source_ccname + "  --  " + source_cclinkname)

    is_valid = update_target_cc_normalized(my_db, my_cursor, notifications, log, orig_bookid_list,target_ccname,target_cclinkname,source_ccname,source_cclinkname)

    return is_valid
#----------------------------------------------------------------------------------------------------------------
def target_cc_table_is_not_normalized_control(my_db, my_cursor, notifications, log, orig_bookid_list,source_library_cc_id,target_cc_id):

    ccname = "custom_column_[N]"

    n = str(target_cc_id)
    target_ccname = ccname.replace("[N]",n)

    n = str(source_library_cc_id)
    source_ccname = ccname.replace("[N]",n)

    is_valid = update_target_cc_not_normalized(my_db, my_cursor, notifications, log, orig_bookid_list, target_ccname,source_ccname)

    return is_valid
#----------------------------------------------------------------------------------------------------------------
def update_target_cc_normalized(my_db, my_cursor, notifications, log, orig_bookid_list,target_ccname,target_cclinkname,source_ccname,source_cclinkname):
    #actually select and insert data...
    is_valid = True

    #~ if DEBUG: print("[2]      TARGET:  " + target_ccname + "  --  " + target_cclinkname + "    SOURCE:  " + source_ccname + "  --  " + source_cclinkname)

    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main.[TARGETCCNAME] SELECT null, value FROM SOURCE.[SOURCECCNAME] "
    mysql = mysql.replace("[TARGETCCNAME]",target_ccname)
    mysql = mysql.replace("[SOURCECCNAME]",source_ccname)
    #if DEBUG: print(str(mysql))
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    sleep(0.25)

    tmp_link_list = []
    mysql = "SELECT book,value FROM SOURCE.[SOURCECCLINKNAME]"
    mysql = mysql.replace("[SOURCECCLINKNAME]",source_cclinkname)
    #if DEBUG: print(str(mysql))
    my_cursor.execute(mysql)
    tmp_rows = my_cursor.fetchall()
    if not tmp_rows:
        return is_valid
    else:
        if len(tmp_rows) == 0:
            return is_valid
        else:
            for row in tmp_rows:
                tmp_link_list.append(row)
                #~ log("tmp_link_list row: " + str(row))
            #END FOR
    del tmp_rows

    tmp_link_list.sort()

    cc_temp_dict = collections.OrderedDict([])

    for row in tmp_link_list:
        orig_book,pointer = row
        mysql = "SELECT id,value FROM SOURCE.[SOURCECCNAME] WHERE id = ? "
        mysql = mysql.replace("[SOURCECCNAME]",source_ccname)
        my_cursor.execute(mysql,([pointer]))
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            continue
        else:
            if len(tmp_rows) == 0:
                continue
            else:
                for row in tmp_rows:
                    id,value = row
                    cc_temp_dict[orig_book] = value
                #END FOR
                del tmp_rows

    del tmp_link_list

    my_cursor.execute("begin")
    for orig_bookid, value in cc_temp_dict.iteritems():
        #~ log("cc_temp_dict[orig_book] = value : " + str(id) + ">>" + value)
        mysql = "INSERT OR IGNORE INTO main.[TARGETCCLINKNAME] (id,book,value) VALUES (?,(SELECT new_bookid FROM main._book_xref WHERE orig_bookid = ? ), \
                                                                                                                                                       (SELECT id FROM main.[TARGETCCNAME] WHERE value = ? ) ) ; "
        mysql = mysql.replace("[TARGETCCLINKNAME]",target_cclinkname)
        mysql = mysql.replace("[TARGETCCNAME]",target_ccname)
        my_cursor.execute(mysql,(None,orig_bookid,value))
    #END FOR
    my_cursor.execute("commit")

    global target_cc_datatype_dict
    s = str(target_ccname)
    s = s.replace("custom_column_","")
    s = s.strip()
    id = int(s)
    datatype = target_cc_datatype_dict[id]
    if str(datatype) == str("series"):
        is_series_like = True
    else:
        is_series_like = False

    if not is_series_like:
        pass
    else:    # update the 'extra' column...
        my_cursor.execute("begin")
        for orig_bookid, value in cc_temp_dict.iteritems():
            #~ log("cc_temp_dict[orig_book] = value : " + str(id) + ">>" + value)
            mysql = "UPDATE main.[TARGETCCLINKNAME] SET extra = (SELECT extra FROM SOURCE.[SOURCECCLINKNAME] WHERE book = ? AND extra NOT NULL) \
                                        WHERE book = (SELECT new_bookid FROM main._book_xref WHERE orig_bookid = ? )"
            mysql = mysql.replace("[TARGETCCLINKNAME]",target_cclinkname)
            mysql = mysql.replace("[SOURCECCLINKNAME]",source_cclinkname)
            my_cursor.execute(mysql,(orig_bookid,orig_bookid))
        #END FOR
        my_cursor.execute("commit")

    del orig_bookid_list
    del cc_temp_dict

    return is_valid
#----------------------------------------------------------------------------------------------------------------
def update_target_cc_not_normalized(my_db, my_cursor, notifications, log, orig_bookid_list, target_ccname,source_ccname):
    #actually select and insert data...
    is_valid = True

    my_cursor.execute("begin")
    for orig_bookid in orig_bookid_list:
        mysql = "INSERT OR IGNORE INTO main.[TARGETCCNAME] SELECT null, new_bookid,(SELECT value FROM SOURCE.[SOURCECCNAME] WHERE SOURCE.[SOURCECCNAME].book = ? )  \
                                                                                            FROM main._book_xref WHERE orig_bookid = ? "
        mysql = mysql.replace("[TARGETCCNAME]",target_ccname)
        mysql = mysql.replace("[SOURCECCNAME]",source_ccname)
        my_cursor.execute(mysql,(orig_bookid,orig_bookid))
    #END FOR
    my_cursor.execute("commit")

    del orig_bookid_list

    return is_valid
#----------------------------------------------------------------------------------------------------------------
def add_unknown_author(my_db, my_cursor, notifications, log):
    my_cursor.execute("begin")
    mysql = "INSERT OR IGNORE INTO main.authors (id,name,sort,link) VALUES(null,'Unknown','Unknown',' ') "
    my_cursor.execute(mysql)
    mysql = "INSERT OR IGNORE INTO main.authors (id,name,sort,link) VALUES(null,'UNKNOWN','UNKNOWN',' ') "
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
def purge_xref_table_data(my_db, my_cursor, notifications, log):

    my_cursor.execute("begin")
    mysql = "DELETE FROM  main._book_xref"
    my_cursor.execute(mysql)
    mysql = "DELETE FROM  main._author_xref"
    my_cursor.execute(mysql)
    mysql = "DELETE FROM  main._series_xref"
    my_cursor.execute(mysql)
    mysql = "DELETE FROM  main._publisher_xref"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
    sleep(0.25)
#----------------------------------------------------------------------------------------------------------------
def copy_xref_tables_to_all_xref_tables(my_db, my_cursor, notifications, log):

    my_cursor.execute("begin")
    mysql = "INSERT OR ABORT INTO main._all_book_xref SELECT *  FROM  main._book_xref"
    my_cursor.execute(mysql)
    mysql = "INSERT OR ABORT INTO main._all_author_xref  SELECT *  FROM  main._author_xref"
    my_cursor.execute(mysql)
    mysql = "INSERT OR ABORT INTO main._all_series_xref  SELECT *  FROM  main._series_xref"
    my_cursor.execute(mysql)
    mysql = "INSERT OR ABORT INTO main._all_publisher_xref  SELECT *  FROM  main._publisher_xref"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
def apsw_attach_to_source(my_db, my_cursor, notifications, log, path):

    s1 = "ATTACH DATABASE '"
    s2 =  "'  As 'SOURCE' ;"

    path = path.replace(os.sep, '/')

    if isbytestring(path):
        path = path.decode(filesystem_encoding)

    mysql = s1 + path + s2

    try:
        log("Attaching to New Source Library: " + path)
        my_cursor.execute (mysql)
    except Exception as e:
        log("NOT Attached: " + str(path))
        log(str(e))
        raise e
        return
#----------------------------------------------------------------------------------------------------------------
def apsw_detach_from_source(my_db, my_cursor, notifications, log, path):
    try:
        mysql = "DETACH 'SOURCE'"
        my_cursor.execute (mysql)
        log("Previous Source Library Detached: " + str(path))
    except Exception as e:
        log("NOT Detached: " + str(path))
        log(str(e))
        raise e
        return
#----------------------------------------------------------------------------------------------------------------
def apsw_connect_to_target(log,my_target_db):

    path = my_target_db
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    my_target_db = path

    log("CALM DB: " + path)
    try:
        my_db =apsw.Connection(path)
    except Exception as e:
        log(str(e))
        raise e
        return

    my_cursor = my_db.cursor()

    # many standard triggers call this user function:
    title_pat = re.compile('^(A|The|An)\s+', re.IGNORECASE)
    def title_sort(title):
        match = title_pat.search(title)
        if match:
            prep = match.group(1)
            title = title.replace(prep, '') + ', ' + prep
        return title.strip()
    my_db.createscalarfunction('title_sort', title_sort,1)

    # standard book triggers call this user function:
    def uuid4():
        return str(uuid.uuid4())
    my_db.createscalarfunction('uuid4', uuid4, 0)

    # for table main._book_xref:
    def make_string_integer(s):
        try:
            s = str(s)
            s = str(s.strip())
            n = int(s)
            return n
        except:
            return s
    my_db.createscalarfunction('make_string_integer', make_string_integer, 1)

    # for inbound author names:
    def titlecase_names(s):
        try:
            s = s.strip()
            s = s.title()
            return s
        except:
            return s
    my_db.createscalarfunction('titlecase_names', titlecase_names, 1)

    return my_cursor,my_db,my_target_db
#-----------------------------------------------------------------------------------------------
def apsw_attach_to_tools_db(my_db,my_cursor):

    global my_target_db

    s1 = "ATTACH DATABASE '"
    s2 =  "'  As 'TOOLS' ;"

    path = my_target_db
    path = path.replace("metadata.db","metadata_tools.db")
    path = path.replace(os.sep, '/')
    if isbytestring(path):
        path = path.decode(filesystem_encoding)

    mysql = s1 + path + s2

    try:
        if DEBUG: print("Attaching to Tools DB: " + path)
        my_cursor.execute (mysql)
        mysql = "PRAGMA TOOLS.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)
    except Exception as e:
        if DEBUG: print("NOT Attached: " + str(path))
        if DEBUG: print(str(e))
        raise e
        return
#----------------------------------------------------------------------------------------------------------------
def apsw_detach_from_tools_db(my_db, my_cursor):
    try:
        mysql = "DETACH 'TOOLS'"
        my_cursor.execute (mysql)
        if DEBUG: print("TOOLS DB Detached")
    except Exception as e:
        if DEBUG: print("TOOLS DB NOT Detached")
        if DEBUG: print(str(e))
        raise e
        return
#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
def clear_or_initialize_globals():
    # called both at the beginning and the end of the job.

    if DEBUG: print("Clearing or initializing globals")

    # clear all lists, sets, dicts, and ordered dicts from the previous job that persist from that job to the next job(s) submitted (unless calibre is exited first)

    global header_s1
    global header_s2
    global header_s3
    global header_s4
    global header_s5
    header_s1 = None
    header_s2 = None
    header_s3 = None
    header_s4 = None
    header_s5 = None

    global my_target_db
    my_target_db = "/CALM/metadata.db"

    global my_param_dict
    my_param_dict.clear()

    global source_cc_to_target_cc_mapping_dict
    source_cc_to_target_cc_mapping_dict.clear()

    global source_custom_columns_list
    source_custom_columns_list[ : ] = []
    del source_custom_columns_list[ : ]
    del source_custom_columns_list[0:len(source_custom_columns_list)]
    # or use Python 3.3 and:  source_custom_columns_list.clear()

    global target_cc_normalized_dict
    target_cc_normalized_dict.clear()
#----------------------------------------------------------------------------------------------------------------
def  count_books_added_for_source(my_db, my_cursor, notifications, log, source_path):

    mysql = "SELECT Count(*) FROM main._book_xref WHERE orig_library = ? "
    my_cursor.execute(mysql,([source_path]))
    tmp_list = my_cursor.fetchall()
    for row in tmp_list:        #   [(138,)]
        for col in row:
            count = col

    log("Number of books created for this Source Library: " + str(count))

    del tmp_list
#----------------------------------------------------------------------------------------------------------------
def  check_for_existing_data(my_db, my_cursor, notifications, log, source_path):

    check_calm_consolidation_status(my_db, my_cursor, notifications, log, source_path)

    has_existing_data = False

    mysql = "SELECT Count(*) FROM main._all_book_xref WHERE orig_library = ? "
    my_cursor.execute(mysql,([source_path]))
    tmp_list = my_cursor.fetchall()
    for row in tmp_list:        #   [(138,)]
        for col in row:
            count = col

    if count <> 0:
        has_existing_data = True
        log("Number of books for this Source Library found in Target Library: " + str(count))

    del tmp_list

    return has_existing_data
#----------------------------------------------------------------------------------------------------------------
def determine_active_sources():

    global my_param_dict

    end_path = unicode("metadata.db")

    source_path_dict = {}

    for k,v in my_param_dict.iteritems():
        if 'LIBRARY_PATH_' in k:
            if not 'IS_ACTIVE' in k:
                if v > " ":
                    if not 'metadata.db' in v:
                        v1 = os.path.join(v,end_path)
                        v1 = v1.replace(os.sep, '/')
                    if 'LIBRARY_PATH_03' in k: # lowest path in CALM is 03 so calm_dialog could easily use a Source Library tab QGridLayout row number = library number
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_03_IS_ACTIVE']
                    elif 'LIBRARY_PATH_04' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_04_IS_ACTIVE']
                    elif 'LIBRARY_PATH_05' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_05_IS_ACTIVE']
                    elif 'LIBRARY_PATH_06' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_06_IS_ACTIVE']
                    elif 'LIBRARY_PATH_07' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_07_IS_ACTIVE']
                    elif 'LIBRARY_PATH_08' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_08_IS_ACTIVE']
                    elif 'LIBRARY_PATH_09' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_09_IS_ACTIVE']

                    elif 'LIBRARY_PATH_10' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_10_IS_ACTIVE']
                    elif 'LIBRARY_PATH_11' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_11_IS_ACTIVE']
                    elif 'LIBRARY_PATH_12' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_12_IS_ACTIVE']
                    elif 'LIBRARY_PATH_13' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_13_IS_ACTIVE']
                    elif 'LIBRARY_PATH_14' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_14_IS_ACTIVE']
                    elif 'LIBRARY_PATH_15' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_15_IS_ACTIVE']
                    elif 'LIBRARY_PATH_16' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_16_IS_ACTIVE']
                    elif 'LIBRARY_PATH_17' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_17_IS_ACTIVE']
                    elif 'LIBRARY_PATH_18' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_18_IS_ACTIVE']
                    elif 'LIBRARY_PATH_19' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_19_IS_ACTIVE']

                    elif 'LIBRARY_PATH_20' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_20_IS_ACTIVE']
                    elif 'LIBRARY_PATH_21' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_21_IS_ACTIVE']
                    elif 'LIBRARY_PATH_22' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_22_IS_ACTIVE']
                    elif 'LIBRARY_PATH_23' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_23_IS_ACTIVE']
                    elif 'LIBRARY_PATH_24' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_24_IS_ACTIVE']
                    elif 'LIBRARY_PATH_25' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_25_IS_ACTIVE']
                    elif 'LIBRARY_PATH_26' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_26_IS_ACTIVE']
                    elif 'LIBRARY_PATH_27' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_27_IS_ACTIVE']
                    elif 'LIBRARY_PATH_28' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_28_IS_ACTIVE']
                    elif 'LIBRARY_PATH_29' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_29_IS_ACTIVE']

                    elif 'LIBRARY_PATH_30' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_30_IS_ACTIVE']
                    elif 'LIBRARY_PATH_31' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_31_IS_ACTIVE']
                    elif 'LIBRARY_PATH_32' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_32_IS_ACTIVE']
                    elif 'LIBRARY_PATH_33' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_33_IS_ACTIVE']
                    elif 'LIBRARY_PATH_34' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_34_IS_ACTIVE']
                    elif 'LIBRARY_PATH_35' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_35_IS_ACTIVE']
                    elif 'LIBRARY_PATH_36' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_36_IS_ACTIVE']
                    elif 'LIBRARY_PATH_37' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_37_IS_ACTIVE']
                    elif 'LIBRARY_PATH_38' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_38_IS_ACTIVE']
                    elif 'LIBRARY_PATH_39' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_39_IS_ACTIVE']

                    elif 'LIBRARY_PATH_40' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_40_IS_ACTIVE']
                    elif 'LIBRARY_PATH_41' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_41_IS_ACTIVE']
                    elif 'LIBRARY_PATH_42' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_42_IS_ACTIVE']
                    elif 'LIBRARY_PATH_43' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_43_IS_ACTIVE']
                    elif 'LIBRARY_PATH_44' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_44_IS_ACTIVE']
                    elif 'LIBRARY_PATH_45' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_45_IS_ACTIVE']
                    elif 'LIBRARY_PATH_46' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_46_IS_ACTIVE']
                    elif 'LIBRARY_PATH_47' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_47_IS_ACTIVE']
                    elif 'LIBRARY_PATH_48' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_48_IS_ACTIVE']
                    elif 'LIBRARY_PATH_49' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_49_IS_ACTIVE']

                    elif 'LIBRARY_PATH_50' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_50_IS_ACTIVE']
                    elif 'LIBRARY_PATH_51' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_51_IS_ACTIVE']
                    elif 'LIBRARY_PATH_52' in k:
                        source_path_dict[v1] = my_param_dict['LIBRARY_PATH_52_IS_ACTIVE']
                    else:
                        continue
                else:
                    continue
    #END FOR

    source_path_list = []

    for k,v in source_path_dict.iteritems():
        if k:
            if k > " ":
                if str(v) == str("True"):
                    source_path_list.append(k)

    del source_path_dict

    source_path_list.sort()

    return source_path_list
#----------------------------------------------------------------------------------------------------------------
def add_mcs_word_book_index(my_db, my_cursor, notifications, log, orig_bookid_list, source_path):

    if not prefs['CALM_MCS_INDEX_CONSOLIDATION'] == unicode("True"):
        return

    localtime = time.asctime( time.localtime(time.time()) )
    log("Consolidating Source MCS Words-by-Book Index: " + localtime + "  -- Large Indexes might take a few minutes...")

    my_cursor.execute("PRAGMA shrink_memory;")

    try:
        mysql = "SELECT book,word FROM SOURCE._mcs_word_book_index"
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
        if len(tmp_rows) == 0:
            log("Source MCS Words-by-Book Index is empty; nothing done.")
            return
    except:
        log("Source MCS Words-by-Book Index does not exist; nothing done.")
        return

    #~ log("Retrieved Source Library MCS Words-by-Book Index")

    mysql = "SELECT id,orig_bookid FROM main._book_xref WHERE orig_library = ? "
    my_cursor.execute(mysql,([source_path]))
    tmp_rows2 = my_cursor.fetchall()
    if not tmp_rows2:
        tmp_rows2 = []
    if len(tmp_rows2) == 0:
        return
    id_dict = {}
    for row in tmp_rows2:
        id,orig_bookid = row
        if not orig_bookid in orig_bookid_list:
            continue
        id_dict[orig_bookid] = id
    #END FOR
    del tmp_rows2

    #~ log("Adding to Target Library Index...")

    my_cursor.execute("PRAGMA shrink_memory;")

    my_cursor.execute("begin")
    i = 0
    for row in tmp_rows:
        orig_bookid,word = row
        if not orig_bookid in id_dict:
            continue
        id = id_dict[orig_bookid]
        id = int(id)
        mysql = "INSERT OR IGNORE INTO main._mcs_word_book_index (book,word) VALUES (?,?) "
        my_cursor.execute(mysql,(id,word))
        i = i + 1
        if i > 200000:
            i = 0
            my_cursor.execute("commit")
            my_cursor.execute("PRAGMA shrink_memory;")
            my_cursor.execute("begin")
    #END FOR
    try:
        my_cursor.execute("commit")
    except:
        pass

    del tmp_rows
    del id_dict

    my_cursor.execute("PRAGMA shrink_memory;")

#----------------------------------------------------------------------------------------------------------------
def mcs_create_txt_format_word_index_table(my_db,my_cursor):
    my_cursor.execute("begin")
    mysql = "CREATE TABLE IF NOT EXISTS _mcs_word_book_index (book INTEGER NOT NULL, word TEXT NOT NULL , PRIMARY KEY (book, word))"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
    my_cursor.execute("begin")
    mysql =  "CREATE INDEX IF NOT EXISTS __mcs_word_book_index_by_word ON _mcs_word_book_index ( word )  "
    my_cursor.execute(mysql)
    my_cursor.execute("commit")
#----------------------------------------------------------------------------------------------------------------
def check_calm_consolidation_status(my_db, my_cursor, notifications, log, source_path):

    my_cursor.execute("begin")
    mysql = "CREATE TABLE IF NOT EXISTS _calm_consolidation_status (source_library TEXT PRIMARY KEY  NOT NULL  UNIQUE , started BOOL DEFAULT 0, completed BOOL DEFAULT 0)"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    if prefs['CALM_FORCE_RECONSOLIDATION'] == unicode("True"):
        purge_previous_consolidation(my_db, my_cursor, notifications, log, source_path)
        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO _calm_consolidation_status (source_library,started,completed) VALUES (?,1,0)"
        my_cursor.execute(mysql,([source_path]))
        my_cursor.execute("commit")
        log("Forced Reconsolidation will be performed for: " + source_path)
        return


    mysql = "SELECT started,completed FROM main._calm_consolidation_status WHERE source_library = ? "
    my_cursor.execute(mysql,([source_path]))
    tmp_list = my_cursor.fetchall()
    if not tmp_list:
        my_cursor.execute("begin")
        mysql = "INSERT OR REPLACE INTO _calm_consolidation_status (source_library,started,completed) VALUES (?,1,1)"
        my_cursor.execute(mysql,([source_path]))
        my_cursor.execute("commit")
        return
    else:
        if len(tmp_list) == 0:
            my_cursor.execute("begin")
            mysql = "INSERT OR REPLACE INTO _calm_consolidation_status (source_library,started,completed) VALUES (?,1,0)"
            my_cursor.execute(mysql,([source_path]))
            my_cursor.execute("commit")
            return
        else:
            for row in tmp_list:
                started,completed = row
                if started == 0:
                    my_cursor.execute("begin")
                    mysql = "INSERT OR REPLACE INTO _calm_consolidation_status (source_library,started,completed) VALUES (?,1,0)"
                    my_cursor.execute(mysql,([source_path]))
                    my_cursor.execute("commit")
                    return
                else:
                    if completed == 0:
                        purge_previous_consolidation(my_db, my_cursor, notifications, log, source_path)
                        my_cursor.execute("begin")
                        mysql = "INSERT OR REPLACE INTO _calm_consolidation_status (source_library,started,completed) VALUES (?,1,0)"
                        my_cursor.execute(mysql,([source_path]))
                        my_cursor.execute("commit")
                        log("Previous failed consolidation for this Source Library has been purged; starting a fresh consolidation: " + source_path)
                        return
                    else:
                        return
            #END FOR
#----------------------------------------------------------------------------------------------------------------
def purge_previous_consolidation(my_db, my_cursor, notifications, log, source_path):
    # this is *not* intended for routine use. user should refresh and regenerate the target library instead.

    mysql_list = []
    mysql_list.append("DELETE FROM main._all_author_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main._all_book_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main._all_publisher_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main._all_series_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main._author_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main._book_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main._publisher_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main._series_xref WHERE orig_library = ? ")
    mysql_list.append("DELETE FROM main.books WHERE isbn = ? ")

    for mysql in mysql_list:
        my_cursor.execute("begin")
        my_cursor.execute(mysql,([source_path]))
        my_cursor.execute("commit")
        my_cursor.execute("PRAGMA shrink_memory;")
    #END FOR

    my_cursor.execute("begin")
    mysql = "DELETE FROM main._mcs_word_book_index WHERE book NOT IN (SELECT id FROM main.books WHERE id = main._mcs_word_book_index.book)"
    my_cursor.execute(mysql)
    my_cursor.execute("commit")

    my_cursor.execute("PRAGMA shrink_memory;")

#----------------------------------------------------------------------------------------------------------------
#----------------------------------------------------------------------------------------------------------------
#END of calm_main.py