# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.1.5"   # Allow themes with user-defined icons...
from calibre.customize import InterfaceActionBase

class ActionAuthorBookCount(InterfaceActionBase):

    name                    = 'Author Book Count'
    description           = 'Updates a custom column for the total number of books written by each author for every book in your library. It has functionality that standard Calibre does not provide, especially the ability to search using queries constructed with integers. Example: ((#abc_numeric:">6") and (#abc_numeric:"<47")). Its ABC column in the Tag Browser has full functionality based specifically on ABC.'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (2, 1, 5)
    minimum_calibre_version = (1, 48, 0)

    actual_plugin           = 'calibre_plugins.author_book_count.ui:AuthorBookCountUpdate'

    gui_name = "author_book_count"

    def is_customizable(self):

        return False



#END of __init__py