# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014, 2015 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "2.1.2"

import os, sys
import sqlite3
#from sqlite3 import IntegrityError, OperationalError, Row
from calibre.library.database import LibraryDatabase
import datetime
from calibre.db.backend import DB
from calibre import isbytestring, force_unicode, prints
from calibre.constants import (iswindows, filesystem_encoding,
        preferred_encoding)
from Queue import Empty, Queue
from calibre.gui2.threaded_jobs import ThreadedJob, BaseJob
from calibre.utils.logging import GUILog, Log

myquotes = "\""
mynothing = ""
mynull = None
custom_table = "custom_column_X"
custom_id = 999
books_custom_column_X_link_str = str("books_custom_column_X_link")
my_terminate_early = False

notifications = Queue()
log = Log()

# ------------------------------------------------------------------------------
#
#     Counts and Updates author_book_count for all books in the library
#
# ------------------------------------------------------------------------------

def get_all_author_book_counts(self, my_guidb, log=None, abort=None, notifications=True):  # <<<<====called from jobs.py

    notifications.put((0.05, 'Counting Author Books'))
    log('====================================================')

    self.guidb = my_guidb
    path = my_guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')
    try:
        print("get_all_author_book_counts: ", path)
    except:
        pass
    log(path)
    try:
        my_db = sqlite3.connect(path)
    except Exception as e:
        gui = self.gui
        return (self,gui,None,None,None)

    my_cursor = my_db.cursor()

    mysql = "PRAGMA main.busy_timeout = 5000;"      #PRAGMA busy_timeout = milliseconds;  (obviously just for this connection)
    my_cursor.execute(mysql)

    Refresh_author_book_count(my_db,my_cursor,log)

    if not my_terminate_early:
        notifications.put((0.99, 'Counting Author Books'))

    my_db.close()

    log(' ')
    log(' ')
    log('Author Book Count Complete. ')
    log('Every book in this library has been updated for ABC. ')
    log('Only One Author Per Book Was Counted. ')
    log(' ')
    log(' ')

    return (None,None,None,None,None)

def Refresh_author_book_count(my_db,my_cursor,log):

        global my_terminate_early

        Get_Custom_Table_Name(my_db,my_cursor,log)
        if not my_terminate_early :
            Drop_Standard_Calibre_Trigger(my_db,my_cursor,log)
            Refresh_custom_column_x(my_db,my_cursor,log)
            Refresh_books_custom_column_x(my_db,my_cursor,log)
            Refresh_Optional_ABC_Numeric(my_db,my_cursor,log)


def Get_Custom_Table_Name(my_db,my_cursor,log):

        # Determine what the custom column Author Book Count has as a physical field name as added previously by the user manually

        global custom_table
        global custom_id
        global books_custom_column_X_link_str
        global my_terminate_early

        custom_table = "custom_column_X"
        custom_id = 999
        books_custom_column_X_link_str = str("books_custom_column_X_link")

        mysql = "SELECT id FROM custom_columns WHERE label = 'author_book_count' "
        mysql = str(mysql)
        my_cursor.execute (mysql)
        rows = my_cursor.fetchall()
        for row in rows:
            for col in row:
                custom_id = col

        s = str(custom_table)
        custom_id_str = str(custom_id)
        custom_table = s.replace('X', custom_id_str, 1)
        s = str(books_custom_column_X_link_str)
        books_custom_column_X_link_str = s.replace('X', custom_id_str, 1)

        print("custom_table :", custom_table, "                           books_custom_column_X_link: ", books_custom_column_X_link_str)
        log("custom column table for ABC :         " + custom_table)
        log("the cc book link table for ABC:       " + books_custom_column_X_link_str)

        if str(custom_table) == str("custom_column_999") or str(custom_table) == str("custom_column_X") \
            or str(books_custom_column_X_link_str) == str("books_custom_column_X_link"):
            log("No Custom Table Column author_book_count Configured By User Yet.")
            log("Plugin terminated. Add author_book_count as a custom column.    ")
            print("No Custom Table Column author_book_count Configured By User Yet.")
            print("Plugin terminated. Add author_book_count as a custom column.    ")
            my_terminate_early = True

def Refresh_custom_column_x(my_db,my_cursor,log):
        #must come after Get_Custom_Table_Name

        global custom_table
        global custom_id
        custom_id_str = str(custom_id)
        global myquotes
        global books_custom_column_X_link_str

        mysql = "DELETE FROM " + custom_table + " WHERE id >= 0;"
        my_cursor.execute (mysql)
        my_db.commit()

        mycount = -1  #start at id = 0 just in case a user manually updates the supposedly hidden field with a zero for a book

        while mycount < 5000:
                mycount = mycount + 1
                mycountstr = str(mycount)
                mysql = "INSERT OR IGNORE INTO custom_column_X(id, value) VALUES"
                mysql  = mysql + "(s_1, s_2);"
                s = str(mysql)
                mysql = s.replace('X', custom_id_str, 1)
                mysql = mysql.replace('s_1', mycountstr, 1)
                mysql = mysql.replace('s_2', mycountstr, 1)

                try:
                    my_cursor.execute (mysql)
                    #my_db.commit()        #defer for ultra performance and avoid db busy lock warning; do at end
                except Exception as e:
                    print(mysql)
                    my_db.rollback()
                    raise e
                    my_db.close()

        my_db.commit()

def Refresh_books_custom_column_x(my_db,my_cursor,log):

        global custom_table
        global custom_id
        custom_id_str = str(custom_id)
        global myquotes
        global books_custom_column_X_link_str
        global mynull

        print("Refresh_books_custom_column_x:                  custom_table :", custom_table, "           books_custom_column_X_link: ", books_custom_column_X_link_str)

        Create_Temp_Table_z_tag_browser_authors(my_db,my_cursor)
        Refresh_z_tag_browser_authors(my_db,my_cursor)

        mysql = "DELETE FROM " + books_custom_column_X_link_str + " WHERE id >= 0;"
        my_cursor.execute (mysql)
        my_db.commit()

        tmp_book = "  "
        tmp_old_book = "   "

        my_list = []

        mysql = "SELECT book, author FROM books_authors_link where id >= 0;"
        my_cursor.execute (mysql)
        my_bal = my_cursor.fetchall()
        my_count = 0
        my_max = len(my_bal)
        while my_count < my_max:
            my_row = my_bal[my_count]
            my_row = str(my_row)
            my_list.append(my_row)
            my_count = my_count + 1

        del my_bal[0:my_max]
        sorted(my_list)
        my_max = len(my_list)
        my_denominator = my_max
        my_max = my_max - 1
        my_count = 0
        my_index = 1
        tmp_old_book = "0"
        my_commit_counter = 0
        while my_count <= my_max:
                tmp_string = str(my_list[my_count])  #convert to byte string from utf8
                tmp_string = tmp_string.replace('<', mynothing, 2)
                tmp_string = tmp_string.replace('>', mynothing, 2)
                tmp_string = tmp_string.replace('(', mynothing, 2)
                tmp_string = tmp_string.replace(')', mynothing, 2)
                tmp_string = tmp_string.replace(' ', mynothing, 4)
                tmp_booktmp = tmp_string[0:(tmp_string.find(",")) ]  #book is first:  book, author FROM books_authors_link
                tmp_book = tmp_booktmp.replace(',', mynothing, 4)
                if tmp_book == tmp_old_book:
                    my_count = my_count + 1
                else:
                    tmp_old_book = tmp_book
                    tmp_authortmp = tmp_string[(tmp_string.find(",")+1): ]
                    tmp_author = tmp_authortmp.replace(',', mynothing, 4)
                    mysql = "SELECT count FROM z_tag_browser_authors WHERE id = " + tmp_author + " "
                    mysql = str(mysql)
                    my_cursor.execute (mysql)
                    my_bal = my_cursor.fetchone()  #one author has one count from z_tag_browser_authors
                    tmp_string = str(my_bal)  #count for author      convert to byte string from utf8
                    tmp_string = tmp_string.replace('<', mynothing, 2)  #convert to byte string from utf8
                    tmp_string = tmp_string.replace('>', mynothing, 2)
                    tmp_string = tmp_string.replace('(', mynothing, 2)
                    tmp_string = tmp_string.replace(')', mynothing, 2)
                    tmp_string = tmp_string.replace(' ', mynothing, 4)
                    tmp_string = tmp_string.replace(',', mynothing, 4)
                    tmp_count = tmp_string
                    tmp_index = str(my_index)
                    mysql = "INSERT OR IGNORE INTO " + books_custom_column_X_link_str + " (id, book, value) VALUES"
                    mysql  = mysql + "(" + tmp_index + "," + tmp_book + "," + tmp_count + ") "
                    try:
                        my_cursor.execute (mysql)
                        if (my_commit_counter >= 500) or (my_count >= my_max):
                            my_db.commit()
                            my_commit_counter = 0
                    except Exception as e:
                        print ("mysql was: ", mysql)
                        my_db.rollback()
                        raise e
                        my_db.close()
                    my_count = my_count + 1
                    my_index = my_index + 1
                    my_commit_counter = my_commit_counter + 1
        #END WHILE


        if (my_commit_counter > 0):
            try:
                my_db.commit()
            except Exception as e:
                print ("mysql was: ", mysql)
                my_db.rollback()
                raise e
                my_db.close()


        mysql = "DROP TABLE IF EXISTS z_tag_browser_authors"
        my_cursor.execute (mysql)
        my_db.commit()

        del my_list[0:len(my_list)]


def Drop_Standard_Calibre_Trigger(my_db,my_cursor,log):

        global custom_id

        custom_id_str = str(custom_id)

        #this automatically Calibre-created trigger should never be executed because custom_column_X should never become empty given its nature and purpose.
        #this trigger will purge books_custom_column_X_link when custom_column_x is emptied and rebuilt. So, DROP it.
        mysql = "SELECT COUNT(*) from sqlite_master WHERE type = 'trigger' and name = 'fkc_delete_books_custom_column_X_link' "
        s = str(mysql)
        mysql = s.replace('X', custom_id_str, 1)
        my_cursor.execute (mysql)
        result=my_cursor.fetchone()
        number_of_rows=result[0]
        if number_of_rows <> 0:
            mysql = "DROP TRIGGER fkc_delete_books_custom_column_X_link"
            s = str(mysql)
            mysql = s.replace('X', custom_id_str, 1)
            my_cursor.execute (mysql)
            my_db.commit()

def Create_Temp_Table_z_tag_browser_authors(my_db,my_cursor):

        mysql = "SELECT COUNT(*) from sqlite_master WHERE tbl_name = 'z_tag_browser_authors' "
        my_cursor.execute (mysql)
        result=my_cursor.fetchone()
        number_of_rows=result[0]
        if number_of_rows == 0:
            try:
                mysql = "CREATE TEMP TABLE IF NOT EXISTS z_tag_browser_authors(id INTEGER PRIMARY KEY, name TEXT NOT NULL COLLATE NOCASE, count INTEGER)"
                my_cursor.execute (mysql)
                my_db.commit()
            except Exception as e:
                my_db.rollback()
                raise e
                my_db.close()

def Refresh_z_tag_browser_authors(my_db,my_cursor):

        global custom_table
        global custom_id
        custom_id_str = str(custom_id)
        global myquotes
        global books_custom_column_X_link_str

        mysql = "DELETE FROM z_tag_browser_authors WHERE id >= 0"
        try:
            my_cursor.execute (mysql)
            my_db.commit()
        except Exception as e:
            db.rollback()
            raise e
            my_db.close()

        mysql = "INSERT OR REPLACE INTO z_tag_browser_authors SELECT id, name,"
        mysql = mysql + "(SELECT COUNT(id) FROM books_authors_link WHERE author=authors.id) count FROM authors"
        try:
            my_cursor.execute (mysql)
            my_db.commit()
        except Exception as e:
            my_db.rollback()
            raise e
            my_db.close()


def Refresh_Optional_ABC_Numeric(my_db,my_cursor,log):
    #if the custom column abc_numeric exits, populate it as an integer, not text
    #this will enable purely numeric search criteria and regular expressions.
    #if the custom column does not exist, then nothing will be done.  optional

    #note that integer custom columns have no separate link table; the custom column table IS the link table.

    # from table custom_columns:  "16","abc_numeric","ABCNumeric","int","0","1","{""number_format"": null}","0","0"

    global mynothing
    global custom_table   #author_book_count custom column
    global custom_id
    global books_custom_column_X_link_str     #author_book_count custom column book link

    numeric_custom_table = "custom_column_X"
    numeric_custom_id = 999

    try:
        mysql = "SELECT id FROM custom_columns WHERE label = 'abc_numeric' "
        mysql = str(mysql)
        my_cursor.execute (mysql)
        rows = my_cursor.fetchall()
        if rows:
            for row in rows:
                for col in row:
                    numeric_custom_id = col
                    numeric_custom_id_str = str(custom_id)
            #END FOR

            s = str(numeric_custom_table)
            numeric_custom_id_str = str(numeric_custom_id)
            numeric_custom_table = s.replace('X', numeric_custom_id_str, 1)

            if numeric_custom_table == "custom_column_999" or numeric_custom_table == "custom_column_X":
                return
            else:
                pass
        else:
            return

        try:
            try:
                mysql = "DELETE FROM " + numeric_custom_table + " WHERE id >= 0;"
                s = str(mysql)
                my_cursor.execute (mysql)
                my_db.commit()
            except:
                return

            try:
                mysql = "INSERT OR IGNORE INTO " + numeric_custom_table + "  (id, book, value) SELECT * FROM " + books_custom_column_X_link_str + "  "
                s = str(mysql)
                my_cursor.execute (mysql)
                my_db.commit()
            except:
                return
        except:
            return
    except:
        return

#END of main.py
