# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014, 2015, 2016, 2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.1.8"      # Remove unnecessary blank space from final ABCH value.

import os, sys
import sqlite3
from calibre.library.database import LibraryDatabase
import datetime, re, sre_constants
from calibre.db.backend import DB
from calibre import isbytestring, force_unicode, prints
from calibre.constants import iswindows, filesystem_encoding, preferred_encoding, DEBUG
from sqlite3 import IntegrityError, OperationalError, Row
from Queue import Empty, Queue
from calibre.gui2.threaded_jobs import ThreadedJob, BaseJob
from calibre.utils.logging import GUILog, Log
from time import sleep
import time

myquotes = "\""
mynothing = ""
mynull = None
custom_table = "custom_column_X"
custom_id = 999
my_terminate_early = False

notifications = Queue()
log = Log()

my_results_list = []
is_testing = False  #if True, does not create TEMP tables...

# ----------------------------------------------------------------------------------------
#
#    Creates an Author Book Count Hierarchy for all books in the library
#
# -----------------------------------------------------------------------------------------

def Create_ABC_Hierarchy(self, my_guidb, log=None, abort=None, notifications=True):

    global my_terminate_early

    notifications.put((0.01, 'Building ABC Hierarchy'))
    log('====================================================')

    self.guidb = my_guidb
    path = my_guidb.library_path
    log("Library path: " + path)

    if is_testing:
        abch_db_path = "C:/CalibreStuff/author_book_count_hierarchy/abch_db/abch.db"
        if isbytestring(abch_db_path):
            abch_db_path = abch_db_path.decode(filesystem_encoding)
        if DEBUG: print(abch_db_path)
        log(abch_db_path)
        my_db = sqlite3.connect(abch_db_path)
    else:
        my_db = sqlite3.connect(':memory:')
        log("External-to-Calibre SQLite in-memory database is being used")

    my_cursor = my_db.cursor()

    mysql = "PRAGMA main.busy_timeout = 15000;"      #PRAGMA busy_timeout = milliseconds;  (obviously just for this connection)
    my_cursor.execute(mysql)

    my_terminate_early = False

    ABC_Control(my_guidb, my_db, my_cursor, log, notifications)

    if not my_terminate_early:
        notifications.put((0.99, 'ABCH Has Completed Processing'))

    my_db.close()

    log('====================================================')
    log('      Author Book Count Hierarchy Is Complete       ')
    log('Every book in this library has been updated for ABCH')
    log('====================================================')

    return


    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def ABC_Control(my_guidb, my_db, my_cursor, log, notifications):

        global my_terminate_early

        log("Beginning ABCH for All Books In Library")
        Create_SQLite_User_Function(my_db, my_cursor, log)
        Attach_Calibre_metadata_db(my_guidb, my_db, my_cursor, log)
        Verify_Custom_Column_Exists(my_db, my_cursor, log, notifications)
        log("Custom_Column Configuration Verified")
        notifications.put((0.02, 'Verifying Configuration...'))
        if not my_terminate_early :
            Build_Temp_Tables(my_db, my_cursor, log, notifications)
            log("Temporary Tables Created")
            Detach_Calibre_metadata_db(my_db, my_cursor, log)
            notifications.put((0.03, 'Constructing New ABC Hierarchy...'))
            if not my_terminate_early:
                Populate_zbooks_abc(my_db, my_cursor, log, notifications)
                log("New ABC Hierarchy Constructed")
                notifications.put((0.50, 'Updating Books with New ABC...'))
                if not my_terminate_early :
                    Attach_Calibre_metadata_db(my_guidb, my_db, my_cursor, log)
                    Update_Custom_Column_Tables(my_db, my_cursor, log, notifications)
                    log("Custom_Column Tables Populated")

    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Update_Custom_Column_Tables(my_db, my_cursor, log, notifications):
    #wipe then insert the new values in both the custom table and the books custom column link table

    global custom_table
    global custom_id
    global my_terminate_early

    custom_id_str = str(custom_id)
    books_custom_column_X_link_str = "books_custom_column_X_link"
    books_custom_column_X_link_str =  books_custom_column_X_link_str.replace('X', custom_id_str, 1)

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "DELETE FROM " + custom_table + " WHERE id > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "DELETE FROM " + books_custom_column_X_link_str + " WHERE id > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "UPDATE sqlite_sequence SET seq = 1 WHERE name = '" + custom_table + "'   ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "UPDATE sqlite_sequence SET seq = 1 WHERE name = '" + books_custom_column_X_link_str + "'  ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "INSERT OR IGNORE INTO " + custom_table + " SELECT id, abc FROM zabc WHERE id > '0' ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "UPDATE " + custom_table + " SET value = replace(value,'|',',') "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if my_terminate_early:
        log("Job Failure.  Terminated.  ")
        return

    sleep(0.01)

    mysql = "SELECT book FROM zbooks_abc WHERE book > '0' ;"
    mysql = str(mysql)
    my_cursor.execute (mysql)
    my_books = my_cursor.fetchall()
    if not my_books:
        log("Job Failure.  Terminated.  ")
        my_terminate_early = True
        return
    else:
        if len(my_books) == 0:
            log("Job Failure.  Terminated.  ")
            my_terminate_early = True
            return

    n = len(my_books)
    i = 0
    my_cursor.execute ("BEGIN TRANSACTION")
    for row in my_books:
        i = i + 1
        tmp_book = row
        tmp_book = Change_Tuple_To_ByteString(tmp_book, log)
        tmp_book = tmp_book.replace(",", mynothing, 10)
        tmp_book = tmp_book.replace(" ", mynothing, 10)  #now a simple integer in bytestring format

        mysql = "SELECT id FROM zabc WHERE zabc.abc IN (SELECT abc FROM zbooks_abc \
                                                           WHERE book = '" + tmp_book + "' );"
        mysql = str(mysql)
        my_cursor.execute (mysql)
        tmp_tmp_list = my_cursor.fetchall()
        if tmp_tmp_list:
            id = tmp_tmp_list[0]
            id = Change_Tuple_To_ByteString(tmp_book, log)
            id = id.replace(",", mynothing, 10)
            id = id.replace(" ", mynothing, 10)  #now a simple integer in bytestring format

            mysql = "INSERT OR IGNORE INTO " + books_custom_column_X_link_str + " SELECT null, book, id \
                                           FROM zbooks_abc WHERE book = '" + tmp_book + "' ;"
            Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql)
            n_float = (0.5 + (0.5*(i/n) ) )
            notifications.put((n_float, 'Updating ' + str(n) + ' Books...'))
        else:
            if DEBUG: print("Error Updating books_custom_column_X_link_.  No id found from SELECT id FROM zabc for: ", tmp_book)
            log("Error Updating books_custom_column_X_link_.  No id found from SELECT id FROM zabc for: ", tmp_book)
            if DEBUG: print(mysql)
    #END FOR
    try:
        my_db.commit()
    except:
        pass

    #ztables will be dropped automatically since they were created as TEMP

    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Populate_zbooks_abc(my_db, my_cursor, log, notifications):

    my_list = []
    tmp_list = []
    my_work_list = []
    my_book_list = []
    my_books = []
    my_zbooks_abc_list = []
    tmp_list2 = []
    my_rows = []

    global my_results_list
    my_results_list = []

    global mynothing


    mysql = "SELECT book FROM zbooks_authors WHERE book > '0' ;"
    mysql = str(mysql)
    my_cursor.execute (mysql)
    my_books = my_cursor.fetchall()

    my_bks = set(my_books) #make unique set of values for book
    del my_books
    my_books = list(my_bks)
    del my_bks

    sorted(my_books)

    for item in my_books:  #now only unique values for a book in this list
        tmp_book = item
        tmp_book = Change_Tuple_To_ByteString(tmp_book, log)
        tmp_book = tmp_book.replace(",", mynothing, 10)
        tmp_book = tmp_book.replace(" ", mynothing, 10)  #now a simple integer in bytestring format
        my_book_list.append(tmp_book)
    #END FOR
    del my_books

    my_cursor.execute ("BEGIN TRANSACTION")
    for item in my_book_list:
        my_rows = []
        del my_rows
        tmp_book = item
        mysql = "SELECT author_name, author_count FROM zbooks_authors WHERE book = '" + tmp_book + "' ;"
        mysql = str(mysql)
        my_cursor.execute (mysql)
        my_rows = my_cursor.fetchall()  #all of the authors for the same book
        del my_work_list
        my_work_list = []
        appnd = ""
        for row in my_rows:  # example:   (u'author_name', u'author_count') ; 1 row for each co-author of the identical current book
            tmp1 = row
            tmp2 = Change_Tuple_To_ByteString(tmp1, log)
            del tmp_list
            tmp_list = tmp2.split(",")  # author_name, author_count
            tmp3 = tmp_list[0] # author_name
            tmp_list[0] = Change_Tuple_To_ByteString(tmp3, log)
            tmp3 = tmp_list[1] # author_count
            tmp3 = tmp3.replace(" ", mynothing, 10)
            tmp_list[1] = Change_Tuple_To_ByteString(tmp3, log)
            #now append it in reverse field order so it can be sorted by author_count
            appnd =   tmp_list[1] + "$$" + tmp_list[0]  + "(" + tmp_list[1] + ")"     #now:   "7$$Evangeline Anderson(7)"
            my_work_list.append(appnd)
        #END FOR

        del my_rows
        my_work_list.sort(reverse=True) #sort in-place; sorted by author_count and then author_name

        #after sorting, can remove leading abc value from each row     #now:   "7$Evangeline Anderson(7)"

        my_highest_abc = 0
        tmp_split_list = []
        tmp_list2 = []
        del tmp_list2
        tmp_list2 = []
        for row in my_work_list:   #now:   "7$$Evangeline Anderson(7)"
            tmp_abc = row
            tmp_split_list = tmp_abc.split("$$")
            tmp_list2.append(tmp_split_list[1])  #now "Evangeline Anderson(7)"
            if tmp_split_list[0] > my_highest_abc:
                my_highest_abc = tmp_split_list[0]
        #END FOR
        tmp_split_list = []
        del tmp_split_list

        tmp_abc = ""
        n = 0
        for row in tmp_list2:   #desired format:  7  Evangeline Anderson(7) Reese Dante(1) Barb Rice(1)
            n = n + 1
            #now concatenate all the rows for the current tmp_book  into a single row appropriate for a Tag Browser Hierarchy
            if n == 1:
                #tmp_abc = my_highest_abc + " " + row  #with leading abc, e.g. 7  Evangeline Anderson(7) Reese Dante(1) Barb Rice(1)
                tmp_abc = tmp_abc + " " + row #without leading abc,           e.g.      Evangeline Anderson(7) Reese Dante(1) Barb Rice(1)
            else:
                tmp_abc = tmp_abc + " " + row
        #END FOR
        tmp_list2 = []
        del tmp_list2

        tmp_abc = tmp_abc.strip()      # Remove unnecessary blank space from final ABCH value.

        tmp_abc = "u'" + tmp_abc + "'"

        mysql = 'INSERT OR IGNORE INTO zabc (id, abc) VALUES (null, "' + tmp_abc + '" );'
        Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql)

        appnd = tmp_book,tmp_abc
        my_zbooks_abc_list.append(appnd)

    #END FOR
    try:
        my_db.commit()
    except:
        pass

    del my_book_list

    my_zbooks_abc_list.sort()

    tmp_list = []
    del tmp_list
    tmp_tmp_list = []
    del tmp_tmp_list
    my_cursor.execute ("BEGIN TRANSACTION")
    for row in my_zbooks_abc_list:
        tmp_book,tmp_abc = row
        mysql = 'SELECT id,id FROM zabc WHERE abc = "' + tmp_abc + '" ;'
        mysql = str(mysql)
        my_cursor.execute (mysql)
        tmp_tmp_list = my_cursor.fetchall()
        if not tmp_tmp_list:
            tmp_tmp_list = []
        for row in tmp_tmp_list:
            id,dummy = row
            tmp_id = str(id)
            mysql = 'INSERT OR IGNORE INTO zbooks_abc (book, abc, id) VALUES ("' + tmp_book + '","' +  tmp_abc + '","' + tmp_id + '" ) ;'
            Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql)
        #END FOR
   #END FOR
    try:
        my_db.commit()
    except:
        pass


    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "UPDATE zabc SET abc = (eval_utf8(abc) );"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)


    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "UPDATE zbooks_abc SET abc = (eval_utf8(abc) );"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

   #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Build_Temp_Tables(my_db, my_cursor, log, notifications):

    global is_testing

    if not is_testing:
        mysql = "CREATE TEMP TABLE IF NOT EXISTS zbooks_authors(book INTEGER NOT NULL,\
                author_id INTEGER NOT NULL,\
                author_name TEXT COLLATE NOCASE DEFAULT NULL,\
                author_count INTEGER DEFAULT NULL,\
                PRIMARY KEY (book, author_id)  )"
    else:
        mysql = "CREATE TABLE IF NOT EXISTS zbooks_authors(book INTEGER NOT NULL,\
        author_id INTEGER NOT NULL,\
        author_name TEXT COLLATE NOCASE DEFAULT NULL,\
        author_count INTEGER DEFAULT NULL,\
        PRIMARY KEY (book, author_id)  )"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "DELETE FROM zbooks_authors WHERE book > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "INSERT OR IGNORE INTO zbooks_authors (book, author_id)\
             SELECT book, author  FROM books_authors_link  WHERE book > 0 and author > 0 "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "UPDATE zbooks_authors SET author_name = (SELECT name FROM authors \
                                                    WHERE authors.id = zbooks_authors.author_id) "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "UPDATE zbooks_authors SET author_count = (SELECT COUNT(id) FROM books_authors_link \
                                                    WHERE author=zbooks_authors.author_id) "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if not is_testing:
        mysql = "CREATE TEMP TABLE IF NOT EXISTS zbooks_abc (book INTEGER NOT NULL,abc TEXT COLLATE NOCASE DEFAULT NULL,\
                                        id INTEGER, PRIMARY KEY (book)  ) "
    else:
        mysql = "CREATE TABLE IF NOT EXISTS zbooks_abc (book INTEGER NOT NULL,abc TEXT COLLATE NOCASE DEFAULT NULL,\
                                id INTEGER, PRIMARY KEY (book)  ) "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "DELETE FROM zbooks_abc WHERE book > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    if not is_testing:
        mysql = "CREATE TEMP TABLE IF NOT EXISTS zabc ( id INTEGER PRIMARY KEY AUTOINCREMENT, abc TEXT NOT NULL COLLATE NOCASE)"
    else:
        mysql = "CREATE TABLE IF NOT EXISTS zabc ( id INTEGER PRIMARY KEY AUTOINCREMENT, abc TEXT NOT NULL COLLATE NOCASE)"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "DELETE FROM zabc WHERE id > '0' "
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    my_cursor.execute ("BEGIN TRANSACTION")
    mysql = "UPDATE sqlite_sequence SET seq = 1 WHERE name = 'zabc'   ;"
    Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql)

    mysql = "SELECT COUNT(id) FROM authors WHERE name LIKE '%| %'  "
    my_cursor.execute(mysql)
    rows = my_cursor.fetchall()
    if not rows:
        rows = []
    if len(rows) > 0:
        for row in rows:
            for col in row:
                n = str(col)
        log("-------------------------------------------------------------------------------------------------------------------------------------")
        msg = "Number of authors with a bar '|' due to a LN,FN format: " + n
        log(msg)
        del rows
        mysql = "SELECT COUNT(id) FROM authors WHERE name  NOT LIKE '%| %'  AND name LIKE '%, %'  "
        my_cursor.execute(mysql)
        rows = my_cursor.fetchall()
        if not rows:
            rows = []
        if len(rows) > 0:
            for row in rows:
                for col in row:
                    n = col
            if n > 0:
                n = str(n)
                msg = "Number of authors without a bar '|' but with a comma: " + n + "  This could be correct, such as for a suffix.  However, if your #abc_hierarchy is incorrect, then this is likely the cause. "
                log(msg)
                log("To fix a corrupt author name as described above, simply manually change the author from LN,FN to FN,LN.  Save.  Then, manually change it back to LN,FN.  It should now be fixed.")
            else:
                msg = "Number of authors without a bar '|' but with a comma:  0  "
                log("")
        del rows
        log("-------------------------------------------------------------------------------------------------------------------------------------")
   #----------------------------------------------------------------------------------------------------------------------------------------------------------
def Execute_mysql_with_commit_generic(my_db, my_cursor, log, mysql):

    global my_terminate_early

    mysql = str(mysql)
    try:
        my_cursor.execute (mysql)
        my_db.commit()
    except Exception as e:
        log("Exception in Execute_mysql_with_commit_generic(my_db, my_cursor, mysql, log) ")
        log(str(e))
        log(mysql)
        my_terminate_early = True
        #raise e
  #----------------------------------------------------------------------------------------------------------------------------------------------------------
def Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql):

    global my_terminate_early

    mysql = str(mysql)
    try:
        my_cursor.execute (mysql)
    except Exception as e:
        log("Exception in Execute_mysql_without_commit_generic(my_db, my_cursor, log, mysql) ")
        log(str(e))
        log(mysql)
        my_terminate_early = True
        #raise e
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Verify_Custom_Column_Exists(my_db, my_cursor, log, notifications):

        # Determine what the custom column Author Book Count Hierarchy has as a physical field name as added previously by the user manually

        global custom_table
        global custom_id
        global my_terminate_early

        custom_table = "custom_column_X"
        custom_id = 999

        mysql = "SELECT id FROM custom_columns WHERE label = 'abc_hierarchy' "
        mysql = str(mysql)
        my_cursor.execute (mysql)
        rows = my_cursor.fetchall()
        if not rows:
            log("No Custom Table Column abc_hierarchy Configured By User Yet.")
            log("Plugin terminated. Add abc_hierarchy as a custom column.")
            my_terminate_early = True
        else:
            if len(rows) == 0:
                log("No Custom Table Column abc_hierarchy Configured By User Yet.")
                log("Plugin terminated. Add abc_hierarchy as a custom column.    ")
                my_terminate_early = True
            else:
                for row in rows:
                    for col in row:
                        custom_id = col

        s = str(custom_table)
        custom_id_str = str(custom_id)
        custom_table = s.replace('X', custom_id_str, 1)

        if custom_table == "custom_column_999" or custom_table == "custom_column_X":
            log("No Custom Table Column abc_hierarchy Configured By User Yet.")
            log("Plugin terminated. Add abc_hierarchy as a custom column.    ")
            my_terminate_early = True
    #-----------------------------------------------------------------------------------------------------------------------------------------------------------
def Change_Tuple_To_ByteString(tuple, log):
    #do not ever remove spaces or commas here

    global mynothing

    s_string = str(tuple)

    s_string = s_string.replace('u"', mynothing, 100)
    s_string = s_string.replace("u'", mynothing, 100)
    s_string = s_string.replace("'", mynothing, 100)
    s_string = s_string.replace("(", mynothing, 100)
    s_string =s_string.replace(")", mynothing, 100)

    s_string = s_string.replace('"', mynothing, 100)

    return s_string
       #----------------------------------------------------------------------------------------------------------------
def Attach_Calibre_metadata_db(my_guidb, my_db, my_cursor, log):

    global my_terminate_early

    path = my_guidb.library_path
    if isbytestring(path):
        path = path.decode(filesystem_encoding)
    path = path.replace(os.sep, '/')
    path = os.path.join(path, 'metadata.db')
    path = path.replace(os.sep, '/')

    try:
        s1 = "ATTACH DATABASE '"
        s2 =  "'  As 'Calibre';"
        mysql = s1 + path + s2
        if isbytestring(mysql):
            mysql = mysql.decode(filesystem_encoding)
        my_cursor.execute(mysql)
        if DEBUG: print("Calibre metadata.db has been properly attached")
        if DEBUG: print(path)
        log("Calibre metadata.db has been properly attached")
        log(path)
    except Exception as e:
        if DEBUG: print("Calibre metadata.db has NOT been properly attached")
        if DEBUG: print(mysql)
        if DEBUG: print(str(e))
        s = str(e)
        log(s)
        my_db.close()
        if DEBUG: print("terminating early...")
        log("terminating early...")
        my_terminate_early = True
        return
   #----------------------------------------------------------------------------------------------------------------
def Detach_Calibre_metadata_db(my_db, my_cursor, log):

    try:
        mysql = "DETACH DATABASE 'Calibre' "
        my_cursor.execute(mysql)
        if DEBUG: print("Calibre metadata.db has been detached")
        log("Calibre metadata.db has been detached")
    except Exception as e:
        pass
      #---------------------------------------------------------------------------------------------------
def Create_SQLite_User_Function(my_db, my_cursor, log):
        #see https://docs.python.org/2/library/sqlite3.html

        global my_terminate_early

        #paramers are: function name for SQLite; number of parameters; Python callable function
        try:
            my_db.create_function("eval_utf8", 1, SQLite_User_Function_1)
        except:
            my_terminate_early = True
            log("Create_SQLite_User_Function failed...cannot proceed...")
    #---------------------------------------------------------------------------------------------------
def SQLite_User_Function_1(s):
    #makes Unicode utf-8 strings lowercase for proper matching
    #how to use in SQLite, bearing in mind that this is a "simple user function" not
    #an "aggregate user function" that would only be usable within a SELECT statement:
    #------------------------------------------------------------------------------------------------------------
    #mysql = "UPDATE zbooks_abc SET abc = (eval_utf8(abc) );"
    #------------------------------------------------------------------------------------------------------------

    t = s
    if t is None: #ignore Nulls being passed by SQLite
        return s
    else:
        try:
            if isinstance(t, unicode):
                t = eval(t)  #unicode such as  u'n\xe3o-fic\xe7\xe3o'   that users want to see in the gui custom column as:  não-ficção
                return t
            else:
                pass
        except:
            #if DEBUG: print("SQLite_User_Function_1 Error: t = t.lower() Failed.")
            pass

    return s
     #--------------------------------------------------------------------------------------------------------------------------------------------



#END of main.py
