# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014, 2015, 2016, 2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.1.5"

try:
    from PyQt5.Qt import QMenu, QDialog, QIcon, QAction
except:
    from PyQt4.Qt import QMenu, QDialog, QIcon, QAction

import os, sys
from Queue import Queue
from calibre.gui2 import info_dialog, question_dialog, error_dialog, Dispatcher
from calibre.gui2.actions import InterfaceAction
from calibre.gui2.dialogs import message_box
from functools import partial
from calibre_plugins.author_book_count_hierarchy.common_utils import set_plugin_icon_resources, get_icon, create_menu_action_unique
from calibre_plugins.author_book_count_hierarchy.jobs import start_abc_hierarchy_threaded
from calibre_plugins.author_book_count_hierarchy.main import Create_ABC_Hierarchy
import zipfile
import subprocess
from calibre.db.cache import Cache as dbcache                   #to force the cache to be refreshed

PLUGIN_ICONS = ['images/abchicon.png', 'images/abchsmallicon.png', 'images/readinstructionsicon.png']

class AuthorBookCountHierarchyUpdate(InterfaceAction):      #<<<<======= called from __init__.py per actual_plugin = ...

    name = 'author_book_count_hierarchy'
    # Create the top-level menu/toolbar action (text, icon_path, tooltip, keyboard shortcut)
    action_spec = ('ABCH', 'images/abchicon.png', 'Create ABC Hierarchy', None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 9
    popup_type = 1

    my_plugin_path = "unknown"
    documentation_path = "unknown"

    my_guidb = "unknown"
    my_gui = "unknown"

    #-----------------------------------------------------------------------------------------
    def genesis(self):

        global my_plugin_path

        my_plugin_path = self.plugin_path

        self.is_library_selected = True

        self.menu = QMenu(self.gui)

        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )

        gui = self.gui
        self.rebuild_menus(gui)  #sub-menu, with 2 lines

        # main icon
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))

        self.qaction.triggered.connect(self.start_threaded_books_to_count)

        global my_guidb
        my_guidb = "unknown"
 #-----------------------------------------------------------------------------------------
    def library_changed(self, guidb):

        global my_guidb
        my_guidb = guidb
        self.guidb = guidb

        #~ try:
            #~ print("library has changed to: ", my_guidb.library_path)
        #~ except:
            #~ pass

        global my_gui
        my_gui = self.gui

        self.rebuild_menus(my_gui)
        self.qaction.setMenu(self.menu)
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))

    #-----------------------------------------------------------------------------------------
    def start_threaded_books_to_count(self):

        global my_guidb
        global my_gui

        if my_guidb == "unknown" or my_gui == "unknown":
            my_gui = self.gui
            my_guidb = self.gui.library_view.model().db

        if question_dialog(self.gui, "Author Book Count Hierarchy", "Execute Author Book Count Hierarchy:  Continue?"):
            start_abc_hierarchy_threaded(self, my_gui, my_guidb, Dispatcher(self.abch_job_complete) )  #<<<<<== in jobs.py
            self.gui.status_bar.show_message(_('ABC Hierarchy Job Has Been Submitted'), 500)
        else:
            return
    #-----------------------------------------------------------------------------------------
    def abch_job_complete(self, job):

        if job.failed:
            error_dialog(self.gui, 'ABCH: Job Has Failed', 'You Must Restart Calibre Before Running ABCH in this Library.' , ' ' ).show()
            return

        self.force_refresh_of_cache()

        self.gui.status_bar.show_message(_('ABC Hierarchy Job Has Completed'), 10000)


    #-----------------------------------------------------------------------------------------
    def rebuild_menus(self,gui):
        # main icon has 2 submenu icons, each with an actionable description

        self.gui = gui

        m = self.menu
        m.clear()
        m.addSeparator()
        create_menu_action_unique(self, m, 'Author Book Count Hierarchy', 'images/abchsmallicon.png',
                              triggered=partial(self.start_threaded_books_to_count))
        m.addSeparator()
        create_menu_action_unique(self, m, 'Read Instructions', 'images/readinstructionsicon.png',
                              triggered=partial(self.view_user_instructions))
        m.addSeparator()

        self.gui.keyboard.finalize()

    #-----------------------------------------------------------------------------------------
    def view_user_instructions(self):

        global documentation_path

        self.extract_documentation_from_zip() #every time to ensure latest copy is available after plugin upgrade

        try:
            p_pid = subprocess.Popen(documentation_path, shell=True)

            #Subprocess "p_pid"  is totally independent of Calibre,  and will never be checked or killed by this plugin...

        except:
            return error_dialog(self.gui, _('Documentation .pdf Not Found. Try reinstalling this plugin, and restarting Calibre.'),
                                       _('It is supposed to be: ' + documentation_path ), show=True)

    #-----------------------------------------------------------------------------------------
    def extract_documentation_from_zip(self):
        #extract the .pdf file from the zip so it can be executed directly.

        global my_plugin_path
        global documentation_path

        documentation_path = "unknown"

        zipfile_path = my_plugin_path

        destination_path = my_plugin_path
        destination_path = destination_path.replace("\Author Book Count Hierarchy.zip", "", 1)
        destination_path = destination_path.replace("/Author Book Count Hierarchy.zip", "", 1)

        zfile = zipfile.ZipFile(zipfile_path)

        dir_name = "abch_documentation"
        dir_name = dir_name.encode("ascii", "strict")

        file_name = 'abch_instructions.pdf'
        file_name = file_name.encode("ascii", "strict")

        file_name = os.path.join(dir_name, file_name )

        for name in zfile.namelist(): #all files in zip with full internal paths
            n = name.find(dir_name)
            if n >= 0:
                zfile.extract(name, destination_path)
                documentation_path = os.path.join(destination_path, file_name)
                #"C:\Users\DaltonST\AppData\Roaming\calibre\plugins\abch_documentation\abch_instructions.pdf"

  #-------------------------------------------------------------------------------------------------------------------------------------
    def force_refresh_of_cache(self):

        db = self.gui.current_db.new_api                           #see:  http://manual.calibre-ebook.com/db_api.html
        work_book_ids_frozenset = db.all_book_ids()
        books_to_refresh = []
        for row in work_book_ids_frozenset:      #ALL books in the database will be refreshed.  This is the only safe way to avoid a total restart.
            books_to_refresh.append(row)

        backend = self.gui.library_view.model().db.backend
        mydbcache = dbcache(self.gui.library_view.model().db.backend)
        mydbcache.init()  #refreshes the cache from the physical metadata.db.  refer to:   \src\calibre\db\cache.py
        self.gui.library_view.model().refresh_ids(list(books_to_refresh))  #refreshes the gui from the cache
        #                                                       class EditMetadataAction in src>calibre>gui2>actions>edit_metadata.py
        self.gui.tags_view.recount()  #refreshes the tag browser
        #                                                       class TagsView in src>calibre>gui2>tag_browser>view.py


    #-----------------------------------------------------------------------------------------
#END of ui.py