# -*- coding: utf-8 -*-
from __future__ import (unicode_literals, division, absolute_import, print_function)
__license__   = 'GPL v3'
__copyright__ = '2014, 2015, 2016, 2017 DaltonST <DaltonShiTzu@outlook.com>'
__my_version__ = "1.1.8"  # Remove unnecessary blank space from final ABCH value.

from calibre.customize import InterfaceActionBase

class ActionAuthorBookCountHierarchy(InterfaceActionBase):

    name                    = 'Author Book Count Hierarchy'
    description             = 'Creates a Hierarchy of Author Book Counts designed for perusing complex Co-Author relationships, not just simple ABC counts.  Provides functionality not available in standard Calibre.'
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 1, 8)
    minimum_calibre_version = (1, 48, 0)

    actual_plugin           = 'calibre_plugins.author_book_count_hierarchy.ui:AuthorBookCountHierarchyUpdate'

    gui_name = "author_book_count_hierarchy"

    def is_customizable(self):

        return False

#END of __init__py