/*
 * Decompiled with CFR 0.152.
 */
package com.prasanta.sample;

import com.pras.Log;
import com.pras.SpreadSheet;
import com.pras.SpreadSheetFactory;
import com.pras.WorkSheet;
import com.pras.table.Record;
import java.util.ArrayList;
import java.util.HashMap;

public class WorkSheetSample {
    public static void main(String[] args) {
        Log.enableLog();
        SpreadSheetFactory spf = SpreadSheetFactory.getInstance(args[0], args[1]);
        ArrayList<SpreadSheet> spreadSheets = spf.getSpreadSheet("Pras", false);
        if (spreadSheets == null || spreadSheets.size() == 0) {
            System.out.println("No SpreadSheet Exists!");
            return;
        }
        System.out.println("Number of SpreadSheets: " + spreadSheets.size());
        SpreadSheet sp = spreadSheets.get(0);
        ArrayList<WorkSheet> wks = sp.getWorkSheet("test", false);
        if (wks == null || wks.size() == 0) {
            System.out.println("No WorkSheet exists!!");
            return;
        }
        System.out.println("Number of WorkSheets: " + wks.size());
        WorkSheet wk = null;
        wk = wks.get(0);
        System.out.println("wk=" + wk.getTitle());
        HashMap<String, String> rs = new HashMap<String, String>();
        rs.put("date", "1st Jan 2011");
        rs.put("item", "Item3");
        rs.put("price", "250");
        wk.addRecord(sp.getKey(), rs);
        ArrayList<Record> records = wk.getRecords(sp.getKey());
        if (records == null || records.size() == 0) {
            System.out.println("No Record exists!!");
            return;
        }
        System.out.println("Number of Records: " + records.size());
        int i = 0;
        while (i < records.size()) {
            Record r = records.get(i);
            HashMap<String, String> data = r.getData();
            System.out.println("Data: " + data);
            ++i;
        }
    }
}

