/*
 * Decompiled with CFR 0.152.
 */
package com.prasanta.sample;

import com.pras.Log;
import com.pras.SpreadSheet;
import com.pras.SpreadSheetFactory;
import com.pras.WorkSheet;
import com.pras.conn.HttpConHandler;
import com.pras.table.Record;
import java.util.ArrayList;
import java.util.HashMap;

public class ConditionalDataRetrieve {
    public static void main(String[] args) {
        String TAG = "ConditionalDataRetrieve";
        Log.enableLog();
        SpreadSheetFactory spf = SpreadSheetFactory.getInstance(args[0], args[1]);
        ArrayList<SpreadSheet> spreadSheets = spf.getAllSpreadSheets();
        if (spreadSheets == null && spreadSheets.size() == 0) {
            Log.p(TAG, "No SpreadSheet Exists");
            return;
        }
        SpreadSheet s = spreadSheets.get(0);
        System.out.println("SpreadSheet: " + s.getTitle());
        s.addWorkSheet("tab_work_sample", new String[]{"Name", "Age", "Exp", "Country"});
        ArrayList<WorkSheet> wks = s.getAllWorkSheets();
        WorkSheet wk = wks.get(0);
        HashMap<String, String> record = new HashMap<String, String>();
        record.put("Name", "Santosh");
        record.put("Age", "25");
        record.put("Exp", "10");
        record.put("Country", "India");
        wk.addRecord(s.getKey(), record);
        ArrayList<Record> records = wk.getRecords(s.getKey(), false, String.valueOf(HttpConHandler.encode("\"Age\"")) + "<" + HttpConHandler.encode("30"), "column:Name");
        if (records == null || records.size() == 0) {
            System.out.println("No matching data");
            return;
        }
        int i = 0;
        while (i < records.size()) {
            Record r = records.get(i);
            HashMap<String, String> data = r.getData();
            System.out.println("Data: " + data);
            ++i;
        }
        s.deleteWorkSheet(wk);
    }
}

