/*
 * Decompiled with CFR 0.152.
 */
package com.pras.sp;

import com.pras.Log;
import com.pras.WorkSheetCell;
import com.pras.sp.Entry;
import com.pras.sp.Feed;
import com.pras.sp.Field;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseFeed
extends DefaultHandler {
    private String TAG = "ParseFeed";
    final String ATTRITUBE_ETAG = "gd:etag";
    final String ATTRITUBE_SRC = "src";
    final String NODE_FEED = "feed";
    final String NODE_ENTRY = "entry";
    final String NODE_ID = "id";
    final String NODE_TITLE = "title";
    final String NODE_SUMMARY = "summary";
    final String NODE_CONTENT = "content";
    final String NODE_LINK = "link";
    final String NODE_NAME = "name";
    final String NODE_EMAIL = "email";
    static String NODE_ROW_COUNT = "gs:rowCount";
    static String NODE_COL_COUNT = "gs:colCount";
    static String NODE_GS_DATA = "gs:data";
    static String NODE_GS_COL = "gs:column";
    final String NODE_GSX = "gsx:";
    final String NODE_GS_CELL = "gs:cell";
    final String ATTRITUBE_ROW = "row";
    final String ATTRITUBE_COL = "col";
    final String NODE_GD_RESOURCEID = "gd:resourceId";
    static String NODE_GS_FIELD = "gs:field";
    final String NODE_GACL_ROLE = "gAcl:role";
    final String NODE_GACL_SCOPE = "gAcl:scope";
    Feed f = null;
    Entry e = null;
    Field field = null;
    String node = null;

    public static void doCustomizationForSDK() {
        NODE_GS_DATA = "data";
        NODE_GS_COL = "column";
        NODE_GS_FIELD = "field";
        NODE_ROW_COUNT = "rowCount";
        NODE_COL_COUNT = "colCount";
    }

    public Feed parse(byte[] data) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(data), (DefaultHandler)this);
        }
        catch (Exception ex) {
            Log.p(this.TAG, "Error in parsing: " + ex.toString());
            ex.printStackTrace();
        }
        return this.f;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        WorkSheetCell cellInfo;
        super.characters(ch, start, length);
        if (this.node.equals("title")) {
            if (this.e == null) {
                this.f.setTitle(new String(ch).substring(start, start + length));
            } else {
                this.e.setTitle(new String(ch).substring(start, start + length));
            }
        }
        if (this.node.equals("summary")) {
            if (this.e != null) {
                this.e.setSummary(new String(ch).substring(start, start + length));
            }
        } else if (this.node.equals("name")) {
            if (this.e != null) {
                this.e.setAuthorName(new String(ch).substring(start, start + length));
            }
        } else if (this.node.equals("email")) {
            if (this.e != null) {
                this.e.setAuthorEmail(new String(ch).substring(start, start + length));
            }
        } else if (this.node.equals("id")) {
            if (this.e == null) {
                this.f.setId(new String(ch).substring(start, start + length));
            } else {
                this.e.setId(new String(ch).substring(start, start + length));
            }
        } else if (this.node.equals(NODE_ROW_COUNT)) {
            if (this.e != null) {
                this.e.setRowCount(Integer.parseInt(new String(ch).substring(start, start + length)));
            }
        } else if (this.node.equals(NODE_COL_COUNT)) {
            if (this.e != null) {
                this.e.setColCount(Integer.parseInt(new String(ch).substring(start, start + length)));
            }
        } else if (this.node.toLowerCase().startsWith("gsx:")) {
            this.node = this.node.toLowerCase();
            WorkSheetCell cell = new WorkSheetCell();
            cell.setName(this.node.toLowerCase().substring(this.node.indexOf(":") + 1));
            cell.setValue(new String(ch).substring(start, start + length));
            if (this.e != null) {
                this.e.addCell(cell);
            }
        } else if (this.node.equals("gd:resourceId")) {
            this.e.setResID(new String(ch).substring(start, start + length));
        } else if (this.node.equals(NODE_GS_FIELD)) {
            this.field.setValue(new String(ch).substring(start, start + length));
            this.e.addField(this.field);
        } else if (this.node.equals("gs:cell") && (cellInfo = this.e.getCellInfo()) != null) {
            cellInfo.setName(new String(ch).substring(start, start + length));
            if (this.e != null) {
                this.e.setCellInfo(cellInfo);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.f = new Feed();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        this.node = name.trim().length() == 0 ? localName : name;
        if (this.node.equals("feed")) {
            this.f = new Feed();
            this.f.setEtag(attributes.getValue("gd:etag"));
        } else if (this.node.equals("entry")) {
            this.e = new Entry();
            this.e.setETAG(attributes.getValue("gd:etag"));
        } else if (this.node.equals("content")) {
            this.e.setWorkSheetURL(attributes.getValue("src"));
        } else if (this.node.equals("link")) {
            if (this.e != null) {
                String rel = attributes.getValue("rel");
                if (rel != null && rel.equals("alternate")) {
                    String href = attributes.getValue("href");
                    int index = href.indexOf("?key=");
                    if (index != -1) {
                        this.e.setResID("spreadsheet:" + href.substring(index + 5));
                    }
                } else if (rel != null && rel.equals("edit")) {
                    this.e.setEditLink(attributes.getValue("href"));
                }
            }
        } else if (this.node.equals(NODE_GS_COL)) {
            String colName = attributes.getValue("name");
            if (colName != null) {
                this.e.addCol(colName);
            }
        } else if (this.node.equals(NODE_GS_FIELD)) {
            String fieldName = attributes.getValue("name");
            if (fieldName != null) {
                this.field = new Field();
                this.field.setColName(fieldName);
                this.field.setIndex(attributes.getValue("index"));
            }
        } else if (this.node.equals("gAcl:role")) {
            this.e.setAclRole(attributes.getValue("value"));
        } else if (this.node.equals("gAcl:scope")) {
            this.e.setAclScopeType(attributes.getValue("type"));
            this.e.setAclScopeValue(attributes.getValue("value"));
        } else if (this.node.equals("gs:cell")) {
            WorkSheetCell cellInfo = new WorkSheetCell();
            cellInfo.setRow(Integer.parseInt(attributes.getValue("row")));
            cellInfo.setCol(Integer.parseInt(attributes.getValue("col")));
            if (this.e != null) {
                this.e.setCellInfo(cellInfo);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        this.node = name.trim().length() == 0 ? localName : name;
        if (this.node == null) {
            return;
        }
        if (this.node.equals("entry")) {
            this.f.addEntry(this.e);
            this.e = null;
        }
    }
}

