/*
 * Decompiled with CFR 0.152.
 */
package com.pras.conn;

import com.pras.Log;
import com.pras.conn.Response;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;

public class HttpConHandler {
    public static final String AUTHORIZATION_HTTP_HEADER = "Authorization";
    public static final String GDATA_VERSION_HTTP_HEADER = "GData-Version";
    public static final String CONTENT_LENGTH_HTTP_HEADER = "Content-Length";
    public static final String CONTENT_TYPE_HTTP_HEADER = "Content-Type";
    public static final int HTTP_GET = 161;
    public static final int HTTP_POST = 162;
    public static final int HTTP_DELETE = 163;
    public static final int HTTP_PUT = 164;

    public Response doConnect(String urlStr, int type, HashMap<String, String> httpHeaders, String postData) {
        String res = null;
        HttpURLConnection con = null;
        Response response = new Response();
        String TAG = "HttpConHandler";
        try {
            Log.p(TAG, "URL=" + urlStr);
            System.getProperties().put("http.proxyHost", "168.219.61.250");
            System.getProperties().put("http.proxyPort", "8080");
            System.getProperties().put("https.proxyHost", "168.219.61.252");
            System.getProperties().put("https.proxyPort", "8080");
            URL url = new URL(urlStr);
            con = (HttpURLConnection)url.openConnection();
            OutputStream out = null;
            if (httpHeaders != null) {
                for (String k : httpHeaders.keySet()) {
                    con.setRequestProperty(k, httpHeaders.get(k));
                }
            }
            if (type == 162) {
                con.setDoOutput(true);
                out = con.getOutputStream();
                out.write(postData.getBytes());
                out.flush();
            } else if (type == 161) {
                con.setDoInput(true);
            } else if (type == 163) {
                con.setRequestMethod("DELETE");
                con.connect();
            } else if (type == 164) {
                con.setRequestMethod("PUT");
                con.setDoOutput(true);
                out = con.getOutputStream();
                out.write(postData.getBytes());
                out.flush();
            }
            response.setResponseCode("" + con.getResponseCode());
            response.setResponseMessage(con.getResponseMessage());
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer strBuf = new StringBuffer();
            String line = "";
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
            reader.close();
            if (out != null) {
                out.close();
            }
            res = strBuf.toString();
            response.setOutput(res);
            Log.p(TAG, "Response from Google Server: \n" + res);
        }
        catch (Exception ex) {
            Log.p(TAG, "Error in connection: " + ex.toString());
            response.setError(true);
            response.setException(ex);
            if (con == null) {
                return response;
            }
            InputStream error_in = con.getErrorStream();
            if (error_in == null) {
                return response;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(error_in));
            if (reader == null) {
                return response;
            }
            StringBuffer errStrBuf = new StringBuffer();
            String line = "";
            try {
                while ((line = reader.readLine()) != null) {
                    errStrBuf.append(line);
                }
                response.setErrorStreamMsg(errStrBuf.toString());
                reader.close();
                response.printErrorLog();
            }
            catch (Exception e) {
                Log.p(TAG, "Error in reading Stream: " + e.getMessage());
            }
        }
        return response;
    }

    public static String encode(String str) {
        try {
            str = URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return str;
    }
}

