/*
 * Decompiled with CFR 0.152.
 */
package com.pras;

import com.pras.Log;
import com.pras.SpreadSheetFactory;
import com.pras.WorkSheetRow;
import com.pras.conn.HttpConHandler;
import com.pras.conn.Response;
import com.pras.sp.Entry;
import com.pras.sp.Feed;
import com.pras.sp.Field;
import com.pras.sp.ParseFeed;
import com.pras.table.Record;
import com.pras.table.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class WorkSheet {
    private String TAG = "WorkSheet";
    private String workSheetID;
    private String workSheetURL;
    private String title;
    private int colCount;
    private int rowCount;
    String[] columns = null;
    private Table table;
    private Entry entry;
    private ArrayList<WorkSheetRow> records = new ArrayList();

    public String getWorkSheetID() {
        return this.workSheetID;
    }

    public void setWorkSheetID(String workSheetID) {
        this.workSheetID = workSheetID;
    }

    public String getWorkSheetURL() {
        return this.workSheetURL;
    }

    public void setWorkSheetURL(String workSheetURL) {
        this.workSheetURL = workSheetURL;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getColCount() {
        return this.colCount;
    }

    public void setColCount(int colCount) {
        this.colCount = colCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public String[] getColumns() {
        ArrayList<String> tableCols;
        if (this.columns != null) {
            return this.columns;
        }
        if (this.table != null && (tableCols = this.table.getCols()) != null) {
            String[] cols = new String[tableCols.size()];
            tableCols.toArray(cols);
            return cols;
        }
        return null;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    void setTable(Table table) {
        this.table = table;
    }

    public ArrayList<WorkSheetRow> getData(boolean isCachedData) {
        return this.getData(isCachedData, false, null, null);
    }

    public ArrayList<WorkSheetRow> getData(boolean isCachedData, boolean doReverse, String sq, String orderBy) {
        Response res;
        if (isCachedData) {
            return this.records;
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        String url = this.workSheetURL;
        if (doReverse) {
            url = url.concat("?reverse=true");
            if (sq != null) {
                url = url.concat("&sq=" + sq);
            }
            if (orderBy != null) {
                url = url.concat("&orderby=" + orderBy);
            }
        } else if (sq != null) {
            url = url.concat("?sq=" + sq);
            if (orderBy != null) {
                url = url.concat("&orderby=" + orderBy);
            }
        } else if (orderBy != null) {
            url = url.concat("?orderby=" + orderBy);
        }
        if ((res = http.doConnect(url, 161, httpHeaders, null)).isError()) {
            return null;
        }
        String xmlOut = res.getOutput();
        ParseFeed pf = new ParseFeed();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        this.records.clear();
        if (entries != null) {
            int i = 0;
            while (i < entries.size()) {
                Entry e = entries.get(i);
                WorkSheetRow row = new WorkSheetRow();
                row.setId(e.getId());
                row.setCells(e.getCells());
                this.records.add(row);
                ++i;
            }
        }
        return this.records;
    }

    public WorkSheetRow addListRow(HashMap<String, String> records) {
        StringBuffer listRecordXML = new StringBuffer();
        listRecordXML.append("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:gsx=\"http://schemas.google.com/spreadsheets/2006/extended\">");
        for (String colName : records.keySet()) {
            String value = records.get(colName);
            listRecordXML.append(" <gsx:" + colName + ">" + value + "</gsx:" + colName + ">");
        }
        listRecordXML.append("</entry>");
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        HttpConHandler http = new HttpConHandler();
        Response res = http.doConnect(this.workSheetURL, 162, httpHeaders, listRecordXML.toString());
        if (res.isError()) {
            Log.p(this.TAG, "Error in updating List Row...");
            return null;
        }
        ParseFeed pf = new ParseFeed();
        String xmlOut = res.getOutput();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        if (entries == null || entries.size() == 0) {
            Log.p(this.TAG, "Error in parsing...");
            return null;
        }
        Entry e = entries.get(0);
        WorkSheetRow row = new WorkSheetRow();
        row.setId(e.getId());
        row.setCells(e.getCells());
        if (this.records == null) {
            this.records = new ArrayList();
            this.records.add(row);
            return row;
        }
        this.records.add(row);
        return row;
    }

    public void deleteListRow(String key, WorkSheetRow r) {
        if (r == null) {
            Log.p(this.TAG, "WorkSheetRow is null...");
            return;
        }
        String listRowURL = "https://spreadsheets.google.com/feeds/list/" + key + "/" + this.workSheetID + "/private/full/" + r.getRowIndex();
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("If-Match", "*");
        HttpConHandler http = new HttpConHandler();
        http.doConnect(listRowURL, 163, httpHeaders, null);
        this.records.remove(r);
    }

    public WorkSheetRow updateListRow(String key, WorkSheetRow r, HashMap<String, String> records) {
        if (r == null) {
            Log.p(this.TAG, "WorkSheetRow is null...");
            return r;
        }
        String listRowURL = "https://spreadsheets.google.com/feeds/list/" + key + "/" + this.workSheetID + "/private/full/" + r.getRowIndex();
        StringBuffer rowUpdateXML = new StringBuffer("<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:gsx=\"http://schemas.google.com/spreadsheets/2006/extended\">");
        for (String colName : records.keySet()) {
            String value = records.get(colName);
            rowUpdateXML.append(" <gsx:" + colName + ">" + value + "</gsx:" + colName + ">");
        }
        rowUpdateXML.append("</entry>");
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        httpHeaders.put("If-Match", "*");
        HttpConHandler http = new HttpConHandler();
        Response res = http.doConnect(listRowURL, 164, httpHeaders, rowUpdateXML.toString());
        if (res.isError()) {
            Log.p(this.TAG, "Error in updating List Row...");
            return null;
        }
        ParseFeed pf = new ParseFeed();
        String xmlOut = res.getOutput();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        if (entries == null || entries.size() == 0) {
            Log.p(this.TAG, "Error in parsing...");
            return null;
        }
        Entry e = entries.get(0);
        WorkSheetRow row = new WorkSheetRow();
        row.setId(e.getId());
        row.setCells(e.getCells());
        if (this.records == null) {
            this.records = new ArrayList();
            this.records.add(row);
            return row;
        }
        this.records.set(this.records.indexOf(row), row);
        return row;
    }

    public void addRecord(String key, HashMap<String, String> records) {
        if (this.table == null) {
            throw new IllegalAccessError("This WorkSheet doesn't have any Table");
        }
        Log.p(this.TAG, "Associated Table ID: " + this.table.getId());
        String tableRecordURL = "https://spreadsheets.google.com/feeds/" + key + "/records/" + this.table.getId();
        String tableRecordXML = "<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gs='http://schemas.google.com/spreadsheets/2006'><title>" + this.table.getName() + "</title>";
        Set<String> keys = records.keySet();
        for (String k : keys) {
            tableRecordXML = tableRecordXML.concat("<gs:field name='" + k + "'>" + records.get(k) + "</gs:field>");
        }
        tableRecordXML = tableRecordXML.concat("</entry>");
        Log.p(this.TAG, "Table Record XML: " + tableRecordXML);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        HttpConHandler http = new HttpConHandler();
        http.doConnect(tableRecordURL, 162, httpHeaders, tableRecordXML);
    }

    public ArrayList<Record> getRecords(String key) {
        return this.getRecords(key, false, null, null);
    }

    public ArrayList<Record> getRecords(String key, String sq) {
        return this.getRecords(key, false, sq, null);
    }

    public ArrayList<Record> getRecords(String key, boolean doReverse, String sq, String orderBy) {
        if (this.table == null) {
            Log.p(this.TAG, "No Associated Table to Hold Data!!");
            return null;
        }
        String tableRecordURL = "https://spreadsheets.google.com/feeds/" + key + "/records/" + this.table.getId();
        if (doReverse) {
            tableRecordURL = tableRecordURL.concat("?reverse=true");
            if (sq != null) {
                tableRecordURL = tableRecordURL.concat("&sq=" + sq);
            }
            if (orderBy != null) {
                tableRecordURL = tableRecordURL.concat("&orderby=" + orderBy);
            }
        } else if (sq != null) {
            tableRecordURL = tableRecordURL.concat("?sq=" + sq);
            if (orderBy != null) {
                tableRecordURL = tableRecordURL.concat("&orderby=" + orderBy);
            }
        } else if (orderBy != null) {
            tableRecordURL = tableRecordURL.concat("?orderby=" + orderBy);
        }
        Log.p(this.TAG, "tableRecordURL=" + tableRecordURL);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        Response res = http.doConnect(tableRecordURL, 161, httpHeaders, null);
        if (res.isError()) {
            return null;
        }
        ParseFeed pf = new ParseFeed();
        String xmlOut = res.getOutput();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        if (entries == null) {
            Log.p(this.TAG, "No Reord found!!");
            return null;
        }
        this.table.clearData();
        int i = 0;
        while (i < entries.size()) {
            Entry e = entries.get(i);
            ArrayList<Field> fields = e.getFields();
            Record r = new Record();
            r.setId(e.getId());
            r.setEditURL(e.getEditLink());
            int j = 0;
            while (j < fields.size()) {
                Field fd = fields.get(j);
                r.addData(fd.getColName(), fd.getValue());
                ++j;
            }
            this.table.addRecord(r);
            ++i;
        }
        return this.table.getRecords();
    }

    public ArrayList<Record> getRecords() {
        return this.table.getRecords();
    }

    public void updateRecord(Record record) {
        if (record == null) {
            throw new IllegalAccessError("Pass a valid Record!!");
        }
        String recordXML = "<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gs='http://schemas.google.com/spreadsheets/2006'><id>" + record.getId() + "</id>";
        HashMap<String, String> data = record.getData();
        Set<String> keys = data.keySet();
        for (String k : keys) {
            recordXML = recordXML.concat("<gs:field name='" + k + "'>" + data.get(k) + "</gs:field>");
        }
        recordXML = String.valueOf(recordXML) + "</entry>";
        Log.p(this.TAG, "Update Record XML: " + recordXML);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        httpHeaders.put("If-Match", "*");
        HttpConHandler http = new HttpConHandler();
        http.doConnect(record.getEditURL(), 164, httpHeaders, recordXML);
    }

    public void deleteRecord(Record record) {
        if (record == null) {
            throw new IllegalAccessError("Pass a valid Record!!");
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("If-Match", "*");
        HttpConHandler http = new HttpConHandler();
        http.doConnect(record.getEditURL(), 163, httpHeaders, null);
    }

    public void delete() {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("If-Match", "*");
        HttpConHandler http = new HttpConHandler();
        String wsDeleteURL = this.entry.getId().substring(0, this.entry.getId().lastIndexOf("/"));
        wsDeleteURL = wsDeleteURL.concat("/private/full/").concat(this.workSheetID);
        http.doConnect(wsDeleteURL, 163, httpHeaders, null);
    }
}

