/*
 * Decompiled with CFR 0.152.
 */
package com.pras;

import com.pras.Collaborator;
import com.pras.Log;
import com.pras.SpreadSheet;
import com.pras.auth.Account;
import com.pras.auth.Authenticator;
import com.pras.auth.BasicAuthenticatorImpl;
import com.pras.conn.HttpConHandler;
import com.pras.conn.Response;
import com.pras.sp.Entry;
import com.pras.sp.Feed;
import com.pras.sp.ParseFeed;
import java.util.ArrayList;
import java.util.HashMap;

public class SpreadSheetFactory {
    private String TAG = "SpreadSheetFactory";
    public static String authToken;
    private final String SP_GET_LIST_URL = "https://spreadsheets.google.com/feeds/spreadsheets/private/full";
    private final String DOCUMENT_LIST_API_URL = "https://docs.google.com/feeds/default/private/full";
    static final String SPREADSHEET_API_SERVICE_NAME = "wise";
    static final String DOCUMENT_LIST_API_SERVICE_NAME = "writely";
    private ArrayList<SpreadSheet> spreadSheets = new ArrayList();
    private Authenticator authenticator = null;
    private static SpreadSheetFactory factory;

    public static SpreadSheetFactory getInstance() {
        return SpreadSheetFactory.getInstance(null, null);
    }

    public static SpreadSheetFactory getInstance(String email, String password) {
        if (factory == null) {
            if (email != null && password != null) {
                Account account = new Account();
                account.setEmail(email);
                account.setPassword(password);
                BasicAuthenticatorImpl basicAuth = new BasicAuthenticatorImpl(account);
                factory = new SpreadSheetFactory(basicAuth);
            } else {
                throw new IllegalAccessError("Missing Account Info. Please use getInstance(String email, String password) or getInstance(Authenticator authenticator)");
            }
        }
        return factory;
    }

    public static SpreadSheetFactory getInstance(Authenticator authenticator) {
        if (authenticator == null) {
            throw new IllegalAccessError("No Authenticator defined");
        }
        if (factory == null) {
            factory = new SpreadSheetFactory(authenticator);
        }
        return factory;
    }

    private SpreadSheetFactory(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void flushMe() {
        factory = null;
        if (this.spreadSheets != null) {
            this.spreadSheets.clear();
        }
        this.spreadSheets = null;
        authToken = null;
        this.authenticator = null;
    }

    public void createSpreadSheet(String spName) {
        this.login(DOCUMENT_LIST_API_SERVICE_NAME);
        String postData = "<?xml version='1.0' encoding='UTF-8'?><entry xmlns='http://www.w3.org/2005/Atom'><category scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/docs/2007#spreadsheet'/><title>" + spName + "</title>" + "</entry>";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Length", "" + postData.length());
        httpHeaders.put("Content-Type", "application/atom+xml");
        HttpConHandler http = new HttpConHandler();
        http.doConnect("https://docs.google.com/feeds/default/private/full", 162, httpHeaders, postData);
        this.login(SPREADSHEET_API_SERVICE_NAME);
    }

    public void deleteSpreadSheet(String resID) {
        this.login(DOCUMENT_LIST_API_SERVICE_NAME);
        String url = "https://docs.google.com/feeds/default/private/full/" + resID + "?delete=true";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("If-Match", "*");
        HttpConHandler http = new HttpConHandler();
        Response res = http.doConnect(url, 163, httpHeaders, null);
        if (!res.isError()) {
            int i = 0;
            while (i < this.spreadSheets.size()) {
                if (this.spreadSheets.get(0).getEntry().getResID() == resID) {
                    this.spreadSheets.remove(i);
                }
                ++i;
            }
        }
        this.login(SPREADSHEET_API_SERVICE_NAME);
    }

    public ArrayList<SpreadSheet> getSpreadSheet(String title, boolean isTitleExact) {
        return this.getAllSpreadSheets(true, title, isTitleExact);
    }

    public ArrayList<SpreadSheet> getAllSpreadSheets() {
        return this.getAllSpreadSheets(true);
    }

    public ArrayList<SpreadSheet> getAllSpreadSheets(boolean doRefresh) {
        return this.getAllSpreadSheets(doRefresh, null, false);
    }

    public ArrayList<SpreadSheet> getAllSpreadSheets(boolean doRefresh, String title, boolean isTitleExact) {
        if (!doRefresh) {
            return this.spreadSheets;
        }
        this.login(SPREADSHEET_API_SERVICE_NAME);
        String xmlOut = this.getSpreadSheetList(title, isTitleExact);
        if (xmlOut == null) {
            Log.p(this.TAG, "No SpreadSheet Feed received from Server!!");
            return null;
        }
        ParseFeed pf = new ParseFeed();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        if (entries == null) {
            return null;
        }
        this.spreadSheets.clear();
        int i = 0;
        while (i < entries.size()) {
            this.spreadSheets.add(new SpreadSheet(entries.get(i)));
            ++i;
        }
        return this.spreadSheets;
    }

    public void addSharePermission(SpreadSheet sp, Collaborator[] collaborators) {
        if (sp == null || collaborators == null || collaborators.length == 0) {
            throw new IllegalArgumentException("Please provide SpreadSheet ResID and Collaborator details to whom you want to share.");
        }
        this.login(DOCUMENT_LIST_API_SERVICE_NAME);
        String postData = "";
        int i = 0;
        while (i < collaborators.length) {
            Collaborator c = collaborators[i];
            postData = "<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gAcl='http://schemas.google.com/acl/2007'><category scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/acl/2007#accessRule'/><gAcl:role value='" + c.getRole() + "'/>" + "<gAcl:scope type='" + c.getScopeType() + "' value='" + c.getScopeValue() + "'/>" + "</entry>";
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("Authorization", "GoogleLogin auth=" + authToken);
            httpHeaders.put("GData-Version", "3.0");
            httpHeaders.put("Content-Type", "application/atom+xml");
            HttpConHandler http = new HttpConHandler();
            String url = "https://docs.google.com/feeds/default/private/full/" + sp.getResourceID() + "/acl";
            http.doConnect(url, 162, httpHeaders, postData);
            ++i;
        }
        this.login(SPREADSHEET_API_SERVICE_NAME);
    }

    public ArrayList<Collaborator> getAllCollaborators(SpreadSheet sp) {
        if (sp == null) {
            throw new IllegalArgumentException("Please provide SpreadSheet ResID and Emails to whom you want to share.");
        }
        this.login(DOCUMENT_LIST_API_SERVICE_NAME);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        String url = "https://docs.google.com/feeds/default/private/full/" + sp.getResourceID() + "/acl";
        Response res = http.doConnect(url, 161, httpHeaders, null);
        this.login(SPREADSHEET_API_SERVICE_NAME);
        String xmlOut = res.getOutput();
        if (xmlOut == null) {
            Log.p(this.TAG, "No XML feed from Server!!");
            return null;
        }
        ParseFeed pf = new ParseFeed();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        sp.clearCollaboratorList();
        if (entries != null) {
            System.out.println("Number of Collaborators: " + entries.size());
            int i = 0;
            while (i < entries.size()) {
                Entry e = entries.get(i);
                Collaborator c = new Collaborator();
                c.setEditLink(e.getEditLink());
                c.setScopeType(e.getAclScopeType());
                c.setScopeValue(e.getAclScopeValue());
                c.setRole(e.getAclRole());
                sp.addCollaborator(c);
                ++i;
            }
        }
        return sp.getCollaborators();
    }

    public void changeSharePermission(Collaborator c, String role) {
        this.login(DOCUMENT_LIST_API_SERVICE_NAME);
        if (c.getEditLink() == null) {
            throw new IllegalArgumentException("No EditLink URL defined in the Collaborator Instance");
        }
        String url = c.getEditLink();
        String postData = "<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gAcl='http://schemas.google.com/acl/2007'><category scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/acl/2007#accessRule'/><gAcl:role value='" + role + "'/>" + "<gAcl:scope type='" + c.getScopeType() + "' value='" + c.getScopeValue() + "'/>" + "</entry>";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        HttpConHandler http = new HttpConHandler();
        http.doConnect(url, 164, httpHeaders, postData);
        this.login(SPREADSHEET_API_SERVICE_NAME);
    }

    public void removeSharePermission(Collaborator c) {
        this.login(DOCUMENT_LIST_API_SERVICE_NAME);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        String url = c.getEditLink();
        http.doConnect(url, 163, httpHeaders, null);
        this.login(SPREADSHEET_API_SERVICE_NAME);
    }

    private void login(String service) {
        Log.p(this.TAG, "New Auth...");
        authToken = this.authenticator.getAuthToken(service);
    }

    private String getSpreadSheetList(String title, boolean isTitleExact) {
        Response res;
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        String url = "https://spreadsheets.google.com/feeds/spreadsheets/private/full";
        if (title != null) {
            url = url.concat("?title=" + HttpConHandler.encode(title));
            url = url.concat("&title-exact=" + isTitleExact);
        }
        if ((res = http.doConnect(url, 161, httpHeaders, null)).isError()) {
            return null;
        }
        return res.getOutput();
    }
}

