/*
 * Decompiled with CFR 0.152.
 */
package com.pras;

import com.pras.Collaborator;
import com.pras.Log;
import com.pras.SpreadSheetFactory;
import com.pras.WorkSheet;
import com.pras.WorkSheetCell;
import com.pras.conn.HttpConHandler;
import com.pras.conn.Response;
import com.pras.sp.Entry;
import com.pras.sp.Feed;
import com.pras.sp.ParseFeed;
import com.pras.table.Table;
import java.util.ArrayList;
import java.util.HashMap;

public class SpreadSheet {
    private String TAG = "SpreadSheet";
    Entry entry;
    ArrayList<WorkSheet> wks = new ArrayList();
    ArrayList<Collaborator> collaborators = new ArrayList();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof SpreadSheet) {
            SpreadSheet s = (SpreadSheet)obj;
            if (this.hashCode() == s.hashCode()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.entry != null) {
            return this.entry.getResID().hashCode();
        }
        return super.hashCode();
    }

    public SpreadSheet(Entry entry) {
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public String getTitle() {
        if (this.entry != null) {
            return this.entry.getTitle();
        }
        return null;
    }

    public String getResourceID() {
        if (this.entry != null) {
            return this.entry.getResID();
        }
        return null;
    }

    public String getKey() {
        if (this.entry != null) {
            return this.entry.getKey();
        }
        return null;
    }

    public ArrayList<Collaborator> getCollaborators() {
        return this.collaborators;
    }

    public void addCollaborator(Collaborator c) {
        this.collaborators.add(c);
    }

    public void clearCollaboratorList() {
        this.collaborators.clear();
    }

    public void setCollaborators(ArrayList<Collaborator> collaborators) {
        this.collaborators = collaborators;
    }

    public void addWorkSheet(String name) {
        if (name == null) {
            throw new IllegalAccessError("Please provide WorkSheet Name");
        }
        this.addWorkSheet(name, 1, 1);
    }

    private WorkSheet addWorkSheet(String name, int col, int row) {
        String workSheetURL = "https://spreadsheets.google.com/feeds/worksheets/" + this.entry.getKey() + "/private/full";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        String postData = "<entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:gs=\"http://schemas.google.com/spreadsheets/2006\"><title>" + name + "</title>" + "<gs:rowCount>" + row + "</gs:rowCount>" + "<gs:colCount>" + col + "</gs:colCount>" + "</entry>";
        Log.p(this.TAG, "POST Data- " + postData);
        HttpConHandler http = new HttpConHandler();
        Response resp = http.doConnect(workSheetURL, 162, httpHeaders, postData);
        if (resp == null) {
            return null;
        }
        return this.parseWorkSheet(resp.getOutput());
    }

    private WorkSheet parseWorkSheet(String xmlFeed) {
        if (xmlFeed == null) {
            return null;
        }
        ParseFeed pf = new ParseFeed();
        Feed f = pf.parse(xmlFeed.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        if (entries == null || entries.size() == 0) {
            return null;
        }
        WorkSheet ws = new WorkSheet();
        int i = 0;
        while (i < entries.size()) {
            Entry e = entries.get(i);
            ws.setWorkSheetID(e.getKey());
            ws.setWorkSheetURL(e.getWorkSheetURL());
            ws.setTitle(e.getTitle());
            ws.setColCount(e.getColCount());
            ws.setRowCount(e.getRowCount());
            ws.setEntry(e);
            ++i;
        }
        return ws;
    }

    public void addWorkSheet(String name, String[] cols) {
        if (cols == null || cols.length == 0) {
            throw new IllegalAccessError("Please provide column name");
        }
        this.addWorkSheet(name, name, 2, cols);
    }

    public void addWorkSheet(String name, String description, int row, String[] cols) {
        if (name == null || description == null || cols == null) {
            throw new IllegalAccessError("Please provide correct input parameters");
        }
        int col = cols.length;
        this.addWorkSheet(name, col, row);
        String tableCreateXML = "<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gs='http://schemas.google.com/spreadsheets/2006'><title type='text'>" + name + "</title>" + "<summary type='text'>" + description + "</summary>" + "<gs:worksheet name='" + name + "'/>" + "<gs:header row='1' />" + "<gs:data numRows='0' startRow='2'>";
        int i = 0;
        while (i < cols.length) {
            tableCreateXML = tableCreateXML.concat("<gs:column index='" + (i + 1) + "' name='" + cols[i] + "' />");
            ++i;
        }
        tableCreateXML = tableCreateXML.concat("</gs:data></entry>");
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        String tableURL = "https://spreadsheets.google.com/feeds/" + this.entry.getKey() + "/tables";
        HttpConHandler http = new HttpConHandler();
        http.doConnect(tableURL, 162, httpHeaders, tableCreateXML);
    }

    public WorkSheet addListWorkSheet(String name, int rowCount, String[] cols) {
        if (name == null || cols == null) {
            throw new IllegalAccessError("Please provide correct input parameters");
        }
        Log.p(this.TAG, "## Create WorkSheet...");
        WorkSheet workSheet = this.addWorkSheet(name, cols.length, rowCount);
        if (workSheet == null) {
            return null;
        }
        workSheet.setColumns(cols);
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        httpHeaders.put("Content-Type", "application/atom+xml");
        httpHeaders.put("If-Match", "*");
        StringBuffer cellUpdateXML = new StringBuffer();
        cellUpdateXML.append("<feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:batch=\"http://schemas.google.com/gdata/batch\" xmlns:gs=\"http://schemas.google.com/spreadsheets/2006\">");
        cellUpdateXML.append("<id>https://spreadsheets.google.com/feeds/cells/" + this.entry.getKey() + "/" + workSheet.getWorkSheetID() + "/private/full</id>");
        int i = 0;
        while (i < cols.length) {
            cellUpdateXML.append("<entry>");
            cellUpdateXML.append("<batch:id>B" + i + "</batch:id>");
            cellUpdateXML.append("<batch:operation type=\"update\"/>");
            cellUpdateXML.append("<id>https://spreadsheets.google.com/feeds/cells/" + this.entry.getKey() + "/" + workSheet.getWorkSheetID() + "/private/full/R1C" + (i + 1) + "</id>");
            cellUpdateXML.append("<link rel=\"edit\" type=\"application/atom+xml\"");
            cellUpdateXML.append(" href=\"https://spreadsheets.google.com/feeds/cells/" + this.entry.getKey() + "/" + workSheet.getWorkSheetID() + "/private/full/R1C" + (i + 1) + "\"/>");
            cellUpdateXML.append("<gs:cell row=\"1\" col=\"" + (i + 1) + "\" inputValue=\"" + cols[i].toLowerCase() + "\"/>");
            cellUpdateXML.append("</entry>");
            ++i;
        }
        cellUpdateXML.append("</feed>");
        String headerRowUpdateUrl = "https://spreadsheets.google.com/feeds/cells/" + this.entry.getKey() + "/" + workSheet.getWorkSheetID() + "/private/full/batch";
        new HttpConHandler().doConnect(headerRowUpdateUrl, 162, httpHeaders, cellUpdateXML.toString());
        return workSheet;
    }

    public ArrayList<WorkSheet> getAllWorkSheets() {
        return this.getAllWorkSheets(true);
    }

    public ArrayList<WorkSheet> getAllWorkSheets(boolean doRefresh) {
        return this.getAllWorkSheets(doRefresh, null, false);
    }

    public ArrayList<WorkSheet> getWorkSheet(String title, boolean isTitleExact) {
        return this.getAllWorkSheets(true, title, isTitleExact);
    }

    public ArrayList<WorkSheet> getAllWorkSheets(boolean doRefresh, String title, boolean isTitleExact) {
        if (!doRefresh) {
            return this.wks;
        }
        String workSheetListURL = "https://spreadsheets.google.com/feeds/worksheets/" + this.entry.getKey() + "/private/full";
        if (title != null) {
            workSheetListURL = workSheetListURL.concat("?title=" + HttpConHandler.encode(title));
            workSheetListURL = workSheetListURL.concat("&title-exact=" + isTitleExact);
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        Response res = http.doConnect(workSheetListURL, 161, httpHeaders, null);
        if (res.isError()) {
            return null;
        }
        String xmlOut = res.getOutput();
        ParseFeed pf = new ParseFeed();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        HashMap<String, Table> tables = null;
        if (entries == null || entries.size() <= 0) {
            return null;
        }
        Log.p(this.TAG, "Get Table Feed");
        tables = this.getTables(title, isTitleExact);
        this.wks.clear();
        int i = 0;
        while (i < entries.size()) {
            Entry e = entries.get(i);
            WorkSheet ws = new WorkSheet();
            ws.setWorkSheetID(e.getKey());
            ws.setWorkSheetURL(e.getWorkSheetURL());
            ws.setTitle(e.getTitle());
            ws.setColCount(e.getColCount());
            ws.setRowCount(e.getRowCount());
            ws.setEntry(e);
            if (tables != null) {
                Table table = tables.get(ws.getTitle());
                if (table != null) {
                    ws.setTable(tables.get(ws.getTitle()));
                } else {
                    ws.setColumns(this.readHeaderRow(ws.getWorkSheetID()));
                }
            }
            this.wks.add(ws);
            ++i;
        }
        return this.wks;
    }

    private String[] readHeaderRow(String workSheetID) {
        String headerRowURL = "https://spreadsheets.google.com/feeds/cells/" + this.entry.getKey() + "/" + workSheetID + "/private/full?min-row=1&max-row=1";
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        Response res = http.doConnect(headerRowURL, 161, httpHeaders, null);
        if (res.isError()) {
            return null;
        }
        ParseFeed pf = new ParseFeed();
        String xmlOut = res.getOutput();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        if (entries == null) {
            return null;
        }
        String[] cols = new String[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            Entry e = entries.get(i);
            WorkSheetCell cellInfo = e.getCellInfo();
            if (cellInfo != null) {
                cols[i] = cellInfo.getName();
            }
            ++i;
        }
        return cols;
    }

    private HashMap<String, Table> getTables(String title, boolean isTitleExact) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        String tableURL = "https://spreadsheets.google.com/feeds/" + this.entry.getKey() + "/tables";
        if (title != null) {
            tableURL = tableURL.concat("?title=" + HttpConHandler.encode(title));
            tableURL = tableURL.concat("&title-exact=" + isTitleExact);
        }
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        httpHeaders.put("Authorization", "GoogleLogin auth=" + SpreadSheetFactory.authToken);
        httpHeaders.put("GData-Version", "3.0");
        HttpConHandler http = new HttpConHandler();
        Response res = http.doConnect(tableURL, 161, httpHeaders, null);
        if (res.isError()) {
            return null;
        }
        ParseFeed pf = new ParseFeed();
        String xmlOut = res.getOutput();
        Feed f = pf.parse(xmlOut.getBytes());
        ArrayList<Entry> entries = f.getEntries();
        if (entries == null) {
            return null;
        }
        int i = 0;
        while (i < entries.size()) {
            Entry e = entries.get(i);
            Table t = new Table();
            t.setId(e.getKey());
            t.setName(e.getTitle());
            t.setDescription(e.getSummary());
            t.setCols(e.getCols());
            t.setUrl("https://spreadsheets.google.com/feeds/" + this.entry.getKey() + "/tables/" + t.getId());
            Log.p(this.TAG, "Table Name: " + t.getName());
            Log.p(this.TAG, "Table ID: " + t.getId());
            Log.p(this.TAG, "Table URL: " + t.getUrl());
            Log.p(this.TAG, "Number of Cols: " + t.getCols().size());
            tables.put(e.getTitle(), t);
            ++i;
        }
        return tables;
    }

    public void deleteWorkSheet(WorkSheet wk) {
        if (wk != null) {
            wk.delete();
        }
        this.wks.remove(wk);
    }
}

