/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util.raf;

import com.hughes.util.raf.RAFList;
import com.hughes.util.raf.RAFSerializer;
import com.hughes.util.raf.UniformRAFList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class UniformRAFListTest
extends TestCase {
    public void testFileList() throws IOException {
        RAFSerializer<String> serializer = RAFSerializer.STRING;
        File file = File.createTempFile("asdf", "asdf");
        file.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.writeUTF("Hello World!");
        List<String> l1 = Arrays.asList("1aaa", "1bca", "1def");
        List<String> l2 = Arrays.asList("2aabc", "2abcd", "2adef");
        UniformRAFList.write(raf, l1, serializer, 6);
        UniformRAFList.write(raf, l2, serializer, 7);
        raf.writeUTF("Goodbye World!");
        raf.seek(0L);
        UniformRAFListTest.assertEquals("Hello World!", raf.readUTF());
        UniformRAFList<String> l1Copy = UniformRAFList.create(raf, serializer, raf.getFilePointer());
        UniformRAFListTest.assertEquals(l1, l1Copy);
        UniformRAFList<String> l2Copy = UniformRAFList.create(raf, serializer, l1Copy.getEndOffset());
        UniformRAFListTest.assertEquals(l2, l2Copy);
        raf.seek(l2Copy.getEndOffset());
        UniformRAFListTest.assertEquals("Goodbye World!", raf.readUTF());
    }

    public void testEmptyList() throws IOException {
        File file = File.createTempFile("asdf", "asdf");
        file.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.writeUTF("Hello World!");
        List l1 = Collections.emptyList();
        RAFList.write(raf, l1, RAFSerializer.STRING);
        raf.writeUTF("Goodbye World!");
        raf.seek(0L);
        UniformRAFListTest.assertEquals("Hello World!", raf.readUTF());
        RAFList<String> l1Copy = RAFList.create(raf, RAFSerializer.STRING, raf.getFilePointer());
        UniformRAFListTest.assertEquals(l1, l1Copy);
        raf.seek(l1Copy.getEndOffset());
        UniformRAFListTest.assertEquals("Goodbye World!", raf.readUTF());
    }
}

