/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util.raf;

import com.hughes.util.raf.RAFList;
import com.hughes.util.raf.RAFListSerializer;
import com.hughes.util.raf.RAFSerializer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;

public class UniformRAFList<T>
extends AbstractList<T>
implements RandomAccess {
    final RandomAccessFile raf;
    final RAFListSerializer<T> serializer;
    final int size;
    final int datumSize;
    final long dataStart;
    final long endOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniformRAFList(RandomAccessFile raf, RAFListSerializer<T> serializer, long startOffset) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            this.raf = raf;
            this.serializer = serializer;
            raf.seek(startOffset);
            this.size = raf.readInt();
            this.datumSize = raf.readInt();
            this.dataStart = raf.getFilePointer();
            this.endOffset = this.dataStart + (long)(this.size * this.datumSize);
            raf.seek(this.endOffset);
        }
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException("" + i);
        }
        try {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.dataStart + (long)(i * this.datumSize));
                T result = this.serializer.read(this.raf, i);
                if (this.raf.getFilePointer() != this.dataStart + (long)((i + 1) * this.datumSize)) {
                    throw new RuntimeException("Read " + (this.raf.getFilePointer() - (this.dataStart + (long)(i * this.datumSize))) + " bytes, should have read " + this.datumSize);
                }
                return result;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public static <T> UniformRAFList<T> create(RandomAccessFile raf, RAFListSerializer<T> serializer, long startOffset) throws IOException {
        return new UniformRAFList<T>(raf, serializer, startOffset);
    }

    public static <T> UniformRAFList<T> create(RandomAccessFile raf, RAFSerializer<T> serializer, long startOffset) throws IOException {
        return new UniformRAFList<T>(raf, RAFList.getWrapper(serializer), startOffset);
    }

    public static <T> void write(RandomAccessFile raf, Collection<T> list, RAFListSerializer<T> serializer, int datumSize) throws IOException {
        raf.writeInt(list.size());
        raf.writeInt(datumSize);
        for (T t : list) {
            long startOffset = raf.getFilePointer();
            serializer.write(raf, t);
            if (raf.getFilePointer() == startOffset + (long)datumSize) continue;
            throw new RuntimeException("Wrote " + (raf.getFilePointer() - startOffset) + " bytes, should have written " + datumSize);
        }
    }

    public static <T> void write(RandomAccessFile raf, Collection<T> list, final RAFSerializer<T> serializer, int datumSize) throws IOException {
        UniformRAFList.write(raf, list, new RAFListSerializer<T>(){

            @Override
            public T read(RandomAccessFile raf, int readIndex) throws IOException {
                return serializer.read(raf);
            }

            @Override
            public void write(RandomAccessFile raf, T t) throws IOException {
                serializer.write(raf, t);
            }
        }, datumSize);
    }
}

