/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util.raf;

import com.hughes.util.raf.RAFSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class SerializableSerializer<T>
implements RAFSerializer<T> {
    @Override
    public void write(RandomAccessFile raf, T t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(t);
        oos.close();
        byte[] bytes = baos.toByteArray();
        raf.writeInt(bytes.length);
        raf.write(bytes);
    }

    @Override
    public T read(RandomAccessFile raf) throws IOException {
        Serializable result;
        int length = raf.readInt();
        byte[] bytes = new byte[length];
        raf.read(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            result = (Serializable)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ois.close();
        return (T)result;
    }
}

