/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util.raf;

import com.hughes.util.raf.RAFSerializable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;

public interface RAFSerializer<T> {
    public static final RAFSerializer<String> STRING = new RAFSerializer<String>(){

        @Override
        public void write(RandomAccessFile raf, String t) throws IOException {
            raf.writeUTF(t);
        }

        @Override
        public String read(RandomAccessFile raf) throws IOException {
            return raf.readUTF();
        }
    };

    public void write(RandomAccessFile var1, T var2) throws IOException;

    public T read(RandomAccessFile var1) throws IOException;

    public static final class RAFSerializableSerializer<T extends RAFSerializable<T>>
    implements RAFSerializer<T> {
        private final Constructor<T> constructor;

        public RAFSerializableSerializer(Class<T> clazz) {
            try {
                this.constructor = clazz.getConstructor(RandomAccessFile.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(RandomAccessFile raf, T t) throws IOException {
            t.write(raf);
        }

        @Override
        public T read(RandomAccessFile raf) throws IOException {
            try {
                return (T)((RAFSerializable)this.constructor.newInstance(raf));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

