/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util.raf;

import com.hughes.util.raf.RAFList;
import com.hughes.util.raf.RAFSerializer;
import com.hughes.util.raf.SerializableSerializer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class RAFListTest
extends TestCase {
    public void testFileListString() throws IOException {
        this.testFileList(RAFSerializer.STRING);
    }

    public void testFileListSerializable() throws IOException {
        this.testFileList(new SerializableSerializer<String>());
    }

    public void testFileList(RAFSerializer<String> serializer) throws IOException {
        File file = File.createTempFile("asdf", "asdf");
        file.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.writeUTF("Hello World!");
        List<String> l1 = Arrays.asList("1a", "1bc", "1def");
        List<String> l2 = Arrays.asList("2aa", "2abc", "2adef");
        RAFList.write(raf, l1, serializer);
        RAFList.write(raf, l2, serializer);
        raf.writeUTF("Goodbye World!");
        raf.seek(0L);
        RAFListTest.assertEquals("Hello World!", raf.readUTF());
        RAFList<String> l1Copy = RAFList.create(raf, serializer, raf.getFilePointer());
        RAFListTest.assertEquals(l1, l1Copy);
        RAFList<String> l2Copy = RAFList.create(raf, serializer, l1Copy.getEndOffset());
        RAFListTest.assertEquals(l2, l2Copy);
        raf.seek(l2Copy.getEndOffset());
        RAFListTest.assertEquals("Goodbye World!", raf.readUTF());
    }

    public void testEmptyList() throws IOException {
        File file = File.createTempFile("asdf", "asdf");
        file.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.writeUTF("Hello World!");
        List l1 = Collections.emptyList();
        RAFList.write(raf, l1, RAFSerializer.STRING);
        raf.writeUTF("Goodbye World!");
        raf.seek(0L);
        RAFListTest.assertEquals("Hello World!", raf.readUTF());
        RAFList<String> l1Copy = RAFList.create(raf, RAFSerializer.STRING, raf.getFilePointer());
        RAFListTest.assertEquals(l1, l1Copy);
        raf.seek(l1Copy.getEndOffset());
        RAFListTest.assertEquals("Goodbye World!", raf.readUTF());
    }
}

