/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util.raf;

import com.hughes.util.raf.RAFSerializer;
import java.io.IOException;
import java.io.RandomAccessFile;

public interface RAFListSerializer<T> {
    public void write(RandomAccessFile var1, T var2) throws IOException;

    public T read(RandomAccessFile var1, int var2) throws IOException;

    public static final class Wrapper<T>
    implements RAFListSerializer<T> {
        private final RAFSerializer<T> serializer;

        public Wrapper(RAFSerializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        public T read(RandomAccessFile raf, int readIndex) throws IOException {
            return this.serializer.read(raf);
        }

        @Override
        public void write(RandomAccessFile raf, T t) throws IOException {
            this.serializer.write(raf, t);
        }
    }
}

