/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util.raf;

import com.hughes.util.raf.RAFListSerializer;
import com.hughes.util.raf.RAFSerializer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;

public class RAFList<T>
extends AbstractList<T>
implements RandomAccess {
    private static final int LONG_BYTES = 8;
    final RandomAccessFile raf;
    final RAFListSerializer<T> serializer;
    final long tocOffset;
    final int size;
    final long endOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAFList(RandomAccessFile raf, RAFListSerializer<T> serializer, long startOffset) throws IOException {
        RandomAccessFile randomAccessFile = raf;
        synchronized (randomAccessFile) {
            this.raf = raf;
            this.serializer = serializer;
            raf.seek(startOffset);
            this.size = raf.readInt();
            this.tocOffset = raf.getFilePointer();
            raf.seek(this.tocOffset + (long)(this.size * 8));
            this.endOffset = raf.readLong();
            raf.seek(this.endOffset);
        }
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(i) + ", size=" + this.size);
        }
        try {
            RandomAccessFile randomAccessFile = this.raf;
            synchronized (randomAccessFile) {
                this.raf.seek(this.tocOffset + (long)(i * 8));
                long start = this.raf.readLong();
                this.raf.seek(start);
                return this.serializer.read(this.raf, i);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public static <T> RAFList<T> create(RandomAccessFile raf, RAFListSerializer<T> serializer, long startOffset) throws IOException {
        return new RAFList<T>(raf, serializer, startOffset);
    }

    public static <T> RAFList<T> create(RandomAccessFile raf, RAFSerializer<T> serializer, long startOffset) throws IOException {
        return new RAFList<T>(raf, RAFList.getWrapper(serializer), startOffset);
    }

    public static <T> void write(RandomAccessFile raf, Collection<T> list, RAFListSerializer<T> serializer) throws IOException {
        raf.writeInt(list.size());
        long tocPos = raf.getFilePointer();
        raf.seek(tocPos + (long)(8 * (list.size() + 1)));
        int i = 0;
        long dataStart = raf.getFilePointer();
        for (T t : list) {
            long startOffset = raf.getFilePointer();
            raf.seek(tocPos);
            raf.writeLong(startOffset);
            tocPos = raf.getFilePointer();
            raf.seek(startOffset);
            serializer.write(raf, t);
            ++i;
        }
        long endOffset = raf.getFilePointer();
        raf.seek(tocPos);
        raf.writeLong(endOffset);
        assert (dataStart == raf.getFilePointer());
        raf.seek(endOffset);
    }

    public static <T> void write(RandomAccessFile raf, Collection<T> list, RAFSerializer<T> serializer) throws IOException {
        RAFList.write(raf, list, RAFList.getWrapper(serializer));
    }

    public static <T> RAFListSerializer<T> getWrapper(RAFSerializer<T> serializer) {
        return new RAFListSerializer.Wrapper<T>(serializer);
    }
}

