/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util;

import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;

public class TransformingList<T1, T2>
extends AbstractList<T2>
implements RandomAccess {
    private final List<T1> list;
    private final Transformer<T1, T2> transformer;

    public TransformingList(List<T1> list, Transformer<T1, T2> transformer) {
        this.list = list;
        this.transformer = transformer;
    }

    public static <T1, T2> TransformingList<T1, T2> create(List<T1> list, Transformer<T1, T2> transformer) {
        return new TransformingList<T1, T2>(list, transformer);
    }

    @Override
    public T2 get(int i) {
        return this.transformer.transform(this.list.get(i));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public static interface Transformer<T1, T2> {
        public T2 transform(T1 var1);
    }
}

