/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util;

import com.hughes.util.StringUtil;
import java.io.IOException;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class StringUtilTest
extends TestCase {
    public void testRemove() {
        StringBuilder sb = new StringBuilder("a<!--asdfasdf-->b<!---> -->c<!---->d");
        StringUtilTest.assertEquals("<!--asdfasdf-->", StringUtil.remove(sb, Pattern.compile("<!--", 16), Pattern.compile("-->", 16), true));
        StringUtilTest.assertEquals("ab<!---> -->c<!---->d", sb.toString());
        StringUtilTest.assertEquals("<!---> -->", StringUtil.remove(sb, Pattern.compile("<!--", 16), Pattern.compile("-->", 16), true));
        StringUtilTest.assertEquals("<!---->", StringUtil.remove(sb, Pattern.compile("<!--", 16), Pattern.compile("-->", 16), true));
        sb = new StringBuilder("a<!--asdfasdf-->b<!---> -->c<!---->d");
        StringUtilTest.assertEquals("abcd", StringUtil.removeAll(sb, Pattern.compile("<!--", 16), Pattern.compile("-->", 16)).toString());
    }

    public void testZip() throws IOException {
        String in = "abcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcdabcd";
        byte[] inBytes = in.getBytes();
        byte[] zipBytes = StringUtil.zipBytes(inBytes);
        System.out.println("zipped " + inBytes.length + " bytes to " + zipBytes.length + " bytes.");
        assert (zipBytes.length < inBytes.length);
        byte[] unzipBytes = new byte[inBytes.length];
        StringUtil.unzipFully(zipBytes, unzipBytes);
        String out = new String(unzipBytes);
        StringUtilTest.assertEquals(in, out);
    }

    public void testURLs() {
        String s = "asdf< >a%b%c<->asdf";
        String url = "asdf%3C+%3Ea%25b%25c%3C-%3Easdf";
        StringUtilTest.assertEquals("asdf%3C+%3Ea%25b%25c%3C-%3Easdf", StringUtil.encodeForUrl("asdf< >a%b%c<->asdf"));
        StringUtilTest.assertEquals("asdf< >a%b%c<->asdf", StringUtil.decodeFromUrl("asdf%3C+%3Ea%25b%25c%3C-%3Easdf"));
        s = "r\u00f6ten";
        url = "r%C3%B6ten";
        StringUtilTest.assertEquals("r%C3%B6ten", StringUtil.encodeForUrl("r\u00f6ten"));
        StringUtilTest.assertEquals("r\u00f6ten", StringUtil.decodeFromUrl("r%C3%B6ten"));
        s = "%";
        url = "%25";
        StringUtilTest.assertEquals("%25", StringUtil.encodeForUrl("%"));
        StringUtilTest.assertEquals("%", StringUtil.decodeFromUrl("%25"));
    }
}

