/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class StringUtil {
    static final Pattern WHITESPACE = Pattern.compile("\\s+");
    public static final Pattern ALL_ASCII = Pattern.compile("[\\p{ASCII}]*");
    public static final Charset UTF8 = Charset.forName("UTF8");

    public static String normalizeWhitespace(String s) {
        return WHITESPACE.matcher(s.trim()).replaceAll(" ");
    }

    public static String reverse(String s) {
        StringBuilder builder = new StringBuilder(s);
        int i = 0;
        while (i < s.length()) {
            builder.setCharAt(i, s.charAt(s.length() - 1 - i));
            ++i;
        }
        return builder.toString();
    }

    public static String flipCase(String s) {
        StringBuilder builder = new StringBuilder(s);
        int i = 0;
        while (i < s.length()) {
            char c = builder.charAt(i);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            builder.setCharAt(i, c);
            ++i;
        }
        return builder.toString();
    }

    public static String longestCommonSubstring(String s1, String s2) {
        int i = 0;
        while (i < s1.length() && i < s2.length()) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return s1.substring(0, i);
            }
            ++i;
        }
        return s1.length() < s2.length() ? s1 : s2;
    }

    public static String remove(StringBuilder s, Pattern start, Pattern end, boolean includeEnd) {
        Matcher startMatcher = start.matcher(s);
        if (!startMatcher.find()) {
            return null;
        }
        int startIndex = startMatcher.start();
        Matcher endMatcher = end.matcher(s);
        endMatcher.region(startMatcher.end(), s.length());
        int endIndex = endMatcher.find() ? (includeEnd ? endMatcher.end() : endMatcher.start()) : s.length();
        String result = s.substring(startIndex, endIndex);
        s.replace(startIndex, endIndex, "");
        return result;
    }

    public static StringBuilder removeAll(StringBuilder s, Pattern start, Pattern end) {
        while (StringUtil.remove(s, start, end, true) != null) {
        }
        return s;
    }

    public static StringBuilder appendLine(StringBuilder s, CharSequence line) {
        if (s.length() > 0) {
            s.append("\n");
        }
        s.append(line);
        return s;
    }

    public static int nestedIndexOf(String s, int startPos, String open, String close) {
        int depth = 0;
        int i = startPos;
        while (i < s.length()) {
            if (s.startsWith(close, i)) {
                if (depth == 0) {
                    return i;
                }
                --depth;
                i += close.length();
                continue;
            }
            if (s.startsWith(open, i)) {
                ++depth;
                i += open.length();
                continue;
            }
            ++i;
        }
        return -1;
    }

    public static int safeIndexOf(String s, String search) {
        int i = s.indexOf(search);
        if (i == -1) {
            return s.length();
        }
        return i;
    }

    public static String readToString(InputStream inputStream) {
        return new Scanner(inputStream).useDelimiter("\\A").next();
    }

    public static String escapeUnicodeToPureHtml(String s) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.codePointCount(0, s.length())) {
            int codePoint = s.codePointAt(i);
            if (codePoint == (char)codePoint && StringUtil.isLatinLetter((char)codePoint)) {
                result.append(Character.valueOf((char)codePoint));
            } else {
                result.append(String.format(String.format("&#x%x;", codePoint), new Object[0]));
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean isAscii(String s) {
        return ALL_ASCII.matcher(s).matches();
    }

    public static boolean isLatinLetter(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c >= 'a' && c <= 'z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isUnreservedUrlCharacter(char c) {
        if (StringUtil.isLatinLetter(c)) {
            return true;
        }
        if (StringUtil.isDigit(c)) {
            return true;
        }
        return c == '-' || c == '_' || c == '.' || c == '~';
    }

    public static String encodeForUrl(String s) {
        byte[] bytes;
        StringBuilder result = new StringBuilder();
        try {
            bytes = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        while (i < bytes.length) {
            if (StringUtil.isUnreservedUrlCharacter((char)bytes[i])) {
                result.append((char)bytes[i]);
            } else if (bytes[i] == 32) {
                result.append('+');
            } else {
                result.append(String.format("%%%02X", bytes[i]));
            }
            ++i;
        }
        return result.toString();
    }

    public static String decodeFromUrl(String s) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '%') {
                bytes.write(Integer.parseInt(s.substring(i + 1, i + 3), 16));
                i += 2;
            } else if (s.charAt(i) == '+') {
                bytes.write(32);
            } else {
                bytes.write(s.charAt(i));
            }
            ++i;
        }
        try {
            return bytes.toString("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final byte[] zipBytes(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(baos);
        out.write(bytes);
        out.close();
        return baos.toByteArray();
    }

    public static final void unzipFully(byte[] inBytes, byte[] outBytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(inBytes);
        GZIPInputStream in = new GZIPInputStream(bais);
        int numRead = 0;
        while ((numRead += in.read(outBytes, numRead, outBytes.length - numRead)) < outBytes.length) {
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.equals("");
    }
}

