/*
 * Decompiled with CFR 0.152.
 */
package com.hughes.util;

import java.util.List;

public final class ListUtil {
    public static final <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T get(List<T> list, int index, T defaultValue) {
        return index < list.size() ? list.get(index) : defaultValue;
    }

    public static <T> T get(List<T> list, int index) {
        return ListUtil.get(list, index, null);
    }

    public static <T> T remove(List<T> list, int index, T defaultValue) {
        return index < list.size() ? list.remove(index) : defaultValue;
    }

    public static final <T> void swap(List<T> list, int i1, int i2) {
        if (i1 == i2) {
            return;
        }
        T temp = list.get(i1);
        list.set(i1, list.get(i2));
        list.set(i2, temp);
    }

    public static final <T> T fastRemoveWithReorder(List<T> list, int index) {
        ListUtil.swap(list, index, list.size() - 1);
        return list.remove(list.size() - 1);
    }
}

